/*--------------------------------------------------------------------------+
$Id: MultiplexedOutputStream.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.io;

import java.io.IOException;
import java.io.OutputStream;

/**
 * This class enables multiplexing of output streams. It can be e.g. used to
 * output content to multiple files.
 * 
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 5DB2776C03CD4F1EF5CE43768985E2BD
 */
public class MultiplexedOutputStream extends OutputStream {

    /** The underlying output streams. */
    private final OutputStream[] streams;

    /**
     * Create new multiplexed output streams.
     * 
     * @param streams
     *            any number of output streams.
     */
    public MultiplexedOutputStream(OutputStream... streams) {
        this.streams = streams;
    }

    /**
     * Forwards close operation to all underlying output streams.
     */
    @Override
    public void close() throws IOException {
        for (OutputStream stream : streams) {
            stream.close();
        }
    }

    /**
     * Forwards flush operation to all underlying output streams.
     */
    @Override
    public void flush() throws IOException {
        for (OutputStream stream : streams) {
            stream.flush();
        }
    }

    /**
     * Forwards write operation to all underlying output streams.
     */
    @Override
	public void write(int b) throws IOException {
        for (OutputStream stream : streams) {
            stream.write(b);
        }

    }

}