/*--------------------------------------------------------------------------+
$Id: StateflowTarget.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.model.stateflow;

import edu.tum.cs.commons.assertion.CCSMPre;

/**
 * A Stateflow target object. Stateflow uses targets for generating C-Code which
 * is used for simulation.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: 566C516ECCBC04E1B2D75F840BC8769F
 */
public class StateflowTarget extends StateflowElementBase<StateflowMachine> {

	/** Create new target. */
	public StateflowTarget() {
		super();
	}

	/** Create new target from existing one (for deep cloning) */
	private StateflowTarget(StateflowTarget orig) {
		super(orig);
	}

	/** Remove this target from the model. */
	@Override
	public void remove() {
		CCSMPre.isFalse(getParent() == null,
				"Target has no parent to be removed from.");
		getParent().removeTarget(this);
	}

	/** Deep clone the target. */
	public StateflowTarget deepClone() {
		return new StateflowTarget(this);
	}

}