/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: GroupFactory.java,v 1.6 2005/06/15 23:42:59 pietschy Exp $
 */

package org.pietschy.command;

/**
 * This factory interface is used by the library when ever a new GroupCommand is required.
 * The factory can be configured by calling {@link CommandManager#setGroupFactory}.
 * @version $Revision: 1.6 $
 * @author andrewp
 */
public interface
GroupFactory
{
   /**
    * Creates a new anonymous group that uses the specified container.
    * @param commandManager the {@link CommandManager} the group is to use.
    * @return a new GroupCommand instance.
    */
   public CommandGroup
   createGroup(CommandManager commandManager);

   /**
    * Creates a new group with the specified Id that uses the specified container.
    * @param commandId the Id of the group
    * @param commandManager the {@link CommandManager} the group is to use.
    * @return a new GroupCommand instance.
    */
   public CommandGroup
   createGroup(CommandManager commandManager, String commandId);

    /**
    * Creates a new anonymous {@link ToggleCommandGroup exclusive group} that uses
    * the specified container.
    * @param commandManager the {@link CommandManager} the group is to use.
    * @return a new ToggleGroupCommand instance.
    */
   public ToggleCommandGroup
    createToggleGroup(CommandManager commandManager);

   /**
    * Creates a new {@link ToggleCommandGroup exclusive group} with the specified Id that uses
    * the specified container.
    * @param commandId the Id of the group
    * @param commandManager the {@link CommandManager} the group is to use.
    * @return a new ToggleGroupCommand instance.
    */
   public ToggleCommandGroup
   createToggleGroup(CommandManager commandManager, String commandId);
}
