package org.workingfrog.i18n.test;

import java.io.FileInputStream;
import java.io.FileNotFoundException; 
import java.io.InputStream;
import java.io.IOException; 

import java.util.Properties;

import org.workingfrog.i18n.util.PropertiesLoader;

class PropLoader {
    public static void main (String[] argv) {
        InputStream input = PropLoader.class.getResourceAsStream("/org/workingfrog/i18n/test/bundles/misc.properties");
	if (input == null) {
            System.out.println("misc.properties not found");
	} else {
            System.out.println("misc.properties found!");
	}

        String path = System.getProperty("user.dir")
            + System.getProperty("file.separator") + "default.properties";
	System.out.println(path);
	try {
            input = new FileInputStream(path);
	} catch (FileNotFoundException fnfe) {
            System.out.println("default.properties not at " + path);
	}

	if (input == null) {
            System.out.println("default.properties not found");
	} else {
            System.out.println("default.properties loaded");
	}

	Properties props = new Properties();
	try {
	    props.load(input);
	} catch (IOException ioe) {
            System.out.println("IOException");
	}
	System.out.println("manual load, bundles.path : " + props.getProperty("bundles.path"));

	PropertiesLoader.init();
	System.out.println("PropertiesLoader, bundles.path : " + PropertiesLoader.getBundlesPath());
	System.out.println("PropertiesLoader, log level : " + PropertiesLoader.getLogLevel());
    }
}
