// Generated by CoffeeScript 1.7.1
describe('bootbox.prompt', function () {
  'use strict';
  beforeEach(function () {
    window.bootbox = bootbox.init();
    this.find = function (selector) {
      return this.dialog.find(selector);
    };
    this.text = function (selector) {
      return this.find(selector).text();
    };
    return this.exists = function (selector) {
      return this.find(selector).length !== 0;
    };
  });

  // basic tests
  describe('basic usage tests', function () {
    describe('with one argument', function () {
      describe('where the argument is not an object', function () {
        beforeEach(function () {
          return this.create = function () {
            return bootbox.prompt('What is your name?');
          };
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('prompt requires a callback');
        });
      });


      describe('where the argument is an object', function () {
        beforeEach(function () {
          this.options = {};
          return this.create = (function (_this) {
            return function () {
              return _this.dialog = bootbox.prompt(_this.options);
            };
          })(this);
        });
        
        describe('with a title property', function () {
          beforeEach(function () {
            return this.options.title = 'What is your name?';
          });

          it('throws an error requiring a callback', function () {
            return expect(this.create).to.throw('prompt requires a callback');
          });
          
          describe('and a callback property', function () {
            describe('where the callback is not a function', function () {
              beforeEach(function () {
                return this.options.callback = 'Not a function';
              });
              return it('throws an error requiring a callback', function () {
                return expect(this.create).to.throw('prompt requires a callback');
              });
            });
          });
        });


        describe('with a callback function', function () {
          beforeEach(function () {
            return this.options.callback = function () {
              return true;
            };
          });
          return it('throws an error requiring a title', function () {
            return expect(this.create).to.throw('prompt requires a title');
          });
        });


        describe('with a title and a callback', function () {
          beforeEach(function () {
            var _this = this;
            this.options = {
              callback: function () {
                return true;
              },
              title: 'What is your name?'
            };
            
            return this.create = function() {
              _this.dialog = bootbox.prompt(_this.options);
            };
          });

          it('does not throw an error', function () {
            return expect(this.create).not.to.throw(Error);
          });
          it('creates a dialog object', function () {
            return expect(this.dialog).to.be.an('object');
          });
          it('applies the bootbox-prompt class to the dialog', function () {
            return expect(this.dialog.hasClass('bootbox-prompt')).to.be.true;
          });
          it('adds the correct button labels', function () {
            expect(this.dialog.find('.btn:first').text()).to.equal('Cancel');
            return expect(this.dialog.find('.btn:last').text()).to.equal('OK');
          });
          return it('adds the correct button classes', function () {
            expect(this.dialog.find('.btn:first').hasClass('btn-default')).to.be.true;
            expect(this.dialog.find('.btn:first').hasClass('btn-secondary')).to.be.true;
            expect(this.dialog.find('.btn:first').hasClass('bootbox-cancel')).to.be.true;
  
            expect(this.dialog.find('.btn:last').hasClass('btn-primary')).to.be.true;
            return expect(this.dialog.find('.btn:last').hasClass('bootbox-accept')).to.be.true;
          });
        });
      });
    });


    describe('with two arguments', function () {
      describe('where the second argument is not a function', function () {
        beforeEach(function () {
          return this.create = (function (_this) {
            return function () {
              return _this.dialog = bootbox.prompt('What is your name?', 'callback here');
            };
          })(this);
        });
        return it('throws an error requiring a callback', function () {
          return expect(this.create).to.throw('prompt requires a callback');
        });
      });

      describe('where the second argument is a function', function () {
        beforeEach(function () {
          return this.create = (function (_this) {
            return function () {
              return _this.dialog = bootbox.prompt('What is your name?', function () {
                return true;
              });
            };
          })(this);
        });

        it('does not throw an error', function () {
          return expect(this.create).not.to.throw(Error);
        });
        it('creates a dialog object', function () {
          return expect(this.dialog).to.be.an('object');
        });
        it('adds the correct button labels', function () {
          expect(this.text('.btn:first')).to.equal('Cancel');
          return expect(this.text('.btn:last')).to.equal('OK');
        });
        it('adds the correct button classes', function () {
          expect(this.dialog.find('.btn:first').hasClass('btn-default')).to.be.true;
          expect(this.dialog.find('.btn:first').hasClass('btn-secondary')).to.be.true;
          expect(this.dialog.find('.btn:first').hasClass('bootbox-cancel')).to.be.true;

          expect(this.dialog.find('.btn:last').hasClass('btn-primary')).to.be.true;
          return expect(this.dialog.find('.btn:last').hasClass('bootbox-accept')).to.be.true;
        });
        it('adds the expected dialog title', function () {
          return expect(this.text('.modal-title')).to.equal('What is your name?');
        });
        it('adds a close button', function () {
          return expect(this.dialog.find('.modal-header .close')).to.be.ok;
        });
        it('creates a form with a text input', function () {
          return expect(this.dialog.find('form input[type=text]')).to.be.ok;
        });
        it('with no default value', function () {
          return expect(this.dialog.find('form input[type="text"]').val()).to.equal('');
        });
        return it('shows the dialog', function () {
          return expect(this.dialog.is(':visible')).to.be.true;
        });
      });
    });
  });

  // options
  describe('configuration options tests', function () {
    beforeEach(function () {
      this.options = {
        title: 'What is your name?',
        callback: function () {
          return true;
        }
      };
      return this.create = (function (_this) {
        return function () {
          return _this.dialog = bootbox.prompt(_this.options);
        };
      })(this);
    });

    // custom cancel button
    describe('with a custom cancel button', function () {
      beforeEach(function () {
        this.options.buttons = {
          cancel: {
            label: 'Custom cancel',
            className: 'btn-danger'
          }
        };
        this.create();
        return this.button = this.dialog.find('.btn:first');
      });
      return it('adds the correct cancel button', function () {
        expect(this.button.text()).to.equal('Custom cancel');
        return expect(this.button.hasClass('btn-danger')).to.be.true;
      });
    });

    // custom confirm button
    describe('with a custom confirm button', function () {
      beforeEach(function () {
        this.options.buttons = {
          confirm: {
            label: 'Custom confirm',
            className: 'btn-warning'
          }
        };
        this.create();
        return this.button = this.dialog.find('.btn:last');
      });
      return it('adds the correct confirm button', function () {
        expect(this.button.text()).to.equal('Custom confirm');
        return expect(this.button.hasClass('btn-warning')).to.be.true;
      });
    });

    // unrecognised button key
    describe('with an unrecognised button key', function () {
      beforeEach(function () {
        return this.options.buttons = {
          prompt: {
            label: 'Custom confirm',
            className: 'btn-warning'
          }
        };
      });
      return it('throws an error', function () {
        return expect(this.create).to.throw('button key "prompt" is not allowed (options are cancel confirm)');
      });
    });

    // manual show
    describe('setting show to false', function () {
      beforeEach(function () {
        this.options.show = false;
        this.shown = sinon.spy();
        sinon.stub(bootbox, 'dialog', (function (_this) {
          return function () {
            return {
              on: function () { },
              off: function () { },
              modal: _this.shown
            };
          };
        })(this));
        return this.create();
      });
      return it('does not show the dialog', function () {
        return expect(this.shown).not.to.have.been.called;
      });
    });

    // invalid prompt type
    describe('invalid prompt type', function () {
      beforeEach(function () {
        return this.options.inputType = 'foobar';
      });
      return it('throws an error', function () {
        return expect(this.create).to.throw('Invalid prompt type');
      });
    });

    // text
    describe('setting inputType text', function () {
      beforeEach(function () {
        return this.options.inputType = 'text';
      });
      describe('without default value', function () {
        beforeEach(function () {
          return this.create();
        });
        it('shows text input ', function () {
          return expect(this.exists('input[type="text"]')).to.be.true;
        });
        return it('has proper class', function () {
          expect(this.find('input[type="text"]').hasClass('bootbox-input')).to.be.true;
          return expect(this.find('input[type="text"]').hasClass('bootbox-input-text')).to.be.true;
        });
      });

      describe('with default value', function () {
        beforeEach(function () {
          this.options.value = 'John Smith';
          return this.create();
        });
        return it('has correct default value', function () {
          return expect(this.find('input[type="text"]').val()).to.equal('John Smith');
        });
      });

      describe('with placeholder', function () {
        beforeEach(function () {
          this.options.placeholder = 'enter your name';
          return this.create();
        });
        return it('has correct placeholder value', function () {
          return expect(this.find('input[type="text"]').attr('placeholder')).to.equal('enter your name');
        });
      });

      describe('with pattern', function () {
        beforeEach(function () {
          this.options.pattern = '\d{1,2}/\d{1,2}/\d{4}';
          return this.create();
        });
        return it('has correct pattern value', function () {
          return expect(this.find('input[type="text"]').attr('pattern')).to.equal('\d{1,2}/\d{1,2}/\d{4}');
        });
      });

      describe('with maxlength', function () {
        beforeEach(function () {
          this.options.maxlength = 5;
          return this.create();
        });
        return it('has correct maxlength value', function () {
          return expect(this.find('input[type="text"]').attr('maxlength')).to.equal('5');
        });
      });
    });

    // textarea
    describe('setting inputType textarea', function () {
      beforeEach(function () {
        return this.options.inputType = 'textarea';
      });
      describe('without default value', function () {
        beforeEach(function () {
          return this.create();
        });
        it('shows text input', function () {
          return expect(this.exists('textarea')).to.be.true;
        });
        return it('has proper class', function () {
          expect(this.find('textarea').hasClass('bootbox-input')).to.be.true;
          return expect(this.find('textarea').hasClass('bootbox-input-textarea')).to.be.true;
        });
      });

      describe('with default value', function () {
        beforeEach(function () {
          this.options.value = 'Once upon a time...';
          return this.create();
        });
        return it('has correct default value', function () {
          return expect(this.find('textarea').val()).to.equal('Once upon a time...');
        });
      });

      describe('with placeholder', function () {
        beforeEach(function () {
          this.options.placeholder = 'enter your favorite fairy tale';
          return this.create();
        });
        return it('has correct placeholder value', function () {
          return expect(this.find('textarea').attr('placeholder')).to.equal('enter your favorite fairy tale');
        });
      });
      
      describe('with rows', function () {
        beforeEach(function () {
          this.options.rows = 6;
          return this.create();
        });
        return it('has correct rows value', function () {
          return expect(this.find('textarea').attr('rows')).to.equal('6');
        });
      });
    });

    // email
    describe('setting inputType email', function () {
      beforeEach(function () {
        return this.options.inputType = 'email';
      });
      describe('without default value', function () {
        beforeEach(function () {
          return this.create();
        });
        it('shows email input', function () {
          return expect(this.exists('input[type="email"]')).to.be.true;
        });
        return it('has proper class', function () {
          expect(this.find('input[type="email"]').hasClass('bootbox-input')).to.be.true;
          return expect(this.find('input[type="email"]').hasClass('bootbox-input-email')).to.be.true;
        });
      });
      describe('with default value', function () {
        beforeEach(function () {
          this.options.value = 'john@smith.com';
          return this.create();
        });
        return it('has correct default value', function () {
          return expect(this.find('input[type="email"]').val()).to.equal('john@smith.com');
        });
      });
      describe('with placeholder', function () {
        beforeEach(function () {
          this.options.placeholder = 'enter your email';
          return this.create();
        });
        return it('has correct placeholder value', function () {
          return expect(this.find('input[type="email"]').attr('placeholder')).to.equal('enter your email');
        });
      });
      describe('with pattern', function () {
        beforeEach(function () {
          this.options.pattern = '\d{1,2}/\d{1,2}/\d{4}';
          return this.create();
        });
        return it('has correct pattern value', function () {
          return expect(this.find('input[type="email"]').attr('pattern')).to.equal('\d{1,2}/\d{1,2}/\d{4}');
        });
      });
    });

    // password
    describe('setting inputType password', function () {
      beforeEach(function () {
        return this.options.inputType = 'password';
      });
      describe('without default value', function () {
        beforeEach(function () {
          return this.create();
        });
        it('shows password input', function () {
          return expect(this.exists('input[type="password"]')).to.be.true;
        });
        return it('has proper class', function () {
          expect(this.find('input[type="password"]').hasClass('bootbox-input')).to.be.true;
          return expect(this.find('input[type="password"]').hasClass('bootbox-input-password')).to.be.true;
        });
      });
      describe('with default value', function () {
        beforeEach(function () {
          this.options.value = 'qwerty';
          return this.create();
        });
        return it('has correct default value', function () {
          return expect(this.find('input[type="password"]').val()).to.equal('qwerty');
        });
      });
      describe('with placeholder', function () {
        beforeEach(function () {
          this.options.placeholder = 'enter your password';
          return this.create();
        });
        return it('has correct placeholder value', function () {
          return expect(this.find('input[type="password"]').attr('placeholder')).to.equal('enter your password');
        });
      });
    });

    // select
    describe('setting inputType select', function () {
      describe('without options', function () {
        beforeEach(function () {
          return this.options.inputType = 'select';
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('prompt with "inputType" set to "select" requires at least one option');
        });
      });
      describe('with invalid options', function () {
        beforeEach(function () {
          this.options.inputType = 'select';
          return this.options.inputOptions = 'foo';
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('Please pass an array of input options');
        });
      });
      describe('with empty options', function () {
        beforeEach(function () {
          this.options.inputType = 'select';
          return this.options.inputOptions = [];
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('prompt with "inputType" set to "select" requires at least one option');
        });
      });
      describe('with options in the wrong format', function () {
        beforeEach(function () {
          this.options.inputType = 'select';
          return this.options.inputOptions = [
            {
              foo: 'bar'
            }
          ];
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('each option needs a "value" property and a "text" property');
        });
      });
      describe('with a value but no text', function () {
        beforeEach(function () {
          this.options.inputType = 'select';
          return this.options.inputOptions = [
            {
              value: 'bar'
            }
          ];
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('each option needs a "value" property and a "text" property');
        });
      });
      describe('with an invalid second options', function () {
        beforeEach(function () {
          this.options.inputType = 'select';
          return this.options.inputOptions = [
            {
              value: 'bar',
              text: 'bar'
            }, {
              text: 'foo'
            }
          ];
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('each option needs a "value" property and a "text" property');
        });
      });
      describe('with valid options', function () {
        beforeEach(function () {
          this.options.inputType = 'select';
          this.options.inputOptions = [
            {
              value: 1,
              text: 'foo'
            }, {
              value: 2,
              text: 'bar'
            }, {
              value: 3,
              text: 'foobar'
            }
          ];
          return this.create();
        });
        it('shows select input', function () {
          return expect(this.exists('select')).to.be.true;
        });
        it('has proper class', function () {
          expect(this.find('select').hasClass('bootbox-input')).to.be.true;
          return expect(this.find('select').hasClass('bootbox-input-select')).to.be.true;
        });
        return it('with three options', function () {
          return expect(this.find('option').length).to.equal(3);
        });
      });
      describe('with zero as the first option', function () {
        beforeEach(function () {
          this.options.inputType = 'select';
          this.options.inputOptions = [
            {
              value: 0,
              text: 'foo'
            }
          ];
          return this.create();
        });
        return it('shows the select input', function () {
          return expect(this.exists('select')).to.be.true;
        });
      });
      describe('with false as the first option', function () {
        beforeEach(function () {
          this.options.inputType = 'select';
          this.options.inputOptions = [
            {
              value: false,
              text: 'foo'
            }
          ];
          return this.create();
        });
        return it('shows the select input', function () {
          return expect(this.exists('select')).to.be.true;
        });
      });
      describe('with option groups', function () {
        beforeEach(function () {
          this.options.inputType = 'select';
          this.options.inputOptions = [
            {
              value: 1,
              group: 'foo',
              text: 'foo'
            }, {
              value: 2,
              group: 'bar',
              text: 'bar'
            }, {
              value: 3,
              group: 'foo',
              text: 'foobar'
            }, {
              value: 4,
              group: 'bar',
              text: 'barfoo'
            }
          ];
          return this.create();
        });
        it('shows select input', function () {
          return expect(this.exists('select')).to.be.true;
        });
        it('has proper class', function () {
          expect(this.find('select').hasClass('bootbox-input')).to.be.true;
          return expect(this.find('select').hasClass('bootbox-input-select')).to.be.true;
        });
        it('with two option group', function () {
          return expect(this.find('optgroup').length).to.equal(2);
        });
        return it('with four options', function () {
          return expect(this.find('option').length).to.equal(4);
        });
      });
    });

    // checkbox
    describe('setting inputType checkbox', function () {
      describe('without options', function () {
        beforeEach(function () {
          return this.options.inputType = 'checkbox';
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('prompt with "inputType" set to "checkbox" requires at least one option');
        });
      });
      describe('with options in the wrong format', function () {
        beforeEach(function () {
          this.options.inputType = 'checkbox';
          return this.options.inputOptions = [
            {
              foo: 'bar'
            }
          ];
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('each option needs a "value" property and a "text" property');
        });
      });
      describe('with options', function () {
        beforeEach(function () {
          this.options.inputType = 'checkbox';
          this.options.inputOptions = [
            {
              value: 1,
              text: 'foo'
            }, {
              value: 2,
              text: 'bar'
            }, {
              value: 3,
              text: 'foobar'
            }
          ];
          return this.create();
        });
        it('shows checkbox input', function () {
          return expect(this.exists('input[type="checkbox"]')).to.be.true;
        });
        it('has proper class', function () {
          expect(this.find('input[type="checkbox"]').hasClass('bootbox-input')).to.be.true;
          return expect(this.find('input[type="checkbox"]').hasClass('bootbox-input-checkbox')).to.be.true;
        });
        return it('with three checkboxes', function () {
          return expect(this.find('input[type="checkbox"]').length).to.equal(3);
        });
      });
    });

    // radio
    describe('setting inputType radio', function () {
      describe('without options', function () {
        beforeEach(function () {
          return this.options.inputType = 'radio';
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('prompt with "inputType" set to "radio" requires at least one option');
        });
      });
      describe('with options in the wrong format', function () {
        beforeEach(function () {
          this.options.inputType = 'radio';
          return this.options.inputOptions = [
            {
              foo: 'bar'
            }
          ];
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('each option needs a "value" property and a "text" property');
        });
      });
      describe('with options', function () {
        beforeEach(function () {
          this.options.inputType = 'radio';
          this.options.inputOptions = [
            {
              value: 1,
              text: 'foo'
            }, {
              value: 2,
              text: 'bar'
            }, {
              value: 3,
              text: 'foobar'
            }
          ];
          return this.create();
        });
        it('shows radio input', function () {
          return expect(this.exists('input[type="radio"]')).to.be.true;
        });
        it('has proper class', function () {
          expect(this.find('input[type="radio"]').hasClass('bootbox-input')).to.be.true;
          return expect(this.find('input[type="radio"]').hasClass('bootbox-input-radio')).to.be.true;
        });
        return it('with three radios', function () {
          return expect(this.find('input[type="radio"]').length).to.equal(3);
        });
      });
      describe('with an invalid value', function () {
        beforeEach(function () {
          this.options.inputType = 'radio';
          this.options.inputOptions = [
            {
              value: 1,
              text: 'foo'
            }, {
              value: 2,
              text: 'bar'
            }, {
              value: 3,
              text: 'foobar'
            }
          ];
          this.options.value = [2,3];
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('prompt with "inputType" set to "radio" requires a single, non-array value for "value"');
        });
      });
    });

    // date
    describe('setting inputType date', function () {
      beforeEach(function () {
        return this.options.inputType = 'date';
      });
      describe('without default value', function () {
        beforeEach(function () {
          return this.create();
        });
        it('shows date input ', function () {
          return expect(this.exists('input[type="date"]')).to.be.true;
        });
        return it('has proper class', function () {
          expect(this.find('input[type="date"]').hasClass('bootbox-input')).to.be.true;
          return expect(this.find('input[type="date"]').hasClass('bootbox-input-date')).to.be.true;
        });
      });
      describe('with default value', function () {
        beforeEach(function () {
          this.options.value = '17/08/2005';
          return this.create();
        });
        return it('has correct default value', function () {
          return expect(this.find('input[type="date"]').val()).to.equal('17/08/2005');
        });
      });
      describe('with placeholder', function () {
        beforeEach(function () {
          this.options.placeholder = 'enter the date';
          return this.create();
        });
        return it('has correct placeholder value', function () {
          return expect(this.find('input[type="date"]').attr('placeholder')).to.equal('enter the date');
        });
      });
      describe('with pattern', function () {
        beforeEach(function () {
          this.options.pattern = '\d{1,2}/\d{1,2}/\d{4}';
          return this.create();
        });
        return it('has correct pattern value', function () {
          return expect(this.find('input[type="date"]').attr('pattern')).to.equal('\d{1,2}/\d{1,2}/\d{4}');
        });
      });
    });

    // time
    describe('setting inputType time', function () {
      beforeEach(function () {
        return this.options.inputType = 'time';
      });
      describe('without default value', function () {
        beforeEach(function () {
          return this.create();
        });
        it('shows time input', function () {
          return expect(this.exists('input[type="time"]')).to.be.true;
        });
        return it('has proper class', function () {
          expect(this.find('input[type="time"]').hasClass('bootbox-input')).to.be.true;
          return expect(this.find('input[type="time"]').hasClass('bootbox-input-time')).to.be.true;
        });
      });
      describe('with default value', function () {
        beforeEach(function () {
          this.options.value = '19:02';
          return this.create();
        });
        return it('has correct default value', function () {
          return expect(this.find('input[type="time"]').val()).to.equal('19:02');
        });
      });
      describe('with placeholder', function () {
        beforeEach(function () {
          this.options.placeholder = 'enter the time';
          return this.create();
        });
        return it('has correct placeholder value', function () {
          return expect(this.find('input[type="time"]').attr('placeholder')).to.equal('enter the time');
        });
      });
      describe('with pattern', function () {
        beforeEach(function () {
          this.options.pattern = '\d{1,2}/\d{1,2}/\d{4}';
          return this.create();
        });
        return it('has correct pattern value', function () {
          return expect(this.find('input[type="time"]').attr('pattern')).to.equal('\d{1,2}/\d{1,2}/\d{4}');
        });
      });
      describe('with min value', function () {
        beforeEach(function () {
          this.options.min = '00:00:00';
          return this.create();
        });
        return it('has correct min value', function () {
          return expect(this.find('input[type="time"]').attr('min')).to.equal('00:00:00');
        });
      });
      describe('with max value', function () {
        beforeEach(function () {
          this.options.max = '23:59:59';
          return this.create();
        });
        return it('has correct max value', function () {
          return expect(this.find('input[type="time"]').attr('max')).to.equal('23:59:59');
        });
      });
      describe('with step value', function () {
        beforeEach(function () {
          this.options.step = '10';
          return this.create();
        });
        return it('has correct step value', function () {
          return expect(this.find('input[type="time"]').attr('step')).to.equal('10');
        });
      });
      describe('with an invalid min value', function () {
        beforeEach(function () {
          this.options.min = 'a';
          this.options.max = '18:00:00';
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('"min" is not a valid time. See https://www.w3.org/TR/2012/WD-html-markup-20120315/datatypes.html#form.data.time for more information.');
        });
      });
      describe('with an invalid max value', function () {
        beforeEach(function () {
          this.options.min = '08:00:00';
          this.options.max = 'a';
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('"max" is not a valid time. See https://www.w3.org/TR/2012/WD-html-markup-20120315/datatypes.html#form.data.time for more information.');
        });
      });
      describe('with min value greater than max value', function () {
        beforeEach(function () {
          this.options.min = '16:00:00';
          this.options.max = '12:00:00';
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('"max" must be greater than "min". See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-max for more information.');
        });
      });
      describe('with an invalid step value', function () {
        beforeEach(function () {
          this.options.step = 'a';
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('"step" must be a valid positive number or the value "any". See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-step for more information.');
        });
      });
    });

    // number
    describe('setting inputType number', function () {
      beforeEach(function () {
        return this.options.inputType = 'number';
      });
      describe('without default value', function () {
        beforeEach(function () {
          return this.create();
        });
        it('shows number input ', function () {
          return expect(this.exists('input[type="number"]')).to.be.true;
        });
        return it('has proper class', function () {
          expect(this.find('input[type="number"]').hasClass('bootbox-input')).to.be.true;
          return expect(this.find('input[type="number"]').hasClass('bootbox-input-number')).to.be.true;
        });
      });
      describe('with default value', function () {
        beforeEach(function () {
          this.options.value = '300';
          return this.create();
        });
        return it('has correct default value', function () {
          return expect(this.find('input[type="number"]').val()).to.equal('300');
        });
      });
      describe('with placeholder', function () {
        beforeEach(function () {
          this.options.placeholder = 'enter the number';
          return this.create();
        });
        return it('has correct placeholder value', function () {
          return expect(this.find('input[type="number"]').attr('placeholder')).to.equal('enter the number');
        });
      });
      describe('with min value', function () {
        beforeEach(function () {
          this.options.min = 0;
          return this.create();
        });
        return it('has correct min value', function () {
          return expect(this.find('input[type="number"]').attr('min')).to.equal('0');
        });
      });
      describe('with max value', function () {
        beforeEach(function () {
          this.options.max = 100;
          return this.create();
        });
        return it('has correct max value', function () {
          return expect(this.find('input[type="number"]').attr('max')).to.equal('100');
        });
      });
      describe('with step value', function () {
        beforeEach(function () {
          this.options.step = 10;
          return this.create();
        });
        return it('has correct step value', function () {
          return expect(this.find('input[type="number"]').attr('step')).to.equal('10');
        });
      });
      describe('with an invalid min value', function () {
        beforeEach(function () {
          this.options.min = 'a';
          this.options.max = 50;
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('"min" must be a valid number. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-min for more information.');
        });
      });
      describe('with an invalid max value', function () {
        beforeEach(function () {
          this.options.min = 0;
          this.options.max = 'a';
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('"max" must be a valid number. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-max for more information.');
        });
      });
      describe('with min value greater than max value', function () {
        beforeEach(function () {
          this.options.min = 100;
          this.options.max = 50;
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('"max" must be greater than "min". See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-max for more information.');
        });
      });
      describe('with an invalid step value', function () {
        beforeEach(function () {
          this.options.step = 'a';
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('"step" must be a valid positive number or the value "any". See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-step for more information.');
        });
      });

    });


    // range
    describe('setting inputType range', function () {
      beforeEach(function () {
        return this.options.inputType = 'range';
      });

      describe('without default value', function () {
        beforeEach(function () {
          return this.create();
        });

        it('shows range input ', function () {
          return expect(this.exists('input[type="range"]')).to.be.true;
        });
        return it('has proper class', function () {
          expect(this.find('input[type="range"]').hasClass('bootbox-input')).to.be.true;
          return expect(this.find('input[type="range"]').hasClass('bootbox-input-range')).to.be.true;
        });
      });

      describe('with default value', function () {
        beforeEach(function () {
          // Default max value of a range is 100, so anything less works as an initial value. 
          // @see https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/range#Specifying_the_minimum_and_maximum
          this.options.value = 50;
          return this.create();
        });
        return it('has correct default value', function () {
          return expect(this.find('input[type="range"]').val()).to.equal('50');
        });
      });

      describe('with min value', function () {
        beforeEach(function () {
          this.options.min = 0;
          return this.create();
        });
        return it('has correct min value', function () {
          return expect(this.find('input[type="range"]').attr('min')).to.equal('0');
        });
      });

      describe('with max value', function () {
        beforeEach(function () {
          this.options.max = 100;
          return this.create();
        });
        return it('has correct max value', function () {
          return expect(this.find('input[type="range"]').attr('max')).to.equal('100');
        });
      });

      describe('with step value', function () {
        beforeEach(function () {
          this.options.step = 10;
          return this.create();
        });
        return it('has correct step value', function () {
          return expect(this.find('input[type="range"]').attr('step')).to.equal('10');
        });
      });

      describe('with an invalid min value', function () {
        beforeEach(function () {
          this.options.min = 'a';
          this.options.max = 50;
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('"min" must be a valid number. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-min for more information.');
        });
      });

      describe('with an invalid max value', function () {
        beforeEach(function () {
          this.options.min = 0;
          this.options.max = 'a';
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('"max" must be a valid number. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-max for more information.');
        });
      });

      describe('with min value greater than max value', function () {
        beforeEach(function () {
          this.options.min = 100;
          this.options.max = 50;
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('"max" must be greater than "min". See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-max for more information.');
        });
      });

      describe('with an invalid step value', function () {
        beforeEach(function () {
          this.options.step = 'a';
        });
        return it('throws an error', function () {
          return expect(this.create).to.throw('"step" must be a valid positive number or the value "any". See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-step for more information.');
        });
      });
    });
  });

  // callback tests
  describe('callback tests', function () {

    // simple callback
    describe('with a simple callback', function () {
      beforeEach(function () {
        this.callback = sinon.spy();
        this.dialog = bootbox.prompt({
          title: 'What is your name?',
          callback: this.callback
        });
        return this.hidden = sinon.spy(this.dialog, 'modal');
      });
      describe('when entering no value in the text input', function () {
        describe('when dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('');
          });
          return it('should hide the modal', function () {
            return expect(this.hidden).to.have.been.calledWithExactly('hide');
          });
        });
        describe('when submitting the form', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-form').trigger('submit');
          });
          it('invokes the callback with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('');
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          return it('should hide the modal', function () {
            return expect(this.hidden).to.have.been.calledWithExactly('hide');
          });
        });
      });
      describe('when entering a value in the text input', function () {
        beforeEach(function () {
          return this.dialog.find('.bootbox-input').val('Test input');
        });
        describe('when dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('Test input');
          });
          return it('should hide the modal', function () {
            return expect(this.hidden).to.have.been.calledWithExactly('hide');
          });
        });
        describe('when submitting the form', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-form').trigger('submit');
          });
          it('invokes the callback with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('Test input');
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          return it('should hide the modal', function () {
            return expect(this.hidden).to.have.been.calledWithExactly('hide');
          });
        });
      });
      describe('when dismissing the dialog by clicking Cancel', function () {
        beforeEach(function () {
          return this.dialog.find('.bootbox-cancel').trigger('click');
        });
        it('should invoke the callback', function () {
          return expect(this.callback).to.have.been.called;
        });
        it('should pass the dialog as "this"', function () {
          return expect(this.callback.thisValues[0]).to.equal(this.dialog);
        });
        it('with the correct value', function () {
          return expect(this.callback).to.have.been.calledWithExactly(null);
        });
        return it('should hide the modal', function () {
          return expect(this.hidden).to.have.been.calledWithExactly('hide');
        });
      });
      describe('when triggering the escape event', function () {
        beforeEach(function () {
          return this.dialog.trigger('escape.close.bb');
        });
        it('should invoke the callback', function () {
          return expect(this.callback).to.have.been.called;
        });
        it('should pass the dialog as "this"', function () {
          return expect(this.callback.thisValues[0]).to.equal(this.dialog);
        });
        it('with the correct value', function () {
          return expect(this.callback).to.have.been.calledWithExactly(null);
        });
        return it('should hide the modal', function () {
          return expect(this.hidden).to.have.been.calledWithExactly('hide');
        });
      });
      describe('when dismissing the dialog by clicking the close button', function () {
        beforeEach(function () {
          return this.dialog.find('.close').trigger('click');
        });
        it('should invoke the callback', function () {
          return expect(this.callback).to.have.been.called;
        });
        it('should pass the dialog as "this"', function () {
          return expect(this.callback.thisValues[0]).to.equal(this.dialog);
        });
        it('with the correct value', function () {
          return expect(this.callback).to.have.been.calledWithExactly(null);
        });
        return it('should hide the modal', function () {
          return expect(this.hidden).to.have.been.calledWithExactly('hide');
        });
      });
    });

    // callback which returns false
    describe('with a callback which returns false', function () {
      beforeEach(function () {
        this.callback = sinon.stub();
        this.callback.returns(false);
        this.dialog = bootbox.prompt({
          title: 'What is your name?',
          callback: this.callback
        });
        return this.hidden = sinon.spy(this.dialog, 'modal');
      });
      describe('when entering no value in the text input', function () {
        return describe('when dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('');
          });
          return it('should not hide the modal', function () {
            return expect(this.hidden).not.to.have.been.called;
          });
        });
      });
      describe('when entering a value in the text input', function () {
        beforeEach(function () {
          return this.dialog.find('.bootbox-input').val('Test input');
        });
        return describe('when dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('Test input');
          });
          return it('should not hide the modal', function () {
            return expect(this.hidden).not.to.have.been.called;
          });
        });
      });
      describe('when dismissing the dialog by clicking Cancel', function () {
        beforeEach(function () {
          return this.dialog.find('.bootbox-cancel').trigger('click');
        });
        it('should invoke the callback', function () {
          return expect(this.callback).to.have.been.called;
        });
        it('should pass the dialog as "this"', function () {
          return expect(this.callback.thisValues[0]).to.equal(this.dialog);
        });
        it('with the correct value', function () {
          return expect(this.callback).to.have.been.calledWithExactly(null);
        });
        return it('should not hide the modal', function () {
          return expect(this.hidden).not.to.have.been.called;
        });
      });
      describe('when triggering the escape event', function () {
        beforeEach(function () {
          return this.dialog.trigger('escape.close.bb');
        });
        it('should invoke the callback', function () {
          return expect(this.callback).to.have.been.called;
        });
        it('should pass the dialog as "this"', function () {
          return expect(this.callback.thisValues[0]).to.equal(this.dialog);
        });
        it('with the correct value', function () {
          return expect(this.callback).to.have.been.calledWithExactly(null);
        });
        return it('should not hide the modal', function () {
          return expect(this.hidden).not.to.have.been.called;
        });
      });
      describe('when dismissing the dialog by clicking the close button', function () {
        beforeEach(function () {
          return this.dialog.find('.close').trigger('click');
        });
        it('should invoke the callback', function () {
          return expect(this.callback).to.have.been.called;
        });
        it('should pass the dialog as "this"', function () {
          return expect(this.callback.thisValues[0]).to.equal(this.dialog);
        });
        it('with the correct value', function () {
          return expect(this.callback).to.have.been.calledWithExactly(null);
        });
        return it('should not hide the modal', function () {
          return expect(this.hidden).not.to.have.been.called;
        });
      });
    });

    // default value
    describe('with a default value', function () {
      beforeEach(function () {
        this.callback = sinon.spy();
        this.dialog = bootbox.prompt({
          title: 'What is your name?',
          value: 'Bob',
          callback: this.callback
        });
        return this.hidden = sinon.spy(this.dialog, 'modal');
      });
      it('populates the input with the default value', function () {
        return expect(this.dialog.find('.bootbox-input').val()).to.equal('Bob');
      });
      describe('when entering no value in the text input', function () {
        describe('when dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          return it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('Bob');
          });
        });
        describe('when dismissing the dialog by clicking Cancel', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-cancel').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          return it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly(null);
          });
        });
      });
      describe('when entering a value in the text input', function () {
        beforeEach(function () {
          return this.dialog.find('.bootbox-input').val('Alice');
        });
        describe('when dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          return it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('Alice');
          });
        });
        describe('when dismissing the dialog by clicking Cancel', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-cancel').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          return it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly(null);
          });
        });
      });
    });

    // placeholder
    describe('with a placeholder', function () {
      beforeEach(function () {
        this.callback = sinon.spy();
        return this.dialog = bootbox.prompt({
          title: 'What is your name?',
          placeholder: 'e.g. Bob Smith',
          callback: function () {
            return true;
          }
        });
      });
      return it('populates the input with the placeholder attribute', function () {
        return expect(this.dialog.find('.bootbox-input').attr('placeholder')).to.equal('e.g. Bob Smith');
      });
    });

    // select
    describe('with inputType select', function () {
      describe('without a default value', function () {
        beforeEach(function () {
          this.callback = sinon.spy();
          this.dialog = bootbox.prompt({
            title: 'What is your IDE?',
            callback: this.callback,
            inputType: 'select',
            inputOptions: [
              {
                value: '#',
                text: 'Choose one'
              }, {
                value: 1,
                text: 'Vim'
              }, {
                value: 2,
                text: 'Sublime Text'
              }, {
                value: 3,
                text: 'WebStorm/PhpStorm'
              }, {
                value: 4,
                text: 'Komodo IDE'
              }
            ]
          });
          return this.hidden = sinon.spy(this.dialog, 'modal');
        });
        it('has correct number values in list', function () {
          return expect(this.find('.bootbox-input-select option').length).to.equal(5);
        });
        describe('when dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          return it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('#');
          });
        });
        describe('when dismissing the dialog by clicking Cancel', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-cancel').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          return it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly(null);
          });
        });
      });
      describe('with a default value', function () {
        beforeEach(function () {
          this.callback = sinon.spy();
          this.dialog = bootbox.prompt({
            title: 'What is your IDE?',
            callback: this.callback,
            value: 1,
            inputType: 'select',
            inputOptions: [
              {
                value: '#',
                text: 'Choose one'
              }, {
                value: 1,
                text: 'Vim'
              }, {
                value: 2,
                text: 'Sublime Text'
              }, {
                value: 3,
                text: 'WebStorm/PhpStorm'
              }, {
                value: 4,
                text: 'Komodo IDE'
              }
            ]
          });
          return this.hidden = sinon.spy(this.dialog, 'modal');
        });
        it('specified option is selected', function () {
          return expect(this.dialog.find('.bootbox-input-select').val()).to.equal('1');
        });
        describe('when dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          return it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('1');
          });
        });
        describe('when dismissing the dialog by clicking Cancel', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-cancel').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          return it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly(null);
          });
        });
        describe('when changing the selected option and dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            this.dialog.find('.bootbox-input-select').val(3);
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          return it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('3');
          });
        });
      });
    });

    // email
    describe('with inputType email', function () {
      describe('without a default value', function () {
        beforeEach(function () {
          this.callback = sinon.spy();
          this.dialog = bootbox.prompt({
            title: 'What is your email?',
            inputType: 'email',
            callback: this.callback
          });
          return this.hidden = sinon.spy(this.dialog, 'modal');
        });
        describe('when dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('should pass the dialog as "this"', function () {
            return expect(this.callback.thisValues[0]).to.equal(this.dialog);
          });
          it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('');
          });
          return it('should hide the modal', function () {
            return expect(this.hidden).to.have.been.calledWithExactly('hide');
          });
        });
        describe('when submitting the form', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-form').trigger('submit');
          });
          it('invokes the callback with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('');
          });
          return it('should hide the modal', function () {
            return expect(this.hidden).to.have.been.calledWithExactly('hide');
          });
        });
        describe('when entering a value in the email input', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-input-email').val('john@smith.com');
          });
          describe('when dismissing the dialog by clicking OK', function () {
            beforeEach(function () {
              return this.dialog.find('.bootbox-accept').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            it('should pass the dialog as "this"', function () {
              return expect(this.callback.thisValues[0]).to.equal(this.dialog);
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly('john@smith.com');
            });
          });
          describe('when dismissing the dialog by clicking Cancel', function () {
            beforeEach(function () {
              return this.dialog.find('.bootbox-cancel').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly(null);
            });
          });
        });
      });
      describe('with a default value', function () {
        beforeEach(function () {
          this.callback = sinon.spy();
          this.dialog = bootbox.prompt({
            title: 'What is your email?',
            inputType: 'email',
            value: 'john@smith.com',
            callback: this.callback
          });
          return this.hidden = sinon.spy(this.dialog, 'modal');
        });
        describe('when dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('john@smith.com');
          });
          return it('should hide the modal', function () {
            return expect(this.hidden).to.have.been.calledWithExactly('hide');
          });
        });
        describe('when submitting the form', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-form').trigger('submit');
          });
          it('invokes the callback with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('john@smith.com');
          });
          return it('should hide the modal', function () {
            return expect(this.hidden).to.have.been.calledWithExactly('hide');
          });
        });
        describe('when changing a value in the email input', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-input-email').val('smith@john.com');
          });
          describe('when dismissing the dialog by clicking OK', function () {
            beforeEach(function () {
              return this.dialog.find('.bootbox-accept').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly('smith@john.com');
            });
          });
          describe('when dismissing the dialog by clicking Cancel', function () {
            beforeEach(function () {
              return this.dialog.find('.bootbox-cancel').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly(null);
            });
          });
        });
      });
    });

    // checkbox
    describe('with input type checkbox', function () {
      describe('without a default value', function () {
        beforeEach(function () {
          this.callback = sinon.spy();
          this.dialog = bootbox.prompt({
            title: 'What is your IDE?',
            inputType: 'checkbox',
            inputOptions: [
              {
                value: 1,
                text: 'Vim'
              }, {
                value: 2,
                text: 'Sublime Text'
              }, {
                value: 3,
                text: 'WebStorm/PhpStorm'
              }, {
                value: 4,
                text: 'Komodo IDE'
              }
            ],
            callback: this.callback
          });
          return this.hidden = sinon.spy(this.dialog, 'modal');
        });
        describe('when dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('with an undefined value', function () {
            return expect(this.callback).to.have.been.calledWithExactly([]);
          });
          return it('should hide the modal', function () {
            return expect(this.hidden).to.have.been.calledWithExactly('hide');
          });
        });
        describe('when dismissing the dialog by clicking Cancel', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-cancel').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          return it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly(null);
          });
        });
      });
      describe('with default value', function () {
        describe('one value checked', function () {
          beforeEach(function () {
            this.callback = sinon.spy();
            this.dialog = bootbox.prompt({
              title: 'What is your IDE?',
              callback: this.callback,
              value: 2,
              inputType: 'checkbox',
              inputOptions: [
                {
                  value: 1,
                  text: 'Vim'
                }, {
                  value: 2,
                  text: 'Sublime Text'
                }, {
                  value: 3,
                  text: 'WebStorm/PhpStorm'
                }, {
                  value: 4,
                  text: 'Komodo IDE'
                }
              ]
            });
            return this.hidden = sinon.spy(this.dialog, 'modal');
          });
          it('specified checkbox is checked', function () {
            return expect(this.dialog.find('input:checkbox:checked').val()).to.equal('2');
          });
          describe('when dismissing the dialog by clicking OK', function () {
            beforeEach(function () {
              return this.dialog.find('.bootbox-accept').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly(['2']);
            });
          });
          describe('when dismissing the dialog by clicking Cancel', function () {
            beforeEach(function () {
              return this.dialog.find('.bootbox-cancel').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly(null);
            });
          });
          describe('when changing the checked option and dismissing the dialog by clicking Cancel', function () {
            beforeEach(function () {
              this.dialog.find('input:checkbox:checked').prop('checked', false);
              this.dialog.find('input:checkbox[value=3]').prop('checked', true);
              return this.dialog.find('.bootbox-cancel').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly(null);
            });
          });
          describe('when changing the selected option and dismissing the dialog by clicking OK', function () {
            beforeEach(function () {
              this.dialog.find('input:checkbox:checked').prop('checked', false);
              this.dialog.find('input:checkbox[value=3]').prop('checked', true);
              return this.dialog.find('.bootbox-accept').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly(['3']);
            });
          });
        });
        describe('multiple value checked', function () {
          beforeEach(function () {
            this.callback = sinon.spy();
            this.dialog = bootbox.prompt({
              title: 'What is your IDE?',
              callback: this.callback,
              value: [2, 3],
              inputType: 'checkbox',
              inputOptions: [
                {
                  value: 1,
                  text: 'Vim'
                }, {
                  value: 2,
                  text: 'Sublime Text'
                }, {
                  value: 3,
                  text: 'WebStorm/PhpStorm'
                }, {
                  value: 4,
                  text: 'Komodo IDE'
                }
              ]
            });
            return this.hidden = sinon.spy(this.dialog, 'modal');
          });
          it('specified checkboxes are checked', function () {
            var checked;
            checked = [];
            this.dialog.find('input:checkbox:checked').each((function () {
              return function (foo, bar) {
                return checked.push($(bar).val());
              };
            })(this));
            return expect(checked).to.deep.equal(['2', '3']);
          });
          describe('when dismissing the dialog by clicking OK', function () {
            beforeEach(function () {
              return this.dialog.find('.bootbox-accept').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly(['2', '3']);
            });
          });
          describe('when dismissing the dialog by clicking Cancel', function () {
            beforeEach(function () {
              return this.dialog.find('.bootbox-cancel').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly(null);
            });
          });
          describe('when changing the checked options and dismissing the dialog by clicking Cancel', function () {
            beforeEach(function () {
              this.dialog.find('input:checkbox:checked').prop('checked', false);
              this.dialog.find('input:checkbox[value=1]').prop('checked', true);
              this.dialog.find('input:checkbox[value=4]').prop('checked', true);
              return this.dialog.find('.bootbox-cancel').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly(null);
            });
          });
          describe('when changing the checked options and dismissing the dialog by clicking OK', function () {
            beforeEach(function () {
              this.dialog.find('input:checkbox:checked').prop('checked', false);
              this.dialog.find('input:checkbox[value=1]').prop('checked', true);
              this.dialog.find('input:checkbox[value=4]').prop('checked', true);
              return this.dialog.find('.bootbox-accept').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly(['1', '4']);
            });
          });
        });
      });
    });

    // radio
    describe('with input type radio', function () {
      describe('without a default value', function () {
        beforeEach(function () {
          this.callback = sinon.spy();
          this.dialog = bootbox.prompt({
            title: 'What is your IDE?',
            inputType: 'radio',
            inputOptions: [
              {
                value: 1,
                text: 'Vim'
              }, {
                value: 2,
                text: 'Sublime Text'
              }, {
                value: 3,
                text: 'WebStorm/PhpStorm'
              }, {
                value: 4,
                text: 'Komodo IDE'
              }
            ],
            callback: this.callback
          });
          return this.hidden = sinon.spy(this.dialog, 'modal');
        });
        describe('when dismissing the dialog by clicking OK', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-accept').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          it('with the first option value', function () {
            return expect(this.callback).to.have.been.calledWithExactly('1');
          });
          return it('should hide the modal', function () {
            return expect(this.hidden).to.have.been.calledWithExactly('hide');
          });
        });
        describe('when dismissing the dialog by clicking Cancel', function () {
          beforeEach(function () {
            return this.dialog.find('.bootbox-cancel').trigger('click');
          });
          it('should invoke the callback', function () {
            return expect(this.callback).to.have.been.called;
          });
          return it('with the correct value', function () {
            return expect(this.callback).to.have.been.calledWithExactly(null);
          });
        });
      });
      describe('with default value', function () {
        describe('one value checked', function () {
          beforeEach(function () {
            this.callback = sinon.spy();
            this.dialog = bootbox.prompt({
              title: 'What is your IDE?',
              callback: this.callback,
              value: 2,
              inputType: 'radio',
              inputOptions: [
                {
                  value: 1,
                  text: 'Vim'
                }, {
                  value: 2,
                  text: 'Sublime Text'
                }, {
                  value: 3,
                  text: 'WebStorm/PhpStorm'
                }, {
                  value: 4,
                  text: 'Komodo IDE'
                }
              ]
            });
            return this.hidden = sinon.spy(this.dialog, 'modal');
          });
          it('specified radio is checked', function () {
            return expect(this.dialog.find('input:checked').val()).to.equal('2');
          });
          describe('when dismissing the dialog by clicking OK', function () {
            beforeEach(function () {
              return this.dialog.find('.bootbox-accept').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly('2');
            });
          });
          describe('when dismissing the dialog by clicking Cancel', function () {
            beforeEach(function () {
              return this.dialog.find('.bootbox-cancel').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly(null);
            });
          });
          describe('when changing the checked option and dismissing the dialog by clicking Cancel', function () {
            beforeEach(function () {
              this.dialog.find('input:radio[value=3]').prop('checked', true);
              return this.dialog.find('.bootbox-cancel').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly(null);
            });
          });
          describe('when changing the selected option and dismissing the dialog by clicking OK', function () {
            beforeEach(function () {
              this.dialog.find('input:radio[value=3]').prop('checked', true);
              return this.dialog.find('.bootbox-accept').trigger('click');
            });
            it('should invoke the callback', function () {
              return expect(this.callback).to.have.been.called;
            });
            return it('with the correct value', function () {
              return expect(this.callback).to.have.been.calledWithExactly('3');
            });
          });
        });
      });
    });
  });
});
