package Locales::DB::Language::hr;

# Auto generated from CLDR

$Locales::DB::Language::hr::VERSION = '0.09';

$Locales::DB::Language::hr::cldr_version = '2.0';

%Locales::DB::Language::hr::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Jezik\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ i\ \{1\}",
            'end'    => "\{0\}\ i\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Regija\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '“',
        'quotation_end'             => '’',
        'quotation_start'           => '‘'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'few',
            'many',
            'other'
        ],
        'category_rules' => {
            'few'  => "n\ mod\ 10\ in\ 2\.\.4\ and\ n\ mod\ 100\ not\ in\ 12\.\.14",
            'many' => "n\ mod\ 10\ is\ 0\ or\ n\ mod\ 10\ in\ 5\.\.9\ or\ n\ mod\ 100\ in\ 11\.\.14",
            'one'  => "n\ mod\ 10\ is\ 1\ and\ n\ mod\ 100\ is\ not\ 11"
        },
        'category_rules_compiled' => {
            'few' => sub {
                if ( ( ( int( $_[0] ) == $_[0] && ( $_[0] % 10 ) >= 2 && ( $_[0] % 10 ) <= 4 ) && ( int( $_[0] ) != $_[0] || ( $_[0] % 100 ) < 12 || ( $_[0] % 100 ) > 14 ) ) ) { return 'few'; }
                return;
            },
            'many' => sub {
                if ( ( ( ( $_[0] % 10 ) == 0 ) ) || ( ( int( $_[0] ) == $_[0] && ( $_[0] % 10 ) >= 5 && ( $_[0] % 10 ) <= 9 ) ) || ( ( int( $_[0] ) == $_[0] && ( $_[0] % 100 ) >= 11 && ( $_[0] % 100 ) <= 14 ) ) ) { return 'many'; }
                return;
            },
            'one' => sub {
                if ( ( ( ( $_[0] % 10 ) == 1 ) && ( ( $_[0] % 100 ) != 11 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "ne\:n",
        'yesstr' => "da\:d"
    },
);

%Locales::DB::Language::hr::code_to_name = (
    'aa'    => 'afarski',
    'ab'    => 'abhaski',
    'ace'   => 'achinese',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adigejski',
    'ae'    => 'avestan',
    'af'    => 'afrikaans',
    'afa'   => "ostali\ afričko\-azijski",
    'afh'   => 'afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'ainu',
    'ak'    => 'akanski',
    'akk'   => 'akkadian',
    'ale'   => 'aleutski',
    'alg'   => 'algonquian',
    'alt'   => "južni\ altai",
    'am'    => 'amharik',
    'an'    => 'aragonski',
    'ang'   => 'staroengleski',
    'anp'   => 'angika',
    'apa'   => 'apaški',
    'ar'    => 'arapski',
    'arc'   => 'aramejski',
    'arn'   => 'araukanski',
    'arp'   => 'arapaho',
    'art'   => "umjetni\ jezik",
    'arw'   => 'arawak',
    'as'    => 'asamski',
    'asa'   => 'Asu',
    'ast'   => 'asturijski',
    'ath'   => 'athapascan',
    'aus'   => 'australski',
    'av'    => 'avarski',
    'awa'   => 'awadhi',
    'ay'    => 'aymara',
    'az'    => 'Azerski',
    'ba'    => 'baškirski',
    'bad'   => 'banda',
    'bai'   => 'bamileke',
    'bal'   => 'baluchi',
    'ban'   => 'balinezijski',
    'bas'   => 'basa',
    'bat'   => 'baltički',
    'be'    => 'bjeloruski',
    'bej'   => 'beja',
    'bem'   => 'bemba',
    'ber'   => 'berberski',
    'bez'   => 'Bena',
    'bg'    => 'bugarski',
    'bh'    => 'bihari',
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalski',
    'bnt'   => 'bantu',
    'bo'    => 'tibetanski',
    'br'    => 'bretonski',
    'bra'   => 'braj',
    'brx'   => 'Bodo',
    'bs'    => 'bosanski',
    'btk'   => 'batak',
    'bua'   => 'buriat',
    'bug'   => 'buginski',
    'byn'   => 'blin',
    'ca'    => 'katalonski',
    'cad'   => 'caddo',
    'cai'   => "jezik\ srednjoameričkih\ Indijanaca",
    'car'   => 'karipski',
    'cau'   => 'kavkaski',
    'cay'   => 'Cayuga',
    'cch'   => 'atsam',
    'ce'    => 'čečenski',
    'ceb'   => 'cebuano',
    'cel'   => 'keltski',
    'cgg'   => 'Chiga',
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'chagatai',
    'chk'   => 'chuukese',
    'chm'   => 'mari',
    'chn'   => "chinook\ žargon",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'čeroki',
    'chy'   => 'čejenski',
    'cmc'   => 'chamic',
    'co'    => 'korzički',
    'cop'   => 'koptski',
    'cpe'   => "engleski\ \-\ na\ osnovi\ kreolskog\ ili\ pidgin",
    'cpf'   => "francuski\ \-\ na\ osnovi\ kreolskog\ ili\ pidgin",
    'cpp'   => "kreolski\ ili\ pidgin\ na\ osnovi\ portugalskog",
    'cr'    => 'cree',
    'crh'   => "krimski\ turski",
    'crp'   => "kreolski\ ili\ pidgin",
    'cs'    => 'češki',
    'csb'   => 'kašupski',
    'cu'    => 'crkvenoslavenski',
    'cus'   => 'kušitski',
    'cv'    => 'chuvash',
    'cy'    => 'velški',
    'da'    => 'danski',
    'dak'   => "dakota\ jezik",
    'dar'   => 'dargwa',
    'dav'   => 'Taita',
    'day'   => 'dayak',
    'de'    => 'njemački',
    'de_at' => "austrijski\ njemački",
    'de_ch' => "gornjonjemački\ \(švicarski\)",
    'del'   => 'delavarski',
    'den'   => 'slave',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'dje'   => 'Zarma',
    'doi'   => 'dogri',
    'dra'   => 'dravidski',
    'dsb'   => 'lužičkosrpski',
    'dua'   => 'duala',
    'dum'   => "nizozemski\,\ srednji",
    'dv'    => 'divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'dyula',
    'dz'    => 'dzongkha',
    'ebu'   => 'Embu',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => 'staroegipatski',
    'eka'   => 'ekajuk',
    'el'    => 'grčki',
    'elx'   => 'elamitski',
    'en'    => 'engleski',
    'en_au' => "engleski\ \(australski\)",
    'en_ca' => "kanadski\ engleski",
    'en_gb' => "engleski\ \(britanski\)",
    'en_us' => "engleski\ \(američki\)",
    'enm'   => "engleski\,\ srednji",
    'eo'    => 'esperanto',
    'es'    => 'španjolski',
    'es_es' => "iberski\ španjolski",
    'et'    => 'estonijski',
    'eu'    => 'baskijski',
    'ewo'   => 'ewondo',
    'fa'    => 'perzijski',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulah',
    'fi'    => 'finski',
    'fil'   => 'filipino',
    'fiu'   => "ugro\-finski\ jezik",
    'fj'    => 'fidžijski',
    'fo'    => 'faroanski',
    'fon'   => 'fon',
    'fr'    => 'francuski',
    'fr_ca' => "kanadski\ francuski",
    'fr_ch' => "švicarski\ francuski",
    'frm'   => "francuski\,\ srednji",
    'fro'   => 'starofrancuski',
    'frr'   => 'sjevernofrizijski',
    'frs'   => 'istočnofrizijski',
    'fur'   => 'friulski',
    'fy'    => 'frizijski',
    'ga'    => 'irski',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "škotski\-galski",
    'gem'   => 'germanski',
    'gez'   => 'staroetiopski',
    'gil'   => 'gilbertski',
    'gl'    => 'galicijski',
    'gmh'   => "njemački\,\ srednji\ visoki",
    'gn'    => 'guarani',
    'goh'   => "staronjemački\,\ visoki",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gothic',
    'grb'   => 'grebo',
    'grc'   => 'starogrčki',
    'gsw'   => "švicarski\ njemački",
    'gu'    => 'gujarati',
    'guz'   => 'Gusii',
    'gv'    => 'manx',
    'gwi'   => "gwich\'in",
    'ha'    => 'hausa',
    'hai'   => 'haidi',
    'haw'   => 'havajski',
    'he'    => 'hebrejski',
    'hi'    => 'hindski',
    'hil'   => 'hiligaynon',
    'him'   => 'himachali',
    'hit'   => 'hetitski',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'hrvatski',
    'hsb'   => 'gornjolužički',
    'ht'    => 'kreolski',
    'hu'    => 'mađarski',
    'hup'   => 'hupa',
    'hy'    => 'armenski',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonezijski',
    'ie'    => 'interligua',
    'ig'    => 'igbo',
    'ii'    => "sichuan\ yi",
    'ijo'   => 'ijo',
    'ik'    => 'inupiaq',
    'ilo'   => 'iloko',
    'inc'   => 'indijski',
    'ine'   => 'indoeuropski',
    'inh'   => 'ingušetski',
    'io'    => 'ido',
    'ira'   => 'iranski',
    'iro'   => 'irokeški',
    'is'    => 'islandski',
    'it'    => 'talijanski',
    'iu'    => 'inuktitut',
    'ja'    => 'japanski',
    'jbo'   => 'lojban',
    'jmc'   => 'Machame',
    'jpr'   => "judejsko\-perzijski",
    'jrb'   => "judejsko\-arapski",
    'jv'    => 'javanski',
    'ka'    => 'gruzijski',
    'kaa'   => "kara\-kalpak",
    'kab'   => 'kabyle',
    'kac'   => 'kachin',
    'kaj'   => 'kaje',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardian',
    'kcg'   => 'tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => 'kojsanski',
    'kho'   => 'khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazaški',
    'kl'    => 'kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'kmerski',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannadski',
    'ko'    => 'korejski',
    'kok'   => 'konkani',
    'kos'   => 'naurski',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karachay\-balkar",
    'krl'   => 'karelijski',
    'kro'   => 'kru',
    'kru'   => 'kuruški',
    'ks'    => 'kašmirski',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kurdski',
    'kum'   => 'kumyk',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'kornski',
    'ky'    => 'kirgiški',
    'la'    => 'latinski',
    'lad'   => 'ladino',
    'lag'   => 'Langi',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luksemburški',
    'lez'   => 'lezgiški',
    'lg'    => 'ganda',
    'li'    => 'limburgish',
    'ln'    => 'lingala',
    'lo'    => 'laoski',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'litvanski',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'luy'   => 'Luyia',
    'lv'    => 'latvijski',
    'mad'   => 'madurski',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makasar',
    'man'   => 'mandingo',
    'map'   => 'austronezijski',
    'mas'   => 'masajski',
    'mdf'   => 'moksha',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgaški',
    'mga'   => "irski\,\ srednji",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'maršalski',
    'mi'    => 'maorski',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "ostali\ jezici",
    'mk'    => 'makedonski',
    'mkh'   => 'mkh',
    'ml'    => 'malajalamski',
    'mn'    => 'mongolski',
    'mnc'   => 'mandžurski',
    'mni'   => 'manipurski',
    'mno'   => 'manobo',
    'mo'    => 'moldavski',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathi',
    'ms'    => 'malajski',
    'mt'    => 'malteški',
    'mua'   => 'Mundang',
    'mul'   => "više\ jezika",
    'mun'   => 'munda',
    'mus'   => 'creek',
    'mwl'   => 'mirandski',
    'mwr'   => 'marwari',
    'my'    => 'burmanski',
    'myn'   => 'majanski',
    'myv'   => 'mordvinski',
    'na'    => 'nauru',
    'nah'   => 'nahuatl',
    'nai'   => "jezik\ sjevernoameričkih\ Indijanaca",
    'nap'   => 'napolitanski',
    'naq'   => 'Nama',
    'nb'    => "književni\ norveški",
    'nd'    => "sjeverni\ ndebele",
    'nds'   => 'donjonjemački',
    'ne'    => 'nepalski',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "nigersko\-kordofanski",
    'niu'   => 'niujski',
    'nl'    => 'nizozemski',
    'nl_be' => 'flamanski',
    'nmg'   => 'Kwasio',
    'nn'    => 'novonorveški',
    'no'    => 'norveški',
    'nog'   => 'nogajski',
    'non'   => 'staronorveški',
    'nqo'   => "n\'ko",
    'nr'    => "južni\ ndebele",
    'nso'   => "sjeverni\ sotho",
    'nub'   => 'nubijski',
    'nus'   => 'Nuer',
    'nv'    => 'navajo',
    'nwc'   => "klasični\ newari",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzima',
    'oc'    => 'okcitanski',
    'oj'    => 'ojibwa',
    'om'    => 'oromski',
    'or'    => 'orijski',
    'os'    => 'osetski',
    'osa'   => 'osage',
    'ota'   => "turski\ \-\ otomanski",
    'oto'   => 'otomijski',
    'pa'    => 'punjabi',
    'paa'   => 'papuanski',
    'pag'   => 'pangasinan',
    'pal'   => 'pahlavi',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'palauanski',
    'peo'   => 'staroperzijski',
    'phi'   => 'filipinski',
    'phn'   => 'fenički',
    'pi'    => 'pali',
    'pl'    => 'poljski',
    'pon'   => 'pohnpeian',
    'pra'   => 'prakrit',
    'pro'   => 'staroprovansalski',
    'ps'    => 'Puštu',
    'pt'    => 'portugalski',
    'pt_br' => "brazilski\ portugalski",
    'pt_pt' => "portugalski\ \(iberijski\)",
    'qu'    => 'quechua',
    'raj'   => 'rajasthani',
    'rap'   => "rapa\ nui",
    'rar'   => 'rarotonški',
    'rm'    => 'retoromanski',
    'rn'    => 'rundi',
    'ro'    => 'rumunjski',
    'roa'   => 'romanski',
    'rof'   => 'Rombo',
    'rom'   => 'romski',
    'ru'    => 'ruski',
    'rup'   => 'aromunski',
    'rw'    => 'kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'sanskrtski',
    'sad'   => 'sandawe',
    'sah'   => 'jakutski',
    'sai'   => "jezik\ južnoameričkih\ Indijanaca",
    'sal'   => 'salishan',
    'sam'   => "samarijanski\ aramejski",
    'saq'   => 'Samburu',
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sbp'   => 'Sangu',
    'sc'    => 'sardski',
    'scn'   => 'sicilijski',
    'sco'   => 'škotski',
    'sd'    => 'sindhi',
    'se'    => "južni\ sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkupski',
    'sem'   => 'semitic',
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sango',
    'sga'   => 'staroirski',
    'sgn'   => "znakovni\ jezik",
    'sh'    => "srpsko\-hrvatski",
    'shi'   => 'Tachelhit',
    'shn'   => 'shan',
    'si'    => 'singaleški',
    'sid'   => 'sidamo',
    'sio'   => 'siouan',
    'sit'   => "sino\-tibetski",
    'sk'    => 'slovački',
    'sl'    => 'slovenski',
    'sla'   => 'slavenski',
    'sm'    => 'samoanski',
    'sma'   => "sjeverni\ sami",
    'smi'   => 'sami',
    'smj'   => "lule\ sami",
    'smn'   => "inari\ sami",
    'sms'   => "skolt\ sami",
    'sn'    => 'shona',
    'snk'   => 'soninke',
    'so'    => 'somalski',
    'sog'   => 'sogdien',
    'son'   => 'songhai',
    'sq'    => 'albanski',
    'sr'    => 'srpski',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'svati',
    'ssa'   => "nilo\-saharski",
    'ssy'   => 'Saho',
    'st'    => 'sesotski',
    'su'    => 'sundanski',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumerski',
    'sv'    => 'švedski',
    'sw'    => 'svahili',
    'swb'   => 'komorski',
    'swc'   => "Congo\ Swahili",
    'syc'   => "klasični\ sirski",
    'syr'   => 'sirijski',
    'ta'    => 'tamilski',
    'tai'   => 'tajski',
    'te'    => 'telugu',
    'tem'   => 'temne',
    'teo'   => 'Teso',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tajik',
    'th'    => 'tajlandski',
    'ti'    => 'tigrinya',
    'tig'   => 'tigriški',
    'tiv'   => 'tiv',
    'tk'    => 'turkmenski',
    'tkl'   => 'tokelaunski',
    'tl'    => 'tagalog',
    'tlh'   => 'klingonski',
    'tli'   => 'tlingit',
    'tmh'   => 'tamashek',
    'tn'    => 'cvana',
    'to'    => 'tonga',
    'tog'   => "nyasa\ tonga",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turski',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatarski',
    'tum'   => 'tumbuka',
    'tup'   => 'tupi',
    'tut'   => 'altajski',
    'tvl'   => 'tuvaluanski',
    'tw'    => 'twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'tahićanski',
    'tyv'   => 'tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurtski',
    'ug'    => 'Ujgurski',
    'uga'   => 'ugaritski',
    'uk'    => 'ukrajinski',
    'umb'   => 'umbundu',
    'und'   => "nepoznati\ ili\ nevažeći\ jezik",
    'ur'    => 'urdski',
    'uz'    => 'uzbečki',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vijetnamski',
    'vo'    => 'volapük',
    'vot'   => 'votic',
    'vun'   => 'Vunjo',
    'wa'    => 'valonski',
    'wae'   => 'Walser',
    'wak'   => 'wakashan',
    'wal'   => 'walamo',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => 'lužički',
    'wo'    => 'wolof',
    'xal'   => 'kalmyk',
    'xh'    => 'xhosa',
    'xog'   => 'Soga',
    'yao'   => 'yao',
    'yap'   => 'japski',
    'yav'   => 'Yangben',
    'yi'    => 'jidiš',
    'yo'    => 'joruba',
    'ypk'   => 'yupik',
    'yue'   => 'kantonski',
    'za'    => 'zhuang',
    'zap'   => 'zapotec',
    'zbl'   => 'blissymbols',
    'zen'   => 'zenaga',
    'zh'    => 'kineski',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "bez\ jezičnog\ sadržaja",
    'zza'   => 'zazaki',
);

%Locales::DB::Language::hr::name_to_code = (
    'abhaski'                               => 'ab',
    'achinese'                              => 'ace',
    'acoli'                                 => 'ach',
    'adangme'                               => 'ada',
    'adigejski'                             => 'ady',
    'afarski'                               => 'aa',
    'afrihili'                              => 'afh',
    'afrikaans'                             => 'af',
    'aghem'                                 => 'agq',
    'ainu'                                  => 'ain',
    'akanski'                               => 'ak',
    'akkadian'                              => 'akk',
    'albanski'                              => 'sq',
    'aleutski'                              => 'ale',
    'algonquian'                            => 'alg',
    'altajski'                              => 'tut',
    'amharik'                               => 'am',
    'angika'                                => 'anp',
    'apaški'                               => 'apa',
    'aragonski'                             => 'an',
    'aramejski'                             => 'arc',
    'arapaho'                               => 'arp',
    'arapski'                               => 'ar',
    'araukanski'                            => 'arn',
    'arawak'                                => 'arw',
    'armenski'                              => 'hy',
    'aromunski'                             => 'rup',
    'asamski'                               => 'as',
    'asturijski'                            => 'ast',
    'asu'                                   => 'asa',
    'athapascan'                            => 'ath',
    'atsam'                                 => 'cch',
    'australski'                            => 'aus',
    'austrijskinjemački'                   => 'de_at',
    'austronezijski'                        => 'map',
    'avarski'                               => 'av',
    'avestan'                               => 'ae',
    'awadhi'                                => 'awa',
    'aymara'                                => 'ay',
    'azerski'                               => 'az',
    'bafia'                                 => 'ksf',
    'balinezijski'                          => 'ban',
    'baltički'                             => 'bat',
    'baluchi'                               => 'bal',
    'bambara'                               => 'bm',
    'bamileke'                              => 'bai',
    'banda'                                 => 'bad',
    'bantu'                                 => 'bnt',
    'basa'                                  => 'bas',
    'baskijski'                             => 'eu',
    'batak'                                 => 'btk',
    'baškirski'                            => 'ba',
    'beja'                                  => 'bej',
    'bemba'                                 => 'bem',
    'bena'                                  => 'bez',
    'bengalski'                             => 'bn',
    'berberski'                             => 'ber',
    'bezjezičnogsadržaja'                 => 'zxx',
    'bhojpuri'                              => 'bho',
    'bihari'                                => 'bh',
    'bikol'                                 => 'bik',
    'bini'                                  => 'bin',
    'bislama'                               => 'bi',
    'bjeloruski'                            => 'be',
    'blin'                                  => 'byn',
    'blissymbols'                           => 'zbl',
    'bodo'                                  => 'brx',
    'bosanski'                              => 'bs',
    'braj'                                  => 'bra',
    'brazilskiportugalski'                  => 'pt_br',
    'bretonski'                             => 'br',
    'bugarski'                              => 'bg',
    'buginski'                              => 'bug',
    'buriat'                                => 'bua',
    'burmanski'                             => 'my',
    'caddo'                                 => 'cad',
    'cayuga'                                => 'cay',
    'cebuano'                               => 'ceb',
    'centralmoroccotamazight'               => 'tzm',
    'chagatai'                              => 'chg',
    'chamic'                                => 'cmc',
    'chamorro'                              => 'ch',
    'chibcha'                               => 'chb',
    'chiga'                                 => 'cgg',
    'chinookžargon'                        => 'chn',
    'chipewyan'                             => 'chp',
    'choctaw'                               => 'cho',
    'chuukese'                              => 'chk',
    'chuvash'                               => 'cv',
    'colognian'                             => 'ksh',
    'congoswahili'                          => 'swc',
    'cree'                                  => 'cr',
    'creek'                                 => 'mus',
    'crkvenoslavenski'                      => 'cu',
    'cvana'                                 => 'tn',
    'dakotajezik'                           => 'dak',
    'danski'                                => 'da',
    'dargwa'                                => 'dar',
    'dayak'                                 => 'day',
    'delavarski'                            => 'del',
    'dinka'                                 => 'din',
    'divehi'                                => 'dv',
    'dogri'                                 => 'doi',
    'dogrib'                                => 'dgr',
    'donjonjemački'                        => 'nds',
    'dravidski'                             => 'dra',
    'duala'                                 => 'dua',
    'dyula'                                 => 'dyu',
    'dzongkha'                              => 'dz',
    'efik'                                  => 'efi',
    'ekajuk'                                => 'eka',
    'elamitski'                             => 'elx',
    'embu'                                  => 'ebu',
    'engleski'                              => 'en',
    "engleski\,srednji"                     => 'enm',
    'engleskiamerički'                     => 'en_us',
    'engleskiaustralski'                    => 'en_au',
    'engleskibritanski'                     => 'en_gb',
    'engleskinaosnovikreolskogilipidgin'    => 'cpe',
    'esperanto'                             => 'eo',
    'estonijski'                            => 'et',
    'ewe'                                   => 'ee',
    'ewondo'                                => 'ewo',
    'fang'                                  => 'fan',
    'fanti'                                 => 'fat',
    'faroanski'                             => 'fo',
    'fenički'                              => 'phn',
    'fidžijski'                            => 'fj',
    'filipino'                              => 'fil',
    'filipinski'                            => 'phi',
    'finski'                                => 'fi',
    'flamanski'                             => 'nl_be',
    'fon'                                   => 'fon',
    'francuski'                             => 'fr',
    "francuski\,srednji"                    => 'frm',
    'francuskinaosnovikreolskogilipidgin'   => 'cpf',
    'friulski'                              => 'fur',
    'frizijski'                             => 'fy',
    'fulah'                                 => 'ff',
    'ga'                                    => 'gaa',
    'galicijski'                            => 'gl',
    'ganda'                                 => 'lg',
    'gayo'                                  => 'gay',
    'gbaya'                                 => 'gba',
    'germanski'                             => 'gem',
    'gilbertski'                            => 'gil',
    'gondi'                                 => 'gon',
    'gornjolužički'                       => 'hsb',
    'gornjonjemačkišvicarski'             => 'de_ch',
    'gorontalo'                             => 'gor',
    'gothic'                                => 'got',
    'grebo'                                 => 'grb',
    'gruzijski'                             => 'ka',
    'grčki'                                => 'el',
    'guarani'                               => 'gn',
    'gujarati'                              => 'gu',
    'gusii'                                 => 'guz',
    'gwichin'                               => 'gwi',
    'haidi'                                 => 'hai',
    'hausa'                                 => 'ha',
    'havajski'                              => 'haw',
    'hebrejski'                             => 'he',
    'herero'                                => 'hz',
    'hetitski'                              => 'hit',
    'hiligaynon'                            => 'hil',
    'himachali'                             => 'him',
    'hindski'                               => 'hi',
    'hirimotu'                              => 'ho',
    'hmong'                                 => 'hmn',
    'hrvatski'                              => 'hr',
    'hupa'                                  => 'hup',
    'iban'                                  => 'iba',
    'iberskišpanjolski'                    => 'es_es',
    'ido'                                   => 'io',
    'igbo'                                  => 'ig',
    'ijo'                                   => 'ijo',
    'iloko'                                 => 'ilo',
    'inarisami'                             => 'smn',
    'indijski'                              => 'inc',
    'indoeuropski'                          => 'ine',
    'indonezijski'                          => 'id',
    'ingušetski'                           => 'inh',
    'interligua'                            => 'ie',
    'interlingua'                           => 'ia',
    'inuktitut'                             => 'iu',
    'inupiaq'                               => 'ik',
    'iranski'                               => 'ira',
    'irokeški'                             => 'iro',
    'irski'                                 => 'ga',
    "irski\,srednji"                        => 'mga',
    'islandski'                             => 'is',
    'istočnofrizijski'                     => 'frs',
    'jakutski'                              => 'sah',
    'japanski'                              => 'ja',
    'japski'                                => 'yap',
    'javanski'                              => 'jv',
    'jezikjužnoameričkihindijanaca'       => 'sai',
    'jeziksjevernoameričkihindijanaca'     => 'nai',
    'jeziksrednjoameričkihindijanaca'      => 'cai',
    'jidiš'                                => 'yi',
    'jolafonyi'                             => 'dyo',
    'joruba'                                => 'yo',
    'judejskoarapski'                       => 'jrb',
    'judejskoperzijski'                     => 'jpr',
    'južnialtai'                           => 'alt',
    'južnindebele'                         => 'nr',
    'južnisami'                            => 'se',
    'kabardian'                             => 'kbd',
    'kabuverdianu'                          => 'kea',
    'kabyle'                                => 'kab',
    'kachin'                                => 'kac',
    'kaje'                                  => 'kaj',
    'kalaallisut'                           => 'kl',
    'kalenjin'                              => 'kln',
    'kalmyk'                                => 'xal',
    'kamba'                                 => 'kam',
    'kanadskiengleski'                      => 'en_ca',
    'kanadskifrancuski'                     => 'fr_ca',
    'kannadski'                             => 'kn',
    'kantonski'                             => 'yue',
    'kanuri'                                => 'kr',
    'karachaybalkar'                        => 'krc',
    'karakalpak'                            => 'kaa',
    'karelijski'                            => 'krl',
    'karen'                                 => 'kar',
    'karipski'                              => 'car',
    'katalonski'                            => 'ca',
    'kavkaski'                              => 'cau',
    'kawi'                                  => 'kaw',
    'kazaški'                              => 'kk',
    'kašmirski'                            => 'ks',
    'kašupski'                             => 'csb',
    'keltski'                               => 'cel',
    'khasi'                                 => 'kha',
    'khotanese'                             => 'kho',
    'kikuyu'                                => 'ki',
    'kimbundu'                              => 'kmb',
    'kineski'                               => 'zh',
    'kinyarwanda'                           => 'rw',
    'kirgiški'                             => 'ky',
    'klasičninewari'                       => 'nwc',
    'klasičnisirski'                       => 'syc',
    'klingonski'                            => 'tlh',
    'kmerski'                               => 'km',
    'književninorveški'                   => 'nb',
    'kojsanski'                             => 'khi',
    'komi'                                  => 'kv',
    'komorski'                              => 'swb',
    'kongo'                                 => 'kg',
    'konkani'                               => 'kok',
    'koptski'                               => 'cop',
    'korejski'                              => 'ko',
    'kornski'                               => 'kw',
    'koro'                                  => 'kfo',
    'korzički'                             => 'co',
    'koyraborosenni'                        => 'ses',
    'koyrachiini'                           => 'khq',
    'kpelle'                                => 'kpe',
    'kreolski'                              => 'ht',
    'kreolskiilipidgin'                     => 'crp',
    'kreolskiilipidginnaosnoviportugalskog' => 'cpp',
    'krimskiturski'                         => 'crh',
    'kru'                                   => 'kro',
    'kuanyama'                              => 'kj',
    'kumyk'                                 => 'kum',
    'kurdski'                               => 'ku',
    'kuruški'                              => 'kru',
    'kutenai'                               => 'kut',
    'kušitski'                             => 'cus',
    'kwasio'                                => 'nmg',
    'ladino'                                => 'lad',
    'lahnda'                                => 'lah',
    'lamba'                                 => 'lam',
    'langi'                                 => 'lag',
    'laoski'                                => 'lo',
    'latinski'                              => 'la',
    'latvijski'                             => 'lv',
    'lezgiški'                             => 'lez',
    'limburgish'                            => 'li',
    'lingala'                               => 'ln',
    'litvanski'                             => 'lt',
    'lojban'                                => 'jbo',
    'lozi'                                  => 'loz',
    'lubakatanga'                           => 'lu',
    'lubalulua'                             => 'lua',
    'luiseno'                               => 'lui',
    'luksemburški'                         => 'lb',
    'lulesami'                              => 'smj',
    'lunda'                                 => 'lun',
    'luo'                                   => 'luo',
    'lushai'                                => 'lus',
    'luyia'                                 => 'luy',
    'lužički'                             => 'wen',
    'lužičkosrpski'                       => 'dsb',
    'machame'                               => 'jmc',
    'madurski'                              => 'mad',
    'magahi'                                => 'mag',
    'maithili'                              => 'mai',
    'majanski'                              => 'myn',
    'makasar'                               => 'mak',
    'makedonski'                            => 'mk',
    'makhuwameetto'                         => 'mgh',
    'makonde'                               => 'kde',
    'malajalamski'                          => 'ml',
    'malajski'                              => 'ms',
    'malgaški'                             => 'mg',
    'malteški'                             => 'mt',
    'mandar'                                => 'mdr',
    'mandingo'                              => 'man',
    'mandžurski'                           => 'mnc',
    'manipurski'                            => 'mni',
    'manobo'                                => 'mno',
    'manx'                                  => 'gv',
    'maorski'                               => 'mi',
    'marathi'                               => 'mr',
    'mari'                                  => 'chm',
    'marwari'                               => 'mwr',
    'maršalski'                            => 'mh',
    'masajski'                              => 'mas',
    'mađarski'                             => 'hu',
    'mende'                                 => 'men',
    'meru'                                  => 'mer',
    'micmac'                                => 'mic',
    'minangkabau'                           => 'min',
    'mirandski'                             => 'mwl',
    'mkh'                                   => 'mkh',
    'mohawk'                                => 'moh',
    'moksha'                                => 'mdf',
    'moldavski'                             => 'mo',
    'mongo'                                 => 'lol',
    'mongolski'                             => 'mn',
    'mordvinski'                            => 'myv',
    'morisyen'                              => 'mfe',
    'mossi'                                 => 'mos',
    'munda'                                 => 'mun',
    'mundang'                               => 'mua',
    'nahuatl'                               => 'nah',
    'nama'                                  => 'naq',
    'napolitanski'                          => 'nap',
    'naurski'                               => 'kos',
    'nauru'                                 => 'na',
    'navajo'                                => 'nv',
    'ndonga'                                => 'ng',
    'nepalski'                              => 'ne',
    'nepoznatiilinevažećijezik'           => 'und',
    'newari'                                => 'new',
    'nias'                                  => 'nia',
    'nigerskokordofanski'                   => 'nic',
    'nilosaharski'                          => 'ssa',
    'niujski'                               => 'niu',
    'nizozemski'                            => 'nl',
    "nizozemski\,srednji"                   => 'dum',
    'njemački'                             => 'de',
    "njemački\,srednjivisoki"              => 'gmh',
    'nko'                                   => 'nqo',
    'nogajski'                              => 'nog',
    'norveški'                             => 'no',
    'novonorveški'                         => 'nn',
    'nubijski'                              => 'nub',
    'nuer'                                  => 'nus',
    'nyamwezi'                              => 'nym',
    'nyanja'                                => 'ny',
    'nyankole'                              => 'nyn',
    'nyasatonga'                            => 'tog',
    'nyoro'                                 => 'nyo',
    'nzima'                                 => 'nzi',
    'ojibwa'                                => 'oj',
    'okcitanski'                            => 'oc',
    'orijski'                               => 'or',
    'oromski'                               => 'om',
    'osage'                                 => 'osa',
    'osetski'                               => 'os',
    'ostaliafričkoazijski'                 => 'afa',
    'ostalijezici'                          => 'mis',
    'otomijski'                             => 'oto',
    'pahlavi'                               => 'pal',
    'palauanski'                            => 'pau',
    'pali'                                  => 'pi',
    'pampanga'                              => 'pam',
    'pangasinan'                            => 'pag',
    'papiamento'                            => 'pap',
    'papuanski'                             => 'paa',
    'perzijski'                             => 'fa',
    'pohnpeian'                             => 'pon',
    'poljski'                               => 'pl',
    'portugalski'                           => 'pt',
    'portugalskiiberijski'                  => 'pt_pt',
    'prakrit'                               => 'pra',
    'punjabi'                               => 'pa',
    'puštu'                                => 'ps',
    'quechua'                               => 'qu',
    'rajasthani'                            => 'raj',
    'rapanui'                               => 'rap',
    'rarotonški'                           => 'rar',
    'retoromanski'                          => 'rm',
    'romanski'                              => 'roa',
    'rombo'                                 => 'rof',
    'romski'                                => 'rom',
    'rumunjski'                             => 'ro',
    'rundi'                                 => 'rn',
    'ruski'                                 => 'ru',
    'rwa'                                   => 'rwk',
    'saho'                                  => 'ssy',
    'salishan'                              => 'sal',
    'samarijanskiaramejski'                 => 'sam',
    'samburu'                               => 'saq',
    'sami'                                  => 'smi',
    'samoanski'                             => 'sm',
    'sandawe'                               => 'sad',
    'sango'                                 => 'sg',
    'sangu'                                 => 'sbp',
    'sanskrtski'                            => 'sa',
    'santali'                               => 'sat',
    'sardski'                               => 'sc',
    'sasak'                                 => 'sas',
    'selkupski'                             => 'sel',
    'semitic'                               => 'sem',
    'sena'                                  => 'seh',
    'seneca'                                => 'see',
    'serer'                                 => 'srr',
    'sesotski'                              => 'st',
    'shambala'                              => 'ksb',
    'shan'                                  => 'shn',
    'shona'                                 => 'sn',
    'sichuanyi'                             => 'ii',
    'sicilijski'                            => 'scn',
    'sidamo'                                => 'sid',
    'siksika'                               => 'bla',
    'sindhi'                                => 'sd',
    'singaleški'                           => 'si',
    'sinotibetski'                          => 'sit',
    'siouan'                                => 'sio',
    'sirijski'                              => 'syr',
    'sjevernindebele'                       => 'nd',
    'sjevernisami'                          => 'sma',
    'sjevernisotho'                         => 'nso',
    'sjevernofrizijski'                     => 'frr',
    'skoltsami'                             => 'sms',
    'slave'                                 => 'den',
    'slavenski'                             => 'sla',
    'slovački'                             => 'sk',
    'slovenski'                             => 'sl',
    'soga'                                  => 'xog',
    'sogdien'                               => 'sog',
    'somalski'                              => 'so',
    'songhai'                               => 'son',
    'soninke'                               => 'snk',
    'sranantongo'                           => 'srn',
    'srpski'                                => 'sr',
    'srpskohrvatski'                        => 'sh',
    'staroegipatski'                        => 'egy',
    'staroengleski'                         => 'ang',
    'staroetiopski'                         => 'gez',
    'starofrancuski'                        => 'fro',
    'starogrčki'                           => 'grc',
    'staroirski'                            => 'sga',
    "staronjemački\,visoki"                => 'goh',
    'staronorveški'                        => 'non',
    'staroperzijski'                        => 'peo',
    'staroprovansalski'                     => 'pro',
    'sukuma'                                => 'suk',
    'sumerski'                              => 'sux',
    'sundanski'                             => 'su',
    'susu'                                  => 'sus',
    'svahili'                               => 'sw',
    'svati'                                 => 'ss',
    'tachelhit'                             => 'shi',
    'tagalog'                               => 'tl',
    'tahićanski'                           => 'ty',
    'taita'                                 => 'dav',
    'tajik'                                 => 'tg',
    'tajlandski'                            => 'th',
    'tajski'                                => 'tai',
    'talijanski'                            => 'it',
    'tamashek'                              => 'tmh',
    'tamilski'                              => 'ta',
    'taroko'                                => 'trv',
    'tasawaq'                               => 'twq',
    'tatarski'                              => 'tt',
    'telugu'                                => 'te',
    'temne'                                 => 'tem',
    'tereno'                                => 'ter',
    'teso'                                  => 'teo',
    'tetum'                                 => 'tet',
    'tibetanski'                            => 'bo',
    'tigrinya'                              => 'ti',
    'tigriški'                             => 'tig',
    'tiv'                                   => 'tiv',
    'tlingit'                               => 'tli',
    'tokelaunski'                           => 'tkl',
    'tokpisin'                              => 'tpi',
    'tonga'                                 => 'to',
    'tsimshian'                             => 'tsi',
    'tsonga'                                => 'ts',
    'tumbuka'                               => 'tum',
    'tupi'                                  => 'tup',
    'turkmenski'                            => 'tk',
    'turski'                                => 'tr',
    'turskiotomanski'                       => 'ota',
    'tuvaluanski'                           => 'tvl',
    'tuvinian'                              => 'tyv',
    'twi'                                   => 'tw',
    'tyap'                                  => 'kcg',
    'udmurtski'                             => 'udm',
    'ugaritski'                             => 'uga',
    'ugrofinskijezik'                       => 'fiu',
    'ujgurski'                              => 'ug',
    'ukrajinski'                            => 'uk',
    'umbundu'                               => 'umb',
    'umjetnijezik'                          => 'art',
    'urdski'                                => 'ur',
    'uzbečki'                              => 'uz',
    'vai'                                   => 'vai',
    'valonski'                              => 'wa',
    'velški'                               => 'cy',
    'venda'                                 => 've',
    'vijetnamski'                           => 'vi',
    'višejezika'                           => 'mul',
    'volapük'                              => 'vo',
    'votic'                                 => 'vot',
    'vunjo'                                 => 'vun',
    'wakashan'                              => 'wak',
    'walamo'                                => 'wal',
    'walser'                                => 'wae',
    'waray'                                 => 'war',
    'washo'                                 => 'was',
    'wolof'                                 => 'wo',
    'xhosa'                                 => 'xh',
    'yangben'                               => 'yav',
    'yao'                                   => 'yao',
    'yupik'                                 => 'ypk',
    'zande'                                 => 'znd',
    'zapotec'                               => 'zap',
    'zarma'                                 => 'dje',
    'zazaki'                                => 'zza',
    'zenaga'                                => 'zen',
    'zhuang'                                => 'za',
    'znakovnijezik'                         => 'sgn',
    'zulu'                                  => 'zu',
    'zuni'                                  => 'zun',
    'čejenski'                             => 'chy',
    'čeroki'                               => 'chr',
    'čečenski'                            => 'ce',
    'češki'                               => 'cs',
    'škotski'                              => 'sco',
    'škotskigalski'                        => 'gd',
    'španjolski'                           => 'es',
    'švedski'                              => 'sv',
    'švicarskifrancuski'                   => 'fr_ch',
    'švicarskinjemački'                   => 'gsw',
);

1;
