/*
    libmaus2
    Copyright (C) 2009-2019 German Tischler
    Copyright (C) 2011-2013 Genome Research Limited

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#if ! defined(LIBMAUS2_CLIENTSOCKET_HPP)
#define LIBMAUS2_CLIENTSOCKET_HPP

#include <libmaus2/network/SocketBase.hpp>

namespace libmaus2
{
	namespace network
	{
		struct ClientSocket : public SocketBase
		{
			typedef ClientSocket this_type;
			typedef ::libmaus2::util::unique_ptr<this_type>::type unique_ptr_type;

			ClientSocket(unsigned short port, char const * hostname)
			: SocketBase()
			{
				setAddress(hostname, remaddr);
				remaddr.sin_port = htons(port);
				remaddrset = true;

				while ( ::connect(getFD(),reinterpret_cast<const sockaddr *>(&remaddr),sizeof(remaddr)) != 0 )
				{
					int const error = errno;

					switch ( error )
					{
						case EINTR:
						case EAGAIN:
							break;
						default:
						{
							::libmaus2::exception::LibMausException se;
							se.getStream() << "ClientSocket: connect() failed with error " << strerror(error) << std::endl;
							se.finish();
							throw se;
						}
					}
				}
			}

			static SocketBase::unique_ptr_type baseCast(ClientSocket::unique_ptr_type & C)
			{
				int const fd = C->getFD();
				C->releaseFD();

				try
				{
					SocketBase::unique_ptr_type ptr ( new SocketBase(fd) );
					return ptr;
				}
				catch(...)
				{
					::close(fd);
					throw;
				}
			}

			static SocketBase::unique_ptr_type baseAlloc(unsigned short const port, char const * const hostname)
			{
				ClientSocket::unique_ptr_type ptr ( new ClientSocket(port,hostname) );
				SocketBase::unique_ptr_type baseptr = baseCast(ptr);
				return baseptr;
			}

			static SocketBase::unique_ptr_type baseAlloc(unsigned short const port, std::string const & hostname)
			{
				SocketBase::unique_ptr_type baseptr = baseAlloc(port,hostname.c_str());
				return baseptr;
			}
		};
	}
}
#endif
