/*
    libmaus2
    Copyright (C) 2009-2013 German Tischler
    Copyright (C) 2011-2013 Genome Research Limited

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#if ! defined(LIBMAUS2_PARALLEL_STDSEMAPHORE_HPP)
#define LIBMAUS2_PARALLEL_STDSEMAPHORE_HPP

#include <libmaus2/exception/LibMausException.hpp>

#include <ctime>
#include <cerrno>
#include <cstring>
#include <stdexcept>

#include <condition_variable>
#include <mutex>
#include <atomic>
#include <chrono>

namespace libmaus2
{
	namespace parallel
	{
                struct StdSemaphore
                {
                	typedef StdSemaphore this_type;
                	typedef libmaus2::util::unique_ptr<this_type>::type unique_ptr_type;
                	typedef libmaus2::util::shared_ptr<this_type>::type shared_ptr_type;

                	std::condition_variable condvar;
                	std::mutex mutex;
                	std::atomic<uint64_t> count;

			private:
			StdSemaphore(StdSemaphore const &);
			StdSemaphore operator=(StdSemaphore const &);

			public:
                        StdSemaphore();
                        ~StdSemaphore();

                        void post();
                        void wait();
                        bool trywait();
                        bool timedWait();
                };
	}
}
#endif
