#include "stdio.h"
#include "windows.h"
#include "MediaInfoDLL/MediaInfoDLL.h"
#include "MediaInfo/MediaInfo_Events.h"
#include <stdarg.h>
#ifdef MEDIAINFO_REGRESSION_TEST
    FILE* F;
    const char* F_FileName;
    #define echo0(_format) fprintf(F, _format)
    #define echo1(_format, Arg1) fprintf(F, _format, Arg1)
    #define echo2(_format, Arg1, Arg2) fprintf(F, _format, Arg1, Arg2)
    #define echo4(_format, Arg1, Arg2, Arg3, Arg4) fprintf(F, _format, Arg1, Arg2, Arg3, Arg4)
    #define wecho0(_format) //wfprintf(F, _format)
    #define wecho1(_format, Arg1) //wfprintf(F, _format, Arg1)
    #define wecho4(_format, Arg1, Arg2, Arg3, Arg4) //wfprintf(F, _format, Arg1, Arg2, Arg3, Arg4)
#else //MEDIAINFO_REGRESSION_TEST
    #define echo0(_format) printf(_format)
    #define echo1(_format, Arg1) printf(_format, Arg1)
    #define echo2(_format, Arg1, Arg2) printf(_format, Arg1, Arg2)
    #define echo4(_format, Arg1, Arg2, Arg3, Arg4) printf(_format, Arg1, Arg2, Arg3, Arg4)
    #define wecho0(_format) wprintf(_format)
    #define wecho1(_format, Arg1) wprintf(_format, Arg1)
    #define wecho4(_format, Arg1, Arg2, Arg3, Arg4) wfprintf(F, _format, Arg1, Arg2, Arg3, Arg4)) wprintf(_format, Arg1wfprintf(F, _format, Arg1, Arg2, Arg3, Arg4))
#endif //MEDIAINFO_REGRESSION_TEST

/***************************************************************************/
/* Some examples of event handling                                         */
/***************************************************************************/

/*You can define your own structure*/
struct UserHandle_struct
{
    void* MI;
    int Option_DCA;
};

void MpegTs_PID_Reserved_0 (struct MediaInfo_Event_MpegTs_PID_Reserved_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1001\n");
    else
        echo0("MpegTs, Reserved PID in use\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
}

void MpegTs_continuity_counter_Check_NoPayload_0 (struct MediaInfo_Event_MpegTs_continuity_counter_Check_NoPayload_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1002\n");
    else
        echo0("MpegTs, no payload, continuity_counter shall not be incremented 1\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
}

void MpegTs_continuity_counter_Check_Payload_0 (struct MediaInfo_Event_MpegTs_continuity_counter_Check_Payload_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1003\n");
    else
        echo0("MpegTs, payload, continuity_counter shall be incremented by 1\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
}

void MpegTs_splice_type_Reserved_0 (struct MediaInfo_Event_MpegTs_splice_type_Reserved_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1004\n");
    else
        echo0("MpegTs, Reserved value found in splice_type field\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    splice_type=%01x\n", Event->splice_type);
}

void MpegTs_profile_level_NoMatch_0 (struct MediaInfo_Event_MpegTs_profile_level_NoMatch_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1005\n");
    else
        echo0("MpegTs, he container stream descriptor does not match the actual codec\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    FromDescriptor=%02x,", Event->profile_and_level_indication_FromDescriptor);
    echo1(   " FromStream=%02x\n", Event->profile_and_level_indication_FromStream);
}

void MpegTs_SampleRate_NotConstant_Audio_0 (struct MediaInfo_Event_MpegTs_SampleRate_NotConstant_Audio_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1006\n");
    else
        echo0("MpegTs, Sample rate should be constant\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    SampleRate_Before=%i,", Event->SampleRate_Before);
    echo1(   " SampleRate_After=%i\n", Event->SampleRate_After);
}

void MpegTs_SampleRate_NotConstant_Video_0 (struct MediaInfo_Event_MpegTs_SampleRate_NotConstant_Video_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1007\n");
    else
        echo0("MpegTs, Sample rate should be constant\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    SampleRate_Before=%i,", Event->SampleRate_Before);
    echo1(   " SampleRate_After=%i\n", Event->SampleRate_After);
}

void MpegTs_OutOfSync_0 (struct MediaInfo_Event_MpegTs_OutOfSync_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1008\n");
    else
        echo0("MpegTs, Out of Sync\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
}

void MpegTs_End_0 (struct MediaInfo_Event_MpegTs_End_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.013\n");
    else
        echo0("MpegTs, End\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    Stuffing bytes=%lu\n", Event->StuffingBytes);
}

void MpegTs_continuity_counter_Duplicate_0 (struct MediaInfo_Event_MpegTs_continuity_counter_Duplicate_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #????\n");
    else
        echo0("MpegTs, Duplicate packets are more than 2 times sent\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
}

void MpegTs_TS_program_map_section_NonExistentPID_0 (struct MediaInfo_Event_MpegTs_TS_program_map_section_NonExistentPID_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1011\n");
    else
        echo0("MpegTs, The PMT contains a PID which points to a non-existent stream\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    program_number=%04x\n", Event->program_number);
}

void MpegTs_transport_error_indicator_Check_0 (struct MediaInfo_Event_MpegTs_transport_error_indicator_Check_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1012\n");
    else
        echo0("MpegTs, transport_error_indicator is set\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
}

void MpegTs_payload_unit_start_indicator_0 (struct MediaInfo_Event_MpegTs_payload_unit_start_indicator_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, payload_unit_start_indicator\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    adaptation_field_control=%x\n", Event->adaptation_field_control);
}

void MpegTs_transport_scrambling_control_0 (struct MediaInfo_Event_MpegTs_transport_scrambling_control_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1019/1020, transport_scrambling_control\n");
    else
        echo0("MpegTs, transport_scrambling_control\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    transport_scrambling_control=%x\n", Event->transport_scrambling_control);
}

void MpegTs_adaptation_field_control_0 (struct MediaInfo_Event_MpegTs_adaptation_field_control_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, adaptation_field_control\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    adaptation_field_control=%x\n", Event->adaptation_field_control);
}

void MpegTs_duplicate_packet_0 (struct MediaInfo_Event_MpegTs_duplicate_packet_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, duplicate_packet\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    adaptation_field_control=%x\n", Event->adaptation_field_control);
}

void MpegTs_adaptation_field_length_0 (struct MediaInfo_Event_MpegTs_adaptation_field_length_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, adaptation_field_length\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    adaptation_field_length=%x\n", Event->adaptation_field_length);
}

void MpegTs_random_access_indicator_0 (struct MediaInfo_Event_MpegTs_random_access_indicator_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, random_access_indicator\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    adaptation_field_length=%x\n", Event->adaptation_field_length);
}

void MpegTs_random_access_PCR_0 (struct MediaInfo_Event_MpegTs_random_access_PCR_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, random_access_PCR\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
}

void MpegTs_random_access_PTS_0 (struct MediaInfo_Event_MpegTs_random_access_PTS_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, random_access_PTS\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
}

void MpegTs_elementary_stream_priority_indicator_0 (struct MediaInfo_Event_MpegTs_elementary_stream_priority_indicator_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, elementary_stream_priority_indicator\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void MpegTs_PCR_OPCR_flags_0 (struct MediaInfo_Event_MpegTs_PCR_OPCR_flags_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, PCR_OPCR_flags\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
}

void MpegTs_transport_private_data_0 (struct MediaInfo_Event_MpegTs_transport_private_data_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, transport_private_data\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
}

void MpegTs_sections_section_length_0 (struct MediaInfo_Event_MpegTs_sections_section_length_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, sections_section_length\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_length=%s\n", Event->section_length);
}

void MpegTs_sections_current_next_indicator_0 (struct MediaInfo_Event_MpegTs_sections_current_next_indicator_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, sections_current_next_indicator\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
}

void MpegTs_sections_CRC_32_0 (struct MediaInfo_Event_MpegTs_sections_CRC_32_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7604 sections_CRC_32\n");
    else
        echo0("MpegTs, sections_CRC_32\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    table_id=%02x\n", Event->table_id);
    echo1("    CRC_32=%08x,", Event->CRC_32);
    echo1(   " CRC_32_Expected=%08x\n", Event->CRC_32_Expected);
}

void MpegTs_sections_AfterCRC_32_0 (struct MediaInfo_Event_MpegTs_sections_AfterCRC_32_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, sections_AfterCRC_32\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\02x", Event->NextByte);
}

void MpegTs_sections_NextPacketIssue_0 (struct MediaInfo_Event_MpegTs_sections_NextPacketIssue_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, sections_NextPacketIssue\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%i\n", Event->payload_unit_start_indicator);
    echo1("    pointer_field=%02x\n", Event->pointer_field);
}

void MpegTs_PAT_table_id_0 (struct MediaInfo_Event_MpegTs_PAT_table_id_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1019 PAT_table_id\n");
    else
        echo0("MpegTs, PAT_table_id\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    table_id=%02x\n", Event->table_id);
}

void MpegTs_PAT_section_syntax_indicator_0 (struct MediaInfo_Event_MpegTs_PAT_section_syntax_indicator_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1019, PAT_section_syntax_indicator\n");
    else
        echo0("MpegTs, PAT_section_syntax_indicator\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
}

void MpegTs_PAT_section_length_0 (struct MediaInfo_Event_MpegTs_PAT_section_length_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1019, PAT_section_length\n");
    else
        echo0("MpegTs, \n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    section_length=%04x\n", Event->section_length);
}

void MpegTs_PAT_transport_stream_id_0 (struct MediaInfo_Event_MpegTs_PAT_transport_stream_id_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1019, PAT_transport_stream_id\n");
    else
        echo0("MpegTs, PAT_transport_stream_id\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    transport_stream_id=%04x,", Event->transport_stream_id);
    echo1(   " transport_stream_id_Expected=%04x\n", Event->transport_stream_id_Expected);
}

void MpegTs_PAT_version_number_0 (struct MediaInfo_Event_MpegTs_PAT_version_number_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1019, PAT_version_number\n");
    else
        echo0("MpegTs, PAT_version_number\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    version_number=%04x,", Event->version_number);
    echo1(   " version_number_Expected=%04x\n", Event->version_number_Expected);
}

void MpegTs_PAT_program_number_0 (struct MediaInfo_Event_MpegTs_PAT_program_number_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1019, PAT_program_number\n");
    else
        echo0("MpegTs, PAT_program_number\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    program_number=%04x\n", Event->program_number);
}

void MpegTs_PAT_network_PID_0 (struct MediaInfo_Event_MpegTs_PAT_network_PID_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1019, PAT_network_PID\n");
    else
        echo0("MpegTs, PAT_network_PID\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    network_PID=%04x\n", Event->network_PID);
}

void MpegTs_PAT_program_PID_0 (struct MediaInfo_Event_MpegTs_PAT_program_PID_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1019, PAT_program_PID\n");
    else
        echo0("MpegTs, PAT_program_PID\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    program_PID=%04x\n", Event->program_PID);
}

void MpegTs_PAT_table_id_OtherPIDs_0 (struct MediaInfo_Event_MpegTs_PAT_table_id_OtherPIDs_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1019, PAT_table_id_OtherPIDs\n");
    else
        echo0("MpegTs, PAT_table_id_OtherPIDs\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
}

void MpegTs_PMT_table_id_0 (struct MediaInfo_Event_MpegTs_PMT_table_id_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1020, PMT_table_id\n");
    else
        echo0("MpegTs, PMT_table_id\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    table_id=%02x\n", Event->table_id);
}

void MpegTs_PMT_section_syntax_indicator_0 (struct MediaInfo_Event_MpegTs_PMT_section_syntax_indicator_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1020, PMT_section_syntax_indicator\n");
    else
        echo0("MpegTs, PMT_section_syntax_indicator\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
}

void MpegTs_PMT_Zero_0 (struct MediaInfo_Event_MpegTs_PMT_Zero_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1020, PMT_Zero\n");
    else
        echo0("MpegTs, PMT_Zero\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
}

void MpegTs_PMT_section_length_0 (struct MediaInfo_Event_MpegTs_PMT_section_length_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1020, PMT_section_length\n");
    else
        echo0("MpegTs, PMT_section_length\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    section_length=%04x\n", Event->section_length);
}

void MpegTs_PMT_program_number_0 (struct MediaInfo_Event_MpegTs_PMT_program_number_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1020, PMT_program_number\n");
    else
        echo0("MpegTs, PMT_program_number\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    program_number=%04x\n", Event->program_number);
}

void MpegTs_PMT_PCR_PID_0 (struct MediaInfo_Event_MpegTs_PMT_PCR_PID_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1020, PMT_PCR_PID\n");
    else
        echo0("MpegTs, PMT_PCR_PID\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
}

void MpegTs_PMT_program_info_length_0 (struct MediaInfo_Event_MpegTs_PMT_program_info_length_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1020, PMT_program_info_length\n");
    else
        echo0("MpegTs, PMT_program_info_length\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    program_info_length=%04x\n", Event->program_info_length);
}

void MpegTs_PMT_descriptor_0 (struct MediaInfo_Event_MpegTs_PMT_descriptor_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1020, PMT_descriptor\n");
    else
        echo0("MpegTs, PMT_descriptor\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    descriptor_tag=%02x\n", Event->descriptor_tag);
}

void MpegTs_PMT_stream_type_0 (struct MediaInfo_Event_MpegTs_PMT_stream_type_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1020, PMT_stream_type\n");
    else
        echo0("MpegTs, PMT_stream_type\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    stream_type=%04x,", Event->stream_type);
    echo1(   " stream_type_Expected=%04x\n", Event->stream_type_Expected);
}

void MpegTs_PMT_elementary_PID_0 (struct MediaInfo_Event_MpegTs_PMT_elementary_PID_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1020, PMT_elementary_PID\n");
    else
        echo0("MpegTs, PMT_elementary_PID\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    elementary_PID=%04x\n", Event->elementary_PID);
}

void MpegTs_PMT_ES_info_length_0 (struct MediaInfo_Event_MpegTs_PMT_ES_info_length_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1020, PMT_ES_info_length\n");
    else
        echo0("MpegTs, PMT_ES_info_length\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    elementary_PID=%04x,", Event->elementary_PID);
    echo1(   " ES_info_length=%04x\n", Event->ES_info_length);
}

void MpegTs_PMT_ES_info_descriptor_0 (struct MediaInfo_Event_MpegTs_PMT_ES_info_descriptor_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1020, PMT_ES_info_descriptor\n");
    else
        echo0("MpegTs, PMT_ES_info_descriptor\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    elementary_PID=%04x,", Event->elementary_PID);
    echo1(   " descriptor_tag=%0x\n", Event->descriptor_tag);
}

void MpegTs_CAT_PID1_0 (struct MediaInfo_Event_MpegTs_CAT_PID1_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, CAT_PID1\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
}

void MpegTs_CAT_table_id_0 (struct MediaInfo_Event_MpegTs_CAT_table_id_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, CAT_table_id\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    table_id=%02x\n", Event->table_id);
}

void MpegTs_CAT_section_syntax_indicator_0 (struct MediaInfo_Event_MpegTs_CAT_section_syntax_indicator_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, CAT_section_syntax_indicator\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
}

void MpegTs_CAT_Zero_0 (struct MediaInfo_Event_MpegTs_CAT_Zero_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, CAT_Zero\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
}

void MpegTs_CAT_section_length_0 (struct MediaInfo_Event_MpegTs_CAT_section_length_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, CAT_section_length\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    section_length=%04x\n", Event->section_length);
}

void MpegTs_CAT_version_number_0 (struct MediaInfo_Event_MpegTs_CAT_version_number_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, CAT_version_number\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    version_number=%04x,", Event->version_number);
    echo1(   " version_number_Expected=%04x\n", Event->version_number_Expected);
}

void MpegTs_CAT_descriptor_0 (struct MediaInfo_Event_MpegTs_CAT_descriptor_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, CAT_descriptor\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    descriptor_tag=%02x\n", Event->descriptor_tag);
}

void MpegTs_NIT_table_id_0 (struct MediaInfo_Event_MpegTs_NIT_table_id_0* Event, int DCA)
{
    if (DCA)
        return; //No DCA need
    else
        echo0("MpegTs, NIT_table_id\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    table_id=%02x\n", Event->table_id);
}

void MpegTs_descriptor_length_0 (struct MediaInfo_Event_MpegTs_descriptor_length_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1021, descriptor_length\n");
    else
        echo0("MpegTs, descriptor_length\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    table_id=%02x\n", Event->table_id);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    elementary_PID=%04x\n", Event->elementary_PID);
    echo1("    descriptor_tag=%02x\n", Event->descriptor_tag);
    echo1("    descriptor_length=%04x,", Event->descriptor_length);
    echo1(   " descriptor_length_Expected=%04x\n", Event->descriptor_length_Expected);
}

void MpegTs_descriptors_length_0 (struct MediaInfo_Event_MpegTs_descriptors_length_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1021, descriptor_length\n");
    else
        echo0("MpegTs, descriptor_length\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    table_id=%02x\n", Event->table_id);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    elementary_PID=%04x\n", Event->elementary_PID);
    echo1("    descriptors_length=%04x,", Event->descriptors_length);
    echo1(   " descriptors_length_Expected=%04x\n", Event->descriptors_length_Expected);
}

void MpegTs_video_stream_frame_rate_code_0 (struct MediaInfo_Event_MpegTs_video_stream_frame_rate_code_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1022, video_stream_frame_rate_code\n");
    else
        echo0("MpegTs, video_stream_frame_rate_code\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    elementary_PID=%04x\n", Event->elementary_PID);
    echo1("    frame_rate_code=%02x\n", Event->frame_rate_code);
}

void MpegTs_video_stream_MPEG_1_only_flag_0 (struct MediaInfo_Event_MpegTs_video_stream_MPEG_1_only_flag_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1022, video_stream_MPEG_1_only_flag\n");
    else
        echo0("MpegTs, video_stream_MPEG_1_only_flag\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    MPEG_1_only_flag=%01x\n", Event->MPEG_1_only_flag);
    echo1("    stream_type=%02x\n", Event->stream_type);
}

void MpegTs_video_stream_Constrained_parameter_flag_0 (struct MediaInfo_Event_MpegTs_video_stream_Constrained_parameter_flag_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1022, video_stream_Constrained_parameter_flag\n");
    else
        echo0("MpegTs, video_stream_Constrained_parameter_flag\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    MPEG_1_only_flag=%01x,", Event->MPEG_1_only_flag);
    echo1(   " constrained_parameter_flag=%01x\n", Event->constrained_parameter_flag);
}

void MpegTs_video_stream_Still_picture_flag_0 (struct MediaInfo_Event_MpegTs_video_stream_Still_picture_flag_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1022, video_stream_Still_picture_flag\n");
    else
        echo0("MpegTs, video_stream_Still_picture_flag\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    picture_structure=%02x,", Event->picture_structure);
}

void MpegTs_video_stream_Profile_and_level_indication_0 (struct MediaInfo_Event_MpegTs_video_stream_Profile_and_level_indication_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1022, video_stream_Profile_and_level_indication\n");
    else
        echo0("MpegTs, video_stream_Profile_and_level_indication\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    profile_and_level_indication=%02x,", Event->profile_and_level_indication);
    echo1(   " profile_and_level_indication_Stream=%02x\n", Event->profile_and_level_indication_Stream);
}

void MpegTs_video_stream_chroma_format_0 (struct MediaInfo_Event_MpegTs_video_stream_chroma_format_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1022, video_stream_chroma_format\n");
    else
        echo0("MpegTs, video_stream_chroma_format\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    chroma_format=%02x,", Event->chroma_format);
    echo1(   " chroma_format_Stream=%02x\n", Event->chroma_format_Stream);
}

void MpegTs_video_stream_frame_rate_extension_flag_0 (struct MediaInfo_Event_MpegTs_video_stream_frame_rate_extension_flag_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1022, video_stream_frame_rate_extension_flag\n");
    else
        echo0("MpegTs, video_stream_frame_rate_extension_flag\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
}

void MpegTs_audio_stream_free_format_flag_0 (struct MediaInfo_Event_MpegTs_audio_stream_free_format_flag_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1023, audio_stream_free_format_flag\n");
    else
        echo0("MpegTs, audio_stream_free_format_flag\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    free_format_flag=%01x,", Event->free_format_flag);
    echo1(   " bitrate_index=%02x\n", Event->bitrate_index);
}

void MpegTs_audio_stream_ID_0 (struct MediaInfo_Event_MpegTs_audio_stream_ID_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1023, audio_stream_ID\n");
    else
        echo0("MpegTs, audio_stream_ID\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    ID=%01x,", Event->ID);
    echo1(   " ID_Stream=%01x\n", Event->ID_Stream);
}

void MpegTs_audio_stream_layer_0 (struct MediaInfo_Event_MpegTs_audio_stream_layer_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1023, audio_stream_layer\n");
    else
        echo0("MpegTs, audio_stream_\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    section_number=%02x\n", Event->section_number);
    echo1("    layer=%01x,", Event->layer);
    echo1(   " layer_Stream=%01x\n", Event->layer_Stream);
}

void MpegTs_PAT_MultiplePrograms_0 (struct MediaInfo_Event_MpegTs_PAT_MultiplePrograms_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.001\n");
    else
        echo0("MpegTs, The transport stream has more than a single program\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    Count=%i\n", Event->Count);
}

void MpegTs_PMT_NoAudioStreams_0 (struct MediaInfo_Event_MpegTs_PMT_NoAudioStreams_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.002\n");
    else
        echo0("MpegTs, The program has no audio stream\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    program_number=%04x,", Event->program_number);
}

void MpegTs_PacketSize_Not188_0 (struct MediaInfo_Event_MpegTs_PacketSize_Not188_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.003\n");
    else
        echo0("MpegTs, The packet size is not 188\n");
    echo1("    Packet_Size=%i\n", Event->Packet_Size);
}

void MpegTs_Junk_Begin_0 (struct MediaInfo_Event_MpegTs_Junk_Begin_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.004\n");
    else
        echo0("MpegTs, The stream is not not in sync at the begining\n");
    echo1("    Junk_Size=%i\n", Event->Junk_Size);
}

void MpegTs_Junk_End_0 (struct MediaInfo_Event_MpegTs_Junk_End_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.005\n");
    else
        echo0("MpegTs, The stream is not not in sync at the end\n");
    echo1("    Junk_Size=%i\n", Event->Junk_Size);
}

void MpegTs_PCR_NotWithVideo_0 (struct MediaInfo_Event_MpegTs_PCR_NotWithVideo_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.007\n");
    else
        echo0("MpegTs, The PCR is on another PID than the video stream of this program\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " PCR_PID=%04x\n", Event->PCR_PID);
}

void MpegTs_PES_Video_PCR_NotAtStart_0 (struct MediaInfo_Event_MpegTs_PES_Video_PCR_NotAtStart_0* Event, int DCA)
{
    if (DCA)
        echo0("No DCA number\n");
    else
        echo0("MpegTs, A PCR is not present in a transport packet containing the first byte of a video PES payload\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
 }

void MpegTs_PES_Video_PCR_NotAtStart_PerFrame_0 (struct MediaInfo_Event_MpegTs_PES_Video_PCR_NotAtStart_PerFrame_0* Event, int DCA)
{
    size_t Pos;
    if (DCA)
        echo0("DCA #7702.008\n");
    else
        echo0("MpegTs, A PCR is not present in a transport packet containing the first byte of a video PES payload (Per frame)\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    for (Pos=0; Pos<Event->Fields_Size; Pos++)
    {
        echo1("    PCR=%s,", Event->Fields[Pos].PCR_HR);
        echo1(   " DTS=%s,", Event->Fields[Pos].DTS_HR);
        echo1(   " PCR not at start for field 1=%i\n", Event->Fields[Pos].PCR_NotAtStart);
    }
 }

void MpegTs_discontinuity_indicator_NotInFirstPCR_0 (struct MediaInfo_Event_MpegTs_discontinuity_indicator_NotInFirstPCR_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.009\n");
    else
        echo0("MpegTs, The first PCR packet of the stream does not have the transport discontinuity_indicator flag set\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
}

void MpegTs_random_access_indicator_NotWithPictureI_0 (struct MediaInfo_Event_MpegTs_random_access_indicator_NotWithPictureI_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.010\n");
    else
        echo0("MpegTs, The random_access_indicator is not set but must be\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void MpegTs_PCR_Accuracy_0 (struct MediaInfo_Event_MpegTs_PCR_Accuracy_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.011\n");
    else
        echo0("MpegTs, The PCR is not accurate\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR_Theory=%u ns,", Event->PCR_Theory);
    echo1(   " PCR_Reality=%u ns\n", Event->PCR_Reality);
}

void MpegTs_BitRate_NotConstant_0 (struct MediaInfo_Event_MpegTs_BitRate_NotConstant_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.012\n");
    else
        echo0("MpegTs, The bit rate is not constant +/- 1pc\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    OverallBitRate_Theory=%u bps,", Event->OverallBitRate_Theory);
    echo1(   " OverallBitRate_Reality=%u bps\n", Event->OverallBitRate_Reality);
}

void MpegTs_BitRate_MoreThan3dot75Mbps_0 (struct MediaInfo_Event_MpegTs_BitRate_MoreThan3dot75Mbps_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7379\n");
    else
        echo0("MpegTs, Bit rate is more than 15 Mbps\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    OverallBitRate=%u bps\n", Event->OverallBitRate);
}

void MpegTs_BitRate_MoreThan19Mbps_0 (struct MediaInfo_Event_MpegTs_BitRate_MoreThan19Mbps_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7381\n");
    else
        echo0("MpegTs, Bit rate is more than 19 Mbps\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    OverallBitRate=%u bps\n", Event->OverallBitRate);
}

void MpegTs_BitRate_MoreThan15Mbps_0 (struct MediaInfo_Event_MpegTs_BitRate_MoreThan15Mbps_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7382\n");
    else
        echo0("MpegTs, Bit rate is more than 15 Mbps\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    OverallBitRate=%u bps\n", Event->OverallBitRate);
}

void MpegTs_BitRate_MoreThan20Mbps_0 (struct MediaInfo_Event_MpegTs_BitRate_MoreThan20Mbps_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7384\n");
    else
        echo0("MpegTs, Bit rate is more than 20 Mbps\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    OverallBitRate=%u bps\n", Event->OverallBitRate);
}

void MpegTs_BitRate_IllegalForCustomer0_0 (struct MediaInfo_Event_MpegTs_BitRate_IllegalForCustomer0_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.013\n");
    else
        echo0("MpegTs, Bit rate doesn't conform to customer 0 needs\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    OverallBitRate_Theory=%u bps,", Event->OverallBitRate_Theory);
    echo1(   " OverallBitRate_Reality=%u bps\n", Event->OverallBitRate_Reality);
    echo1("    PayloadBitRate_Reality=%u bps\n", Event->PayloadBitRate_Reality);
}

void MpegTs_PID_Detected_0 (struct MediaInfo_Event_MpegTs_PID_Detected_0* Event, int DCA)
{
    if (DCA)
        echo0("No DCA number\n");
    else
        echo0("MpegTs, A PID is detected\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    switch (Event->Kind)
    {
        case 0x01 : echo1("    Kind=PES,", Event->Kind); break;
        case 0x02 : echo1("    Kind=PSI,", Event->Kind); break;
        default   : echo1("    Kind=Unknown,", Event->Kind); break;
    }
    echo1(   " table_id=%02x\n", Event->table_id);
}

void MpegTs_PID_IllegalForCustomer0_2 (struct MediaInfo_Event_MpegTs_PID_IllegalForCustomer0_2* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.014\n");
    else
        echo0("MpegTs, The PID doesn't conform to customer 0 needs\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    table_id=%02x,", Event->table_id);
    echo1(   " stream_type=%02x", Event->stream_type);
    echo1(   " kind=%02x\n", Event->kind);
    echo1("    Expected PID=%04x\n", Event->PID_Expected);
}

void MpegTs_PID_IllegalForCableLabsVOD_2 (struct MediaInfo_Event_MpegTs_PID_IllegalForCableLabsVOD_2* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7376\n");
    else
        echo0("MpegTs, The PID doesn't conform to CableLabs VOD needs\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    table_id=%02x,", Event->table_id);
    echo1(   " stream_type=%02x", Event->stream_type);
    echo1(   " kind=%02x\n", Event->kind);
    echo1("    Expected PID=%04x\n", Event->PID_Expected);
}

void MpegTs_PAT_PMT_NotPresent_0 (struct MediaInfo_Event_MpegTs_PAT_PMT_NotPresent_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.015\n");
    else
        echo0("MpegTs, The PAT or the PMT are not present\n");
    Event->EventCode=Event->EventCode;
}

void MpegTs_PAT_transport_stream_id_IllegalForCustomer0_1 (struct MediaInfo_Event_MpegTs_PAT_transport_stream_id_IllegalForCustomer0_1* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.015\n");
    else
        echo0("MpegTs, The PAT transport_stream_id doesn't conform to customer 0 needs\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    transport_stream_id=%04x\n", Event->transport_stream_id);
    echo1("    Expected transport_stream_id=%04x\n", Event->transport_stream_id_Expected);
}

void MpegTs_PMT_program_number_IllegalForCustomer0_1 (struct MediaInfo_Event_MpegTs_PMT_program_number_IllegalForCustomer0_1* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.015\n");
    else
        echo0("MpegTs, The PAT program_number doesn't conform to customer 0 needs\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    Expected program_number=%04x\n", Event->program_number_Expected);
}

void MpegTs_PAT_TooLate_0 (struct MediaInfo_Event_MpegTs_PAT_TooLate_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.016\n");
    else
        echo0("MpegTs, A complete PAT didn't occur in the TS before the first byte of a PMT\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    Stream_Offset_PAT_Begin=%08x,", Event->Stream_Offset_PAT_Begin);
    echo1(   " Stream_Offset_PAT_End=%08x\n", Event->Stream_Offset_PAT_End);
    echo1("    Stream_Offset_PMT_Begin=%08x,", Event->Stream_Offset_PMT_Begin);
    echo1(   " Stream_Offset_PMT_End=%08x\n", Event->Stream_Offset_PMT_End);
}

void MpegTs_PAT_Repetition_Not100ms_0 (struct MediaInfo_Event_MpegTs_PAT_Repetition_Not100ms_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.017\n");
    else
        echo0("MpegTs, The repetition interval for a PAT is not be 100ms\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    Interval=%i ns\n", Event->Interval);
}

void MpegTs_PAT_New_0 (struct MediaInfo_Event_MpegTs_PAT_New_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.018\n");
    else
        echo0("MpegTs, A new version_number of the PAT is found\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    version_number_Old=%02x,", Event->version_number_Old);
    echo1(   " version_number_New=%02x\n", Event->version_number_New);
}

void MpegTs_PAT_NoPAS_0 (struct MediaInfo_Event_MpegTs_PAT_NoPAS_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.019\n");
    else
        echo0("MpegTs, The PAT doesn't contain a PAS\n");
    echo1("    table_id=%02x\n", Event->table_id);
}

void MpegTs_PMT_stream_type_Unknown_0 (struct MediaInfo_Event_MpegTs_PMT_stream_type_Unknown_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.014 (Unknown stream)\n");
    else
        echo0("MpegTs, PID has an unknown stream_type\n");
    echo1("    PID=%04x\n", Event->PID);
    echo1("    registration_format_identifier=%08x,", Event->registration_format_identifier);
    echo1(   " stream_type=%02x\n", Event->stream_type);
}

void MpegTs_PID_Unreferenced_0 (struct MediaInfo_Event_MpegTs_PID_Unreferenced_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.014 (Unreferenced PID)\n");
    else
        echo0("MpegTs, PID is not referenced\n");
    echo1("    PID=%04x\n", Event->PID);
}

void MpegTs_PAT_current_next_indicator_NotSet_0 (struct MediaInfo_Event_MpegTs_PAT_current_next_indicator_NotSet_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.020\n");
    else
        echo0("MpegTs, The current_next_indicator is not set\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
}

void MpegTs_network_PID_InUse_0 (struct MediaInfo_Event_MpegTs_network_PID_InUse_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.021\n");
    else
        echo0("MpegTs, A network_PID is set in the PMT\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
}

void MpegTs_PMT_TooLate_0 (struct MediaInfo_Event_MpegTs_PMT_TooLate_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.022\n");
    else
        echo0("MpegTs, A complete PMT didn't occur in the TS before the first byte of a PID\n");
    echo1("    PID=%04x\n", Event->PID);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    Stream_Offset_PMT_Begin=%08x,", Event->Stream_Offset_PMT_Begin);
    echo1(   " Stream_Offset_PMT_End=%08x\n", Event->Stream_Offset_PMT_End);
    echo1("    Stream_Offset_PID_Begin=%08x,", Event->Stream_Offset_PID_Begin);
    echo1(   " Stream_Offset_PID_End=%08x\n", Event->Stream_Offset_PID_End);
}

void MpegTs_PMT_Repetition_Not100ms_0 (struct MediaInfo_Event_MpegTs_PMT_Repetition_Not100ms_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.023\n");
    else
        echo0("MpegTs, The repetition interval for a PMT is not be 100ms\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    Interval=%i ns\n", Event->Interval);
}

void MpegTs_PMT_New_0 (struct MediaInfo_Event_MpegTs_PMT_New_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.024\n");
    else
        echo0("MpegTs, A new version_number of the PMT is found\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    version_number_Old=%02x,", Event->version_number_Old);
    echo1(   " version_number_New=%02x\n", Event->version_number_New);
}

void MpegTs_PMT_NoPMS_0 (struct MediaInfo_Event_MpegTs_PMT_NoPMS_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.025\n");
    else
        echo0("MpegTs, The PMT doesn't contain a PMS\n");
    echo1("    PID=%04x\n", Event->PID);
    echo1("    table_id=%02x\n", Event->table_id);
}

void MpegTs_PES_Information_0 (struct MediaInfo_Event_MpegTs_PES_Information_0* Event, int DCA)
{
    if (DCA)
        echo0("No DCA number\n");
    else
        echo0("MpegTs, PES information\n");
    echo1("    PID=%04x\n", Event->PID);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    registration_format_identifier=%08x\n", Event->registration_format_identifier);
    echo1("    stream_type=%02x\n", Event->stream_type);
}

void MpegTs_PES_stream_type_IllegalForCustomer0_0 (struct MediaInfo_Event_MpegTs_PES_stream_type_IllegalForCustomer0_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.026 (stream_type does not conform)\n");
    else
        echo0("MpegTs, The PES stream_type doesn't conform to customer 0 needs\n");
    echo1("    PID=%04x\n", Event->PID);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    registration_format_identifier=%08x\n", Event->registration_format_identifier);
    echo1("    stream_type=%02x\n", Event->stream_type);
}

void MpegTs_PMT_stream_type_DoesNotFit_0 (struct MediaInfo_Event_MpegTs_PMT_stream_type_DoesNotFit_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.026 (stream_type does not fit)\n");
    else
        echo0("MpegTs, The PMT stream_type doesn't not fit the stream format\n");
    echo1("    PID=%04x\n", Event->PID);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    registration_format_identifier=%08x\n", Event->registration_format_identifier);
    echo1("    stream_type=%02x\n", Event->stream_type);
}

void MpegTs_PES_PCR_Repetition_MoreThan40ms_0 (struct MediaInfo_Event_MpegTs_PES_PCR_Repetition_MoreThan40ms_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7604, PCR Repetition\n");
    else
        echo0("MpegTs, The repetition interval for a PCR of an elementary stream is more than 40ms\n");
    echo1("    PID=%04x\n", Event->PID);
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    Interval=%i ns\n", Event->Interval);
}

void MpegTs_PAT_MoreThan2Sections_0 (struct MediaInfo_Event_MpegTs_PAT_MoreThan2Sections_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7604, PAT has more than 2 sections\n");
    else
        echo0("MpegTs, PAT has more than 2 sections\n");
    echo1("    PID=%04x\n", Event->PID);
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
}

void MpegTs_PMT_IsMissing_0 (struct MediaInfo_Event_MpegTs_PMT_IsMissing_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7604, PMT is missing\n");
    else
        echo0("MpegTs, PMT is missing\n");
    echo1("    PID=%04x\n", Event->PID);
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    program_number=%04x\n", Event->program_number);
}

void MpegTs_PID_IsMissing_0 (struct MediaInfo_Event_MpegTs_PID_IsMissing_0* Event, int DCA)
{
    size_t Pos;
	if (DCA)
        echo0("DCA #7604, PID is missing\n");
    else
        echo0("MpegTs, PID is missing\n");
    echo1("    PID=%04x\n", Event->PID);
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    if (Event->program_numbers_Count)
	{
		echo0("    program_number=");
		for (Pos=0; Pos<Event->program_numbers_Count-1; Pos++)
			echo1("%04x, \n", Event->program_numbers[Pos]);
		echo1("%04x\n", Event->program_numbers[Event->program_numbers_Count-1]);
	}
}

void MpegTs_PES_PCR_Repetition_Not40ms_0 (struct MediaInfo_Event_MpegTs_PES_PCR_Repetition_Not40ms_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.030\n");
    else
        echo0("MpegTs, The repetition interval for a PCR of an elementary stream is not 40ms\n");
    echo1("    PID=%04x\n", Event->PID);
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    Interval=%i ns\n", Event->Interval);
}

void MpegTs_PAT_Repetition_MoreThan250ms_0 (struct MediaInfo_Event_MpegTs_PAT_Repetition_MoreThan250ms_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7374\n");
    else
        echo0("MpegTs, The repetition interval for a PAT is more than 250 ms\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    Interval=%i ns\n", Event->Interval);
}

void MpegTs_PMT_Repetition_MoreThan250ms_0 (struct MediaInfo_Event_MpegTs_PMT_Repetition_MoreThan250ms_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7374\n");
    else
        echo0("MpegTs, The repetition interval for a PMT is more than 250 ms\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    Interval=%i ns\n", Event->Interval);
}

void MpegTs_PMT_descriptor_tag_IllegalForCustomer0_0 (struct MediaInfo_Event_MpegTs_PMT_descriptor_tag_IllegalForCustomer0_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.027\n");
    else
        echo0("MpegTs, The PMT descriptor doesn't conform to customer 0 needs\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    program_number=%04x\n", Event->program_number);
    switch (Event->Kind)
    {
        case 0x00 : echo0("    Kind=Program\n"); break;
        case 0x01 : echo0("    Kind=Stream\n"); break;
        default   : echo0("    Kind=Unknown\n"); break;
    }
    echo1("    registration_format_identifier=%08x,", Event->registration_format_identifier);
    echo1(   " stream_type=%02x\n", Event->stream_type);
    switch (Event->IsUsed)
    {
        case 0x00 : echo0("    IsUsed=No,"); break;
        case 0x01 : echo0("    IsUsed=Yes,"); break;
        default   : echo0("    IsUsed=Unknown,"); break;
    }
    echo1(   " descriptor_tag=%02x\n", Event->descriptor_tag);
}

void MpegTs_PMT_registration_tag_IllegalForScte35_0 (struct MediaInfo_Event_MpegTs_PMT_registration_tag_IllegalForScte35_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7358\n");
    else
        echo0("MpegTs, program registration_tag is not CUEI\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    registration_format_identifier=%08x\n", Event->registration_format_identifier);
    switch (Event->IsUsed)
    {
        case 0x00 : echo0("    IsUsed=No\n"); break;
        case 0x01 : echo0("    IsUsed=Yes\n"); break;
        default   : echo0("    IsUsed=Unknown\n"); break;
    }
}

void MpegTs_Scte35_segmentation_End_0 (struct MediaInfo_Event_MpegTs_Scte35_segmentation_End_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7359\n");
    else
        echo0("MpegTs, Information about SCTE 35 segmentation\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    segmentation_IsPresent=%01x\n", Event->segmentation_IsPresent);
    if (Event->segmentation_IsPresent)
    {
        echo1("    segmentation_event_id=%01x\n", Event->segmentation_event_id);
        echo1("    Program=%01x", Event->segmentation_type_id[0x10]);
        echo1(  ", Chapter=%01x", Event->segmentation_type_id[0x20]);
        echo1(  ", Provider Advertisement=%01x", Event->segmentation_type_id[0x30]);
        echo1(  ", Distributor Advertisement=%01x\n", Event->segmentation_type_id[0x32]);
    }
}

void MpegTs_Scte35_Splice_Insert_0 (struct MediaInfo_Event_MpegTs_Scte35_Splice_Insert_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #???? (SCTE 35 splice insert info)\n");
    else
        echo0("MpegTs, SCTE 35 splice insert info\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x\n", Event->PID);
    echo1("    program_number=%04x\n", Event->program_number);
    echo1("    splice_event_id=%01x\n", Event->splice_event_id);
    echo1("    splice_event_cancel_indicator=%01x\n", Event->splice_event_cancel_indicator);
    if (!Event->splice_event_cancel_indicator)
    {
        echo1("    out_of_network_indicator=%01x\n", Event->out_of_network_indicator);
        echo1("    PTS=%s\n", Event->pts_time_HR);
    }
}

void Avc_Hrd_Cpb_Flow_0 (struct MediaInfo_Event_Avc_Hrd_Cpb_Flow_0* Event, int DCA)
{
    size_t Pos;
    if (DCA)
        echo0("DCA #1256\n");
    else
        echo0("Avc, Buffer overflow/underflow from HRD\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    NalOrVcl=%s,", Event->NalOrVcl==0?"NAL":"VCL");
    echo1(   " SchedSel=%u,", Event->SchedSel);
    echo1(   " HrdConfig_FromFrameNumber=%lu\n", Event->HrdConfig_FromFrameNumber);
    echo1("    cpb_size_value=%lu", Event->cpb_size_value);
    echo1(   " cpb_size_Real=%lu\n", Event->cpb_size_Real);
}

void Avc_pic_parameter_set_id_DoesNotExist_0 (struct MediaInfo_Event_Avc_pic_parameter_set_id_DoesNotExist_0* Event, int DCA)
{
    size_t Pos;
    if (DCA)
        echo0("DCA #1258\n");
    else
        echo0("Avc, pic_parameter_set_id does not exist\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    pic_parameter_set_id=%02x\n", Event->pic_parameter_set_id);
}

void Avc_FirstFrame_NotIdr_0 (struct MediaInfo_Event_Avc_FirstFrame_NotIdr_0* Event, int DCA)
{
    size_t Pos;
    if (DCA)
        echo0("DCA #1257\n");
    else
        echo0("Avc, FirstFrame is not IDR\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

const char* Avc_slice_type[]=
{
    "P",
    "B",
    "I",
    "SP",
    "SI",
    "P",
    "B",
    "I",
    "SP",
    "SI",
};
void Avc_GOP_0 (struct MediaInfo_Event_Avc_GOP_0* Event, int DCA)
{
    size_t Pos;
    if (DCA)
        echo0("DCA #???\n");
    else
        echo0("Avc, GOP information\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    IFrame_nal_unit_type=%02x\n", Event->IFrame_nal_unit_type);
    echo1("    GOP_Size=%i\n", Event->GOP_Size);
    echo0("    GOP=");
    for (Pos=0; Pos<Event->GOP_FieldsOrder_Size; Pos++)
        echo1("%s", Avc_slice_type[Event->GOP_FieldsOrder[Pos]]);
    echo0("\n");
}

void Avc_BitRate_NotConstant_0 (struct MediaInfo_Event_Avc_BitRate_NotConstant_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.011\n");
    else
        echo0("Avc, BitRate_NotConstant information\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    BitRate=%i,", Event->BitRate);
    echo1(   " BitRate_Expected=%i\n", Event->BitRate_Expected);
}

void Avc_NumBytesInNALunit_IllegalForBluray_0 (struct MediaInfo_Event_Avc_NumBytesInNALunit_IllegalForBluray_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7123\n");
    else
        echo0("Avc, NumBytesInNALunit is Illegal for Blu-ray\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    NumBytesInNALunit=%i\n", Event->NumBytesInNALunit);
    echo1("    NumBytesInNALunit_MaximumAllowed=%i\n", Event->NumBytesInNALunit_MaximumAllowed);
}

void Avc_GOP_Size_IllegalForCustomer0_0 (struct MediaInfo_Event_Avc_GOP_Size_IllegalForCustomer0_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.109 and 210\n");
    else
        echo0("Avc, The GOP size doesn't conform to customer needs\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    GOP_Size=%i\n", Event->GOP_Size);
}

void Avc_GOP_FieldsOrder_IllegalForCustomer0_0 (struct MediaInfo_Event_Avc_GOP_FieldsOrder_IllegalForCustomer0_0* Event, int DCA)
{
    size_t Pos;
    if (DCA)
        echo0("DCA #3028, 7702.110, 111, 211 and 212\n");
    else
        echo0("Avc, The GOP field/frame order doesn't conform to customer needs\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo0("    GOP=");
    for (Pos=0; Pos<Event->GOP_FieldsOrder_Size; Pos++)
        echo1("%s", Avc_slice_type[Event->GOP_FieldsOrder[Pos]]);
    echo0("\n");
}

void MpegPs_PES_Start_NotAligned_0 (struct MediaInfo_Event_MpegPs_PES_Start_NotAligned_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.112 and 213\n");
    else
        echo0("MpegTs, The elementary stream is not aligned with PES packet start\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void MpegPs_PES_NotOnePerFrame_0 (struct MediaInfo_Event_MpegPs_PES_NotOnePerFrame_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.113 and 214\n");
    else
        echo0("MpegTs, A picture is not contained in one PES packet\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    PES_Count=%i\n", Event->PES_Count);
}

void Avc_IFrame_WithoutStart_0 (struct MediaInfo_Event_Avc_IFrame_WithoutStart_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.114 and 215\n");
    else
        echo0("MpegTs, A reference frame (I-frame) is not preceded by a start code\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void MpegTs_Stream_Start_TooLate_0 (struct MediaInfo_Event_MpegTs_Stream_Start_TooLate_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.115 and 216\n");
    else
        echo0("MpegTs, Start of the stream is too late\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void MpegTs_BitRate_IllegalForScte54_0 (struct MediaInfo_Event_MpegTs_BitRate_IllegalForScte54_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7301\n");
    else
        echo0("MpegTs, Bit rate doesn't conform to SCTE 54 needs\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    OverallBitRate=%u bps\n", Event->OverallBitRate);
}

void MpegPs_PES_IFrame_NoTimeStamps_0 (struct MediaInfo_Event_MpegPs_PES_IFrame_NoTimeStamps_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7702.116 and 217\n");
    else
        echo0("MpegTs, PES with I-Frame has no time stamps\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s\n", Event->PCR_HR);
}

void MpegPs_PES_IllegalForScte54_1 (struct MediaInfo_Event_MpegPs_PES_IllegalForScte54_1* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7302\n");
    else
        echo0("MpegPs, PES_IllegalForScte54\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    PES_scrambling_control=%i\n", Event->PES_scrambling_control);
    echo1("    ESCR_flag=%i\n", Event->ESCR_flag);
    echo1("    ES_rate_flag=%i\n", Event->ES_rate_flag);
    echo1("    PES_CRC_flag=%i\n", Event->PES_CRC_flag);
    echo1("    PES_private_data_flag=%i\n", Event->PES_private_data_flag);
    echo1("    pack_header_field_flag=%i\n", Event->pack_header_field_flag);
    echo1("    program_packet_sequence_counter_flag=%i\n", Event->program_packet_sequence_counter_flag);
    echo1("    p_STD_buffer_flag=%i\n", Event->p_STD_buffer_flag);
}

void MpegPs_SampleRate_NotConstant_Audio_0 (struct MediaInfo_Event_MpegPs_SampleRate_NotConstant_Audio_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1051\n");
    else
        echo0("MpegPs, Sample rate should be constant\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    SampleRate_Before=%i,", Event->SampleRate_Before);
    echo1(   " SampleRate_After=%i\n", Event->SampleRate_After);
}

void MpegPs_SampleRate_NotConstant_Video_0 (struct MediaInfo_Event_MpegPs_SampleRate_NotConstant_Video_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1052\n");
    else
        echo0("MpegPs, Sample rate should be constant\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    SampleRate_Before=%i,", Event->SampleRate_Before);
    echo1(   " SampleRate_After=%i\n", Event->SampleRate_After);
}

void MpegPs_program_stream_map_NonExistentESID_0 (struct MediaInfo_Event_MpegPs_program_stream_map_NonExistentESID_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1053\n");
    else
        echo0("MpegPs, The PSM contains a PID which points to a non-existent stream\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s\n", Event->PCR_HR);
    echo1("    Origin=%02x\n", Event->Origin);
}

void MpegPs_stream_id_0 (struct MediaInfo_Event_MpegPs_stream_id_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #????, stream_id\n");
    else
        echo0("MpegPs, stream_id\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void MpegPs_PES_packet_length_0 (struct MediaInfo_Event_MpegPs_PES_packet_length_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #????, PES_packet_length\n");
    else
        echo0("MpegPs, PES_packet_length\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    PES_packet_length=%i\n", Event->PES_packet_length);
}

void MpegPs_data_alignment_indicator_0 (struct MediaInfo_Event_MpegPs_data_alignment_indicator_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1018, data_alignment_indicator\n");
    else
        echo0("MpegPs, data_alignment_indicator\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void MpegPs_PTS_DTS_flags_0 (struct MediaInfo_Event_MpegPs_PTS_DTS_flags_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1018, PTS_DTS_flags\n");
    else
        echo0("MpegPs, PTS_DTS_flags\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void MpegPs_PES_header_data_length_0 (struct MediaInfo_Event_MpegPs_PES_header_data_length_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1018, PES_header_data_length\n");
    else
        echo0("MpegPs, PES_header_data_length\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    PES_header_data_length=%i\n", Event->PES_header_data_length);
}

void MpegPs_Timestamps_0 (struct MediaInfo_Event_MpegPs_Timestamps_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1018, Timestamps\n");
    else
        echo0("MpegPs, Timestamps\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    PTSDTS_Previous_HR=%s\n", Event->PTSDTS_Previous_HR);
}

void MpegPs_rep_cntrl_0 (struct MediaInfo_Event_MpegPs_rep_cntrl_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1018, rep_cntrl\n");
    else
        echo0("MpegPs, rep_cntrl\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void MpegPs_previous_PES_packet_CRC_0 (struct MediaInfo_Event_MpegPs_previous_PES_packet_CRC_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1018, previous_PES_packet_CRC\n");
    else
        echo0("MpegPs, previous_PES_packet_CRC\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    PES_packet_CRC=%08x,", Event->PES_packet_CRC);
    echo1(   " PES_packet_CRC_Expected=%08x\n", Event->PES_packet_CRC_Expected);
}

void MpegPs_pack_header_field_flag_0 (struct MediaInfo_Event_MpegPs_pack_header_field_flag_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1018, pack_header_field_flag\n");
    else
        echo0("MpegPs, pack_header_field_flag\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void MpegPs_program_packet_sequence_counter_0 (struct MediaInfo_Event_MpegPs_program_packet_sequence_counter_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1018, program_packet_sequence_counter\n");
    else
        echo0("MpegPs, program_packet_sequence_counter\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    program_packet_sequence_counter=%i,", Event->program_packet_sequence_counter);
    echo1(   " program_packet_sequence_counter_Expected=%08x\n", Event->program_packet_sequence_counter_Expected);
}

void MpegPs_original_stuff_length_0 (struct MediaInfo_Event_MpegPs_original_stuff_length_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1018, original_stuff_length\n");
    else
        echo0("MpegPs, original_stuff_length\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    original_stuff_length=%i\n", Event->original_stuff_length);
}

void MpegPs_P_STD_buffer_scale_0 (struct MediaInfo_Event_MpegPs_P_STD_buffer_scale_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1018, P_STD_buffer_scale\n");
    else
        echo0("MpegPs, P_STD_buffer_scale\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void Gxf_Header_PacketType_Unknown_0 (struct MediaInfo_Event_Gxf_Header_PacketType_Unknown_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1852\n");
    else
        echo0("Gxf, Header_PacketType_Unknown\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PacketType=%u\n", Event->PacketType);
}

void Gxf_Header_Reserved_NotZero_0 (struct MediaInfo_Event_Gxf_Header_Reserved_NotZero_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1853\n");
    else
        echo0("Gxf, Header_Reserved_NotZero\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo4("    Reserved=%02x%02x%02x%02x\n", Event->Reserved[0], Event->Reserved[1], Event->Reserved[2], Event->Reserved[3]);
}

void Gxf_Media_MediaType_Unknown_0 (struct MediaInfo_Event_Gxf_Media_MediaType_Unknown_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1854\n");
    else
        echo0("Gxf, Media_MediaType_Unknown\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    MediaType=%u\n", Event->MediaType);
}

void Gxf_NotSimpleClip_0 (struct MediaInfo_Event_Gxf_NotSimpleClip_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7704.001\n");
    else
        echo0("Gxf, NotSimpleClip\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    MarkIn=%u,", Event->MarkIn);
    echo1(   " MarkOut=%u\n", Event->MarkOut);
    echo1("    FirstField=%u,", Event->FirstField);
    echo1(   " LastField=%u\n", Event->LastField);
}

void Gxf_TimeCode_NotValid_1 (struct MediaInfo_Event_Gxf_TimeCode_NotValid_1* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7704.015\n");
    else
        echo0("Gxf, TimeCode_NotValid\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x,", Event->PID);
    echo1("    Frames=%u,", Event->Frames);
    echo1(   " Seconds=%u,", Event->Seconds);
    echo1(   " Minutes=%u,", Event->Minutes);
    echo1(   " Hours=%u\n", Event->Hours);
}

void Gxf_TimeCode_NotContinuous_1 (struct MediaInfo_Event_Gxf_TimeCode_NotContinuous_1* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7704.016\n");
    else
        echo0("Gxf, TimeCode_NotContinuous\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x,", Event->PID);
    echo1("    Frames=%u,", Event->Frames);
    echo1(   " Seconds=%u,", Event->Seconds);
    echo1(   " Minutes=%u,", Event->Minutes);
    echo1(   " Hours=%u\n", Event->Hours);
    echo1("    Expected Frames=%u,", Event->Frames_Expected);
    echo1(   " Seconds=%u,", Event->Seconds_Expected);
    echo1(   " Minutes=%u,", Event->Minutes_Expected);
    echo1(   " Hours=%u\n", Event->Hours_Expected);
}

void Gxf_TimeCode_DropFrameIssue_1 (struct MediaInfo_Event_Gxf_TimeCode_DropFrameIssue_1* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7704.017\n");
    else
        echo0("Gxf, TimeCode_DropFrameIssue\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    PID=%04x,", Event->PID);
    echo1("    DropFrame=%u\n", Event->DropFrame);
}

void Mxf_BodyPartition_NoGop_0 (struct MediaInfo_Event_Mxf_BodyPartition_NoGop_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7640 (BodyPartition_NoGop)\n");
    else
        echo0("Mxf, BodyPartition_NoGop\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
}

void Mxf_BodyPartition_MoreThan10seconds_0 (struct MediaInfo_Event_Mxf_BodyPartition_MoreThan10seconds_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7640 (BodyPartition_MoreThan10seconds)\n");
    else
        echo0("Mxf, BodyPartition_MoreThan10seconds\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    Duration=%u ms\n", Event->Duration/1000000); /*Warning: %lu does not work on Windows, this is unsigned long integer, so I divide by 1000000 in order to have the value is milliseconds*/
}

void Mxf_BodyPartition_NotFollowedByIFrame_0 (struct MediaInfo_Event_Mxf_BodyPartition_NotFollowedByIFrame_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7640 (BodyPartition_NotFollowedByIFrame)\n");
    else
        echo0("Mxf, BodyPartition_NotFollowedByIFrame\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    Frame_Kind=%u\n", Event->Frame_Kind);
}

void Mxf_IndexTable_Duration_NotSame_0 (struct MediaInfo_Event_Mxf_IndexTable_Duration_NotSame_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7640 (IndexTable_Duration_NotSame)\n");
    else
        echo0("Mxf, IndexTable_Duration_NotSame\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    Start=%u,", Event->Start);
    echo1(   " Duration=%u ms,", Event->Duration/1000000); /*Warning: %lu does not work on Windows, this is unsigned long integer, so I divide by 1000000 in order to have the value is milliseconds*/
    echo1(   " Duration_Previous=%u ms\n", Event->Duration_Previous/1000000); /*Warning: %lu does not work on Windows, this is unsigned long integer, so I divide by 1000000 in order to have the value is milliseconds*/
}

void Mxf_BodyPartition_PartitionSpacing_NotAs02_0 (struct MediaInfo_Event_Mxf_BodyPartition_PartitionSpacing_NotAs02_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7659\n");
    else
        echo0("Mxf, BodyPartition_PartitionSpacing_NotAs02\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    Start=%u,", Event->Start);
    echo1(   " Duration=%u ms,", Event->Duration/1000000); /*Warning: %lu does not work on Windows, this is unsigned long integer, so I divide by 1000000 in order to have the value is milliseconds*/
    echo1(   " Duration_Previous=%u ms\n", Event->Duration_Previous/1000000); /*Warning: %lu does not work on Windows, this is unsigned long integer, so I divide by 1000000 in order to have the value is milliseconds*/
}

void Mxf_HeaderPartition_NotFirstByte_0 (struct MediaInfo_Event_Mxf_HeaderPartition_NotFirstByte_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7660\n");
    else
        echo0("Mxf, HeaderPartition_NotFirstByte\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
}

void Mxf_FooterNotFollowedByRip_0 (struct MediaInfo_Event_Mxf_FooterNotFollowedByRip_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7662\n");
    else
        echo0("Mxf, FooterNotFollowedByRip\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
}

void Mxf_Partition_NotClosedComplete_0 (struct MediaInfo_Event_Mxf_Partition_NotClosedComplete_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7662\n");
    else
        echo0("Mxf, Partition_NotClosedComplete\n");
    echo1("    Stream_Offset=%08x\n", Event->Stream_Offset);
    echo1("    KindOfPartition=%08x,", Event->KindOfPartition);
    echo1(   " PartitionStatus=%u\n", Event->PartitionStatus);
}

void Mpegv_sequence_header_NotSame_0 (struct MediaInfo_Event_Mpegv_sequence_header_NotSame_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1207 (sequence_header)\n");
    else
        echo0("Mpegv, sequence_header is not same\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo2("    horizontal_size_value, Previous=%i, Current=%i\n", Event->horizontal_size_value_Previous, Event->horizontal_size_value_Current);
    echo2("    vertical_size_value, Previous=%i, Current=%i\n", Event->vertical_size_value_Previous, Event->vertical_size_value_Current);
    echo2("    aspect_ratio_information, Previous=%i, Current=%i\n", Event->aspect_ratio_information_Previous, Event->aspect_ratio_information_Current);
    echo2("    frame_rate_code, Previous=%i, Current=%i\n", Event->frame_rate_code_Previous, Event->frame_rate_code_Current);
    echo2("    bit_rate_value, Previous=%i, Current=%i\n", Event->bit_rate_value_Previous, Event->bit_rate_value_Current);
    echo2("    vbv_buffer_size_value, Previous=%i, Current=%i\n", Event->vbv_buffer_size_value_Previous, Event->vbv_buffer_size_value_Current);
    echo2("    constrained_parameters_flag, Previous=%i, Current=%i\n", Event->constrained_parameters_flag_Previous, Event->constrained_parameters_flag_Current);
}

void Mpegv_sequence_extension_NotSame_0 (struct MediaInfo_Event_Mpegv_sequence_extension_NotSame_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1207 (sequence_extension)\n");
    else
        echo0("Mpegv, sequence_extension is not same\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo2("    profile_and_level_indication_escape, Previous=%i, Current=%i\n", Event->profile_and_level_indication_escape_Previous, Event->profile_and_level_indication_escape_Current);
    echo2("    profile_and_level_indication, Previous=%i, Current=%i\n", Event->profile_and_level_indication_Previous, Event->profile_and_level_indication_Current);
    echo2("    profile_and_level_indication_profile, Previous=%i, Current=%i\n", Event->profile_and_level_indication_profile_Previous, Event->profile_and_level_indication_profile_Current);
    echo2("    profile_and_level_indication_level, Previous=%i, Current=%i\n", Event->profile_and_level_indication_level_Previous, Event->profile_and_level_indication_level_Current);
    echo2("    progressive_sequence, Previous=%i, Current=%i\n", Event->progressive_sequence_Previous, Event->progressive_sequence_Current);
    echo2("    chroma_format, Previous=%i, Current=%i\n", Event->chroma_format_Previous, Event->chroma_format_Current);
    echo2("    horizontal_size_extension, Previous=%i, Current=%i\n", Event->horizontal_size_extension_Previous, Event->horizontal_size_extension_Current);
    echo2("    vertical_size_extension, Previous=%i, Current=%i\n", Event->vertical_size_extension_Previous, Event->vertical_size_extension_Current);
    echo2("    bit_rate_extension, Previous=%i, Current=%i\n", Event->bit_rate_extension_Previous, Event->bit_rate_extension_Current);
    echo2("    vbv_buffer_size_extension, Previous=%i, Current=%i\n", Event->vbv_buffer_size_extension_Previous, Event->vbv_buffer_size_extension_Current);
    echo2("    low_delay, Previous=%i, Current=%i\n", Event->low_delay_Previous, Event->low_delay_Current);
    echo2("    frame_rate_extension_n, Previous=%i, Current=%i\n", Event->frame_rate_extension_n_Previous, Event->frame_rate_extension_n_Current);
    echo2("    frame_rate_extension_d, Previous=%i, Current=%i\n", Event->frame_rate_extension_d_Previous, Event->frame_rate_extension_d_Current);
}

void Mpegv_group_start_closed_gop_0 (struct MediaInfo_Event_Mpegv_group_start_closed_gop_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #3013\n");
    else
        echo0("Mpegv, closed_gop\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    closed_gop=%i\n", Event->closed_gop);
}

void Mpegv_DataBeforeFirst_sequence_header_0 (struct MediaInfo_Event_Mpegv_DataBeforeFirst_sequence_header_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7351\n");
    else
        echo0("Mpegv, Data before first sequence_header\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    Data_Size=%i\n", Event->Data_Size);
}

void Mpegv_IFrame_Without_sequence_header_0 (struct MediaInfo_Event_Mpegv_IFrame_Without_sequence_header_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7352\n");
    else
        echo0("Mpegv, An I-Frame begins without a sequence_header or sequence_extension\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    MissingElements=%i\n", Event->MissingElements);
}

void Mpegv_picture_structure_Not3_0 (struct MediaInfo_Event_Mpegv_picture_structure_Not3_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7356\n");
    else
        echo0("Mpegv, picture_structure is not set to 3\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    picture_structure=%i\n", Event->picture_structure);
}

void Mpegv_Has_scalable_extensions_0 (struct MediaInfo_Event_Mpegv_Has_scalable_extensions_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #7357\n");
    else
        echo0("Mpegv, The sequece has scalable extensions\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    scalable_extensions=%1x\n", Event->scalable_extensions);
}

void Afd_Content_0 (struct MediaInfo_Event_Afd_Content_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #????\n");
    else
        echo0("AFD, Content\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    active_format=%i,", Event->active_format);
    echo1(   " aspect_ratio=%02x\n", Event->aspect_ratio);
}

void BarData_Content_0 (struct MediaInfo_Event_BarData_Content_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #????\n");
    else
        echo0("AFD, Content\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    line_number_end_of_top_bar=%i,", Event->line_number_end_of_top_bar);
    echo1(   " line_number_start_of_bottom_bar=%i\n", Event->line_number_start_of_bottom_bar);
    echo1("    pixel_number_end_of_left_bar=%i,", Event->line_number_end_of_top_bar);
    echo1(   " pixel_number_start_of_right_bar=%i\n", Event->line_number_start_of_bottom_bar);
}

void DolbyE_Crc_0 (struct MediaInfo_Event_DolbyE_Crc_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1828\n");
    else
        echo0("DolbyE, CRC error\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    CRC_List=%02x\n",  Event->CRC_List);
}

void DolbyE_frame_rate_code_Changed_0 (struct MediaInfo_Event_DolbyE_frame_rate_code_Changed_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1831 (frame_rate_code)\n");
    else
        echo0("DolbyE, frame_rate_code_Changed\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    frame_rate_code_HR=%s,",  Event->frame_rate_code_HR);
    echo1(   " frame_rate_code_Previous_HR=%s\n",  Event->frame_rate_code_Previous_HR);
}

void DolbyE_GuardBand_0 (struct MediaInfo_Event_DolbyE_GuardBand_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1830\n");
    else
        echo0("DolbyE, frame_rate_code_Changed\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    GuardBand_Duration=%u ns,",  Event->GuardBand_Duration/1000);
    echo1(   " GuardBand_Duration_Ideal=%u ns\n",  Event->GuardBand_Duration_Ideal/1000);
}

void DolbyE_program_config_Changed_0 (struct MediaInfo_Event_DolbyE_program_config_Changed_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1831 (program_config)\n");
    else
        echo0("DolbyE, program_config_Changed\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    program_config_HR=%s\n",  Event->program_config_HR);
    echo1("    program_config_Previous_HR=%s,\n",  Event->program_config_Previous_HR);
}

void DolbyE_frame_count_Splice_0 (struct MediaInfo_Event_DolbyE_frame_count_Splice_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1832\n");
    else
        echo0("DolbyE, frame_count splice\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    frame_count=%u,",  Event->frame_count);
    echo1(   " frame_count_Previous=%u\n",  Event->frame_count_Previous);
}

void DolbyE_GuardBand_NotIdeal_0 (struct MediaInfo_Event_DolbyE_GuardBand_NotIdeal_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1833\n");
    else
        echo0("DolbyE, frame_rate_code_Changed\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    GuardBand_Duration=%u ns,",  Event->GuardBand_Duration/1000);
    echo1(   " GuardBand_Duration_Ideal=%u ns\n",  Event->GuardBand_Duration_Ideal/1000);
}

void Eia608_ControlCode_NotTwice_0 (struct MediaInfo_Event_Eia608_ControlCode_NotTwice_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1501\n");
    else
        echo0("CEA-608, Control Code not transmitted twice in successive frames\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    Character_1=%02x,",  Event->Character_1);
    echo1(   " Character_2=%02x\n",  Event->Character_2);
}

void Eia608_NoFieldMatch_0 (struct MediaInfo_Event_Eia608_NoFieldMatch_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1502\n");
    else
        echo0("CEA-608, non-printing character that does not match the data from the field\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void Eia608_CC_MoreThan32Chars_0 (struct MediaInfo_Event_Eia608_CC_MoreThan32Chars_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1503\n");
    else
        echo0("CEA-608, More than 32 Informational Characters\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x,", Event->Field);
    echo1(   " Service=%01x\n", Event->Service);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    Character=%c\n", Event->NewChar);
}

void Eia608_XDS_Current_ContentAdvisory_MPA_USTV_0 (struct MediaInfo_Event_Eia608_XDS_Current_ContentAdvisory_MPA_USTV_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1504\n");
    else
        echo0("CEA-608, MPA System is set, but TV Rating System is in use\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    Character_1=%02x,",  Event->Character_1);
    echo1(   " Character_2=%02x\n",  Event->Character_2);
}

void Eia608_XDS_Current_ContentAdvisory_USTV_MPA_0 (struct MediaInfo_Event_Eia608_XDS_Current_ContentAdvisory_USTV_MPA_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1505\n");
    else
        echo0("CEA-608, TV Rating System is set, but MPA System is in use\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    Character_1=%02x,",  Event->Character_1);
    echo1(   " Character_2=%02x\n",  Event->Character_2);
}

void Eia608_XDS_Current_CopyAndRedistributionControlPacket_0 (struct MediaInfo_Event_Eia608_XDS_Current_CopyAndRedistributionControlPacket_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1506 and 3026\n");
    else
        echo0("CEA-608, CGMS-A or APS is present\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    Byte_1=%02x,",  Event->Byte_1);
    echo1(   " Byte_2=%02x\n",  Event->Byte_2);
}

void Eia608_XDS_PublicService_NationalWeather_0 (struct MediaInfo_Event_Eia608_XDS_PublicService_NationalWeather_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1507\n");
    else
        echo0("CEA-608, National Weather Service is present\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void Eia608_IllegalCharacter_0 (struct MediaInfo_Event_Eia608_IllegalCharacter_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1508\n");
    else
        echo0("CEA-608, Illegal character\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    Character_1=%02x,",  Event->Character_1);
    echo1(   " Character_2=%02x\n",  Event->Character_2);
}

void Eia608_CC_MoreThan15Rows_0 (struct MediaInfo_Event_Eia608_CC_MoreThan15Rows_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1515\n");
    else
        echo0("CEA-608, More than 15 Rows\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x,", Event->Field);
    echo1(   " Service=%01x\n", Event->Service);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void Eia608_XDS_Field1_0 (struct MediaInfo_Event_Eia608_XDS_Field1_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1516\n");
    else
        echo0("CEA-608, XDS data in field 1\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void Eia608_XDS_Current_ContentAdvisory_Content_0 (struct MediaInfo_Event_Eia608_XDS_Current_ContentAdvisory_Content_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #3027\n");
    else
        echo0("CEA-608, ContentAdvisory Content information\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    Character_1=%02x,",  Event->Character_1);
    echo1(   " Character_2=%02x\n",  Event->Character_2);
}

void Eia608_CC_Content_0 (struct MediaInfo_Event_Eia608_CC_Content_0* Event, int DCA)
{
    int Pos;
    if (DCA)
        echo0("DCA #????\n");
    else
        echo0("Eia608, Content\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x,", Event->Field);
    echo1(   " Service=%01x\n", Event->Service);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);

    wecho0(L"    **********************************\n");
    for (Pos=0; Pos<15; Pos++)
    {
        wecho1(L"    *%ls*\n", (const wchar_t *)(Event->Row_Values[Pos]));
    }
    wecho0(L"    **********************************\n");
}

void Eia608_End_0 (struct MediaInfo_Event_Eia608_End_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1514 (CEA-708)\n");
    else
        echo0("Eia608, End\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    ContentDetected=%02x\n", Event->ContentDetected);
}

void DtvccTransport_cc_count_0 (struct MediaInfo_Event_DtvccTransport_cc_count_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1512 (DTVCC Transport / Total)\n");
    else
        echo0("DTVCC Transport, cc_count\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    cc_count=%i\n", Event->cc_count);
}

void DtvccTransport_Eia608_cc_count_0 (struct MediaInfo_Event_DtvccTransport_Eia608_cc_count_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1512 (DTVCC Transport / EIA-608)\n");
    else
        echo0("DTVCC Transport, EIA-608 cc_count\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    cc_count=%i\n", Event->cc_count);
}

void DtvccTransport_picture_structure_cc_type_0 (struct MediaInfo_Event_DtvccTransport_picture_structure_cc_type_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1513\n");
    else
        echo0("DTVCC Transport, picture_structure cc_type\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    picture_structure=%i,", Event->picture_structure);
    echo1(   " cc_type=%i\n", Event->cc_type);
}

void DtvccTransport_additional_data_flag_0 (struct MediaInfo_Event_DtvccTransport_additional_data_flag_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1651\n");
    else
        echo0("DTVCC Transport, additional_data_flag\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void DtvccCaption_WindowIsOutsideOfArea_Minimal_0 (struct MediaInfo_Event_DtvccCaption_WindowIsOutsideOfArea_Minimal_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1511\n");
    else
        echo0("DTVCC Caption, Window is outside of area (Minimal)\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Service=%01x,", Event->Service);
    echo1(   " Window=%01x\n", Event->Window);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    Row_Position=%02x,", Event->Row_Position);
    echo1(   " Row_Count=%02x\n", Event->Row_Count);
    echo1("    Column_Position=%02x,", Event->Column_Position);
    echo1(   " Column_Count=%02x\n", Event->Column_Count);
}

void DtvccCaption_ReservedCode_0 (struct MediaInfo_Event_DtvccCaption_ReservedCode_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1509\n");
    else
        echo0("DTVCC Caption, Reserved Code\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    Code=%01x\n", Event->Code[0]);
}

void DtvccCaption_wordwrap_Deprecated_0 (struct MediaInfo_Event_DtvccCaption_wordwrap_Deprecated_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1510\n");
    else
        echo0("DTVCC Caption, End\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Service=%01x,", Event->Service);
    echo1(   " Window=%01x\n", Event->Window);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void DtvccCaption_Content_Minimal_0 (struct MediaInfo_Event_DtvccCaption_Content_Minimal_0* Event, int DCA)
{
    size_t Pos;
    size_t Row_Length;
    if (DCA)
        echo0("DCA #????\n");
    else
        echo0("DTVCC Caption, Content\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Service=%01x\n", Event->Service);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);

    Row_Length=wcslen(Event->Row_Values[0]);
    wecho0(L"    *");
    for (Pos=0; Pos<Row_Length; Pos++)
        wecho0(L"*");
    wecho0(L"*\n");
    for (Pos=0; Pos<15; Pos++)
    {
        wecho1(L"    *%ls*\n", (const wchar_t *)(Event->Row_Values[Pos]));
    }
    wecho0(L"    *");
    for (Pos=0; Pos<Row_Length; Pos++)
        wecho0(L"*");
    wecho0(L"*\n");
}

void DtvccCaption_Window_Content_Minimal_0 (struct MediaInfo_Event_DtvccCaption_Window_Content_Minimal_0* Event, int DCA)
{
    size_t Pos;
    size_t Row_Length;
    if (DCA)
        echo0("DCA #????\n");
    else
        echo0("DTVCC Caption, Window content\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Service=%01x,", Event->Service);
    echo1(   " Window=%01x\n", Event->Window);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);

    Row_Length=wcslen(Event->Row_Values[0]);
    wecho0(L"    *");
    for (Pos=0; Pos<Row_Length; Pos++)
        wecho0(L"*");
    wecho0(L"*\n");
    for (Pos=0; Pos<15; Pos++)
    {
        wecho1(L"    *%ls*\n", (const wchar_t *)(Event->Row_Values[Pos]));
        if (Pos<15 && wcslen(Event->Row_Values[Pos+1])==0)
            break; //No more content in next lines
    }
    wecho0(L"    *");
    for (Pos=0; Pos<Row_Length; Pos++)
        wecho0(L"*");
    wecho0(L"*\n");
}

void DtvccCaption_End_0 (struct MediaInfo_Event_DtvccCaption_End_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1514 (CEA-708)\n");
    else
        echo0("DTVCC Caption, End\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    ContentDetected=%08x\n", Event->ContentDetected);
}

void Cdp_cc_count_0 (struct MediaInfo_Event_Cdp_cc_count_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1512 (CDP / Total)\n");
    else
        echo0("CDP, cc_count\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    cc_count=%i\n", Event->cc_count);
}

void Cdp_Eia608_cc_count_0 (struct MediaInfo_Event_Cdp_Eia608_cc_count_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1512 (CDP / EIA-608)\n");
    else
        echo0("CDP, EIA-608\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    cc_count=%i\n", Event->cc_count);
}

void Cdp_picture_structure_cc_type_0 (struct MediaInfo_Event_Cdp_picture_structure_cc_type_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1513 (CDP)\n");
    else
        echo0("CDP, picture_structure cc_type\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    picture_structure=%i,", Event->picture_structure);
    echo1(   " cc_type=%i\n", Event->cc_type);
}

void Scte20_cc_count_0 (struct MediaInfo_Event_Scte20_cc_count_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1512 (SCTE20 / Total)\n");
    else
        echo0("SCTE 20, cc_count\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    cc_count=%i\n", Event->cc_count);
}

void Scte20_Eia608_cc_count_0 (struct MediaInfo_Event_Scte20_Eia608_cc_count_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1512 (SCTE20 / EIA-608)\n");
    else
        echo0("SCTE 20, EIA-608\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1(   " Field=%01x\n", Event->Field);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    cc_count=%i\n", Event->cc_count);
}

void Scte20_picture_structure_cc_type_0 (struct MediaInfo_Event_Scte20_picture_structure_cc_type_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1513 (SCTE20)\n");
    else
        echo0("SCTE 20, picture_structure cc_type\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    picture_structure=%i,", Event->picture_structure);
    echo1(   " cc_type=%i\n", Event->cc_type);
}

void Scte20_field_number_Forbidden_0 (struct MediaInfo_Event_Scte20_field_number_Forbidden_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #1601\n");
    else
        echo0("SCTE 20, field_number_Forbidden\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x\n", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
}

void xxx_GOP_ByteSize_IllegalForCustomer0_0 (struct MediaInfo_Event_Mpegv_GOP_ByteSize_IllegalForCustomer0_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #3035\n");
    else
        echo0("AVC/VC-1/MPEG Video, GOP size is illegal for customer\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    echo1("    PID=%04x,", Event->PID);
    echo1(   " stream_id=%02x,", Event->stream_id);
    echo1("    PCR=%s,", Event->PCR_HR);
    echo1(   " PTS=%s\n", Event->PTS_HR);
    echo1("    GOP Byte size=%i,", Event->GOP_ByteSize);
}

void Global_TimeCode_Discountinuity_0 (struct MediaInfo_Event_Global_TimeCode_Discountinuity_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA #2008/3036\n");
    else
        echo0("Global, Time code discountinuity\n");
    echo1("    Stream_Offset=%08x,", Event->Stream_Offset);
    echo1(   " Frame_Number=%u\n", Event->Frame_Number);
    if (Event->IsRaw)
    {
        echo1("    PID=%04x,", Event->PID);
        echo1(   " stream_id=%02x,", Event->stream_id);
        echo1("    PCR=%s,", Event->PCR_HR);
        echo1(   " PTS=%s\n", Event->PTS_HR);
    }
    echo1("    TimeCode: Previous=%s,", Event->Previous_HR);
    echo1(   " Theory=%s,", Event->Theory_HR);
    echo1(   " Reality=%s\n", Event->Reality_HR);
}

void General_Start_0 (struct MediaInfo_Event_General_Start_0* Event, int DCA)
{
    if (DCA)
    {
        return; //No DCA need
    }

    echo1("MediaInfo starts, Size=%i bytes\n", Event->Stream_Size);
}

void General_End_0 (struct MediaInfo_Event_General_End_0* Event, int DCA)
{
    if (DCA)
    {
        return; //No DCA need
    }

    echo1("MediaInfo ends, %i bytes read\n", Event->Stream_Bytes_Analyzed);
}

void General_Parser_Selected_0 (struct MediaInfo_Event_General_Parser_Selected_0* Event, int DCA)
{
    if (DCA)
    {
        return; //No DCA need
    }

    echo1("MediaInfo has selected the parser: %s\n", Event->Name);
}

void General_Move_Request_0 (struct MediaInfo_Event_General_Move_Request_0* Event, int DCA)
{
    if (DCA)
    {
        return; //No DCA need
    }

    echo1("MediaInfo has requested to seek, Offset=%08x\n", Event->Stream_Offset);
}

void General_Move_Done_0 (struct MediaInfo_Event_General_Move_Done_0* Event, int DCA)
{
    if (DCA)
    {
        return; //No DCA need
    }

    echo1("MediaInfo has seek, Offset=%08x\n", Event->Stream_Offset);
}

void General_SubFile_Start_0 (struct MediaInfo_Event_General_SubFile_Start_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA Start of subfile\n");
    else
        echo0("MediaInfo is parsing a new file from the source file\n");
    echo1("    FileName_Relative=%s\n", Event->FileName_Relative);
    echo1("    FileName_Absolute=%s\n", Event->FileName_Absolute);
}

void General_SubFile_End_0 (struct MediaInfo_Event_General_SubFile_End_0* Event, int DCA)
{
    if (DCA)
        echo0("DCA End of subfile\n");
    else
        echo0("has finished the parsing a new file from the source file\n");
}

/***************************************************************************/
/* The callback function                                                   */
/***************************************************************************/

#define CASE(_PARSER,_EVENT,_VERSION) \
    case MediaInfo_Event_##_PARSER##_##_EVENT : if (EventVersion==_VERSION && Data_Size>=sizeof(struct MediaInfo_Event_##_PARSER##_##_EVENT##_##_VERSION)) _PARSER##_##_EVENT##_##_VERSION((struct MediaInfo_Event_##_PARSER##_##_EVENT##_##_VERSION*)Data_Content, UserHandler->Option_DCA); break;

void __stdcall Event_CallBackFunction(unsigned char* Data_Content, size_t Data_Size, void* UserHandler_Void)
{
    /*Retrieving UserHandler*/
    struct UserHandle_struct*           UserHandler=(struct UserHandle_struct*)UserHandler_Void;
    struct MediaInfo_Event_Generic*     Event_Generic=(struct MediaInfo_Event_Generic*) Data_Content;
    unsigned char                       ParserID;
    unsigned short                      EventID;
    unsigned char                       EventVersion;

    /*integrity tests*/
    if (Data_Size<4)
        return; //There is a problem

    #ifdef MEDIAINFO_REGRESSION_TEST
    {
        char FileName[65536];
        char Temp[100];
        size_t Pos;
        strcpy(FileName, "..\\..\\..\\..\\..\\..\\MediaInfoLib_DCA_RegressionTest\\New\\");
        strcpy(FileName+strlen(FileName), F_FileName);
        CreateDirectory(FileName, NULL);
        strcpy(FileName+strlen(FileName), "\\");
        sprintf(Temp, "%x", Event_Generic->EventCode);
        for (Pos=8; Pos>strlen(Temp); Pos--)
            strcpy(FileName+strlen(FileName), "0");
        strcpy(FileName+strlen(FileName), Temp);
        strcpy(FileName+strlen(FileName), ".txt");
        F=fopen(FileName, "a");
    }
    #endif //MEDIAINFO_REGRESSION_TEST
    
    /*Do what you need with the event, here is only an example*/
    /*Retrieving EventID*/
    ParserID    =(unsigned char) ((Event_Generic->EventCode&0xFF000000)>>24);
    EventID     =(unsigned short)((Event_Generic->EventCode&0x00FFFF00)>>8 );
    EventVersion=(unsigned char) ( Event_Generic->EventCode&0x000000FF     );

    /*Global to all parsers*/
    switch (EventID)
    {
        CASE (Global, TimeCode_Discountinuity, 0)
        default                                                                                 : ;
    }

    switch (ParserID)
    {
           /*DCA number in comment*/
        case MediaInfo_Parser_None :    
                switch (EventID)
                {
                    case MediaInfo_Event_General_Start                                          : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_General_Start_0)) General_Start_0((struct MediaInfo_Event_General_Start_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_General_End                                            : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_General_End_0)) General_End_0((struct MediaInfo_Event_General_End_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_General_Parser_Selected                                : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_General_Parser_Selected_0)) General_Parser_Selected_0((struct MediaInfo_Event_General_Parser_Selected_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_General_Move_Request                                   : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_General_Move_Request_0)) General_Move_Request_0((struct MediaInfo_Event_General_Move_Request_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_General_Move_Done                                      : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_General_Move_Done_0)) General_Move_Done_0((struct MediaInfo_Event_General_Move_Done_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_General_SubFile_Start                                  : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_General_SubFile_Start_0)) General_SubFile_Start_0((struct MediaInfo_Event_General_SubFile_Start_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_General_SubFile_End                                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_General_SubFile_End_0)) General_SubFile_End_0((struct MediaInfo_Event_General_SubFile_End_0*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_MpegTs :    
                switch (EventID)
                {    
           /*1001*/ case MediaInfo_Event_MpegTs_PID_Reserved                                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PID_Reserved_0)) MpegTs_PID_Reserved_0((struct MediaInfo_Event_MpegTs_PID_Reserved_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1002*/ case MediaInfo_Event_MpegTs_continuity_counter_Check_NoPayload              : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_continuity_counter_Check_NoPayload_0)) MpegTs_continuity_counter_Check_NoPayload_0((struct MediaInfo_Event_MpegTs_continuity_counter_Check_NoPayload_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1003*/ case MediaInfo_Event_MpegTs_continuity_counter_Check_Payload                : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_continuity_counter_Check_Payload_0)) MpegTs_continuity_counter_Check_Payload_0((struct MediaInfo_Event_MpegTs_continuity_counter_Check_Payload_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1004*/ case MediaInfo_Event_MpegTs_splice_type_Reserved                            : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_splice_type_Reserved_0)) MpegTs_splice_type_Reserved_0((struct MediaInfo_Event_MpegTs_splice_type_Reserved_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1005*/ case MediaInfo_Event_MpegTs_profile_level_NoMatch                           : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_profile_level_NoMatch_0)) MpegTs_profile_level_NoMatch_0((struct MediaInfo_Event_MpegTs_profile_level_NoMatch_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1006*/ case MediaInfo_Event_MpegTs_SampleRate_NotConstant_Audio                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_SampleRate_NotConstant_Audio_0)) MpegTs_SampleRate_NotConstant_Audio_0((struct MediaInfo_Event_MpegTs_SampleRate_NotConstant_Audio_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1007*/ case MediaInfo_Event_MpegTs_SampleRate_NotConstant_Video                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_SampleRate_NotConstant_Video_0)) MpegTs_SampleRate_NotConstant_Video_0((struct MediaInfo_Event_MpegTs_SampleRate_NotConstant_Video_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1008*/ case MediaInfo_Event_MpegTs_OutOfSync                                       : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_OutOfSync_0)) MpegTs_OutOfSync_0((struct MediaInfo_Event_MpegTs_OutOfSync_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_MpegTs_End                                             : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_End_0)) MpegTs_End_0((struct MediaInfo_Event_MpegTs_End_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1011*/ case MediaInfo_Event_MpegTs_TS_program_map_section_NonExistentPID           : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_TS_program_map_section_NonExistentPID_0)) MpegTs_TS_program_map_section_NonExistentPID_0((struct MediaInfo_Event_MpegTs_TS_program_map_section_NonExistentPID_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_MpegTs_continuity_counter_Duplicate                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_continuity_counter_Duplicate_0)) MpegTs_continuity_counter_Duplicate_0((struct MediaInfo_Event_MpegTs_continuity_counter_Duplicate_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1012*/ case MediaInfo_Event_MpegTs_transport_error_indicator_Check                 : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_transport_error_indicator_Check_0)) MpegTs_transport_error_indicator_Check_0((struct MediaInfo_Event_MpegTs_transport_error_indicator_Check_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.001*/ case MediaInfo_Event_MpegTs_PAT_MultiplePrograms                            : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PAT_MultiplePrograms_0)) MpegTs_PAT_MultiplePrograms_0((struct MediaInfo_Event_MpegTs_PAT_MultiplePrograms_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.002*/ case MediaInfo_Event_MpegTs_PMT_NoAudioStreams                              : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PMT_NoAudioStreams_0)) MpegTs_PMT_NoAudioStreams_0((struct MediaInfo_Event_MpegTs_PMT_NoAudioStreams_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.003*/ case MediaInfo_Event_MpegTs_PacketSize_Not188                               : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PacketSize_Not188_0)) MpegTs_PacketSize_Not188_0((struct MediaInfo_Event_MpegTs_PacketSize_Not188_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.004*/ case MediaInfo_Event_MpegTs_Junk_Begin                                      : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_Junk_Begin_0)) MpegTs_Junk_Begin_0((struct MediaInfo_Event_MpegTs_Junk_Begin_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.005*/ case MediaInfo_Event_MpegTs_Junk_End                                        : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_Junk_End_0)) MpegTs_Junk_End_0((struct MediaInfo_Event_MpegTs_Junk_End_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.007*/ case MediaInfo_Event_MpegTs_PCR_NotWithVideo                                : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PCR_NotWithVideo_0)) MpegTs_PCR_NotWithVideo_0((struct MediaInfo_Event_MpegTs_PCR_NotWithVideo_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_MpegTs_PES_Video_PCR_NotAtStart                        : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PES_Video_PCR_NotAtStart_0)) MpegTs_PES_Video_PCR_NotAtStart_0((struct MediaInfo_Event_MpegTs_PES_Video_PCR_NotAtStart_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.008*/ case MediaInfo_Event_MpegTs_PES_Video_PCR_NotAtStart_PerFrame               : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PES_Video_PCR_NotAtStart_PerFrame_0)) MpegTs_PES_Video_PCR_NotAtStart_PerFrame_0((struct MediaInfo_Event_MpegTs_PES_Video_PCR_NotAtStart_PerFrame_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.009*/ case MediaInfo_Event_MpegTs_discontinuity_indicator_NotInFirstPCR           : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_discontinuity_indicator_NotInFirstPCR_0)) MpegTs_discontinuity_indicator_NotInFirstPCR_0((struct MediaInfo_Event_MpegTs_discontinuity_indicator_NotInFirstPCR_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.010*/ case MediaInfo_Event_MpegTs_random_access_indicator_NotWithPictureI         : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_random_access_indicator_NotWithPictureI_0)) MpegTs_random_access_indicator_NotWithPictureI_0((struct MediaInfo_Event_MpegTs_random_access_indicator_NotWithPictureI_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.011*/ case MediaInfo_Event_MpegTs_PCR_Accuracy                                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PCR_Accuracy_0)) MpegTs_PCR_Accuracy_0((struct MediaInfo_Event_MpegTs_PCR_Accuracy_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.012*/ case MediaInfo_Event_MpegTs_BitRate_NotConstant                             : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_BitRate_NotConstant_0)) MpegTs_BitRate_NotConstant_0((struct MediaInfo_Event_MpegTs_BitRate_NotConstant_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7379*/ case MediaInfo_Event_MpegTs_BitRate_MoreThan3dot75Mbps                      : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_BitRate_MoreThan3dot75Mbps_0)) MpegTs_BitRate_MoreThan3dot75Mbps_0((struct MediaInfo_Event_MpegTs_BitRate_MoreThan3dot75Mbps_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7381*/ case MediaInfo_Event_MpegTs_BitRate_MoreThan19Mbps                          : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_BitRate_MoreThan19Mbps_0)) MpegTs_BitRate_MoreThan19Mbps_0((struct MediaInfo_Event_MpegTs_BitRate_MoreThan19Mbps_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7382*/ case MediaInfo_Event_MpegTs_BitRate_MoreThan15Mbps                          : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_BitRate_MoreThan15Mbps_0)) MpegTs_BitRate_MoreThan15Mbps_0((struct MediaInfo_Event_MpegTs_BitRate_MoreThan15Mbps_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7384*/ case MediaInfo_Event_MpegTs_BitRate_MoreThan20Mbps                          : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_BitRate_MoreThan20Mbps_0)) MpegTs_BitRate_MoreThan20Mbps_0((struct MediaInfo_Event_MpegTs_BitRate_MoreThan20Mbps_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.013*/ case MediaInfo_Event_MpegTs_BitRate_IllegalForCustomer0                     : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_BitRate_IllegalForCustomer0_0)) MpegTs_BitRate_IllegalForCustomer0_0((struct MediaInfo_Event_MpegTs_BitRate_IllegalForCustomer0_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_MpegTs_PID_Detected                                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PID_Detected_0)) MpegTs_PID_Detected_0((struct MediaInfo_Event_MpegTs_PID_Detected_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.014*/ case MediaInfo_Event_MpegTs_PID_IllegalForCustomer0                         : if (EventVersion==2 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PID_IllegalForCustomer0_2)) MpegTs_PID_IllegalForCustomer0_2((struct MediaInfo_Event_MpegTs_PID_IllegalForCustomer0_2*)Data_Content, UserHandler->Option_DCA); break;
           /*7376*/ case MediaInfo_Event_MpegTs_PID_IllegalForCableLabsVOD                      : if (EventVersion==2 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PID_IllegalForCableLabsVOD_2)) MpegTs_PID_IllegalForCableLabsVOD_2((struct MediaInfo_Event_MpegTs_PID_IllegalForCableLabsVOD_2*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.014*/ case MediaInfo_Event_MpegTs_PMT_stream_type_Unknown                         : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PMT_stream_type_Unknown_0)) MpegTs_PMT_stream_type_Unknown_0((struct MediaInfo_Event_MpegTs_PMT_stream_type_Unknown_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.014*/ case MediaInfo_Event_MpegTs_PID_Unreferenced                                : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PID_Unreferenced_0)) MpegTs_PID_Unreferenced_0((struct MediaInfo_Event_MpegTs_PID_Unreferenced_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.015*/ case MediaInfo_Event_MpegTs_PAT_PMT_NotPresent                              : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PAT_PMT_NotPresent_0)) MpegTs_PAT_PMT_NotPresent_0((struct MediaInfo_Event_MpegTs_PAT_PMT_NotPresent_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.015*/ case MediaInfo_Event_MpegTs_PAT_transport_stream_id_IllegalForCustomer0     : if (EventVersion==1 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PAT_transport_stream_id_IllegalForCustomer0_1)) MpegTs_PAT_transport_stream_id_IllegalForCustomer0_1((struct MediaInfo_Event_MpegTs_PAT_transport_stream_id_IllegalForCustomer0_1*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.015*/ case MediaInfo_Event_MpegTs_PMT_program_number_IllegalForCustomer0          : if (EventVersion==1 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PMT_program_number_IllegalForCustomer0_1)) MpegTs_PMT_program_number_IllegalForCustomer0_1((struct MediaInfo_Event_MpegTs_PMT_program_number_IllegalForCustomer0_1*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.016*/ case MediaInfo_Event_MpegTs_PAT_TooLate                                     : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PAT_TooLate_0)) MpegTs_PAT_TooLate_0((struct MediaInfo_Event_MpegTs_PAT_TooLate_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.017*/ case MediaInfo_Event_MpegTs_PAT_Repetition_Not100ms                         : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PAT_Repetition_Not100ms_0)) MpegTs_PAT_Repetition_Not100ms_0((struct MediaInfo_Event_MpegTs_PAT_Repetition_Not100ms_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.018*/ case MediaInfo_Event_MpegTs_PAT_New                                         : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PAT_New_0)) MpegTs_PAT_New_0((struct MediaInfo_Event_MpegTs_PAT_New_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.019*/ case MediaInfo_Event_MpegTs_PAT_NoPAS                                       : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PAT_NoPAS_0)) MpegTs_PAT_NoPAS_0((struct MediaInfo_Event_MpegTs_PAT_NoPAS_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.020*/ case MediaInfo_Event_MpegTs_PAT_current_next_indicator_NotSet               : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PAT_current_next_indicator_NotSet_0)) MpegTs_PAT_current_next_indicator_NotSet_0((struct MediaInfo_Event_MpegTs_PAT_current_next_indicator_NotSet_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.021*/ case MediaInfo_Event_MpegTs_network_PID_InUse                               : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_network_PID_InUse_0)) MpegTs_network_PID_InUse_0((struct MediaInfo_Event_MpegTs_network_PID_InUse_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.022*/ case MediaInfo_Event_MpegTs_PMT_TooLate                                     : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PMT_TooLate_0)) MpegTs_PMT_TooLate_0((struct MediaInfo_Event_MpegTs_PMT_TooLate_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.023*/ case MediaInfo_Event_MpegTs_PMT_Repetition_Not100ms                         : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PMT_Repetition_Not100ms_0)) MpegTs_PMT_Repetition_Not100ms_0((struct MediaInfo_Event_MpegTs_PMT_Repetition_Not100ms_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.024*/ case MediaInfo_Event_MpegTs_PMT_New                                         : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PMT_New_0)) MpegTs_PMT_New_0((struct MediaInfo_Event_MpegTs_PMT_New_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.025*/ case MediaInfo_Event_MpegTs_PMT_NoPMS                                       : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PMT_NoPMS_0)) MpegTs_PMT_NoPMS_0((struct MediaInfo_Event_MpegTs_PMT_NoPMS_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_MpegTs_PES_Information                                 : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PES_Information_0)) MpegTs_PES_Information_0((struct MediaInfo_Event_MpegTs_PES_Information_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.026*/ case MediaInfo_Event_MpegTs_PES_stream_type_IllegalForCustomer0             : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PES_stream_type_IllegalForCustomer0_0)) MpegTs_PES_stream_type_IllegalForCustomer0_0((struct MediaInfo_Event_MpegTs_PES_stream_type_IllegalForCustomer0_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.026*/ case MediaInfo_Event_MpegTs_PMT_stream_type_DoesNotFit                      : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PMT_stream_type_DoesNotFit_0)) MpegTs_PMT_stream_type_DoesNotFit_0((struct MediaInfo_Event_MpegTs_PMT_stream_type_DoesNotFit_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.027*/ case MediaInfo_Event_MpegTs_PMT_descriptor_tag_IllegalForCustomer0          : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PMT_descriptor_tag_IllegalForCustomer0_0)) MpegTs_PMT_descriptor_tag_IllegalForCustomer0_0((struct MediaInfo_Event_MpegTs_PMT_descriptor_tag_IllegalForCustomer0_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7702.030*/ case MediaInfo_Event_MpegTs_PES_PCR_Repetition_Not40ms                      : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PES_PCR_Repetition_Not40ms_0)) MpegTs_PES_PCR_Repetition_Not40ms_0((struct MediaInfo_Event_MpegTs_PES_PCR_Repetition_Not40ms_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7604*/     CASE (MpegTs, PES_PCR_Repetition_MoreThan40ms, 0)
       /*7604*/     CASE (MpegTs, PAT_MoreThan2Sections, 0)
       /*7604*/     CASE (MpegTs, PMT_IsMissing, 0)
       /*7604*/     CASE (MpegTs, PID_IsMissing, 0)
       /*7374*/     case MediaInfo_Event_MpegTs_PAT_Repetition_MoreThan250ms                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PAT_Repetition_MoreThan250ms_0)) MpegTs_PAT_Repetition_MoreThan250ms_0((struct MediaInfo_Event_MpegTs_PAT_Repetition_MoreThan250ms_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7374*/     case MediaInfo_Event_MpegTs_PMT_Repetition_MoreThan250ms                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PMT_Repetition_MoreThan250ms_0)) MpegTs_PMT_Repetition_MoreThan250ms_0((struct MediaInfo_Event_MpegTs_PMT_Repetition_MoreThan250ms_0*)Data_Content, UserHandler->Option_DCA); break;
/*7702.115*//*216*/ case MediaInfo_Event_MpegTs_Stream_Start_TooLate                            : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_Stream_Start_TooLate_0)) MpegTs_Stream_Start_TooLate_0((struct MediaInfo_Event_MpegTs_Stream_Start_TooLate_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7301*/ case MediaInfo_Event_MpegTs_BitRate_IllegalForScte54                        : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_BitRate_IllegalForScte54_0)) MpegTs_BitRate_IllegalForScte54_0((struct MediaInfo_Event_MpegTs_BitRate_IllegalForScte54_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7358*/ case MediaInfo_Event_MpegTs_PMT_registration_tag_IllegalForScte35           : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_PMT_registration_tag_IllegalForScte35_0)) MpegTs_PMT_registration_tag_IllegalForScte35_0((struct MediaInfo_Event_MpegTs_PMT_registration_tag_IllegalForScte35_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7359*/ case MediaInfo_Event_MpegTs_Scte35_segmentation_End                         : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_Scte35_segmentation_End_0)) MpegTs_Scte35_segmentation_End_0((struct MediaInfo_Event_MpegTs_Scte35_segmentation_End_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_MpegTs_Scte35_Splice_Insert                            : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegTs_Scte35_Splice_Insert_0)) MpegTs_Scte35_Splice_Insert_0((struct MediaInfo_Event_MpegTs_Scte35_Splice_Insert_0*)Data_Content, UserHandler->Option_DCA); break;
                    CASE (MpegTs, payload_unit_start_indicator, 0)
   /*1019*//*1020*/ CASE (MpegTs, transport_scrambling_control, 0)
                    CASE (MpegTs, adaptation_field_control, 0)
                    CASE (MpegTs, duplicate_packet, 0)
                    CASE (MpegTs, adaptation_field_length, 0)
                    CASE (MpegTs, random_access_indicator, 0)
                    CASE (MpegTs, random_access_PCR, 0)
                    CASE (MpegTs, random_access_PTS, 0)
                    CASE (MpegTs, elementary_stream_priority_indicator, 0)
                    CASE (MpegTs, PCR_OPCR_flags, 0)
                    CASE (MpegTs, transport_private_data, 0)
                    CASE (MpegTs, sections_section_length, 0)
                    CASE (MpegTs, sections_current_next_indicator, 0)
           /*7604*/ CASE (MpegTs, sections_CRC_32, 0)
                    CASE (MpegTs, sections_AfterCRC_32, 0)
                    CASE (MpegTs, sections_NextPacketIssue, 0)
           /*1019*/ CASE (MpegTs, PAT_table_id, 0)
           /*1019*/ CASE (MpegTs, PAT_section_syntax_indicator, 0)
           /*1019*/ CASE (MpegTs, PAT_section_length, 0)
           /*1019*/ CASE (MpegTs, PAT_transport_stream_id, 0)
           /*1019*/ CASE (MpegTs, PAT_version_number, 0)
           /*1019*/ CASE (MpegTs, PAT_program_number, 0)
           /*1019*/ CASE (MpegTs, PAT_network_PID, 0)
           /*1019*/ CASE (MpegTs, PAT_program_PID, 0)
           /*1019*/ CASE (MpegTs, PAT_table_id_OtherPIDs, 0)
           /*1020*/ CASE (MpegTs, PMT_table_id, 0)
           /*1020*/ CASE (MpegTs, PMT_section_syntax_indicator, 0)
           /*1020*/ CASE (MpegTs, PMT_Zero, 0)
           /*1020*/ CASE (MpegTs, PMT_section_length, 0)
           /*1020*/ CASE (MpegTs, PMT_program_number, 0)
           /*1020*/ CASE (MpegTs, PMT_PCR_PID, 0)
           /*1020*/ CASE (MpegTs, PMT_program_info_length, 0)
           /*1020*/ CASE (MpegTs, PMT_descriptor, 0)
           /*1020*/ CASE (MpegTs, PMT_stream_type, 0)
           /*1020*/ CASE (MpegTs, PMT_elementary_PID, 0)
           /*1020*/ CASE (MpegTs, PMT_ES_info_length, 0)
           /*1020*/ CASE (MpegTs, PMT_ES_info_descriptor, 0)
                    CASE (MpegTs, CAT_PID1, 0)
                    CASE (MpegTs, CAT_table_id, 0)
                    CASE (MpegTs, CAT_section_syntax_indicator, 0)
                    CASE (MpegTs, CAT_Zero, 0)
                    CASE (MpegTs, CAT_section_length, 0)
                    CASE (MpegTs, CAT_version_number, 0)
                    CASE (MpegTs, CAT_descriptor, 0)
                    CASE (MpegTs, NIT_table_id, 0)
           /*1021*/ CASE (MpegTs, descriptor_length, 0)
           /*1021*/ CASE (MpegTs, descriptors_length, 0)
           /*1022*/ CASE (MpegTs, video_stream_frame_rate_code, 0)
           /*1022*/ CASE (MpegTs, video_stream_MPEG_1_only_flag, 0)
           /*1022*/ CASE (MpegTs, video_stream_Constrained_parameter_flag, 0)
           /*1022*/ CASE (MpegTs, video_stream_Still_picture_flag, 0)
           /*1022*/ CASE (MpegTs, video_stream_Profile_and_level_indication, 0)
           /*1022*/ CASE (MpegTs, video_stream_chroma_format, 0)
           /*1022*/ CASE (MpegTs, video_stream_frame_rate_extension_flag, 0)
           /*1023*/ CASE (MpegTs, audio_stream_free_format_flag, 0)
           /*1023*/ CASE (MpegTs, audio_stream_ID, 0)
           /*1023*/ CASE (MpegTs, audio_stream_layer, 0)
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_MpegPs :    
                switch (EventID)
                {    
           /*1051*/ case MediaInfo_Event_MpegPs_SampleRate_NotConstant_Audio                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegPs_SampleRate_NotConstant_Audio_0)) MpegPs_SampleRate_NotConstant_Audio_0((struct MediaInfo_Event_MpegPs_SampleRate_NotConstant_Audio_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1052*/ case MediaInfo_Event_MpegPs_SampleRate_NotConstant_Video                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegPs_SampleRate_NotConstant_Video_0)) MpegPs_SampleRate_NotConstant_Video_0((struct MediaInfo_Event_MpegPs_SampleRate_NotConstant_Video_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1053*/ case MediaInfo_Event_MpegPs_program_stream_map_NonExistentESID              : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegPs_program_stream_map_NonExistentESID_0)) MpegPs_program_stream_map_NonExistentESID_0((struct MediaInfo_Event_MpegPs_program_stream_map_NonExistentESID_0*)Data_Content, UserHandler->Option_DCA); break;
/*7702.112*//*213*/ case MediaInfo_Event_MpegPs_PES_Start_NotAligned                            : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegPs_PES_Start_NotAligned_0)) MpegPs_PES_Start_NotAligned_0((struct MediaInfo_Event_MpegPs_PES_Start_NotAligned_0*)Data_Content, UserHandler->Option_DCA); break;
/*7702.113*//*214*/ case MediaInfo_Event_MpegPs_PES_NotOnePerFrame                              : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegPs_PES_NotOnePerFrame_0)) MpegPs_PES_NotOnePerFrame_0((struct MediaInfo_Event_MpegPs_PES_NotOnePerFrame_0*)Data_Content, UserHandler->Option_DCA); break;
/*7702.116*//*217*/ case MediaInfo_Event_MpegPs_PES_IFrame_NoTimeStamps                         : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_MpegPs_PES_IFrame_NoTimeStamps_0)) MpegPs_PES_IFrame_NoTimeStamps_0((struct MediaInfo_Event_MpegPs_PES_IFrame_NoTimeStamps_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7302*/ case MediaInfo_Event_MpegPs_PES_IllegalForScte54                            : if (EventVersion==1 && Data_Size==sizeof(struct MediaInfo_Event_MpegPs_PES_IllegalForScte54_1)) MpegPs_PES_IllegalForScte54_1((struct MediaInfo_Event_MpegPs_PES_IllegalForScte54_1*)Data_Content, UserHandler->Option_DCA); break;
           /*1018*/ CASE (MpegPs, stream_id, 0)
           /*1018*/ CASE (MpegPs, PES_packet_length, 0)
           /*1018*/ CASE (MpegPs, data_alignment_indicator, 0)
           /*1018*/ CASE (MpegPs, PTS_DTS_flags, 0)
           /*1018*/ CASE (MpegPs, PES_header_data_length, 0)
           /*1018*/ CASE (MpegPs, Timestamps, 0)
           /*1018*/ CASE (MpegPs, rep_cntrl, 0)
           /*1018*/ CASE (MpegPs, previous_PES_packet_CRC, 0)
           /*1018*/ CASE (MpegPs, pack_header_field_flag, 0)
           /*1018*/ CASE (MpegPs, program_packet_sequence_counter, 0)
           /*1018*/ CASE (MpegPs, original_stuff_length, 0)
           /*1018*/ CASE (MpegPs, P_STD_buffer_scale, 0)
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_Gxf :    
                switch (EventID)
                {    
           /*1852*/ case MediaInfo_Event_Gxf_Header_PacketType_Unknown                          : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Gxf_Header_PacketType_Unknown_0)) Gxf_Header_PacketType_Unknown_0((struct MediaInfo_Event_Gxf_Header_PacketType_Unknown_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1853*/ case MediaInfo_Event_Gxf_Header_Reserved_NotZero                            : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Gxf_Header_Reserved_NotZero_0))Gxf_Header_Reserved_NotZero_0((struct MediaInfo_Event_Gxf_Header_Reserved_NotZero_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1854*/ case MediaInfo_Event_Gxf_Media_MediaType_Unknown                            : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Gxf_Media_MediaType_Unknown_0))Gxf_Media_MediaType_Unknown_0((struct MediaInfo_Event_Gxf_Media_MediaType_Unknown_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7704.001*/ case MediaInfo_Event_Gxf_NotSimpleClip                                      : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Gxf_NotSimpleClip_0)) Gxf_NotSimpleClip_0((struct MediaInfo_Event_Gxf_NotSimpleClip_0*)Data_Content, UserHandler->Option_DCA); break;
       /*7704.015*/ case MediaInfo_Event_Gxf_TimeCode_NotValid                                  : if (EventVersion==1 && Data_Size==sizeof(struct MediaInfo_Event_Gxf_TimeCode_NotValid_0)) Gxf_TimeCode_NotValid_1((struct MediaInfo_Event_Gxf_TimeCode_NotValid_1*)Data_Content, UserHandler->Option_DCA); break;
/*7704.016* *1855*/ case MediaInfo_Event_Gxf_TimeCode_NotContinuous                             : if (EventVersion==1 && Data_Size==sizeof(struct MediaInfo_Event_Gxf_TimeCode_NotContinuous_0))Gxf_TimeCode_NotContinuous_1((struct MediaInfo_Event_Gxf_TimeCode_NotContinuous_1*)Data_Content, UserHandler->Option_DCA); break;
       /*7704.017*/ case MediaInfo_Event_Gxf_TimeCode_DropFrameIssue                            : if (EventVersion==1 && Data_Size==sizeof(struct MediaInfo_Event_Gxf_TimeCode_DropFrameIssue_0)) Gxf_TimeCode_DropFrameIssue_1((struct MediaInfo_Event_Gxf_TimeCode_DropFrameIssue_1*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_Mxf :    
                switch (EventID)
                {    
           /*7640*/ case MediaInfo_Event_Mxf_BodyPartition_NoGop                                : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mxf_BodyPartition_NoGop_0)) Mxf_BodyPartition_NoGop_0((struct MediaInfo_Event_Mxf_BodyPartition_NoGop_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7640*/ case MediaInfo_Event_Mxf_BodyPartition_MoreThan10seconds                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mxf_BodyPartition_MoreThan10seconds_0)) Mxf_BodyPartition_MoreThan10seconds_0((struct MediaInfo_Event_Mxf_BodyPartition_MoreThan10seconds_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7640*/ case MediaInfo_Event_Mxf_BodyPartition_NotFollowedByIFrame                  : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mxf_BodyPartition_NotFollowedByIFrame_0)) Mxf_BodyPartition_NotFollowedByIFrame_0((struct MediaInfo_Event_Mxf_BodyPartition_NotFollowedByIFrame_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7640*/ case MediaInfo_Event_Mxf_IndexTable_Duration_NotSame                        : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mxf_IndexTable_Duration_NotSame_0)) Mxf_IndexTable_Duration_NotSame_0((struct MediaInfo_Event_Mxf_IndexTable_Duration_NotSame_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7659*/ case MediaInfo_Event_Mxf_BodyPartition_PartitionSpacing_NotAs02             : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mxf_BodyPartition_PartitionSpacing_NotAs02_0)) Mxf_BodyPartition_PartitionSpacing_NotAs02_0((struct MediaInfo_Event_Mxf_BodyPartition_PartitionSpacing_NotAs02_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7660*/ case MediaInfo_Event_Mxf_HeaderPartition_NotFirstByte                       : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mxf_HeaderPartition_NotFirstByte_0)) Mxf_HeaderPartition_NotFirstByte_0((struct MediaInfo_Event_Mxf_HeaderPartition_NotFirstByte_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7662*/ case MediaInfo_Event_Mxf_FooterNotFollowedByRip                             : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mxf_FooterNotFollowedByRip_0)) Mxf_FooterNotFollowedByRip_0((struct MediaInfo_Event_Mxf_FooterNotFollowedByRip_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7662*/ case MediaInfo_Event_Mxf_Partition_NotClosedComplete                        : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mxf_Partition_NotClosedComplete_0)) Mxf_Partition_NotClosedComplete_0((struct MediaInfo_Event_Mxf_Partition_NotClosedComplete_0*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_Mpegv :    
                switch (EventID)
                {    
           /*1207*/ case MediaInfo_Event_Mpegv_sequence_header_NotSame                          : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mpegv_sequence_header_NotSame_0)) Mpegv_sequence_header_NotSame_0((struct MediaInfo_Event_Mpegv_sequence_header_NotSame_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1207*/ case MediaInfo_Event_Mpegv_sequence_extension_NotSame                       : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mpegv_sequence_extension_NotSame_0)) Mpegv_sequence_extension_NotSame_0((struct MediaInfo_Event_Mpegv_sequence_extension_NotSame_0*)Data_Content, UserHandler->Option_DCA); break;
           /*3013*/ case MediaInfo_Event_Mpegv_group_start_closed_gop                           : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mpegv_group_start_closed_gop_0)) Mpegv_group_start_closed_gop_0((struct MediaInfo_Event_Mpegv_group_start_closed_gop_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7035*/ case MediaInfo_Event_Mpegv_GOP_ByteSize_IllegalForCustomer0                 : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mpegv_GOP_ByteSize_IllegalForCustomer0_0)) xxx_GOP_ByteSize_IllegalForCustomer0_0((struct MediaInfo_Event_Mpegv_GOP_ByteSize_IllegalForCustomer0_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7351*/ case MediaInfo_Event_Mpegv_DataBeforeFirst_sequence_header                  : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mpegv_DataBeforeFirst_sequence_header_0)) Mpegv_DataBeforeFirst_sequence_header_0((struct MediaInfo_Event_Mpegv_DataBeforeFirst_sequence_header_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7352*/ case MediaInfo_Event_Mpegv_IFrame_Without_sequence_header                   : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mpegv_IFrame_Without_sequence_header_0)) Mpegv_IFrame_Without_sequence_header_0((struct MediaInfo_Event_Mpegv_IFrame_Without_sequence_header_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7356*/ case MediaInfo_Event_Mpegv_picture_structure_Not3                           : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mpegv_picture_structure_Not3_0)) Mpegv_picture_structure_Not3_0((struct MediaInfo_Event_Mpegv_picture_structure_Not3_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7357*/ case MediaInfo_Event_Mpegv_Has_scalable_extensions                          : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mpegv_Has_scalable_extensions_0)) Mpegv_Has_scalable_extensions_0((struct MediaInfo_Event_Mpegv_Has_scalable_extensions_0*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_Avc :    
                switch (EventID)
                {    
           /*1256*/ CASE (Avc, Hrd_Cpb_Flow, 0)
           /*1258*/ CASE (Avc, pic_parameter_set_id_DoesNotExist, 0)
                    case MediaInfo_Event_Avc_GOP                                                : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Avc_GOP_0)) Avc_GOP_0((struct MediaInfo_Event_Avc_GOP_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_Avc_BitRate_NotConstant                                : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Avc_BitRate_NotConstant_0)) Avc_BitRate_NotConstant_0((struct MediaInfo_Event_Avc_BitRate_NotConstant_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7123*/ case MediaInfo_Event_Avc_NumBytesInNALunit_IllegalForBluray                 : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Avc_NumBytesInNALunit_IllegalForBluray_0)) Avc_NumBytesInNALunit_IllegalForBluray_0((struct MediaInfo_Event_Avc_NumBytesInNALunit_IllegalForBluray_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1257*/ CASE (Avc, FirstFrame_NotIdr, 0)
/*7702.114*//*215*/ case MediaInfo_Event_Avc_IFrame_WithoutStart                                : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Avc_IFrame_WithoutStart_0)) Avc_IFrame_WithoutStart_0((struct MediaInfo_Event_Avc_IFrame_WithoutStart_0*)Data_Content, UserHandler->Option_DCA); break;
/*3012,7702.109*//*210*/ case MediaInfo_Event_Avc_GOP_Size_IllegalForCustomer0                  : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Avc_GOP_Size_IllegalForCustomer0_0)) Avc_GOP_Size_IllegalForCustomer0_0((struct MediaInfo_Event_Avc_GOP_Size_IllegalForCustomer0_0*)Data_Content, UserHandler->Option_DCA); break;
/*3028,7702.110,111,211,212*/ case MediaInfo_Event_Avc_GOP_FieldsOrder_IllegalForCustomer0      : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Avc_GOP_FieldsOrder_IllegalForCustomer0_0)) Avc_GOP_FieldsOrder_IllegalForCustomer0_0((struct MediaInfo_Event_Avc_GOP_FieldsOrder_IllegalForCustomer0_0*)Data_Content, UserHandler->Option_DCA); break;
           /*7035*/ case MediaInfo_Event_Avc_GOP_ByteSize_IllegalForCustomer0                   : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mpegv_GOP_ByteSize_IllegalForCustomer0_0)) xxx_GOP_ByteSize_IllegalForCustomer0_0((struct MediaInfo_Event_Mpegv_GOP_ByteSize_IllegalForCustomer0_0*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_Vc1 :    
                switch (EventID)
                {    
           /*7035*/ case MediaInfo_Event_Vc1_GOP_ByteSize_IllegalForCustomer0                   : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Mpegv_GOP_ByteSize_IllegalForCustomer0_0)) xxx_GOP_ByteSize_IllegalForCustomer0_0((struct MediaInfo_Event_Mpegv_GOP_ByteSize_IllegalForCustomer0_0*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_Afd :    
                switch (EventID)
                { 
                    case MediaInfo_Event_Afd_Content                                            : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Afd_Content_0)) Afd_Content_0((struct MediaInfo_Event_Afd_Content_0*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_BarData :    
                switch (EventID)
                { 
                    case MediaInfo_Event_BarData_Content                                        : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_BarData_Content_0)) BarData_Content_0((struct MediaInfo_Event_BarData_Content_0*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_DolbyE :    
                switch (EventID)
                {    
           /*1828*/ CASE (DolbyE, Crc, 0)
           /*1831*/ CASE (DolbyE, frame_rate_code_Changed, 0)
           /*1830*/ CASE (DolbyE, GuardBand, 0)
           /*1831*/ CASE (DolbyE, program_config_Changed, 0)
           /*1832*/ CASE (DolbyE, frame_count_Splice, 0)
           /*1833*/ CASE (DolbyE, GuardBand_NotIdeal, 0)
                }
                break;
        case MediaInfo_Parser_Eia608 :    
                switch (EventID)
                { 
           /*1501*/ case MediaInfo_Event_Eia608_ControlCode_NotTwice                            : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_ControlCode_NotTwice_0)) Eia608_ControlCode_NotTwice_0((struct MediaInfo_Event_Eia608_ControlCode_NotTwice_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1502*/ case MediaInfo_Event_Eia608_NoFieldMatch                                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_NoFieldMatch_0)) Eia608_NoFieldMatch_0((struct MediaInfo_Event_Eia608_NoFieldMatch_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1503*/ case MediaInfo_Event_Eia608_CC_MoreThan32Chars                              : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_CC_MoreThan32Chars_0)) Eia608_CC_MoreThan32Chars_0((struct MediaInfo_Event_Eia608_CC_MoreThan32Chars_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1504*/ case MediaInfo_Event_Eia608_XDS_Current_ContentAdvisory_MPA_USTV            : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_XDS_Current_ContentAdvisory_MPA_USTV_0)) Eia608_XDS_Current_ContentAdvisory_MPA_USTV_0((struct MediaInfo_Event_Eia608_XDS_Current_ContentAdvisory_MPA_USTV_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1505*/ case MediaInfo_Event_Eia608_XDS_Current_ContentAdvisory_USTV_MPA            : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_XDS_Current_ContentAdvisory_USTV_MPA_0)) Eia608_XDS_Current_ContentAdvisory_USTV_MPA_0((struct MediaInfo_Event_Eia608_XDS_Current_ContentAdvisory_USTV_MPA_0*)Data_Content, UserHandler->Option_DCA); break;
   /*3026*//*1506*/ case MediaInfo_Event_Eia608_XDS_Current_CopyAndRedistributionControlPacket  : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_XDS_Current_CopyAndRedistributionControlPacket_0)) Eia608_XDS_Current_CopyAndRedistributionControlPacket_0((struct MediaInfo_Event_Eia608_XDS_Current_CopyAndRedistributionControlPacket_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1507*/ case MediaInfo_Event_Eia608_XDS_PublicService_NationalWeather               : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_XDS_PublicService_NationalWeather_0)) Eia608_XDS_PublicService_NationalWeather_0((struct MediaInfo_Event_Eia608_XDS_PublicService_NationalWeather_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1508*/ case MediaInfo_Event_Eia608_IllegalCharacter                                : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_IllegalCharacter_0)) Eia608_IllegalCharacter_0((struct MediaInfo_Event_Eia608_IllegalCharacter_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1514*/ case MediaInfo_Event_Eia608_End                                             : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_End_0)) Eia608_End_0((struct MediaInfo_Event_Eia608_End_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1515*/ case MediaInfo_Event_Eia608_CC_MoreThan15Rows                               : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_CC_MoreThan15Rows_0)) Eia608_CC_MoreThan15Rows_0((struct MediaInfo_Event_Eia608_CC_MoreThan15Rows_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1516*/ case MediaInfo_Event_Eia608_XDS_Field1                                      : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_XDS_Field1_0)) Eia608_XDS_Field1_0((struct MediaInfo_Event_Eia608_XDS_Field1_0*)Data_Content, UserHandler->Option_DCA); break;
           /*3027*/ case MediaInfo_Event_Eia608_XDS_Current_ContentAdvisory_Content             : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_XDS_Current_ContentAdvisory_Content_0)) Eia608_XDS_Current_ContentAdvisory_Content_0((struct MediaInfo_Event_Eia608_XDS_Current_ContentAdvisory_Content_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_Eia608_CC_Content                                      : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Eia608_CC_Content_0)) Eia608_CC_Content_0((struct MediaInfo_Event_Eia608_CC_Content_0*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_DtvccTransport :    
                switch (EventID)
                { 
           /*1512*/ case MediaInfo_Event_DtvccTransport_cc_count                                : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_DtvccTransport_cc_count_0)) DtvccTransport_cc_count_0((struct MediaInfo_Event_DtvccTransport_cc_count_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1512*/ case MediaInfo_Event_DtvccTransport_Eia608_cc_count                         : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_DtvccTransport_Eia608_cc_count_0)) DtvccTransport_Eia608_cc_count_0((struct MediaInfo_Event_DtvccTransport_Eia608_cc_count_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1513*/ case MediaInfo_Event_DtvccTransport_picture_structure_cc_type               : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_DtvccTransport_picture_structure_cc_type_0)) DtvccTransport_picture_structure_cc_type_0((struct MediaInfo_Event_DtvccTransport_picture_structure_cc_type_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1651*/ case MediaInfo_Event_DtvccTransport_additional_data_flag                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_DtvccTransport_additional_data_flag_0)) DtvccTransport_additional_data_flag_0((struct MediaInfo_Event_DtvccTransport_additional_data_flag_0*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_DtvccCaption :    
                switch (EventID)
                { 
           /*1509*/ case MediaInfo_Event_DtvccCaption_ReservedCode                              : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_DtvccCaption_ReservedCode_0)) DtvccCaption_ReservedCode_0((struct MediaInfo_Event_DtvccCaption_ReservedCode_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1510*/ case MediaInfo_Event_DtvccCaption_wordwrap_Deprecated                       : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_DtvccCaption_wordwrap_Deprecated_0)) DtvccCaption_wordwrap_Deprecated_0((struct MediaInfo_Event_DtvccCaption_wordwrap_Deprecated_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1511*/ case MediaInfo_Event_DtvccCaption_WindowIsOutsideOfArea_Minimal             : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_DtvccCaption_WindowIsOutsideOfArea_Minimal_0)) DtvccCaption_WindowIsOutsideOfArea_Minimal_0((struct MediaInfo_Event_DtvccCaption_WindowIsOutsideOfArea_Minimal_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1514*/ case MediaInfo_Event_DtvccCaption_End                                       : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_DtvccCaption_End_0)) DtvccCaption_End_0((struct MediaInfo_Event_DtvccCaption_End_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_DtvccCaption_Content_Minimal                           : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_DtvccCaption_Content_Minimal_0)) DtvccCaption_Content_Minimal_0((struct MediaInfo_Event_DtvccCaption_Content_Minimal_0*)Data_Content, UserHandler->Option_DCA); break;
                    case MediaInfo_Event_DtvccCaption_Window_Content_Minimal                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_DtvccCaption_Window_Content_Minimal_0)) DtvccCaption_Window_Content_Minimal_0((struct MediaInfo_Event_DtvccCaption_Window_Content_Minimal_0*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_Cdp :    
                switch (EventID)
                { 
           /*1512*/ case MediaInfo_Event_Cdp_cc_count                                           : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Cdp_cc_count_0)) Cdp_cc_count_0((struct MediaInfo_Event_Cdp_cc_count_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1512*/ case MediaInfo_Event_Cdp_Eia608_cc_count                                    : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Cdp_Eia608_cc_count_0)) Cdp_Eia608_cc_count_0((struct MediaInfo_Event_Cdp_Eia608_cc_count_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1513*/ case MediaInfo_Event_Cdp_picture_structure_cc_type                          : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Cdp_picture_structure_cc_type_0)) Cdp_picture_structure_cc_type_0((struct MediaInfo_Event_Cdp_picture_structure_cc_type_0*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        case MediaInfo_Parser_Scte20 :    
                switch (EventID)
                { 
           /*1512*/ case MediaInfo_Event_Scte20_cc_count                                        : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Scte20_cc_count_0)) Scte20_cc_count_0((struct MediaInfo_Event_Scte20_cc_count_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1512*/ case MediaInfo_Event_Scte20_Eia608_cc_count                                 : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Scte20_Eia608_cc_count_0)) Scte20_Eia608_cc_count_0((struct MediaInfo_Event_Scte20_Eia608_cc_count_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1513*/ case MediaInfo_Event_Scte20_picture_structure_cc_type                       : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Scte20_picture_structure_cc_type_0)) Scte20_picture_structure_cc_type_0((struct MediaInfo_Event_Scte20_picture_structure_cc_type_0*)Data_Content, UserHandler->Option_DCA); break;
           /*1601*/ case MediaInfo_Event_Scte20_field_number_Forbidden                          : if (EventVersion==0 && Data_Size==sizeof(struct MediaInfo_Event_Scte20_field_number_Forbidden_0)) Scte20_field_number_Forbidden_0((struct MediaInfo_Event_Scte20_field_number_Forbidden_0*)Data_Content, UserHandler->Option_DCA); break;
                    default                                                                     : ;
                }
                break;
        default : ; //ParserID is unknown
    }

    #ifdef MEDIAINFO_REGRESSION_TEST
        fclose(F); F=NULL;
    #endif //MEDIAINFO_REGRESSION_TEST
}

/***************************************************************************/
/* Parsing the file, example with the stream interface                     */
/***************************************************************************/

int MI_Parse (void* MI, const char* FileName)
{
    /*Note: You can use basicly the analyze by FileName too, the code her is to demonstrate the usage of buffers, useful if you capture a stream*/
    void* From;
    unsigned char* From_Buffer;
    DWORD From_Buffer_Size;
    DWORD From_Size_Low; 
    DWORD From_Size_High;
    unsigned long long From_Size;

    /***********************************************************************/
    /* Preparing input file                                                */
    /***********************************************************************/

    /*From: preparing an example file for reading*/
    From=CreateFile(FileName, FILE_READ_DATA, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
    if (From==INVALID_HANDLE_VALUE)
    {
        echo0("Can not open input file");
        return 1;
    }
    From_Size_Low=GetFileSize(From, &From_Size_High);
    if (From_Size_Low==INVALID_FILE_SIZE && GetLastError()!=NO_ERROR)
    {
        echo0("Can not get input file size");
        return 1;
    }
    From_Size=0x100000000ULL*From_Size_High+From_Size_Low;

    /*From: preparing a memory buffer for reading*/
    From_Buffer=(unsigned char*)malloc(300000); //Note: you can do your own buffer

    /*Preparing to fill MediaInfo with a buffer*/
    MediaInfo_Open_Buffer_Init(MI, From_Size, 0);
    MediaInfo_Option(MI, "file_demux_unpacketize", "1");
    MediaInfo_Option(MI, "File_FileName", FileName);

    /***********************************************************************/
    /* Parsing                                                             */
    /***********************************************************************/

    /*The parsing loop*/
    do
    {
        /*Reading data somewhere, do what you want for this.*/
        if (!ReadFile(From, From_Buffer, 300000, &From_Buffer_Size, NULL))
        {
                char lpMsgBuf[1000];
                DWORD dw = GetLastError();
                FormatMessageA(
                FORMAT_MESSAGE_FROM_SYSTEM,
                NULL,
                dw,
                MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
                lpMsgBuf,
                1000, NULL );

            /*Clean up*/
            free(From_Buffer);

            echo0("Can not read input file");
            return 1;
        }

        /*Sending the buffer to MediaInfo*/
        if (MediaInfo_Open_Buffer_Continue(MI, From_Buffer, From_Buffer_Size)&0x08) //Bit 3 is set if analyzing is finished (TODO: documentation about function return vale)
            break;

        /*Managing seek requests*/
        if (MediaInfo_Open_Buffer_Continue_GoTo_Get(MI)!=(MediaInfo_int64u)-1)
        {
            LARGE_INTEGER GoTo; GoTo.QuadPart=MediaInfo_Open_Buffer_Continue_GoTo_Get(MI);
            GoTo.LowPart=SetFilePointer(From, GoTo.LowPart, &GoTo.HighPart, FILE_BEGIN);
            if (GoTo.LowPart==INVALID_SET_FILE_POINTER && GetLastError()!=NO_ERROR)
            {
                /*Clean up*/
                free(From_Buffer);

                echo0("Error during input file seek");
                return 1;
            }
            MediaInfo_Open_Buffer_Init(MI, From_Size, GoTo.QuadPart);
        }
    }
    while (From_Buffer_Size>0);
    MediaInfo_Open_Buffer_Finalize(MI);

    {
        const char* A=MediaInfo_Inform(MI, 0);
        A=NULL;
    }

    /*Clean up*/
    free(From_Buffer);

    return 0;
}

/***************************************************************************/
/* Per file                                                                */
/***************************************************************************/

int MI_PerFile (const char* FileName, struct UserHandle_struct UserHandle)
{
    void* MI;
    char Event_CallBackFunction_Text[1000];
    const char* MI_Result;
    size_t StreamKind;
    size_t StreamPos;
    char OverallBitRate_String[1000];
    char IDs_Format_String[10000];

    /***********************************************************************/
    /* Retrieving bit rate                                                 */
    /***********************************************************************/

    /*Init*/
    MI=MediaInfo_New();
    if (MI==NULL)
    {
        echo0("MediaInfo error: impossible to create a new MediaInfo handler");
        return 1;
    }
  
    /*We want only some details*/
    MI_Result=MediaInfo_Option(MI, "ParseSpeed", "0.5");
    if (strlen(MI_Result))
    {
        echo1("MediaInfo error: %s\r\n", MI_Result);
        return 1;
    }
    
    /*We want to test streams even if stream_type is wrong*/
    MI_Result=MediaInfo_Option(MI, "File_MpegTs_stream_type_Trust", "0");
    if (strlen(MI_Result))
    {
        echo1("MediaInfo error: %s\r\n", MI_Result);
        return 1;
    }
    
    /*Parsing*/
    #ifdef MEDIAINFO_REGRESSION_TEST
        F_FileName=strrchr(FileName, '\\');
        if (F_FileName==NULL)
            F_FileName=FileName;
        else
            F_FileName++; //Skipping antislash
    #endif //MEDIAINFO_REGRESSION_TEST
    if (MI_Parse(MI, FileName))
        return 1;

    /*Retrieving information*/
    strcpy(OverallBitRate_String, MediaInfo_Get(MI, MediaInfo_Stream_General, 0, "OverallBitRate", MediaInfo_Info_Text, MediaInfo_Info_Name));
    IDs_Format_String[0]='\0'; //Form is "ID1=Format1;ID2=Format2;..."
    for (StreamKind=1; StreamKind<MediaInfo_Stream_Max; StreamKind++)
        for (StreamPos=0; StreamPos<MediaInfo_Count_Get(MI, (MediaInfo_stream_C)StreamKind, (size_t)-1); StreamPos++)
        {
            strcpy(IDs_Format_String+strlen(IDs_Format_String), MediaInfo_Get(MI, (MediaInfo_stream_C)StreamKind, StreamPos, "ID", MediaInfo_Info_Text, MediaInfo_Info_Name));
            strcpy(IDs_Format_String+strlen(IDs_Format_String), "=");
            strcpy(IDs_Format_String+strlen(IDs_Format_String), MediaInfo_Get(MI, (MediaInfo_stream_C)StreamKind, StreamPos, "Format", MediaInfo_Info_Text, MediaInfo_Info_Name));
            strcpy(IDs_Format_String+strlen(IDs_Format_String), ";");
        }

    /*Clean up*/
    MediaInfo_Delete(MI);

    /***********************************************************************/
    /* Parsing, with events                                                */
    /***********************************************************************/

    /*Init*/
    MI=MediaInfo_New();
    if (MI==NULL)
    {
        echo0("MediaInfo error: impossible to create a new MediaInfo handler");
        return 1;
    }

    /*CallBack configuration*/
    /*MediaInfo need pointer as text, for compatibility with older version) + 64-bit OS handling*/
    /*form is "CallBack=memory://handlerInDecimal;UserHandler=memory://handlerInDecimal"*/
    /*UserHandler is a unique value wich will be provided to the callback function, in order to know which MediaInfo instance send the event*/
    UserHandle.MI=MI;
    strcpy(Event_CallBackFunction_Text, "CallBack=memory://");
    _ui64toa_s((unsigned __int64)Event_CallBackFunction, Event_CallBackFunction_Text+strlen(Event_CallBackFunction_Text), 1000-strlen(Event_CallBackFunction_Text), 10);
    strcpy(Event_CallBackFunction_Text+strlen(Event_CallBackFunction_Text), ";UserHandler=memory://");
    _ui64toa_s((unsigned __int64)&UserHandle, Event_CallBackFunction_Text+strlen(Event_CallBackFunction_Text), 1000-strlen(Event_CallBackFunction_Text), 10);
    MI_Result=MediaInfo_Option(MI, "File_Event_CallBackFunction", Event_CallBackFunction_Text);
    if (strlen(MI_Result))
    {
        echo1("MediaInfo error: %s\r\n", MI_Result);
        return 1;
    }

    /*Indicating previously retrieve information*/
    MI_Result=MediaInfo_Option(MI, "File_OverallBitRate", OverallBitRate_String);
    if (strlen(MI_Result))
    {
        echo1("MediaInfo error: %s\r\n", MI_Result);
        return 1;
    }
    MI_Result=MediaInfo_Option(MI, "File_IDs_Format", IDs_Format_String);
    if (strlen(MI_Result))
    {
        echo1("MediaInfo error: %s\r\n", MI_Result);
        return 1;
    }

    /*Indicating the GOP structure for progressive assets*/
    MI_Result=MediaInfo_Option(MI, "File_GopStructure_Progressive", "Format=IPB;IBBBPBBBPBBBPBBBPBBBPBBB");
    if (strlen(MI_Result))
    {
        echo1("MediaInfo error: %s\r\n", MI_Result);
        return 1;
    }

    /*Indicating the GOP structure for interlaced assets*/
    MI_Result=MediaInfo_Option(MI, "File_GopStructure_Interlaced", "Format=IPB;IPBBBBBBPPBBBBBBPPBBBBBBPPBBBBBBPPBBBBBBPPBBBBBB");
    if (strlen(MI_Result))
    {
        echo1("MediaInfo error: %s\r\n", MI_Result);
        return 1;
    }

    /*Indicating GOP Size, Minimum/Maximum*/
    MI_Result=MediaInfo_Option(MI, "File_GopSize_Min", "2000000");
    if (strlen(MI_Result))
    {
        echo1("MediaInfo error: %s\r\n", MI_Result);
        return 1;
    }
    MI_Result=MediaInfo_Option(MI, "File_GopSize_Max", "2000000");
    if (strlen(MI_Result))
    {
        echo1("MediaInfo error: %s\r\n", MI_Result);
        return 1;
    }

    /*We want all the stream, not only the beginning*/
    MI_Result=MediaInfo_Option(MI, "ParseSpeed", "1.0");
    if (strlen(MI_Result))
    {
        echo1("MediaInfo error: %s\r\n", MI_Result);
        return 1;
    }
    
    /*We want to test streams even if stream_type is wrong*/
    MI_Result=MediaInfo_Option(MI, "File_MpegTs_stream_type_Trust", "0");
    if (strlen(MI_Result))
    {
        echo1("MediaInfo error: %s\r\n", MI_Result);
        return 1;
    }
    
    /*Parsing*/
    /*
    if (MI_Parse (MI, FileName))
        return 1;
        */

	/*We want to use the "NextPacket" interface*/
	MI_Result=MediaInfo_Option(MI, _T("File_NextPacket"), _T("1"));
	if (strlen(MI_Result))
	{
		printf("MediaInfo error: %s\n", MI_Result);
		return 1;
	}

	if( MediaInfo_Open(MI, FileName) == 0)
		return 1;

	while (MediaInfo_Open_NextPacket(MI)&0x100)
	{
		//if(UserHandle.Packet.stream_index != -1)
		//	return UserHandle.Packet.size;
        int A=0;
	}

    /*Clean up*/
    MediaInfo_Delete(MI);

    return 0;
}

/***************************************************************************/
/* Main                                                                    */
/***************************************************************************/

int main (int argc, char *argv[])
{
    const char* FileNames[10000];
    size_t FileNames_Max=0;
    int argv_Problem=0;
    struct UserHandle_struct UserHandle;
    size_t Pos;

    /***********************************************************************/
    /* Options handling                                                    */
    /***********************************************************************/

    UserHandle.Option_DCA=1;
    for (Pos=1; Pos<(size_t)argc; Pos++)
    {
        if (strcmp(argv[Pos], "--dca")==0)
            UserHandle.Option_DCA=1;
        else
        {
            FileNames[FileNames_Max]=argv[Pos];
            FileNames_Max++;
        }
    }

    #ifdef MEDIAINFO_REGRESSION_TEST
    {
        WIN32_FIND_DATA ffd;
        HANDLE hFind = INVALID_HANDLE_VALUE;

        FileNames_Max=0;
        hFind = FindFirstFile("..\\..\\..\\..\\..\\..\\MediaInfoLib_DCA_RegressionTest\\Files\\*", &ffd);
        if (hFind!=INVALID_HANDLE_VALUE)
        {
            do
            {
                if (strlen(ffd.cFileName)>2)
                {
                    char* Temp=(char*)malloc(65536);
                    sprintf(Temp, "..\\..\\..\\..\\..\\..\\MediaInfoLib_DCA_RegressionTest\\Files\\%s", ffd.cFileName);
                    FileNames[FileNames_Max]=Temp;
                    FileNames_Max++;
                }
            }
            while (FindNextFile(hFind, &ffd)!=0);
        }
    }
    #endif //MEDIAINFO_REGRESSION_TEST

    /*Input*/
    if (argv_Problem || FileNames_Max==0)
    {
        echo0("Usage: MediaInfoDCA FileName [--dca]");
        return 1;
    }

    /***********************************************************************/
    /* MediaInfo library init                                              */
    /***********************************************************************/

    /*Initializing MediaInfo*/
    if (MediaInfoDLL_Load()!=1)
    {
        printf("MediaInfo error: MediaInfo.dll not found");
        return 1;
    }

    for (Pos=0; Pos<FileNames_Max; Pos++)
    {
        #ifdef MEDIAINFO_REGRESSION_TEST
        {
            printf("%d / %d\n", Pos, FileNames_Max);
        }
        #endif //MEDIAINFO_REGRESSION_TEST
        MI_PerFile(FileNames[Pos], UserHandle);
    }

    #ifdef MEDIAINFO_REGRESSION_TEST
        for (Pos=0; Pos<FileNames_Max; Pos++)
        {
            char FileNameRef[65536];
            char FileNameNew[65536];
            char FileNameRef_Find[65536];
            WIN32_FIND_DATA ffd;
            HANDLE hFind = INVALID_HANDLE_VALUE;

            strcpy(FileNameRef, "..\\..\\..\\..\\..\\..\\MediaInfoLib_DCA_RegressionTest\\Ref\\");
            strcpy(FileNameNew, "..\\..\\..\\..\\..\\..\\MediaInfoLib_DCA_RegressionTest\\New\\");
            strcpy(FileNameRef+strlen(FileNameRef), strrchr(FileNames[Pos], '\\'));
            strcpy(FileNameNew+strlen(FileNameNew), strrchr(FileNames[Pos], '\\'));
            strcpy(FileNameRef+strlen(FileNameRef), "\\");
            strcpy(FileNameNew+strlen(FileNameNew), "\\");

            strcpy(FileNameRef_Find, FileNameRef);
            strcpy(FileNameRef_Find+strlen(FileNameRef_Find), "*.txt");
            hFind = FindFirstFile(FileNameRef_Find, &ffd);
            if (hFind!=INVALID_HANDLE_VALUE)
            {
                do
                {
                    char* Ref_Buffer=NULL;
                    FILE* Ref=NULL;
                    char  Ref_CompleteFileName[65536];
                    char* New_Buffer=NULL;
                    FILE* New=NULL;
                    char  New_CompleteFileName[65536];
                    int   New_Size;

                    strcpy(Ref_CompleteFileName, FileNameRef);
                    strcpy(Ref_CompleteFileName+strlen(Ref_CompleteFileName), ffd.cFileName);
                    Ref=fopen(Ref_CompleteFileName, "rb");
                    Ref_Buffer=(char*)malloc(ffd.nFileSizeLow+1);
                    fread(Ref_Buffer, ffd.nFileSizeLow, 1, Ref);
                    Ref_Buffer[ffd.nFileSizeLow]='\0';

                    strcpy(New_CompleteFileName, FileNameNew);
                    strcpy(New_CompleteFileName+strlen(New_CompleteFileName), ffd.cFileName);
                    New=fopen(New_CompleteFileName, "rb");
                    if (New==NULL)
                        New_Size=-1;
                    else
                    {
                        fseek (New, 0 , SEEK_END);
                        New_Size=ftell(New);
                        rewind(New);
                        if (New_Size==ffd.nFileSizeLow)
                        {  
                            /*
                            New_Buffer=(char*)malloc(New_Size+1);
                            fread(New_Buffer, New_Size, 1, New);
                            New_Buffer[New_Size]='\0';
                            if (strcmp(Ref_Buffer, New_Buffer))
                                New_Size=-1;
                            */
                        }
                    }

                    if (New_Size!=ffd.nFileSizeLow)
                    {
                        char FileNameDiff[65536];
                        FILE* Result;
                        char ToWrite[65536];

                        strcpy(FileNameDiff, "..\\..\\..\\..\\..\\..\\MediaInfoLib_DCA_RegressionTest\\Diff");
                        strcpy(FileNameDiff+strlen(FileNameDiff), strrchr(FileNames[Pos], '\\'));
                        strcpy(FileNameDiff+strlen(FileNameDiff), ".txt");
                        Result=fopen(FileNameDiff, "a");
                    
                        sprintf(ToWrite, "%s - %i - %i\n", ffd.cFileName, New_Size, ffd.nFileSizeLow);
                        fwrite(ToWrite, strlen(ToWrite), 1, Result);
                        fclose(Result); Result=NULL;
                    }

                    free(Ref_Buffer); Ref_Buffer=NULL;
                    if (Ref) {fclose(Ref); Ref=NULL;}
                    free(New_Buffer); New_Buffer=NULL;
                    if (New) {fclose(New); New=NULL;}
                }
                while (FindNextFile(hFind, &ffd)!=0);
                FindClose(hFind);
            }
        }
    #endif //MEDIAINFO_REGRESSION_TEST

    return 0;
}