<?php $root=""; ?>
<?php require($root."navigation.php"); ?>
<html>
<head>
  <title>libMesh Publications</title>
<?php load_style($root); ?>
</head>
<body>
<?php make_navigation("publications",$root)?>
<div class="content">
<h2>Please use the following citation to reference libMesh</h2>

<!-- This document was automatically generated with bibtex2html 1.95
     (see http://www.lri.fr/~filliatr/bibtex2html/),
     with the following command:
     bibtex2html -d -r --nodoc --single -nofooter libmesh.bib  -->


<table>

<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="libMeshPaper">1</a>]
</td>
<td class="bibtexitem">
B.&nbsp;S. Kirk, J.&nbsp;W. Peterson, R.&nbsp;H. Stogner, and G.&nbsp;F. Carey.
 <tt>libMesh</tt>: A C++ Library for Parallel Adaptive Mesh
  Refinement/Coarsening Simulations.
 <em>Engineering with Computers</em>, 22(3-4):237-254, 2006.
 <a href="http://dx.doi.org/10.1007/s00366-006-0049-3">http://dx.doi.org/10.1007/s00366-006-0049-3</a>.
<a name="libMeshPaper"></a><pre>
@article{libMeshPaper,
  author = {B.~S.~Kirk and J.~W.~Peterson and R.~H.~Stogner and G.~F.~Carey},
  title = {{\texttt{libMesh}: A C++ Library for Parallel Adaptive Mesh
              Refinement/Coarsening Simulations}},
  journal = {Engineering with Computers},
  volume = {22},
  number = {3--4},
  pages = {237--254},
  year = {2006},
  note = {\url{http://dx.doi.org/10.1007/s00366-006-0049-3}}
}
</pre>


</td>
</tr>
</table><a name="Dissertations"></a>
<h2>Dissertations & Theses</h2>

<!-- This document was automatically generated with bibtex2html 1.95
     (see http://www.lri.fr/~filliatr/bibtex2html/),
     with the following command:
     bibtex2html -d -r --nodoc --single -nofooter theses.bib  -->


<table>

<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Petrolati_Dissertation">1</a>]
</td>
<td class="bibtexitem">
E.&nbsp;Petrolati.
 <em>Study and Optimization of Polariton LASERs</em>.
 PhD thesis, Universit&agrave; Degli Studi Di Roma &ldquo;Tor Vergata&rdquo;,
  December 2008.
 <a href="http://art.torvergata.it/bitstream/2108/1116/1/FINALE.pdf">http://art.torvergata.it/bitstream/2108/1116/1/FINALE.pdf</a>.
<a name="Petrolati_Dissertation"></a><pre>
@phdthesis{Petrolati_Dissertation,
  author = {E.~Petrolati},
  school = {Universit\`{a} Degli Studi Di Roma ``Tor Vergata''},
  title = {{Study and Optimization of Polariton LASERs}},
  note = {\url{http://art.torvergata.it/bitstream/2108/1116/1/FINALE.pdf}},
  month = dec,
  year = {2008}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Stogner_Dissertation">2</a>]
</td>
<td class="bibtexitem">
R.&nbsp;H. Stogner.
 <em>Parallel Adaptive C1 Macro-Elements for Nonlinear Thin Film and
  Non-Newtonian Flow Problems</em>.
 PhD thesis, Institute for Computational Engineering and Sciences
  (ICES), The University of Texas at Austin, August 2008.
 <a href="http://www.cfdlab.ae.utexas.edu/~roystgnr/dissertation/dissertation-stogner.pdf">http://www.cfdlab.ae.utexas.edu/~roystgnr/dissertation/dissertation-stogner.pdf</a>.
<a name="Stogner_Dissertation"></a><pre>
@phdthesis{Stogner_Dissertation,
  author = {R.~H.~Stogner},
  school = {Institute for Computational Engineering and Sciences (ICES), The University of Texas at Austin},
  title = {{Parallel Adaptive C1 Macro-Elements for Nonlinear Thin Film and Non-Newtonian Flow Problems}},
  note = {\url{http://www.cfdlab.ae.utexas.edu/~roystgnr/
  dissertation/dissertation-stogner.pdf}},
  month = aug,
  year = {2008}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Peterson_Dissertation">3</a>]
</td>
<td class="bibtexitem">
J.&nbsp;W. Peterson.
 <em>Parallel Adaptive Finite Element Methods for Problems in
  Natural Convection</em>.
 PhD thesis, ASE-EM dept., The University of Texas at Austin, May
  2008.
 <a href="http://www.cfdlab.ae.utexas.edu/~peterson/diss.pdf">http://www.cfdlab.ae.utexas.edu/~peterson/diss.pdf</a>.
<a name="Peterson_Dissertation"></a><pre>
@phdthesis{Peterson_Dissertation,
  author = {J.~W.~Peterson},
  school = {ASE-EM dept., The University of Texas at Austin},
  title = {{Parallel Adaptive Finite Element Methods for Problems in Natural Convection}},
  note = {\url{http://www.cfdlab.ae.utexas.edu/~peterson/diss.pdf}},
  month = may,
  year = {2008}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Knezevic_Dissertation">4</a>]
</td>
<td class="bibtexitem">
D.&nbsp;J. Knezevic.
 <em>Analysis and Implementation of Numerical Methods for Simulating
  Dilute Polymeric Fluids</em>.
 PhD thesis, University of Oxford, Balliol College, Michaelmas Term
  2008.
 <a href="http://www.comlab.ox.ac.uk/files/1416/knezevic-thesis.pdf">http://www.comlab.ox.ac.uk/files/1416/knezevic-thesis.pdf</a>.
<a name="Knezevic_Dissertation"></a><pre>
@phdthesis{Knezevic_Dissertation,
  author = {D.~J.~Knezevic},
  school = {University of Oxford, Balliol College},
  title = {{Analysis and Implementation of Numerical Methods for Simulating Dilute Polymeric Fluids}},
  note = {\url{http://www.comlab.ox.ac.uk/files/1416/knezevic-thesis.pdf}},
  month = {Michaelmas Term},
  year = {2008}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Kirk_Dissertation">5</a>]
</td>
<td class="bibtexitem">
B.&nbsp;S. Kirk.
 <em>Adaptive Finite Element Simulation of Flow and Transport
  Applications on Parallel Computers</em>.
 PhD thesis, ASE-EM dept., The University of Texas at Austin, May
  2007.
 <a href="http://www.cfdlab.ae.utexas.edu/~benkirk/dissertation.pdf">http://www.cfdlab.ae.utexas.edu/~benkirk/dissertation.pdf</a>.
<a name="Kirk_Dissertation"></a><pre>
@phdthesis{Kirk_Dissertation,
  author = {B.~S.~Kirk},
  school = {ASE-EM dept., The University of Texas at Austin},
  title = {{Adaptive Finite Element Simulation of Flow and Transport Applications on Parallel Computers}},
  note = {\url{http://www.cfdlab.ae.utexas.edu/~benkirk/dissertation.pdf}},
  month = may,
  year = {2007}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Peterson_Thesis">6</a>]
</td>
<td class="bibtexitem">
J.&nbsp;W. Peterson.
 A Numerical Investigation of B&eacute;nard Convection in Small Aspect
  Ratio Containers.
 Master's Report, ASE-EM dept., The University of Texas at Austin,
  May 2003.
 <a href="http://www.cfdlab.ae.utexas.edu/~peterson/masters.pdf">http://www.cfdlab.ae.utexas.edu/~peterson/masters.pdf</a>.
<a name="Peterson_Thesis"></a><pre>
@mastersthesis{Peterson_Thesis,
  author = {J.~W.~Peterson},
  type = {{Master's Report}},
  school = {ASE-EM dept., The University of Texas at Austin},
  title = {{A Numerical Investigation of B\'{e}nard Convection in Small Aspect Ratio Containers}},
  note = {\url{http://www.cfdlab.ae.utexas.edu/~peterson/masters.pdf}},
  month = may,
  year = {2003}
}
</pre>


</td>
</tr>
</table><a name="Preprints"></a>
<h2>Preprints</h2>

<!-- This document was automatically generated with bibtex2html 1.95
     (see http://www.lri.fr/~filliatr/bibtex2html/),
     with the following command:
     bibtex2html -d -r --nodoc --single -nofooter preprints.bib  -->


<table>

<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Eftang_2010b">1</a>]
</td>
<td class="bibtexitem">
J.&nbsp;L. Eftang, D.&nbsp;B.&nbsp;P. Huynh, D.&nbsp;J. Knezevic, and A.&nbsp;T. Patera.
 A two-step certified reduced basis method.
 <em>SUBMITTED, Journal of Scientific Computing</em>, October 2010.
 <a href="http://augustine.mit.edu/methodology/papers/atp_JSC_preprint_Oct2010.pdf">http://augustine.mit.edu/methodology/papers/atp_JSC_preprint_Oct2010.pdf</a>.
<a name="Eftang_2010b"></a><pre>
@article{Eftang_2010b,
  author = {J.~L.~Eftang and D.~B.~P.~Huynh and D.~J.~Knezevic and A.~T.~Patera},
  title = {{A two-step certified reduced basis method}},
  journal = {SUBMITTED, Journal of Scientific Computing},
  year = 2010,
  month = oct,
  note = {\url{http://augustine.mit.edu/methodology/papers/
     atp_JSC_preprint_Oct2010.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Griffith_2010">2</a>]
</td>
<td class="bibtexitem">
B.&nbsp;E. Griffith and X.&nbsp;Luo.
 Immersed boundary method with finite element elasticity.
 <em>SUBMITTED</em>, October 2010.
 <a href="http://www.cims.nyu.edu/~griffith/docs/griffith_ibfem_sub.pdf">http://www.cims.nyu.edu/~griffith/docs/griffith_ibfem_sub.pdf</a>.
<a name="Griffith_2010"></a><pre>
@article{Griffith_2010,
  author = {B.~E.~Griffith and X.~Luo},
  title = {{Immersed boundary method with finite element elasticity}},
  journal = {SUBMITTED},
  year = 2010,
  month = oct,
  note = {\url{http://www.cims.nyu.edu/~griffith/docs/griffith_ibfem_sub.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Knezevic_2010b">3</a>]
</td>
<td class="bibtexitem">
D.&nbsp;J. Knezevic, N.&nbsp;C. Nguyen, and A.&nbsp;T. Patera.
 Reduced basis approximation and a posteriori error estimation for
  the parametrized unsteady Boussinesq equations.
 <em>PREPRINT, Accepted in Mathematical Models and Methods in Applied
  Sciences</em>, August 2010.
 <a href="http://augustine.mit.edu/methodology/papers/atp_M3AS_preprint_Nov09.pdf">http://augustine.mit.edu/methodology/papers/atp_M3AS_preprint_Nov09.pdf</a>.
<a name="Knezevic_2010b"></a><pre>
@article{Knezevic_2010b,
  author = {D.~J.~Knezevic and N.~C.~Nguyen and A.~T.~Patera},
  title = {{Reduced basis approximation and a posteriori 
              error estimation for the parametrized unsteady 
              Boussinesq equations}},
  journal = {PREPRINT, Accepted in Mathematical Models and Methods in Applied Sciences},
  month = aug,
  year = 2010,
  note = {\url{http://augustine.mit.edu/methodology/
     papers/atp_M3AS_preprint_Nov09.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Huynh_2010">4</a>]
</td>
<td class="bibtexitem">
D.&nbsp;B.&nbsp;P. Huynh, D.&nbsp;J. Knezevic, J.&nbsp;W. Peterson, and A.&nbsp;T. Patera.
 High-Fidelity Real-Time Simulation on Deployed Platforms.
 <em>PREPRINT, Computers &amp; Fluids</em>, July 2010.
 Special Issue: Proceedings of the Symposium on High Accuracy Flow
  Simulations (HAFS), &Eacute;cole Polytechnique F&eacute;d&eacute;rale de Lausanne,
  February 15-16, 2010,
  DOI:&nbsp;<a href="http://dx.doi.org/10.1016/j.compfluid.2010.07.007">http://dx.doi.org/10.1016/j.compfluid.2010.07.007</a>.
<a name="Huynh_2010"></a><pre>
@article{Huynh_2010,
  author = {D.~B.~P.~Huynh and D.~J.~Knezevic and J.~W.~Peterson and A.~T.~Patera},
  title = {{High-Fidelity Real-Time Simulation on Deployed Platforms}},
  journal = {PREPRINT, Computers \& Fluids},
  year = {2010},
  month = jul,
  note = {Special Issue: Proceedings of the Symposium on High Accuracy Flow Simulations (HAFS),
    \'{E}cole Polytechnique F\'{e}d\'{e}rale de Lausanne, February 15--16, 2010,
    DOI:~\url{http://dx.doi.org/10.1016/j.compfluid.2010.07.007}    }
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Berrone_2010">5</a>]
</td>
<td class="bibtexitem">
S.&nbsp;Berrone and M.&nbsp;Verani.
 A new marking strategy for the adaptive finite element approximation
  of optimal control constrained problems.
 <em>EARLY VIEW, Optimization Methods and Software</em>, June 2010.
 <a href="http://dx.doi.org/10.1080/10556788.2010.491866">http://dx.doi.org/10.1080/10556788.2010.491866</a>.
<a name="Berrone_2010"></a><pre>
@article{Berrone_2010,
  author = {S.~Berrone and M.~Verani},
  title = {{A new marking strategy for the adaptive finite element
    approximation of optimal control constrained problems}},
  journal = {EARLY VIEW, Optimization Methods and Software},
  year = 2010,
  month = jun,
  note = {\url{http://dx.doi.org/10.1080/10556788.2010.491866}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Eftang_2010a">6</a>]
</td>
<td class="bibtexitem">
J.&nbsp;L. Eftang, D.&nbsp;J. Knezevic, and A.&nbsp;T. Patera.
 An <em>hp</em> Certified Reduced Basis Method for Parameterized Parabolic
  Partial Differential Equations.
 <em>PREPRINT, Mathematical and Computer Modelling of Dynamical
  Systems</em>, revised July 2010.
 <a href="http://augustine.mit.edu/methodology/papers/atp_MCMDS_preprint_Apr2010.pdf">http://augustine.mit.edu/methodology/papers/atp_MCMDS_preprint_Apr2010.pdf</a>.
<a name="Eftang_2010a"></a><pre>
@article{Eftang_2010a,
  author = {J.~L.~Eftang and D.~J.~Knezevic and A.~T.~Patera},
  title = {{An $hp$ Certified Reduced Basis Method for Parameterized Parabolic Partial Differential Equations}},
  journal = {PREPRINT, Mathematical and Computer Modelling of Dynamical Systems},
  year = {revised July 2010},
  note = {\url{http://augustine.mit.edu/methodology/
     papers/atp_MCMDS_preprint_Apr2010.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Knezevic_2010">7</a>]
</td>
<td class="bibtexitem">
D.&nbsp;J. Knezevic and J.&nbsp;W. Peterson.
 A High-Performance Parallel Implementation of the Certified Reduced
  Basis Method.
 <em>PREPRINT, Comput. Meth. Appl. Mech. Eng.</em>, submitted May 2010.
 <a href="http://www.tacc.utexas.edu/~peterson/articles/2010_rboomit_cmame_preprint.pdf">http://www.tacc.utexas.edu/~peterson/articles/2010_rboomit_cmame_preprint.pdf</a>.
<a name="Knezevic_2010"></a><pre>
@article{Knezevic_2010,
  author = {D.~J.~Knezevic and J.~W.~Peterson},
  title = {{A High-Performance Parallel Implementation of the Certified Reduced Basis Method}},
  journal = {PREPRINT, Comput. Meth. Appl. Mech. Eng.},
  year = {submitted May 2010},
  note = {\url{http://www.tacc.utexas.edu/~peterson/
     articles/2010_rboomit_cmame_preprint.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Peterson_2010b">8</a>]
</td>
<td class="bibtexitem">
J.&nbsp;W. Peterson and G.&nbsp;F. Carey.
 Parallel adaptive solution of coupled
  Rayleigh-B&eacute;nard-Marangoni problems with Navier-slip.
 <em>EARLY VIEW, International Journal for Numerical Methods in
  Fluids</em>, accepted, 2009.
 <a href="http://dx.doi.org/10.1002/fld.2264">http://dx.doi.org/10.1002/fld.2264</a>.
<a name="Peterson_2010b"></a><pre>
@article{Peterson_2010b,
  author = {J.~W.~Peterson and G.~F.~Carey},
  title = {{Parallel adaptive solution of coupled Rayleigh--B\'{e}nard--Marangoni
  problems with Navier-slip}},
  journal = {EARLY VIEW, International Journal for Numerical Methods in Fluids},
  year = {accepted, 2009},
  note = {\url{http://dx.doi.org/10.1002/fld.2264}}
}
</pre>


</td>
</tr>
</table><a name="Articles"></a>
<h2>2011</h2>

<!-- This document was automatically generated with bibtex2html 1.95
     (see http://www.lri.fr/~filliatr/bibtex2html/),
     with the following command:
     bibtex2html -d -r --nodoc --single -nofooter eleven.bib  -->


<table>

<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Botti_2011">1</a>]
</td>
<td class="bibtexitem">
L.&nbsp;Botti and D.&nbsp;A.&nbsp;Di Pietro.
 A pressure-correction scheme for convection-dominated incompressible
  flows with discontinuous velocity and continuous pressure.
 <em>Journal of Computational Physics</em>, 230(3):572-585, February
  2011.
 <a href="http://dx.doi.org/10.1016/j.jcp.2010.10.004">http://dx.doi.org/10.1016/j.jcp.2010.10.004</a>.
<a name="Botti_2011"></a><pre>
@article{Botti_2011,
  author = {L.~Botti and D.~A.~Di Pietro},
  title = {{A pressure-correction scheme for convection-dominated incompressible flows
    with discontinuous velocity and continuous pressure}},
  journal = {Journal of Computational Physics},
  year = 2011,
  volume = 230,
  number = 3,
  month = feb,
  pages = {572--585},
  note = {\url{http://dx.doi.org/10.1016/j.jcp.2010.10.004}}
}
</pre>


</td>
</tr>
</table><h2>2010</h2>

<!-- This document was automatically generated with bibtex2html 1.95
     (see http://www.lri.fr/~filliatr/bibtex2html/),
     with the following command:
     bibtex2html -d -r --nodoc --single -nofooter ten.bib  -->


<table>

<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Kirk_2010b">1</a>]
</td>
<td class="bibtexitem">
B.&nbsp;S. Kirk.
 Adiabatic shock capturing in perfect gas hypersonic flows.
 <em>International Journal for Numerical Methods in Fluids</em>,
  64(9):1041-1062, November 2010.
 <a href="http://dx.doi.org/10.1002/fld.2195">http://dx.doi.org/10.1002/fld.2195</a>.
<a name="Kirk_2010b"></a><pre>
@article{Kirk_2010b,
  author = {B.~S.~Kirk},
  title = {{Adiabatic shock capturing in perfect gas hypersonic flows}},
  journal = {International Journal for Numerical Methods in Fluids},
  year = 2010,
  month = nov,
  volume = 64,
  number = 9,
  pages = {1041--1062},
  note = {\url{http://dx.doi.org/10.1002/fld.2195}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Fuentes_2010b">2</a>]
</td>
<td class="bibtexitem">
D.&nbsp;Fuentes, R.&nbsp;Cardan, R.&nbsp;J. Stafford, J.&nbsp;Yung, G.&nbsp;D.&nbsp;Dodd III, and Y.&nbsp;Feng.
 High-fidelity computer models for prospective treatment planning of
  radiofrequency ablation with in vitro experimental correlation.
 <em>Journal of Vascular and Interventional Radiology</em>,
  21(11):1725-1732, November 2010.
 <a href="http://dx.doi.org/10.1016/j.jvir.2010.07.022">http://dx.doi.org/10.1016/j.jvir.2010.07.022</a>.
<a name="Fuentes_2010b"></a><pre>
@article{Fuentes_2010b,
  author = {D.~Fuentes and R.~Cardan and R.~J.~Stafford and J.~Yung and G.~D.~Dodd~III and Y.~Feng},
  title = {High-fidelity Computer Models for Prospective Treatment Planning
         of Radiofrequency Ablation with In Vitro Experimental Correlation},
  journal = {Journal of Vascular and Interventional Radiology},
  volume = 21,
  number = 11,
  month = nov,
  year = {2010},
  pages = {1725--1732},
  note = {\url{http://dx.doi.org/10.1016/j.jvir.2010.07.022}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Brown_2010">3</a>]
</td>
<td class="bibtexitem">
J.&nbsp;Brown.
 Efficient Nonlinear Solvers for Nodal High-Order Finite Elements in
  3D.
 <em>Journal of Scientific Computing</em>, 45:48-63, October 2010.
 <a href="http://dx.doi.org/10.1007/s10915-010-9396-8">http://dx.doi.org/10.1007/s10915-010-9396-8</a>.
<a name="Brown_2010"></a><pre>
@article{Brown_2010,
  author = {J.~Brown},
  title = {{Efficient Nonlinear Solvers for Nodal High-Order Finite Elements in 3D}},
  journal = {Journal of Scientific Computing},
  year = 2010,
  volume = 45,
  issue = {1--3},
  month = oct,
  pages = {48--63},
  note = {\url{http://dx.doi.org/10.1007/s10915-010-9396-8}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Olivera_2010">4</a>]
</td>
<td class="bibtexitem">
S.&nbsp;Oliveira, A.-M. Toader, and P.&nbsp;Vieira.
 Finding the elastic coefficients of a damaged zone in a concrete dam
  using material optimization to fit measured modal parameters.
 In <em>Proceedings of the 2nd International Conference on
  Engineering Optimization</em>, Lisbon, Portugal, September&nbsp;6-9, 2010.
 <a href="http://lemac1.dem.ist.utl.pt/engopt2010/Book_and_CD/Papers_CD_Final_Version/pdf/12/01122-01.pdf">http://lemac1.dem.ist.utl.pt/engopt2010/Book_and_CD/Papers_CD_Final_Version/pdf/12/01122-01.pdf</a>.
<a name="Olivera_2010"></a><pre>
@inproceedings{Olivera_2010,
  author = {S.~Oliveira and A.-M.~Toader and P.~Vieira},
  title = {Finding the elastic coefficients of a damaged zone in
  a concrete dam using material optimization to fit measured modal parameters},
  booktitle = {{Proceedings of the 2nd International Conference on
                 Engineering Optimization}},
  month = sep # {~6--9,},
  address = {Lisbon, Portugal},
  year = {2010},
  note = {\url{http://lemac1.dem.ist.utl.pt/engopt2010/Book_and_CD/
  Papers_CD_Final_Version/pdf/12/01122-01.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Ragusa_2010">5</a>]
</td>
<td class="bibtexitem">
J.&nbsp;Ragusa, A.&nbsp;Siegel, and J.-M. Ruggieri.
 Neutronic/Thermalhydraulic Coupling Technigues for Sodium Cooled
  Fast Reactor Simulations.
 Technical Report 14837, Department of Energy, September 2010.
 <a href="http://dx.doi/org/10.2172/992636">http://dx.doi/org/10.2172/992636</a>.
<a name="Ragusa_2010"></a><pre>
@techreport{Ragusa_2010,
  author = {J.~Ragusa and A.~Siegel and J.-M.~Ruggieri},
  title = {{Neutronic/Thermalhydraulic Coupling Technigues for Sodium Cooled Fast Reactor Simulations}},
  institution = {Department of Energy},
  day = 28,
  month = sep,
  year = {2010},
  number = {14837},
  note = {\url{http://dx.doi/org/10.2172/992636}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Lu_2010">6</a>]
</td>
<td class="bibtexitem">
Y.&nbsp;Lu, B.&nbsp;Zhu, H.&nbsp;Shen, J.&nbsp;C. Rasmussen, G.&nbsp;Wang, and E.&nbsp;M. Sevick-Muraca.
 A parallel adaptive finite element simplified spherical harmonics
  approximation solver for frequency domain fluorescence molecular imaging.
 <em>Physics in Medicine and Biololgy</em>, 55(16):4625-4645, August
  2010.
 <a href="http://dx.doi.org/10.1088/0031-9155/55/16/002">http://dx.doi.org/10.1088/0031-9155/55/16/002</a>.
<a name="Lu_2010"></a><pre>
@article{Lu_2010,
  author = {Y.~Lu and B.~Zhu and H.~Shen and J.~C.~Rasmussen
             and G.~Wang and E.~M.~Sevick-Muraca},
  title = {{A parallel adaptive finite element simplified
              spherical harmonics approximation solver for
	      frequency domain fluorescence molecular imaging}},
  journal = {Physics in Medicine and Biololgy},
  year = 2010,
  volume = 55,
  number = 16,
  month = aug,
  pages = {4625--4645},
  note = {\url{http://dx.doi.org/10.1088/0031-9155/55/16/002}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Pereira_2010">7</a>]
</td>
<td class="bibtexitem">
F.&nbsp;H. Pereira and S.&nbsp;I. Nabeta.
 Wavelet-based algebraic multigrid method using the lifting
  technique.
 <em>Journal of Microwaves, Optoelectronics, and Electromagnetic
  Applications</em>, 9(1):1-9, June 2010.
 <a href="http://www.sel.eesc.usp.br/jmo/issues/vol_9/v9_n1/v9_n1_paper_pdf/regular/v9n1a1.pdf">http://www.sel.eesc.usp.br/jmo/issues/vol_9/v9_n1/v9_n1_paper_pdf/regular/v9n1a1.pdf</a>.
<a name="Pereira_2010"></a><pre>
@article{Pereira_2010,
  author = {F.~H.~Pereira and S.~I.~Nabeta},
  title = {{Wavelet-based algebraic multigrid method using the lifting technique}},
  journal = {Journal of Microwaves, Optoelectronics, and Electromagnetic Applications},
  year = 2010,
  volume = 9,
  number = 1,
  pages = {1--9},
  note = {\url{http://www.sel.eesc.usp.br/jmo/issues/
     vol_9/v9_n1/v9_n1_paper_pdf/regular/v9n1a1.pdf}},
  month = jun
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Kirk_2010a">8</a>]
</td>
<td class="bibtexitem">
B.&nbsp;S. Kirk and G.&nbsp;F. Carey.
 Validation of Fully Implicit, Parallel Finite Element Simulations of
  Laminar Hypersonic Flows.
 <em>AIAA Journal</em>, 48(6):1025-1036, June 2010.
 <a href="http://dx.doi.org/10.2514/1.40860">http://dx.doi.org/10.2514/1.40860</a>.
<a name="Kirk_2010a"></a><pre>
@article{Kirk_2010a,
  author = {B.~S.~Kirk and G.~F.~Carey},
  title = {{Validation of Fully Implicit, Parallel Finite Element Simulations of Laminar Hypersonic Flows}},
  journal = {AIAA Journal},
  year = 2010,
  month = jun,
  volume = 48,
  number = 6,
  pages = {1025--1036},
  note = {\url{http://dx.doi.org/10.2514/1.40860}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Pecchia_2010">9</a>]
</td>
<td class="bibtexitem">
A.&nbsp;Pecchia.
 Transport at the nanoscale: integration of micro-macro scales for
  electrothermal device simulations.
 Technical Report A029035, University of Rome, &ldquo;Tor Vergata&rdquo;, May
  2010.
 <a href="http://www.dtic.mil/cgi-bin/GetTRDoc?Location=U2&doc=GetTRDoc.pdf&AD=ADA530920">http://www.dtic.mil/cgi-bin/GetTRDoc?Location=U2&doc=GetTRDoc.pdf&AD=ADA530920</a>.
<a name="Pecchia_2010"></a><pre>
@techreport{Pecchia_2010,
  author = {A.~Pecchia},
  title = {{Transport at the nanoscale: integration of micro-macro
                  scales for electrothermal device simulations}},
  institution = {University of Rome, ``Tor Vergata''},
  day = 27,
  month = may,
  year = {2010},
  number = {A029035},
  note = {\url{http://www.dtic.mil/cgi-bin/GetTRDoc?
                      Location=U2&doc=GetTRDoc.pdf&AD=ADA530920}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Nagler_2010">10</a>]
</td>
<td class="bibtexitem">
L.&nbsp;Nagler and M.&nbsp;Schanz.
 An extendable poroelastic plate formulation in dynamics.
 <em>Archive of Applied Mechanics</em>, 80:1177-1195, May 2010.
 <a href="http://dx.doi.org/10.1007/s00419-010-0429-4">http://dx.doi.org/10.1007/s00419-010-0429-4</a>.
<a name="Nagler_2010"></a><pre>
@article{Nagler_2010,
  author = {L.~Nagler and M.~Schanz},
  title = {{An extendable poroelastic plate formulation in dynamics}},
  journal = {Archive of Applied Mechanics},
  year = 2010,
  month = may,
  volume = 80,
  issue = 10,
  month = oct,
  pages = {1177--1195},
  note = {\url{http://dx.doi.org/10.1007/s00419-010-0429-4}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Fuentes_2010a">11</a>]
</td>
<td class="bibtexitem">
D.&nbsp;Fuentes, Y.&nbsp;Feng, A.&nbsp;Elliott, A.&nbsp;Shetty, R.&nbsp;J. McNichols, J.&nbsp;T. Oden, and
  R.&nbsp;J. Stafford.
 Adaptive Real-Time Bioheat Transfer Models for Computer Driven
  MR-guided Laser Induced Thermal Therapy.
 <em>IEEE Trans. Biomed. Eng.</em>, 57(5):1024-1030, May 2010.
 <a href="http://www.ncbi.nlm.nih.gov/pubmed/20142153">http://www.ncbi.nlm.nih.gov/pubmed/20142153</a>.
<a name="Fuentes_2010a"></a><pre>
@article{Fuentes_2010a,
  author = {D.~Fuentes and Y.~Feng and A.~Elliott and A.~Shetty and
   R.~J.~McNichols and J.~T.~Oden and R.~J.~Stafford},
  title = {{Adaptive Real-Time Bioheat Transfer Models for
   Computer Driven MR-guided Laser Induced Thermal Therapy}},
  journal = {{IEEE Trans. Biomed. Eng.}},
  year = {2010},
  volume = {57},
  number = {5},
  month = may,
  pages = {1024--1030},
  note = {\url{http://www.ncbi.nlm.nih.gov/pubmed/20142153}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Berrone_2010a">12</a>]
</td>
<td class="bibtexitem">
S.&nbsp;Berrone.
 Skipping transition conditions in a posteriori error estimates for
  finite element discretizations of parabolic equations.
 <em>Mathematical Modelling and Numerical Analysis (M2AN)</em>,
  44(3):455-484, May 2010.
 <a href="http://dx.doi.org/10.1051/m2an/2010009">http://dx.doi.org/10.1051/m2an/2010009</a>.
<a name="Berrone_2010a"></a><pre>
@article{Berrone_2010a,
  author = {S.~Berrone},
  title = {{Skipping transition conditions in a posteriori error
estimates for finite element discretizations of parabolic equations}},
  journal = {Mathematical Modelling and Numerical Analysis (M2AN)},
  month = may,
  year = 2010,
  volume = 44,
  number = 3,
  pages = {455--484},
  note = {\url{http://dx.doi.org/10.1051/m2an/2010009}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Zhu_2010">13</a>]
</td>
<td class="bibtexitem">
Y.&nbsp;Zhu, X.&nbsp;Y. Luo, and R.&nbsp;W. Ogden.
 Nonlinear axisymmetric deformations of an elastic tube under
  external pressure.
 <em>European Journal of Mechanics - A/Solids</em>, 29(2):216-229,
  March-April 2010.
 <a href="http://dx.doi.org/10.1016/j.euromechsol.2009.10.004">http://dx.doi.org/10.1016/j.euromechsol.2009.10.004</a>.
<a name="Zhu_2010"></a><pre>
@article{Zhu_2010,
  author = {Y.~Zhu and X.~Y.~Luo and R.~W.~Ogden},
  title = {{Nonlinear axisymmetric deformations of an
              elastic tube under external pressure}},
  journal = {European Journal of Mechanics - A/Solids},
  year = 2010,
  volume = 29,
  number = 2,
  month = {March--April},
  pages = {216--229},
  note = {\url{http://dx.doi.org/10.1016/j.euromechsol.2009.10.004}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Podgorney_2010">14</a>]
</td>
<td class="bibtexitem">
R.&nbsp;Podgorney, H.&nbsp;Huang, and D.&nbsp;Gaston.
 Massively parallel fully coupled implicit modeling of coupled
  thermal-hydrological-mechanical processes for enhanced geothermal system
  reservoirs.
 In <em>Proceedings of the 35th Workshop on Geothermal Reservoir
  Engineering</em>. Stanford University, February 2010.
 
  <a href="http://pangea.stanford.edu/ERE/pdf/IGAstandard/SGW/2010/podgorne.pdf">http://pangea.stanford.edu/ERE/pdf/IGAstandard/SGW/2010/podgorne.pdf</a>.
<a name="Podgorney_2010"></a><pre>
@inproceedings{Podgorney_2010,
  author = {R.~Podgorney and H.~Huang and D.~Gaston},
  title = {{Massively parallel fully coupled implicit modeling of coupled
                 thermal-hydrological-mechanical processes for enhanced geothermal
		 system reservoirs}},
  booktitle = {{Proceedings of the 35th Workshop on Geothermal Reservoir Engineering}},
  publisher = {Stanford University},
  month = feb,
  year = {2010},
  note = {\url{http://pangea.stanford.edu/ERE/pdf/IGAstandard/SGW/2010/podgorne.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Knezevic_2010a">15</a>]
</td>
<td class="bibtexitem">
D.&nbsp;J. Knezevic and A.&nbsp;T. Patera.
 A certified reduced basis method for the Fokker-Planck equation of
  dilute polymeric fluids: FENE dumbbells in extensional flow.
 <em>SIAM Journal on Scientific Computing</em>, 32(2):793-817, 2010.
 <a href="http://dx.doi.org/10.1137/090759239">http://dx.doi.org/10.1137/090759239</a>.
<a name="Knezevic_2010a"></a><pre>
@article{Knezevic_2010a,
  author = {D.~J.~Knezevic and A.~T.~Patera},
  title = {{A certified reduced basis method for the 
              Fokker-Planck equation of dilute polymeric fluids: 
              FENE dumbbells in extensional flow}},
  journal = {SIAM Journal on Scientific Computing},
  year = 2010,
  volume = 32,
  number = 2,
  pages = {793--817},
  note = {\url{http://dx.doi.org/10.1137/090759239}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Zhengyong_2010">16</a>]
</td>
<td class="bibtexitem">
Z.&nbsp;Ren and J.&nbsp;Tang.
 3D direct current resistivity modeling with unstructured mesh by
  adaptive finite-element method.
 <em>Geophysics</em>, 1(75):H7-H17, 2010.
 <a href="http://dx.doi.org/10.1190/1.3298690">http://dx.doi.org/10.1190/1.3298690</a>.
<a name="Zhengyong_2010"></a><pre>
@article{Zhengyong_2010,
  author = {Z.~Ren and J.~Tang},
  title = {{3D direct current resistivity modeling with
              unstructured mesh by adaptive finite-element method}},
  journal = {Geophysics},
  year = 2010,
  volume = 1,
  number = 75,
  pages = {H7--H17},
  note = {\url{http://dx.doi.org/10.1190/1.3298690}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Carey_2010">17</a>]
</td>
<td class="bibtexitem">
G.&nbsp;F. Carey and D.&nbsp;J. Knezevic.
 Multiscale and hysteresis effects in vortex pattern simulations for
  Ginzburg-Landau problems.
 <em>International Journal for Numerical Methods in Engineering</em>,
  81(7):866-891, 2010.
 <a href="http://dx.doi.org/10.1002/nme.2714">http://dx.doi.org/10.1002/nme.2714</a>.
<a name="Carey_2010"></a><pre>
@article{Carey_2010,
  author = {G.~F.~Carey and D.~J.~Knezevic},
  title = {{Multiscale and hysteresis effects in vortex
              pattern simulations for Ginzburg-Landau problems}},
  journal = {International Journal for Numerical Methods in Engineering},
  year = 2010,
  volume = 81,
  number = 7,
  pages = {866--891},
  note = {\url{http://dx.doi.org/10.1002/nme.2714}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Peterson_2010">18</a>]
</td>
<td class="bibtexitem">
J.&nbsp;W. Peterson, G.&nbsp;F. Carey, and B.&nbsp;T. Murray.
 Multi-Resolution Simulation of Double-Diffusive Convection in Porous
  Media.
 <em>International Journal of Numerical Methods for Heat &amp; Fluid
  Flow</em>, 20(1):37-65, 2010.
 <a href="http://dx.doi.org/10.1108/09615531011008118">http://dx.doi.org/10.1108/09615531011008118</a>.
<a name="Peterson_2010"></a><pre>
@article{Peterson_2010,
  author = {J.~W.~Peterson and G.~F.~Carey and B.~T.~Murray},
  title = {{Multi-Resolution Simulation of Double-Diffusive 
              Convection in Porous Media}},
  journal = {International Journal of Numerical Methods for Heat \& Fluid Flow},
  volume = 20,
  number = 1,
  year = {2010},
  pages = {37--65},
  note = {\url{http://dx.doi.org/10.1108/09615531011008118}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Botti_2010">19</a>]
</td>
<td class="bibtexitem">
L.&nbsp;Botti, M.&nbsp;Piccinelli, B.&nbsp;Ene-Iordache, A.&nbsp;Remuzzi, and L.&nbsp;Antiga.
 An adaptive mesh refinement solver for large-scale simulation of
  biological flows.
 <em>International Journal for Numerical Methods in Biomedical
  Engineering</em>, 26(1):86-100, 2010.
 <a href="http://dx.doi.org/10.1002/cnm.1257">http://dx.doi.org/10.1002/cnm.1257</a>.
<a name="Botti_2010"></a><pre>
@article{Botti_2010,
  author = {L.~Botti and M.~Piccinelli and B.~Ene-Iordache and A.~Remuzzi and L.~Antiga},
  title = {{An adaptive mesh refinement solver for large-scale simulation of biological flows}},
  journal = {International Journal for Numerical Methods in Biomedical Engineering},
  year = 2010,
  volume = 26,
  number = 1,
  pages = {86--100},
  note = {\url{http://dx.doi.org/10.1002/cnm.1257}}
}
</pre>


</td>
</tr>
</table><h2>2009</h2>

<!-- This document was automatically generated with bibtex2html 1.95
     (see http://www.lri.fr/~filliatr/bibtex2html/),
     with the following command:
     bibtex2html -d -r --nodoc --single -nofooter nine.bib  -->


<table>

<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Prouet_2009">1</a>]
</td>
<td class="bibtexitem">
P.&nbsp;Prouzet, M.&nbsp;Odunlami, E.&nbsp;Duquesne, and A.&nbsp;Boussouar.
 Analysis and visualization of the glass eel behavior (Anguilla
  anguilla) in the Adour estuary and estimate of its upstream migration speed.
 <em>Aquatic Living Resources</em>, 22(4):525-534, December 2009.
 <a href="http://dx.doi.org/10.1051/alr/2009041">http://dx.doi.org/10.1051/alr/2009041</a>.
<a name="Prouet_2009"></a><pre>
@article{Prouet_2009,
  author = {P.~Prouzet and M.~Odunlami and E.~Duquesne and A.~Boussouar},
  title = {{Analysis and visualization of the glass
             eel behavior (Anguilla anguilla) in the Adour estuary
             and estimate of its upstream migration speed}},
  note = {\url{http://dx.doi.org/10.1051/alr/2009041}},
  journal = {Aquatic Living Resources},
  year = 2009,
  volume = 22,
  number = 4,
  pages = {525--534},
  month = dec
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Class_2009">2</a>]
</td>
<td class="bibtexitem">
H.&nbsp;Class et&nbsp;al.
 A benchmark study on problems related to CO2 storage in geologic
  formations.
 <em>Computational Geosciences</em>, 13(4):409-434, December 2009.
 <a href="http://dx.doi.org/10.1007/s10596-009-9146-x">http://dx.doi.org/10.1007/s10596-009-9146-x</a>.
<a name="Class_2009"></a><pre>
@article{Class_2009,
  author = {H.~Class and others},
  title = {{A benchmark study on problems related to CO2 storage in geologic formations}},
  journal = {Computational Geosciences},
  year = 2009,
  volume = 13,
  number = 4,
  pages = {409--434},
  month = dec,
  note = {\url{http://dx.doi.org/10.1007/s10596-009-9146-x}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Barbarosie_2009">3</a>]
</td>
<td class="bibtexitem">
C.&nbsp;Barbarosie and A.-M. Toader.
 Optimization of bodies with locally periodic microstructure.
 Technical Report Pre-2009-021, Centro de Matem&aacute;tica e
  Aplica&ccedil;&otilde;es Fundamentais (CMAF), December 2009.
 <a href="http://cmaf.ptmat.fc.ul.pt/arquivo/docs/pre-2009-021.pdf">http://cmaf.ptmat.fc.ul.pt/arquivo/docs/pre-2009-021.pdf</a>.
<a name="Barbarosie_2009"></a><pre>
@techreport{Barbarosie_2009,
  author = {C.~Barbarosie and A.-M.~Toader},
  title = {{Optimization of bodies with locally periodic 
                  microstructure}},
  institution = {Centro de Matem\'{a}tica e Aplica\c{c}\~{o}es Fundamentais (CMAF)},
  number = {Pre-2009-021},
  day = {2},
  month = dec,
  year = {2009},
  note = {\url{http://cmaf.ptmat.fc.ul.pt/arquivo/docs/pre-2009-021.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Kirk_2009c">4</a>]
</td>
<td class="bibtexitem">
B.&nbsp;S. Kirk and G.&nbsp;F. Carey.
 A parallel, adaptive finite element scheme for modeling chemotactic
  biological systems.
 <em>Communications in Numerical Methods in Engineering</em>,
  25(12):1162-1185, December 2009.
 <a href="http://dx.doi.org/10.1002/cnm.1173">http://dx.doi.org/10.1002/cnm.1173</a>.
<a name="Kirk_2009c"></a><pre>
@article{Kirk_2009c,
  author = {B.~S.~Kirk and G.~F.~Carey},
  title = {{A parallel, adaptive finite element scheme for
              modeling chemotactic biological systems}},
  journal = {Communications in Numerical Methods in Engineering},
  volume = {25},
  number = {12},
  pages = {1162--1185},
  month = dec,
  year = {2009},
  note = {\url{http://dx.doi.org/10.1002/cnm.1173}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Knezevic_2009d">5</a>]
</td>
<td class="bibtexitem">
D.&nbsp;J. Knezevic and E.&nbsp;S&uuml;li.
 A heterogeneous alternating-direction method for a micro-macro
  dilute polymeric fluid model.
 <em>European Series in Applied and Industrial Mathematics:
  Mathematical Modelling and Numerical Analysis</em>, 43(6):1117-1156, November
  2009.
 <a href="http://dx.doi.org/10.1051/m2an/2009034">http://dx.doi.org/10.1051/m2an/2009034</a>.
<a name="Knezevic_2009d"></a><pre>
@article{Knezevic_2009d,
  author = {D.~J.~Knezevic and E.~S\"{u}li},
  title = {{A heterogeneous alternating-direction method
            for a micro-macro dilute polymeric fluid model}},
  note = {\url{http://dx.doi.org/10.1051/m2an/2009034}},
  journal = {European Series in Applied and Industrial Mathematics:
             Mathematical Modelling and Numerical Analysis},
  year = 2009,
  volume = 43,
  number = 6,
  pages = {1117--1156},
  month = nov
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Antiga_2009">6</a>]
</td>
<td class="bibtexitem">
L.&nbsp;Antiga, R.&nbsp;N. Planken, K.&nbsp;Van Canneyt, L.&nbsp;Botti, A.&nbsp;Caroli, B.&nbsp;Ene-Iordache,
  J.&nbsp;Tordoir, P.&nbsp;Verdonck, and A.&nbsp;Remuzzi.
 Non-linear resistance associated to complex geometry at high flow
  rates in vascular access for hemodialysis.
 In Olaf D&ouml;ssel and Wolfgang&nbsp;C. Schlegel, editors, <em>World
  Congress on Medical Physics and Biomedical Engineering</em>, pages 543-546,
  Munich, Germany, September&nbsp;7-12, 2009. Springer Berlin Heidelberg.
 <a href="http://dx.doi.org/10.1007/978-3-642-03885-3">http://dx.doi.org/10.1007/978-3-642-03885-3</a>.
<a name="Antiga_2009"></a><pre>
@inproceedings{Antiga_2009,
  author = {L. Antiga and R. N. Planken and K. Van Canneyt and
                L. Botti and A. Caroli and B. Ene-Iordache and
                J. Tordoir and P. Verdonck and A. Remuzzi},
  title = {{Non-linear resistance associated to complex geometry
                 at high flow rates in vascular access for hemodialysis}},
  booktitle = {{World Congress on Medical Physics and Biomedical Engineering}},
  editor = {Olaf D\"{o}ssel and Wolfgang C. Schlegel},
  pages = {543--546},
  publisher = {Springer Berlin Heidelberg},
  month = sep # {~7--12,},
  address = {Munich, Germany},
  year = {2009},
  note = {\url{http://dx.doi.org/10.1007/978-3-642-03885-3}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Barone_2009b">7</a>]
</td>
<td class="bibtexitem">
M.&nbsp;F. Barone, I.&nbsp;Kalashnikova, M.&nbsp;R. Brake, and D.&nbsp;J. Segalman.
 Reduced order modeling of fluid/structure interaction.
 Technical Report SAND2009-7189, Sandia National Laboratories,
  September 2009.
 <a href="http://www.stanford.edu/~irinak/rom_ldrd_sand.pdf">http://www.stanford.edu/~irinak/rom_ldrd_sand.pdf</a>.
<a name="Barone_2009b"></a><pre>
@techreport{Barone_2009b,
  author = {M.~F.~Barone and I.~Kalashnikova and M.~R.~Brake and D.~J.~Segalman},
  title = {{Reduced order modeling of fluid/structure interaction}},
  institution = {Sandia National Laboratories},
  month = sep,
  year = {2009},
  number = {SAND2009-7189},
  note = {\url{http://www.stanford.edu/~irinak/rom_ldrd_sand.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Lu_2009b">8</a>]
</td>
<td class="bibtexitem">
Y.&nbsp;Lu and A.&nbsp;F. Chatziioannou.
 A parallel adaptive finite element method for the simulation of
  photon migration with the radiative-transfer-based model.
 <em>Communications in Numerical Methods in Engineering</em>,
  25(6):751-770, June 2009.
 <a href="http://dx.doi.org/10.1002/cnm.1167">http://dx.doi.org/10.1002/cnm.1167</a>.
<a name="Lu_2009b"></a><pre>
@article{Lu_2009b,
  author = {Y.~Lu and A.~F.~Chatziioannou},
  title = {{A parallel adaptive finite element method for the
              simulation of photon migration with the radiative-transfer-based model}},
  journal = {Communications in Numerical Methods in Engineering},
  month = jun,
  year = 2009,
  volume = 25,
  number = 6,
  pages = {751--770},
  note = {\url{http://dx.doi.org/10.1002/cnm.1167}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="AufderMaur_2009">9</a>]
</td>
<td class="bibtexitem">
M.&nbsp;Auf der Maur, M.&nbsp;Povolotskyi, F.&nbsp;Sacconi, G.&nbsp;Romano, G.&nbsp;Penazzi,
  A.&nbsp;Pecchia, and A.&nbsp;Di Carlo.
 Multiscale-multiphysics simulation of nanostructured devices: the
  TiberCAD project.
 In <em>13th International Workshop on Computational Electronics
  (IWCE '09)</em>. Institute of Electrical and Electronic Engineers (IEEE),
  May&nbsp;27-29, 2009.
 <a href="http://ieeexplore.ieee.org/iel5/5091069/5091070/05091126.pdf">http://ieeexplore.ieee.org/iel5/5091069/5091070/05091126.pdf</a>.
<a name="AufderMaur_2009"></a><pre>
@inproceedings{AufderMaur_2009,
  author = {M.~{Auf der Maur} and M.~Povolotskyi and F.~Sacconi and
                G.~Romano and G.~Penazzi and A.~Pecchia and A.~{Di Carlo}},
  title = {{Multiscale-multiphysics simulation of nanostructured devices:
                 the TiberCAD project}},
  booktitle = {{13th International Workshop on Computational Electronics (IWCE '09)}},
  publisher = {Institute of Electrical and Electronic Engineers (IEEE)},
  month = may # {~27--29,},
  year = {2009},
  note = {\url{http://ieeexplore.ieee.org/iel5/5091069/5091070/05091126.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Barone_2009">10</a>]
</td>
<td class="bibtexitem">
M.&nbsp;F. Barone, I.&nbsp;Kalashnikova, D.&nbsp;J. Segalman, and H.&nbsp;K. Thornquist.
 Stable Galerkin reduced order models for linearized compressible
  flow.
 <em>Journal of Computational Physics</em>, 228(6):1932-1946, April
  2009.
 <a href="http://dx.doi.org/10.1016/j.jcp.2008.11.015">http://dx.doi.org/10.1016/j.jcp.2008.11.015</a>.
<a name="Barone_2009"></a><pre>
@article{Barone_2009,
  author = {M.~F.~Barone and I.~Kalashnikova and D.~J.~Segalman and H.~K.~Thornquist},
  title = {{Stable Galerkin reduced order models for linearized compressible flow}},
  journal = {Journal of Computational Physics},
  volume = {228},
  number = {6},
  pages = {1932--1946},
  year = {2009},
  month = apr,
  issn = {0021-9991},
  note = {\url{http://dx.doi.org/10.1016/j.jcp.2008.11.015}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Polidori_2009">11</a>]
</td>
<td class="bibtexitem">
M.&nbsp;Polidori.
 Set Up and Preliminary Assessment of a 3D Numerical Model for the
  Thermo-Fluid Dynamics Analysis of an Open Square Lattice Core of a Lead
  Cooled Reactor.
 Technical Report RSE/2009/84, Ente per le Nuove tecnologie, l'Energia
  e l'Ambiente (ENEA), March 2009.
 <a href="http://www.enea.it/enea_paese/sistema_elettrico/Nucleare_fissione/Reattori_Innovativi/RSE84.pdf">http://www.enea.it/enea_paese/sistema_elettrico/Nucleare_fissione/Reattori_Innovativi/RSE84.pdf</a>.
<a name="Polidori_2009"></a><pre>
@techreport{Polidori_2009,
  author = {M.~Polidori},
  title = {{Set Up and Preliminary Assessment of a 3D Numerical Model 
                  for the Thermo-Fluid Dynamics Analysis of an Open Square 
                  Lattice Core of a Lead Cooled Reactor}},
  institution = {Ente per le Nuove tecnologie, l'Energia e l'Ambiente (ENEA)},
  number = {RSE/2009/84},
  year = {2009},
  month = mar,
  note = {\url{http://www.enea.it/enea_paese/sistema_elettrico/
  Nucleare_fissione/Reattori_Innovativi/RSE84.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="S_Lu_2009">12</a>]
</td>
<td class="bibtexitem">
S.&nbsp;Lu et&nbsp;al.
 Multiscale Modeling in Rodent Ventricular Myocytes.
 <em>IEEE Engineering in Medicine and Biology Magazine</em>,
  28(2):46-57, March 2009.
 <a href="http://www.ncbi.nlm.nih.gov/pubmed/19349251">http://www.ncbi.nlm.nih.gov/pubmed/19349251</a>.
<a name="S_Lu_2009"></a><pre>
@article{S_Lu_2009,
  author = {S.~Lu and others},
  title = {{Multiscale Modeling in Rodent Ventricular Myocytes}},
  journal = {IEEE Engineering in Medicine and Biology Magazine},
  year = 2009,
  month = mar,
  volume = 28,
  number = 2,
  pages = {46--57},
  note = {\url{http://www.ncbi.nlm.nih.gov/pubmed/19349251}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Abukhdeir_2009">13</a>]
</td>
<td class="bibtexitem">
N.&nbsp;M. Abukhdeir and A.&nbsp;D. Rey.
 Shape-dynamic growth, structure, and elasticity of homogeneously
  oriented spherulites in an isotropic/smectic-A mesophase transition.
 <em>Liquid Crystals</em>, 36(10-11):1125-1137, 2009.
 <a href="http://dx.doi.org/10.1080/02678290902878754">http://dx.doi.org/10.1080/02678290902878754</a>.
<a name="Abukhdeir_2009"></a><pre>
@article{Abukhdeir_2009,
  author = {N.~M.~Abukhdeir and A.~D.~Rey},
  title = {{Shape-dynamic growth, structure, and elasticity of homogeneously 
              oriented spherulites in an isotropic/smectic-A mesophase transition}},
  journal = {Liquid Crystals},
  year = 2009,
  volume = 36,
  number = {10--11},
  pages = {1125--1137},
  note = {\url{http://dx.doi.org/10.1080/02678290902878754}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Blome_2009">14</a>]
</td>
<td class="bibtexitem">
M.&nbsp;Blome, H.&nbsp;R. Maurer, and K.&nbsp;Schmidt.
 Advances on 3D geoelectric forward solver techniques.
 <em>Geophysical Journal International</em>, 176(3):740-752, 2009.
 <a href="http:dx.doi.org/10.1111/j.1365-246X.2008.04006.x">http:dx.doi.org/10.1111/j.1365-246X.2008.04006.x</a>.
<a name="Blome_2009"></a><pre>
@article{Blome_2009,
  author = {M.~Blome and H.~R.~Maurer and K.~Schmidt},
  title = {{Advances on 3D geoelectric forward solver techniques}},
  journal = {Geophysical Journal International},
  year = 2009,
  volume = 176,
  number = 3,
  pages = {740--752},
  note = {\url{http:dx.doi.org/10.1111/j.1365-246X.2008.04006.x}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="AufderMaur_2009b">15</a>]
</td>
<td class="bibtexitem">
M.&nbsp;Auf der Maur, M.&nbsp;Povolotskyi, F.&nbsp;Sacconi, A.&nbsp;Pecchia, G.&nbsp;Romano,
  G.&nbsp;Penazzi, and A.&nbsp;Di Carlo.
 TiberCAD: towards multiscale simulation of optoelectronic devices.
 <em>Optical and Quantum Electronics</em>, 40(14):1077-1083, 2009.
 <a href="http://dx.doi.org/10.1007/s11082-009-9272-7">http://dx.doi.org/10.1007/s11082-009-9272-7</a>.
<a name="AufderMaur_2009b"></a><pre>
@article{AufderMaur_2009b,
  author = {M.~{Auf der Maur} and M.~Povolotskyi and F.~Sacconi and
               A.~Pecchia and G.~Romano and G.~Penazzi and A.~{Di Carlo}},
  title = {{TiberCAD: towards multiscale simulation of optoelectronic devices}},
  pages = {1077--1083},
  year = 2009,
  journal = {Optical and Quantum Electronics},
  volume = {40},
  number = {14},
  note = {\url{http://dx.doi.org/10.1007/s11082-009-9272-7}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Knezevic_2009">16</a>]
</td>
<td class="bibtexitem">
D.&nbsp;J. Knezevic and E.&nbsp;S&uuml;li.
 A Deterministic Multiscale Approach for Simulating Dilute Polymeric
  Fluids.
 In <em>Lecture Notes in Computational Science and Engineering, BAIL
  2008 - Boundary and Interior Layers</em>, volume&nbsp;69, pages 23-38. Springer,
  Berlin Heidelberg, 2009.
 <a href="http://dx.doi.org/10.1007/978-3-642-00605-0">http://dx.doi.org/10.1007/978-3-642-00605-0</a>.
<a name="Knezevic_2009"></a><pre>
@incollection{Knezevic_2009,
  author = {D.~J.~Knezevic and E.~S\"{u}li},
  title = {{A Deterministic Multiscale Approach
                for Simulating Dilute Polymeric Fluids}},
  pages = {23--38},
  year = 2009,
  publisher = {Springer},
  address = {Berlin Heidelberg},
  booktitle = {Lecture Notes in Computational Science and Engineering,
               BAIL 2008 - Boundary and Interior Layers},
  volume = {69},
  note = {\url{http://dx.doi.org/10.1007/978-3-642-00605-0}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Lu_2009">17</a>]
</td>
<td class="bibtexitem">
Y.&nbsp;Lu, H.&nbsp;B. Machado, A.&nbsp;Douraghy, D.&nbsp;Stout, H.&nbsp;Herschman, and A.&nbsp;F.
  Chatziioannou.
 Experimental bioluminescence tomography with fully parallel
  radiative-transfer-based reconstruction framework.
 <em>Optics Express</em>, 17(19):16681-16695, 2009.
 <a href="http://dx.doi.org/10.1364/OE.17.016681">http://dx.doi.org/10.1364/OE.17.016681</a>.
<a name="Lu_2009"></a><pre>
@article{Lu_2009,
  author = {Y.~Lu and H.~B.~Machado and A.~Douraghy
             and D.~Stout and H.~Herschman and
             A.~F.~Chatziioannou},
  title = {Experimental bioluminescence tomography with fully
             parallel radiative-transfer-based reconstruction framework},
  journal = {Optics Express},
  number = {19},
  pages = {16681--16695},
  volume = {17},
  year = {2009},
  note = {\url{http://dx.doi.org/10.1364/OE.17.016681}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Xu_2009">18</a>]
</td>
<td class="bibtexitem">
D.&nbsp;Xu, J.&nbsp;Stare, and A.&nbsp;L. Cooksy.
 Solving the vibrational Schr&ouml;dinger equation on an arbitrary
  multidimensional potential energy surface by the finite element method.
 <em>Computer Physics Communications</em>, 180(11):2079-2094, 2009.
 <a href="http://dx.doi.org/10.1016/j.cpc.2009.06.010">http://dx.doi.org/10.1016/j.cpc.2009.06.010</a>.
<a name="Xu_2009"></a><pre>
@article{Xu_2009,
  author = {D.~Xu and J.~Stare and A.~L.~Cooksy},
  title = {Solving the vibrational {S}chr\"{o}dinger equation
             on an arbitrary multidimensional potential energy
	     surface by the finite element method},
  journal = {Computer Physics Communications},
  volume = {180},
  number = {11},
  pages = {2079--2094},
  year = {2009},
  note = {\url{http://dx.doi.org/10.1016/j.cpc.2009.06.010}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Gaston_2009b">19</a>]
</td>
<td class="bibtexitem">
D.&nbsp;Gaston, C.&nbsp;Newman, G.&nbsp;Hansen, and D.&nbsp;Lebrun-Grandi&eacute;.
 Moose: A parallel computational framework for coupled systems of
  nonlinear equations.
 <em>Nuclear Engineering and Design</em>, 239(10):1768-1778, 2009.
 <a href="http://dx.doi.org/10.1016/j.nucengdes.2009.05.021">http://dx.doi.org/10.1016/j.nucengdes.2009.05.021</a>.
<a name="Gaston_2009b"></a><pre>
@article{Gaston_2009b,
  author = {D.~Gaston and C.~Newman and G.~Hansen and D.~Lebrun-Grandi\'{e}},
  title = {MOOSE: A parallel computational framework for coupled
             systems of nonlinear equations},
  journal = {Nuclear Engineering and Design},
  volume = {239},
  number = {10},
  pages = {1768--1778},
  year = {2009},
  note = {\url{http://dx.doi.org/10.1016/j.nucengdes.2009.05.021}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Jones_2009">20</a>]
</td>
<td class="bibtexitem">
I.&nbsp;A. Jones, W.&nbsp;Ruijter, and A.&nbsp;C. Long.
 A novel tetrahedal element for static and dynamic analysis of
  laminated composites.
 <em>Journal of Physics: Conference Series</em>, 181:012042 (8pp), 2009.
 <a href="http://dx.doi.org/10.1088/1742-6596/181/1/012042">http://dx.doi.org/10.1088/1742-6596/181/1/012042</a>.
<a name="Jones_2009"></a><pre>
@article{Jones_2009,
  author = {I.~A.~Jones and W.~Ruijter and A.~C.~Long},
  title = {A novel tetrahedal element for static and dynamic analysis of laminated composites},
  journal = {Journal of Physics: Conference Series},
  volume = {181},
  pages = {012042 (8pp)},
  note = {\url{http://dx.doi.org/10.1088/1742-6596/181/1/012042}},
  year = {2009}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Mahadevan_2009">21</a>]
</td>
<td class="bibtexitem">
V.&nbsp;S. Mahadevan, J.&nbsp;C. Ragusa, and V.&nbsp;Mousseau.
 Verification of multiphysics software: Space and time convergence
  studies for nonlinearly coupled applications.
 In <em>International Conference on Mathematics, Computaional Methods
  &amp; Reactor Physics (M&amp;C 2009)</em>, Saratoga Springs, New York, 2009.
 <a href="http://www.inl.gov/technicalpublications/Documents/4247162.pdf">http://www.inl.gov/technicalpublications/Documents/4247162.pdf</a>.
<a name="Mahadevan_2009"></a><pre>
@conference{Mahadevan_2009,
  author = {V.~S.~Mahadevan and J.~C.~Ragusa and V.~Mousseau},
  title = {Verification of Multiphysics software: Space and time
               convergence studies for nonlinearly coupled applications},
  booktitle = {International Conference on Mathematics, Computaional
               Methods \& Reactor Physics (M\&C 2009)},
  address = {Saratoga Springs, New York},
  year = {2009},
  note = {\url{http://www.inl.gov/technicalpublications/Documents/4247162.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Gaston_2009">22</a>]
</td>
<td class="bibtexitem">
D.&nbsp;Gaston, G.&nbsp;Hansen, S.&nbsp;Kadioglu, D.&nbsp;A. Knoll, C.&nbsp;Newman, H.&nbsp;Park, C.&nbsp;Permann,
  and W.&nbsp;Taitano.
 Parallel multiphysics algorithms and software for computational
  nuclear engineering.
 <em>Journal of Physics: Conference Series</em>, 180:012012 (10pp), 2009.
 <a href="http://dx.doi.org/10.1088/1742-6596/180/1/012012">http://dx.doi.org/10.1088/1742-6596/180/1/012012</a>.
<a name="Gaston_2009"></a><pre>
@article{Gaston_2009,
  author = {D.~Gaston and G.~Hansen and S.~Kadioglu and D.~A.~Knoll
            and C.~Newman and H.~Park and C.~Permann and W.~Taitano},
  title = {Parallel multiphysics algorithms and software for computational nuclear engineering},
  journal = {Journal of Physics: Conference Series},
  volume = {180},
  pages = {012012 (10pp)},
  year = {2009},
  note = {\url{http://dx.doi.org/10.1088/1742-6596/180/1/012012}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Luethi2009">23</a>]
</td>
<td class="bibtexitem">
M.&nbsp;P. L&uuml;thi.
 Transient response of idealized glaciers to climate variations.
 <em>Journal of Glaciology</em>, 55(193):918-930, 2009.
 <a href="http://dx.doi.org/10.3189/002214309790152519">http://dx.doi.org/10.3189/002214309790152519</a>.
<a name="Luethi2009"></a><pre>
@article{Luethi2009,
  author = {M.~P.~L{\"u}thi},
  title = {Transient response of idealized glaciers to climate variations},
  journal = {Journal of Glaciology},
  year = 2009,
  number = 193,
  volume = 55,
  pages = {918--930},
  note = {\url{http://dx.doi.org/10.3189/002214309790152519}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Valli_2009">24</a>]
</td>
<td class="bibtexitem">
A.&nbsp;M.&nbsp;P. Valli, R.&nbsp;N. Elias, G.&nbsp;F. Carey, and A.&nbsp;L. G.&nbsp;A. Coutinho.
 PID adaptive control of incremental and arclength continuation in
  nonlinear applications.
 <em>International Journal for Numerical Methods in Fluids</em>,
  61(11):1181-1200, 2009.
 <a href="http://dx.doi.org/10.1002/fld.1998">http://dx.doi.org/10.1002/fld.1998</a>.
<a name="Valli_2009"></a><pre>
@article{Valli_2009,
  author = {A. M. P. Valli and R. N. Elias and G. F. Carey and A. L. G. A. Coutinho},
  title = {{PID adaptive control of incremental and arclength continuation in nonlinear applications}},
  journal = {International Journal for Numerical Methods in Fluids},
  year = 2009,
  volume = {61},
  number = {11},
  pages = {1181--1200},
  note = {\url{http://dx.doi.org/10.1002/fld.1998}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Biermann_2009">25</a>]
</td>
<td class="bibtexitem">
J.&nbsp;Biermann, O.&nbsp;von Estorff, S.&nbsp;Petersen, and C.&nbsp;Wenterodt.
 Higher order finite and infinite elements for the solution of
  Helmholtz problems.
 <em>Computer Methods in Applied Mechanics and Engineering</em>,
  198(13-14):1171-1188, 2009.
 <a href="http://dx.doi.org/10.1016/j.cma.2008.11.009">http://dx.doi.org/10.1016/j.cma.2008.11.009</a>.
<a name="Biermann_2009"></a><pre>
@article{Biermann_2009,
  author = {J.~Biermann and O.~von Estorff and S.~Petersen and C.~Wenterodt},
  title = {{Higher order finite and infinite elements for the solution of Helmholtz problems}},
  journal = {Computer Methods in Applied Mechanics and Engineering},
  volume = {198},
  number = {13--14},
  pages = {1171--1188},
  year = {2009},
  issn = {0045-7825},
  note = {\url{http://dx.doi.org/10.1016/j.cma.2008.11.009}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Kirk_2009">26</a>]
</td>
<td class="bibtexitem">
B.&nbsp;S. Kirk.
 Multidimensional Assessment of Modeling Error in Typical High-Speed
  Wind-Tunnel Heat-Transfer Data-Reduction Schemes.
 <em>AIAA Journal of Thermophysics and Heat Transfer</em>,
  23(1):186-191, January 2009.
 <a href="http://dx.doi.org/10.2514/1.35989">http://dx.doi.org/10.2514/1.35989</a>.
<a name="Kirk_2009"></a><pre>
@article{Kirk_2009,
  author = {B.~S.~Kirk},
  title = {{Multidimensional Assessment of Modeling Error in Typical
              High-Speed Wind-Tunnel Heat-Transfer Data-Reduction Schemes}},
  journal = {AIAA Journal of Thermophysics and Heat Transfer},
  year = 2009,
  month = jan,
  volume = 23,
  number = 1,
  pages = {186--191},
  note = {\url{http://dx.doi.org/10.2514/1.35989}}
}
</pre>


</td>
</tr>
</table><h2>2008</h2>

<!-- This document was automatically generated with bibtex2html 1.95
     (see http://www.lri.fr/~filliatr/bibtex2html/),
     with the following command:
     bibtex2html -d -r --nodoc --single -nofooter eight.bib  -->


<table>

<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Cervone_2008">1</a>]
</td>
<td class="bibtexitem">
A.&nbsp;Cervone and S.&nbsp;Manservisi.
 A three-dimensional CFD program for the simulation of the
  thermo-hydraulic behaviour of an open core liquid metal reactor.
 Technical Report RSE/2009/85, ENEA: Ente per le Nuove tecnologie,
  l'Energia e l'Ambiente, December 2008.
 <a href="http://www.enea.it/attivita_ricerca/energia/sistema_elettrico/Nucleare_fissione/Reattori_Innovativi/RSE85.pdf">http://www.enea.it/attivita_ricerca/energia/sistema_elettrico/Nucleare_fissione/Reattori_Innovativi/RSE85.pdf</a>.
<a name="Cervone_2008"></a><pre>
@techreport{Cervone_2008,
  author = {A.~Cervone and S.~Manservisi},
  title = {{A three-dimensional CFD program for the simulation of
                  the thermo-hydraulic behaviour of an open core liquid metal reactor}},
  institution = {ENEA: Ente per le Nuove tecnologie, l'Energia e l'Ambiente},
  day = 16,
  month = dec,
  year = 2008,
  number = {RSE/2009/85},
  note = {\url{http://www.enea.it/attivita_ricerca/energia/
  sistema_elettrico/Nucleare_fissione/Reattori_Innovativi/RSE85.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Hawkins_2008">2</a>]
</td>
<td class="bibtexitem">
A.&nbsp;Hawkins and J.&nbsp;T. Oden.
 Toward a predictive model of tumor growth.
 Technical report, Institute for Computational Engineering and
  Sciences (ICES), The University of Texas at Austin, November 2008.
 <a href="http://www.ices.utexas.edu/research/reports/2008/0829.pdf">http://www.ices.utexas.edu/research/reports/2008/0829.pdf</a>.
<a name="Hawkins_2008"></a><pre>
@techreport{Hawkins_2008,
  author = {A.~Hawkins and J.~T.~Oden},
  title = {{Toward a predictive model of tumor growth}},
  institution = {Institute for Computational Engineering and Sciences (ICES),
                 The University of Texas at Austin},
  day = {20},
  month = nov,
  year = {2008},
  note = {\url{http://www.ices.utexas.edu/research/reports/2008/0829.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Antiga_2008">3</a>]
</td>
<td class="bibtexitem">
L.&nbsp;Antiga, M.&nbsp;Piccinelli, L.&nbsp;Botti, B.&nbsp;Ene-Iordache, A.&nbsp;Remuzzi, and D.&nbsp;A.
  Steinman.
 An image-based modeling framework for patient-specific computational
  hemodynamics.
 <em>Medical and Biological Engineering and Computing</em>,
  46(11):1097-1112, November 2008.
 <a href="http://dx.doi.org/10.1007/s11517-008-0420-1">http://dx.doi.org/10.1007/s11517-008-0420-1</a>.
<a name="Antiga_2008"></a><pre>
@article{Antiga_2008,
  author = {L.~Antiga and M.~Piccinelli and L.~Botti and B.~Ene-Iordache and A.~Remuzzi and D.~A.~Steinman},
  title = {{An image-based modeling framework for patient-specific computational hemodynamics}},
  journal = {Medical and Biological Engineering and Computing},
  year = 2008,
  volume = 46,
  number = 11,
  month = nov,
  pages = {1097--1112},
  note = {\url{http://dx.doi.org/10.1007/s11517-008-0420-1}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Xu_2008">4</a>]
</td>
<td class="bibtexitem">
D.&nbsp;Xu, J.&nbsp;Stare, and A.&nbsp;L. Cooksy.
 Solving the vibrational Schr&ouml;dinger equation on an arbitrary
  multidimensional potential energy surface by the finite element method.
 Technical Report CSRCR2008-26, Computational Science Research Center,
  San Diego State University, October 2008.
<a name="Xu_2008"></a><pre>
@techreport{Xu_2008,
  author = {D.~Xu and J.~Stare and A.~L.~Cooksy},
  title = {{Solving the vibrational {S}chr\"{o}dinger equation
                  on an arbitrary multidimensional potential
		  energy surface by the finite element method}},
  institution = {Computational Science Research Center,
                 San Diego State University},
  day = {15},
  month = oct,
  year = {2008},
  number = {CSRCR2008-26}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Mahadevan_2008">5</a>]
</td>
<td class="bibtexitem">
V.&nbsp;S. Mahadevan and J.&nbsp;C. Ragusa.
 High-order spatio-temporal schemes for coupled, multi-physics reactor
  simulations.
 Technical report, Idaho National Laboratory, September 2008.
 <a href="http://www.inl.gov/technicalpublications/Documents/4120524.pdf">http://www.inl.gov/technicalpublications/Documents/4120524.pdf</a>.
<a name="Mahadevan_2008"></a><pre>
@techreport{Mahadevan_2008,
  author = {V.~S.~Mahadevan and J.~C.~Ragusa},
  title = {High-order spatio-temporal schemes for coupled, multi-physics reactor simulations},
  institution = {Idaho National Laboratory},
  month = sep,
  year = {2008},
  note = {\url{http://www.inl.gov/technicalpublications/Documents/4120524.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Galbusera_2008">6</a>]
</td>
<td class="bibtexitem">
F.&nbsp;Galbusera, M.&nbsp;Cioffi, and M.&nbsp;T. Raimondi.
 An in silico bioreactor for simulating laboratory experiments in
  tissue engineering.
 <em>Biomedical Microdevices</em>, 10(4):547-554, August 2008.
 <a href="http://dx.doi.org/10.1007/s10544-008-9164-9">http://dx.doi.org/10.1007/s10544-008-9164-9</a>.
<a name="Galbusera_2008"></a><pre>
@article{Galbusera_2008,
  author = {F.~Galbusera and M.~Cioffi and M.~T.~Raimondi},
  title = {{An in silico bioreactor for simulating laboratory experiments in tissue engineering}},
  journal = {Biomedical Microdevices},
  year = 2008,
  volume = 10,
  number = 4,
  month = aug,
  pages = {547--554},
  note = {\url{http://dx.doi.org/10.1007/s10544-008-9164-9}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Piccinelli_2008">7</a>]
</td>
<td class="bibtexitem">
M.&nbsp;Piccinelli, L.&nbsp;Botti, B.&nbsp;Ene-Iordache, A.&nbsp;Remuzzi, A.&nbsp;Veneziani, and
  L.&nbsp;Antiga.
 Link between vortex structures and voronoi diagram in cerebral
  aneurysms.
 <em>Journal of Biomechanics</em>, 41, Supplement 1:S12, July 2008.
<a name="Piccinelli_2008"></a><pre>
@article{Piccinelli_2008,
  author = {M.~Piccinelli and L.~Botti and B.~Ene-Iordache
             and A.~Remuzzi and A.~Veneziani and L.~Antiga},
  title = {{Link between vortex structures and voronoi diagram in cerebral aneurysms}},
  journal = {Journal of Biomechanics},
  year = 2008,
  month = jul,
  volume = {41, Supplement 1},
  pages = {S12}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="VanCanneyt_2008">8</a>]
</td>
<td class="bibtexitem">
K.&nbsp;Van Canneyt, R.&nbsp;Kaminsky, L.&nbsp;Botti, L.&nbsp;Antiga, J.&nbsp;Tordoir, P.&nbsp;Verdonck, and
  S.&nbsp;Eloot.
 Can a kinked arterio-venous graft cause instable flow? a
  patient-specific validated computational study.
 <em>Journal of Biomechanics</em>, 41(Supplement 1):S210, July 2008.
 <a href="http://dx.doi.org/10.1016/S0021-9290(08)70210-0">http://dx.doi.org/10.1016/S0021-9290(08)70210-0</a>.
<a name="VanCanneyt_2008"></a><pre>
@article{VanCanneyt_2008,
  author = {K.~Van Canneyt and R.~Kaminsky and L.~Botti and
           L.~Antiga and J.~Tordoir and P.~Verdonck and S.~Eloot},
  title = {CAN A KINKED ARTERIO-VENOUS GRAFT CAUSE INSTABLE FLOW?
           A PATIENT-SPECIFIC VALIDATED COMPUTATIONAL STUDY},
  journal = {Journal of Biomechanics},
  volume = {41},
  number = {Supplement 1},
  pages = {S210},
  year = {2008},
  month = jul,
  issn = {0021-9290},
  note = {\url{http://dx.doi.org/10.1016/S0021-9290(08)70210-0}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Botti_2008">9</a>]
</td>
<td class="bibtexitem">
L.&nbsp;Botti, M.&nbsp;Piccinelli, B.&nbsp;Ene-Iordache, A.&nbsp;Remuzzi, and L.&nbsp;Antiga.
 An open source parallel AMR FE solver for biological flows based
  on the LibMesh C++ library.
 <em>Journal of Biomechanics</em>, 41(Supplement 1):S211, July 2008.
 <a href="http://dx.doi.org/10.1016/S0021-9290(08)70211-2">http://dx.doi.org/10.1016/S0021-9290(08)70211-2</a>.
<a name="Botti_2008"></a><pre>
@article{Botti_2008,
  author = {L.~Botti and M.~Piccinelli and B.~Ene-Iordache and A.~Remuzzi and L.~Antiga},
  title = {AN OPEN SOURCE PARALLEL {AMR} {FE} SOLVER FOR BIOLOGICAL FLOWS BASED ON THE {LibMesh C++} LIBRARY},
  journal = {Journal of Biomechanics},
  volume = {41},
  number = {Supplement 1},
  pages = {S211},
  year = {2008},
  month = jul,
  issn = {0021-9290},
  note = {\url{http://dx.doi.org/10.1016/S0021-9290(08)70211-2}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Ahn_2008">10</a>]
</td>
<td class="bibtexitem">
H.&nbsp;T. Ahn, M.&nbsp;Shashkov, and M.&nbsp;A. Christon.
 The moment-of-fluid method in action.
 <em>Communications in Numerical Methods in Engineering</em>,
  25(10):1009-1018, July 2008.
 <a href="http://dx.doi.org/10.1002/cnm.1135">http://dx.doi.org/10.1002/cnm.1135</a>.
<a name="Ahn_2008"></a><pre>
@article{Ahn_2008,
  author = {{Ahn}, H.~T. and {Shashkov}, M. and M.~A.~Christon},
  title = {{The moment-of-fluid method in action}},
  journal = {Communications in Numerical Methods in Engineering},
  year = 2008,
  month = jul,
  volume = {25},
  number = {10},
  pages = {1009--1018},
  note = {\url{http://dx.doi.org/10.1002/cnm.1135}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Powell_2008">11</a>]
</td>
<td class="bibtexitem">
A.&nbsp;C. Powell, IV and R.&nbsp;Arroyave.
 Open source software for materials and process modeling.
 <em>Journal of the Minerals, Metals and Materials Society</em>,
  60(5):32-39, May 2008.
 <a href="http://dx.doi.org/10.1007/s11837-008-0057-4">http://dx.doi.org/10.1007/s11837-008-0057-4</a>.
<a name="Powell_2008"></a><pre>
@article{Powell_2008,
  author = {{Powell}, IV, A.~C. and {Arroyave}, R.},
  title = {{Open source software for materials and process modeling}},
  journal = {Journal of the Minerals, Metals and Materials Society},
  year = 2008,
  month = may,
  volume = 60,
  number = 5,
  pages = {32--39},
  note = {\url{http://dx.doi.org/10.1007/s11837-008-0057-4}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Kroger_2008">12</a>]
</td>
<td class="bibtexitem">
T.&nbsp;Kr&ouml;ger and T.&nbsp;Preusser.
 Stability of the 8-tetrahedra shortest-interior-edge partitioning
  method.
 <em>Numerische Mathematik</em>, 109(3):435-457, May 2008.
 <a href="http://dx.doi.org/10.1007/s00211-008-0148-8">http://dx.doi.org/10.1007/s00211-008-0148-8</a>.
<a name="Kroger_2008"></a><pre>
@article{Kroger_2008,
  author = {T.~Kr\"{o}ger and T.~Preusser},
  title = {{Stability of the 8-tetrahedra shortest-interior-edge partitioning method}},
  journal = {Numerische Mathematik},
  year = 2008,
  month = may,
  volume = 109,
  number = 3,
  pages = {435--457},
  note = {\url{http://dx.doi.org/10.1007/s00211-008-0148-8}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Bhatia_2008">13</a>]
</td>
<td class="bibtexitem">
M.&nbsp;Bhatia and E.&nbsp;Livnet.
 Design-oriented thermostructural analysis with external and internal
  radiation, Part 1: Steady state.
 <em>AIAA Journal</em>, 46(3):578-590, March 2008.
 <a href="http://dx.doi.org/10.2514/1.26236">http://dx.doi.org/10.2514/1.26236</a>.
<a name="Bhatia_2008"></a><pre>
@article{Bhatia_2008,
  author = {M.~Bhatia and E.~Livnet},
  title = {{Design-oriented thermostructural analysis with external and internal radiation, Part 1: Steady state}},
  journal = {AIAA Journal},
  year = 2008,
  volume = 46,
  number = 3,
  month = mar,
  pages = {578--590},
  note = {\url{http://dx.doi.org/10.2514/1.26236}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Barone_2008">14</a>]
</td>
<td class="bibtexitem">
M.&nbsp;F. Barone, D.&nbsp;J. Segalman, H.&nbsp;Thornquist, and I.&nbsp;Kalashnikova.
 Galerkin reduced order models for compressible flow with structural
  interaction.
 In <em>46th AIAA Aerospace Sciences Meeting and Exhibit</em>, Reno, NV,
  2008.
 <a href="http://www.stanford.edu/~irinak/reno08.pdf">http://www.stanford.edu/~irinak/reno08.pdf</a>.
<a name="Barone_2008"></a><pre>
@conference{Barone_2008,
  author = {M.~F.~Barone and D.~J.~Segalman and H.~Thornquist and I.~Kalashnikova},
  title = {Galerkin reduced order models for compressible flow with structural interaction},
  booktitle = {46th AIAA Aerospace Sciences Meeting and Exhibit},
  address = {Reno, NV},
  year = {2008},
  note = {\url{http://www.stanford.edu/~irinak/reno08.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="VonEstorff_2008">15</a>]
</td>
<td class="bibtexitem">
O.&nbsp;von Estorff, S.&nbsp;Petersen, and D.&nbsp;Dreyer.
 Efficient Infinite Elements based on Jacobi Polynomials.
 In Steffen Marburg and Bodo Nolte, editors, <em>Computational
  Acoustics of Noise Propagation in Fluids-Finite and Boundary Element
  Methods</em>, pages 231-250. Springer Berlin Heidelberg, 2008.
 <a href="http://dx.doi.org/10.1007/978-3-540-77448-8_9">http://dx.doi.org/10.1007/978-3-540-77448-8_9</a>.
<a name="VonEstorff_2008"></a><pre>
@incollection{VonEstorff_2008,
  author = {O.~{von Estorff} and S.~Petersen and D.~Dreyer},
  title = {{Efficient Infinite Elements based on Jacobi Polynomials}},
  pages = {231--250},
  year = 2008,
  publisher = {Springer Berlin Heidelberg},
  editor = {Steffen Marburg and Bodo Nolte},
  booktitle = {Computational Acoustics of Noise Propagation in
               Fluids--Finite and Boundary Element Methods},
  volume = {},
  note = {\url{http://dx.doi.org/10.1007/978-3-540-77448-8_9}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="DeSturler_2008">16</a>]
</td>
<td class="bibtexitem">
E.&nbsp;De Sturler, G.&nbsp;H. Paulino, and S.&nbsp;Wang.
 Topology optimization with adaptive mesh refinement.
 In J.&nbsp;F. Abel and J.&nbsp;R. Cooke, editors, <em>Proceedings of the 6th
  Internation Conference on Computation of Shell and Spatial Structures
  (IASS-IACM 2008)</em>, Ithaca, NY, 2008. Cornell University.
 <a href="http://www.math.vt.edu/people/sturler/publications/Proc-IASS-IACM_TopOptAMR_SturlerPaulinoWang_2008.pdf">http://www.math.vt.edu/people/sturler/publications/Proc-IASS-IACM_TopOptAMR_SturlerPaulinoWang_2008.pdf</a>.
<a name="DeSturler_2008"></a><pre>
@inproceedings{DeSturler_2008,
  author = {E.~{De Sturler} and G.~H.~Paulino and S.~Wang},
  title = {Topology Optimization with Adaptive Mesh Refinement},
  booktitle = {{Proceedings of the 6th Internation Conference on
                 Computation of Shell and Spatial Structures (IASS-IACM 2008)}},
  editor = {J.~F.~Abel and J.~R.~Cooke},
  publisher = {Cornell University},
  address = {Ithaca, NY},
  year = {2008},
  note = {\url{http://www.math.vt.edu/people/sturler/
  publications/Proc-IASS-IACM_TopOptAMR_SturlerPaulinoWang_2008.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Stogner_2008">17</a>]
</td>
<td class="bibtexitem">
R.&nbsp;H. Stogner, G.&nbsp;F. Carey, and B.&nbsp;T. Murray.
 Approximation of Cahn-Hilliard diffuse interface models using
  parallel adaptive mesh refinement and coarsening with <em>C</em><sup>1</sup> elements.
 <em>International Journal for Numerical Methods in Engineering</em>,
  76(5):636-661, 2008.
 <a href="http://dx.doi.org/10.1002/nme.2337">http://dx.doi.org/10.1002/nme.2337</a>.
<a name="Stogner_2008"></a><pre>
@article{Stogner_2008,
  author = {R.~H.~Stogner and G.~F.~Carey and B.~T.~Murray},
  title = {{Approximation of Cahn-Hilliard diffuse interface models
              using parallel adaptive mesh refinement and coarsening with
	      $C^1$ elements}},
  journal = {International Journal for Numerical Methods in Engineering},
  year = 2008,
  volume = 76,
  number = 5,
  pages = {636--661},
  note = {\url{http://dx.doi.org/10.1002/nme.2337}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Berrone_2008">18</a>]
</td>
<td class="bibtexitem">
S.&nbsp;Berrone and E.&nbsp;S&uuml;li.
 Two-sided a posteriori error bounds for incompressible
  quasi-Newtonian flows.
 <em>IMA Journal of Numerical Analysis</em>, 28(2):382-421, 2008.
 <a href="http://dx.doi.org/10.1093/imanum/drm017">http://dx.doi.org/10.1093/imanum/drm017</a>.
<a name="Berrone_2008"></a><pre>
@article{Berrone_2008,
  author = {S.~Berrone and E.~S\"{u}li},
  title = {{Two-sided a posteriori error bounds for incompressible quasi-Newtonian flows}},
  journal = {IMA Journal of Numerical Analysis},
  year = 2008,
  volume = 28,
  number = 2,
  pages = {382--421},
  note = {\url{http://dx.doi.org/10.1093/imanum/drm017}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Kirk_2008a">19</a>]
</td>
<td class="bibtexitem">
B.&nbsp;S. Kirk and G.&nbsp;F. Carey.
 Development and validation of a SUPG finite element scheme for the
  compressible Navier-Stokes equations using a modified inviscid flux
  discretization.
 <em>International Journal for Numerical Methods in Fluids</em>,
  57(3):265-293, 2008.
 <a href="http://dx.doi.org/10.1002/fld.1635">http://dx.doi.org/10.1002/fld.1635</a>.
<a name="Kirk_2008a"></a><pre>
@article{Kirk_2008a,
  author = {B.~S.~Kirk and G.~F.~Carey},
  title = {{Development and validation of a SUPG finite element scheme for the compressible
              Navier-Stokes equations using a modified inviscid flux discretization}},
  journal = {International Journal for Numerical Methods in Fluids},
  year = 2008,
  volume = 57,
  number = 3,
  pages = {265--293},
  note = {\url{http://dx.doi.org/10.1002/fld.1635}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Brinkmeier_2008">20</a>]
</td>
<td class="bibtexitem">
M.&nbsp;Brinkmeier, U.&nbsp;Nackenhorst, S.&nbsp;Petersen, and O.&nbsp;von Estorff.
 A numerical model for the simulation of tire rolling noise.
 <em>Journal of Sound and Vibration</em>, 309(1-2):20-39, January 2008.
 <a href="http://dx.doi.org/10.1016/j.jsv.2006.11.040">http://dx.doi.org/10.1016/j.jsv.2006.11.040</a>.
<a name="Brinkmeier_2008"></a><pre>
@article{Brinkmeier_2008,
  author = {Brinkmeier, M. and Nackenhorst, U. and Petersen, S. and {von Estorff}, O.},
  title = {A Numerical Model for the Simulation of Tire Rolling Noise},
  journal = {Journal of Sound and Vibration},
  year = {2008},
  month = jan,
  volume = {309},
  number = {1--2},
  pages = {20--39},
  note = {\url{http://dx.doi.org/10.1016/j.jsv.2006.11.040}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Lu_2008">21</a>]
</td>
<td class="bibtexitem">
Y.&nbsp;Lu and A.&nbsp;F. Chatziioannou.
 Parallel adaptive finite element simulation for optical molecular
  imaging with simplified spherical harmonics approximation.
 In P.&nbsp;Sellin, editor, <em>Nuclear Science Symposium Conference
  Record (NSS08)</em>, pages 4039-4042. IEEE, 2008.
 <a href="http://dx.doi.org/10.1109/NSSMIC.2008.4774171">http://dx.doi.org/10.1109/NSSMIC.2008.4774171</a>.
<a name="Lu_2008"></a><pre>
@inproceedings{Lu_2008,
  author = {Y.~Lu and A.~F.~Chatziioannou},
  title = {{Parallel adaptive finite element simulation for optical
                 molecular imaging with simplified spherical harmonics approximation}},
  booktitle = {{Nuclear Science Symposium Conference Record (NSS08)}},
  editor = {P.~Sellin},
  pages = {4039--4042},
  publisher = {IEEE},
  year = {2008},
  note = {\url{http://dx.doi.org/10.1109/NSSMIC.2008.4774171}}
}
</pre>


</td>
</tr>
</table><h2>2007</h2>

<!-- This document was automatically generated with bibtex2html 1.95
     (see http://www.lri.fr/~filliatr/bibtex2html/),
     with the following command:
     bibtex2html -d -r --nodoc --single -nofooter seven.bib  -->


<table>

<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Anderson_2007">1</a>]
</td>
<td class="bibtexitem">
M.&nbsp;Anderson and J.-H. Kimn.
 A numerical approach to space-time finite elements for the wave
  equation.
 <em>Journal of Computational Physics</em>, 226:466-476, September 2007.
 <a href="http://dx.doi.org/10.1016/j.jcp.2007.04.021">http://dx.doi.org/10.1016/j.jcp.2007.04.021</a>.
<a name="Anderson_2007"></a><pre>
@article{Anderson_2007,
  author = {{Anderson}, M. and {Kimn}, {J.-H.}},
  title = {{A numerical approach to space-time finite elements for the wave equation}},
  journal = {Journal of Computational Physics},
  eprint = {arXiv:gr-qc/0601099},
  year = 2007,
  month = sep,
  volume = 226,
  pages = {466--476},
  note = {\url{http://dx.doi.org/10.1016/j.jcp.2007.04.021}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Steensland_2007">2</a>]
</td>
<td class="bibtexitem">
J.&nbsp;Steensland and J.&nbsp;W. Peterson.
 A Study of Dynamically Adaptive Partitioning for AMR.
 In <em>Proceedings of the 2007 International Conference on Parallel
  and Distributed Processing Techniques and Applications (PDPTA'07) Volume 2</em>,
  pages 503-509, Las Vegas, NV, June&nbsp;25-28, 2007. CSREA Press.
 ISBN: 1-60132-021-3.
<a name="Steensland_2007"></a><pre>
@inproceedings{Steensland_2007,
  author = {J.~Steensland and J.~W.~Peterson},
  title = {{A Study of Dynamically Adaptive Partitioning for AMR}},
  booktitle = {{Proceedings of the 2007 International Conference on Parallel and
                Distributed Processing Techniques and Applications (PDPTA'07)
		Volume 2}},
  month = jun # {~25--28,},
  pages = {503--509},
  address = {Las Vegas, NV},
  publisher = {CSREA Press},
  year = {2007},
  note = {ISBN: 1-60132-021-3}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="AufderMaur_2007">3</a>]
</td>
<td class="bibtexitem">
M.&nbsp;Auf der Maur, M.&nbsp;Povolotskyi, F.&nbsp;Sacconi, and A.&nbsp;di Carlo.
 TIBERCAD: A new multiscale simulator for electronic and
  optoelectronic devices.
 <em>Superlattices and Microstructures</em>, 41:381-385, May 2007.
 <a href="http://dx.doi.org/10.1016/j.spmi.2007.03.011">http://dx.doi.org/10.1016/j.spmi.2007.03.011</a>.
<a name="AufderMaur_2007"></a><pre>
@article{AufderMaur_2007,
  author = {{Auf der Maur}, M. and {Povolotskyi}, M. and {Sacconi}, F. and 
             {di Carlo}, A.},
  title = {{TIBERCAD: A new multiscale simulator for electronic and optoelectronic devices}},
  journal = {Superlattices and Microstructures},
  year = 2007,
  month = may,
  volume = 41,
  pages = {381--385},
  note = {\url{http://dx.doi.org/10.1016/j.spmi.2007.03.011}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Stogner_2007">4</a>]
</td>
<td class="bibtexitem">
R.&nbsp;H. Stogner and G.&nbsp;F. Carey.
 <em>C</em><sup>1</sup> macroelements in adaptive finite element methods.
 <em>Int. J. Numerical Methods in Engineering</em>, 70(9):1076-1095, May
  2007.
 <a href="http://dx.doi.org/10.1002/nme.1912">http://dx.doi.org/10.1002/nme.1912</a>.
<a name="Stogner_2007"></a><pre>
@article{Stogner_2007,
  author = {R.~H.~Stogner and G.~F.~Carey},
  title = {{$C^1$} macroelements in adaptive finite element methods},
  journal = {Int. J. Numerical Methods in Engineering},
  volume = 70,
  number = 9,
  pages = {1076--1095},
  month = may,
  year = 2007,
  note = {\url{http://dx.doi.org/10.1002/nme.1912}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Nam_2007">5</a>]
</td>
<td class="bibtexitem">
K.&nbsp;Nam and M.&nbsp;M. Aral.
 Optimal placement of monitoring sensors in lakes.
 In <em>Proceedings of the 2007 Georgia Water Resources Conference</em>,
  University of Georgia, March&nbsp;27-29, 2007.
 <a href="http://www.uga.edu/water/publication/uploads/2007/3.6.4.pdf">http://www.uga.edu/water/publication/uploads/2007/3.6.4.pdf</a>.
<a name="Nam_2007"></a><pre>
@inproceedings{Nam_2007,
  author = {K.~Nam and M.~M.~Aral},
  title = {{Optimal placement of monitoring sensors in lakes}},
  booktitle = {Proceedings of the 2007 Georgia Water Resources Conference},
  address = {University of Georgia},
  month = mar # {~27--29,},
  year = {2007},
  note = {\url{http://www.uga.edu/water/publication/uploads/2007/3.6.4.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Biermann_2007">6</a>]
</td>
<td class="bibtexitem">
J.&nbsp;Biermann, O.&nbsp;von Estorff, S.&nbsp;Petersen, and H.&nbsp;Schmidt.
 Computational model to investigate the sound radiation from rolling
  tires.
 <em>Tire Science and Technology</em>, 35(3):209-225, 2007.
 <a href="http://dx.doi.org/10.2346/1.2768608">http://dx.doi.org/10.2346/1.2768608</a>.
<a name="Biermann_2007"></a><pre>
@article{Biermann_2007,
  author = {J.~Biermann and O.~von Estorff and S.~Petersen and H.~Schmidt},
  title = {Computational Model to Investigate the Sound Radiation from Rolling Tires},
  publisher = {TIRSOC},
  year = {2007},
  journal = {Tire Science and Technology},
  volume = {35},
  number = {3},
  pages = {209--225},
  note = {\url{http://dx.doi.org/10.2346/1.2768608}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Peterson_2007">7</a>]
</td>
<td class="bibtexitem">
J.&nbsp;W. Peterson, G.&nbsp;F. Carey, D.&nbsp;J. Knezevic, and B.&nbsp;T. Murray.
 Adaptive finite element methodology for tumor angiogenesis
  modeling.
 <em>Int.&nbsp;J.&nbsp;Numer.&nbsp;Meth.&nbsp;Eng.</em>, 69(6):1212-1238, 2007.
 <a href="http://dx.doi.org/10.1002/nme.1802">http://dx.doi.org/10.1002/nme.1802</a>.
<a name="Peterson_2007"></a><pre>
@article{Peterson_2007,
  author = {J.~W.~Peterson and G.~F.~Carey and D.~J.~Knezevic and B.~T.~Murray},
  title = {{Adaptive finite element methodology for tumor angiogenesis modeling}},
  journal = {Int.~J.~Numer.~Meth.~Eng.},
  volume = {69},
  number = {6},
  pages = {1212--1238},
  year = {2007},
  note = {\url{http://dx.doi.org/10.1002/nme.1802}}
}
</pre>


</td>
</tr>
</table><h2>2006</h2>

<!-- This document was automatically generated with bibtex2html 1.95
     (see http://www.lri.fr/~filliatr/bibtex2html/),
     with the following command:
     bibtex2html -d -r --nodoc --single -nofooter six.bib  -->


<table>

<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Berrone_2006">1</a>]
</td>
<td class="bibtexitem">
S.&nbsp;Berrone.
 Robust a posteriori error estimates for finite element
  discretizations of the heat equation with discontinuous coefficients.
 <em>Mathematical Modelling and Numerical Analysis (M2AN)</em>,
  40(6):991-1021, November 2006.
 <a href="http://dx.doi.org/10.1051/m2an:2006034">http://dx.doi.org/10.1051/m2an:2006034</a>.
<a name="Berrone_2006"></a><pre>
@article{Berrone_2006,
  author = {S.~Berrone},
  title = {{Robust a posteriori error estimates for finite element
discretizations of the heat equation with discontinuous coefficients}},
  journal = {Mathematical Modelling and Numerical Analysis (M2AN)},
  month = nov,
  year = 2006,
  volume = 40,
  number = 6,
  pages = {991--1021},
  note = {\url{http://dx.doi.org/10.1051/m2an:2006034}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Crookston_2006">2</a>]
</td>
<td class="bibtexitem">
J.&nbsp;J. Crookston, W.&nbsp;Ruijter, A.&nbsp;C. Long, and I.&nbsp;A. Jones.
 Modelling mechanical performance including damage development for
  textile composites using a grid-based finite element method with adaptive
  mesh refinement.
 In <em>Proceedings of the 8th International Conference on Textile
  Composites (TEXCOMP-8)</em>, Nottingham, UK, October&nbsp;16-18, 2006.
 <a href="http://textiles.nottingham.ac.uk/T09-Crookston.pdf">http://textiles.nottingham.ac.uk/T09-Crookston.pdf</a>.
<a name="Crookston_2006"></a><pre>
@inproceedings{Crookston_2006,
  author = {J.~J.~Crookston and W.~Ruijter and A.~C.~Long and I.~A.~Jones},
  title = {Modelling mechanical performance including damage development
                for textile composites using a grid-based finite element method with
                adaptive mesh refinement},
  booktitle = {{Proceedings of the 8th International Conference on
                 Textile Composites (TEXCOMP-8)}},
  month = oct # {~16--18,},
  address = {Nottingham, UK},
  year = {2006},
  note = {\url{http://textiles.nottingham.ac.uk/T09-Crookston.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Knezevic_2006">3</a>]
</td>
<td class="bibtexitem">
D.&nbsp;J. Knezevic.
 Finite element methods for deterministic simulation of polymeric
  fluids.
 Technical Report NA-06/19, Oxford University Computing Laboratory,
  October 2006.
 
  <a href="http://www.maths.warwick.ac.uk/multiscale/MSPreprints/ox-NA-19-06.pdf">http://www.maths.warwick.ac.uk/multiscale/MSPreprints/ox-NA-19-06.pdf</a>.
<a name="Knezevic_2006"></a><pre>
@techreport{Knezevic_2006,
  author = {D.~J.~Knezevic},
  title = {Finite Element Methods for Deterministic Simulation
                  of Polymeric Fluids},
  institution = {Oxford University Computing Laboratory},
  month = oct,
  year = {2006},
  number = {NA-06/19},
  note = {\url{http://www.maths.warwick.ac.uk/multiscale/MSPreprints/ox-NA-19-06.pdf}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Schindler_2006">4</a>]
</td>
<td class="bibtexitem">
M.&nbsp;Schindler, P.&nbsp;Talkner, and P.&nbsp;H&auml;nggi.
 Computing stationary free-surface shapes in microfluidics.
 <em>Physics of Fluids</em>, 18(10):103303, October 2006.
 <a href="http://dx.doi.org/10.1063/1.2361291">http://dx.doi.org/10.1063/1.2361291</a>.
<a name="Schindler_2006"></a><pre>
@article{Schindler_2006,
  author = {{Schindler}, M. and {Talkner}, P. and {H{\"a}nggi}, P.},
  title = {{Computing stationary free-surface shapes in microfluidics}},
  journal = {Physics of Fluids},
  eprint = {arXiv:physics/0511217},
  year = 2006,
  month = oct,
  volume = 18,
  number = 10,
  pages = {103303},
  note = {\url{http://dx.doi.org/10.1063/1.2361291}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Estorff_2006">5</a>]
</td>
<td class="bibtexitem">
O.&nbsp;von Estorff and S.&nbsp;Petersen.
 Vibro-acoustic investigations using finite and infinite elements.
 <em>Proceedings of the Gesellschaft f&uuml;r Angewandte Mathematik
  und Mechanik (GAMM) Annual Meeting 2006 (PAMM)</em>, 6(1):615-616, 2006.
 <a href="http://dx.doi.org/10.1002/pamm.200610288">http://dx.doi.org/10.1002/pamm.200610288</a>.
<a name="Estorff_2006"></a><pre>
@article{Estorff_2006,
  author = {O.~von~Estorff and S.~Petersen},
  title = {{Vibro-acoustic investigations using finite and infinite elements}},
  journal = {{Proceedings of the Gesellschaft f\"{u}r Angewandte Mathematik und Mechanik
              (GAMM) Annual Meeting 2006 (PAMM)}},
  year = 2006,
  volume = 6,
  number = 1,
  pages = {615--616},
  note = {\url{http://dx.doi.org/10.1002/pamm.200610288}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Marichalar_2006">6</a>]
</td>
<td class="bibtexitem">
J.&nbsp;J. Marichalar, W.&nbsp;C. Rochelle, B.&nbsp;S. Kirk, and C.&nbsp;H. Campbell.
 Boundary Layer/Streamline Surface Catalytic Heating Predictions on
  Space Shuttle Orbiter.
 <em>Journal of Spacecraft and Rockets</em>, 43(6):1202-1215, 2006.
 <a href="http://dx.doi.org/10.2514/1.23082">http://dx.doi.org/10.2514/1.23082</a>.
<a name="Marichalar_2006"></a><pre>
@article{Marichalar_2006,
  author = {J.~J.~Marichalar and W.~C.~Rochelle and B.~S.~Kirk and C.~H.~Campbell},
  title = {{Boundary Layer/Streamline Surface Catalytic Heating Predictions on Space Shuttle Orbiter}},
  journal = {Journal of Spacecraft and Rockets},
  year = 2006,
  volume = 43,
  number = 6,
  pages = {1202--1215},
  note = {\url{http://dx.doi.org/10.2514/1.23082}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Petersen_2006">7</a>]
</td>
<td class="bibtexitem">
S.&nbsp;Petersen, D.&nbsp;Dreyer, and O.&nbsp;von Estorff.
 Assessment of finite and spectral element shape functions for
  efficient iterative simulations of interior acoustics.
 <em>Computer Methods in Applied Mechanics and Engineering</em>,
  195(44-47):6463-6478, 2006.
 <a href="http://dx.doi.org/10.1016/j.cma.2006.01.008">http://dx.doi.org/10.1016/j.cma.2006.01.008</a>.
<a name="Petersen_2006"></a><pre>
@article{Petersen_2006,
  author = {Petersen, S. and Dreyer, D. and {von Estorff}, O.},
  title = {Assessment of finite and spectral element shape functions
              for efficient iterative simulations of interior acoustics},
  journal = {Computer Methods in Applied Mechanics and Engineering},
  year = {2006},
  volume = {195},
  number = {44--47},
  pages = {6463--6478},
  note = {\url{http://dx.doi.org/10.1016/j.cma.2006.01.008}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Dreyer_2006">8</a>]
</td>
<td class="bibtexitem">
D.&nbsp;Dreyer, S.&nbsp;Petersen, and O.&nbsp;von Estorff.
 Effectiveness and robustness of improved infinite elements for
  exterior acoustics.
 <em>Computer Methods in Applied Mechanics and Engineering</em>,
  195(29-32):3591-3607, 2006.
 <a href="http://dx.doi.org/10.1016/j.cma.2005.01.019">http://dx.doi.org/10.1016/j.cma.2005.01.019</a>.
<a name="Dreyer_2006"></a><pre>
@article{Dreyer_2006,
  author = {D. Dreyer and S. Petersen and O. von Estorff},
  title = {Effectiveness and robustness of improved infinite elements for exterior acoustics},
  journal = {Computer Methods in Applied Mechanics and Engineering},
  volume = {195},
  number = {29--32},
  pages = {3591--3607},
  year = {2006},
  issn = {0045-7825},
  note = {\url{http://dx.doi.org/10.1016/j.cma.2005.01.019}}
}
</pre>


</td>
</tr>
</table><h2>2005</h2>

<!-- This document was automatically generated with bibtex2html 1.95
     (see http://www.lri.fr/~filliatr/bibtex2html/),
     with the following command:
     bibtex2html -d -r --nodoc --single -nofooter five.bib  -->


<table>

<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Carey_2005">1</a>]
</td>
<td class="bibtexitem">
G.&nbsp;F. Carey, W.&nbsp;Barth, B.&nbsp;S. Kirk, and J.&nbsp;W. Peterson.
 Parallel CFD for Flow and Transport Applications Including
  Unstructured and Adaptive Grids.
 In <em>Proceedings of Parallel CFD 2004: Multidisciplinary
  Applications, G.&nbsp;Winter, A.&nbsp;Ecer, J.&nbsp;Periaux, N.&nbsp;Satofuka and P.&nbsp;Fox (Eds)</em>,
  Amsterdam, The Netherlands, October 2005. Elsevier Science B.V.
 ISBN: 0444520244.
<a name="Carey_2005"></a><pre>
@inproceedings{Carey_2005,
  author = {G.~F.~Carey and W.~Barth and B.~S.~Kirk and J.~W.~Peterson},
  title = {{Parallel CFD for Flow and Transport Applications
              Including Unstructured and Adaptive Grids}},
  booktitle = {Proceedings of Parallel CFD 2004:  Multidisciplinary Applications, G.~Winter,
             A.~Ecer, J.~Periaux, N.~Satofuka and P.~Fox (Eds)},
  publisher = {Elsevier Science B.V.},
  address = {Amsterdam, The Netherlands},
  month = oct,
  year = {2005},
  note = {ISBN: 0444520244}
}
</pre>


</td>
</tr>
</table><h2>2004</h2>

<!-- This document was automatically generated with bibtex2html 1.95
     (see http://www.lri.fr/~filliatr/bibtex2html/),
     with the following command:
     bibtex2html -d -r --nodoc --single -nofooter four.bib  -->


<table>

<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Antiga_2004">1</a>]
</td>
<td class="bibtexitem">
L.&nbsp;Antiga.
 Imaging and numerical fluid dynamics for the study of the
  cardiovascular system.
 In M.&nbsp;Grigioni, editor, <em>III Workshop Bioflumen: Technological
  innovation and evaluation of medical devices for the cardiovascular system</em>,
  pages 55-59, Rome, Italy, November 2004. Istituto Superiore di Sanit&agrave;.
<a name="Antiga_2004"></a><pre>
@inproceedings{Antiga_2004,
  author = {L.~Antiga},
  title = {{Imaging and numerical fluid dynamics for the study of the
                 cardiovascular system}},
  booktitle = {{III Workshop Bioflumen:  Technological innovation and evaluation of medical
                 devices for the cardiovascular system}},
  editor = {M.~Grigioni},
  pages = {55--59},
  publisher = {Istituto Superiore di Sanit\`{a}},
  address = {Rome, Italy},
  month = nov,
  year = {2004}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Carey_2004b">2</a>]
</td>
<td class="bibtexitem">
G.&nbsp;F. Carey, W.&nbsp;Barth, J.&nbsp;A. Woods, B.&nbsp;S. Kirk, M.&nbsp;L. Anderson, S.&nbsp;Chow, and
  W.&nbsp;Bangerth.
 Modeling error and constitutive relations in simulation of flow and
  transport.
 <em>Int. J. Numerical Methods in Fluid</em>, 46(12):1211-1236, 2004.
 <a href="http://dx.doi.org/10.1002/fld.797">http://dx.doi.org/10.1002/fld.797</a>.
<a name="Carey_2004b"></a><pre>
@article{Carey_2004b,
  author = {G.~F.~Carey and W.~Barth and J.~A.~Woods
             and B.~S.~Kirk and M.~L.~Anderson and S.~Chow 
             and W.~Bangerth},
  title = {Modeling error and constitutive relations in simulation
             of flow and transport},
  journal = {Int. J. Numerical Methods in Fluid},
  year = {2004},
  volume = {46},
  number = {12},
  pages = {1211--1236},
  note = {\url{http://dx.doi.org/10.1002/fld.797}}
}
</pre>


</td>
</tr>


<tr valign="top">
<td align="right" class="bibtexnumber">
[<a name="Carey_2004a">3</a>]
</td>
<td class="bibtexitem">
G.&nbsp;F. Carey, M.&nbsp;Anderson, B.&nbsp;Carnes, and B.&nbsp;S. Kirk.
 Some aspects of adaptive grid technology related to boundary and
  interior layers.
 <em>J. Comput. Appl. Math.</em>, 166(1):55-86, 2004.
 <a href="http://dx.doi.org/10.1016/j.cam.2003.09.036">http://dx.doi.org/10.1016/j.cam.2003.09.036</a>.
<a name="Carey_2004a"></a><pre>
@article{Carey_2004a,
  author = {G.~F. Carey and M.~Anderson and B.~Carnes and B.~S.~Kirk},
  title = {Some aspects of adaptive grid technology related to boundary and interior layers},
  journal = {J. Comput. Appl. Math.},
  volume = {166},
  number = {1},
  year = {2004},
  issn = {0377-0427},
  pages = {55--86},
  note = {\url{http://dx.doi.org/10.1016/j.cam.2003.09.036}}
}
</pre>


</td>
</tr>
</table><br>
<br>
<?php make_footer() ?>
</body>
</html>
