#include "osl/direction.h"
#include "osl/directionTraits.h"
#include "osl/boardTable.h"
#include "osl/oslConfig.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>
using namespace osl;

class directionTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE( directionTest );
  CPPUNIT_TEST( testInverse);
  CPPUNIT_TEST( testPrimDir);
  CPPUNIT_TEST( testTraits);
  CPPUNIT_TEST( testTable);
  CPPUNIT_TEST( testShow );
  CPPUNIT_TEST_SUITE_END();
 public:
  void testInverse();
  void testPrimDir();
  void testTraits();
  void testTable();
  void testShow();
};

CPPUNIT_TEST_SUITE_REGISTRATION(directionTest);

void directionTest::testInverse(){
  CPPUNIT_ASSERT_EQUAL(DR,inverse(UL));
  CPPUNIT_ASSERT_EQUAL(D,inverse(U));
  CPPUNIT_ASSERT_EQUAL(DL,inverse(UR));
  CPPUNIT_ASSERT_EQUAL(R,inverse(L));
  CPPUNIT_ASSERT_EQUAL(L,inverse(R));
  CPPUNIT_ASSERT_EQUAL(UR,inverse(DL));
  CPPUNIT_ASSERT_EQUAL(U,inverse(D));
  CPPUNIT_ASSERT_EQUAL(UL,inverse(DR));
}
void directionTest::testPrimDir(){
  CPPUNIT_ASSERT_EQUAL(UL,primDir(UL));
  CPPUNIT_ASSERT_EQUAL(U,primDir(U));
  CPPUNIT_ASSERT_EQUAL(UR,primDir(UR));
  CPPUNIT_ASSERT_EQUAL(L,primDir(L));
  CPPUNIT_ASSERT_EQUAL(L,primDir(R));
  CPPUNIT_ASSERT_EQUAL(UR,primDir(DL));
  CPPUNIT_ASSERT_EQUAL(U,primDir(D));
  CPPUNIT_ASSERT_EQUAL(UL,primDir(DR));
}
  void directionTest::testTraits(){
    CPPUNIT_ASSERT(DirectionTraitsGen<LONG_D>::blackDx==0);
    CPPUNIT_ASSERT(DirectionTraitsGen<LONG_D>::blackDy==1);
    CPPUNIT_ASSERT(DirectionTraits<LONG_D>::blackOffset()==(Offset(0,1)));
    CPPUNIT_ASSERT((DirectionPlayerTraits<LONG_D,BLACK>::offset())==(Offset(0,1)));
    CPPUNIT_ASSERT((DirectionPlayerTraits<LONG_D,BLACK>::offset())!=Offset::ZERO());
    CPPUNIT_ASSERT((DirectionPlayerTraits<UUR,WHITE>::offset())==(Offset(1,2)));
    CPPUNIT_ASSERT((DirectionPlayerTraits<UUR,WHITE>::offset())==Offset::makeDirect(18));
  }

  void directionTest::testTable(){
    CPPUNIT_ASSERT_EQUAL(Board_Table.getShortOffset(Offset32(6,0)),
			 Offset(1,0));
    CPPUNIT_ASSERT(DirectionTraitsGen<LONG_D>::blackDy==1);
    CPPUNIT_ASSERT(DirectionTraits<LONG_D>::blackOffset()==(Offset(0,1)));
    CPPUNIT_ASSERT((DirectionPlayerTraits<LONG_D,BLACK>::offset())==(Offset(0,1)));
    CPPUNIT_ASSERT((DirectionPlayerTraits<LONG_D,BLACK>::offset())!=Offset::ZERO());
    for(int x0=1;x0<=9;x0++)
      for(int y0=1;y0<=9;y0++){
	Square pos0(x0,y0);
	for(int x1=1;x1<=9;x1++)
	  for(int y1=1;y1<=9;y1++){
	    Square pos1(x1,y1);
	    if(x0==x1 && y0==y1) continue;
	    if(x0==x1 || y0==y1 || abs(x0-x1)==abs(y0-y1)){
	      CPPUNIT_ASSERT_EQUAL(longToShort(Board_Table.getLongDirection<BLACK>(pos0,pos1)),
				   Board_Table.getShort8<BLACK>(pos0,pos1));
	    }
	  }
      }
  }

template<int i>
static void showDirect(){
  Direction d=static_cast<Direction>(i);
  std::ostringstream ss;
  ss << i << "," << d << "," << DirectionTraits<static_cast<Direction>(i)>::mask << std::endl;
}
void directionTest::testShow(){
  if (OslConfig::verbose()) {
      showDirect<0>();
      showDirect<1>();
      showDirect<2>();
      showDirect<3>();
      showDirect<4>();
      showDirect<5>();
      showDirect<6>();
      showDirect<7>();
      showDirect<8>();
      showDirect<9>();
      showDirect<10>();
      showDirect<11>();
      showDirect<12>();
      showDirect<13>();
      showDirect<14>();
      showDirect<15>();
      showDirect<16>();
      showDirect<17>();
      for(int dy=-8;dy<=8;dy++){
	for(int dx=-8;dx<=8;dx++){
	  std::ostringstream ss;
	  ss << "LongDirection<BLACK>(" << dx << "," << dy << ")=" << Board_Table.getLongDirection<BLACK>(Offset32(dx,dy)) << std::endl;
	}
      }
    }
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
