/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jsp;

import java.io.File;
import org.apache.tools.ant.taskdefs.optional.jsp.JspMangler;

public class JspNameMangler
implements JspMangler {
    public static String[] keywords = new String[]{"assert", "abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public String mapJspToJavaName(File jspFile) {
        return this.mapJspToBaseName(jspFile) + ".java";
    }

    private String mapJspToBaseName(File jspFile) {
        String className = this.stripExtension(jspFile);
        int i = 0;
        while (i < keywords.length) {
            if (className.equals(keywords[i])) {
                className = className + "%";
                break;
            }
            ++i;
        }
        StringBuffer modifiedClassName = new StringBuffer(className.length());
        char firstChar = className.charAt(0);
        if (Character.isJavaIdentifierStart(firstChar)) {
            modifiedClassName.append(firstChar);
        } else {
            modifiedClassName.append(JspNameMangler.mangleChar(firstChar));
        }
        int i2 = 1;
        while (i2 < className.length()) {
            char subChar = className.charAt(i2);
            if (Character.isJavaIdentifierPart(subChar)) {
                modifiedClassName.append(subChar);
            } else {
                modifiedClassName.append(JspNameMangler.mangleChar(subChar));
            }
            ++i2;
        }
        return modifiedClassName.toString();
    }

    private String stripExtension(File jspFile) {
        String filename = jspFile.getName();
        String className = filename.endsWith(".jsp") ? filename.substring(0, filename.length() - 4) : filename;
        return className;
    }

    private static final String mangleChar(char ch) {
        if (ch == File.separatorChar) {
            ch = (char)47;
        }
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        int i = 1;
        while (i <= nzeros) {
            result[i] = 48;
            ++i;
        }
        int resultIndex = 0;
        int i2 = nzeros + 1;
        while (i2 < 6) {
            result[i2] = s.charAt(resultIndex++);
            ++i2;
        }
        return new String(result);
    }

    public String mapPath(String path) {
        return null;
    }
}

