/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme.sender;

import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;
import mediathek.io.GetUrl;

/**
 * 
 * @author
 */
public class MediathekMdr extends MediathekReader implements Runnable {

    private String addr = "http://www.mdr.de/mediathek/fernsehen/a-z/5841479.html";

    /**
     * 
     * @param ddaten
     */
    public MediathekMdr(Daten ddaten) {
        super(ddaten);
        sender = Konstanten.SENDER_MDR;
        text = "MDR  (ca. 3 MB, 1000 Filme)";
    }

    /**
     * 
     */
    @Override
    public void addToList() {
        final String MUSTER = "<a href=\"/mediathek/fernsehen/a-z/5841479-";
        final String MUSTER_ADD = "http://www.mdr.de/mediathek/fernsehen/a-z/5841479-";
        StringBuffer seite = new StringBuffer();
        listeThemen.clear();
        seite = getUrlIo.getUri_Utf(sender, addr, seite, "");
        int pos = 0;
        int pos1 = 0;
        int pos2 = 0;
        String url = "";
        while ((pos = seite.indexOf(MUSTER, pos)) != -1) {
            pos += MUSTER.length();
            pos1 = pos;
            pos2 = seite.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1) {
                url = seite.substring(pos1, pos2);
            }
            if (url.equals("")) {
                daten.fehler.fehlerMeldung("Fehler!", "MediathekMdr.addToList: keine URL");
            } else {
                url = MUSTER_ADD + url;
                if (!istInListe(listeThemen, url, 0)) {
                    listeThemen.add(new String[]{url});
                }
            }
        }
        if (!stop) {
            if (listeThemen.size() > 0) {
                notifyStart(listeThemen.size());
                Funktionen.listeSort(listeThemen, 0);
                for (int t = 0; t < Konstanten.MAX_THREAD_LADEN_FILME_KLEIN; ++t) {
                    new Thread(new MdrThemaLaden()).start();
                }
            }
        }
    }

    private class MdrThemaLaden implements Runnable {

        GetUrl getUrl = new GetUrl(daten, -1, Konstanten.WARTEN_BASIS_URL_LANG);
        private StringBuffer seite1 = new StringBuffer();
        private StringBuffer seite2 = new StringBuffer();
        private StringBuffer seite3 = new StringBuffer();

        @Override
        public void run() {
            addThread();
            String[] link;
            while (!stop && (link = getListeThemen()) != null) {
                notifyProgress(link[0]);
                addThema(link[0]);
            }
            threadUndFertig();
        }

        void addThema(String strUrlFeed) {
            //<h2><a href="/mediathek/fernsehen/a-z/6946914.html" class="pfeil">artour<span class="otype"> | Videos</span></a></h2>
            final String MUSTER_TITEL = "class=\"pfeil\">";
            final String MUSTER_URL = "<h2><a href=\"/mediathek/fernsehen/a-z/";
            final String MUSTER_ADD = "http://www.mdr.de/mediathek/fernsehen/a-z/";
            int pos = 0;
            int pos2 = 0;
            String thema = "";
            String url = "";
            try {
                seite1 = getUrl.getUri_Utf(sender, strUrlFeed, seite1, "");
                while ((pos = seite1.indexOf(MUSTER_URL, pos)) != -1) {
                    url = "";
                    pos += MUSTER_URL.length();
                    pos2 = seite1.indexOf("\"", pos);
                    if (pos != -1 && pos2 != -1) {
                        url = seite1.substring(pos, pos2);
                        pos = pos2;
                        if ((pos = seite1.indexOf(MUSTER_TITEL, pos)) != -1) {
                            pos += MUSTER_TITEL.length();
                            pos2 = seite1.indexOf("<", pos);
                            if (pos != -1 && pos2 != -1) {
                                thema = seite1.substring(pos, pos2);
                                pos = pos2;
                                if (nurAboLaden()) {
                                    //nur Abos laden
                                    if (!daten.listeAbo.aboExists(sender, thema)) {
                                        continue;
                                    }
                                }
                            }
                            if (url.equals("")) {
                                daten.fehler.systemMeldung("MediathekMdr.addThema: keine URL: " + strUrlFeed);
                            } else {
                                addSendug(strUrlFeed, thema, MUSTER_ADD + url);
                            }
                        }
                    }
                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "MediathekZdf.addToList");
            }
        }

        private void addSendug(String strUrlFeed, String thema, String urlThema) {
            final String MUSTER = "<li><a href=\"http://www.mdr.de/Media/stream/";
            final String MUSTER_ADD = "http://www.mdr.de/Media/stream/";
            seite2 = getUrl.getUri_Utf(sender, urlThema, seite2, "Thema: " + thema);
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            String url = "";
            while ((pos = seite2.indexOf(MUSTER, pos)) != -1) {
                pos += MUSTER.length();
                pos1 = pos;
                pos2 = seite2.indexOf("\"", pos);
                if (pos1 != -1 && pos2 != -1) {
                    url = seite2.substring(pos1, pos2);
                }
                if (url.equals("")) {
                     daten.fehler.fehlerMeldung("Fehler!", "MediathekMdr.addSendug: keine URL: " + urlThema);
                    daten.fehler.fehlerMeldung("Fehler!", "Thema: " + thema + " UrlFeed" + strUrlFeed);
                } else {
                    url = MUSTER_ADD + url;
                    addFilme(strUrlFeed, thema, url);
                }
            }
        }

        void addFilme(String strUrlFeed, String thema, String urlFilm) {
            //<ENTRY>
            //<TITLE>L�nderzeit</TITLE>
            //<AUTHOR>L�nderzeit</AUTHOR>
            //<COPYRIGHT>(c) 2009 MITTELDEUTSCHER RUNDFUNK</COPYRIGHT>
            //<REF HREF = "mms://c22033-o.w.core.cdn.streamfarm.net/22033mdr/ondemand/3087mdr/MDR_vgnwsm/FCMS-7bb7741c-2ad1-4649-bd49-f31a336600ae.wmv" />
            //</ENTRY>

            final String MUSTER_ITEM_1 = "<ENTRY>";
            final String MUSTER_TITEL_1 = "<TITLE>";
            final String MUSTER_TITEL_2 = "</TITLE>";
            final String MUSTER_URL_1 = "<REF HREF = \"";
            final String MUSTER_URL_2 = "\"";
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            String titel = "";
            String url = "";
            try {
                seite3 = getUrl.getUri_Iso(sender, urlFilm, seite3, "Thema: " + thema);
                while ((pos = seite3.indexOf(MUSTER_ITEM_1, pos)) != -1) {
                    url = "";
                    pos += MUSTER_ITEM_1.length();
                    pos1 = seite3.indexOf(MUSTER_TITEL_1, pos);
                    pos2 = seite3.indexOf(MUSTER_TITEL_2, pos);
                    if (pos1 != -1 && pos2 != -1) {
                        titel = seite3.substring(pos1 + MUSTER_TITEL_1.length(), pos2);
                        pos = pos2;
                    }
                    pos1 = seite3.indexOf(MUSTER_URL_1, pos);
                    if (pos1 != -1) {
                        pos1 += MUSTER_URL_1.length();
                        pos2 = seite3.indexOf(MUSTER_URL_2, pos1);
                        if (pos2 != -1) {
                            url = seite3.substring(pos1, pos2);
                            pos = pos2; //erst den zweiten Eintrag nehmen
                        }
                        if (url.equals("")) {
                            daten.fehler.systemMeldung("MediathekMdr.addFilme: keine URL: urlFilm");
                           daten.fehler.fehlerMeldung("Fehler!", "Thema: " + thema + " UrlFeed" + strUrlFeed);
                        } else {
                            //DatenFilm(Daten ddaten, String ssender, String tthema, String urlThema, String ttitel, String uurl, String uurlorg, String zziel) {
                            daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(new DatenFilm(daten, sender, thema, strUrlFeed, titel,
                                    url,  ""/*datum*/, ""/*zeit*/));
                        }
                    }
                }
            } catch (Exception ex) {
                 daten.fehler.fehlerMeldung(ex, "MediathekZdf.addFilme");
            }
        }
    }
}
