/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.gui;

import java.awt.Point;
import mediathek.gui.dialoge.DialogEditAbo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.daten.Daten;
import mediathek.Funktionen;
import mediathek.HinweisKeineAuswahl;
import mediathek.Konstanten;
import mediathek.io.starter.Starts;
import mediathek.TModel;
import mediathek.beobachter.BeobachterTableSelect;
import mediathek.beobachter.DownloadCellRenderer;
import mediathek.beobachter.DownloadCellRendererAbo;
import mediathek.daten.DatenAbo;
import mediathek.filme.DatenFilm;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenProg;
import mediathek.gui.dialoge.DialogExportAbos;
import mediathek.gui.dialoge.DialogPgruppen;
import mediathek.io.starter.StartEvent;
import mediathek.io.starter.StartListener;

public class GuiAbo extends PanelVorlage {

    public TModel tModel1;
    public TModel tModel2;
    private BeobachterTableSelect beobachterTableSelect;

    public GuiAbo(Daten d) {
        super(d);
        initComponents();
        initBeobachter();
        tabelle2Laden(); // wegen des Datums
        tabelle1Laden();
    }
    //===================================
    //public
    //===================================

    @Override
    public void neuLaden() {
    }

    public void einstellungen() {
        new DialogPgruppen(null, true, daten, false).setVisible(true);
        load();
    }
    //===================================
    //private
    //===================================

    private void initBeobachter() {
//        jButtonAboLoeschen.addActionListener(new BeobachterAboLoeschen());
//        jButtonAboAendern.addActionListener(new BeobachterAboAendern());
        jButtonDownloadStarten.addActionListener(new BeobachterDownloadAbos());
        jButtonDownloadLoeschen.addActionListener(new BeobDownloadLoeschen(false));
        jButtonDownloadsNeuLaden.addActionListener(new BeobachterNeuLaden());
        jButtonDauerhaft.addActionListener(new BeobDownloadLoeschen(true));
        jButtonAufraeumen.addActionListener(new BeobachterAufraeumen());
        beobachterTableSelect = new BeobachterTableSelect(daten, jTable1);
        jTable1.addMouseListener(new BeobMausTabelle1(jTable1));
        jTable1.getSelectionModel().addListSelectionListener(beobachterTableSelect);
        jTable2.addMouseListener(new BeobMausTabelle2(jTable2));
        //film starten
        ActionMap am = jTable2.getActionMap();
        am.put("film_starten", new BeobAbstractAction());
        InputMap im = jTable2.getInputMap();
        KeyStroke enter = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);
        im.put(enter, "film_starten");
        //
        daten.starterClass.addListener(new BeobachterStart());
    }

    private synchronized void tabelle1Laden() {
        //Tabelle1-Abbos
        jTable1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        tModel1 = new TModel(daten.listeAbo.getObjectData(), Konstanten.ABO_COLUMN_NAMES);
        jTable1.setModel(tModel1);
        jTable1.setDefaultRenderer(Object.class, new DownloadCellRendererAbo(daten));
        jTable1.getColumnModel().getColumn(Konstanten.ABO_NR_NR).setPreferredWidth(50);
        jTable1.getColumnModel().getColumn(Konstanten.ABO_NR_NR).setMaxWidth(1000);
    }

    private synchronized void tabelle2Laden() {
        jTable2.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        jTable2.setModel(new javax.swing.table.DefaultTableModel(
                new Object[][]{},
                new String[]{}));
        tModel2 = daten.filmeLaden.listeFilme.getAboModel();
        jTable2.setModel(tModel2);
        jTable2.setDefaultRenderer(Object.class, new DownloadCellRenderer(daten, true /*starts*/, true /*Abo*/));
        //Spalten ausblenden
        Funktionen.spaltenFilmSetzen(jTable2, daten, false, true /*ziel*/, true /*prog*/);
    }

    private void load() {
        //Tabelle2-Abbos
        super.getSpalten(jTable2);
        tabelle2Laden();
        super.setSpalten(jTable2);
        //Tabelle1-Abbos - wegen des Datums
        super.getSpalten(jTable1);
        tabelle1Laden();
        super.setSpalten(jTable1);
    }

    private void aboAendern() {
        int row = jTable1.getSelectedRow();
        if (row >= 0) {
            int delRow = jTable1.convertRowIndexToModel(row);
            DatenAbo akt = daten.listeAbo.getAboNr(delRow);
            DatenAbo ret = akt.getCopy();
            DialogEditAbo dialog = new DialogEditAbo(null, true, daten, ret);
            dialog.setVisible(true);
            if (dialog.ok) {
                akt.aufMichKopieren(ret);
                load();
            }
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void aboLoeschen() {
        int rows[] = jTable1.getSelectedRows();
        if (rows.length > 0) {
            for (int i = rows.length - 1; i >= 0; --i) {
                int delRow = jTable1.convertRowIndexToModel(rows[i]);
                daten.listeAbo.remove(delRow);
            }
            daten.setGeaendert();
            load();
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void downloadLoeschen(boolean dauerhaft) {
        int rows[] = jTable2.getSelectedRows();
        if (rows.length > 0) {
            for (int i = rows.length - 1; i >= 0; --i) {
                int delRow = jTable2.convertRowIndexToModel(rows[i]);
                if (dauerhaft) {
                    DatenAbo abo = daten.listeAbo.getEinmalAbo(tModel2.getValueAt(delRow, Konstanten.FILM_URL_NR).toString());
                    if (abo != null) {
                        // dann einmalAbo
                        abo.arr[Konstanten.ABO_EINMAL_ERLEDIGT_NR] = Boolean.toString(true);
                        daten.fehler.systemMeldung("StarterClass.einmalErledigen Abo: " + abo.arr[Konstanten.ABO_NAME_NR]);
                    } else {
                        daten.log.zeileSchreiben(tModel2.getValueAt(delRow, Konstanten.FILM_TITEL_NR).toString(), tModel2.getValueAt(delRow, Konstanten.FILM_URL_NR).toString(), Konstanten.LOG_DATEI_ZDF);
                    }
                }
                daten.starterClass.filmLoeschen(tModel2.getValueAt(delRow, Konstanten.FILM_URL_NR).toString());
                tModel2.removeRow(delRow);
            }
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void filmStartenWiederholen() {
        // ein Film der noch keinen Starts hat wird gestartet
        // ein Film dessen Starts schon auf fertig/fehler steht wird wieder gestartet
        int row = jTable2.getSelectedRow();
        if (row >= 0) {
            int delRow = jTable2.convertRowIndexToModel(row);
            Starts s = daten.starterClass.getStart(tModel2.getValueAt(delRow, Konstanten.FILM_URL_NR).toString());
            if (s != null) {
                if (s.status > Starts.STATUS_RUN) {
                    daten.starterClass.delStart(tModel2.getValueAt(delRow, Konstanten.FILM_URL_NR).toString());
                }
            }
            downloadAll(daten, tModel2, tModel2.getValueAt(delRow, Konstanten.FILM_URL_NR).toString());
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void aufraeumen() {
        for (int i = 0; i < tModel2.getRowCount(); ++i) {
            int s = daten.starterClass.getState(tModel2.getValueAt(i, Konstanten.FILM_URL_NR).toString());
            if (s >= Starts.STATUS_FERTIG) {
                tModel2.removeRow(i);
                --i;
            }
        }
        daten.starterClass.aufraeumen(Starts.QUELLE_ABO);
//        load();
    }

    private void export() {
        OutputStreamWriter writer = null;
        DialogExportAbos dialog = new DialogExportAbos(null, true, daten, daten.system[Konstanten.SYSTEM_PFAD_EXPORT_ABOS_NR]);
        dialog.setVisible(true);
        if (dialog.ok) {
            File f = new File(dialog.ziel);
            if (!f.exists()
                    || JOptionPane.showConfirmDialog(null, "Trotzdem anlegen und \u00fcberschreiben?",
                    "Datei existiert bereits!", JOptionPane.YES_NO_OPTION) == JOptionPane.OK_OPTION) {
                try {
                    daten.system[Konstanten.SYSTEM_PFAD_EXPORT_ABOS_NR] = dialog.ziel;
                    writer = new OutputStreamWriter(new FileOutputStream(f));
                    for (int i = 0; i < tModel2.getRowCount(); ++i) {
                        writer.write(tModel2.getValueAt(i, Konstanten.FILM_URL_NR).toString() + "\n");
                    }
                } catch (Exception ex) {
                    daten.fehler.fehlerMeldung(ex, "GuiAbo.zeileSchreiben");
                } finally {
                    try {
                        writer.close();
                    } catch (Exception ex) {
                        daten.fehler.fehlerMeldung(ex, "GuiAbo.zeileSchreiben");
                    }
                }
            }
        }
    }

    private void downloadAbos() {
        downloadAll(daten, tModel2, "");
    }

    public static boolean downloadAll(Daten daten, TModel tMod, String uurl) {
        // liefert false, wenn es nicht zu Laden gibt
        boolean ret = false;
        String befehlsString = "";
        String url = "";
        String zielPfad = "";
        String zielDateiname = "";
        int art = -1;
        DatenFilm datenFilm;
        if (daten.listePgruppeAbo.size() == 0) {
            JOptionPane.showMessageDialog(null, "Bitte ein Programm zum Downloaden einrichten.",
                    "Kein Programm eingerichtet!", JOptionPane.INFORMATION_MESSAGE);
        } else {
            if (tMod != null) {
                LinkedList<Starts> startsListe = new LinkedList<Starts>();
                for (int i = 0; i < tMod.getRowCount(); ++i) {
                    url = (tMod.getValueAt(i, Konstanten.FILM_URL_NR).toString());
                    if (uurl.equals("") || uurl.equals(url)) {
                        zielPfad = (tMod.getValueAt(i, Konstanten.FILM_ZIEL_PFAD_NR).toString());
                        //erst das Abo suchen
                        DatenAbo abo = daten.listeAbo.getAbo(tMod.getValueAt(i, Konstanten.FILM_SENDER_NR).toString(),
                                tMod.getValueAt(i, Konstanten.FILM_THEMA_NR).toString(),
                                tMod.getValueAt(i, Konstanten.FILM_TITEL_NR).toString(),
                                tMod.getValueAt(i, Konstanten.FILM_URL_NR).toString());
                        //dann die passende Programmgruppe
                        DatenPgruppe gruppe = daten.listePgruppeAbo.getName(abo.arr[Konstanten.ABO_PGRUPPE_NR]);
                        //mit der Url das passende Programm aus der Pgruppe finden
                        DatenProg prog = gruppe.getProgUrl(url);
                        befehlsString = prog.getBegehl();
                        zielDateiname = gruppe.getZielDateiname();
                        zielPfad = gruppe.getZielPfad();
                        zielPfad = abo.aboPfadAnhaengen(daten, zielPfad);
                        art = gruppe.checkDownloadDirekt(daten, url); //2: zdf, 3: direkt
                        //prog
                        if (prog.arr[Konstanten.PROGRAMM_SCHALTER_NR].contains("**")) {
                            datenFilm = daten.filmeLaden.listeFilme.getFilmByUrl(url);
                            zielDateiname = datenFilm.dateiNamenBauen(zielPfad, zielDateiname);
                            befehlsString = Funktionen.getBefhelsString(befehlsString, zielDateiname, url, datenFilm);
                            //Start erstellen und zur Liste hinzufügen
                            startsListe.add(new Starts(Starts.QUELLE_ABO, datenFilm, art, befehlsString, Boolean.parseBoolean(prog.arr[Konstanten.PROGRAMM_RESTART_NR])));
                            ret = true;
                        } else {
                            daten.fehler.fehlerMeldung("Fehler",
                                    new String[]{"Die Einstellungen zum Download der Abos sind Fehlerhaft",
                                        "es fehlen die Angaben zum Dateinamen in zB.: *%n*"});
                        }
                    }
                }
                daten.starterClass.addListe(startsListe);
            }
        }
        return ret;
    }

    private void panelUpdate() {
        jTable2.repaint();
        this.validate();
    }

    private void open(int open) {
        DatenFilm ersterFilm = new DatenFilm(daten);
        int select = jTable2.convertRowIndexToModel(jTable2.getSelectedRow());
        for (int i = 0; i < Konstanten.FILME_MAX_ELEM; ++i) {
            ersterFilm.arr[i] = tModel2.getValueAt(select, i).toString();
        }
        daten.starterClass.urlStarten(ersterFilm.arr[Konstanten.FILM_URL_NR], open, ersterFilm);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jButtonDownloadsNeuLaden = new javax.swing.JButton();
        jButtonDownloadStarten = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jSplitPane2 = new javax.swing.JSplitPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable2 = new javax.swing.JTable();
        jButtonDownloadLoeschen = new javax.swing.JButton();
        jButtonDauerhaft = new javax.swing.JButton();
        jButtonAufraeumen = new javax.swing.JButton();

        jLabel1.setText("jLabel1");

        jPanel2.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jButtonDownloadsNeuLaden.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/view-refresh.png"))); // NOI18N
        jButtonDownloadsNeuLaden.setText("Downloads aktualisieren");
        jButtonDownloadsNeuLaden.setToolTipText("Liste der anstehenden Downloads neu aufbauen");

        jButtonDownloadStarten.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/go-next.png"))); // NOI18N
        jButtonDownloadStarten.setText("alle Downloads starten");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jButtonDownloadsNeuLaden)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButtonDownloadStarten)
                .addContainerGap(347, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonDownloadsNeuLaden)
                    .addComponent(jButtonDownloadStarten))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonDownloadStarten, jButtonDownloadsNeuLaden});

        jPanel3.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jSplitPane2.setDividerLocation(150);
        jSplitPane2.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jTable1.setAutoCreateRowSorter(true);
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        jScrollPane1.setViewportView(jTable1);

        jSplitPane2.setTopComponent(jScrollPane1);

        jTable2.setAutoCreateRowSorter(true);
        jTable2.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        jTable2.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        jScrollPane2.setViewportView(jTable2);

        jSplitPane2.setRightComponent(jScrollPane2);

        jButtonDownloadLoeschen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/edit-cut.png"))); // NOI18N
        jButtonDownloadLoeschen.setText("Download löschen");
        jButtonDownloadLoeschen.setToolTipText("markierten Download aus der Liste entfernen (beim nächsten Laden wieder anzeigen)");

        jButtonDauerhaft.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/user-trash.png"))); // NOI18N
        jButtonDauerhaft.setText("Download dauerhaft löschen");
        jButtonDauerhaft.setToolTipText("markierten Download endgültig aus der Liste löschen");

        jButtonAufraeumen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mediathek/res/edit-clear.png"))); // NOI18N
        jButtonAufraeumen.setText("Tabelle aufräumen");
        jButtonAufraeumen.setToolTipText("abgeschlossene Downloads entfernen");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSplitPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 810, Short.MAX_VALUE)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(jButtonDownloadLoeschen)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonDauerhaft)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonAufraeumen)))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSplitPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 328, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonDownloadLoeschen)
                    .addComponent(jButtonDauerhaft)
                    .addComponent(jButtonAufraeumen))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel3, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAufraeumen;
    private javax.swing.JButton jButtonDauerhaft;
    private javax.swing.JButton jButtonDownloadLoeschen;
    private javax.swing.JButton jButtonDownloadStarten;
    private javax.swing.JButton jButtonDownloadsNeuLaden;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSplitPane jSplitPane2;
    private javax.swing.JTable jTable1;
    private javax.swing.JTable jTable2;
    // End of variables declaration//GEN-END:variables

    private class BeobachterAboLoeschen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            aboLoeschen();
        }
    }

    private class BeobachterAboAendern implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            aboAendern();
        }
    }

    private class BeobDownloadLoeschen implements ActionListener {

        boolean dauerhaft = false;

        public BeobDownloadLoeschen(boolean d) {
            dauerhaft = d;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            downloadLoeschen(dauerhaft);
        }
    }

    private class BeobFilmStartenWiederholen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            filmStartenWiederholen();
        }
    }

    private class BeobachterDownloadAbos implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            downloadAbos();
        }
    }

    private class BeobachterNeuLaden implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            //erst Logliste zdf löschen
            daten.log.clearLogList(Konstanten.LOG_DATEI_ZDF);
            daten.listeAbo.erledigteEinmalAboLoeschen();
            aufraeumen();
            load();
        }
    }

    private class BeobachterExport implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            export();
        }
    }

    private class BeobachterAufraeumen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent arg0) {
            aufraeumen();
        }
    }

    private class BeobachterStart implements StartListener {

        @Override
        public void starter(StartEvent ev) {
            panelUpdate();
            if (ev.allesStop()) {
            }
        }
    }

    public class BeobMausTabelle1 extends MouseAdapter {

        private Point p;
        private JTable tabelle;

        public BeobMausTabelle1(JTable ttabelle) {
            tabelle = ttabelle;
        }

        /**
         *
         * @param arg0
         */
        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == MouseEvent.BUTTON1) {
                if (arg0.getClickCount() > 1) {
                    aboAendern();
                }
            } else if (arg0.getButton() == MouseEvent.BUTTON3) {
                showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            p = evt.getPoint();
            int nr = tabelle.rowAtPoint(p);
            if (nr >= 0) {
                tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu menu = new JPopupMenu();
            //Abo lösschen
            JMenuItem itemLoeschen = new JMenuItem("Abo löschen");
            itemLoeschen.addActionListener(new BeobachterAboLoeschen());
            menu.add(itemLoeschen);
            //Abo ändern
            JMenuItem itemAendern = new JMenuItem("Abo ändern");
            itemAendern.addActionListener(new BeobachterAboAendern());
            menu.add(itemAendern);
            //Menü anzeigen
            menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public class BeobMausTabelle2 extends MouseAdapter {

        private BeobUrl beobUrl = new BeobUrl();
        private Point p;
        private JTable tabelle;

        public BeobMausTabelle2(JTable ttabelle) {
            tabelle = ttabelle;
        }

        private class BeobUrl implements ActionListener {

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = tabelle.rowAtPoint(p);
                if (nr >= 0) {
                    Funktionen.copyToClipboard(
                            tabelle.getModel().getValueAt(tabelle.convertRowIndexToModel(nr),
                            Konstanten.FILM_URL_NR).toString());
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == MouseEvent.BUTTON1) {
                if (arg0.getClickCount() > 1) {
                    int nr = daten.listePgruppeButton.getDoppelklick();
                    if (nr >= 0) {
                        open(nr);
                    } else {
                        JOptionPane.showMessageDialog(null, "unter \"Pfade\" einen Standardbutton festlegen.",
                                "keine Standardbutton!", JOptionPane.INFORMATION_MESSAGE);
                    }
                }
            } else if (arg0.getButton() == MouseEvent.BUTTON3) {
                showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            p = evt.getPoint();
            int nr = tabelle.rowAtPoint(p);
            if (nr >= 0) {
                tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu menu = new JPopupMenu();
            //Film vorzehen
            int row = jTable2.getSelectedRow();
            boolean anzeigen = true;
            if (row >= 0) {
                int delRow = jTable2.convertRowIndexToModel(row);
                Starts s = daten.starterClass.getStart(tModel2.getValueAt(delRow, Konstanten.FILM_URL_NR).toString());
                if (s != null) {
                    if (s.status <= Starts.STATUS_RUN) {
                        anzeigen = false;
                    }
                }
            }
            JMenuItem itemVorziehen = new JMenuItem("Film starten");
            menu.add(itemVorziehen);
            if (anzeigen) {
                itemVorziehen.addActionListener(new BeobFilmStartenWiederholen());
            } else {
                itemVorziehen.setEnabled(false);
            }
            //url
            JMenuItem itemVor = new JMenuItem("URL kopieren");
            itemVor.addActionListener(beobUrl);
            menu.add(itemVor);
            //##Trenner##
            menu.addSeparator();
            //löschen
            JMenuItem itemLoeschen = new JMenuItem("Download löschen");
            itemLoeschen.addActionListener(new BeobDownloadLoeschen(false));
            menu.add(itemLoeschen);
            //dauerhaft löschen
            JMenuItem itemDauerhaftLoeschen = new JMenuItem("Download dauerhaft löschen");
            itemDauerhaftLoeschen.addActionListener(new BeobDownloadLoeschen(true));
            menu.add(itemDauerhaftLoeschen);
            //##Trenner##
            menu.addSeparator();
            //löschen
            JMenuItem itemExport = new JMenuItem("Links in Datei exportieren");
            itemExport.addActionListener(new BeobachterExport());
            menu.add(itemExport);
            //Menü anzeigen
            menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private class BeobAbstractAction extends AbstractAction {

        @Override
        public void actionPerformed(ActionEvent e) {
            int nr = daten.listePgruppeButton.getDoppelklick();
            if (nr >= 0) {
                open(nr);
            } else {
                JOptionPane.showMessageDialog(null, "unter \"Pfade\" einen Standardbutton festlegen.",
                        "keine Standardbutton!", JOptionPane.INFORMATION_MESSAGE);
            }
        }
    }
}
