/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.gui.dialoge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mediathek.Funktionen;
import mediathek.HinweisKeineAuswahl;
import mediathek.Konstanten;
import mediathek.TModel;
import mediathek.daten.Daten;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenProg;
import mediathek.daten.ListePgruppe;
import mediathek.gui.GuiFilme;

public class DialogPgruppen extends javax.swing.JDialog {

    private Daten daten;
    public boolean ok = false;
    private TModel tModel;
    private ListePgruppe listePgruppe;
    private boolean stopBeob = false;
    private boolean button;
    private GuiFilme guiFilme = null;

    public DialogPgruppen(java.awt.Frame parent, boolean modal, Daten d, boolean bbutton, GuiFilme gguiFilme) {
        super(parent, modal);
        initComponents();
        guiFilme = gguiFilme;
        daten = d;
        button = bbutton;
        starten();
        this.pack();
    }

    public DialogPgruppen(java.awt.Frame parent, boolean modal, Daten d, boolean bbutton) {
        super(parent, modal);
        initComponents();
        daten = d;
        button = bbutton;
        starten();
        this.pack();
    }

    private void starten() {
        //Programme
        BeobProgDoc beobDoc = new BeobProgDoc();
        jTable1.getSelectionModel().addListSelectionListener(new BeobTableSelect());
        jTextFieldProgPfad.getDocument().addDocumentListener(beobDoc);
        jTextFieldProgSchalter.getDocument().addDocumentListener(beobDoc);
        jTextFieldProgName.getDocument().addDocumentListener(beobDoc);
        jTextFieldProgPraefix.getDocument().addDocumentListener(beobDoc);
        jTextFieldProgSuffix.getDocument().addDocumentListener(beobDoc);
        jTextFieldProgPfad.setEnabled(false);
        jTextFieldProgSchalter.setEnabled(false);
        jTextFieldProgName.setEnabled(false);
        jTextFieldProgPraefix.setEnabled(false);
        jTextFieldProgSuffix.setEnabled(false);
        jButtonProgPfad.addActionListener(new BeobDateiDialogProg());
        jButtonProgPlus.addActionListener(new BeobProgNeueZeile());
        jButtonProgMinus.addActionListener(new BeobProgLoeschen());
        jButtonProgDuplizieren.addActionListener(new BeobProgDuplizieren());
        jButtonProgAuf.addActionListener(new BeobProgAufAb(true));
        jButtonProgAb.addActionListener(new BeobProgAufAb(false));
        jButtonProgPfad.setEnabled(false);
        jButtonProgVorlageHinzufuegen.addActionListener(new BeobVorlageProgHinzufuegen());
        jComboBoxProgVorlagen.setModel(new DefaultComboBoxModel(daten.listeProgVorlagen.getObjectDataCombo()));
        jCheckBoxRestart.addActionListener(new BeobProgAction());
        //Pgruppe
        jList1.addListSelectionListener(new BeobSelectGruppe());
        jList1.setCellRenderer(new ComboBoxRenderer());
        jList1.addMouseListener(new BeobMaus());
        jButtonGruppeNeu.addActionListener(new BeobGruppeNeu());
        jButtonGruppeLoeschen.addActionListener(new BeobGruppeLoeschen());
        jButtonGruppeFarbe.addActionListener(new BeobachterFarbe());
        jButtonGruppeStandardfarbe.addActionListener(new BeobStandardfarbe());
        jButtonGruppeAuf.addActionListener(new BeobGruppeAufAb(true));
        jButtonGruppeAb.addActionListener(new BeobGruppeAufAb(false));
        jButtonGruppeDuplizieren.addActionListener(new BeobGruppeDuplizieren());
        jButtonGruppeDoppelklick.addActionListener(new BeobGruppeDoppelklick());
        jButtonGruppePfad.addActionListener(new BeobDateiDialogPfad());
        jTextFieldGruppeName.getDocument().addDocumentListener(new BeobGruppenDoc(jTextFieldGruppeName, Konstanten.PROGRAMMGRUPPE_NAME_NR));
        jTextFieldGruppeDirektSuffix.getDocument().addDocumentListener(
            new BeobGruppenDoc(jTextFieldGruppeDirektSuffix, Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR));
        jTextFieldGruppeDirektPraefix.getDocument().addDocumentListener(
            new BeobGruppenDoc(jTextFieldGruppeDirektPraefix, Konstanten.PROGRAMMGRUPPE_PRAEFIX_DIREKT_NR));
        jTextFieldGruppeZielName.getDocument().addDocumentListener(new BeobGruppenDoc(jTextFieldGruppeZielName,
                                                                                      Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR));
        jTextFieldGruppeZielPfad.getDocument().addDocumentListener(
            new BeobGruppenDoc(jTextFieldGruppeZielPfad, Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR));
        //rest
        jButtonHilfe.addActionListener(new BeobHilfeTabelle());
        jButtonOk.addActionListener(new BeobOk());
        jButtonPruefen.addActionListener(new BeobPuefen());
        if (button) {
            this.setTitle("Einstellungen Programme Button");
            jLabelTitel.setText("Button anlegen");
            listePgruppe = daten.listePgruppeButton;
        } else {
            this.setTitle("Einstellungen Programme Abo");
            jLabelTitel.setText("Abo einrichten");
            listePgruppe = daten.listePgruppeAbo;
        }
        init();
        this.pack();
    }

    private void init() {
        if (listePgruppe.size() > 0) {
            fillList(0);
        } else {
            fillList();
        }
    }

    private void fillList() {
        fillList(-1);
    }

    private void fillList(int count) {
        stopBeob = true;
        int sel = jList1.getSelectedIndex();
        jList1.setModel(new javax.swing.DefaultComboBoxModel(listePgruppe.getObjectDataCombo()));
        if (count < 0) {
            jList1.setSelectedIndex(sel);
        } else {
            jList1.setSelectedIndex(count);
            jList1.setSelectionInterval(count, count);
        }
        stopBeob = false;
        fillTable();
        guiFilmeAendern();
    }

    private void guiFilmeAendern() {
        if (guiFilme != null) {
            guiFilme.bildProgs();
        }
    }

    private void fillTable() {
        //Tabelle mit den Programmen füllen
        DatenPgruppe pgruppe = getPgruppe();
        stopBeob = true;
        jTextFieldGruppeName.setEnabled(pgruppe != null);
        jTextFieldGruppeDirektSuffix.setEnabled(pgruppe != null);
        jTextFieldGruppeDirektPraefix.setEnabled(pgruppe != null);
        jTextFieldGruppeZielName.setEnabled(pgruppe != null);
        jTextFieldGruppeZielPfad.setEnabled(pgruppe != null);
        jButtonGruppePfad.setEnabled(pgruppe != null);
        if (pgruppe != null) {
            jTextFieldGruppeName.setText(pgruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR]);
            jTextFieldGruppeDirektSuffix.setText(pgruppe.arr[Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR]);
            jTextFieldGruppeDirektPraefix.setText(pgruppe.arr[Konstanten.PROGRAMMGRUPPE_PRAEFIX_DIREKT_NR]);
            jTextFieldGruppeZielName.setText(pgruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR]);
            jTextFieldGruppeZielPfad.setText(pgruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR]);
        } else {
            jTextFieldGruppeName.setText("");
            jTextFieldGruppeDirektSuffix.setText("");
            jTextFieldGruppeDirektPraefix.setText("");
            jTextFieldGruppeZielName.setText("");
            jTextFieldGruppeZielPfad.setText("");
        }
        if (pgruppe != null) {
            tModel = getPgruppe().getListeProg().getModel();
            jTable1.setModel(tModel);
            if (tModel.getRowCount() > 0) {
                jTable1.setRowSelectionInterval(0, 0);
                jTable1.scrollRectToVisible(jTable1.getCellRect(0, 0, true));
            }
        } else {
            //Tabelle löschen
            jTable1.setModel(new TModel(new Object[0][Konstanten.PROGRAMM_MAX_ELEM], Konstanten.PROGRAMM_COLUMN_NAMES));
        }
        stopBeob = false;
        fillText();
    }

    private void fillText() {
        //Textfelder mit Programmdaten füllen
        stopBeob = true;
        int rows = jTable1.getSelectedRow();
        jTextFieldProgPfad.setEnabled(rows != -1);
        jTextFieldProgSchalter.setEnabled(rows != -1);
        jTextFieldProgName.setEnabled(rows != -1);
        jTextFieldProgPraefix.setEnabled(rows != -1);
        jTextFieldProgSuffix.setEnabled(rows != -1);
        jButtonProgPfad.setEnabled(rows != -1);
        jCheckBoxRestart.setEnabled(rows != -1);
        if (rows != -1) {
            int row = jTable1.convertRowIndexToModel(rows);
            DatenProg prog = getPgruppe().getProg(row);
            jTextFieldProgPfad.setText(prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR]);
            jTextFieldProgSchalter.setText(prog.arr[Konstanten.PROGRAMM_SCHALTER_NR]);
            jTextFieldProgName.setText(prog.arr[Konstanten.PROGRAMM_NAME_NR]);
            jTextFieldProgPraefix.setText(prog.arr[Konstanten.PROGRAMM_PRAEFIX_NR]);
            jTextFieldProgSuffix.setText(prog.arr[Konstanten.PROGRAMM_SUFFIX_NR]);
            jCheckBoxRestart.setSelected(Boolean.parseBoolean(prog.arr[Konstanten.PROGRAMM_RESTART_NR]));
        } else {
            jTextFieldProgPfad.setText("");
            jTextFieldProgSchalter.setText("");
            jTextFieldProgName.setText("");
            jTextFieldProgName.setBackground(Color.WHITE);
            jTextFieldProgPraefix.setText("");
            jTextFieldProgSuffix.setText("");
        }
        stopBeob = false;
//        progNamePruefen();
    }

    //Pgruppe
    private DatenPgruppe getPgruppe() {
        DatenPgruppe ret = null;
        int i = jList1.getSelectedIndex();
        if (i != -1) {
            ret = listePgruppe.get(i);
        }
        return ret;
    }

    private void setDoppelklick() {
        int i = jList1.getSelectedIndex();
        if (listePgruppe.get(i).getListeProg().size() <= 0) {
            JOptionPane.showMessageDialog(null, "Die Programmgruppe muss mind. ein Programm enthalten!",
                                          "kein Programm", JOptionPane.INFORMATION_MESSAGE);
        } else {
            if (i != -1) {
                listePgruppe.setDoppelklick(i);
                daten.setGeaendert();
                fillList();
            } else {
                new HinweisKeineAuswahl();
            }
        }
    }

    private void gruppenNamePruefen() {
        //doppelte Gruppennamen suchen
        //nur für die Abos wichtig
        if (!button) {
            int rows = jList1.getSelectedIndex();
            if (rows != -1) {
                int foundgruppe = 0;
                Iterator<DatenPgruppe> it = listePgruppe.iterator();
                while (it.hasNext()) {
                    DatenPgruppe gruppe = it.next();
                    if (jTextFieldGruppeName.getText().equals(gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR])) {
                        ++foundgruppe;
                    }
                }
                if (foundgruppe > 1) {
                    jTextFieldGruppeName.setBackground(Color.ORANGE);
                } else {
                    jTextFieldGruppeName.setBackground(Color.WHITE);
                }
            }
        }
    }

    private void gruppeAufAb(boolean auf) {
        int rows = jList1.getSelectedIndex();
        if (rows != -1) {
            fillList(listePgruppe.auf(rows, auf));
            daten.setGeaendert();
        } else {
            new HinweisKeineAuswahl();
        }

    }

    private void gruppeNeu() {
        //DatenPgruppe(String name, String suffix, String farbe, String zielPfad, String zielDateiname) {
        listePgruppe.add(new DatenPgruppe("", "", "", "", ""));
        fillList(listePgruppe.size() - 1);
    }

    private void gruppeLoeschen() {
        int row = jList1.getSelectedIndex();
        if (row >= 0) {
            int ret = -1;
            ret = JOptionPane.showConfirmDialog(null, "Löschen?", " ", JOptionPane.YES_NO_OPTION);
            if (ret == JOptionPane.OK_OPTION) {
                listePgruppe.remove(row);
            }
            fillList();
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void progNeueZeile(DatenProg prog) {
        DatenPgruppe gruppe = null;
        int i = jList1.getSelectedIndex();
        if (i != -1) {
            gruppe = listePgruppe.get(i);
            gruppe.addProg(prog);
            fillTable();
            int neu = tModel.getRowCount();
            jTable1.setRowSelectionInterval(jTable1.convertRowIndexToView(neu - 1), jTable1.convertRowIndexToView(neu - 1));
            jTable1.scrollRectToVisible(jTable1.getCellRect(neu - 1, 0, true));
            daten.setGeaendert();
            guiFilmeAendern();
        }
    }

    private void progAufAb(boolean auf) {
        int rows = jTable1.getSelectedRow();
        if (rows != -1) {
            int row = jTable1.convertRowIndexToModel(rows);
            int neu = getPgruppe().getListeProg().auf(row, auf);
            fillTable();
            jTable1.setRowSelectionInterval(neu, neu);
            jTable1.scrollRectToVisible(jTable1.getCellRect(neu, 0, true));
            daten.setGeaendert();
        } else {
            new HinweisKeineAuswahl();
        }

    }

    private void vorlageProgHinzufuegen() {
        int i = jComboBoxProgVorlagen.getSelectedIndex();
        DatenProg prog = daten.listeProgVorlagen.get(i).copy();
        progNeueZeile(prog);
    }

    //Rest
    private void dialogHilfe() {
        new DialogHilfeProgramme(null, true, daten, button).setVisible(true);
        fillList();
    }

    private void beenden() {
        this.dispose();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jSplitPane1 = new javax.swing.JSplitPane();
        jPanel4 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jButtonGruppeNeu = new javax.swing.JButton();
        jButtonGruppeLoeschen = new javax.swing.JButton();
        jButtonGruppeDuplizieren = new javax.swing.JButton();
        jButtonGruppeAuf = new javax.swing.JButton();
        jButtonGruppeAb = new javax.swing.JButton();
        jLabelTitel = new javax.swing.JLabel();
        jButtonGruppeDoppelklick = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        jPanel7 = new javax.swing.JPanel();
        jTextFieldGruppeDirektSuffix = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jButtonGruppeFarbe = new javax.swing.JButton();
        jButtonGruppeStandardfarbe = new javax.swing.JButton();
        jTextFieldGruppeName = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jTextFieldGruppeZielPfad = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        jTextFieldGruppeZielName = new javax.swing.JTextField();
        jButtonGruppePfad = new javax.swing.JButton();
        jTextFieldGruppeDirektPraefix = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel2 = new javax.swing.JPanel();
        jButtonProgPlus = new javax.swing.JButton();
        jButtonProgMinus = new javax.swing.JButton();
        jButtonProgDuplizieren = new javax.swing.JButton();
        jComboBoxProgVorlagen = new javax.swing.JComboBox();
        jButtonProgVorlageHinzufuegen = new javax.swing.JButton();
        jButtonProgAuf = new javax.swing.JButton();
        jButtonProgAb = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jLabel = new javax.swing.JLabel();
        jTextFieldProgPfad = new javax.swing.JTextField();
        jButtonProgPfad = new javax.swing.JButton();
        jTextFieldProgSchalter = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jTextFieldProgName = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jTextFieldProgPraefix = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jTextFieldProgSuffix = new javax.swing.JTextField();
        jCheckBoxRestart = new javax.swing.JCheckBox();
        jButtonHilfe = new javax.swing.JButton();
        jButtonPruefen = new javax.swing.JButton();
        jButtonOk = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jSplitPane1.setDividerLocation(300);

        jPanel4.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));

        jList1.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane2.setViewportView(jList1);

        jButtonGruppeNeu.setText("Neu");
        jButtonGruppeNeu.setToolTipText("neue Programmgruppe anlegen");

        jButtonGruppeLoeschen.setText("Löschen");
        jButtonGruppeLoeschen.setToolTipText("Programmgruppe löschen");

        jButtonGruppeDuplizieren.setText("Duplizieren");
        jButtonGruppeDuplizieren.setToolTipText("Programmgruppe kopieren");

        jButtonGruppeAuf.setText("Auf");
        jButtonGruppeAuf.setToolTipText("Programmgruppe nach oben schieben");

        jButtonGruppeAb.setText("Ab");
        jButtonGruppeAb.setToolTipText("Programmgruppe nach unten schieben");

        jLabelTitel.setText("  ");

        jButtonGruppeDoppelklick.setText("Doppelklick");
        jButtonGruppeDoppelklick.setToolTipText("Bei einem Doppelklick wird dieser Button betätigt");

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jButtonGruppeDoppelklick, javax.swing.GroupLayout.DEFAULT_SIZE, 269, Short.MAX_VALUE)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 269, Short.MAX_VALUE)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(jButtonGruppeAuf)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButtonGruppeNeu, javax.swing.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButtonGruppeAb))
                    .addComponent(jLabelTitel)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(jButtonGruppeDuplizieren)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE)
                        .addComponent(jButtonGruppeLoeschen, javax.swing.GroupLayout.PREFERRED_SIZE, 125, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        jPanel4Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonGruppeDuplizieren, jButtonGruppeLoeschen});

        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabelTitel)
                .addGap(12, 12, 12)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 542, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jButtonGruppeAuf)
                    .addComponent(jButtonGruppeNeu)
                    .addComponent(jButtonGruppeAb))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonGruppeDuplizieren)
                    .addComponent(jButtonGruppeLoeschen))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonGruppeDoppelklick)
                .addContainerGap())
        );

        jPanel4Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonGruppeLoeschen, jButtonGruppeNeu});

        jSplitPane1.setLeftComponent(jPanel4);

        jPanel5.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));

        jPanel7.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(102, 102, 255), 2), "Programmgruppe"));

        jLabel5.setText("Suffix:");

        jButtonGruppeFarbe.setText("Farbe");
        jButtonGruppeFarbe.setToolTipText("Farbauswahldialog anzeigen");

        jButtonGruppeStandardfarbe.setText("Standardfarbe");
        jButtonGruppeStandardfarbe.setToolTipText("Farbe zurücksetzen");

        jLabel6.setText("Name:");

        jLabel7.setText("Zielpfad:");

        jLabel8.setText("Zieldateiname:");

        jButtonGruppePfad.setText(":::");
        jButtonGruppePfad.setToolTipText("Pfad auswählen");

        jLabel10.setText("direkter Downloads, Präfix:");

        javax.swing.GroupLayout jPanel7Layout = new javax.swing.GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addComponent(jButtonGruppeFarbe)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonGruppeStandardfarbe))
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addComponent(jLabel10)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldGruppeDirektPraefix, javax.swing.GroupLayout.PREFERRED_SIZE, 127, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldGruppeDirektSuffix, javax.swing.GroupLayout.DEFAULT_SIZE, 97, Short.MAX_VALUE))
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addComponent(jLabel6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldGruppeName, javax.swing.GroupLayout.DEFAULT_SIZE, 441, Short.MAX_VALUE))
                    .addGroup(jPanel7Layout.createSequentialGroup()
                        .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel8)
                            .addComponent(jLabel7))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel7Layout.createSequentialGroup()
                                .addComponent(jTextFieldGruppeZielPfad, javax.swing.GroupLayout.DEFAULT_SIZE, 323, Short.MAX_VALUE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonGruppePfad))
                            .addComponent(jTextFieldGruppeZielName, javax.swing.GroupLayout.DEFAULT_SIZE, 378, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel7Layout.setVerticalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldGruppeName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldGruppeZielPfad, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonGruppePfad)
                    .addComponent(jLabel7))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel8)
                    .addComponent(jTextFieldGruppeZielName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldGruppeDirektSuffix, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel10)
                    .addComponent(jTextFieldGruppeDirektPraefix, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel5))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonGruppeFarbe)
                    .addComponent(jButtonGruppeStandardfarbe))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(102, 102, 255)), "Programme"));

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        jScrollPane1.setViewportView(jTable1);

        jPanel2.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jButtonProgPlus.setText("+");
        jButtonProgPlus.setToolTipText("neues Programm anlegen");

        jButtonProgMinus.setText("-");
        jButtonProgMinus.setToolTipText("markiertes Programm löschen");

        jButtonProgDuplizieren.setText("Duplizieren");
        jButtonProgDuplizieren.setToolTipText("markierte Zeile duplizieren");

        jComboBoxProgVorlagen.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jButtonProgVorlageHinzufuegen.setText("Hinzufügen");
        jButtonProgVorlageHinzufuegen.setToolTipText("eine Auswahl an Programmen hinzufügen");

        jButtonProgAuf.setText("auf");
        jButtonProgAuf.setToolTipText("markierte Zeile eins nach oben");

        jButtonProgAb.setText("ab");
        jButtonProgAb.setToolTipText("markierte Zeile eins nach unten");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jButtonProgPlus)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonProgMinus)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonProgDuplizieren)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonProgAuf)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonProgAb))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jComboBoxProgVorlagen, 0, 351, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonProgVorlageHinzufuegen)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonProgPlus)
                    .addComponent(jButtonProgMinus)
                    .addComponent(jButtonProgDuplizieren)
                    .addComponent(jButtonProgAuf)
                    .addComponent(jButtonProgAb))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxProgVorlagen, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonProgVorlageHinzufuegen))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jLabel.setText("Programm:");

        jButtonProgPfad.setText(":::");
        jButtonProgPfad.setToolTipText("Pfad auswählen");

        jLabel1.setText("Schalter:");

        jLabel2.setText("Name:");

        jLabel3.setText("Präfix ( zB. http ):");

        jLabel4.setText("Suffix ( zB. mp4):");

        jCheckBoxRestart.setText("fehlgeschlagene Downloads wieder Starten");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel3)
                    .addComponent(jLabel1)
                    .addComponent(jLabel)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jCheckBoxRestart)
                    .addComponent(jTextFieldProgSchalter, javax.swing.GroupLayout.DEFAULT_SIZE, 337, Short.MAX_VALUE)
                    .addComponent(jTextFieldProgName, javax.swing.GroupLayout.DEFAULT_SIZE, 337, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                        .addComponent(jTextFieldProgPfad, javax.swing.GroupLayout.DEFAULT_SIZE, 282, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonProgPfad))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jTextFieldProgPraefix, javax.swing.GroupLayout.PREFERRED_SIZE, 146, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldProgSuffix, javax.swing.GroupLayout.DEFAULT_SIZE, 50, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(jTextFieldProgName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel)
                    .addComponent(jButtonProgPfad)
                    .addComponent(jTextFieldProgPfad, javax.swing.GroupLayout.PREFERRED_SIZE, 12, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jTextFieldProgSchalter, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE, false)
                    .addComponent(jTextFieldProgPraefix, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3)
                    .addComponent(jTextFieldProgSuffix, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jCheckBoxRestart)
                .addContainerGap(18, Short.MAX_VALUE))
        );

        jPanel1Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jTextFieldProgName, jTextFieldProgPfad, jTextFieldProgPraefix, jTextFieldProgSchalter, jTextFieldProgSuffix});

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 500, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 139, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 165, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jButtonHilfe.setText("Hilfe");
        jButtonHilfe.setToolTipText("Hilfedialog anzeigen");

        jButtonPruefen.setText("Prüfen");
        jButtonPruefen.setToolTipText("Programmpfade prüfen");

        jButtonOk.setText("Ok");

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel3, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup()
                        .addComponent(jButtonPruefen, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonHilfe)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonOk))
                    .addComponent(jPanel7, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        jPanel5Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonHilfe, jButtonOk, jButtonPruefen});

        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonHilfe)
                    .addComponent(jButtonPruefen)
                    .addComponent(jButtonOk))
                .addContainerGap())
        );

        jSplitPane1.setRightComponent(jPanel5);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 875, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 694, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonGruppeAb;
    private javax.swing.JButton jButtonGruppeAuf;
    private javax.swing.JButton jButtonGruppeDoppelklick;
    private javax.swing.JButton jButtonGruppeDuplizieren;
    private javax.swing.JButton jButtonGruppeFarbe;
    private javax.swing.JButton jButtonGruppeLoeschen;
    private javax.swing.JButton jButtonGruppeNeu;
    private javax.swing.JButton jButtonGruppePfad;
    private javax.swing.JButton jButtonGruppeStandardfarbe;
    private javax.swing.JButton jButtonHilfe;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JButton jButtonProgAb;
    private javax.swing.JButton jButtonProgAuf;
    private javax.swing.JButton jButtonProgDuplizieren;
    private javax.swing.JButton jButtonProgMinus;
    private javax.swing.JButton jButtonProgPfad;
    private javax.swing.JButton jButtonProgPlus;
    private javax.swing.JButton jButtonProgVorlageHinzufuegen;
    private javax.swing.JButton jButtonPruefen;
    private javax.swing.JCheckBox jCheckBoxRestart;
    private javax.swing.JComboBox jComboBoxProgVorlagen;
    private javax.swing.JLabel jLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabelTitel;
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextField jTextFieldGruppeDirektPraefix;
    private javax.swing.JTextField jTextFieldGruppeDirektSuffix;
    private javax.swing.JTextField jTextFieldGruppeName;
    private javax.swing.JTextField jTextFieldGruppeZielName;
    private javax.swing.JTextField jTextFieldGruppeZielPfad;
    private javax.swing.JTextField jTextFieldProgName;
    private javax.swing.JTextField jTextFieldProgPfad;
    private javax.swing.JTextField jTextFieldProgPraefix;
    private javax.swing.JTextField jTextFieldProgSchalter;
    private javax.swing.JTextField jTextFieldProgSuffix;
    // End of variables declaration//GEN-END:variables

    private class BeobProgAction implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!stopBeob) {
                daten.setGeaendert();
                int rows = jTable1.getSelectedRow();
                if (rows != -1) {
                    int row = jTable1.convertRowIndexToModel(rows);
                    DatenProg prog = getPgruppe().getListeProg().get(row);
                    prog.arr[Konstanten.PROGRAMM_RESTART_NR] = Boolean.toString(jCheckBoxRestart.isSelected());
                    tModel.setValueAt(Boolean.toString(jCheckBoxRestart.isSelected()), row, Konstanten.PROGRAMM_RESTART_NR);
                }
            }

        }

    }

    private class BeobProgDoc implements DocumentListener {

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            eingabe();
        }

        private void eingabe() {
            if (!stopBeob) {
                daten.setGeaendert();
                int rows = jTable1.getSelectedRow();
                if (rows != -1) {
                    int row = jTable1.convertRowIndexToModel(rows);
                    DatenProg prog = getPgruppe().getListeProg().get(row);
                    prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR] = jTextFieldProgPfad.getText();
                    prog.arr[Konstanten.PROGRAMM_SCHALTER_NR] = jTextFieldProgSchalter.getText();
                    prog.arr[Konstanten.PROGRAMM_NAME_NR] = jTextFieldProgName.getText();
                    prog.arr[Konstanten.PROGRAMM_SUFFIX_NR] = jTextFieldProgSuffix.getText();
                    prog.arr[Konstanten.PROGRAMM_PRAEFIX_NR] = jTextFieldProgPraefix.getText();
                    tModel.setValueAt(jTextFieldProgPfad.getText(), row, Konstanten.PROGRAMM_PROGRAMMPFAD_NR);
                    tModel.setValueAt(jTextFieldProgSchalter.getText(), row, Konstanten.PROGRAMM_SCHALTER_NR);
                    tModel.setValueAt(jTextFieldProgName.getText(), row, Konstanten.PROGRAMM_NAME_NR);
                    tModel.setValueAt(jTextFieldProgSuffix.getText(), row, Konstanten.PROGRAMM_SUFFIX_NR);
                    tModel.setValueAt(jTextFieldProgPraefix.getText(), row, Konstanten.PROGRAMM_PRAEFIX_NR);
//                    progNamePruefen();
                }
            }
        }

    }

    private class BeobSelectGruppe implements ListSelectionListener {

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!stopBeob) {
                if (!event.getValueIsAdjusting()) {
                    fillTable();
                }
            }
        }

    }

    private class BeobDateiDialogProg implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
            if (!jTextFieldProgPfad.getText().equals("")) {
                chooser.setCurrentDirectory(new File(jTextFieldProgPfad.getText()));
            }
            returnVal = chooser.showOpenDialog(null);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                try {
                    String str = chooser.getSelectedFile().getPath();
                    jTextFieldProgPfad.setText(str);
                } catch (Exception ex) {
                    daten.fehler.fehlerMeldung(ex, "DialogPgruppe.BeobDateiDialogProg");
                }
            }
        }

    }

    private class BeobDateiDialogPfad implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            if (!jTextFieldGruppeZielPfad.getText().equals("")) {
                chooser.setCurrentDirectory(new File(jTextFieldGruppeZielPfad.getText()));
            }
            returnVal = chooser.showOpenDialog(null);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                try {
                    String str = chooser.getSelectedFile().getPath();
                    jTextFieldGruppeZielPfad.setText(str);
                } catch (Exception ex) {
                    daten.fehler.fehlerMeldung(ex, "DialogPgruppe.BeobDateiDialogPfad");
                }
            }
        }

    }

    private class BeobProgNeueZeile implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            DatenProg prog = new DatenProg();
            progNeueZeile(prog);
        }

    }

    private class BeobProgDuplizieren implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            int rows = jTable1.getSelectedRow();
            if (rows != -1) {
                int row = jTable1.convertRowIndexToModel(rows);
                DatenProg prog = getPgruppe().getListeProg().get(row);
                progNeueZeile(prog.copy());
            } else {
                new HinweisKeineAuswahl();
            }
        }

    }

    private class BeobGruppenDoc implements DocumentListener {

        JTextField textfeld;
        int nr;

        public BeobGruppenDoc(JTextField ttextfeld, int nnr) {
            textfeld = ttextfeld;
            nr = nnr;
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            eingabe();
        }

        private void eingabe() {
            if (!stopBeob) {
                int row = jList1.getSelectedIndex();
                if (row >= 0) {
                    stopBeob = true;
                    DatenPgruppe gruppe = listePgruppe.get(row);
                    gruppe.arr[nr] = textfeld.getText();
                    if (nr == Konstanten.PROGRAMMGRUPPE_NAME_NR) {
                        jList1.setModel(new javax.swing.DefaultComboBoxModel(listePgruppe.getObjectDataCombo()));
                        jList1.setSelectedIndex(row);
                    }
                    daten.setGeaendert();
                    stopBeob = false;
                } else {
                    new HinweisKeineAuswahl();
                }
            }
            gruppenNamePruefen();
            guiFilmeAendern();
        }

    }

    private class BeobGruppeDuplizieren implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = jList1.getSelectedIndex();
            if (row >= 0) {
                listePgruppe.duplicate(getPgruppe());
                fillList();
                daten.setGeaendert();
            } else {
                new HinweisKeineAuswahl();
            }
        }

    }

    private class BeobGruppeDoppelklick implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            setDoppelklick();
        }

    }

    private class BeobOk implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            beenden();
        }

    }

    private class BeobHilfeTabelle implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            dialogHilfe();
        }

    }

    private class BeobProgLoeschen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            int rows[] = jTable1.getSelectedRows();
            if (rows.length > 0) {
                int ret = -1;
                ret = JOptionPane.showConfirmDialog(null, "Löschen?", " ", JOptionPane.YES_NO_OPTION);
                if (ret == JOptionPane.OK_OPTION) {
                    for (int i = rows.length - 1; i >= 0; --i) {
                        int delRow = jTable1.convertRowIndexToModel(rows[i]);
                        getPgruppe().getListeProg().remove(delRow);
                    }
                    fillTable();
                    daten.setGeaendert();
                    guiFilmeAendern();
                }
            } else {
                new HinweisKeineAuswahl();
            }
        }

    }

    private class BeobPuefen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            Funktionen.programmePruefen(daten, listePgruppe);
        }

    }

    private class BeobVorlageProgHinzufuegen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            vorlageProgHinzufuegen();
        }

    }

    private class BeobProgAufAb implements ActionListener {

        boolean auf;

        public BeobProgAufAb(boolean a) {
            auf = a;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            progAufAb(auf);
        }

    }

    private class BeobGruppeAufAb implements ActionListener {

        boolean auf;

        public BeobGruppeAufAb(boolean a) {
            auf = a;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            gruppeAufAb(auf);
        }

    }

    private class BeobGruppeNeu implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            gruppeNeu();
        }

    }

    private class BeobGruppeLoeschen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            gruppeLoeschen();
        }

    }

    private class BeobachterFarbe implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            DatenPgruppe pgruppe = getPgruppe();
            if (pgruppe != null) {
                DialogFarbe dialog = new DialogFarbe(null, true);
                dialog.setVisible(true);
                if (dialog.farbe != null) {
                    pgruppe.setFarbe(dialog.farbe);
                    fillList();
                    daten.setGeaendert();
                }
            }

        }

    }

    private class BeobStandardfarbe implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            DatenPgruppe pgruppe = getPgruppe();
            if (pgruppe != null) {
                pgruppe.arr[Konstanten.PROGRAMMGRUPPE_FARBE_NR] = "";
                fillList();
                daten.setGeaendert();
            }

        }

    }

    private class ComboBoxRenderer extends JLabel implements ListCellRenderer {

        @Override
        public Component getListCellRendererComponent(
            JList list, // the list
            Object value, // value to display
            int index, // cell index
            boolean isSelected, // is the cell selected
            boolean cellHasFocus) // does the cell have focus
        {
            if (value.toString().equals("")) {
                //für Leerzeichen
                this.setMinimumSize(new Dimension(19, 19));
                this.setPreferredSize(new Dimension(19, 19));
            }
            setText(value.toString());
            setBackground(null);
            setBorder(null);
            Color col = null;
            col = listePgruppe.get(index).getFarbe(daten);
            boolean doppelklick = listePgruppe.get(index).arr[Konstanten.PROGRAMMGRUPPE_DOPPELKLICK_NR].equals(Boolean.toString(true));
            if (isSelected) {
                if (doppelklick) {
                    setForeground(Color.RED);
                } else {
                    setForeground(list.getSelectionForeground());
                }
                setBackground(list.getSelectionBackground());
            } else {
                if (doppelklick) {
                    setForeground(Color.RED);
                } else {
                    setForeground(list.getForeground());
                }
                setBackground(list.getBackground());
            }
            if (col != null) {
                setBorder(javax.swing.BorderFactory.createLineBorder(col, 2));
            }
            setEnabled(list.isEnabled());
            setFont(list.getFont());
            setOpaque(true);
            return this;
        }

    }

    public class BeobTableSelect implements ListSelectionListener {

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                if (!stopBeob) {
                    fillText();
                }
            }

        }

    }

    public class BeobMaus extends MouseAdapter {

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == MouseEvent.BUTTON1) {
                if (arg0.getClickCount() > 1) {
                    setDoppelklick();
                }
            }
        }

    }

}
