/*
 * (C) Copyright 1996- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */

/// @author Baudouin Raoult
/// @author Pedro Maciel
/// @date Apr 2015


#ifndef mir_util_Increments_h
#define mir_util_Increments_h

#include <iosfwd>
#include "mir/util/LatitudeIncrement.h"
#include "mir/util/LongitudeIncrement.h"


struct grib_info;
namespace mir {
namespace param {
class MIRParametrisation;
}
namespace api {
class MIRJob;
}
}
namespace mir {
namespace util {
class BoundingBox;
}
}


namespace mir {
namespace util {


class Increments {
public:

    // -- Exceptions
    // None

    // -- Contructors

    Increments();
    Increments(const param::MIRParametrisation&);
    Increments(const Increments&);
    explicit Increments(double westEastIncrement, double southNorthIncrement);
    explicit Increments(const LongitudeIncrement&, const LatitudeIncrement&);

    // -- Destructor

    ~Increments();

    // -- Convertors
    // None

    // -- Operators

    bool operator==(const Increments&) const;

    bool operator!=(const Increments&) const;

    Increments& operator=(const Increments&);

    // -- Methods

    bool isPeriodic() const;

    bool isShifted(const BoundingBox&) const;

    const LongitudeIncrement& west_east() const {
        return west_east_;
    }

    const LatitudeIncrement& south_north() const {
        return south_north_;
    }

    void fill(grib_info&) const;

    void fill(api::MIRJob&) const;

    void makeName(std::ostream&) const;

    bool isLatitudeShifted(const BoundingBox&) const;

    bool isLongitudeShifted(const BoundingBox&) const;

    // -- Overridden methods
    // None

    // -- Class members
    // None

    // -- Class methods
    // None

protected:

    // -- Members
    // None

    // -- Methods

    void print(std::ostream&) const;

    // -- Overridden methods
    // None

    // -- Class members
    // None

    // -- Class methods
    // None

private:

    // -- Members

    LongitudeIncrement west_east_;
    LatitudeIncrement south_north_;

    // -- Methods
    // None

    // -- Overridden methods
    // None

    // -- Class members
    // None

    // -- Class methods
    // None

    // -- Friends

    friend std::ostream &operator<<(std::ostream& s, const Increments& p) {
        p.print(s);
        return s;
    }

};


}  // namespace util
}  // namespace mir


#endif

