/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.Color;
import java.awt.Paint;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGAttributeKeys
extends AttributeKeys {
    private static final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
    public static final AttributeKey<String> TITLE = new AttributeKey<Object>("title", String.class, null, true, labels);
    public static final AttributeKey<String> DESCRIPTION = new AttributeKey<Object>("description", String.class, null, true, labels);
    public static final AttributeKey<Color> VIEWPORT_FILL = CANVAS_FILL_COLOR;
    public static final AttributeKey<Double> VIEWPORT_FILL_OPACITY = CANVAS_FILL_OPACITY;
    public static final AttributeKey<Double> VIEWPORT_WIDTH = CANVAS_WIDTH;
    public static final AttributeKey<Double> VIEWPORT_HEIGHT = CANVAS_HEIGHT;
    public static final AttributeKey<TextAnchor> TEXT_ANCHOR = new AttributeKey<TextAnchor>("textAnchor", TextAnchor.class, TextAnchor.START, false, labels);
    public static final AttributeKey<TextAlign> TEXT_ALIGN = new AttributeKey<TextAlign>("textAlign", TextAlign.class, TextAlign.START, false, labels);
    public static final AttributeKey<Gradient> FILL_GRADIENT = new AttributeKey<Object>("fillGradient", Gradient.class, null, true, labels);
    public static final AttributeKey<Double> FILL_OPACITY = new AttributeKey<Double>("fillOpacity", Double.class, 1.0, false, labels);
    public static final AttributeKey<Double> OPACITY = new AttributeKey<Double>("opacity", Double.class, 1.0, false, labels);
    public static final AttributeKey<Gradient> STROKE_GRADIENT = new AttributeKey<Object>("strokeGradient", Gradient.class, null, true, labels);
    public static final AttributeKey<Double> STROKE_OPACITY = new AttributeKey<Double>("strokeOpacity", Double.class, 1.0, false, labels);
    public static final AttributeKey<String> LINK = new AttributeKey<Object>("link", String.class, null, true, labels);
    public static final AttributeKey<String> LINK_TARGET = new AttributeKey<Object>("linkTarget", String.class, null, true, labels);

    public static Paint getFillPaint(Figure figure) {
        double d = figure.get(FILL_OPACITY);
        if (figure.get(FILL_GRADIENT) != null) {
            return figure.get(FILL_GRADIENT).getPaint(figure, d);
        }
        Color color = (Color)figure.get(FILL_COLOR);
        if (color != null && d != 1.0) {
            color = new Color(color.getRGB() & 0xFFFFFF | (int)(d * 255.0) << 24, true);
        }
        return color;
    }

    public static Paint getStrokePaint(Figure figure) {
        double d = figure.get(STROKE_OPACITY);
        if (figure.get(STROKE_GRADIENT) != null) {
            return figure.get(STROKE_GRADIENT).getPaint(figure, d);
        }
        Color color = (Color)figure.get(STROKE_COLOR);
        if (color != null && d != 1.0) {
            color = new Color(color.getRGB() & 0xFFFFFF | (int)(d * 255.0) << 24, true);
        }
        return color;
    }

    public static void setDefaults(Figure figure) {
        figure.set(FILL_COLOR, Color.black);
        figure.set(WINDING_RULE, AttributeKeys.WindingRule.NON_ZERO);
        figure.set(STROKE_COLOR, null);
        figure.set(STROKE_WIDTH, 1.0);
        figure.set(STROKE_CAP, 0);
        figure.set(STROKE_JOIN, 0);
        figure.set(STROKE_MITER_LIMIT, 4.0);
        figure.set(IS_STROKE_MITER_LIMIT_FACTOR, false);
        figure.set(STROKE_DASHES, null);
        figure.set(STROKE_DASH_PHASE, 0.0);
        figure.set(IS_STROKE_DASH_FACTOR, false);
    }

    public static double getPerpendicularHitGrowth(Figure figure) {
        double d;
        if (figure.get(STROKE_COLOR) == null && figure.get(STROKE_GRADIENT) == null) {
            d = SVGAttributeKeys.getPerpendicularFillGrowth(figure);
        } else {
            double d2 = AttributeKeys.getStrokeTotalWidth(figure);
            d = SVGAttributeKeys.getPerpendicularDrawGrowth(figure) + d2 / 2.0;
        }
        return d;
    }

    public static enum TextAlign {
        START,
        CENTER,
        END;

    }

    public static enum TextAnchor {
        START,
        MIDDLE,
        END;

    }
}

