/*****************************************************
*  
*  Copyright 2009 Adobe Systems Incorporated.  All Rights Reserved.
*  
*****************************************************
*  The contents of this file are subject to the Mozilla Public License
*  Version 1.1 (the "License"); you may not use this file except in
*  compliance with the License. You may obtain a copy of the License at
*  http://www.mozilla.org/MPL/
*   
*  Software distributed under the License is distributed on an "AS IS"
*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
*  License for the specific language governing rights and limitations
*  under the License.
*   
*  
*  The Initial Developer of the Original Code is Adobe Systems Incorporated.
*  Portions created by Adobe Systems Incorporated are Copyright (C) 2009 Adobe Systems 
*  Incorporated. All Rights Reserved. 
* 
*  Contributor(s): Akamai Technologies
*  
*****************************************************/
package org.osmf.netmocker
{
	public interface IMockNetLoader
	{
		/**
		 * The client's expectation for how this loader's NetConnection will
		 * behave after connect() is called.
		 **/ 
		function set netConnectionExpectation(value:NetConnectionExpectation):void;
		function get netConnectionExpectation():NetConnectionExpectation;
		
		/**
		 * The client's expectation for the version of the FMS server from which
		 * the NetConnection originates.  Format should be "3,5,3" (i.e. comma
		 * separated).
		 **/ 
		function set netConnectionExpectedFMSVersion(value:String):void;
		function get netConnectionExpectedFMSVersion():String;
		
		/**
		 * The expected duration of any mock NetStreams generated by this
		 * loader.
		 * 
		 * The expected duration will be returned in the onMetaData client
		 * callback.
		 **/
		function set netStreamExpectedDuration(value:Number):void;		
		function get netStreamExpectedDuration():Number;

		/**
		 * The expected duration of any mock NetStreams generated by this
		 * loader, where the streams are subclips.
		 * 
		 * The expected duration will map to the playback duration of the
		 * media.
		 **/
		function set netStreamExpectedSubclipDuration(value:Number):void;
		function get netStreamExpectedSubclipDuration():Number;

		/**
		 * The expected width of any mock NetStreams generated by this
		 * loader.
		 * 
		 * The expected width will be returned in the onMetaData client
		 * callback.
		 **/
		function set netStreamExpectedWidth(value:Number):void;
		function get netStreamExpectedWidth():Number;

		/**
		 * The expected height of any mock NetStreams generated by this
		 * loader.
		 * 
		 * The expected height will be returned in the onMetaData client
		 * callback.
		 **/
		function set netStreamExpectedHeight(value:Number):void;		
		function get netStreamExpectedHeight():Number;
		
		/**
		 * An Array of EventInfos representing any events that are expected to
		 *  be dispatched when the mock NetStream's position crosses a certain
		 * threshold.  Note that these events are above and beyond what the
		 * MockNetStream typically dispatches during playback.
		 **/
		function set netStreamExpectedEvents(value:Array):void;
		function get netStreamExpectedEvents():Array;
	}
}
