/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.ShortCharAssociativeContainer;
import com.carrotsearch.hppc.ShortCharMap;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.cursors.ShortCharCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.hash.CharHashFunction;
import com.carrotsearch.hppc.hash.ShortHashFunction;
import com.carrotsearch.hppc.hash.ShortMurmurHash;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ShortCharProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortCharOpenHashMap
implements ShortCharMap {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final byte EMPTY = 0;
    public static final byte DELETED = 1;
    public static final byte ASSIGNED = 2;
    public short[] keys;
    public char[] values;
    public byte[] states;
    public int deleted;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;
    public final ShortHashFunction keyHashFunction;
    public final CharHashFunction valueHashFunction;
    private KeySet keySetView;

    public ShortCharOpenHashMap() {
        this(16);
    }

    public ShortCharOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ShortCharOpenHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, new ShortMurmurHash());
    }

    public ShortCharOpenHashMap(int initialCapacity, float loadFactor, ShortHashFunction keyHashFunction) {
        this(initialCapacity, loadFactor, keyHashFunction, new CharHashFunction());
    }

    public ShortCharOpenHashMap(int initialCapacity, float loadFactor, ShortHashFunction keyHashFunction, CharHashFunction valueHashFunction) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.valueHashFunction = valueHashFunction;
        this.keyHashFunction = keyHashFunction;
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public ShortCharOpenHashMap(ShortCharAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public char put(short key, char value) {
        int slot;
        byte state;
        if (this.assigned + this.deleted >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        if ((state = this.states[slot = this.slotFor(key)]) != 2) {
            ++this.assigned;
        }
        if (state == 1) {
            --this.deleted;
        }
        char oldValue = this.values[slot];
        this.keys[slot] = key;
        this.values[slot] = value;
        this.states[slot] = 2;
        return oldValue;
    }

    @Override
    public final int putAll(ShortCharAssociativeContainer container) {
        int count = this.assigned;
        for (ShortCharCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(short key, char value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final char putOrAdd(short key, char putValue, char additionValue) {
        int slot;
        byte state;
        if (this.assigned + this.deleted >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        if ((state = this.states[slot = this.slotFor(key)]) == 2) {
            int n = slot;
            char c = (char)(this.values[n] + additionValue);
            this.values[n] = c;
            return c;
        }
        ++this.assigned;
        if (state == 1) {
            --this.deleted;
        }
        this.states[slot] = 2;
        this.keys[slot] = key;
        this.values[slot] = putValue;
        return this.values[slot];
    }

    private void expandAndRehash() {
        short[] oldKeys = this.keys;
        char[] oldValues = this.values;
        byte[] oldStates = this.states;
        if (this.assigned >= this.resizeThreshold) {
            this.allocateBuffers(this.nextCapacity(this.keys.length));
        } else {
            this.allocateBuffers(this.values.length);
        }
        for (int i = 0; i < oldStates.length; ++i) {
            if (oldStates[i] != 2) continue;
            int slot = this.slotFor(oldKeys[i]);
            this.keys[slot] = oldKeys[i];
            this.values[slot] = oldValues[i];
            this.states[slot] = 2;
        }
        this.deleted = 0;
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new short[capacity];
        this.values = new char[capacity];
        this.states = new byte[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public char remove(short key) {
        int slot = this.slotFor(key);
        char value = this.values[slot];
        byte state = this.states[slot];
        if (state == 2) {
            ++this.deleted;
            --this.assigned;
            this.keys[slot] = 0;
            this.values[slot] = '\u0000';
            this.states[slot] = 1;
        } else assert ('\u0000' == value) : "Default value expected.";
        return value;
    }

    @Override
    public final int removeAll(ShortContainer container) {
        int before = this.deleted;
        for (ShortCursor cursor : container) {
            this.remove(cursor.value);
        }
        return this.deleted - before;
    }

    @Override
    public final int removeAll(ShortPredicate predicate) {
        int before = this.deleted;
        short[] keys = this.keys;
        char[] values = this.values;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2 || !predicate.apply(keys[i])) continue;
            ++this.deleted;
            --this.assigned;
            keys[i] = 0;
            values[i] = '\u0000';
            states[i] = 1;
        }
        return this.deleted - before;
    }

    @Override
    public char get(short key) {
        return this.values[this.slotFor(key)];
    }

    public char lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public char lset(char key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        char previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(short key) {
        this.lastSlot = this.slotFor(key);
        int slot = this.lastSlot;
        return this.states[slot] == 2;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    public int slotFor(short key) {
        int slots = this.states.length;
        int bucketMask = slots - 1;
        int slot = this.keyHashFunction.hash(key) & bucketMask;
        int i = 0;
        int deletedSlot = -1;
        byte state;
        while ((state = this.states[slot]) != 0) {
            if (state == 2 && this.keys[slot] == key) {
                return slot;
            }
            if (state == 1 && deletedSlot < 0) {
                deletedSlot = slot;
            }
            slot = slot + ++i & bucketMask;
        }
        return deletedSlot != -1 ? deletedSlot : slot;
    }

    @Override
    public void clear() {
        this.deleted = 0;
        this.assigned = 0;
        Arrays.fill(this.states, (byte)0);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (ShortCharCursor c : this) {
            h += this.keyHashFunction.hash(c.key) + this.valueHashFunction.hash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ShortCharMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ShortCharMap && (other = (ShortCharMap)obj).size() == this.size()) {
                for (ShortCharCursor c : this) {
                    char v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ShortCharCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ShortCharProcedure> T forEach(T procedure) {
        short[] keys = this.keys;
        char[] values = this.values;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeySet keySet() {
        if (this.keySetView == null) {
            this.keySetView = new KeySet();
        }
        return this.keySetView;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ShortCharCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static ShortCharOpenHashMap from(short[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortCharOpenHashMap map = new ShortCharOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static ShortCharOpenHashMap from(ShortCharAssociativeContainer container) {
        return new ShortCharOpenHashMap(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySetIterator
    implements Iterator<ShortCursor> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final ShortCursor cursor = new ShortCursor();
        private int nextIndex = -1;

        public KeySetIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < ShortCharOpenHashMap.this.keys.length && ShortCharOpenHashMap.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != ShortCharOpenHashMap.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public ShortCursor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.value = ShortCharOpenHashMap.this.keys[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeySet
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortCharOpenHashMap owner;

        public KeySet() {
            this.owner = ShortCharOpenHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return ShortCharOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            short[] localKeys = this.owner.keys;
            byte[] localStates = this.owner.states;
            for (int i = 0; i < localStates.length; ++i) {
                if (localStates[i] != 2) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            short[] localKeys = this.owner.keys;
            byte[] localStates = this.owner.states;
            for (int i = 0; i < localStates.length && (localStates[i] != 2 || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeySetIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(short e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    implements Iterator<ShortCharCursor> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final ShortCharCursor cursor = new ShortCharCursor();
        private int nextIndex = -1;

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < ShortCharOpenHashMap.this.keys.length && ShortCharOpenHashMap.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != ShortCharOpenHashMap.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public ShortCharCursor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.key = ShortCharOpenHashMap.this.keys[this.nextIndex];
            this.cursor.value = ShortCharOpenHashMap.this.values[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

