//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Plugin "Images mounting"
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef IMAGESMOUNTING_H
#define IMAGESMOUNTING_H

#include <QObject>
#include <QProcess>
#include "plugininterface.h"

class QWidget;
class QDialog;
class QDockWidget;
class QTextBrowser;
class QAction;
class QPushButton;
class QCheckBox;
class QLineEdit;

class ImagesMounting : public QObject, public MountManagerPlugin
{
	Q_OBJECT
	Q_INTERFACES(MountManagerPlugin)
	private slots:
		void chooseImage();
		void processFinished(int exitCode,QProcess::ExitStatus exitStatus);
		void chooseMountPoint();
		void mount();
		void unmount();
	signals:
		void showError(const QString &);
	private:
		QDialog *mainWidget;
		Actions actions;
		QPushButton *mountButton;
		QPushButton *unmountButton;
		QPushButton *closeButton;
		QLineEdit *imagePath;
		QLineEdit *mountPointPath;
		QPushButton *chooseImagePath;
		QPushButton *chooseMountPointPath;
		QCheckBox *openDirAfterMounting;

		QString homePath;
		QString imageType;
		QString tempIsoImagePath;
		QProcess *process;
		bool wasMounting;

		bool convert();
	public:
		ImagesMounting(QWidget *parent = 0);
		~ImagesMounting();

		void setParent(QObject *parent);

		const QString pluginName() const;
		const QString pluginDescription() const;
		
		QDialog* dialog() const;
		QDockWidget* dockWidget() const;
		QMenu* menu() const;
		QToolBar* toolBar() const;
		
		Actions menuActions() const;
};

#endif
