//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QtGui/QApplication>
#include <QtCore/QTranslator>
#include <QtCore/QSettings>
#include <QtCore/QLocale>
#include <QtCore/QDir>
#include "mainwindow.h"
#include "const.h"
#include "welcomedialog.h"


int main(int argc, char* argv[]) {
	QApplication application(argc,argv);

	QString Language = QLocale().name();
	Language = Language.remove(Language.indexOf("_"),Language.length());
		
	QDir transesDirectory(TRANS_PATH);
	foreach (QString transFileName,transesDirectory.entryList(QDir::Files))
		if (transFileName.split("_").last().contains(Language)) {
			QTranslator *translator = new QTranslator;
			translator->load(transesDirectory.filePath(transFileName));
			application.installTranslator(translator);
		}

	MainWindow mainWindow;

	QSettings settings(ORGANIZATION,PROGRAM_NAME);
	if (settings.value("ShowWelcome",true).toBool()) {
		WelcomeDialog welcomeDialog(&mainWindow);
		welcomeDialog.exec();
		settings.setValue("ShowWelcome",false);
	}

	return application.exec();
}
