//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef MENU_H
#define MENU_H

#include <QMenu>
#include <QString>

class QLabel;
class QWidgetAction;
class QFrame;

// This menu class can create header in top of menu
class Menu : public QMenu
{
	private:
		QString headerText;
		// Action on the top of menu
		QWidgetAction *headerAction;
		QFrame *headerActionFrame;
		QLabel *headerLabel;
		QLabel *iconLabel;
		int iconSize;
	public:
		Menu(bool useSpecialHeader = true);
		void setHeaderIcon(const QIcon &newHeaderIcon);
		void setHeaderText(const QString &newHeaderText);
};


#endif
