#include <QtGui/QToolButton>
#include <QtGui/QLineEdit>
#include <QtGui/QComboBox>
#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include "const.h"
#include "optionsforfswidget.h"

//=====================Class "Row" methods====================//

Row::Row(const QString& fileSystem,const QString& options) {
	
	fileSystemView = new QComboBox;
	fileSystemView->addItem("Fat","vfat");
	fileSystemView->addItem("Ntfs","ntfs");
	fileSystemView->addItem("Ext2","ext2");
	fileSystemView->addItem("Ext3","ext3");
	fileSystemView->addItem("ReiserFs","reiserfs");
	
	
	optionsView = new QLineEdit;
	
	removeRowButton = new QToolButton;
	removeRowButton->setAutoRaise(true);
	removeRowButton->setIcon(QIcon(ICONS_PATH"remove.png"));
	connect(removeRowButton,SIGNAL(clicked()),this,SLOT(hide()));
	
	QHBoxLayout *mainLayout = new QHBoxLayout;
	mainLayout->addWidget(fileSystemView);
	mainLayout->addWidget(optionsView,1);
	mainLayout->addWidget(removeRowButton);
	setLayout(mainLayout);
	
	setFileSystem(fileSystem);
	setOptions(options.isEmpty() ? "defaults" : options);
}

Row::~Row() {
	delete fileSystemView;
	delete optionsView;
	delete removeRowButton;
}

void Row::setFileSystem(const QString& fileSystem) {
	for (int i = 0; i < fileSystemView->count(); i++)
		if (fileSystemView->itemData(i).toString() == fileSystem)
			fileSystemView->setCurrentIndex(i);
}

void Row::setOptions(const QString& options) {
	optionsView->setText(options);
}

QString Row::getFileSystem() const {
	return fileSystemView->itemData(fileSystemView->currentIndex()).toString();
}

QString Row::getOptions() const {
	return optionsView->text();
}

//=====================Class "OptionsForFSWidget" methods====================//

OptionsForFSWidget::OptionsForFSWidget() {
	
	addRowButton = new QToolButton;
	addRowButton->setAutoRaise(true);
	addRowButton->setIcon(QIcon(ICONS_PATH"add.png"));
	connect(addRowButton,SIGNAL(clicked()),this,SLOT(addRow()));
	
	QHBoxLayout *addRowLayout = new QHBoxLayout;
	addRowLayout->addStretch();
	addRowLayout->addWidget(addRowButton);
	addRowLayout->addStretch();
	
	rowsLayout = new QVBoxLayout;
	rowsLayout->addLayout(addRowLayout);
	
	setLayout(rowsLayout);
	
	addRow();
}

OptionsForFSWidget::~OptionsForFSWidget() {
	clear();
}

void OptionsForFSWidget::updateRows() {
	for (int i = rows.count() - 1; i >= 0; i--)
		if (!rows[i]->isVisible())
			delete rows.takeAt(i);
	if (rows.count() == 0)
		addRow();
}

void OptionsForFSWidget::addRow() {
	addRow("","");
}

void OptionsForFSWidget::addRow(const QString& fileSystem,const QString& options) {
	Row *newRow = new Row(fileSystem,options);
	rowsLayout->insertWidget(rowsLayout->count()-1,newRow);
	connect(newRow->removeRowButton,SIGNAL(clicked()),this,SLOT(updateRows()));
	rows << newRow;
}

void OptionsForFSWidget::clear() {
	for (int i = rows.count() - 1; i >= 0; i--)
		delete rows.takeAt(i);
}

int OptionsForFSWidget::count() const {
	return rows.count();
}


QString OptionsForFSWidget::getFileSystem(int rowIndex) const {
	if (rowIndex >= 0 && rowIndex < rows.count())
		return rows[rowIndex]->getFileSystem();
	return QString();
}
QString OptionsForFSWidget::getOptions(int rowIndex) const {
	if (rowIndex >= 0 && rowIndex < rows.count())
		return rows[rowIndex]->getOptions();
	return QString();
}
