#include "xmlparser.h"
#include "base64.h"
#include <qfile.h>
#include <stdio.h>
#include <stdlib.h>
#include <qdom.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qregexp.h>

bool XMLParser::parse_rc()
{
	char s1[100];

#ifndef WIN32
	sprintf(s1, "%s/.mysqlnavigator.rc", getenv("HOME"));
#else
	sprintf(s1, "%s/.mysqlnavigator.rc", "c:");
#endif

	QFile s2(s1);

	if(s2.exists() == FALSE)
		return FALSE;
		
	if(s2.open(IO_ReadOnly) == FALSE)
		return FALSE;
	
	QDomDocument mysql("mysql");

	if(mysql.setContent(&s2) == FALSE)
	{
		s2.close();
		return FALSE;
	}

	s2.close();

	QDomNode node;
	QDomNodeList v;
	
	v = mysql.elementsByTagName("xpm");
	node = v.item(0);		
		
	if(node.isElement())
	{
		option->xpm= node.namedItem("file").firstChild().nodeValue();
	}
	
	v = mysql.elementsByTagName("password");
	node = v.item(0);		
	
	if(node.isElement())
		option->password = node.firstChild().nodeValue().toInt();
	
	v = mysql.elementsByTagName("schema");
	node = v.item(0);		
	
	if(node.isElement())
		option->schema = node.firstChild().nodeValue().toInt();
	
	v = mysql.elementsByTagName("exit");
	node = v.item(0);		
		
	if(node.isElement())
		option->exit = node.firstChild().nodeValue().toInt();

	v = mysql.elementsByTagName("from");
	node = v.item(0);		
		
	if(node.isElement())
		option->from = node.firstChild().nodeValue().toInt();

	v = mysql.elementsByTagName("to");
	node = v.item(0);		
		
	if(node.isElement())
		option->to = node.firstChild().nodeValue().toInt();

	v = mysql.elementsByTagName("style");
	if(v.count() != 0)	
		option->style = atoi(v.item(0).firstChild().nodeValue());
	
	v = mysql.elementsByTagName("width");
	if(v.count() != 0)	
		option->size.setWidth(atoi(v.item(0).firstChild().nodeValue()));
	
	v = mysql.elementsByTagName("height");
	if(v.count() != 0)	
		option->size.setHeight(atoi(v.item(0).firstChild().nodeValue()));

	// font
	v = mysql.elementsByTagName("save");
	node = v.item(0);		
	
	if(node.isElement())
		option->save = node.firstChild().nodeValue().toInt();

	v = mysql.elementsByTagName("font");
	node = v.item(0);		

	if(node.isElement())
	{
		QFont s;

		QDomNode z;
		z = node.firstChild();
		option->font.family = QString::fromLocal8Bit(z.firstChild().nodeValue());
		z = z.nextSibling();
		option->font.bold = z.firstChild().nodeValue().toInt();
		z = z.nextSibling();
		option->font.italic = z.firstChild().nodeValue().toInt();
		z = z.nextSibling();
		option->font.size = z.firstChild().nodeValue().toInt();
		z = z.nextSibling();
		option->font.strikeout = z.firstChild().nodeValue().toInt();
		z = z.nextSibling();
		option->font.underline = z.firstChild().nodeValue().toInt();

		if(option->font.family.isEmpty() == FALSE)
		{
			s.setFamily(option->font.family);
			s.setBold(option->font.bold);
			s.setItalic(option->font.italic);
			s.setPointSize(option->font.size);
			s.setStrikeOut(option->font.strikeout);
			s.setUnderline(option->font.underline);

			qApp->setFont(s, TRUE);
		}
	}


	// clear
	v = mysql.elementsByTagName("clear");
	node = v.item(0);		
		
	if(node.isElement())
		option->clear = atoi(v.item(0).firstChild().nodeValue());

	// log
	v = mysql.elementsByTagName("log");
	node = v.item(0);		
		
	if(node.isElement())
		option->log = atoi(v.item(0).firstChild().nodeValue());

	// server
	v = mysql.elementsByTagName("server");

	for(unsigned int s = 0; s < v.count(); s++)
	{
		struct server_data server;
		QString host;

		QDomNode node;

		node = v.item(s).firstChild();	// host node
		host = node.firstChild().nodeValue();

		node= node.nextSibling();	// user node
		server.user = node.firstChild().nodeValue();
					
		node= node.nextSibling();	// password node
		server.password = node.firstChild().nodeValue();
		if(server.password.at(0) == '$')
		{
			server.password = server.password.remove(0, 1);
			char *z = new char[server.password.length() + 1];
			FromBase64(z, (const void *)server.password.latin1(), server.password.length(), TRUE);
			server.password = z;
			delete []z;
		}
		
		node= node.nextSibling();	// database node
		server.database = node.firstChild().nodeValue();

		node= node.nextSibling();	// port node
		server.port = node.firstChild().nodeValue();
					
		node= node.nextSibling();	// socket node
		server.socket = node.firstChild().nodeValue();

		node= node.nextSibling();	// timeout node
		server.timeout = node.firstChild().nodeValue();
	
		if(server.timeout.toInt() == 0)
		{
			server.timeout = "30";
		}

		server_map->insert(server.user + "@" + host, server);	
	}

	/*
	switch(option->style)
	{
		case 0:
			slot_windows();
			break;
		case 1:
			slot_cde();
			break;
		case 2:
			slot_motif();
			break;
		case 3:
			slot_motif_plus();
			break;
		case 4:
			slot_platinum();
			break;
		case 5:
			slot_sgi();
			break;
		case 6:
			slot_jfc();
			break;
		case 7:
			slot_nextstep();
			break;
		default:
			slot_windows();
			break;
	}
	*/
	return TRUE;	
}

bool XMLParser::save_rc()
{
	QDomElement v;
	QDomElement s;
	QDomDocument z("mysql");

	z.appendChild(z.createElement("mysql"));	// document element

	// xpm
	z.documentElement().appendChild(v = z.createElement("xpm"));
	v.appendChild(s = z.createElement("file"));
	s.appendChild(z.createTextNode(option->xpm.simplifyWhiteSpace()));
	
	// schema
	z.documentElement().appendChild(v = z.createElement("schema"));
	v.appendChild(z.createTextNode(option->schema ? "1" : "0"));

	// password
	z.documentElement().appendChild(v = z.createElement("password"));
	v.appendChild(z.createTextNode(option->password ? "1" : "0"));

	// from
	z.documentElement().appendChild(v = z.createElement("from"));
	v.appendChild(z.createTextNode(QString::number(option->from)));	

	// to
	z.documentElement().appendChild(v = z.createElement("to"));
	v.appendChild(z.createTextNode(QString::number(option->to)));	

	// style
	z.documentElement().appendChild(v = z.createElement("style"));
	v.appendChild(z.createTextNode(QString::number(option->style)));	
	
	// size
	z.documentElement().appendChild(v = z.createElement("size"));
	v.appendChild(s = z.createElement("width"));
	s.appendChild(z.createTextNode(QString::number(option->size.width())));
	v.appendChild(s = z.createElement("height"));
	s.appendChild(z.createTextNode(QString::number(option->size.height())));

	// exit
	z.documentElement().appendChild(v = z.createElement("exit"));
	v.appendChild(z.createTextNode(option->exit ? "1" : "0"));

	// clear
	z.documentElement().appendChild(v = z.createElement("clear"));
	v.appendChild(z.createTextNode(option->clear ? "1" : "0"));

	// log
	z.documentElement().appendChild(v = z.createElement("log"));
	v.appendChild(z.createTextNode(option->log ? "1" : "0"));

	// server
	QMap<QString, struct server_data>::Iterator sql;
	for(sql = server_map->begin(); sql != server_map->end(); ++sql)
	{
		z.documentElement().appendChild(v = z.createElement("server"));
		v.appendChild(s = z.createElement("host"));
		s.appendChild(z.createTextNode(QString(sql.key()).replace(QRegExp(".*@"), "" )));
		v.appendChild(s = z.createElement("user"));
		s.appendChild(z.createTextNode(sql.data().user));
		v.appendChild(s = z.createElement("password"));
		if(option->password)
		{
			char *s_  = new char[sql.data().password.length() * 4 + 1];
			ToBase64(s_, (const void *)sql.data().password.latin1(), sql.data().password.length(), TRUE);
			s.appendChild(z.createTextNode(QString("$") + s_));
			delete []s_;
		}
		else
		{
			s.appendChild(z.createTextNode(""));
		}
		v.appendChild(s = z.createElement("database"));
		s.appendChild(z.createTextNode(sql.data().database));
		v.appendChild(s = z.createElement("port"));
		s.appendChild(z.createTextNode(sql.data().port));
		v.appendChild(s = z.createElement("socket"));
		s.appendChild(z.createTextNode(sql.data().socket));
		v.appendChild(s = z.createElement("timeout"));
		s.appendChild(z.createTextNode(sql.data().timeout));
	}

	// font
	z.documentElement().appendChild(v = z.createElement("save"));
	v.appendChild(z.createTextNode(option->save ? "1" : "0"));

	if(option->save)
	{
		QFont font = qApp->mainWidget()->font();

		option->font.family = font.family();
		option->font.bold = font.bold();
		option->font.italic = font.italic();
		option->font.size = font.pointSize();
		option->font.strikeout = font.strikeOut ();
		option->font.underline = font.underline();
	}

	z.documentElement().appendChild(v = z.createElement("font"));
	v.appendChild(s = z.createElement("family"));
	s.appendChild(z.createTextNode(option->font.family.local8Bit()));
	v.appendChild(s = z.createElement("bold"));
	s.appendChild(z.createTextNode(QString::number(option->font.bold)));
	v.appendChild(s = z.createElement("italic"));
	s.appendChild(z.createTextNode(QString::number(option->font.italic)));
	v.appendChild(s = z.createElement("size"));
	s.appendChild(z.createTextNode(QString::number(option->font.size)));
	v.appendChild(s = z.createElement("strikeout"));
	s.appendChild(z.createTextNode(QString::number(option->font.strikeout)));
	v.appendChild(s = z.createElement("underline"));
	s.appendChild(z.createTextNode(QString::number(option->font.underline)));
			
	char s1[100];

#ifndef WIN32
	sprintf(s1, "%s/.mysqlnavigator.rc", getenv("HOME"));
#else
	sprintf(s1, "%s/.mysqlnavigator.rc", "c:");
#endif

	QFile s2(s1);

	if(s2.open(IO_WriteOnly | IO_Truncate) == FALSE)
		return FALSE;
	
	s2.writeBlock(z.toString(), z.toString().length());

	s2.close();

	return TRUE;
}

