/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATWGT_H
#define CHATWGT_H

#include <QPushButton>
#include <QGridLayout>
#include <QTextEdit>
#include <QUdpSocket>
#include <QHostInfo>
#include <QLineEdit>
#include <QByteArray>
#include <QTabWidget>
#include <QColor>
#include <QSettings>
#include <QAction>
#include <QMenu>
#include <QMenuBar>
#include <QKeyEvent>
#include <QCloseEvent>
#include <QDialog>
#include <QTimer>
#include <QToolButton>
#include <QComboBox>
#include <QSplashScreen>
#include <QToolBar>
#include <QMainWindow>
#include <QTranslator>
#include <QLabel>
#include <QSystemTrayIcon>

#include <QCursor>

#include <QListWidget>

#include "messagewithcheckbox.h"

class LogWgt;
class AddChannelDlg;
class EditUserInfoDlg;
class PreferencesDlg;
class ChatCore;
class ChannelWgt;
class SmilesWgt;
class UserWgt;
class InputTextWgt;
class QChatTrayIcon;
class Message;
class SingleMsgsHistoryView;

struct QC_DatagramHeader;

/**
        @author Anistratov Oleg <ower@users.sourceforge.net>
*/
class ChatWgt : public QMainWindow
{
  Q_OBJECT
  friend class ChatCore;

  private:
    QLabel*       m_profilesLab;

    QTranslator*  m_translator;
    ChatCore*     m_chatCore;

    QToolButton*  m_addChannelBtn;
    QToolButton*  m_delChannelBtn;
    QComboBox*    m_profilesCmbx;

    QTabWidget*   mw_tabs;

    QToolBar*     m_mainToolBar;
    QToolBar*     m_profilesToolBar;
    QMenuBar*     m_menuBar;
    QMenu*        m_menuFile;
    QMenu*        m_menuView;
    QMenu*        m_menuSettings;
    QMenu*        m_menuHelp;
    QMenu*        m_menuTranslations;
    QMenu*        m_menuToolbars;

    QAction*      m_showSettingsAct;
    QAction*      m_showPreferencesAct;
    QAction*      m_showSmilesAct;
    QAction*      m_exitAct;
    QAction*      m_addChannelAct;
    QAction*      m_delChannelAct;
    QAction*      m_aboutAct;
    QAction*      m_aboutQtAct;
    QAction*      m_licenseAct;
    QAction*      m_writeSettingsAct;
    QAction*      m_addProfileAct;
    QAction*      m_deleteProfileAct;
    QAction*      m_renameProfileAct;
    QAction*      m_translatePlAct;
    QAction*      m_translateUkAct;
    QAction*      m_translateRuAct;
    QAction*      m_translateEnAct;
    QAction*      m_showMainTBarAct;
    QAction*      m_showProfilesTBarAct;
    QAction*      m_showSingleMessagesAct;

    LogWgt*       mw_log;
    SmilesWgt*    mw_smiles;
    ChannelWgt**  mw_channels;
    int           m_channelsNum;
    SingleMsgsHistoryView*  m_singleMessagesHistoryView;

    AddChannelDlg*             m_addChannelDlg;
    EditUserInfoDlg*           m_userInfoDlg;
    PreferencesDlg*            m_preferencesDlg;

    QChatTrayIcon* m_trayIcon;

    QTimer* m_activityTimer;
    int m_cursorX;
    int m_cursorY;

  public:
    ChatWgt(ChatCore* chc, QWidget* parent = 0);
    ~ChatWgt();

    QString currentChannelName() const ;
    int  findChannel(const QString & name   , quint32 = 0) const ;
    int  findChannel(const QHostAddress & ip, quint32 = 0) const ;
    void fillProfilesCmbx(const QStringList & profiles, const QString & current);

    ChannelWgt* channel(uint idx){if(idx >= (uint)m_channelsNum) return NULL; return mw_channels[idx];}
    const QList<ChannelWgt*> channels() const
    {QList<ChannelWgt*> l; for(int i = 0; i < m_channelsNum; i++) l.append(mw_channels[i]); return l;}

    void createActions();
    void createWidgets();
    void setupLayout  ();
    void retranslate  ();

    void createChannel(const QString &, const QHostAddress & = QHostAddress(0xffffffff));

    QMenu* createPopupMenu();
    void restoreAndShow();

  public slots:
    void setLanguage();

    void slot_setIP          (const QString &);
    void slot_setUsername    (const QString &);

    void slot_addChannell    (const QString & name){createChannel(name);}
    void slot_privateChat    (const QString & name, const QHostAddress & addr){createChannel(name, addr);}
    void slot_delChannell    ();
    void slot_sendFile       (const QHostAddress & addr);
    void slot_receiveFile    (const QString &, quint16, quint64);
    void slot_singleMessageIn(Message*);
    void slot_about();
    void slot_aboutQt();
    void slot_license();
    void slot_showSettings();
    void slot_showPreferences();
    void slot_showUserInfo(UserWgt*);
    void slot_showSmiles();
    void slot_activateWindow();

    void slot_insertSmile(const QString &);
    void slot_openSocketError(quint16);
    void slot_exit();
    void slot_trayIconClicked(QSystemTrayIcon::ActivationReason);

    void slot_setCurrentProfileName(const QString &);
    void slot_reloadProfileData    ();

    void slot_editProfileName();
    void slot_addProfile     ();
    void slot_delProfile     ();
    void slot_changeSmileTheme(const QString &);
    void slot_focusChanged(QWidget*, QWidget*);
    void slot_processData(QC_DatagramHeader*);

    void activity();

    void slot_showSingleMessagesHistory();

    void showSingleMessage(int);

  protected:
    void keyPressEvent(QKeyEvent * ev)
    {
      if((ev->key      () ==  Qt::Key_A) &&
         (ev->modifiers() == (Qt::ShiftModifier|Qt::ControlModifier)))
        slot_about();
      QWidget::keyPressEvent(ev);
    }
    void mousePressEvent(QMouseEvent * ev){ QWidget::mousePressEvent(ev);}
    void closeEvent(QCloseEvent* ev);

  signals:
    void singleMessageOut (const QString &, const QHostAddress &);
    void singleMessage    (const QString &, const QHostAddress &);
    void closed           ();
    void wantLoadProfile  (const QString &);
    void wantRenameProfile(const QString &, const QString &);
    void wantDeleteProfile(const QString &);
    void wantChangeStyleSheet(const QString &);
};

#endif
