/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef LARGEDATAGRAMOUT_H
#define LARGEDATAGRAMOUT_H

#include <QObject>
#include <QHostAddress>
#include <QUdpSocket>
#include <QTimer>
#include <QFile>

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class LargeDatagramOut : public QObject
{
  Q_OBJECT
  private:
    quint32      m_id;
    QHostAddress m_destAddr;
    QString      m_filename;
    QFile        m_file;
    bool         m_confirmed;
    bool         m_inited;
    bool         m_rest;
    quint16      m_headerSize;
    quint32      m_dataSize;
    quint64      m_fileSize;
    quint32      m_sizePerFragment;
    quint32      m_totalFragments;
    quint32      m_fragmentsRemain;
    char*        m_header;
    char*        m_data;
    char*        m_fragments; /// pokazyvaet kakie fragmenty otoslany
    QTimer*      m_selfDestroyTimer;
    quint32      m_selfDestroyInterval;

  public:
    LargeDatagramOut(QObject *parent = 0);
    ~LargeDatagramOut();

    const QHostAddress & addr() const {return m_destAddr;}
    bool    complete         () const {return !m_fragmentsRemain;}
    quint32 id               () const {return m_id;}

    void init(char* hdr, quint16 hdr_sz, char* data, quint32 data_sz, const QHostAddress & addr, quint32 ID);
    void init(char* hdr, quint16 hdr_sz, const QString & filename   , const QHostAddress & addr, quint32 ID);

    void prepareInitHeader();
    void fragmentsRequest (const char* , quint16);
    void sendNextFragment (QUdpSocket* socket, quint16 port, char* buf);
    void acceptSending    (){m_confirmed = true;}
    quint32 writeFragment (char* buf, quint32 num);

  public slots:
    void selfDestroy();
    void slot_confirmed(unsigned short ID);

  signals:
    void wantDie         (LargeDatagramOut*);
    void sendingCancelled(quint16);

};

#endif
