/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "nlamarok.h"

#include <QProcess>

NLAmarok::NLAmarok(QObject *parent)
 : QObject   (parent),
  m_updated  (false),
  m_artist   (""),
  m_album    (""),
  m_title    (""),
  m_nRequests(0)
{
  m_processArtist = new QProcess(this);
  m_processAlbum  = new QProcess(this);
  m_processTitle  = new QProcess(this);
  m_updateTimer   = new QTimer  (this);

  connect(m_updateTimer  , SIGNAL(timeout()) , this, SLOT(update()));
  connect(m_processAlbum , SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(updateAlbum(int)));
  connect(m_processArtist, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(updateArtist(int)));
  connect(m_processTitle , SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(updateTitle(int)));

  m_updateTimer->start(5 * 1000);
}

NLAmarok::~NLAmarok()
{
}

void NLAmarok::requestArtist()
{
  if(!m_processArtist->pid())
  {
    m_processArtist->start("dcop amarok player artist");
    m_nRequests++;
  }
}

void NLAmarok::requestAlbum()
{
  if(!m_processAlbum->pid())
  {
    m_processAlbum->start("dcop amarok player album");
    m_nRequests++;
  }
}
void NLAmarok::requestTitle()
{
  if(!m_processTitle->pid())
  {
    m_processTitle->start("dcop amarok player title");
    m_nRequests++;
  }
}

void NLAmarok::updateArtist(int code)
{
  if(!code)
  {
    QString str;
    str = QString().fromUtf8(m_processArtist->readAllStandardOutput());

    if(str[str.size() - 1] == '\n')
      str.remove(str.size() - 1, 1);

    if(str != m_artist)
    {
      m_artist = str;
      m_updated = true;
    }
  }

  m_nRequests--;

  if(!m_nRequests && m_updated)
  {
    emit updated(m_title, m_artist, m_album);
    m_updated = false;
  }
}

void NLAmarok::updateAlbum(int code)
{
  if(!code)
  {
    QString str;
    str = QString().fromUtf8(m_processAlbum->readAllStandardOutput());

    if(str[str.size() - 1] == '\n')
      str.remove(str.size() - 1, 1);

    if(str != m_album)
    {
      m_album = str;
      m_updated = true;
    }
  }

  m_nRequests--;

  if(!m_nRequests && m_updated)
  {
    emit updated(m_title, m_artist, m_album);
    m_updated = false;
  }
}

void NLAmarok::updateTitle (int code)
{
  if(!code)
  {
    QString str;
    str = QString().fromUtf8(m_processTitle->readAllStandardOutput());

    if(str[str.size() - 1] == '\n')
      str.remove(str.size() - 1, 1);

    if(str != m_title)
    {

      m_title = str;
      m_updated = true;
    }
  }

  m_nRequests--;

  if(!m_nRequests && m_updated)
  {
    emit updated(m_title, m_artist, m_album);
    m_updated = false;
  }

}
