/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef PREFERENCESDLG_H
#define PREFERENCESDLG_H

#include <QDialog>

#include <QLayout>
#include <QLabel>
#include <QColorDialog>
#include <QPixmap>
#include <QPushButton>
#include <QCheckBox>
#include <QSpinBox>
#include <QLineEdit>
#include <QComboBox>
#include <QGroupBox>
#include <QListWidget>
#include <QListWidgetItem>
#include <QStackedWidget>
#include <QEvent>
#include <QDir>
#include <QNetworkAddressEntry>

class Globals;
class ColorLabel;
class EditStatusDescriptionsDlg;

/**
        @author Anistratov Oleg <ower@users.sourceforge.net>
*/
class PreferencesDlg : public QDialog
{
  Q_OBJECT
  public:
    enum Sections{Network, Messages, Smiles, Misc, StyleSheets};

  private:
    QListWidget*     m_sectionsChooser;

    QListWidgetItem* m_networkSection;
    QListWidgetItem* m_messagesSection;
    QListWidgetItem* m_profileSection;
    QListWidgetItem* m_miscSection;
    QListWidgetItem* m_smilesSection;
    QListWidgetItem* m_styleSheetsSection;

    QStackedWidget*  m_sections;

    QGroupBox*    m_colorsGrbx;
    QGroupBox*    m_networkGrbx;
    QGroupBox*    m_miscGrbx;
    QGroupBox*    m_nowListeningGrbx;
    QGroupBox*    m_smilesThemesGrbx;
    QGroupBox*    m_usersListGrbx;
    QGroupBox*    m_styleSheetsGrbx;

    QString       m_profileName;
    ColorLabel*   m_myColor;
    ColorLabel*   m_sysColor;
    ColorLabel*   m_baseColor;
    QPushButton*  m_okBtn;
    QPushButton*  m_cancelBtn;
    QPushButton*  m_applyBtn;
    QColorDialog* m_colorDlg;

    QCheckBox*    m_colorWholeMsgChbx;
    QCheckBox*    m_colorWholeSysMsgChbx;
    QCheckBox*    m_activateOnMsgInChbx;
    QCheckBox*    m_soundOnMsgInChbx;

    QSpinBox*     m_portInSpbx;
    QSpinBox*     m_portOutSpbx;
    QLineEdit*    m_ipEdit;

    QLineEdit*    m_commandOnIncomingEdit;
    QCheckBox*    m_isCommandOnIncomingChbx;

    QLineEdit*    m_broadcastEdit;
    QComboBox*    m_networkIfCmbx;

    // Now listening
    QCheckBox*    m_nlWithMessageChbx;
    QCheckBox*    m_nlInStatusChbx;
    QLineEdit*    m_nlFormatEdit;

    // Smile theme switcher
    QListWidget*  m_smilesThemeChooser;
    QStringList   m_smilesThemes;

    // Style Sheets
    QListWidget*  m_styleSheetsChooser;
    QStringList   m_styleSheets;

    QLabel*       m_portOutLab;
    QLabel*       m_portInLab;
    QLabel*       m_myColorLab;
    QLabel*       m_sysColorLab;
    QLabel*       m_baseColorLab;
    QLabel*       m_ipLab;
    QLabel*       m_broadcastLab;
    QLabel*       m_nlFormatLab;
    QLabel*       m_displayMsgFmtLab;
    QLabel*       m_msgsHistoryIntervalLab;
    QLabel*       m_msgsHistoryNumLab;
    QLabel*       m_ulRefreshIntervalLab;
    QLabel*       m_ulDeepRefreshIntervalLab;
    QLabel*       m_networkIfLab;

    bool          m_edited;
    quint16       m_oldPortIn;
    QLineEdit*    m_displayMsgFmtEdit;
    QSpinBox*     m_msgsHistoryIntervalSpbx;
    QSpinBox*     m_msgsHistoryNumSpbx;
    QSpinBox*     m_ulRefreshIntervalSpbx;
    QSpinBox*     m_ulDeepRefreshIntervalSpbx;

    QVector<QNetworkAddressEntry> m_addressEntries;

  private:
    void emoticonsThemesFromDir(QDir);
    void styleSheetsFromDir(QDir);

  public:
    PreferencesDlg(QWidget *parent = 0);
    ~PreferencesDlg();

    void retranslate();

    void createWidgets();
    void setupConnections();
    void init();

    QWidget* setupSectionLayout(QList<QWidget*>);
    QWidget* setupSectionLayout(QWidget*, bool = true);

    void setupSections();
    void reloadSmileThemeList();
    void toggleVisible(){if(isHidden()) show(); else hide();}
    void reloadStyleSheetsList();

  public slots:
    void slot_chooseColor();
    void slot_edited();
    void slot_setPrefs();
    void slot_accept(){accept();}
    void slot_cancel();
    void slot_validateIp(const QString &);
    void slot_setMsgColorMode   (int mode);
    void slot_setSysMsgColorMode(int mode);
    void slot_setActivateOnMsgIn(int mode);
    void slot_setSoundOnMsgIn   (int mode);
    void slot_setNlWithMessage  (int mode);
    void slot_setNlInStatus     (int mode);
    void slot_setExecuteCommandMode(int);

    void slot_activateSection(int idx);
    void reloadNetworkIfs();
    void setNetworkIf(int);

  protected:
    void changeEvent(QEvent *ev)
    {
      if(ev->type() == QEvent::LanguageChange)
        retranslate();
      else
        QDialog::changeEvent(ev);
    }

  signals:
    void myColor  (const QColor &);
    void sysColor (const QColor &);
    void baseColor(const QColor &);
    void portChanged(int);
    void ipTextChanged(const QString &);
    void wantChangeSmileTheme(const QString &);
    void ulRefreshIntervalChanged(uint);
    void ulDeepRefreshIntervalChanged(uint);
    void styleSheetChanged(const QString &);
};

#endif
