/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "singlemsgshistoryview.h"

#include <QGridLayout>
#include <QDateTime>
#include <QListWidgetItem>

#include "message.h"

SingleMsgsHistoryView::SingleMsgsHistoryView(QWidget *parent)
 : QWidget(parent)
{
  QGridLayout* grid = new QGridLayout(this);
  m_listWgt = new QListWidget(this);

  grid->addWidget(m_listWgt, 0, 0);

  grid->setMargin(0);

  connect(m_listWgt, SIGNAL(itemDoubleClicked(QListWidgetItem*)), this, SLOT(slot_itemDoubleClicked()));

  resize(400, 400);
}

SingleMsgsHistoryView::~SingleMsgsHistoryView()
{
}

void SingleMsgsHistoryView::slot_itemDoubleClicked()
{
  emit wantViewMessage(m_listWgt->currentRow());
}

void SingleMsgsHistoryView::appendMsg(const Message* msg)
{
  QListWidgetItem* item = new QListWidgetItem;
  QDateTime dt;
  dt.setTime_t(msg->receiveTime());

  QString title = dt.toString("hh:mm:ss(dd.MM.yy)") + "   " + msg->userName() + "[" + QHostAddress(msg->srcIp()).toString() + "] :  " + "\"" + msg->msg().left(50);

  if(msg->msg().size() > 50)
    title += "...";

  title.replace("\n", " ");
  title += "\"";

  item->setData(Qt::DisplayRole, title);

  title = msg->msg().left(500);
  if(msg->msg().size() > 500)
    title += "...";

  item->setData(Qt::ToolTipRole, title);

  m_listWgt->addItem(item);
}


