/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef USERSLISTWGT_H
#define USERSLISTWGT_H

#include <QListWidget>
#include <QMenu>
#include <QAction>
#include <QHostAddress>
#include <QEvent>

class UserWgt;

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class UsersListWgt : public QListWidget
{
  Q_OBJECT
  friend class ChannelWgt;

  private:
    QMenu*   m_menu;
    QAction* m_singleMessageAct;
    QAction* m_showInfoAct;
    QAction* m_sendFileAct;
    QAction* m_privateChatAct;

  public:
    UsersListWgt (QWidget *parent = 0);
    ~UsersListWgt();

    void retranslate();

    void hideUser(UserWgt*);
    void addUser (UserWgt*);
    void clear   ();

  public slots:
    void send_itemDoubleClicked(QListWidgetItem* item);
    void slot_singleMessage();
    void slot_sendFile     ();
    void slot_privateChat  ();

  signals:
    void itemDoubleClicked(UserWgt*);
    void singleMessage    (const QString &, const QHostAddress &);
    void wantPrivateChat  (const QString &, const QHostAddress &);
    void wantSendFile     (const QHostAddress &);

  protected:
    void mousePressEvent (QMouseEvent * ev);
    void changeEvent(QEvent *ev)
    {
      if(ev->type() == QEvent::LanguageChange)
        retranslate();
      else
        QListWidget::changeEvent(ev);
    }
};

#endif
