/*
 * Decompiled with CFR 0.152.
 */
package king.points;

import driftwood.r3.Transform;
import java.awt.Color;
import java.awt.Paint;
import king.core.Engine;
import king.core.Engine2D;
import king.core.KPaint;
import king.core.KPoint;
import king.points.AbstractPoint;

public class VectorPoint
extends AbstractPoint {
    protected VectorPoint from = null;
    protected int width = 0;

    public VectorPoint(String string, VectorPoint vectorPoint) {
        super(string);
        this.setPrev(vectorPoint);
    }

    public void setPrev(KPoint kPoint) {
        super.setPrev(kPoint);
        this.from = (VectorPoint)kPoint;
    }

    public VectorPoint getPrev() {
        return this.from;
    }

    public boolean isBreak() {
        return this.from == null;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n > 7 ? 7 : (n < 0 ? 0 : n);
        this.fireKinChanged(512);
    }

    public void doTransform(Engine engine, Transform transform, double d) {
        transform.transform(this, engine.work1);
        this.setDrawXYZ(engine.work1);
        if (this.from != null) {
            if (this.from.z < this.z && (double)this.from.z <= engine.clipFront && (double)this.z >= engine.clipBack) {
                engine.addPaintable(this, (Math.max((double)this.from.z, engine.clipBack) + Math.min((double)this.z, engine.clipFront)) / 2.0);
            } else if ((double)this.from.z >= engine.clipBack && (double)this.z <= engine.clipFront) {
                engine.addPaintable(this, (Math.max((double)this.z, engine.clipBack) + Math.min((double)this.from.z, engine.clipFront)) / 2.0);
            }
        } else {
            engine.addPaintable(this, this.z);
        }
    }

    public KPoint isPickedBy(float f, float f2, float f3, boolean bl) {
        if (bl && this.from != null) {
            float f4;
            float f5;
            double d;
            double d2;
            VectorPoint vectorPoint = this;
            VectorPoint vectorPoint2 = this.from;
            if (f > Math.min(vectorPoint.x, vectorPoint2.x) - f3 && f < Math.max(vectorPoint.x, vectorPoint2.x) + f3 && f2 > Math.min(vectorPoint.y, vectorPoint2.y) - f3 && f2 < Math.max(vectorPoint.y, vectorPoint2.y) + f3 && (d2 = (d = (double)((f5 = vectorPoint2.y - vectorPoint.y) * f + (f4 = vectorPoint.x - vectorPoint2.x) * f2 - (f5 * vectorPoint.x + f4 * vectorPoint.y))) * d / (double)(f5 * f5 + f4 * f4)) < (double)(f3 * f3)) {
                return this;
            }
        }
        return super.isPickedBy(f, f2, f3, bl);
    }

    public void paint2D(Engine2D engine2D) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        boolean bl;
        if (this.from == null || this.x0 == this.from.x0 && this.y0 == this.from.y0 && this.z0 == this.from.z0) {
            return;
        }
        KPaint kPaint = this.getDrawingColor(engine2D);
        if (kPaint.isInvisible()) {
            return;
        }
        int n = this.parent == null ? 255 : this.parent.getAlpha();
        Color color = kPaint.getPaint(engine2D.backgroundMode, 1.0, engine2D.colorCue, n);
        if (this.from.z < this.z) {
            bl = false;
            d12 = this.from.x;
            d11 = this.from.y;
            d10 = this.from.z;
            d9 = engine2D.getShortening(this.from);
            d8 = this.x;
            d7 = this.y;
            d6 = this.z;
            d5 = engine2D.getShortening(this);
        } else {
            bl = true;
            d8 = this.from.x;
            d7 = this.from.y;
            d6 = this.from.z;
            d5 = engine2D.getShortening(this.from);
            d12 = this.x;
            d11 = this.y;
            d10 = this.z;
            d9 = engine2D.getShortening(this);
        }
        double d13 = d6 - d10;
        double d14 = (d8 - d12) / d13;
        double d15 = (d7 - d11) / d13;
        double d16 = engine2D.clipBack - d10;
        double d17 = engine2D.clipFront - d6;
        if (d9 > 0.0) {
            d4 = Math.sqrt(d9 * d9 / ((d14 * d14 + d15 * d15 + 1.0) * d13 * d13));
            d3 = d4 * d13;
            d2 = d3 * d14;
            d = d3 * d15;
            if (d3 > d16) {
                d12 += d2;
                d11 += d;
                d10 += d3;
            } else if (d10 < engine2D.clipBack) {
                d12 += d14 * d16;
                d11 += d15 * d16;
                d10 = engine2D.clipBack;
            }
        } else if (d10 < engine2D.clipBack) {
            d12 += d14 * d16;
            d11 += d15 * d16;
            d10 = engine2D.clipBack;
        }
        if (d5 > 0.0) {
            d4 = Math.sqrt(d5 * d5 / ((d14 * d14 + d15 * d15 + 1.0) * d13 * d13));
            d3 = d4 * d13;
            d2 = d3 * d14;
            d = d3 * d15;
            if (d3 > -d17) {
                d8 -= d2;
                d7 -= d;
                d6 -= d3;
            } else if (d6 > engine2D.clipFront) {
                d8 += d14 * d17;
                d7 += d15 * d17;
                d6 = engine2D.clipFront;
            }
        } else if (d6 > engine2D.clipFront) {
            d8 += d14 * d17;
            d7 += d15 * d17;
            d6 = engine2D.clipFront;
        }
        if (bl) {
            this.paintStandard2(engine2D, color, d8, d7, d6, d12, d11, d10);
        } else {
            this.paintStandard2(engine2D, color, d12, d11, d10, d8, d7, d6);
        }
    }

    protected void paintStandard2(Engine2D engine2D, Paint paint, double d, double d2, double d3, double d4, double d5, double d6) {
        int n = this.calcLineWidth(engine2D);
        engine2D.painter.paintVector(paint, n, engine2D.widthCue, d, d2, d3, d4, d5, d6);
    }

    protected int calcLineWidth(Engine engine) {
        if (engine.thinLines) {
            return 1;
        }
        int n = 2;
        if (this.width > 0) {
            n = this.width;
        } else if (this.parent != null) {
            n = this.parent.getWidth();
        }
        return n;
    }
}

