/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import org.chromium.devtools.jsdoc.ValidationCheck;
import org.chromium.devtools.jsdoc.ValidatorContext;
import org.chromium.devtools.jsdoc.checks.AstUtil;
import org.chromium.devtools.jsdoc.checks.ContextTrackingChecker;
import org.chromium.devtools.jsdoc.checks.ContextTrackingState;
import org.chromium.devtools.jsdoc.checks.DisallowedGlobalPropertiesChecker;
import org.chromium.devtools.jsdoc.checks.FunctionReceiverChecker;
import org.chromium.devtools.jsdoc.checks.FunctionRecord;
import org.chromium.devtools.jsdoc.checks.MethodAnnotationChecker;
import org.chromium.devtools.jsdoc.checks.ProtoFollowsExtendsChecker;
import org.chromium.devtools.jsdoc.checks.TypeRecord;

public class ContextTrackingValidationCheck
extends ValidationCheck {
    private ContextTrackingState state;
    private final List<ContextTrackingChecker> clients = new ArrayList<ContextTrackingChecker>(5);

    @Override
    protected void setContext(ValidatorContext validatorContext) {
        super.setContext(validatorContext);
        this.state = new ContextTrackingState(validatorContext);
        this.registerClient(new ProtoFollowsExtendsChecker());
        this.registerClient(new MethodAnnotationChecker());
        this.registerClient(new FunctionReceiverChecker());
        this.registerClient(new DisallowedGlobalPropertiesChecker());
    }

    @Override
    public void doVisit(Node node) {
        switch (node.getToken()) {
            case ASSIGN: 
            case VAR: {
                this.enterAssignOrVarNode(node);
                break;
            }
            case FUNCTION: {
                this.enterFunctionNode(node);
                break;
            }
        }
        this.enterNode(node);
    }

    @Override
    public void didVisit(Node node) {
        this.leaveNode(node);
        switch (node.getToken()) {
            case ASSIGN: {
                this.leaveAssignNode(node);
                break;
            }
            case FUNCTION: {
                this.leaveFunctionNode(node);
                break;
            }
        }
    }

    public void registerClient(ContextTrackingChecker contextTrackingChecker) {
        this.clients.add(contextTrackingChecker);
        contextTrackingChecker.setState(this.state);
    }

    private void enterNode(Node node) {
        for (ContextTrackingChecker contextTrackingChecker : this.clients) {
            contextTrackingChecker.enterNode(node);
        }
    }

    private void leaveNode(Node node) {
        for (ContextTrackingChecker contextTrackingChecker : this.clients) {
            contextTrackingChecker.leaveNode(node);
        }
    }

    private void enterFunctionNode(Node node) {
        TypeRecord typeRecord = this.state.getCurrentFunctionRecord() == null ? this.state.getCurrentTypeRecord() : null;
        Node node2 = AstUtil.getFunctionNameNode(node);
        String string = node2 == null ? null : this.state.getNodeText(node2);
        FunctionRecord functionRecord = new FunctionRecord(node, string, this.getFunctionParameterNames(node), typeRecord, this.state.getCurrentFunctionRecord());
        this.state.pushFunctionRecord(functionRecord);
        this.rememberTypeRecordIfNeeded(string, functionRecord.info);
    }

    private void leaveFunctionNode(Node node) {
        this.state.functionRecords.removeLast();
    }

    private void enterAssignOrVarNode(Node node) {
        String string = this.getAssignedTypeName(node);
        if (string == null) {
            return;
        }
        if (AstUtil.isPrototypeName(string)) {
            String string2 = AstUtil.getTypeNameFromPrototype(string);
            TypeRecord typeRecord = this.state.typeRecordsByTypeName.get(string2);
            this.state.pushTypeRecord(typeRecord);
            this.state.pushFunctionRecord(null);
            return;
        }
    }

    private void leaveAssignNode(Node node) {
        String string = this.getAssignedTypeName(node);
        if (string == null) {
            return;
        }
        if (AstUtil.isPrototypeName(string)) {
            this.state.typeRecords.removeLast();
            this.state.functionRecords.removeLast();
            return;
        }
    }

    private String getAssignedTypeName(Node node) {
        Node node2 = AstUtil.getAssignedTypeNameNode(node);
        return this.getNodeText(node2);
    }

    private List<String> getFunctionParameterNames(Node node) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Node node2 = NodeUtil.getFunctionParameters(node);
        int n = node2.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node node3 = node2.getChildAtIndex(i);
            String string = this.state.getContext().getNodeText(node3);
            if ("...".equals(string)) continue;
            String string2 = string.split("=")[0].trim();
            arrayList.add(string2);
        }
        return arrayList;
    }

    private boolean rememberTypeRecordIfNeeded(String string, JSDocInfo jSDocInfo) {
        if (jSDocInfo == null) {
            return false;
        }
        if (string == null) {
            return jSDocInfo.isConstructor() || jSDocInfo.isInterface();
        }
        if (!jSDocInfo.isConstructor() && !jSDocInfo.isInterface()) {
            return false;
        }
        TypeRecord typeRecord = new TypeRecord(string, jSDocInfo);
        this.state.typeRecordsByTypeName.put(string, typeRecord);
        return true;
    }
}

