// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This header is hand-written, whereas most CSSProperty subclass
// headers are generated by core/css/properties/templates/Subclass.h.tmpl.
// CSSPropertyVariable is treated as a CSS properties in some places for
// convenience but is not really a CSS property.
#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_CSS_PROPERTIES_LONGHANDS_VARIABLE_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_CSS_PROPERTIES_LONGHANDS_VARIABLE_H_

#include "third_party/blink/renderer/core/css/properties/longhand.h"

namespace blink {

class Variable final : public Longhand {
 public:
  constexpr Variable() : Longhand() {}

  bool IsInherited() const override { return true; }
  bool IsAffectedByAll() const override { return false; }
  CSSPropertyID PropertyID() const override { return CSSPropertyVariable; }
  const char* GetPropertyName() const override { return "variable\0"; }
  const WTF::AtomicString& GetPropertyNameAtomicString() const override {
    static const WTF::AtomicString& name = WTF::AtomicString("variable\0");
    return name;
  }
  const CSSValue* CSSValueFromComputedStyleInternal(
      const ComputedStyle&,
      const SVGComputedStyle&,
      const LayoutObject*,
      Node*,
      bool allow_visited_style) const override {
    NOTREACHED();
    return nullptr;
  }

  void ApplyValue(StyleResolverState& state,
                  const CSSValue& value) const override;
};

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_CSS_PROPERTIES_LONGHANDS_VARIABLE_H_
