/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "third_party/blink/public/web/web_crypto_normalize.h"

#include "third_party/blink/public/platform/web_string.h"
#include "third_party/blink/renderer/bindings/core/v8/dictionary.h"
#include "third_party/blink/renderer/modules/crypto/crypto_result_impl.h"
#include "third_party/blink/renderer/modules/crypto/normalize_algorithm.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/crypto_result.h"
#include "v8/include/v8.h"

namespace blink {

WebCryptoAlgorithm NormalizeCryptoAlgorithm(
    v8::Local<v8::Object> algorithm_object,
    WebCryptoOperation operation,
    int* exception_code,
    WebString* error_details,
    v8::Isolate* isolate) {
  // FIXME: Avoid using NonThrowableExceptionState.
  NonThrowableExceptionState exception_state;
  Dictionary algorithm_dictionary(isolate, algorithm_object, exception_state);
  if (!algorithm_dictionary.IsUndefinedOrNull() &&
      !algorithm_dictionary.IsObject())
    return WebCryptoAlgorithm();
  WebCryptoAlgorithm algorithm;
  AlgorithmError error;
  AlgorithmIdentifier algorithm_identifier;
  algorithm_identifier.SetDictionary(algorithm_dictionary);
  if (!NormalizeAlgorithm(algorithm_identifier, operation, algorithm, &error)) {
    *exception_code = WebCryptoErrorToExceptionCode(error.error_type);
    *error_details = error.error_details;
    return WebCryptoAlgorithm();
  }

  return algorithm;
}

}  // namespace blink
