// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_DOM_EVENTS_EVENT_TARGET_IMPL_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_DOM_EVENTS_EVENT_TARGET_IMPL_H_

#include "third_party/blink/renderer/core/dom/context_lifecycle_observer.h"
#include "third_party/blink/renderer/core/dom/events/event_target.h"
#include "third_party/blink/renderer/platform/bindings/script_wrappable.h"

class ScriptState;

namespace blink {

// Constructible version of EventTarget. Calls to EventTarget
// constructor in JavaScript will return an instance of this class.
// We don't use EventTarget directly because EventTarget is an abstract
// class and and making it non-abstract is unfavorable  because it will
// increase the size of EventTarget and all of its subclasses with code
// that are mostly unnecessary for them, resulting in a performance
// decrease.
class CORE_EXPORT EventTargetImpl final : public EventTargetWithInlineData,
                                          public ContextLifecycleObserver {
  USING_GARBAGE_COLLECTED_MIXIN(EventTargetImpl);

 public:
  static EventTargetImpl* Create(ScriptState*);

  ~EventTargetImpl() override = default;

  const AtomicString& InterfaceName() const override;
  ExecutionContext* GetExecutionContext() const override;
  void Trace(blink::Visitor*) override;

 private:
  EventTargetImpl(ScriptState*);
};

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_DOM_EVENTS_EVENT_TARGET_IMPL_H_
