/* -*- mode: c++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 Copyright (C) 2010 Klaus Spanderen

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it
 under the terms of the QuantLib license.  You should have received a
 copy of the license along with this program; if not, please email
 <quantlib-dev@lists.sf.net>. The license is also available online at
 <http://quantlib.org/license.shtml>.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

/*! \file fdmbatesop.hpp
    \brief Bates linear operator
*/

#ifndef quantlib_fdm_bates_op_hpp
#define quantlib_fdm_bates_op_hpp

#include <ql/processes/batesprocess.hpp>
#include <ql/math/integrals/gaussianquadratures.hpp>
#include <ql/experimental/finitedifferences/fdmhestonop.hpp>
#include <ql/experimental/finitedifferences/fdmdirichletboundary.hpp>

namespace QuantLib {

    class LinearInterpolation;
    
    class FdmBatesOp : public FdmLinearOpComposite {
      public:
        FdmBatesOp(
            const boost::shared_ptr<FdmMesher>& mesher,
            const boost::shared_ptr<BatesProcess>& batesProcess,
            const FdmBoundaryConditionSet& bcSet,
            Size integroIntegrationOrder,
            const boost::shared_ptr<FdmQuantoHelper>& quantoHelper
                                        = boost::shared_ptr<FdmQuantoHelper>());

        Size size() const;
        void setTime(Time t1, Time t2);

        Disposable<Array> apply(const Array& r) const;
        Disposable<Array> apply_mixed(const Array& r) const;

        Disposable<Array> apply_direction(Size direction,
                                          const Array& r) const;
        Disposable<Array> solve_splitting(Size direction,
                                          const Array& r, Real s) const;
        Disposable<Array> preconditioner(const Array& r, Real s) const;

      private:
        class IntegroIntegrand {
          public:
            IntegroIntegrand(const boost::shared_ptr<LinearInterpolation>& i,
                             const FdmBoundaryConditionSet& bcSet,
                             Real x, Real delta, Real nu);
            Real operator()(Real y) const;
            
          private:
            const Real x_, delta_, nu_;
            const FdmBoundaryConditionSet& bcSet_;
            const boost::shared_ptr<LinearInterpolation>& interpl_;
        };
          
        Disposable<Array> integro(const Array& r) const;  
        
        Array x_, weights_;
        
        const Real lambda_, delta_, nu_, m_;
        GaussHermiteIntegration gaussHermiteIntegration_;
        
        const boost::shared_ptr<FdmMesher> mesher_;
        const FdmBoundaryConditionSet bcSet_;
        const boost::shared_ptr<FdmHestonOp> hestonOp_;
    };
}

#endif
