/* umockdev-record.c generated by valac 0.44.3, the Vala compiler
 * generated from umockdev-record.vala, do not modify */

/*
 * Record Linux devices and their ancestors from sysfs/udev.
 * All attributes and properties are included, non-ASCII ones get printed in hex.
 * The record is written to the standard output.
 *
 * Copyright (C) 2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <errno.h>
#include "sys/sysmacros.h"
#include <glib/gstdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include "config.h"

#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

extern guint record_script_counter;
guint record_script_counter = (guint) 0;
extern gchar** opt_devices;
gchar** opt_devices = NULL;
extern gboolean opt_all;
gboolean opt_all = FALSE;
extern gchar* opt_ioctl;
gchar* opt_ioctl = NULL;
extern gchar** opt_script;
gchar** opt_script = NULL;
extern gchar** opt_evemu_events;
gchar** opt_evemu_events = NULL;
extern gboolean opt_version;
gboolean opt_version = FALSE;

void exit_error (const gchar* message,
                 ...);
void devices_from_dir (const gchar* dir,
                       GPtrArray* * devs);
gchar** all_devices (void);
static void _g_free0_ (gpointer var);
static gchar** _vala_array_dup1 (gchar** self,
                          int length);
gchar* resolve (const gchar* dev);
gchar* parent (const gchar* dev);
gchar* format_hex (guint8* bytes,
                   gint bytes_length1,
                   gint len);
void write_attr (const gchar* name,
                 guint8* val,
                 gint val_length1);
gchar* dev_contents (const gchar* dev);
void print_device_attributes (const gchar* devpath,
                              const gchar* subdir);
static inline void _g_list_free__g_free0_ (GList* self);
void record_device (const gchar* dev);
void dump_devices (gchar** devices,
                   gint devices_length1);
void split_devfile_arg (const gchar* arg,
                        gchar* * dev,
                        gchar* * devnum,
                        gchar* * fname);
void record_ioctl (const gchar* arg);
void record_script (const gchar* arg,
                    const gchar* format);
gint _vala_main (gchar** args,
                 gint args_length1);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[7] = {{"all", 'a', 0, G_OPTION_ARG_NONE, &opt_all, "Record all devices"}, {"ioctl", 'i', 0, G_OPTION_ARG_FILENAME, &opt_ioctl, "Trace ioctls on the device, record into given file. In this case, all " \
"positional arguments are a command (and its arguments) to run that get" \
"s traced.", "devname=FILE"}, {"script", 's', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_script, "Trace reads and writes on the device, record into given file. In this " \
"case, all positional arguments are a command (and its arguments) to ru" \
"n that gets traced. Can be specified multiple times.", "devname=FILE"}, {"evemu-events", 'e', 0, G_OPTION_ARG_FILENAME_ARRAY, &opt_evemu_events, "Trace evdev event reads on the device, record into given file in EVEMU" \
" event format. In this case, all positional arguments are a command (a" \
"nd its arguments) to run that gets traced. Can be specified multiple t" \
"imes.", "devname=FILE"}, {"", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &opt_devices, "Path of a device in /dev or /sys, or command and arguments with --ioct" \
"l.", "DEVICE [...]"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &opt_version, "Output version information and exit"}, {NULL}};

void
exit_error (const gchar* message,
            ...)
{
	FILE* _tmp0_;
	va_list _tmp1_ = {0};
	FILE* _tmp2_;
	g_return_if_fail (message != NULL);
	_tmp0_ = stderr;
	va_start (_tmp1_, message);
	vfprintf (_tmp0_, message, _tmp1_);
	va_end (_tmp1_);
	_tmp2_ = stderr;
	fputs ("\n", _tmp2_);
	exit (1);
}

void
devices_from_dir (const gchar* dir,
                  GPtrArray* * devs)
{
	GDir* d = NULL;
	gboolean has_uevent = FALSE;
	gboolean has_subsystem = FALSE;
	gchar* entry = NULL;
	gboolean _tmp19_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dir != NULL);
	g_return_if_fail (*devs != NULL);
	{
		GDir* _tmp0_ = NULL;
		GDir* _tmp1_;
		GDir* _tmp2_;
		_tmp1_ = g_dir_open (dir, (guint) 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_dir_close0 (d);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_dir_close0 (d);
		d = _tmp2_;
		_g_dir_close0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_g_error_free0 (e);
		_g_dir_close0 (d);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_dir_close0 (d);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	has_uevent = FALSE;
	has_subsystem = FALSE;
	while (TRUE) {
		GDir* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = d;
		_tmp4_ = g_dir_read_name (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (entry);
		entry = _tmp5_;
		_tmp6_ = entry;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = entry;
		if (g_strcmp0 (_tmp7_, "uevent") == 0) {
			has_uevent = TRUE;
		} else {
			const gchar* _tmp8_;
			_tmp8_ = entry;
			if (g_strcmp0 (_tmp8_, "subsystem") == 0) {
				has_subsystem = TRUE;
			} else {
				gchar* p = NULL;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				struct stat st = {0};
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				const gchar* _tmp13_;
				struct stat _tmp14_ = {0};
				gint _tmp15_;
				_tmp9_ = entry;
				_tmp10_ = g_build_filename (dir, _tmp9_, NULL);
				p = _tmp10_;
				_tmp13_ = p;
				_tmp15_ = lstat (_tmp13_, &_tmp14_);
				st = _tmp14_;
				if (_tmp15_ == 0) {
					struct stat _tmp16_;
					_tmp16_ = st;
					_tmp12_ = S_ISDIR (_tmp16_.st_mode);
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					struct stat _tmp17_;
					_tmp17_ = st;
					_tmp11_ = !S_ISLNK (_tmp17_.st_mode);
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					const gchar* _tmp18_;
					_tmp18_ = p;
					devices_from_dir (_tmp18_, devs);
				}
				_g_free0 (p);
			}
		}
	}
	if (has_uevent) {
		_tmp19_ = has_subsystem;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gchar* _tmp20_;
		_tmp20_ = g_strdup (dir);
		g_ptr_array_add (*devs, _tmp20_);
	}
	_g_free0 (entry);
	_g_dir_close0 (d);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

gchar**
all_devices (void)
{
	gchar** result = NULL;
	GPtrArray* devs = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	gpointer* _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	devs = _tmp0_;
	devices_from_dir ("/sys/devices", &devs);
	_tmp1_ = devs;
	_tmp2_ = _tmp1_->pdata;
	_tmp2__length1 = _tmp1_->len;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	result = _tmp3_;
	_g_ptr_array_unref0 (devs);
	return result;
}

gchar*
resolve (const gchar* dev)
{
	gchar* result = NULL;
	struct stat st = {0};
	struct stat _tmp0_ = {0};
	gint _tmp1_;
	guint maj = 0U;
	struct stat _tmp3_;
	guint min = 0U;
	struct stat _tmp4_;
	gchar* link = NULL;
	struct stat _tmp5_;
	gchar* real = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp1_ = stat (dev, &_tmp0_);
	st = _tmp0_;
	if (_tmp1_ != 0) {
		const gchar* _tmp2_;
		_tmp2_ = g_strerror (errno);
		exit_error ("Cannot access device %s: %s", dev, _tmp2_, NULL);
	}
	_tmp3_ = st;
	maj = major (_tmp3_.st_rdev);
	_tmp4_ = st;
	min = minor (_tmp4_.st_rdev);
	_tmp5_ = st;
	if (S_ISCHR (_tmp5_.st_mode)) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup_printf ("/sys/dev/char/%u:%u", maj, min);
		_g_free0 (link);
		link = _tmp6_;
	} else {
		struct stat _tmp7_;
		_tmp7_ = st;
		if (S_ISBLK (_tmp7_.st_mode)) {
			gchar* _tmp8_;
			_tmp8_ = g_strdup_printf ("/sys/dev/block/%u:%u", maj, min);
			_g_free0 (link);
			link = _tmp8_;
		} else {
			gchar* _tmp9_;
			_tmp9_ = g_strdup (dev);
			_g_free0 (link);
			link = _tmp9_;
		}
	}
	_tmp10_ = link;
	_tmp11_ = realpath (_tmp10_, NULL);
	real = _tmp11_;
	_tmp12_ = real;
	if (_tmp12_ == NULL) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = link;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (real);
		real = _tmp14_;
	}
	_tmp15_ = real;
	_tmp16_ = g_build_filename (_tmp15_, "uevent", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = !g_file_test (_tmp17_, G_FILE_TEST_EXISTS);
	_g_free0 (_tmp17_);
	if (_tmp18_) {
		const gchar* _tmp19_;
		_tmp19_ = real;
		exit_error ("Invalid device %s, has no uevent attribute", _tmp19_, NULL);
	}
	result = real;
	_g_free0 (link);
	return result;
}

gchar*
parent (const gchar* dev)
{
	gchar* result = NULL;
	gchar* p = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp0_ = g_path_get_dirname (dev);
	p = _tmp0_;
	_tmp1_ = p;
	if (!g_str_has_prefix (_tmp1_, "/sys")) {
		result = NULL;
		_g_free0 (p);
		return result;
	}
	_tmp3_ = p;
	_tmp4_ = g_build_filename (_tmp3_, "uevent", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_test (_tmp5_, G_FILE_TEST_EXISTS);
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = p;
		_tmp8_ = g_build_filename (_tmp7_, "subsystem", NULL);
		_tmp9_ = _tmp8_;
		_tmp2_ = g_file_test (_tmp9_, G_FILE_TEST_EXISTS);
		_g_free0 (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = p;
		return result;
	}
	_tmp10_ = p;
	_tmp11_ = parent (_tmp10_);
	result = _tmp11_;
	_g_free0 (p);
	return result;
}

gchar*
format_hex (guint8* bytes,
            gint bytes_length1,
            gint len)
{
	gchar* result = NULL;
	GString* _result_ = NULL;
	GString* _tmp0_;
	GString* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	if (len < 0) {
		len = bytes_length1;
	}
	_tmp0_ = g_string_new ("");
	_result_ = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GString* _tmp2_;
				guint8 _tmp3_;
				if (!_tmp1_) {
					i = i + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < len)) {
					break;
				}
				_tmp2_ = _result_;
				_tmp3_ = bytes[i];
				g_string_append_printf (_tmp2_, "%02X", (guint) _tmp3_);
			}
		}
	}
	_tmp4_ = _result_;
	_tmp5_ = _tmp4_->str;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	_g_string_free0 (_result_);
	return result;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchomp (_tmp1_);
	result = _result_;
	return result;
}

void
write_attr (const gchar* name,
            guint8* val,
            gint val_length1)
{
	gchar* strval = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	FILE* _tmp15_;
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup ((const gchar*) val);
	strval = _tmp0_;
	_tmp2_ = strval;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (val_length1 == _tmp4_) {
		const gchar* _tmp5_;
		_tmp5_ = strval;
		_tmp1_ = g_utf8_validate (_tmp5_, (gssize) -1, NULL);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		FILE* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = stdout;
		_tmp7_ = strval;
		_tmp8_ = string_chomp (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strescape (_tmp9_, "");
		_tmp11_ = _tmp10_;
		fprintf (_tmp6_, "A: %s=%s", name, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	} else {
		FILE* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = stdout;
		_tmp13_ = format_hex (val, (gint) val_length1, -1);
		_tmp14_ = _tmp13_;
		fprintf (_tmp12_, "H: %s=%s", name, _tmp14_);
		_g_free0 (_tmp14_);
	}
	_tmp15_ = stdout;
	fputc ('\n', _tmp15_);
	_g_free0 (strval);
}

gchar*
dev_contents (const gchar* dev)
{
	gchar* result = NULL;
	struct stat st = {0};
	struct stat _tmp0_ = {0};
	gint _tmp1_;
	gboolean _tmp3_ = FALSE;
	struct stat _tmp4_;
	gint fd = 0;
	guint8* buffer = NULL;
	guint8* _tmp8_;
	gint buffer_length1;
	gint _buffer_size_;
	gssize len = 0L;
	guint8* _tmp9_;
	gint _tmp9__length1;
	gchar* _result_ = NULL;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp1_ = lstat (dev, &_tmp0_);
	st = _tmp0_;
	if (_tmp1_ != 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		return result;
	}
	_tmp4_ = st;
	if (!S_ISCHR (_tmp4_.st_mode)) {
		_tmp3_ = TRUE;
	} else {
		struct stat _tmp5_;
		_tmp5_ = st;
		_tmp3_ = major (_tmp5_.st_rdev) != ((guint) 189);
	}
	if (_tmp3_) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		return result;
	}
	fd = open (dev, O_RDONLY | O_NONBLOCK, (mode_t) 0);
	if (fd < 0) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		return result;
	}
	_tmp8_ = g_new0 (guint8, 1025);
	buffer = _tmp8_;
	buffer_length1 = 1025;
	_buffer_size_ = buffer_length1;
	_tmp9_ = buffer;
	_tmp9__length1 = buffer_length1;
	len = read (fd, _tmp9_, (gsize) 1025);
	_tmp10_ = g_strdup ("");
	_result_ = _tmp10_;
	if (len > ((gssize) 0)) {
		_tmp11_ = len <= ((gssize) 1024);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		guint8* _tmp12_;
		gint _tmp12__length1;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = buffer;
		_tmp12__length1 = buffer_length1;
		_tmp13_ = format_hex (_tmp12_, (gint) _tmp12__length1, (gint) len);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat ("=", _tmp14_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp15_;
		_g_free0 (_tmp14_);
	}
	close (fd);
	result = _result_;
	buffer = (g_free (buffer), NULL);
	return result;
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

void
print_device_attributes (const gchar* devpath,
                         const gchar* subdir)
{
	GDir* d = NULL;
	gchar* attr_dir = NULL;
	gchar* _tmp0_;
	GList* attributes = NULL;
	gchar* entry = NULL;
	GCompareFunc _tmp22_;
	GList* _tmp23_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (subdir != NULL);
	_tmp0_ = g_build_filename (devpath, subdir, NULL);
	attr_dir = _tmp0_;
	{
		GDir* _tmp1_ = NULL;
		const gchar* _tmp2_;
		GDir* _tmp3_;
		GDir* _tmp4_;
		_tmp2_ = attr_dir;
		_tmp3_ = g_dir_open (_tmp2_, (guint) 0, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_dir_close0 (d);
		d = _tmp4_;
		_g_dir_close0 (_tmp1_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (g_strcmp0 (subdir, "") == 0) {
			const gchar* _tmp5_;
			GError* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = attr_dir;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			exit_error ("Cannot open directory %s: %s", _tmp5_, _tmp7_, NULL);
		} else {
			const gchar* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = attr_dir;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_debug ("umockdev-record.vala:180: Cannot open directory %s: %s", _tmp8_, _tmp10_);
		}
		_g_error_free0 (e);
		_g_free0 (attr_dir);
		_g_dir_close0 (d);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (attr_dir);
		_g_dir_close0 (d);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	attributes = NULL;
	while (TRUE) {
		GDir* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		const gchar* _tmp17_;
		_tmp11_ = d;
		_tmp12_ = g_dir_read_name (_tmp11_);
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (entry);
		entry = _tmp13_;
		_tmp14_ = entry;
		if (!(_tmp14_ != NULL)) {
			break;
		}
		_tmp17_ = entry;
		if (g_strcmp0 (_tmp17_, "subsystem") != 0) {
			const gchar* _tmp18_;
			_tmp18_ = entry;
			_tmp16_ = g_strcmp0 (_tmp18_, "firmware_node") != 0;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			const gchar* _tmp19_;
			_tmp19_ = entry;
			_tmp15_ = g_strcmp0 (_tmp19_, "uevent") != 0;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp20_ = entry;
			_tmp21_ = g_strdup (_tmp20_);
			attributes = g_list_append (attributes, _tmp21_);
		} else {
			if (g_strcmp0 (subdir, "") != 0) {
				_g_free0 (entry);
				(attributes == NULL) ? NULL : (attributes = (_g_list_free__g_free0_ (attributes), NULL));
				_g_free0 (attr_dir);
				_g_dir_close0 (d);
				return;
			}
		}
	}
	_tmp22_ = ((GCompareFunc) g_strcmp0);
	attributes = g_list_sort (attributes, _tmp22_);
	_tmp23_ = attributes;
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp23_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			gchar* _tmp24_;
			gchar* attr = NULL;
			_tmp24_ = g_strdup ((const gchar*) attr_it->data);
			attr = _tmp24_;
			{
				gchar* attr_path = NULL;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* attr_name = NULL;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				_tmp25_ = attr_dir;
				_tmp26_ = attr;
				_tmp27_ = g_build_filename (_tmp25_, _tmp26_, NULL);
				attr_path = _tmp27_;
				_tmp28_ = attr;
				_tmp29_ = g_build_filename (subdir, _tmp28_, NULL);
				attr_name = _tmp29_;
				_tmp30_ = attr_path;
				if (g_file_test (_tmp30_, G_FILE_TEST_IS_SYMLINK)) {
					{
						gchar* _tmp31_ = NULL;
						const gchar* _tmp32_;
						gchar* _tmp33_;
						FILE* _tmp34_;
						const gchar* _tmp35_;
						_tmp32_ = attr_path;
						_tmp33_ = g_file_read_link (_tmp32_, &_inner_error0_);
						_tmp31_ = _tmp33_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch2_g_error;
						}
						_tmp34_ = stdout;
						_tmp35_ = attr_name;
						fprintf (_tmp34_, "L: %s=%s\n", _tmp35_, _tmp31_);
						_g_free0 (_tmp31_);
					}
					goto __finally2;
					__catch2_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp36_;
						GError* _tmp37_;
						const gchar* _tmp38_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp36_ = attr_path;
						_tmp37_ = e;
						_tmp38_ = _tmp37_->message;
						exit_error ("Cannot read link %s: %s", _tmp36_, _tmp38_, NULL);
						_g_error_free0 (e);
					}
					__finally2:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (attr_name);
						_g_free0 (attr_path);
						_g_free0 (attr);
						_g_free0 (entry);
						(attributes == NULL) ? NULL : (attributes = (_g_list_free__g_free0_ (attributes), NULL));
						_g_free0 (attr_dir);
						_g_dir_close0 (d);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				} else {
					const gchar* _tmp39_;
					_tmp39_ = attr_path;
					if (g_file_test (_tmp39_, G_FILE_TEST_IS_REGULAR)) {
						guint8* contents = NULL;
						gint contents_length1 = 0;
						gint _contents_size_ = 0;
						{
							const gchar* _tmp40_;
							guint8* _tmp41_ = NULL;
							size_t _tmp42_ = 0;
							const gchar* _tmp43_;
							guint8* _tmp44_;
							gint _tmp44__length1;
							_tmp40_ = attr_path;
							g_file_get_contents (_tmp40_, (gchar**) (&_tmp41_), &_tmp42_, &_inner_error0_);
							contents = (g_free (contents), NULL);
							contents = _tmp41_;
							contents_length1 = _tmp42_;
							_contents_size_ = contents_length1;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == G_FILE_ERROR) {
									goto __catch3_g_file_error;
								}
								contents = (g_free (contents), NULL);
								_g_free0 (attr_name);
								_g_free0 (attr_path);
								_g_free0 (attr);
								_g_free0 (entry);
								(attributes == NULL) ? NULL : (attributes = (_g_list_free__g_free0_ (attributes), NULL));
								_g_free0 (attr_dir);
								_g_dir_close0 (d);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
							_tmp43_ = attr_name;
							_tmp44_ = contents;
							_tmp44__length1 = contents_length1;
							write_attr (_tmp43_, _tmp44_, (gint) _tmp44__length1);
						}
						goto __finally3;
						__catch3_g_file_error:
						{
							GError* e = NULL;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_g_error_free0 (e);
						}
						__finally3:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							contents = (g_free (contents), NULL);
							_g_free0 (attr_name);
							_g_free0 (attr_path);
							_g_free0 (attr);
							_g_free0 (entry);
							(attributes == NULL) ? NULL : (attributes = (_g_list_free__g_free0_ (attributes), NULL));
							_g_free0 (attr_dir);
							_g_dir_close0 (d);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						contents = (g_free (contents), NULL);
					} else {
						const gchar* _tmp45_;
						_tmp45_ = attr_path;
						if (g_file_test (_tmp45_, G_FILE_TEST_IS_DIR)) {
							const gchar* _tmp46_;
							_tmp46_ = attr;
							print_device_attributes (devpath, _tmp46_);
						}
					}
				}
				_g_free0 (attr_name);
				_g_free0 (attr_path);
				_g_free0 (attr);
			}
		}
	}
	_g_free0 (entry);
	(attributes == NULL) ? NULL : (attributes = (_g_list_free__g_free0_ (attributes), NULL));
	_g_free0 (attr_dir);
	_g_dir_close0 (d);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
record_device (const gchar* dev)
{
	gchar* u_out = NULL;
	gchar* u_err = NULL;
	gint exitcode = 0;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	FILE* _tmp48_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dev != NULL);
	g_debug ("umockdev-record.vala:222: recording device %s", dev);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp0_ = g_strdup ("udevadm");
		_tmp1_ = g_strdup ("info");
		_tmp2_ = g_strdup ("--query=all");
		_tmp3_ = g_strdup ("--path");
		_tmp4_ = g_strdup (dev);
		_tmp5_ = g_new0 (gchar*, 5 + 1);
		_tmp5_[0] = _tmp0_;
		_tmp5_[1] = _tmp1_;
		_tmp5_[2] = _tmp2_;
		_tmp5_[3] = _tmp3_;
		_tmp5_[4] = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = 5;
		g_spawn_sync (NULL, _tmp6_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp7_, &_tmp8_, &_tmp9_, &_inner_error0_);
		_g_free0 (u_out);
		u_out = _tmp7_;
		_g_free0 (u_err);
		u_err = _tmp8_;
		exitcode = _tmp9_;
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch4_g_error;
		}
		if (exitcode != 0) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GError* _tmp13_;
			GError* _tmp14_;
			_tmp10_ = u_err;
			_tmp11_ = g_strdup_printf ("udevadm exited with code %i\n%s", exitcode, _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp12_);
			_inner_error0_ = _tmp14_;
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		exit_error ("Cannot call udevadm: %s", _tmp16_, NULL);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (u_err);
		_g_free0 (u_out);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp17_ = u_out;
	_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp19_;
		line_collection_length1 = _vala_array_length (_tmp18_);
		for (line_it = 0; line_it < _vala_array_length (_tmp18_); line_it = line_it + 1) {
			gchar* _tmp20_;
			gchar* line = NULL;
			_tmp20_ = g_strdup (line_collection[line_it]);
			line = _tmp20_;
			{
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				const gchar* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				const gchar* _tmp32_;
				FILE* _tmp44_;
				const gchar* _tmp45_;
				FILE* _tmp46_;
				_tmp25_ = line;
				_tmp26_ = strlen (_tmp25_);
				_tmp27_ = _tmp26_;
				if (_tmp27_ == 0) {
					_tmp24_ = TRUE;
				} else {
					const gchar* _tmp28_;
					_tmp28_ = line;
					_tmp24_ = g_str_has_prefix (_tmp28_, "E: DEVPATH=");
				}
				if (_tmp24_) {
					_tmp23_ = TRUE;
				} else {
					const gchar* _tmp29_;
					_tmp29_ = line;
					_tmp23_ = g_str_has_prefix (_tmp29_, "E: UDEV_LOG=");
				}
				if (_tmp23_) {
					_tmp22_ = TRUE;
				} else {
					const gchar* _tmp30_;
					_tmp30_ = line;
					_tmp22_ = g_str_has_prefix (_tmp30_, "E: USEC_INITIALIZED=");
				}
				if (_tmp22_) {
					_tmp21_ = TRUE;
				} else {
					const gchar* _tmp31_;
					_tmp31_ = line;
					_tmp21_ = g_str_has_prefix (_tmp31_, "L: ");
				}
				if (_tmp21_) {
					_g_free0 (line);
					continue;
				}
				_tmp32_ = line;
				if (g_str_has_prefix (_tmp32_, "N: ")) {
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					_tmp33_ = line;
					_tmp34_ = line;
					_tmp35_ = string_substring (_tmp34_, (glong) 3, (glong) -1);
					_tmp36_ = _tmp35_;
					_tmp37_ = string_chomp (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = g_strconcat ("/dev/", _tmp38_, NULL);
					_tmp40_ = _tmp39_;
					_tmp41_ = dev_contents (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = g_strconcat (_tmp33_, _tmp42_, NULL);
					_g_free0 (line);
					line = _tmp43_;
					_g_free0 (_tmp42_);
					_g_free0 (_tmp40_);
					_g_free0 (_tmp38_);
					_g_free0 (_tmp36_);
				}
				_tmp44_ = stdout;
				_tmp45_ = line;
				fputs (_tmp45_, _tmp44_);
				_tmp46_ = stdout;
				fputc ('\n', _tmp46_);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (string_contains (dev, "tegra")) {
		FILE* _tmp47_;
		_tmp47_ = stdout;
		fputc ('\n', _tmp47_);
		_g_free0 (u_err);
		_g_free0 (u_out);
		return;
	}
	print_device_attributes (dev, "");
	_tmp48_ = stdout;
	fputc ('\n', _tmp48_);
	_g_free0 (u_err);
	_g_free0 (u_out);
}

void
dump_devices (gchar** devices,
              gint devices_length1)
{
	GHashTable* seen = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	seen = _tmp2_;
	{
		gchar** device_collection = NULL;
		gint device_collection_length1 = 0;
		gint _device_collection_size_ = 0;
		gint device_it = 0;
		device_collection = devices;
		device_collection_length1 = devices_length1;
		for (device_it = 0; device_it < devices_length1; device_it = device_it + 1) {
			gchar* _tmp3_;
			gchar* device = NULL;
			_tmp3_ = g_strdup (device_collection[device_it]);
			device = _tmp3_;
			{
				while (TRUE) {
					const gchar* _tmp4_;
					GHashTable* _tmp5_;
					const gchar* _tmp6_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp4_ = device;
					if (!(_tmp4_ != NULL)) {
						break;
					}
					_tmp5_ = seen;
					_tmp6_ = device;
					if (!g_hash_table_contains (_tmp5_, _tmp6_)) {
						GHashTable* _tmp7_;
						const gchar* _tmp8_;
						gchar* _tmp9_;
						const gchar* _tmp10_;
						_tmp7_ = seen;
						_tmp8_ = device;
						_tmp9_ = g_strdup (_tmp8_);
						g_hash_table_add (_tmp7_, _tmp9_);
						_tmp10_ = device;
						record_device (_tmp10_);
					}
					_tmp11_ = device;
					_tmp12_ = parent (_tmp11_);
					_g_free0 (device);
					device = _tmp12_;
				}
				_g_free0 (device);
			}
		}
	}
	_g_hash_table_unref0 (seen);
}

void
split_devfile_arg (const gchar* arg,
                   gchar* * dev,
                   gchar* * devnum,
                   gchar* * fname)
{
	gchar* _vala_dev = NULL;
	gchar* _vala_devnum = NULL;
	gchar* _vala_fname = NULL;
	gchar** parts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	struct stat st = {0};
	const gchar* _tmp9_;
	struct stat _tmp10_ = {0};
	gint _tmp11_;
	gboolean _tmp14_ = FALSE;
	struct stat _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (arg != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (arg, "=", 2);
	parts = _tmp1_;
	parts_length1 = _vala_array_length (_tmp0_);
	_parts_size_ = parts_length1;
	_tmp2_ = parts;
	_tmp2__length1 = parts_length1;
	if (_tmp2__length1 != 2) {
		exit_error ("--ioctl argument must be devname=filename", NULL);
	}
	_tmp3_ = parts;
	_tmp3__length1 = parts_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (_vala_dev);
	_vala_dev = _tmp5_;
	_tmp6_ = parts;
	_tmp6__length1 = parts_length1;
	_tmp7_ = _tmp6_[1];
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (_vala_fname);
	_vala_fname = _tmp8_;
	_tmp9_ = _vala_dev;
	_tmp11_ = stat (_tmp9_, &_tmp10_);
	st = _tmp10_;
	if (_tmp11_ != 0) {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = _vala_dev;
		_tmp13_ = g_strerror (errno);
		exit_error ("Cannot access device %s: %s", _tmp12_, _tmp13_, NULL);
	}
	_tmp15_ = st;
	if (S_ISCHR (_tmp15_.st_mode)) {
		_tmp14_ = TRUE;
	} else {
		struct stat _tmp16_;
		_tmp16_ = st;
		_tmp14_ = S_ISBLK (_tmp16_.st_mode);
	}
	if (_tmp14_) {
		struct stat _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		struct stat _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp17_ = st;
		_tmp18_ = g_strdup_printf ("%u", major (_tmp17_.st_rdev));
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, ":", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = st;
		_tmp23_ = g_strdup_printf ("%u", minor (_tmp22_.st_rdev));
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp21_, _tmp24_, NULL);
		_g_free0 (_vala_devnum);
		_vala_devnum = _tmp25_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
	} else {
		struct stat _tmp26_;
		_tmp26_ = st;
		if (S_ISSOCK (_tmp26_.st_mode)) {
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp27_ = _vala_dev;
			_tmp28_ = g_strdup (_tmp27_);
			_g_free0 (_vala_devnum);
			_vala_devnum = _tmp28_;
		} else {
			{
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_ = NULL;
				_tmp29_ = _vala_dev;
				_tmp30_ = g_build_filename (_tmp29_, "dev", NULL);
				_tmp31_ = _tmp30_;
				g_file_get_contents (_tmp31_, &_tmp32_, NULL, &_inner_error0_);
				_g_free0 (_vala_devnum);
				_vala_devnum = _tmp32_;
				_g_free0 (_tmp31_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch5_g_error;
				}
			}
			goto __finally5;
			__catch5_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp33_;
				GError* _tmp34_;
				const gchar* _tmp35_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp33_ = _vala_dev;
				_tmp34_ = e;
				_tmp35_ = _tmp34_->message;
				exit_error ("Cannot open %s/dev: %s", _tmp33_, _tmp35_, NULL);
				_g_error_free0 (e);
			}
			__finally5:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	if (dev) {
		*dev = _vala_dev;
	} else {
		_g_free0 (_vala_dev);
	}
	if (devnum) {
		*devnum = _vala_devnum;
	} else {
		_g_free0 (_vala_devnum);
	}
	if (fname) {
		*fname = _vala_fname;
	} else {
		_g_free0 (_vala_fname);
	}
}

void
record_ioctl (const gchar* arg)
{
	gchar* dev = NULL;
	gchar* devnum = NULL;
	gchar* outfile = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (arg != NULL);
	split_devfile_arg (arg, &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (dev);
	dev = _tmp0_;
	_g_free0 (devnum);
	devnum = _tmp1_;
	_g_free0 (outfile);
	outfile = _tmp2_;
	g_setenv ("UMOCKDEV_IOCTL_RECORD_FILE", outfile, TRUE);
	g_setenv ("UMOCKDEV_IOCTL_RECORD_DEV", devnum, TRUE);
	g_setenv ("UMOCKDEV_IOCTL_RECORD_DEVICE_PATH", dev, TRUE);
	_g_free0 (outfile);
	_g_free0 (devnum);
	_g_free0 (dev);
}

void
record_script (const gchar* arg,
               const gchar* format)
{
	gchar* dev = NULL;
	gchar* devnum = NULL;
	gchar* outfile = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* c = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	guint _tmp12_;
	g_return_if_fail (arg != NULL);
	g_return_if_fail (format != NULL);
	split_devfile_arg (arg, &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (dev);
	dev = _tmp0_;
	_g_free0 (devnum);
	devnum = _tmp1_;
	_g_free0 (outfile);
	outfile = _tmp2_;
	_tmp3_ = g_strdup_printf ("%u", record_script_counter);
	c = _tmp3_;
	_tmp4_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_FILE_", c, NULL);
	_tmp5_ = _tmp4_;
	g_setenv (_tmp5_, outfile, TRUE);
	_g_free0 (_tmp5_);
	_tmp6_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_DEV_", c, NULL);
	_tmp7_ = _tmp6_;
	g_setenv (_tmp7_, devnum, TRUE);
	_g_free0 (_tmp7_);
	_tmp8_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_DEVICE_PATH_", c, NULL);
	_tmp9_ = _tmp8_;
	g_setenv (_tmp9_, dev, TRUE);
	_g_free0 (_tmp9_);
	_tmp10_ = g_strconcat ("UMOCKDEV_SCRIPT_RECORD_FORMAT_", c, NULL);
	_tmp11_ = _tmp10_;
	g_setenv (_tmp11_, format, TRUE);
	_g_free0 (_tmp11_);
	_tmp12_ = record_script_counter;
	record_script_counter = _tmp12_ + 1;
	_g_free0 (c);
	_g_free0 (outfile);
	_g_free0 (devnum);
	_g_free0 (dev);
}

gint
_vala_main (gchar** args,
            gint args_length1)
{
	gint result = 0;
	GOptionContext* oc = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_;
	gchar* preload = NULL;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gchar** _tmp52_;
	gint _tmp52__length1;
	const gchar* _tmp53_;
	gchar** _tmp54_;
	gint _tmp54__length1;
	gchar** _tmp55_;
	gint _tmp55__length1;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_option_context_new ("");
	oc = _tmp0_;
	_tmp1_ = oc;
	g_option_context_set_summary (_tmp1_, "Record Linux devices and their ancestors from sysfs/udev, or record io" \
"ctls for a device.");
	_tmp2_ = oc;
	g_option_context_add_main_entries (_tmp2_, options, NULL);
	{
		GOptionContext* _tmp3_;
		_tmp3_ = oc;
		g_option_context_parse (_tmp3_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = args[0];
		exit_error ("Error: %s\nRun %s --help for how to use this program", _tmp5_, _tmp6_, NULL);
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (oc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	if (opt_version) {
		FILE* _tmp8_;
		_tmp8_ = stdout;
		fprintf (_tmp8_, "%s\n", VERSION);
		result = 0;
		_g_option_context_free0 (oc);
		return result;
	}
	if (opt_all) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp10_ = opt_devices;
		_tmp10__length1 = _vala_array_length (opt_devices);
		_tmp9_ = _tmp10__length1 > 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		exit_error ("Specifying a device list together with --all is invalid.", NULL);
	}
	if (!opt_all) {
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp12_ = opt_devices;
		_tmp12__length1 = _vala_array_length (opt_devices);
		_tmp11_ = _tmp12__length1 == 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		exit_error ("Need to specify at least one device or --all.", NULL);
	}
	_tmp16_ = opt_ioctl;
	if (_tmp16_ != NULL) {
		_tmp15_ = TRUE;
	} else {
		gchar** _tmp17_;
		gint _tmp17__length1;
		_tmp17_ = opt_script;
		_tmp17__length1 = _vala_array_length (opt_script);
		_tmp15_ = _tmp17__length1 > 0;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		gchar** _tmp18_;
		gint _tmp18__length1;
		_tmp18_ = opt_evemu_events;
		_tmp18__length1 = _vala_array_length (opt_evemu_events);
		_tmp14_ = _tmp18__length1 > 0;
	}
	if (_tmp14_) {
		gboolean _tmp19_ = FALSE;
		if (opt_all) {
			_tmp19_ = TRUE;
		} else {
			gchar** _tmp20_;
			gint _tmp20__length1;
			_tmp20_ = opt_devices;
			_tmp20__length1 = _vala_array_length (opt_devices);
			_tmp19_ = _tmp20__length1 < 1;
		}
		_tmp13_ = _tmp19_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		exit_error ("For recording ioctls or scripts you have to specify a command to run", NULL);
	}
	_tmp23_ = opt_ioctl;
	if (_tmp23_ == NULL) {
		gchar** _tmp24_;
		gint _tmp24__length1;
		_tmp24_ = opt_script;
		_tmp24__length1 = _vala_array_length (opt_script);
		_tmp22_ = _tmp24__length1 == 0;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		gchar** _tmp25_;
		gint _tmp25__length1;
		_tmp25_ = opt_evemu_events;
		_tmp25__length1 = _vala_array_length (opt_evemu_events);
		_tmp21_ = _tmp25__length1 == 0;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		gchar** _tmp34_;
		gint _tmp34__length1;
		if (opt_all) {
			gchar** _tmp26_;
			gchar** _tmp27_;
			_tmp27_ = _tmp26_ = all_devices ();
			opt_devices = (_vala_array_free (opt_devices, _vala_array_length (opt_devices), (GDestroyNotify) g_free), NULL);
			opt_devices = _tmp27_;
		} else {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp28_ = FALSE;
					_tmp28_ = TRUE;
					while (TRUE) {
						gchar** _tmp29_;
						gint _tmp29__length1;
						gchar** _tmp30_;
						gint _tmp30__length1;
						gchar** _tmp31_;
						gint _tmp31__length1;
						const gchar* _tmp32_;
						gchar* _tmp33_;
						if (!_tmp28_) {
							i = i + 1;
						}
						_tmp28_ = FALSE;
						_tmp29_ = opt_devices;
						_tmp29__length1 = _vala_array_length (opt_devices);
						if (!(i < _tmp29__length1)) {
							break;
						}
						_tmp30_ = opt_devices;
						_tmp30__length1 = _vala_array_length (opt_devices);
						_tmp31_ = opt_devices;
						_tmp31__length1 = _vala_array_length (opt_devices);
						_tmp32_ = _tmp31_[i];
						_tmp33_ = resolve (_tmp32_);
						_g_free0 (_tmp30_[i]);
						_tmp30_[i] = _tmp33_;
					}
				}
			}
		}
		_tmp34_ = opt_devices;
		_tmp34__length1 = _vala_array_length (opt_devices);
		dump_devices (_tmp34_, (gint) _tmp34__length1);
		result = 0;
		_g_option_context_free0 (oc);
		return result;
	}
	_tmp35_ = g_getenv ("LD_PRELOAD");
	_tmp36_ = g_strdup (_tmp35_);
	preload = _tmp36_;
	_tmp37_ = preload;
	if (_tmp37_ == NULL) {
		gchar* _tmp38_;
		_tmp38_ = g_strdup ("");
		_g_free0 (preload);
		preload = _tmp38_;
	} else {
		const gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp39_ = preload;
		_tmp40_ = g_strconcat (_tmp39_, ":", NULL);
		_g_free0 (preload);
		preload = _tmp40_;
	}
	_tmp41_ = preload;
	_tmp42_ = g_strconcat (_tmp41_, "libumockdev-preload.so.0", NULL);
	_tmp43_ = _tmp42_;
	g_setenv ("LD_PRELOAD", _tmp43_, TRUE);
	_g_free0 (_tmp43_);
	_tmp44_ = opt_ioctl;
	if (_tmp44_ != NULL) {
		const gchar* _tmp45_;
		_tmp45_ = opt_ioctl;
		record_ioctl (_tmp45_);
	}
	_tmp46_ = opt_script;
	_tmp46__length1 = _vala_array_length (opt_script);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp46_;
		s_collection_length1 = _tmp46__length1;
		for (s_it = 0; s_it < _tmp46__length1; s_it = s_it + 1) {
			gchar* _tmp47_;
			gchar* s = NULL;
			_tmp47_ = g_strdup (s_collection[s_it]);
			s = _tmp47_;
			{
				const gchar* _tmp48_;
				_tmp48_ = s;
				record_script (_tmp48_, "default");
				_g_free0 (s);
			}
		}
	}
	_tmp49_ = opt_evemu_events;
	_tmp49__length1 = _vala_array_length (opt_evemu_events);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp49_;
		s_collection_length1 = _tmp49__length1;
		for (s_it = 0; s_it < _tmp49__length1; s_it = s_it + 1) {
			gchar* _tmp50_;
			gchar* s = NULL;
			_tmp50_ = g_strdup (s_collection[s_it]);
			s = _tmp50_;
			{
				const gchar* _tmp51_;
				_tmp51_ = s;
				record_script (_tmp51_, "evemu");
				_g_free0 (s);
			}
		}
	}
	_tmp52_ = opt_devices;
	_tmp52__length1 = _vala_array_length (opt_devices);
	_tmp53_ = _tmp52_[0];
	_tmp54_ = opt_devices;
	_tmp54__length1 = _vala_array_length (opt_devices);
	execvp (_tmp53_, _tmp54_);
	_tmp55_ = opt_devices;
	_tmp55__length1 = _vala_array_length (opt_devices);
	_tmp56_ = _tmp55_[0];
	_tmp57_ = g_strerror (errno);
	exit_error ("Cannot run program %s: %s", _tmp56_, _tmp57_, NULL);
	result = 0;
	_g_free0 (preload);
	_g_option_context_free0 (oc);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

