/* test-umockdev-vala.c generated by valac 0.44.3, the Vala compiler
 * generated from test-umockdev-vala.vala, do not modify */

/*
 * test-umockdev.vala
 *
 * Copyright (C) 2012 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#include <umockdev.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <gudev/gudev.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include "linux/usbdevice_fs.h"
#include <errno.h>
#include <unistd.h>
#include <glib/gstdio.h>
#include <sys/stat.h>
#include "sys/sysmacros.h"
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ATTRIBUTE_COUNTER_THREAD (attribute_counter_thread_get_type ())
#define ATTRIBUTE_COUNTER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ATTRIBUTE_COUNTER_THREAD, AttributeCounterThread))
#define ATTRIBUTE_COUNTER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ATTRIBUTE_COUNTER_THREAD, AttributeCounterThreadClass))
#define IS_ATTRIBUTE_COUNTER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ATTRIBUTE_COUNTER_THREAD))
#define IS_ATTRIBUTE_COUNTER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ATTRIBUTE_COUNTER_THREAD))
#define ATTRIBUTE_COUNTER_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ATTRIBUTE_COUNTER_THREAD, AttributeCounterThreadClass))

typedef struct _AttributeCounterThread AttributeCounterThread;
typedef struct _AttributeCounterThreadClass AttributeCounterThreadClass;
typedef struct _AttributeCounterThreadPrivate AttributeCounterThreadPrivate;
typedef struct _ParamSpecAttributeCounterThread ParamSpecAttributeCounterThread;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _attribute_counter_thread_unref0(var) ((var == NULL) ? NULL : (var = (attribute_counter_thread_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AttributeCounterThread {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AttributeCounterThreadPrivate * priv;
};

struct _AttributeCounterThreadClass {
	GTypeClass parent_class;
	void (*finalize) (AttributeCounterThread *self);
};

struct _AttributeCounterThreadPrivate {
	UMockdevTestbed* tb;
	gchar* name;
	gchar* syspath;
	guint count;
};

struct _ParamSpecAttributeCounterThread {
	GParamSpec parent_instance;
};

struct _Block1Data {
	int _ref_count_;
	UMockdevTestbed* tb;
	GMainLoop* ml;
	guint add_count;
	guint change_count;
	guint num_changes;
	gchar* syspath;
};

static gint AttributeCounterThread_private_offset;
static gpointer attribute_counter_thread_parent_class = NULL;

void tb_add_from_string (UMockdevTestbed* tb,
                         const gchar* s);
void t_testbed_empty (void);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
void t_testbed_add_device (void);
void t_testbed_gudev_query_list (void);
void t_usbfs_ioctl_static (void);
void t_usbfs_ioctl_tree (void);
static guint8* _vala_array_dup1 (guint8* self,
                          int length);
void t_usbfs_ioctl_tree_with_default_device (void);
void t_usbfs_ioctl_tree_override_default_device (void);
void t_usbfs_ioctl_tree_xz (void);
void t_tty_stty (void);
void t_tty_data (void);
void t_detects_running_in_testbed (void);
void t_detects_not_running_in_testbed (void);
gint is_test_inside_testbed (gint pipefd);
gpointer attribute_counter_thread_ref (gpointer instance);
void attribute_counter_thread_unref (gpointer instance);
GParamSpec* param_spec_attribute_counter_thread (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
void value_set_attribute_counter_thread (GValue* value,
                                         gpointer v_object);
void value_take_attribute_counter_thread (GValue* value,
                                          gpointer v_object);
gpointer value_get_attribute_counter_thread (const GValue* value);
GType attribute_counter_thread_get_type (void) G_GNUC_CONST;
AttributeCounterThread* attribute_counter_thread_new (UMockdevTestbed* tb,
                                                      const gchar* syspath,
                                                      const gchar* name,
                                                      guint max);
AttributeCounterThread* attribute_counter_thread_construct (GType object_type,
                                                            UMockdevTestbed* tb,
                                                            const gchar* syspath,
                                                            const gchar* name,
                                                            guint max);
void* attribute_counter_thread_run (AttributeCounterThread* self);
static void attribute_counter_thread_finalize (AttributeCounterThread * obj);
void t_mt_parallel_attr_distinct (void);
static gpointer _attribute_counter_thread_run_gthread_func (gpointer self);
void t_mt_uevent (void);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 GUdevClient* client,
                 const gchar* action,
                 GUdevDevice* device);
static void ___lambda4__g_udev_client_uevent (GUdevClient* _sender,
                                       const gchar* action,
                                       GUdevDevice* device,
                                       gpointer self);
static void* __lambda5_ (Block1Data* _data1_);
static gpointer ___lambda5__gthread_func (gpointer self);
static void* __lambda6_ (Block1Data* _data1_);
static gpointer ___lambda6__gthread_func (gpointer self);
static gboolean __lambda7_ (Block1Data* _data1_);
static gboolean ___lambda7__gsource_func (gpointer self);
gint _vala_main (gchar** args,
                 gint args_length1);
static void _t_testbed_empty_gtest_func (void);
static void _t_testbed_add_device_gtest_func (void);
static void _t_testbed_gudev_query_list_gtest_func (void);
static void _t_usbfs_ioctl_static_gtest_func (void);
static void _t_usbfs_ioctl_tree_gtest_func (void);
static void _t_usbfs_ioctl_tree_with_default_device_gtest_func (void);
static void _t_usbfs_ioctl_tree_override_default_device_gtest_func (void);
static void _t_usbfs_ioctl_tree_xz_gtest_func (void);
static void _t_tty_stty_gtest_func (void);
static void _t_tty_data_gtest_func (void);
static void _t_detects_running_in_testbed_gtest_func (void);
static void _t_detects_not_running_in_testbed_gtest_func (void);
static void _t_mt_parallel_attr_distinct_gtest_func (void);
static void _t_mt_uevent_gtest_func (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

void
tb_add_from_string (UMockdevTestbed* tb,
                    const gchar* s)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (tb != NULL);
	g_return_if_fail (s != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = umockdev_testbed_add_from_string (tb, s, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_vala_assert (_tmp0_, "tb.add_from_string (s)");
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e->message;
		fprintf (_tmp1_, "Failed to call Testbed.add_from_string(): %s\n", _tmp2_);
		abort ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
t_testbed_empty (void)
{
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_;
	GUdevEnumerator* enumerator = NULL;
	GUdevClient* _tmp1_;
	GUdevClient* _tmp2_;
	GUdevEnumerator* _tmp3_;
	GUdevEnumerator* _tmp4_;
	GList* devices = NULL;
	GList* _tmp5_;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_vala_assert (tb != NULL, "tb != null");
	_tmp1_ = g_udev_client_new (NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_udev_enumerator_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	enumerator = _tmp4_;
	_tmp5_ = g_udev_enumerator_execute (enumerator);
	devices = _tmp5_;
	g_assert_cmpuint (g_list_length (devices), ==, (guint) 0);
	(devices == NULL) ? NULL : (devices = (_g_list_free__g_object_unref0_ (devices), NULL));
	_g_object_unref0 (enumerator);
	_g_object_unref0 (tb);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
t_testbed_add_device (void)
{
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_;
	gchar* syspath = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GUdevEnumerator* enumerator = NULL;
	GUdevClient* _tmp15_;
	GUdevClient* _tmp16_;
	GUdevEnumerator* _tmp17_;
	GUdevEnumerator* _tmp18_;
	GList* devices = NULL;
	GList* _tmp19_;
	GUdevDevice* device = NULL;
	gconstpointer _tmp20_;
	GUdevDevice* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = g_strdup ("idVendor");
	_tmp2_ = g_strdup ("0815");
	_tmp3_ = g_strdup ("idProduct");
	_tmp4_ = g_strdup ("AFFE");
	_tmp5_ = g_new0 (gchar*, 4 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp2_;
	_tmp5_[2] = _tmp3_;
	_tmp5_[3] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 4;
	_tmp7_ = g_strdup ("ID_INPUT");
	_tmp8_ = g_strdup ("1");
	_tmp9_ = g_strdup ("ID_INPUT_KEYBOARD");
	_tmp10_ = g_strdup ("1");
	_tmp11_ = g_new0 (gchar*, 4 + 1);
	_tmp11_[0] = _tmp7_;
	_tmp11_[1] = _tmp8_;
	_tmp11_[2] = _tmp9_;
	_tmp11_[3] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 4;
	_tmp13_ = umockdev_testbed_add_devicev (tb, "usb", "extkeyboard1", NULL, _tmp6_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	syspath = _tmp14_;
	g_assert_cmpstr (syspath, ==, "/sys/devices/extkeyboard1");
	_tmp15_ = g_udev_client_new (NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_udev_enumerator_new (_tmp16_);
	_tmp18_ = _tmp17_;
	_g_object_unref0 (_tmp16_);
	enumerator = _tmp18_;
	_tmp19_ = g_udev_enumerator_execute (enumerator);
	devices = _tmp19_;
	g_assert_cmpuint (g_list_length (devices), ==, (guint) 1);
	_tmp20_ = g_list_nth_data (devices, (guint) 0);
	_tmp21_ = _g_object_ref0 ((GUdevDevice*) _tmp20_);
	device = _tmp21_;
	_tmp22_ = g_udev_device_get_name (device);
	g_assert_cmpstr (_tmp22_, ==, "extkeyboard1");
	_tmp23_ = g_udev_device_get_sysfs_path (device);
	g_assert_cmpstr (_tmp23_, ==, "/sys/devices/extkeyboard1");
	_tmp24_ = g_udev_device_get_subsystem (device);
	g_assert_cmpstr (_tmp24_, ==, "usb");
	_tmp25_ = g_udev_device_get_sysfs_attr (device, "idVendor");
	g_assert_cmpstr (_tmp25_, ==, "0815");
	_tmp26_ = g_udev_device_get_sysfs_attr (device, "idProduct");
	g_assert_cmpstr (_tmp26_, ==, "AFFE");
	_tmp27_ = g_udev_device_get_sysfs_attr (device, "noSuchAttr");
	g_assert_cmpstr (_tmp27_, ==, NULL);
	_tmp28_ = g_udev_device_get_property (device, "DEVPATH");
	g_assert_cmpstr (_tmp28_, ==, "/devices/extkeyboard1");
	_tmp29_ = g_udev_device_get_property (device, "SUBSYSTEM");
	g_assert_cmpstr (_tmp29_, ==, "usb");
	_tmp30_ = g_udev_device_get_property (device, "ID_INPUT");
	g_assert_cmpstr (_tmp30_, ==, "1");
	_tmp31_ = g_udev_device_get_property (device, "ID_INPUT_KEYBOARD");
	g_assert_cmpstr (_tmp31_, ==, "1");
	_tmp32_ = g_udev_device_get_property (device, "NO_SUCH_PROP");
	g_assert_cmpstr (_tmp32_, ==, NULL);
	_g_object_unref0 (device);
	(devices == NULL) ? NULL : (devices = (_g_list_free__g_object_unref0_ (devices), NULL));
	_g_object_unref0 (enumerator);
	_g_free0 (syspath);
	_g_object_unref0 (tb);
}

void
t_testbed_gudev_query_list (void)
{
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_;
	UMockdevTestbed* _tmp1_;
	GUdevClient* client = NULL;
	GUdevClient* _tmp2_;
	GList* devices = NULL;
	GUdevClient* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	tb_add_from_string (_tmp1_, "P: /devices/myusbhub/cam\n" \
"N: bus/usb/001/002\n" \
"E: SUBSYSTEM=usb\n" \
"E: DEVTYPE=usb_device\n" \
"E: DEVNAME=/dev/bus/usb/001/002\n" \
"\n" \
"P: /devices/myusbhub\n" \
"N: bus/usb/001/001\n" \
"E: SUBSYSTEM=usb\n" \
"E: DEVTYPE=usb_device\n" \
"E: DEVNAME=/dev/bus/usb/001/001\n");
	_tmp2_ = g_udev_client_new (NULL);
	client = _tmp2_;
	_tmp3_ = client;
	_tmp4_ = g_udev_client_query_by_subsystem (_tmp3_, NULL);
	devices = _tmp4_;
	_tmp5_ = devices;
	g_assert_cmpuint (g_list_length (_tmp5_), ==, (guint) 2);
	_tmp6_ = devices;
	{
		GList* dev_collection = NULL;
		GList* dev_it = NULL;
		dev_collection = _tmp6_;
		for (dev_it = dev_collection; dev_it != NULL; dev_it = dev_it->next) {
			GUdevDevice* _tmp7_;
			GUdevDevice* dev = NULL;
			_tmp7_ = _g_object_ref0 ((GUdevDevice*) dev_it->data);
			dev = _tmp7_;
			{
				GUdevDevice* _tmp8_;
				const gchar* _tmp9_;
				GUdevDevice* _tmp10_;
				const gchar* _tmp11_;
				_tmp8_ = dev;
				_tmp9_ = g_udev_device_get_subsystem (_tmp8_);
				g_assert_cmpstr (_tmp9_, ==, "usb");
				_tmp10_ = dev;
				_tmp11_ = g_udev_device_get_sysfs_path (_tmp10_);
				if (g_strcmp0 (_tmp11_, "/sys/devices/myusbhub") == 0) {
					GUdevDevice* _tmp12_;
					const gchar* _tmp13_;
					GUdevDevice* _tmp14_;
					const gchar* _tmp15_;
					_tmp12_ = dev;
					_tmp13_ = g_udev_device_get_name (_tmp12_);
					g_assert_cmpstr (_tmp13_, ==, "myusbhub");
					_tmp14_ = dev;
					_tmp15_ = g_udev_device_get_device_file (_tmp14_);
					g_assert_cmpstr (_tmp15_, ==, "/dev/bus/usb/001/001");
				} else {
					GUdevDevice* _tmp16_;
					const gchar* _tmp17_;
					GUdevDevice* _tmp18_;
					const gchar* _tmp19_;
					GUdevDevice* _tmp20_;
					const gchar* _tmp21_;
					_tmp16_ = dev;
					_tmp17_ = g_udev_device_get_sysfs_path (_tmp16_);
					g_assert_cmpstr (_tmp17_, ==, "/sys/devices/myusbhub/cam");
					_tmp18_ = dev;
					_tmp19_ = g_udev_device_get_name (_tmp18_);
					g_assert_cmpstr (_tmp19_, ==, "cam");
					_tmp20_ = dev;
					_tmp21_ = g_udev_device_get_device_file (_tmp20_);
					g_assert_cmpstr (_tmp21_, ==, "/dev/bus/usb/001/002");
				}
				_g_object_unref0 (dev);
			}
		}
	}
	(devices == NULL) ? NULL : (devices = (_g_list_free__g_object_unref0_ (devices), NULL));
	_g_object_unref0 (client);
	_g_object_unref0 (tb);
}

void
t_usbfs_ioctl_static (void)
{
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_;
	UMockdevTestbed* _tmp1_;
	gint fd = 0;
	gint i = 0;
	gint _tmp2_;
	gint _tmp3_;
	struct usbdevfs_connectinfo ci = {0};
	gint _tmp4_;
	gint fd2 = 0;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	tb_add_from_string (_tmp1_, "P: /devices/mycam\nN: 001\nE: SUBSYSTEM=usb\n");
	fd = open ("/dev/001", O_RDWR, (mode_t) 0);
	g_assert_cmpint (fd, >=, 0);
	i = 1;
	_tmp2_ = ioctl (fd, USBDEVFS_CLAIMINTERFACE, &i);
	g_assert_cmpint (_tmp2_, ==, 0);
	g_assert_cmpint (errno, ==, 0);
	_tmp3_ = ioctl (fd, USBDEVFS_GETDRIVER, &i);
	g_assert_cmpint (_tmp3_, ==, -1);
	g_assert_cmpint (errno, ==, ENODATA);
	errno = 0;
	memset (&ci, 0, sizeof (struct usbdevfs_connectinfo));
	_tmp4_ = ioctl (fd, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp4_, ==, -1);
	g_assert_cmpint (errno, >=, 22);
	errno = 0;
	g_assert_cmpint (ioctl (fd, TIOCSBRK, 0), ==, -1);
	g_assert_cmpint (errno, ==, ENOTTY);
	errno = 0;
	fd2 = open ("/dev/tty", O_RDWR, (mode_t) 0);
	if (fd2 > 0) {
		g_assert_cmpint (ioctl (fd2, TIOCSBRK, 0), ==, 0);
		g_assert_cmpint (errno, ==, 0);
		close (fd2);
	}
	close (fd);
	_g_object_unref0 (tb);
}

static guint8*
_vala_array_dup1 (guint8* self,
                  int length)
{
	return g_memdup (self, length * sizeof (guint8));
}

void
t_usbfs_ioctl_tree (void)
{
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_;
	UMockdevTestbed* _tmp1_;
	gchar* test_tree = NULL;
	gchar* tmppath = NULL;
	gint fd = 0;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint i = 0;
	gint _tmp11_;
	gint _tmp15_;
	struct usbdevfs_connectinfo ci = {0};
	gint _tmp16_;
	struct usbdevfs_connectinfo _tmp17_;
	struct usbdevfs_connectinfo _tmp18_;
	guint8* urb_buffer = NULL;
	guint8* _tmp19_;
	gint urb_buffer_length1;
	gint _urb_buffer_size_;
	struct usbdevfs_urb urb = {0};
	guint8* _tmp20_;
	gint _tmp20__length1;
	struct usbdevfs_urb _tmp21_ = {0};
	gint _tmp22_;
	struct usbdevfs_urb _tmp23_;
	guint8 _tmp24_;
	struct usbdevfs_urb* urb_reap = NULL;
	gint _tmp25_;
	struct usbdevfs_urb* _tmp26_;
	struct usbdevfs_urb _tmp27_;
	struct usbdevfs_urb _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	guint8 _tmp30_;
	struct usbdevfs_urb _tmp31_;
	guint8* _tmp32_;
	gint _tmp32__length1;
	guint8 _tmp33_;
	struct usbdevfs_urb _tmp34_;
	guint8* _tmp35_;
	gint _tmp35__length1;
	guint8 _tmp36_;
	struct usbdevfs_urb _tmp37_;
	guint8* _tmp38_;
	gint _tmp38__length1;
	guint8 _tmp39_;
	gint fd2 = 0;
	gint _tmp40_;
	struct usbdevfs_connectinfo _tmp41_;
	struct usbdevfs_connectinfo _tmp42_;
	gint _tmp43_;
	struct usbdevfs_connectinfo _tmp44_;
	struct usbdevfs_connectinfo _tmp45_;
	gint _tmp46_;
	struct usbdevfs_connectinfo _tmp47_;
	struct usbdevfs_connectinfo _tmp48_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	tb_add_from_string (_tmp1_, "P: /devices/mycam\nN: 001\nE: SUBSYSTEM=usb\n");
	if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("# little-endian test ioctls\n" \
"USBDEVFS_CONNECTINFO 0 0B00000000000000\n" \
"USBDEVFS_REAPURB 0 1 129 -1 0 4 4 0 9902AAFF\n" \
"\n" \
"# another connect info\n" \
"USBDEVFS_CONNECTINFO 42 0C00000001000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("# big-endian test ioctls\n" \
"USBDEVFS_CONNECTINFO 0 0000000B00000000\n" \
"USBDEVFS_REAPURB 0 1 129 -1 0 4 4 0 9902AAFF\n" \
"\n" \
"# another connect info\n" \
"USBDEVFS_CONNECTINFO 42 0000000C01000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp3_;
	}
	{
		gint _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gint _tmp6_;
		_tmp6_ = g_file_open_tmp ("test_ioctl_tree.XXXXXX", &_tmp5_, &_inner_error0_);
		_g_free0 (tmppath);
		tmppath = _tmp5_;
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		fd = _tmp4_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = test_tree;
	_tmp8_ = test_tree;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	g_assert_cmpint ((gint) write (fd, _tmp7_, (gsize) _tmp10_), >, 20);
	i = 1;
	_tmp11_ = ioctl (fd, USBDEVFS_CLAIMINTERFACE, &i);
	g_assert_cmpint (_tmp11_, ==, -1);
	g_assert_cmpint (errno, >=, 22);
	close (fd);
	{
		UMockdevTestbed* _tmp12_;
		_tmp12_ = tb;
		umockdev_testbed_load_ioctl (_tmp12_, "/dev/001", tmppath, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = stderr;
		_tmp14_ = e->message;
		fprintf (_tmp13_, "Cannot load ioctls: %s\n", _tmp14_);
		abort ();
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_unlink (tmppath);
	fd = open ("/dev/001", O_RDWR, (mode_t) 0);
	g_assert_cmpint (fd, >=, 0);
	_tmp15_ = ioctl (fd, USBDEVFS_CLAIMINTERFACE, &i);
	g_assert_cmpint (_tmp15_, ==, 0);
	g_assert_cmpint (errno, ==, 0);
	memset (&ci, 0, sizeof (struct usbdevfs_connectinfo));
	_tmp16_ = ioctl (fd, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp16_, ==, 0);
	g_assert_cmpint (errno, ==, 0);
	_tmp17_ = ci;
	g_assert_cmpuint (_tmp17_.devnum, ==, (guint) 11);
	_tmp18_ = ci;
	g_assert_cmpuint (_tmp18_.slow, ==, (guint) 0);
	_tmp19_ = g_new0 (guint8, 4);
	urb_buffer = _tmp19_;
	urb_buffer_length1 = 4;
	_urb_buffer_size_ = urb_buffer_length1;
	_tmp20_ = (urb_buffer != NULL) ? _vala_array_dup1 (urb_buffer, urb_buffer_length1) : ((gpointer) urb_buffer);
	_tmp20__length1 = urb_buffer_length1;
	_tmp21_.type = (guint8) 1;
	_tmp21_.endpoint = (guint8) 129;
	_tmp21_.status = 0;
	_tmp21_.flags = (guint) 0;
	_tmp21_.buffer = (g_free (_tmp21_.buffer), NULL);
	_tmp21_.buffer = _tmp20_;
	_tmp21_.buffer_length = 4;
	_tmp21_.actual_length = 0;
	urb = _tmp21_;
	_tmp22_ = ioctl (fd, USBDEVFS_SUBMITURB, &urb);
	g_assert_cmpint (_tmp22_, ==, 0);
	g_assert_cmpint (errno, ==, 0);
	_tmp23_ = urb;
	g_assert_cmpuint ((guint) _tmp23_.status, ==, (guint) 0);
	_tmp24_ = urb_buffer[0];
	g_assert_cmpint ((gint) _tmp24_, ==, 0);
	urb_reap = NULL;
	_tmp25_ = ioctl (fd, USBDEVFS_REAPURB, &urb_reap);
	g_assert_cmpint (_tmp25_, ==, 0);
	g_assert_cmpint (errno, ==, 0);
	_tmp26_ = urb_reap;
	_vala_assert (_tmp26_ == (&urb), "urb_reap == &urb");
	_tmp27_ = urb;
	g_assert_cmpint (_tmp27_.status, ==, -1);
	_tmp28_ = urb;
	_tmp29_ = _tmp28_.buffer;
	_tmp29__length1 = -1;
	_tmp30_ = _tmp29_[0];
	g_assert_cmpuint ((guint) _tmp30_, ==, (guint) 0x99);
	_tmp31_ = urb;
	_tmp32_ = _tmp31_.buffer;
	_tmp32__length1 = -1;
	_tmp33_ = _tmp32_[1];
	g_assert_cmpuint ((guint) _tmp33_, ==, (guint) 0x02);
	_tmp34_ = urb;
	_tmp35_ = _tmp34_.buffer;
	_tmp35__length1 = -1;
	_tmp36_ = _tmp35_[2];
	g_assert_cmpuint ((guint) _tmp36_, ==, (guint) 0xAA);
	_tmp37_ = urb;
	_tmp38_ = _tmp37_.buffer;
	_tmp38__length1 = -1;
	_tmp39_ = _tmp38_[3];
	g_assert_cmpuint ((guint) _tmp39_, ==, (guint) 0xFF);
	fd2 = open ("/dev/001", O_RDWR, (mode_t) 0);
	g_assert_cmpint (fd2, >=, 0);
	ci.devnum = (guint) 99;
	ci.slow = (guint) 99;
	_tmp40_ = ioctl (fd2, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp40_, ==, 0);
	g_assert_cmpint (errno, ==, 0);
	_tmp41_ = ci;
	g_assert_cmpuint (_tmp41_.devnum, ==, (guint) 11);
	_tmp42_ = ci;
	g_assert_cmpuint (_tmp42_.slow, ==, (guint) 0);
	ci.devnum = (guint) 99;
	ci.slow = (guint) 99;
	_tmp43_ = ioctl (fd, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp43_, ==, 42);
	g_assert_cmpint (errno, ==, 0);
	_tmp44_ = ci;
	g_assert_cmpuint (_tmp44_.devnum, ==, (guint) 12);
	_tmp45_ = ci;
	g_assert_cmpuint (_tmp45_.slow, ==, (guint) 1);
	close (fd);
	ci.devnum = (guint) 99;
	ci.slow = (guint) 99;
	_tmp46_ = ioctl (fd2, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp46_, ==, 42);
	g_assert_cmpint (errno, ==, 0);
	_tmp47_ = ci;
	g_assert_cmpuint (_tmp47_.devnum, ==, (guint) 12);
	_tmp48_ = ci;
	g_assert_cmpuint (_tmp48_.slow, ==, (guint) 1);
	close (fd2);
	 (&urb);
	urb_buffer = (g_free (urb_buffer), NULL);
	_g_free0 (tmppath);
	_g_free0 (test_tree);
	_g_object_unref0 (tb);
}

void
t_usbfs_ioctl_tree_with_default_device (void)
{
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_;
	UMockdevTestbed* _tmp1_;
	gchar* test_tree = NULL;
	gchar* tmppath = NULL;
	gint fd = 0;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	struct usbdevfs_connectinfo ci = {0};
	gint _tmp14_;
	struct usbdevfs_connectinfo _tmp15_;
	struct usbdevfs_connectinfo _tmp16_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	tb_add_from_string (_tmp1_, "P: /devices/mycam\nN: 001\nE: SUBSYSTEM=usb\n");
	if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("# little-endian test ioctls\n" \
"@DEV /dev/001\n" \
"USBDEVFS_CONNECTINFO 0 0B00000000000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("# big-endian test ioctls\n" \
"@DEV /dev/001\n" \
"USBDEVFS_CONNECTINFO 0 0000000B00000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp3_;
	}
	{
		gint _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gint _tmp6_;
		_tmp6_ = g_file_open_tmp ("test_ioctl_tree.XXXXXX", &_tmp5_, &_inner_error0_);
		_g_free0 (tmppath);
		tmppath = _tmp5_;
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch3_g_error;
		}
		fd = _tmp4_;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = test_tree;
	_tmp8_ = test_tree;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	g_assert_cmpint ((gint) write (fd, _tmp7_, (gsize) _tmp10_), >, 20);
	close (fd);
	{
		UMockdevTestbed* _tmp11_;
		_tmp11_ = tb;
		umockdev_testbed_load_ioctl (_tmp11_, NULL, tmppath, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = e->message;
		fprintf (_tmp12_, "Cannot load ioctls: %s\n", _tmp13_);
		abort ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_unlink (tmppath);
	fd = open ("/dev/001", O_RDWR, (mode_t) 0);
	g_assert_cmpint (fd, >=, 0);
	memset (&ci, 0, sizeof (struct usbdevfs_connectinfo));
	_tmp14_ = ioctl (fd, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp14_, ==, 0);
	g_assert_cmpint (errno, ==, 0);
	_tmp15_ = ci;
	g_assert_cmpuint (_tmp15_.devnum, ==, (guint) 11);
	_tmp16_ = ci;
	g_assert_cmpuint (_tmp16_.slow, ==, (guint) 0);
	_g_free0 (tmppath);
	_g_free0 (test_tree);
	_g_object_unref0 (tb);
}

void
t_usbfs_ioctl_tree_override_default_device (void)
{
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_;
	UMockdevTestbed* _tmp1_;
	gchar* test_tree = NULL;
	gchar* tmppath = NULL;
	gint fd = 0;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	struct usbdevfs_connectinfo ci = {0};
	gint _tmp14_;
	struct usbdevfs_connectinfo _tmp15_;
	struct usbdevfs_connectinfo _tmp16_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	tb_add_from_string (_tmp1_, "P: /devices/mycam\nN: 002\nE: SUBSYSTEM=usb\n");
	if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("# little-endian test ioctls\n" \
"@DEV /dev/001\n" \
"USBDEVFS_CONNECTINFO 0 0B00000000000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("# big-endian test ioctls\n" \
"@DEV /dev/001\n" \
"USBDEVFS_CONNECTINFO 0 0000000B00000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp3_;
	}
	{
		gint _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gint _tmp6_;
		_tmp6_ = g_file_open_tmp ("test_ioctl_tree.XXXXXX", &_tmp5_, &_inner_error0_);
		_g_free0 (tmppath);
		tmppath = _tmp5_;
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch5_g_error;
		}
		fd = _tmp4_;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = test_tree;
	_tmp8_ = test_tree;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	g_assert_cmpint ((gint) write (fd, _tmp7_, (gsize) _tmp10_), >, 20);
	close (fd);
	{
		UMockdevTestbed* _tmp11_;
		_tmp11_ = tb;
		umockdev_testbed_load_ioctl (_tmp11_, "/dev/002", tmppath, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = e->message;
		fprintf (_tmp12_, "Cannot load ioctls: %s\n", _tmp13_);
		abort ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_unlink (tmppath);
	fd = open ("/dev/002", O_RDWR, (mode_t) 0);
	g_assert_cmpint (fd, >=, 0);
	memset (&ci, 0, sizeof (struct usbdevfs_connectinfo));
	_tmp14_ = ioctl (fd, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp14_, ==, 0);
	g_assert_cmpint (errno, ==, 0);
	_tmp15_ = ci;
	g_assert_cmpuint (_tmp15_.devnum, ==, (guint) 11);
	_tmp16_ = ci;
	g_assert_cmpuint (_tmp16_.slow, ==, (guint) 0);
	_g_free0 (tmppath);
	_g_free0 (test_tree);
	_g_object_unref0 (tb);
}

void
t_usbfs_ioctl_tree_xz (void)
{
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_;
	UMockdevTestbed* _tmp1_;
	gchar* test_tree = NULL;
	gchar* tmppath = NULL;
	gint exit = 0;
	gint fd = 0;
	struct usbdevfs_connectinfo ci = {0};
	gint _tmp22_;
	struct usbdevfs_connectinfo _tmp23_;
	struct usbdevfs_connectinfo _tmp24_;
	gint _tmp25_;
	struct usbdevfs_connectinfo _tmp26_;
	struct usbdevfs_connectinfo _tmp27_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	tb_add_from_string (_tmp1_, "P: /devices/mycam\nN: 001\nE: SUBSYSTEM=usb\n");
	if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("USBDEVFS_CONNECTINFO 0 0B00000000000000\n" \
"USBDEVFS_REAPURB 0 1 129 -1 0 4 4 0 9902AAFF\n" \
"USBDEVFS_CONNECTINFO 42 0C00000001000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("USBDEVFS_CONNECTINFO 0 0000000B00000000\n" \
"USBDEVFS_REAPURB 0 1 129 -1 0 4 4 0 9902AAFF\n" \
"USBDEVFS_CONNECTINFO 42 0000000C01000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp3_;
	}
	{
		gint _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gint _tmp6_;
		_tmp6_ = g_file_open_tmp ("test_ioctl_tree.XXXXXX.xz", &_tmp5_, &_inner_error0_);
		_g_free0 (tmppath);
		tmppath = _tmp5_;
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch7_g_error;
		}
		close (_tmp4_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gint _tmp16_ = 0;
		_tmp7_ = test_tree;
		_tmp8_ = g_strconcat ("sh -c 'echo \"", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, "\" | xz -9c > ", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, tmppath, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "; sync'", NULL);
		_tmp15_ = _tmp14_;
		g_spawn_command_line_sync (_tmp15_, NULL, NULL, &_tmp16_, &_inner_error0_);
		exit = _tmp16_;
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch8_g_spawn_error;
			}
			_g_free0 (tmppath);
			_g_free0 (test_tree);
			_g_object_unref0 (tb);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally8;
	__catch8_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = stderr;
		_tmp18_ = e->message;
		fprintf (_tmp17_, "Cannot call xz: %s\n", _tmp18_);
		abort ();
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_assert_cmpint (exit, ==, 0);
	{
		UMockdevTestbed* _tmp19_;
		_tmp19_ = tb;
		umockdev_testbed_load_ioctl (_tmp19_, "/dev/001", tmppath, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		FILE* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = stderr;
		_tmp21_ = e->message;
		fprintf (_tmp20_, "Cannot load ioctls: %s\n", _tmp21_);
		abort ();
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_unlink (tmppath);
	fd = open ("/dev/001", O_RDWR, (mode_t) 0);
	g_assert_cmpint (fd, >=, 0);
	memset (&ci, 0, sizeof (struct usbdevfs_connectinfo));
	_tmp22_ = ioctl (fd, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp22_, ==, 0);
	g_assert_cmpint (errno, ==, 0);
	_tmp23_ = ci;
	g_assert_cmpuint (_tmp23_.devnum, ==, (guint) 11);
	_tmp24_ = ci;
	g_assert_cmpuint (_tmp24_.slow, ==, (guint) 0);
	_tmp25_ = ioctl (fd, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp25_, ==, 42);
	g_assert_cmpint (errno, ==, 0);
	_tmp26_ = ci;
	g_assert_cmpuint (_tmp26_.devnum, ==, (guint) 12);
	_tmp27_ = ci;
	g_assert_cmpuint (_tmp27_.slow, ==, (guint) 1);
	close (fd);
	_g_free0 (tmppath);
	_g_free0 (test_tree);
	_g_object_unref0 (tb);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
t_tty_stty (void)
{
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_;
	struct stat st = {0};
	struct stat _tmp1_ = {0};
	gint _tmp2_;
	struct stat _tmp3_;
	struct stat _tmp4_;
	struct stat _tmp5_;
	gchar* pout = NULL;
	gchar* perr = NULL;
	gint pexit = 0;
	GError* _inner_error0_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	tb_add_from_string (tb, "P: /devices/usb/tty/ttyUSB1\n" \
"N: ttyUSB1\n" \
"E: DEVNAME=/dev/ttyUSB1\n" \
"E: SUBSYSTEM=tty\n" \
"A: dev=188:1\n");
	_tmp2_ = lstat ("/dev/ttyUSB1", &_tmp1_);
	st = _tmp1_;
	g_assert_cmpint (_tmp2_, ==, 0);
	_tmp3_ = st;
	_vala_assert (S_ISCHR (_tmp3_.st_mode), "Posix.S_ISCHR (st.st_mode)");
	_tmp4_ = st;
	g_assert_cmpuint (major (_tmp4_.st_rdev), ==, (guint) 188);
	_tmp5_ = st;
	g_assert_cmpuint (minor (_tmp5_.st_rdev), ==, (guint) 1);
	{
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		g_spawn_command_line_sync ("stty -F /dev/ttyUSB1", &_tmp6_, &_tmp7_, &_tmp8_, &_inner_error0_);
		_g_free0 (pout);
		pout = _tmp6_;
		_g_free0 (perr);
		perr = _tmp7_;
		pexit = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch10_g_spawn_error;
			}
			_g_free0 (perr);
			_g_free0 (pout);
			_g_object_unref0 (tb);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally10;
	__catch10_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = stderr;
		_tmp10_ = e->message;
		fprintf (_tmp9_, "Cannot call stty: %s\n", _tmp10_);
		abort ();
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (perr);
		_g_free0 (pout);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_assert_cmpstr (perr, ==, "");
	g_assert_cmpint (pexit, ==, 0);
	_vala_assert (string_contains (pout, "speed 38400 baud"), "pout.contains (\"speed 38400 baud\")");
	_g_free0 (perr);
	_g_free0 (pout);
	_g_object_unref0 (tb);
}

void
t_tty_data (void)
{
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_;
	gint client_fd = 0;
	gint master_fd = 0;
	gchar* buf = NULL;
	gchar* _tmp1_;
	gint buf_length1;
	gint _buf_size_;
	gchar* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gint _tmp6__length1;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	tb_add_from_string (tb, "P: /devices/serial/ttyS10\n" \
"N: ttyS10\n" \
"E: DEVNAME=/dev/ttyS10\n" \
"E: SUBSYSTEM=tty\n" \
"A: dev=4:74\n");
	client_fd = open ("/dev/ttyS10", O_RDWR, (mode_t) 0);
	g_assert_cmpint (client_fd, >=, 0);
	master_fd = umockdev_testbed_get_dev_fd (tb, "/dev/ttyS10");
	g_assert_cmpint (master_fd, >=, 0);
	_tmp1_ = g_new0 (gchar, 100);
	buf = _tmp1_;
	buf_length1 = 100;
	_buf_size_ = buf_length1;
	g_assert_cmpint ((gint) write (client_fd, "hello\n", (gsize) 6), ==, 6);
	_tmp2_ = buf;
	_tmp2__length1 = buf_length1;
	g_assert_cmpint ((gint) read (master_fd, _tmp2_, (gsize) 100), ==, 6);
	_tmp3_ = buf;
	_tmp3__length1 = buf_length1;
	g_assert_cmpstr ((const gchar*) _tmp3_, ==, "hello\n");
	_tmp4_ = g_new0 (gchar, 100);
	buf = (g_free (buf), NULL);
	buf = _tmp4_;
	buf_length1 = 100;
	_buf_size_ = buf_length1;
	g_assert_cmpint ((gint) write (master_fd, "world\n", (gsize) 6), ==, 6);
	_tmp5_ = buf;
	_tmp5__length1 = buf_length1;
	g_assert_cmpint ((gint) read (client_fd, _tmp5_, (gsize) 100), ==, 6);
	_tmp6_ = buf;
	_tmp6__length1 = buf_length1;
	g_assert_cmpstr ((const gchar*) _tmp6_, ==, "world\n");
	close (client_fd);
	buf = (g_free (buf), NULL);
	_g_object_unref0 (tb);
}

void
t_detects_running_in_testbed (void)
{
	_vala_assert (umockdev_in_mock_environment (), "UMockdev.in_mock_environment()");
}

void
t_detects_not_running_in_testbed (void)
{
	gint pipefds[2] = {0};
	pid_t pid = 0;
	gint _tmp6_;
	gchar buf = '\0';
	gint _tmp7_;
	gint _tmp8_;
	g_assert_cmpint (pipe (pipefds), ==, 0);
	pid = fork ();
	g_assert_cmpint ((gint) pid, !=, -1);
	if (pid == ((pid_t) 0)) {
		gint _tmp0_;
		gchar** argv = NULL;
		gchar* _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gint argv_length1;
		gint _argv_size_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		_tmp0_ = pipefds[0];
		close (_tmp0_);
		g_unsetenv ("LD_PRELOAD");
		_tmp1_ = g_strdup ("--test-outside-testbed");
		_tmp2_ = pipefds[1];
		_tmp3_ = g_strdup_printf ("%i", _tmp2_);
		_tmp4_ = g_new0 (gchar*, 2 + 1);
		_tmp4_[0] = _tmp1_;
		_tmp4_[1] = _tmp3_;
		argv = _tmp4_;
		argv_length1 = 2;
		_argv_size_ = argv_length1;
		_tmp5_ = argv;
		_tmp5__length1 = argv_length1;
		execv ("/proc/self/exe", _tmp5_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp6_ = pipefds[1];
	close (_tmp6_);
	buf = 'x';
	_tmp7_ = pipefds[0];
	g_assert_cmpint ((gint) read (_tmp7_, &buf, (gsize) 1), ==, 1);
	g_assert_cmpint ((gint) buf, ==, (gint) '0');
	_tmp8_ = pipefds[0];
	close (_tmp8_);
}

gint
is_test_inside_testbed (gint pipefd)
{
	gint result = 0;
	gchar buf[1] = {0};
	buf[0] = '0';
	if (umockdev_in_mock_environment ()) {
		buf[0] = '1';
	}
	write (pipefd, buf, (gsize) 1);
	result = atoi ((const gchar*) buf);
	return result;
}

static inline gpointer
attribute_counter_thread_get_instance_private (AttributeCounterThread* self)
{
	return G_STRUCT_MEMBER_P (self, AttributeCounterThread_private_offset);
}

AttributeCounterThread*
attribute_counter_thread_construct (GType object_type,
                                    UMockdevTestbed* tb,
                                    const gchar* syspath,
                                    const gchar* name,
                                    guint max)
{
	AttributeCounterThread* self = NULL;
	UMockdevTestbed* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (tb != NULL, NULL);
	g_return_val_if_fail (syspath != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (AttributeCounterThread*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (tb);
	_g_object_unref0 (self->priv->tb);
	self->priv->tb = _tmp0_;
	_tmp1_ = g_strdup (syspath);
	_g_free0 (self->priv->syspath);
	self->priv->syspath = _tmp1_;
	_tmp2_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp2_;
	self->priv->count = max;
	return self;
}

AttributeCounterThread*
attribute_counter_thread_new (UMockdevTestbed* tb,
                              const gchar* syspath,
                              const gchar* name,
                              guint max)
{
	return attribute_counter_thread_construct (TYPE_ATTRIBUTE_COUNTER_THREAD, tb, syspath, name, max);
}

void*
attribute_counter_thread_run (AttributeCounterThread* self)
{
	void* result = NULL;
	gchar* attr_path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->syspath;
	_tmp1_ = self->priv->name;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, NULL);
	attr_path = _tmp2_;
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			gchar* cur_value = NULL;
			UMockdevTestbed* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			if (!_tmp3_) {
				self->priv->count = self->priv->count - 1;
			}
			_tmp3_ = FALSE;
			if (!(self->priv->count > ((guint) 0))) {
				break;
			}
			{
				const gchar* _tmp4_;
				gchar* _tmp5_ = NULL;
				_tmp4_ = attr_path;
				g_file_get_contents (_tmp4_, &_tmp5_, NULL, &_inner_error0_);
				_g_free0 (cur_value);
				cur_value = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_FILE_ERROR) {
						goto __catch11_g_file_error;
					}
					_g_free0 (cur_value);
					_g_free0 (attr_path);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			goto __finally11;
			__catch11_g_file_error:
			{
				GError* e = NULL;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp6_ = attr_path;
				_tmp7_ = e->message;
				g_error ("test-umockdev-vala.vala:552: (count %u) failed to read %s: %s", self->priv->count, _tmp6_, _tmp7_);
				_g_error_free0 (e);
			}
			__finally11:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (cur_value);
				_g_free0 (attr_path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp8_ = self->priv->tb;
			_tmp9_ = self->priv->syspath;
			_tmp10_ = self->priv->name;
			_tmp11_ = cur_value;
			umockdev_testbed_set_attribute_int (_tmp8_, _tmp9_, _tmp10_, atoi (_tmp11_) + 1);
			_g_free0 (cur_value);
		}
	}
	result = NULL;
	_g_free0 (attr_path);
	return result;
}

static void
value_attribute_counter_thread_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_attribute_counter_thread_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		attribute_counter_thread_unref (value->data[0].v_pointer);
	}
}

static void
value_attribute_counter_thread_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = attribute_counter_thread_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_attribute_counter_thread_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_attribute_counter_thread_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AttributeCounterThread * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = attribute_counter_thread_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_attribute_counter_thread_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	AttributeCounterThread ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = attribute_counter_thread_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_attribute_counter_thread (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ParamSpecAttributeCounterThread* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ATTRIBUTE_COUNTER_THREAD), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_attribute_counter_thread (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ATTRIBUTE_COUNTER_THREAD), NULL);
	return value->data[0].v_pointer;
}

void
value_set_attribute_counter_thread (GValue* value,
                                    gpointer v_object)
{
	AttributeCounterThread * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ATTRIBUTE_COUNTER_THREAD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ATTRIBUTE_COUNTER_THREAD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		attribute_counter_thread_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		attribute_counter_thread_unref (old);
	}
}

void
value_take_attribute_counter_thread (GValue* value,
                                     gpointer v_object)
{
	AttributeCounterThread * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ATTRIBUTE_COUNTER_THREAD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ATTRIBUTE_COUNTER_THREAD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		attribute_counter_thread_unref (old);
	}
}

static void
attribute_counter_thread_class_init (AttributeCounterThreadClass * klass,
                                     gpointer klass_data)
{
	attribute_counter_thread_parent_class = g_type_class_peek_parent (klass);
	((AttributeCounterThreadClass *) klass)->finalize = attribute_counter_thread_finalize;
	g_type_class_adjust_private_offset (klass, &AttributeCounterThread_private_offset);
}

static void
attribute_counter_thread_instance_init (AttributeCounterThread * self,
                                        gpointer klass)
{
	self->priv = attribute_counter_thread_get_instance_private (self);
	self->ref_count = 1;
}

static void
attribute_counter_thread_finalize (AttributeCounterThread * obj)
{
	AttributeCounterThread * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ATTRIBUTE_COUNTER_THREAD, AttributeCounterThread);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->tb);
	_g_free0 (self->priv->name);
	_g_free0 (self->priv->syspath);
}

GType
attribute_counter_thread_get_type (void)
{
	static volatile gsize attribute_counter_thread_type_id__volatile = 0;
	if (g_once_init_enter (&attribute_counter_thread_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_attribute_counter_thread_init, value_attribute_counter_thread_free_value, value_attribute_counter_thread_copy_value, value_attribute_counter_thread_peek_pointer, "p", value_attribute_counter_thread_collect_value, "p", value_attribute_counter_thread_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AttributeCounterThreadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) attribute_counter_thread_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AttributeCounterThread), 0, (GInstanceInitFunc) attribute_counter_thread_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType attribute_counter_thread_type_id;
		attribute_counter_thread_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AttributeCounterThread", &g_define_type_info, &g_define_type_fundamental_info, 0);
		AttributeCounterThread_private_offset = g_type_add_instance_private (attribute_counter_thread_type_id, sizeof (AttributeCounterThreadPrivate));
		g_once_init_leave (&attribute_counter_thread_type_id__volatile, attribute_counter_thread_type_id);
	}
	return attribute_counter_thread_type_id__volatile;
}

gpointer
attribute_counter_thread_ref (gpointer instance)
{
	AttributeCounterThread * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
attribute_counter_thread_unref (gpointer instance)
{
	AttributeCounterThread * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ATTRIBUTE_COUNTER_THREAD_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gpointer
_attribute_counter_thread_run_gthread_func (gpointer self)
{
	gpointer result;
	result = attribute_counter_thread_run ((AttributeCounterThread*) self);
	return result;
}

void
t_mt_parallel_attr_distinct (void)
{
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_;
	gchar* syspath = NULL;
	UMockdevTestbed* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar* _tmp13_;
	AttributeCounterThread* t1d = NULL;
	UMockdevTestbed* _tmp14_;
	const gchar* _tmp15_;
	AttributeCounterThread* _tmp16_;
	AttributeCounterThread* t2d = NULL;
	UMockdevTestbed* _tmp17_;
	const gchar* _tmp18_;
	AttributeCounterThread* _tmp19_;
	AttributeCounterThread* t3d = NULL;
	UMockdevTestbed* _tmp20_;
	const gchar* _tmp21_;
	AttributeCounterThread* _tmp22_;
	GThread* t1 = NULL;
	AttributeCounterThread* _tmp23_;
	GThread* _tmp24_;
	GThread* t2 = NULL;
	AttributeCounterThread* _tmp25_;
	GThread* _tmp26_;
	GThread* t3 = NULL;
	AttributeCounterThread* _tmp27_;
	GThread* _tmp28_;
	GThread* _tmp29_;
	GThread* _tmp30_;
	GThread* _tmp31_;
	gchar* val = NULL;
	GError* _inner_error0_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	_tmp2_ = g_strdup ("c1");
	_tmp3_ = g_strdup ("0");
	_tmp4_ = g_strdup ("c2");
	_tmp5_ = g_strdup ("0");
	_tmp6_ = g_strdup ("c3");
	_tmp7_ = g_strdup ("0");
	_tmp8_ = g_new0 (gchar*, 6 + 1);
	_tmp8_[0] = _tmp2_;
	_tmp8_[1] = _tmp3_;
	_tmp8_[2] = _tmp4_;
	_tmp8_[3] = _tmp5_;
	_tmp8_[4] = _tmp6_;
	_tmp8_[5] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 6;
	_tmp10_ = g_new0 (gchar*, 0 + 1);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 0;
	_tmp12_ = umockdev_testbed_add_devicev (_tmp1_, "changelings", "rapid", NULL, _tmp9_, _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	syspath = _tmp13_;
	_tmp14_ = tb;
	_tmp15_ = syspath;
	_tmp16_ = attribute_counter_thread_new (_tmp14_, _tmp15_, "c1", (guint) 100);
	t1d = _tmp16_;
	_tmp17_ = tb;
	_tmp18_ = syspath;
	_tmp19_ = attribute_counter_thread_new (_tmp17_, _tmp18_, "c2", (guint) 100);
	t2d = _tmp19_;
	_tmp20_ = tb;
	_tmp21_ = syspath;
	_tmp22_ = attribute_counter_thread_new (_tmp20_, _tmp21_, "c3", (guint) 100);
	t3d = _tmp22_;
	_tmp23_ = t1d;
	_tmp24_ = g_thread_new ("t_c1", _attribute_counter_thread_run_gthread_func, attribute_counter_thread_ref (_tmp23_));
	t1 = _tmp24_;
	_tmp25_ = t2d;
	_tmp26_ = g_thread_new ("t_c2", _attribute_counter_thread_run_gthread_func, attribute_counter_thread_ref (_tmp25_));
	t2 = _tmp26_;
	_tmp27_ = t3d;
	_tmp28_ = g_thread_new ("t_c3", _attribute_counter_thread_run_gthread_func, attribute_counter_thread_ref (_tmp27_));
	t3 = _tmp28_;
	_tmp29_ = t1;
	t1 = NULL;
	g_thread_join (_tmp29_);
	_tmp30_ = t2;
	t2 = NULL;
	g_thread_join (_tmp30_);
	_tmp31_ = t3;
	t3 = NULL;
	g_thread_join (_tmp31_);
	{
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_ = NULL;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_ = NULL;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_ = NULL;
		const gchar* _tmp46_;
		_tmp32_ = syspath;
		_tmp33_ = g_build_filename (_tmp32_, "c1", NULL);
		_tmp34_ = _tmp33_;
		g_file_get_contents (_tmp34_, &_tmp35_, NULL, &_inner_error0_);
		_g_free0 (val);
		val = _tmp35_;
		_g_free0 (_tmp34_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch12_g_file_error;
			}
			_g_free0 (val);
			_g_thread_unref0 (t3);
			_g_thread_unref0 (t2);
			_g_thread_unref0 (t1);
			_attribute_counter_thread_unref0 (t3d);
			_attribute_counter_thread_unref0 (t2d);
			_attribute_counter_thread_unref0 (t1d);
			_g_free0 (syspath);
			_g_object_unref0 (tb);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp36_ = val;
		g_assert_cmpstr (_tmp36_, ==, "100");
		_tmp37_ = syspath;
		_tmp38_ = g_build_filename (_tmp37_, "c2", NULL);
		_tmp39_ = _tmp38_;
		g_file_get_contents (_tmp39_, &_tmp40_, NULL, &_inner_error0_);
		_g_free0 (val);
		val = _tmp40_;
		_g_free0 (_tmp39_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch12_g_file_error;
			}
			_g_free0 (val);
			_g_thread_unref0 (t3);
			_g_thread_unref0 (t2);
			_g_thread_unref0 (t1);
			_attribute_counter_thread_unref0 (t3d);
			_attribute_counter_thread_unref0 (t2d);
			_attribute_counter_thread_unref0 (t1d);
			_g_free0 (syspath);
			_g_object_unref0 (tb);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp41_ = val;
		g_assert_cmpstr (_tmp41_, ==, "100");
		_tmp42_ = syspath;
		_tmp43_ = g_build_filename (_tmp42_, "c3", NULL);
		_tmp44_ = _tmp43_;
		g_file_get_contents (_tmp44_, &_tmp45_, NULL, &_inner_error0_);
		_g_free0 (val);
		val = _tmp45_;
		_g_free0 (_tmp44_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch12_g_file_error;
			}
			_g_free0 (val);
			_g_thread_unref0 (t3);
			_g_thread_unref0 (t2);
			_g_thread_unref0 (t1);
			_attribute_counter_thread_unref0 (t3d);
			_attribute_counter_thread_unref0 (t2d);
			_attribute_counter_thread_unref0 (t1d);
			_g_free0 (syspath);
			_g_object_unref0 (tb);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp46_ = val;
		g_assert_cmpstr (_tmp46_, ==, "100");
	}
	goto __finally12;
	__catch12_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp47_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp47_ = e->message;
		g_error ("test-umockdev-vala.vala:595: failed to read attribute: %s", _tmp47_);
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (val);
		_g_thread_unref0 (t3);
		_g_thread_unref0 (t2);
		_g_thread_unref0 (t1);
		_attribute_counter_thread_unref0 (t3d);
		_attribute_counter_thread_unref0 (t2d);
		_attribute_counter_thread_unref0 (t1d);
		_g_free0 (syspath);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (val);
	_g_thread_unref0 (t3);
	_g_thread_unref0 (t2);
	_g_thread_unref0 (t1);
	_attribute_counter_thread_unref0 (t3d);
	_attribute_counter_thread_unref0 (t2d);
	_attribute_counter_thread_unref0 (t1d);
	_g_free0 (syspath);
	_g_object_unref0 (tb);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_free0 (_data1_->syspath);
		_g_main_loop_unref0 (_data1_->ml);
		_g_object_unref0 (_data1_->tb);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda4_ (Block1Data* _data1_,
            GUdevClient* client,
            const gchar* action,
            GUdevDevice* device)
{
	g_return_if_fail (client != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (device != NULL);
	if (g_strcmp0 (action, "add") == 0) {
		guint _tmp0_;
		_tmp0_ = _data1_->add_count;
		_data1_->add_count = _tmp0_ + 1;
	} else {
		_data1_->change_count = _data1_->change_count + 1;
		if (_data1_->change_count == _data1_->num_changes) {
			g_main_loop_quit (_data1_->ml);
		}
	}
}

static void
___lambda4__g_udev_client_uevent (GUdevClient* _sender,
                                  const gchar* action,
                                  GUdevDevice* device,
                                  gpointer self)
{
	__lambda4_ (self, _sender, action, device);
}

static void*
__lambda5_ (Block1Data* _data1_)
{
	void* result = NULL;
	gchar* contents = NULL;
	GError* _inner_error0_ = NULL;
	while (TRUE) {
		const gchar* _tmp2_;
		if (!g_main_loop_is_running (_data1_->ml)) {
			break;
		}
		{
			gchar* _tmp0_ = NULL;
			g_file_get_contents ("/sys/devices/dev1/a", &_tmp0_, NULL, &_inner_error0_);
			_g_free0 (contents);
			contents = _tmp0_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch13_g_file_error;
				}
				_g_free0 (contents);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		goto __finally13;
		__catch13_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp1_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp1_ = e->message;
			g_error ("test-umockdev-vala.vala:630: (#changes: %u) Error opening attribute fi" \
"le: %s", _data1_->change_count, _tmp1_);
			_g_error_free0 (e);
		}
		__finally13:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = contents;
		g_assert_cmpstr (_tmp2_, ==, "1");
		umockdev_testbed_set_property (_data1_->tb, _data1_->syspath, "ID_FOO", "1");
	}
	result = NULL;
	_g_free0 (contents);
	return result;
}

static gpointer
___lambda5__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda5_ (self);
	block1_data_unref (self);
	return result;
}

static void*
__lambda6_ (Block1Data* _data1_)
{
	void* result = NULL;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i = i + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < _data1_->num_changes)) {
					break;
				}
				umockdev_testbed_uevent (_data1_->tb, _data1_->syspath, "change");
			}
		}
	}
	result = NULL;
	return result;
}

static gpointer
___lambda6__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda6_ (self);
	block1_data_unref (self);
	return result;
}

static gboolean
__lambda7_ (Block1Data* _data1_)
{
	gboolean result = FALSE;
	g_main_loop_quit (_data1_->ml);
	result = FALSE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ (self);
	return result;
}

void
t_mt_uevent (void)
{
	Block1Data* _data1_;
	UMockdevTestbed* _tmp0_;
	GUdevClient* gudev = NULL;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GUdevClient* _tmp4_;
	GUdevClient* _tmp5_;
	GMainLoop* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GThread* t_noise = NULL;
	GThread* _tmp17_;
	GThread* t_emitter = NULL;
	GThread* _tmp18_;
	GThread* _tmp19_;
	GThread* _tmp20_;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = umockdev_testbed_new ();
	_data1_->tb = _tmp0_;
	_tmp1_ = g_strdup ("pci");
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = g_udev_client_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	gudev = _tmp5_;
	_tmp6_ = g_main_loop_new (NULL, FALSE);
	_data1_->ml = _tmp6_;
	_data1_->add_count = (guint) 0;
	_data1_->change_count = (guint) 0;
	_data1_->num_changes = (guint) 10;
	g_signal_connect_data (gudev, "uevent", (GCallback) ___lambda4__g_udev_client_uevent, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp7_ = g_strdup ("a");
	_tmp8_ = g_strdup ("1");
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = g_strdup ("DEVTYPE");
	_tmp12_ = g_strdup ("fancy");
	_tmp13_ = g_new0 (gchar*, 2 + 1);
	_tmp13_[0] = _tmp11_;
	_tmp13_[1] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 2;
	_tmp15_ = umockdev_testbed_add_devicev (_data1_->tb, "pci", "dev1", NULL, _tmp10_, _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_data1_->syspath = _tmp16_;
	_tmp17_ = g_thread_new ("noise", ___lambda5__gthread_func, block1_data_ref (_data1_));
	t_noise = _tmp17_;
	_tmp18_ = g_thread_new ("emitter", ___lambda6__gthread_func, block1_data_ref (_data1_));
	t_emitter = _tmp18_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 3000, ___lambda7__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	g_main_loop_run (_data1_->ml);
	_tmp19_ = t_emitter;
	t_emitter = NULL;
	g_thread_join (_tmp19_);
	_tmp20_ = t_noise;
	t_noise = NULL;
	g_thread_join (_tmp20_);
	g_assert_cmpuint (_data1_->add_count, ==, (guint) 1);
	g_assert_cmpuint (_data1_->change_count, ==, _data1_->num_changes);
	_g_thread_unref0 (t_emitter);
	_g_thread_unref0 (t_noise);
	_g_object_unref0 (gudev);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
_t_testbed_empty_gtest_func (void)
{
	t_testbed_empty ();
}

static void
_t_testbed_add_device_gtest_func (void)
{
	t_testbed_add_device ();
}

static void
_t_testbed_gudev_query_list_gtest_func (void)
{
	t_testbed_gudev_query_list ();
}

static void
_t_usbfs_ioctl_static_gtest_func (void)
{
	t_usbfs_ioctl_static ();
}

static void
_t_usbfs_ioctl_tree_gtest_func (void)
{
	t_usbfs_ioctl_tree ();
}

static void
_t_usbfs_ioctl_tree_with_default_device_gtest_func (void)
{
	t_usbfs_ioctl_tree_with_default_device ();
}

static void
_t_usbfs_ioctl_tree_override_default_device_gtest_func (void)
{
	t_usbfs_ioctl_tree_override_default_device ();
}

static void
_t_usbfs_ioctl_tree_xz_gtest_func (void)
{
	t_usbfs_ioctl_tree_xz ();
}

static void
_t_tty_stty_gtest_func (void)
{
	t_tty_stty ();
}

static void
_t_tty_data_gtest_func (void)
{
	t_tty_data ();
}

static void
_t_detects_running_in_testbed_gtest_func (void)
{
	t_detects_running_in_testbed ();
}

static void
_t_detects_not_running_in_testbed_gtest_func (void)
{
	t_detects_not_running_in_testbed ();
}

static void
_t_mt_parallel_attr_distinct_gtest_func (void)
{
	t_mt_parallel_attr_distinct ();
}

static void
_t_mt_uevent_gtest_func (void)
{
	t_mt_uevent ();
}

gint
_vala_main (gchar** args,
            gint args_length1)
{
	gint result = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < args_length1)) {
					break;
				}
				_tmp2_ = args[i];
				if (g_strcmp0 (_tmp2_, "--test-outside-testbed") == 0) {
					const gchar* _tmp3_;
					_tmp3_ = args[i + 1];
					result = is_test_inside_testbed (atoi (_tmp3_));
					return result;
				}
			}
		}
	}
	g_test_init ((gint*) (&args_length1), &args, NULL);
	g_test_add_func ("/umockdev-testbed-vala/empty", _t_testbed_empty_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/add_devicev", _t_testbed_add_device_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/gudev-query-list", _t_testbed_gudev_query_list_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/usbfs_ioctl_static", _t_usbfs_ioctl_static_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/usbfs_ioctl_tree", _t_usbfs_ioctl_tree_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/usbfs_ioctl_tree_with_default_device", _t_usbfs_ioctl_tree_with_default_device_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/usbfs_ioctl_tree_override_default_device", _t_usbfs_ioctl_tree_override_default_device_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/usbfs_ioctl_tree_xz", _t_usbfs_ioctl_tree_xz_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/tty_stty", _t_tty_stty_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/tty_data", _t_tty_data_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/detects_running_in_testbed", _t_detects_running_in_testbed_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/detects_running_outside_testbed", _t_detects_not_running_in_testbed_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/mt_parallel_attr_distinct", _t_mt_parallel_attr_distinct_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/mt_uevent", _t_mt_uevent_gtest_func);
	result = g_test_run ();
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

