/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#include "CIM_LogicalElement.h"
using namespace CimClassNamespace;

CIM_LogicalElement::CIM_LogicalElement(
		const string& objName,
		const string& uri,
		const string& ns,
		const string& nsPrefix)
		:CIM_ManagedSystemElement(objName, uri, ns, nsPrefix){}

void  CIM_LogicalElement::SerializeMembers(XMLElement& node) const
{
	if(CaptionSpecified)
	{
		node.AppendLeaf("Caption", Caption, CIM_LogicalElement::CLASS_URI, CIM_LogicalElement::CLASS_NS_PREFIX);
	}
	if(DescriptionSpecified)
	{
		node.AppendLeaf("Description", Description, CIM_LogicalElement::CLASS_URI, CIM_LogicalElement::CLASS_NS_PREFIX);
	}
	if(ElementNameSpecified)
	{
		node.AppendLeaf("ElementName", ElementName, CIM_LogicalElement::CLASS_URI, CIM_LogicalElement::CLASS_NS_PREFIX);
	}
	if(HealthStateSpecified)
	{
		node.AppendLeaf("HealthState", HealthState, CIM_LogicalElement::CLASS_URI, CIM_LogicalElement::CLASS_NS_PREFIX);
	}
	if(InstallDateSpecified)
	{
		node.AppendLeaf("InstallDate", InstallDate, CIM_LogicalElement::CLASS_URI, CIM_LogicalElement::CLASS_NS_PREFIX);
	}
	if(NameSpecified)
	{
		node.AppendLeaf("Name", Name, CIM_LogicalElement::CLASS_URI, CIM_LogicalElement::CLASS_NS_PREFIX);
	}
	node.AppendLeafArray("OperationalStatus", OperationalStatus, CIM_LogicalElement::CLASS_URI, CIM_LogicalElement::CLASS_NS_PREFIX);
	if(StatusSpecified)
	{
		node.AppendLeaf("Status", Status, CIM_LogicalElement::CLASS_URI, CIM_LogicalElement::CLASS_NS_PREFIX);
	}
	node.AppendLeafArray("StatusDescriptions", StatusDescriptions, CIM_LogicalElement::CLASS_URI, CIM_LogicalElement::CLASS_NS_PREFIX);
}

NameValuePairs CIM_LogicalElement::GetSelectorsList() const
{
	NameValuePairs serList;
	return serList;
}

void CIM_LogicalElement::SetValue(const XMLElement& node)
{
	string name = node.GetNodeName();
	if(name == "HealthState")
	{
		node.SetValue(HealthState);
		HealthStateSpecified = true;
	}
	else if(name == "Status")
	{
		node.SetValue(Status);
		StatusSpecified = true;
	}
	else if(name == "StatusDescriptions")
	{
		node.AddValue(StatusDescriptions);
	}
	else if(name == "OperationalStatus")
	{
		node.AddValue(OperationalStatus);
	}
	else if(name == "Name")
	{
		node.SetValue(Name);
		NameSpecified = true;
	}
	else if(name == "InstallDate")
	{
		node.SetValue(InstallDate);
		InstallDateSpecified = true;
	}
	else if(name == "Caption")
	{
		node.SetValue(Caption);
		CaptionSpecified = true;
	}
	else if(name == "Description")
	{
		node.SetValue(Description);
		DescriptionSpecified = true;
	}
	else if(name == "ElementName")
	{
		node.SetValue(ElementName);
		ElementNameSpecified = true;
	}
}

const string CIM_LogicalElement::CLASS_NAME = "CIM_LogicalElement";
const string CIM_LogicalElement::CLASS_URI = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_LogicalElement";
const string CIM_LogicalElement::CLASS_NS = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_LogicalElement";
const string CIM_LogicalElement::CLASS_NS_PREFIX = "";
