/*
    Copyright (C) 2001-2006  Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef LOGIN_H
#define LOGIN_H

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

#ifdef HAVE_ERR_H
#include <err.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifdef HAVE_PATHS_H
#include <paths.h>
#else
#ifndef _PATH_DEV
#define _PATH_DEV	"/dev/"
#endif
#endif

#ifdef HAVE_LASTLOG_H
#include <lastlog.h>
#endif

#ifndef _PATH_LASTLOG
#define _PATH_LASTLOG	"/var/adm/lastlog"
#endif

#ifdef UTMPX_FORMAT
#include <utmpx.h>
#ifndef UT_HOSTSIZE
#define UT_HOSTSIZE 256
#define UT_LINESIZE 32
#define UT_NAMESIZE 32
#endif
typedef struct utmpx UTMP;
#else
typedef struct utmp UTMP;
#endif

#define setutent setutxent
#define ut_xtime ut_tv.tv_sec

#define TIMEBUFSIZE	64

#ifdef HAVE_PROCFS
#ifdef HAVE_DIRENT_H
#include <dirent.h>
DIR *procdir;
#endif
#endif

#ifdef HAVE_KVM_H
#include <sys/param.h>
#include <sys/sysctl.h>
#include <sys/user.h>
#include <kvm.h>
static kvm_t *kd;
#endif

#define LOGIN_OPTION_ORDER	"pdimyhtl"
#define LOGIN_OPTION_STRING	"Lpdimyhtl:"

static char options[9];		/* NULL terminated. */
static char *last_options;
static char **strings;
static int lastlogfd;
static time_t now;
static int login_count;

char *parentpid(uid_t, int, char *);
void add_string(char ***, const char *);
char *stamp(time_t, const char *);

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

#endif
