/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#include "utouch_plugin.h"

#include <qdeclarative.h>

#include "device.h"
#include "gesture.h"
#include "gestureevent.h"
#include "touch.h"
#include "utouchdragarea.h"
#include "utouchpincharea.h"
#include "utouchrotatearea.h"
#include "utouchtaparea.h"

void uTouchPlugin::registerTypes(const char* uri) {
  qmlRegisterType< UTouchDragArea >(uri, 1, 0, "UTouchDragArea");
  qmlRegisterType< UTouchPinchArea >(uri, 1, 0, "UTouchPinchArea");
  qmlRegisterType< UTouchRotateArea >(uri, 1, 0, "UTouchRotateArea");
  qmlRegisterType< UTouchTapArea >(uri, 1, 0, "UTouchTapArea");
  qmlRegisterType< Gesture >();
  qmlRegisterType< TouchLimits >();
  qmlRegisterType< GestureEvent >();
  qmlRegisterType< GestureProperty >();
  qmlRegisterType< Touch >();
  qmlRegisterType< Device >();
  qmlRegisterType< AxisInfo >();
}

Q_EXPORT_PLUGIN2(uTouch, uTouchPlugin)
