import sys
from optparse import OptionParser

class CommandLineLoader(object):

    def __init__(self, args=None):
        """
        This loads the options from the command line. This will specifically
        parse out command line settings which match the name of an option. For
        example if you have an option named "foo" then you can change it like
        so on the command line:

        program --foo bar

        With the above, ``foo`` has "bar" for a value.

        :Parameters:
          - `args` (optional): Source of arguments, defaults to ``sys.argv[1:]``
        """
        self.args = args or sys.argv[1:]

    def load(self, options, settings, **kwargs):
        # Build up an optionparser for the given options
        parser = IgnoreInvalidArgs_OptionParser()
        for (name, option) in options.iteritems():
            parser.add_option("--%s" % name, action="store", dest=name,
                              default=None, help=option.help)

        # Parse the arguments
        parsed_options, _ = parser.parse_args(self.args)

        # Convert the results into a dictionary
        results = {}
        for name, _ in options.iteritems():
            if getattr(parsed_options, name) is not None:
                results[name] = getattr(parsed_options, name)

        return results

class IgnoreInvalidArgs_OptionParser(OptionParser):
    """
    This OptionParser subclass so that invalid arguments don't
    raise a ``SystemExit`` error.
    """

    def error(self, msg):
        pass
