/* valaccodeattribute.c generated by valac, the Vala compiler
 * generated from valaccodeattribute.vala, do not modify */

/* valaccodeattribute.vala
 *
 * Copyright (C) 2011  Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lucabru@src.gnome.org>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_attribute_cache_unref0(var) ((var == NULL) ? NULL : (var = (vala_attribute_cache_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaCCodeAttributePrivate {
	ValaCodeNode* node;
	ValaSymbol* sym;
	ValaAttribute* ccode;
	gchar* _array_length_type;
	gchar* _array_length_name;
	gchar* _array_length_expr;
	gboolean _delegate_target;
	gchar* _sentinel;
	gchar* _name;
	gchar* _const_name;
	gchar* _type_name;
	gchar* _feature_test_macros;
	gchar* _header_filenames;
	gchar* _prefix;
	gchar* _lower_case_prefix;
	gchar* _lower_case_suffix;
	gchar* _ref_function;
	gboolean ref_function_set;
	gboolean* _ref_function_void;
	gchar* _unref_function;
	gboolean unref_function_set;
	gchar* _ref_sink_function;
	gchar* _copy_function;
	gboolean copy_function_set;
	gchar* _destroy_function;
	gboolean destroy_function_set;
	gchar* _dup_function;
	gboolean dup_function_set;
	gchar* _free_function;
	gboolean free_function_set;
	gboolean* _free_function_address_of;
	gchar* _type_id;
	gchar* _marshaller_type_name;
	gchar* _get_value_function;
	gchar* _set_value_function;
	gchar* _take_value_function;
	gchar* _param_spec_function;
	gchar* _default_value;
	gchar* _default_value_on_error;
	gdouble* _pos;
	gchar* _vfunc_name;
	gchar* _finish_name;
	gchar* _finish_vfunc_name;
	gchar* _finish_real_name;
	gboolean* _finish_instance;
	gchar* _real_name;
	gchar* _delegate_target_name;
	gchar* _ctype;
	gboolean ctype_set;
	gboolean* _array_length;
	gboolean* _array_null_terminated;
};


static gpointer vala_ccode_attribute_parent_class = NULL;
static gint vala_ccode_attribute_dynamic_method_id;
static gint vala_ccode_attribute_dynamic_method_id = 0;

#define VALA_CCODE_ATTRIBUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ATTRIBUTE, ValaCCodeAttributePrivate))
static void vala_ccode_attribute_set_delegate_target (ValaCCodeAttribute* self,
                                               gboolean value);
static void vala_ccode_attribute_set_array_length_type (ValaCCodeAttribute* self,
                                                 const gchar* value);
static void vala_ccode_attribute_set_array_length_name (ValaCCodeAttribute* self,
                                                 const gchar* value);
static void vala_ccode_attribute_set_array_length_expr (ValaCCodeAttribute* self,
                                                 const gchar* value);
static gdouble* _double_dup (gdouble* self);
static void vala_ccode_attribute_set_sentinel (ValaCCodeAttribute* self,
                                        const gchar* value);
static gchar* vala_ccode_attribute_get_default_name (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_header_filenames (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_prefix (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_lower_case_prefix (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_lower_case_suffix (ValaCCodeAttribute* self);
G_GNUC_INTERNAL ValaCCodeAttribute* vala_get_ccode_attribute (ValaCodeNode* node);
static gchar* vala_ccode_attribute_get_default_ref_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_unref_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_ref_sink_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_free_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_type_id (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_marshaller_type_name (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_get_value_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_set_value_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_take_value_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_param_spec_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_default_value (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_finish_name_for_basename (ValaCCodeAttribute* self,
                                                          const gchar* basename);
static gchar* vala_ccode_attribute_get_default_real_name (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_const_name (ValaCCodeAttribute* self);
static gboolean vala_ccode_attribute_get_default_array_length (ValaCCodeAttribute* self);
static gboolean vala_ccode_attribute_get_default_array_null_terminated (ValaCCodeAttribute* self);
static gboolean* _bool_dup (gboolean* self);
static void vala_ccode_attribute_finalize (ValaAttributeCache * obj);


static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}


static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}


ValaCCodeAttribute*
vala_ccode_attribute_construct (GType object_type,
                                ValaCodeNode* node)
{
	ValaCCodeAttribute* self = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	const gchar* _tmp19_;
	g_return_val_if_fail (node != NULL, NULL);
	self = (ValaCCodeAttribute*) vala_attribute_cache_construct (object_type);
	self->priv->node = node;
	self->priv->sym = G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_SYMBOL) ? ((ValaSymbol*) node) : NULL;
	vala_ccode_attribute_set_delegate_target (self, TRUE);
	_tmp0_ = vala_code_node_get_attribute (node, "CCode");
	_vala_code_node_unref0 (self->priv->ccode);
	self->priv->ccode = _tmp0_;
	_tmp1_ = self->priv->ccode;
	if (_tmp1_ != NULL) {
		ValaAttribute* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValaAttribute* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		ValaAttribute* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		ValaAttribute* _tmp11_;
		ValaAttribute* _tmp15_;
		ValaAttribute* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp2_ = self->priv->ccode;
		_tmp3_ = vala_attribute_get_string (_tmp2_, "array_length_type", NULL);
		_tmp4_ = _tmp3_;
		vala_ccode_attribute_set_array_length_type (self, _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = self->priv->ccode;
		_tmp6_ = vala_attribute_get_string (_tmp5_, "array_length_cname", NULL);
		_tmp7_ = _tmp6_;
		vala_ccode_attribute_set_array_length_name (self, _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = self->priv->ccode;
		_tmp9_ = vala_attribute_get_string (_tmp8_, "array_length_cexpr", NULL);
		_tmp10_ = _tmp9_;
		vala_ccode_attribute_set_array_length_expr (self, _tmp10_);
		_g_free0 (_tmp10_);
		_tmp11_ = self->priv->ccode;
		if (vala_attribute_has_argument (_tmp11_, "pos")) {
			ValaAttribute* _tmp12_;
			gdouble _tmp13_;
			gdouble* _tmp14_;
			_tmp12_ = self->priv->ccode;
			_tmp13_ = vala_attribute_get_double (_tmp12_, "pos", (gdouble) 0);
			_tmp14_ = __double_dup0 (&_tmp13_);
			_g_free0 (self->priv->_pos);
			self->priv->_pos = _tmp14_;
		}
		_tmp15_ = self->priv->ccode;
		vala_ccode_attribute_set_delegate_target (self, vala_attribute_get_bool (_tmp15_, "delegate_target", TRUE));
		_tmp16_ = self->priv->ccode;
		_tmp17_ = vala_attribute_get_string (_tmp16_, "sentinel", NULL);
		_tmp18_ = _tmp17_;
		vala_ccode_attribute_set_sentinel (self, _tmp18_);
		_g_free0 (_tmp18_);
	}
	_tmp19_ = self->priv->_sentinel;
	if (_tmp19_ == NULL) {
		vala_ccode_attribute_set_sentinel (self, "NULL");
	}
	return self;
}


ValaCCodeAttribute*
vala_ccode_attribute_new (ValaCodeNode* node)
{
	return vala_ccode_attribute_construct (VALA_TYPE_CCODE_ATTRIBUTE, node);
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


static gchar*
vala_ccode_attribute_get_default_name (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* sym = NULL;
	ValaCodeNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->node;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_SYMBOL) ? ((ValaSymbol*) _tmp0_) : NULL);
	sym = _tmp1_;
	_tmp2_ = sym;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaSymbol* _tmp4_;
		_tmp4_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_CONSTANT)) {
			ValaSymbol* _tmp5_;
			_tmp5_ = sym;
			_tmp3_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_ENUM_VALUE);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			ValaSymbol* _tmp6_;
			ValaSymbol* _tmp7_;
			ValaSymbol* _tmp8_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			ValaSymbol* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp6_ = sym;
			_tmp7_ = vala_symbol_get_parent_symbol (_tmp6_);
			_tmp8_ = _tmp7_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_BLOCK)) {
				ValaSymbol* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp9_ = sym;
				_tmp10_ = vala_symbol_get_name (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strdup (_tmp11_);
				result = _tmp12_;
				_vala_code_node_unref0 (sym);
				return result;
			}
			_tmp13_ = sym;
			_tmp14_ = vala_symbol_get_parent_symbol (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_get_ccode_lower_case_prefix (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_ascii_strup (_tmp17_, (gssize) -1);
			_tmp19_ = _tmp18_;
			_tmp20_ = sym;
			_tmp21_ = vala_symbol_get_name (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strdup_printf ("%s%s", _tmp19_, _tmp22_);
			_tmp24_ = _tmp23_;
			_g_free0 (_tmp19_);
			_g_free0 (_tmp17_);
			result = _tmp24_;
			_vala_code_node_unref0 (sym);
			return result;
		} else {
			ValaSymbol* _tmp25_;
			_tmp25_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_FIELD)) {
				gchar* cname = NULL;
				ValaSymbol* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				ValaSymbol* _tmp30_;
				ValaMemberBinding _tmp31_;
				ValaMemberBinding _tmp32_;
				const gchar* _tmp42_;
				_tmp26_ = sym;
				_tmp27_ = vala_symbol_get_name (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strdup (_tmp28_);
				cname = _tmp29_;
				_tmp30_ = sym;
				_tmp31_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_FIELD, ValaField));
				_tmp32_ = _tmp31_;
				if (_tmp32_ == VALA_MEMBER_BINDING_STATIC) {
					ValaSymbol* _tmp33_;
					ValaSymbol* _tmp34_;
					ValaSymbol* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					ValaSymbol* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					gchar* _tmp41_;
					_tmp33_ = sym;
					_tmp34_ = vala_symbol_get_parent_symbol (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = vala_get_ccode_lower_case_prefix (_tmp35_);
					_tmp37_ = _tmp36_;
					_tmp38_ = sym;
					_tmp39_ = vala_symbol_get_name (_tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = g_strdup_printf ("%s%s", _tmp37_, _tmp40_);
					_g_free0 (cname);
					cname = _tmp41_;
					_g_free0 (_tmp37_);
				}
				_tmp42_ = cname;
				if (g_ascii_isdigit (string_get (_tmp42_, (glong) 0))) {
					ValaCodeNode* _tmp43_;
					ValaSourceReference* _tmp44_;
					ValaSourceReference* _tmp45_;
					gchar* _tmp46_;
					_tmp43_ = self->priv->node;
					_tmp44_ = vala_code_node_get_source_reference (_tmp43_);
					_tmp45_ = _tmp44_;
					vala_report_error (_tmp45_, "Field name starts with a digit. Use the `cname' attribute to provide a" \
" valid C name if intended");
					_tmp46_ = g_strdup ("");
					result = _tmp46_;
					_g_free0 (cname);
					_vala_code_node_unref0 (sym);
					return result;
				}
				result = cname;
				_vala_code_node_unref0 (sym);
				return result;
			} else {
				ValaSymbol* _tmp47_;
				_tmp47_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_CREATION_METHOD)) {
					ValaCreationMethod* m = NULL;
					ValaSymbol* _tmp48_;
					ValaCreationMethod* _tmp49_;
					gchar* infix = NULL;
					ValaCreationMethod* _tmp50_;
					ValaSymbol* _tmp51_;
					ValaSymbol* _tmp52_;
					ValaCreationMethod* _tmp55_;
					const gchar* _tmp56_;
					const gchar* _tmp57_;
					_tmp48_ = sym;
					_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					m = _tmp49_;
					_tmp50_ = m;
					_tmp51_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp50_);
					_tmp52_ = _tmp51_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, VALA_TYPE_STRUCT)) {
						gchar* _tmp53_;
						_tmp53_ = g_strdup ("init");
						_g_free0 (infix);
						infix = _tmp53_;
					} else {
						gchar* _tmp54_;
						_tmp54_ = g_strdup ("new");
						_g_free0 (infix);
						infix = _tmp54_;
					}
					_tmp55_ = m;
					_tmp56_ = vala_symbol_get_name ((ValaSymbol*) _tmp55_);
					_tmp57_ = _tmp56_;
					if (g_strcmp0 (_tmp57_, ".new") == 0) {
						ValaCreationMethod* _tmp58_;
						ValaSymbol* _tmp59_;
						ValaSymbol* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						const gchar* _tmp63_;
						gchar* _tmp64_;
						gchar* _tmp65_;
						_tmp58_ = m;
						_tmp59_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp58_);
						_tmp60_ = _tmp59_;
						_tmp61_ = vala_get_ccode_lower_case_prefix (_tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = infix;
						_tmp64_ = g_strdup_printf ("%s%s", _tmp62_, _tmp63_);
						_tmp65_ = _tmp64_;
						_g_free0 (_tmp62_);
						result = _tmp65_;
						_g_free0 (infix);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (sym);
						return result;
					} else {
						ValaCreationMethod* _tmp66_;
						ValaSymbol* _tmp67_;
						ValaSymbol* _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						const gchar* _tmp71_;
						ValaCreationMethod* _tmp72_;
						const gchar* _tmp73_;
						const gchar* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp76_;
						_tmp66_ = m;
						_tmp67_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp66_);
						_tmp68_ = _tmp67_;
						_tmp69_ = vala_get_ccode_lower_case_prefix (_tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = infix;
						_tmp72_ = m;
						_tmp73_ = vala_symbol_get_name ((ValaSymbol*) _tmp72_);
						_tmp74_ = _tmp73_;
						_tmp75_ = g_strdup_printf ("%s%s_%s", _tmp70_, _tmp71_, _tmp74_);
						_tmp76_ = _tmp75_;
						_g_free0 (_tmp70_);
						result = _tmp76_;
						_g_free0 (infix);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (sym);
						return result;
					}
					_g_free0 (infix);
					_vala_code_node_unref0 (m);
				} else {
					ValaSymbol* _tmp77_;
					_tmp77_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, VALA_TYPE_DYNAMIC_METHOD)) {
						ValaSymbol* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
						gint _tmp81_;
						gchar* _tmp82_;
						_tmp78_ = sym;
						_tmp79_ = vala_symbol_get_name (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp81_ = vala_ccode_attribute_dynamic_method_id;
						vala_ccode_attribute_dynamic_method_id = _tmp81_ + 1;
						_tmp82_ = g_strdup_printf ("_dynamic_%s%d", _tmp80_, _tmp81_);
						result = _tmp82_;
						_vala_code_node_unref0 (sym);
						return result;
					} else {
						ValaSymbol* _tmp83_;
						_tmp83_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp83_, VALA_TYPE_METHOD)) {
							ValaMethod* m = NULL;
							ValaSymbol* _tmp84_;
							ValaMethod* _tmp85_;
							ValaMethod* _tmp86_;
							gboolean _tmp87_;
							gboolean _tmp88_;
							ValaMethod* _tmp96_;
							ValaSignal* _tmp97_;
							ValaSignal* _tmp98_;
							gboolean _tmp111_ = FALSE;
							ValaSymbol* _tmp112_;
							const gchar* _tmp113_;
							const gchar* _tmp114_;
							_tmp84_ = sym;
							_tmp85_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, VALA_TYPE_METHOD, ValaMethod));
							m = _tmp85_;
							_tmp86_ = m;
							_tmp87_ = vala_method_get_is_async_callback (_tmp86_);
							_tmp88_ = _tmp87_;
							if (_tmp88_) {
								ValaMethod* _tmp89_;
								ValaSymbol* _tmp90_;
								ValaSymbol* _tmp91_;
								gchar* _tmp92_;
								gchar* _tmp93_;
								gchar* _tmp94_;
								gchar* _tmp95_;
								_tmp89_ = m;
								_tmp90_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp89_);
								_tmp91_ = _tmp90_;
								_tmp92_ = vala_get_ccode_real_name ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, VALA_TYPE_METHOD, ValaMethod));
								_tmp93_ = _tmp92_;
								_tmp94_ = g_strdup_printf ("%s_co", _tmp93_);
								_tmp95_ = _tmp94_;
								_g_free0 (_tmp93_);
								result = _tmp95_;
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (sym);
								return result;
							}
							_tmp96_ = m;
							_tmp97_ = vala_method_get_signal_reference (_tmp96_);
							_tmp98_ = _tmp97_;
							if (_tmp98_ != NULL) {
								ValaMethod* _tmp99_;
								ValaSymbol* _tmp100_;
								ValaSymbol* _tmp101_;
								gchar* _tmp102_;
								gchar* _tmp103_;
								ValaMethod* _tmp104_;
								ValaSignal* _tmp105_;
								ValaSignal* _tmp106_;
								gchar* _tmp107_;
								gchar* _tmp108_;
								gchar* _tmp109_;
								gchar* _tmp110_;
								_tmp99_ = m;
								_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp99_);
								_tmp101_ = _tmp100_;
								_tmp102_ = vala_get_ccode_lower_case_prefix (_tmp101_);
								_tmp103_ = _tmp102_;
								_tmp104_ = m;
								_tmp105_ = vala_method_get_signal_reference (_tmp104_);
								_tmp106_ = _tmp105_;
								_tmp107_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp106_, NULL);
								_tmp108_ = _tmp107_;
								_tmp109_ = g_strdup_printf ("%s%s", _tmp103_, _tmp108_);
								_tmp110_ = _tmp109_;
								_g_free0 (_tmp108_);
								_g_free0 (_tmp103_);
								result = _tmp110_;
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (sym);
								return result;
							}
							_tmp112_ = sym;
							_tmp113_ = vala_symbol_get_name (_tmp112_);
							_tmp114_ = _tmp113_;
							if (g_strcmp0 (_tmp114_, "main") == 0) {
								ValaSymbol* _tmp115_;
								ValaSymbol* _tmp116_;
								ValaSymbol* _tmp117_;
								const gchar* _tmp118_;
								const gchar* _tmp119_;
								_tmp115_ = sym;
								_tmp116_ = vala_symbol_get_parent_symbol (_tmp115_);
								_tmp117_ = _tmp116_;
								_tmp118_ = vala_symbol_get_name (_tmp117_);
								_tmp119_ = _tmp118_;
								_tmp111_ = _tmp119_ == NULL;
							} else {
								_tmp111_ = FALSE;
							}
							if (_tmp111_) {
								gchar* _tmp120_;
								_tmp120_ = g_strdup ("_vala_main");
								result = _tmp120_;
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (sym);
								return result;
							} else {
								ValaSymbol* _tmp121_;
								const gchar* _tmp122_;
								const gchar* _tmp123_;
								_tmp121_ = sym;
								_tmp122_ = vala_symbol_get_name (_tmp121_);
								_tmp123_ = _tmp122_;
								if (g_str_has_prefix (_tmp123_, "_")) {
									ValaSymbol* _tmp124_;
									ValaSymbol* _tmp125_;
									ValaSymbol* _tmp126_;
									gchar* _tmp127_;
									gchar* _tmp128_;
									ValaSymbol* _tmp129_;
									const gchar* _tmp130_;
									const gchar* _tmp131_;
									gchar* _tmp132_;
									gchar* _tmp133_;
									gchar* _tmp134_;
									gchar* _tmp135_;
									_tmp124_ = sym;
									_tmp125_ = vala_symbol_get_parent_symbol (_tmp124_);
									_tmp126_ = _tmp125_;
									_tmp127_ = vala_get_ccode_lower_case_prefix (_tmp126_);
									_tmp128_ = _tmp127_;
									_tmp129_ = sym;
									_tmp130_ = vala_symbol_get_name (_tmp129_);
									_tmp131_ = _tmp130_;
									_tmp132_ = string_substring (_tmp131_, (glong) 1, (glong) -1);
									_tmp133_ = _tmp132_;
									_tmp134_ = g_strdup_printf ("_%s%s", _tmp128_, _tmp133_);
									_tmp135_ = _tmp134_;
									_g_free0 (_tmp133_);
									_g_free0 (_tmp128_);
									result = _tmp135_;
									_vala_code_node_unref0 (m);
									_vala_code_node_unref0 (sym);
									return result;
								} else {
									ValaSymbol* _tmp136_;
									ValaSymbol* _tmp137_;
									ValaSymbol* _tmp138_;
									gchar* _tmp139_;
									gchar* _tmp140_;
									ValaSymbol* _tmp141_;
									const gchar* _tmp142_;
									const gchar* _tmp143_;
									gchar* _tmp144_;
									gchar* _tmp145_;
									_tmp136_ = sym;
									_tmp137_ = vala_symbol_get_parent_symbol (_tmp136_);
									_tmp138_ = _tmp137_;
									_tmp139_ = vala_get_ccode_lower_case_prefix (_tmp138_);
									_tmp140_ = _tmp139_;
									_tmp141_ = sym;
									_tmp142_ = vala_symbol_get_name (_tmp141_);
									_tmp143_ = _tmp142_;
									_tmp144_ = g_strdup_printf ("%s%s", _tmp140_, _tmp143_);
									_tmp145_ = _tmp144_;
									_g_free0 (_tmp140_);
									result = _tmp145_;
									_vala_code_node_unref0 (m);
									_vala_code_node_unref0 (sym);
									return result;
								}
							}
							_vala_code_node_unref0 (m);
						} else {
							ValaSymbol* _tmp146_;
							_tmp146_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp146_, VALA_TYPE_PROPERTY_ACCESSOR)) {
								ValaPropertyAccessor* acc = NULL;
								ValaSymbol* _tmp147_;
								ValaPropertyAccessor* _tmp148_;
								ValaTypeSymbol* t = NULL;
								ValaPropertyAccessor* _tmp149_;
								ValaProperty* _tmp150_;
								ValaProperty* _tmp151_;
								ValaSymbol* _tmp152_;
								ValaSymbol* _tmp153_;
								ValaTypeSymbol* _tmp154_;
								ValaPropertyAccessor* _tmp155_;
								gboolean _tmp156_;
								gboolean _tmp157_;
								_tmp147_ = sym;
								_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor));
								acc = _tmp148_;
								_tmp149_ = acc;
								_tmp150_ = vala_property_accessor_get_prop (_tmp149_);
								_tmp151_ = _tmp150_;
								_tmp152_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp151_);
								_tmp153_ = _tmp152_;
								_tmp154_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
								t = _tmp154_;
								_tmp155_ = acc;
								_tmp156_ = vala_property_accessor_get_readable (_tmp155_);
								_tmp157_ = _tmp156_;
								if (_tmp157_) {
									ValaTypeSymbol* _tmp158_;
									gchar* _tmp159_;
									gchar* _tmp160_;
									ValaPropertyAccessor* _tmp161_;
									ValaProperty* _tmp162_;
									ValaProperty* _tmp163_;
									const gchar* _tmp164_;
									const gchar* _tmp165_;
									gchar* _tmp166_;
									gchar* _tmp167_;
									_tmp158_ = t;
									_tmp159_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp158_);
									_tmp160_ = _tmp159_;
									_tmp161_ = acc;
									_tmp162_ = vala_property_accessor_get_prop (_tmp161_);
									_tmp163_ = _tmp162_;
									_tmp164_ = vala_symbol_get_name ((ValaSymbol*) _tmp163_);
									_tmp165_ = _tmp164_;
									_tmp166_ = g_strdup_printf ("%sget_%s", _tmp160_, _tmp165_);
									_tmp167_ = _tmp166_;
									_g_free0 (_tmp160_);
									result = _tmp167_;
									_vala_code_node_unref0 (t);
									_vala_code_node_unref0 (acc);
									_vala_code_node_unref0 (sym);
									return result;
								} else {
									ValaTypeSymbol* _tmp168_;
									gchar* _tmp169_;
									gchar* _tmp170_;
									ValaPropertyAccessor* _tmp171_;
									ValaProperty* _tmp172_;
									ValaProperty* _tmp173_;
									const gchar* _tmp174_;
									const gchar* _tmp175_;
									gchar* _tmp176_;
									gchar* _tmp177_;
									_tmp168_ = t;
									_tmp169_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp168_);
									_tmp170_ = _tmp169_;
									_tmp171_ = acc;
									_tmp172_ = vala_property_accessor_get_prop (_tmp171_);
									_tmp173_ = _tmp172_;
									_tmp174_ = vala_symbol_get_name ((ValaSymbol*) _tmp173_);
									_tmp175_ = _tmp174_;
									_tmp176_ = g_strdup_printf ("%sset_%s", _tmp170_, _tmp175_);
									_tmp177_ = _tmp176_;
									_g_free0 (_tmp170_);
									result = _tmp177_;
									_vala_code_node_unref0 (t);
									_vala_code_node_unref0 (acc);
									_vala_code_node_unref0 (sym);
									return result;
								}
								_vala_code_node_unref0 (t);
								_vala_code_node_unref0 (acc);
							} else {
								ValaSymbol* _tmp178_;
								_tmp178_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp178_, VALA_TYPE_SIGNAL)) {
									ValaSymbol* _tmp179_;
									const gchar* _tmp180_;
									const gchar* _tmp181_;
									gchar* _tmp182_;
									gchar* _tmp183_;
									gchar* _tmp184_;
									gchar* _tmp185_;
									_tmp179_ = sym;
									_tmp180_ = vala_symbol_get_name (_tmp179_);
									_tmp181_ = _tmp180_;
									_tmp182_ = vala_symbol_camel_case_to_lower_case (_tmp181_);
									_tmp183_ = _tmp182_;
									_tmp184_ = string_replace (_tmp183_, "_", "-");
									_tmp185_ = _tmp184_;
									_g_free0 (_tmp183_);
									result = _tmp185_;
									_vala_code_node_unref0 (sym);
									return result;
								} else {
									gboolean _tmp186_ = FALSE;
									ValaSymbol* _tmp187_;
									_tmp187_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp187_, VALA_TYPE_LOCAL_VARIABLE)) {
										_tmp186_ = TRUE;
									} else {
										ValaSymbol* _tmp188_;
										_tmp188_ = sym;
										_tmp186_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp188_, VALA_TYPE_PARAMETER);
									}
									if (_tmp186_) {
										ValaSymbol* _tmp189_;
										const gchar* _tmp190_;
										const gchar* _tmp191_;
										gchar* _tmp192_;
										_tmp189_ = sym;
										_tmp190_ = vala_symbol_get_name (_tmp189_);
										_tmp191_ = _tmp190_;
										_tmp192_ = g_strdup (_tmp191_);
										result = _tmp192_;
										_vala_code_node_unref0 (sym);
										return result;
									} else {
										ValaSymbol* _tmp193_;
										ValaSymbol* _tmp194_;
										ValaSymbol* _tmp195_;
										gchar* _tmp196_;
										gchar* _tmp197_;
										ValaSymbol* _tmp198_;
										const gchar* _tmp199_;
										const gchar* _tmp200_;
										gchar* _tmp201_;
										gchar* _tmp202_;
										_tmp193_ = sym;
										_tmp194_ = vala_symbol_get_parent_symbol (_tmp193_);
										_tmp195_ = _tmp194_;
										_tmp196_ = vala_get_ccode_prefix (_tmp195_);
										_tmp197_ = _tmp196_;
										_tmp198_ = sym;
										_tmp199_ = vala_symbol_get_name (_tmp198_);
										_tmp200_ = _tmp199_;
										_tmp201_ = g_strdup_printf ("%s%s", _tmp197_, _tmp200_);
										_tmp202_ = _tmp201_;
										_g_free0 (_tmp197_);
										result = _tmp202_;
										_vala_code_node_unref0 (sym);
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		ValaCodeNode* _tmp203_;
		_tmp203_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp203_, VALA_TYPE_OBJECT_TYPE)) {
			ValaObjectType* type = NULL;
			ValaCodeNode* _tmp204_;
			ValaObjectType* _tmp205_;
			gchar* cname = NULL;
			ValaObjectType* _tmp206_;
			gboolean _tmp207_;
			gboolean _tmp208_;
			const gchar* _tmp217_;
			gchar* _tmp218_;
			_tmp204_ = self->priv->node;
			_tmp205_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			type = _tmp205_;
			_tmp206_ = type;
			_tmp207_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp206_);
			_tmp208_ = _tmp207_;
			if (!_tmp208_) {
				ValaObjectType* _tmp209_;
				ValaObjectTypeSymbol* _tmp210_;
				ValaObjectTypeSymbol* _tmp211_;
				gchar* _tmp212_;
				_tmp209_ = type;
				_tmp210_ = vala_object_type_get_type_symbol (_tmp209_);
				_tmp211_ = _tmp210_;
				_tmp212_ = vala_get_ccode_const_name ((ValaCodeNode*) _tmp211_);
				_g_free0 (cname);
				cname = _tmp212_;
			} else {
				ValaObjectType* _tmp213_;
				ValaObjectTypeSymbol* _tmp214_;
				ValaObjectTypeSymbol* _tmp215_;
				gchar* _tmp216_;
				_tmp213_ = type;
				_tmp214_ = vala_object_type_get_type_symbol (_tmp213_);
				_tmp215_ = _tmp214_;
				_tmp216_ = vala_get_ccode_name ((ValaCodeNode*) _tmp215_);
				_g_free0 (cname);
				cname = _tmp216_;
			}
			_tmp217_ = cname;
			_tmp218_ = g_strdup_printf ("%s*", _tmp217_);
			result = _tmp218_;
			_g_free0 (cname);
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (sym);
			return result;
		} else {
			ValaCodeNode* _tmp219_;
			_tmp219_ = self->priv->node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp219_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* type = NULL;
				ValaCodeNode* _tmp220_;
				ValaArrayType* _tmp221_;
				gchar* cname = NULL;
				ValaArrayType* _tmp222_;
				ValaDataType* _tmp223_;
				ValaDataType* _tmp224_;
				gchar* _tmp225_;
				ValaArrayType* _tmp226_;
				gboolean _tmp227_;
				gboolean _tmp228_;
				_tmp220_ = self->priv->node;
				_tmp221_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp220_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				type = _tmp221_;
				_tmp222_ = type;
				_tmp223_ = vala_array_type_get_element_type (_tmp222_);
				_tmp224_ = _tmp223_;
				_tmp225_ = vala_get_ccode_name ((ValaCodeNode*) _tmp224_);
				cname = _tmp225_;
				_tmp226_ = type;
				_tmp227_ = vala_array_type_get_inline_allocated (_tmp226_);
				_tmp228_ = _tmp227_;
				if (_tmp228_) {
					result = cname;
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				} else {
					const gchar* _tmp229_;
					gchar* _tmp230_;
					_tmp229_ = cname;
					_tmp230_ = g_strdup_printf ("%s*", _tmp229_);
					result = _tmp230_;
					_g_free0 (cname);
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				}
				_g_free0 (cname);
				_vala_code_node_unref0 (type);
			} else {
				ValaCodeNode* _tmp231_;
				_tmp231_ = self->priv->node;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp231_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* type = NULL;
					ValaCodeNode* _tmp232_;
					ValaDelegateType* _tmp233_;
					ValaDelegateType* _tmp234_;
					ValaDelegate* _tmp235_;
					ValaDelegate* _tmp236_;
					gchar* _tmp237_;
					_tmp232_ = self->priv->node;
					_tmp233_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp232_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					type = _tmp233_;
					_tmp234_ = type;
					_tmp235_ = vala_delegate_type_get_delegate_symbol (_tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = vala_get_ccode_name ((ValaCodeNode*) _tmp236_);
					result = _tmp237_;
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				} else {
					ValaCodeNode* _tmp238_;
					_tmp238_ = self->priv->node;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp238_, VALA_TYPE_ERROR_TYPE)) {
						gchar* _tmp239_;
						_tmp239_ = g_strdup ("GError*");
						result = _tmp239_;
						_vala_code_node_unref0 (sym);
						return result;
					} else {
						ValaCodeNode* _tmp240_;
						_tmp240_ = self->priv->node;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp240_, VALA_TYPE_GENERIC_TYPE)) {
							ValaGenericType* type = NULL;
							ValaCodeNode* _tmp241_;
							ValaGenericType* _tmp242_;
							ValaGenericType* _tmp243_;
							gboolean _tmp244_;
							gboolean _tmp245_;
							_tmp241_ = self->priv->node;
							_tmp242_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp241_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
							type = _tmp242_;
							_tmp243_ = type;
							_tmp244_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp243_);
							_tmp245_ = _tmp244_;
							if (_tmp245_) {
								gchar* _tmp246_;
								_tmp246_ = g_strdup ("gpointer");
								result = _tmp246_;
								_vala_code_node_unref0 (type);
								_vala_code_node_unref0 (sym);
								return result;
							} else {
								gchar* _tmp247_;
								_tmp247_ = g_strdup ("gconstpointer");
								result = _tmp247_;
								_vala_code_node_unref0 (type);
								_vala_code_node_unref0 (sym);
								return result;
							}
							_vala_code_node_unref0 (type);
						} else {
							ValaCodeNode* _tmp248_;
							_tmp248_ = self->priv->node;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp248_, VALA_TYPE_METHOD_TYPE)) {
								gchar* _tmp249_;
								_tmp249_ = g_strdup ("gpointer");
								result = _tmp249_;
								_vala_code_node_unref0 (sym);
								return result;
							} else {
								ValaCodeNode* _tmp250_;
								_tmp250_ = self->priv->node;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp250_, VALA_TYPE_NULL_TYPE)) {
									gchar* _tmp251_;
									_tmp251_ = g_strdup ("gpointer");
									result = _tmp251_;
									_vala_code_node_unref0 (sym);
									return result;
								} else {
									ValaCodeNode* _tmp252_;
									_tmp252_ = self->priv->node;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp252_, VALA_TYPE_POINTER_TYPE)) {
										ValaPointerType* type = NULL;
										ValaCodeNode* _tmp253_;
										ValaPointerType* _tmp254_;
										gboolean _tmp255_ = FALSE;
										ValaPointerType* _tmp256_;
										ValaDataType* _tmp257_;
										ValaDataType* _tmp258_;
										ValaTypeSymbol* _tmp259_;
										ValaTypeSymbol* _tmp260_;
										_tmp253_ = self->priv->node;
										_tmp254_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp253_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
										type = _tmp254_;
										_tmp256_ = type;
										_tmp257_ = vala_pointer_type_get_base_type (_tmp256_);
										_tmp258_ = _tmp257_;
										_tmp259_ = vala_data_type_get_data_type (_tmp258_);
										_tmp260_ = _tmp259_;
										if (_tmp260_ != NULL) {
											ValaPointerType* _tmp261_;
											ValaDataType* _tmp262_;
											ValaDataType* _tmp263_;
											ValaTypeSymbol* _tmp264_;
											ValaTypeSymbol* _tmp265_;
											_tmp261_ = type;
											_tmp262_ = vala_pointer_type_get_base_type (_tmp261_);
											_tmp263_ = _tmp262_;
											_tmp264_ = vala_data_type_get_data_type (_tmp263_);
											_tmp265_ = _tmp264_;
											_tmp255_ = vala_typesymbol_is_reference_type (_tmp265_);
										} else {
											_tmp255_ = FALSE;
										}
										if (_tmp255_) {
											ValaPointerType* _tmp266_;
											ValaDataType* _tmp267_;
											ValaDataType* _tmp268_;
											gchar* _tmp269_;
											_tmp266_ = type;
											_tmp267_ = vala_pointer_type_get_base_type (_tmp266_);
											_tmp268_ = _tmp267_;
											_tmp269_ = vala_get_ccode_name ((ValaCodeNode*) _tmp268_);
											result = _tmp269_;
											_vala_code_node_unref0 (type);
											_vala_code_node_unref0 (sym);
											return result;
										} else {
											ValaPointerType* _tmp270_;
											ValaDataType* _tmp271_;
											ValaDataType* _tmp272_;
											gchar* _tmp273_;
											gchar* _tmp274_;
											gchar* _tmp275_;
											gchar* _tmp276_;
											_tmp270_ = type;
											_tmp271_ = vala_pointer_type_get_base_type (_tmp270_);
											_tmp272_ = _tmp271_;
											_tmp273_ = vala_get_ccode_name ((ValaCodeNode*) _tmp272_);
											_tmp274_ = _tmp273_;
											_tmp275_ = g_strdup_printf ("%s*", _tmp274_);
											_tmp276_ = _tmp275_;
											_g_free0 (_tmp274_);
											result = _tmp276_;
											_vala_code_node_unref0 (type);
											_vala_code_node_unref0 (sym);
											return result;
										}
										_vala_code_node_unref0 (type);
									} else {
										ValaCodeNode* _tmp277_;
										_tmp277_ = self->priv->node;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp277_, VALA_TYPE_VOID_TYPE)) {
											gchar* _tmp278_;
											_tmp278_ = g_strdup ("void");
											result = _tmp278_;
											_vala_code_node_unref0 (sym);
											return result;
										} else {
											ValaCodeNode* _tmp279_;
											_tmp279_ = self->priv->node;
											if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp279_, VALA_TYPE_CLASS_TYPE)) {
												ValaClassType* type = NULL;
												ValaCodeNode* _tmp280_;
												ValaClassType* _tmp281_;
												ValaClassType* _tmp282_;
												ValaClass* _tmp283_;
												ValaClass* _tmp284_;
												gchar* _tmp285_;
												gchar* _tmp286_;
												gchar* _tmp287_;
												gchar* _tmp288_;
												_tmp280_ = self->priv->node;
												_tmp281_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp280_, VALA_TYPE_CLASS_TYPE, ValaClassType));
												type = _tmp281_;
												_tmp282_ = type;
												_tmp283_ = vala_class_type_get_class_symbol (_tmp282_);
												_tmp284_ = _tmp283_;
												_tmp285_ = vala_get_ccode_name ((ValaCodeNode*) _tmp284_);
												_tmp286_ = _tmp285_;
												_tmp287_ = g_strdup_printf ("%sClass*", _tmp286_);
												_tmp288_ = _tmp287_;
												_g_free0 (_tmp286_);
												result = _tmp288_;
												_vala_code_node_unref0 (type);
												_vala_code_node_unref0 (sym);
												return result;
											} else {
												ValaCodeNode* _tmp289_;
												_tmp289_ = self->priv->node;
												if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp289_, VALA_TYPE_INTERFACE_TYPE)) {
													ValaInterfaceType* type = NULL;
													ValaCodeNode* _tmp290_;
													ValaInterfaceType* _tmp291_;
													ValaInterfaceType* _tmp292_;
													ValaInterface* _tmp293_;
													ValaInterface* _tmp294_;
													gchar* _tmp295_;
													gchar* _tmp296_;
													gchar* _tmp297_;
													gchar* _tmp298_;
													_tmp290_ = self->priv->node;
													_tmp291_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp290_, VALA_TYPE_INTERFACE_TYPE, ValaInterfaceType));
													type = _tmp291_;
													_tmp292_ = type;
													_tmp293_ = vala_interface_type_get_interface_symbol (_tmp292_);
													_tmp294_ = _tmp293_;
													_tmp295_ = vala_get_ccode_type_name (_tmp294_);
													_tmp296_ = _tmp295_;
													_tmp297_ = g_strdup_printf ("%s*", _tmp296_);
													_tmp298_ = _tmp297_;
													_g_free0 (_tmp296_);
													result = _tmp298_;
													_vala_code_node_unref0 (type);
													_vala_code_node_unref0 (sym);
													return result;
												} else {
													ValaCodeNode* _tmp299_;
													_tmp299_ = self->priv->node;
													if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp299_, VALA_TYPE_VALUE_TYPE)) {
														ValaValueType* type = NULL;
														ValaCodeNode* _tmp300_;
														ValaValueType* _tmp301_;
														gchar* cname = NULL;
														ValaValueType* _tmp302_;
														ValaTypeSymbol* _tmp303_;
														ValaTypeSymbol* _tmp304_;
														gchar* _tmp305_;
														ValaValueType* _tmp306_;
														gboolean _tmp307_;
														gboolean _tmp308_;
														_tmp300_ = self->priv->node;
														_tmp301_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp300_, VALA_TYPE_VALUE_TYPE, ValaValueType));
														type = _tmp301_;
														_tmp302_ = type;
														_tmp303_ = vala_value_type_get_type_symbol (_tmp302_);
														_tmp304_ = _tmp303_;
														_tmp305_ = vala_get_ccode_name ((ValaCodeNode*) _tmp304_);
														cname = _tmp305_;
														_tmp306_ = type;
														_tmp307_ = vala_data_type_get_nullable ((ValaDataType*) _tmp306_);
														_tmp308_ = _tmp307_;
														if (_tmp308_) {
															const gchar* _tmp309_;
															gchar* _tmp310_;
															_tmp309_ = cname;
															_tmp310_ = g_strdup_printf ("%s*", _tmp309_);
															result = _tmp310_;
															_g_free0 (cname);
															_vala_code_node_unref0 (type);
															_vala_code_node_unref0 (sym);
															return result;
														} else {
															result = cname;
															_vala_code_node_unref0 (type);
															_vala_code_node_unref0 (sym);
															return result;
														}
														_g_free0 (cname);
														_vala_code_node_unref0 (type);
													} else {
														ValaCodeNode* _tmp311_;
														_tmp311_ = self->priv->node;
														if (VALA_IS_CTYPE (_tmp311_)) {
															ValaCodeNode* _tmp312_;
															const gchar* _tmp313_;
															const gchar* _tmp314_;
															gchar* _tmp315_;
															_tmp312_ = self->priv->node;
															_tmp313_ = vala_ctype_get_ctype_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp312_, VALA_TYPE_CTYPE, ValaCType));
															_tmp314_ = _tmp313_;
															_tmp315_ = g_strdup (_tmp314_);
															result = _tmp315_;
															_vala_code_node_unref0 (sym);
															return result;
														} else {
															ValaCodeNode* _tmp316_;
															ValaSourceReference* _tmp317_;
															ValaSourceReference* _tmp318_;
															gchar* _tmp319_;
															_tmp316_ = self->priv->node;
															_tmp317_ = vala_code_node_get_source_reference (_tmp316_);
															_tmp318_ = _tmp317_;
															vala_report_error (_tmp318_, "Unresolved type reference");
															_tmp319_ = g_strdup ("");
															result = _tmp319_;
															_vala_code_node_unref0 (sym);
															return result;
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_vala_code_node_unref0 (sym);
}


static gchar*
vala_ccode_attribute_get_default_header_filenames (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp6_;
	gboolean _tmp14_ = FALSE;
	ValaSymbol* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	gchar* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_DYNAMIC_PROPERTY)) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp2_;
		_tmp2_ = self->priv->sym;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_DYNAMIC_METHOD);
	}
	if (_tmp0_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->sym;
	_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		gchar* parent_headers = NULL;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp7_ = self->priv->sym;
		_tmp8_ = vala_symbol_get_parent_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_get_ccode_header_filenames (_tmp9_);
		parent_headers = _tmp10_;
		_tmp11_ = parent_headers;
		_tmp12_ = strlen (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ > 0) {
			result = parent_headers;
			return result;
		}
		_g_free0 (parent_headers);
	}
	_tmp15_ = self->priv->sym;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaSymbol* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = self->priv->sym;
		_tmp19_ = vala_symbol_get_external_package (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp14_ = !_tmp20_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaSymbol* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaSourceReference* _tmp23_;
		ValaSourceFile* _tmp24_;
		ValaSourceFile* _tmp25_;
		gchar* _tmp26_;
		_tmp21_ = self->priv->sym;
		_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_source_reference_get_file (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_source_file_get_cinclude_filename (_tmp25_);
		result = _tmp26_;
		return result;
	}
	_tmp27_ = g_strdup ("");
	result = _tmp27_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_prefix (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp37_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = vala_ccode_attribute_get_name (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		ValaSymbol* _tmp5_;
		_tmp5_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_ENUM)) {
			_tmp4_ = TRUE;
		} else {
			ValaSymbol* _tmp6_;
			_tmp6_ = self->priv->sym;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_ERROR_DOMAIN);
		}
		if (_tmp4_) {
			ValaSymbol* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = self->priv->sym;
			_tmp8_ = vala_get_ccode_upper_case_name (_tmp7_, NULL);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup_printf ("%s_", _tmp9_);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp9_);
			result = _tmp11_;
			return result;
		} else {
			ValaSymbol* _tmp12_;
			_tmp12_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_NAMESPACE)) {
				ValaSymbol* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp13_ = self->priv->sym;
				_tmp14_ = vala_symbol_get_name (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ != NULL) {
					gchar* parent_prefix = NULL;
					gchar* _tmp16_;
					ValaSymbol* _tmp17_;
					ValaSymbol* _tmp18_;
					ValaSymbol* _tmp19_;
					const gchar* _tmp24_;
					ValaSymbol* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp16_ = g_strdup ("");
					parent_prefix = _tmp16_;
					_tmp17_ = self->priv->sym;
					_tmp18_ = vala_symbol_get_parent_symbol (_tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_ != NULL) {
						ValaSymbol* _tmp20_;
						ValaSymbol* _tmp21_;
						ValaSymbol* _tmp22_;
						gchar* _tmp23_;
						_tmp20_ = self->priv->sym;
						_tmp21_ = vala_symbol_get_parent_symbol (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = vala_get_ccode_prefix (_tmp22_);
						_g_free0 (parent_prefix);
						parent_prefix = _tmp23_;
					}
					_tmp24_ = parent_prefix;
					_tmp25_ = self->priv->sym;
					_tmp26_ = vala_symbol_get_name (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = g_strdup_printf ("%s%s", _tmp24_, _tmp27_);
					result = _tmp28_;
					_g_free0 (parent_prefix);
					return result;
				} else {
					gchar* _tmp29_;
					_tmp29_ = g_strdup ("");
					result = _tmp29_;
					return result;
				}
			} else {
				ValaSymbol* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp30_ = self->priv->sym;
				_tmp31_ = vala_symbol_get_name (_tmp30_);
				_tmp32_ = _tmp31_;
				if (_tmp32_ != NULL) {
					ValaSymbol* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp33_ = self->priv->sym;
					_tmp34_ = vala_symbol_get_name (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = g_strdup (_tmp35_);
					result = _tmp36_;
					return result;
				}
			}
		}
	}
	_tmp37_ = g_strdup ("");
	result = _tmp37_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_lower_case_prefix (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_NAMESPACE)) {
		ValaSymbol* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = vala_symbol_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ == NULL) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			result = _tmp4_;
			return result;
		} else {
			ValaSymbol* _tmp5_;
			ValaSymbol* _tmp6_;
			ValaSymbol* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			ValaSymbol* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp5_ = self->priv->sym;
			_tmp6_ = vala_symbol_get_parent_symbol (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_get_ccode_lower_case_prefix (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = self->priv->sym;
			_tmp11_ = vala_symbol_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_symbol_camel_case_to_lower_case (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strdup_printf ("%s%s_", _tmp9_, _tmp14_);
			_tmp16_ = _tmp15_;
			_g_free0 (_tmp14_);
			_g_free0 (_tmp9_);
			result = _tmp16_;
			return result;
		}
	} else {
		ValaSymbol* _tmp17_;
		_tmp17_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_METHOD)) {
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("");
			result = _tmp18_;
			return result;
		} else {
			ValaSymbol* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp19_ = self->priv->sym;
			_tmp20_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp19_, NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strdup_printf ("%s_", _tmp21_);
			_tmp23_ = _tmp22_;
			_g_free0 (_tmp21_);
			result = _tmp23_;
			return result;
		}
	}
}


static gchar*
vala_ccode_attribute_get_default_lower_case_suffix (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp44_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		gchar* csuffix = NULL;
		ValaSymbol* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp19_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = vala_symbol_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_symbol_camel_case_to_lower_case (_tmp3_);
		csuffix = _tmp4_;
		_tmp5_ = csuffix;
		if (g_str_has_prefix (_tmp5_, "type_")) {
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = csuffix;
			_tmp7_ = strlen ("type_");
			_tmp8_ = _tmp7_;
			_tmp9_ = string_substring (_tmp6_, (glong) _tmp8_, (glong) -1);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat ("type", _tmp10_, NULL);
			_g_free0 (csuffix);
			csuffix = _tmp11_;
			_g_free0 (_tmp10_);
		} else {
			const gchar* _tmp12_;
			_tmp12_ = csuffix;
			if (g_str_has_prefix (_tmp12_, "is_")) {
				const gchar* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp13_ = csuffix;
				_tmp14_ = strlen ("is_");
				_tmp15_ = _tmp14_;
				_tmp16_ = string_substring (_tmp13_, (glong) _tmp15_, (glong) -1);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat ("is", _tmp17_, NULL);
				_g_free0 (csuffix);
				csuffix = _tmp18_;
				_g_free0 (_tmp17_);
			}
		}
		_tmp19_ = csuffix;
		if (g_str_has_suffix (_tmp19_, "_class")) {
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp20_ = csuffix;
			_tmp21_ = csuffix;
			_tmp22_ = strlen (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = strlen ("_class");
			_tmp25_ = _tmp24_;
			_tmp26_ = string_substring (_tmp20_, (glong) 0, (glong) (_tmp23_ - _tmp25_));
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strconcat (_tmp27_, "class", NULL);
			_g_free0 (csuffix);
			csuffix = _tmp28_;
			_g_free0 (_tmp27_);
		}
		result = csuffix;
		return result;
	} else {
		ValaSymbol* _tmp29_;
		_tmp29_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_SIGNAL)) {
			ValaSymbol* _tmp30_;
			ValaCCodeAttribute* _tmp31_;
			ValaCCodeAttribute* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp30_ = self->priv->sym;
			_tmp31_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_attribute_get_name (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = string_replace (_tmp34_, "-", "_");
			_tmp36_ = _tmp35_;
			_vala_attribute_cache_unref0 (_tmp32_);
			result = _tmp36_;
			return result;
		} else {
			ValaSymbol* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			_tmp37_ = self->priv->sym;
			_tmp38_ = vala_symbol_get_name (_tmp37_);
			_tmp39_ = _tmp38_;
			if (_tmp39_ != NULL) {
				ValaSymbol* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				_tmp40_ = self->priv->sym;
				_tmp41_ = vala_symbol_get_name (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = vala_symbol_camel_case_to_lower_case (_tmp42_);
				result = _tmp43_;
				return result;
			}
		}
	}
	_tmp44_ = g_strdup ("");
	result = _tmp44_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_ref_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		ValaClass* _tmp3_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp2_;
		_tmp3_ = cl;
		if (vala_class_is_fundamental (_tmp3_)) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = vala_ccode_attribute_get_lower_case_prefix (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup_printf ("%sref", _tmp5_);
			result = _tmp6_;
			_vala_code_node_unref0 (cl);
			return result;
		} else {
			ValaClass* _tmp7_;
			ValaClass* _tmp8_;
			ValaClass* _tmp9_;
			_tmp7_ = cl;
			_tmp8_ = vala_class_get_base_class (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				ValaClass* _tmp10_;
				ValaClass* _tmp11_;
				ValaClass* _tmp12_;
				gchar* _tmp13_;
				_tmp10_ = cl;
				_tmp11_ = vala_class_get_base_class (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = vala_get_ccode_ref_function ((ValaTypeSymbol*) _tmp12_);
				result = _tmp13_;
				_vala_code_node_unref0 (cl);
				return result;
			}
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaSymbol* _tmp14_;
		_tmp14_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_INTERFACE)) {
			{
				ValaList* _prereq_list = NULL;
				ValaSymbol* _tmp15_;
				ValaList* _tmp16_;
				gint _prereq_size = 0;
				ValaList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _prereq_index = 0;
				_tmp15_ = self->priv->sym;
				_tmp16_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_INTERFACE, ValaInterface));
				_prereq_list = _tmp16_;
				_tmp17_ = _prereq_list;
				_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
				_tmp19_ = _tmp18_;
				_prereq_size = _tmp19_;
				_prereq_index = -1;
				while (TRUE) {
					gint _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					ValaDataType* prereq = NULL;
					ValaList* _tmp23_;
					gint _tmp24_;
					gpointer _tmp25_;
					gchar* ref_func = NULL;
					ValaDataType* _tmp26_;
					ValaTypeSymbol* _tmp27_;
					ValaTypeSymbol* _tmp28_;
					gchar* _tmp29_;
					const gchar* _tmp30_;
					_tmp20_ = _prereq_index;
					_prereq_index = _tmp20_ + 1;
					_tmp21_ = _prereq_index;
					_tmp22_ = _prereq_size;
					if (!(_tmp21_ < _tmp22_)) {
						break;
					}
					_tmp23_ = _prereq_list;
					_tmp24_ = _prereq_index;
					_tmp25_ = vala_list_get (_tmp23_, _tmp24_);
					prereq = (ValaDataType*) _tmp25_;
					_tmp26_ = prereq;
					_tmp27_ = vala_data_type_get_data_type (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = vala_get_ccode_ref_function ((ValaTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
					ref_func = _tmp29_;
					_tmp30_ = ref_func;
					if (_tmp30_ != NULL) {
						result = ref_func;
						_vala_code_node_unref0 (prereq);
						_vala_iterable_unref0 (_prereq_list);
						return result;
					}
					_g_free0 (ref_func);
					_vala_code_node_unref0 (prereq);
				}
				_vala_iterable_unref0 (_prereq_list);
			}
		}
	}
	result = NULL;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_unref_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		ValaClass* _tmp3_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp2_;
		_tmp3_ = cl;
		if (vala_class_is_fundamental (_tmp3_)) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = vala_ccode_attribute_get_lower_case_prefix (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup_printf ("%sunref", _tmp5_);
			result = _tmp6_;
			_vala_code_node_unref0 (cl);
			return result;
		} else {
			ValaClass* _tmp7_;
			ValaClass* _tmp8_;
			ValaClass* _tmp9_;
			_tmp7_ = cl;
			_tmp8_ = vala_class_get_base_class (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				ValaClass* _tmp10_;
				ValaClass* _tmp11_;
				ValaClass* _tmp12_;
				gchar* _tmp13_;
				_tmp10_ = cl;
				_tmp11_ = vala_class_get_base_class (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = vala_get_ccode_unref_function ((ValaObjectTypeSymbol*) _tmp12_);
				result = _tmp13_;
				_vala_code_node_unref0 (cl);
				return result;
			}
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaSymbol* _tmp14_;
		_tmp14_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_INTERFACE)) {
			{
				ValaList* _prereq_list = NULL;
				ValaSymbol* _tmp15_;
				ValaList* _tmp16_;
				gint _prereq_size = 0;
				ValaList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _prereq_index = 0;
				_tmp15_ = self->priv->sym;
				_tmp16_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_INTERFACE, ValaInterface));
				_prereq_list = _tmp16_;
				_tmp17_ = _prereq_list;
				_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
				_tmp19_ = _tmp18_;
				_prereq_size = _tmp19_;
				_prereq_index = -1;
				while (TRUE) {
					gint _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					ValaDataType* prereq = NULL;
					ValaList* _tmp23_;
					gint _tmp24_;
					gpointer _tmp25_;
					gchar* unref_func = NULL;
					ValaDataType* _tmp26_;
					ValaTypeSymbol* _tmp27_;
					ValaTypeSymbol* _tmp28_;
					gchar* _tmp29_;
					const gchar* _tmp30_;
					_tmp20_ = _prereq_index;
					_prereq_index = _tmp20_ + 1;
					_tmp21_ = _prereq_index;
					_tmp22_ = _prereq_size;
					if (!(_tmp21_ < _tmp22_)) {
						break;
					}
					_tmp23_ = _prereq_list;
					_tmp24_ = _prereq_index;
					_tmp25_ = vala_list_get (_tmp23_, _tmp24_);
					prereq = (ValaDataType*) _tmp25_;
					_tmp26_ = prereq;
					_tmp27_ = vala_data_type_get_data_type (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = vala_get_ccode_unref_function (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
					unref_func = _tmp29_;
					_tmp30_ = unref_func;
					if (_tmp30_ != NULL) {
						result = unref_func;
						_vala_code_node_unref0 (prereq);
						_vala_iterable_unref0 (_prereq_list);
						return result;
					}
					_g_free0 (unref_func);
					_vala_code_node_unref0 (prereq);
				}
				_vala_iterable_unref0 (_prereq_list);
			}
		}
	}
	result = NULL;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_ref_sink_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* base_class = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		ValaClass* _tmp3_;
		ValaClass* _tmp4_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = vala_class_get_base_class (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass));
		_tmp3_ = _tmp2_;
		base_class = _tmp3_;
		_tmp4_ = base_class;
		if (_tmp4_ != NULL) {
			ValaClass* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = base_class;
			_tmp6_ = vala_get_ccode_ref_sink_function ((ValaObjectTypeSymbol*) _tmp5_);
			result = _tmp6_;
			return result;
		}
	} else {
		ValaSymbol* _tmp7_;
		_tmp7_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_INTERFACE)) {
			{
				ValaList* _prereq_list = NULL;
				ValaSymbol* _tmp8_;
				ValaList* _tmp9_;
				gint _prereq_size = 0;
				ValaList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _prereq_index = 0;
				_tmp8_ = self->priv->sym;
				_tmp9_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_INTERFACE, ValaInterface));
				_prereq_list = _tmp9_;
				_tmp10_ = _prereq_list;
				_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_prereq_size = _tmp12_;
				_prereq_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					ValaDataType* prereq = NULL;
					ValaList* _tmp16_;
					gint _tmp17_;
					gpointer _tmp18_;
					gchar* ref_sink_func = NULL;
					ValaDataType* _tmp19_;
					ValaTypeSymbol* _tmp20_;
					ValaTypeSymbol* _tmp21_;
					gchar* _tmp22_;
					const gchar* _tmp23_;
					_tmp13_ = _prereq_index;
					_prereq_index = _tmp13_ + 1;
					_tmp14_ = _prereq_index;
					_tmp15_ = _prereq_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _prereq_list;
					_tmp17_ = _prereq_index;
					_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
					prereq = (ValaDataType*) _tmp18_;
					_tmp19_ = prereq;
					_tmp20_ = vala_data_type_get_data_type (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = vala_get_ccode_ref_sink_function (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
					ref_sink_func = _tmp22_;
					_tmp23_ = ref_sink_func;
					if (g_strcmp0 (_tmp23_, "") != 0) {
						result = ref_sink_func;
						_vala_code_node_unref0 (prereq);
						_vala_iterable_unref0 (_prereq_list);
						return result;
					}
					_g_free0 (ref_sink_func);
					_vala_code_node_unref0 (prereq);
				}
				_vala_iterable_unref0 (_prereq_list);
			}
		}
	}
	_tmp24_ = g_strdup ("");
	result = _tmp24_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_free_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		ValaClass* _tmp3_;
		ValaClass* _tmp4_;
		ValaClass* _tmp5_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp2_;
		_tmp3_ = cl;
		_tmp4_ = vala_class_get_base_class (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			ValaClass* _tmp6_;
			ValaClass* _tmp7_;
			ValaClass* _tmp8_;
			gchar* _tmp9_;
			_tmp6_ = cl;
			_tmp7_ = vala_class_get_base_class (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_get_ccode_free_function ((ValaTypeSymbol*) _tmp8_);
			result = _tmp9_;
			_vala_code_node_unref0 (cl);
			return result;
		}
		_tmp10_ = vala_ccode_attribute_get_lower_case_prefix (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("%sfree", _tmp11_);
		result = _tmp12_;
		_vala_code_node_unref0 (cl);
		return result;
	} else {
		ValaSymbol* _tmp13_;
		_tmp13_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_STRUCT)) {
			ValaSymbol* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp14_ = self->priv->sym;
			_tmp15_ = vala_symbol_get_external_package (_tmp14_);
			_tmp16_ = _tmp15_;
			if (!_tmp16_) {
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp17_ = vala_ccode_attribute_get_lower_case_prefix (self);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strdup_printf ("%sfree", _tmp18_);
				result = _tmp19_;
				return result;
			}
		}
	}
	result = NULL;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_type_id (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp66_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		ValaSymbol* _tmp3_;
		_tmp3_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_CLASS)) {
			ValaSymbol* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp4_ = self->priv->sym;
			_tmp5_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = _tmp5_;
			_tmp2_ = !_tmp6_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			ValaSymbol* _tmp7_;
			_tmp7_ = self->priv->sym;
			_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_INTERFACE);
		}
		if (_tmp1_) {
			ValaSymbol* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = self->priv->sym;
			_tmp9_ = vala_get_ccode_upper_case_name (_tmp8_, "TYPE_");
			result = _tmp9_;
			return result;
		} else {
			ValaSymbol* _tmp10_;
			_tmp10_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_ERROR_TYPE)) {
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("G_TYPE_ERROR");
				result = _tmp11_;
				return result;
			} else {
				ValaSymbol* _tmp12_;
				_tmp12_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_STRUCT)) {
					ValaStruct* st = NULL;
					ValaSymbol* _tmp13_;
					ValaStruct* _tmp14_;
					ValaStruct* _tmp15_;
					_tmp13_ = self->priv->sym;
					_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp14_;
					_tmp15_ = st;
					if (!vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp15_)) {
						ValaStruct* base_struct = NULL;
						ValaStruct* _tmp16_;
						ValaStruct* _tmp17_;
						ValaStruct* _tmp18_;
						ValaStruct* _tmp19_;
						ValaStruct* _tmp20_;
						ValaStruct* _tmp23_;
						_tmp16_ = st;
						_tmp17_ = vala_struct_get_base_struct (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp19_ = _vala_code_node_ref0 (_tmp18_);
						base_struct = _tmp19_;
						_tmp20_ = base_struct;
						if (_tmp20_ != NULL) {
							ValaStruct* _tmp21_;
							gchar* _tmp22_;
							_tmp21_ = base_struct;
							_tmp22_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp21_);
							result = _tmp22_;
							_vala_code_node_unref0 (base_struct);
							_vala_code_node_unref0 (st);
							return result;
						}
						_tmp23_ = st;
						if (!vala_struct_is_simple_type (_tmp23_)) {
							gchar* _tmp24_;
							_tmp24_ = g_strdup ("G_TYPE_POINTER");
							result = _tmp24_;
							_vala_code_node_unref0 (base_struct);
							_vala_code_node_unref0 (st);
							return result;
						}
						_vala_code_node_unref0 (base_struct);
					} else {
						ValaStruct* _tmp25_;
						gchar* _tmp26_;
						_tmp25_ = st;
						_tmp26_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp25_, "TYPE_");
						result = _tmp26_;
						_vala_code_node_unref0 (st);
						return result;
					}
					_vala_code_node_unref0 (st);
				} else {
					ValaSymbol* _tmp27_;
					_tmp27_ = self->priv->sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_ENUM)) {
						ValaEnum* en = NULL;
						ValaSymbol* _tmp28_;
						ValaEnum* _tmp29_;
						ValaEnum* _tmp30_;
						_tmp28_ = self->priv->sym;
						_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_ENUM, ValaEnum));
						en = _tmp29_;
						_tmp30_ = en;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp30_)) {
							ValaEnum* _tmp31_;
							gchar* _tmp32_;
							_tmp31_ = en;
							_tmp32_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp31_, "TYPE_");
							result = _tmp32_;
							_vala_code_node_unref0 (en);
							return result;
						} else {
							const gchar* _tmp33_ = NULL;
							ValaEnum* _tmp34_;
							gboolean _tmp35_;
							gboolean _tmp36_;
							gchar* _tmp37_;
							_tmp34_ = en;
							_tmp35_ = vala_enum_get_is_flags (_tmp34_);
							_tmp36_ = _tmp35_;
							if (_tmp36_) {
								_tmp33_ = "G_TYPE_UINT";
							} else {
								_tmp33_ = "G_TYPE_INT";
							}
							_tmp37_ = g_strdup (_tmp33_);
							result = _tmp37_;
							_vala_code_node_unref0 (en);
							return result;
						}
						_vala_code_node_unref0 (en);
					} else {
						gchar* _tmp38_;
						_tmp38_ = g_strdup ("G_TYPE_POINTER");
						result = _tmp38_;
						return result;
					}
				}
			}
		}
	} else {
		gboolean _tmp39_ = FALSE;
		ValaCodeNode* _tmp40_;
		_tmp40_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, VALA_TYPE_ARRAY_TYPE)) {
			ValaCodeNode* _tmp41_;
			ValaDataType* _tmp42_;
			ValaDataType* _tmp43_;
			ValaTypeSymbol* _tmp44_;
			ValaTypeSymbol* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp41_ = self->priv->node;
			_tmp42_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_data_type_get_data_type (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp39_ = g_strcmp0 (_tmp47_, "string") == 0;
			_g_free0 (_tmp47_);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			gchar* _tmp48_;
			_tmp48_ = g_strdup ("G_TYPE_STRV");
			result = _tmp48_;
			return result;
		} else {
			gboolean _tmp49_ = FALSE;
			ValaCodeNode* _tmp50_;
			_tmp50_ = self->priv->node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, VALA_TYPE_POINTER_TYPE)) {
				_tmp49_ = TRUE;
			} else {
				ValaCodeNode* _tmp51_;
				_tmp51_ = self->priv->node;
				_tmp49_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_DELEGATE_TYPE);
			}
			if (_tmp49_) {
				gchar* _tmp52_;
				_tmp52_ = g_strdup ("G_TYPE_POINTER");
				result = _tmp52_;
				return result;
			} else {
				ValaCodeNode* _tmp53_;
				_tmp53_ = self->priv->node;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALA_TYPE_ERROR_TYPE)) {
					gchar* _tmp54_;
					_tmp54_ = g_strdup ("G_TYPE_ERROR");
					result = _tmp54_;
					return result;
				} else {
					ValaCodeNode* _tmp55_;
					_tmp55_ = self->priv->node;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_VOID_TYPE)) {
						gchar* _tmp56_;
						_tmp56_ = g_strdup ("G_TYPE_NONE");
						result = _tmp56_;
						return result;
					} else {
						ValaDataType* type = NULL;
						ValaCodeNode* _tmp57_;
						ValaDataType* _tmp58_;
						ValaDataType* _tmp59_;
						ValaTypeSymbol* _tmp60_;
						ValaTypeSymbol* _tmp61_;
						_tmp57_ = self->priv->node;
						_tmp58_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_DATA_TYPE, ValaDataType));
						type = _tmp58_;
						_tmp59_ = type;
						_tmp60_ = vala_data_type_get_data_type (_tmp59_);
						_tmp61_ = _tmp60_;
						if (_tmp61_ != NULL) {
							ValaDataType* _tmp62_;
							ValaTypeSymbol* _tmp63_;
							ValaTypeSymbol* _tmp64_;
							gchar* _tmp65_;
							_tmp62_ = type;
							_tmp63_ = vala_data_type_get_data_type (_tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp64_);
							result = _tmp65_;
							_vala_code_node_unref0 (type);
							return result;
						}
						_vala_code_node_unref0 (type);
					}
				}
			}
		}
	}
	_tmp66_ = g_strdup ("");
	result = _tmp66_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_marshaller_type_name (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp128_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (_tmp0_ != NULL) {
		ValaSymbol* _tmp1_;
		_tmp1_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp2_;
			ValaClass* _tmp3_;
			ValaClass* _tmp4_;
			ValaClass* _tmp5_;
			ValaClass* _tmp6_;
			_tmp2_ = self->priv->sym;
			_tmp3_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp3_;
			_tmp4_ = cl;
			_tmp5_ = vala_class_get_base_class (_tmp4_);
			_tmp6_ = _tmp5_;
			if (_tmp6_ != NULL) {
				ValaClass* _tmp7_;
				ValaClass* _tmp8_;
				ValaClass* _tmp9_;
				gchar* _tmp10_;
				_tmp7_ = cl;
				_tmp8_ = vala_class_get_base_class (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp9_);
				result = _tmp10_;
				_vala_code_node_unref0 (cl);
				return result;
			} else {
				ValaClass* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = cl;
				_tmp12_ = vala_class_get_is_compact (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					ValaClass* _tmp14_;
					gchar* _tmp15_;
					_tmp14_ = cl;
					_tmp15_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp14_, NULL);
					result = _tmp15_;
					_vala_code_node_unref0 (cl);
					return result;
				} else {
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					_tmp16_ = vala_ccode_attribute_get_type_id (self);
					_tmp17_ = _tmp16_;
					if (g_strcmp0 (_tmp17_, "G_TYPE_POINTER") == 0) {
						gchar* _tmp18_;
						_tmp18_ = g_strdup ("POINTER");
						result = _tmp18_;
						_vala_code_node_unref0 (cl);
						return result;
					} else {
						gchar* _tmp19_;
						_tmp19_ = g_strdup ("BOXED");
						result = _tmp19_;
						_vala_code_node_unref0 (cl);
						return result;
					}
				}
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp20_;
			_tmp20_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_ENUM)) {
				ValaEnum* en = NULL;
				ValaSymbol* _tmp21_;
				ValaEnum* _tmp22_;
				ValaEnum* _tmp23_;
				_tmp21_ = self->priv->sym;
				_tmp22_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_ENUM, ValaEnum));
				en = _tmp22_;
				_tmp23_ = en;
				if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp23_)) {
					ValaEnum* _tmp24_;
					gboolean _tmp25_;
					gboolean _tmp26_;
					_tmp24_ = en;
					_tmp25_ = vala_enum_get_is_flags (_tmp24_);
					_tmp26_ = _tmp25_;
					if (_tmp26_) {
						gchar* _tmp27_;
						_tmp27_ = g_strdup ("FLAGS");
						result = _tmp27_;
						_vala_code_node_unref0 (en);
						return result;
					} else {
						gchar* _tmp28_;
						_tmp28_ = g_strdup ("ENUM");
						result = _tmp28_;
						_vala_code_node_unref0 (en);
						return result;
					}
				} else {
					ValaEnum* _tmp29_;
					gboolean _tmp30_;
					gboolean _tmp31_;
					_tmp29_ = en;
					_tmp30_ = vala_enum_get_is_flags (_tmp29_);
					_tmp31_ = _tmp30_;
					if (_tmp31_) {
						gchar* _tmp32_;
						_tmp32_ = g_strdup ("UINT");
						result = _tmp32_;
						_vala_code_node_unref0 (en);
						return result;
					} else {
						gchar* _tmp33_;
						_tmp33_ = g_strdup ("INT");
						result = _tmp33_;
						_vala_code_node_unref0 (en);
						return result;
					}
				}
				_vala_code_node_unref0 (en);
			} else {
				ValaSymbol* _tmp34_;
				_tmp34_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALA_TYPE_INTERFACE)) {
					gchar* _tmp51_;
					{
						ValaList* _prereq_list = NULL;
						ValaSymbol* _tmp35_;
						ValaList* _tmp36_;
						gint _prereq_size = 0;
						ValaList* _tmp37_;
						gint _tmp38_;
						gint _tmp39_;
						gint _prereq_index = 0;
						_tmp35_ = self->priv->sym;
						_tmp36_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_INTERFACE, ValaInterface));
						_prereq_list = _tmp36_;
						_tmp37_ = _prereq_list;
						_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
						_tmp39_ = _tmp38_;
						_prereq_size = _tmp39_;
						_prereq_index = -1;
						while (TRUE) {
							gint _tmp40_;
							gint _tmp41_;
							gint _tmp42_;
							ValaDataType* prereq = NULL;
							ValaList* _tmp43_;
							gint _tmp44_;
							gpointer _tmp45_;
							gchar* type_name = NULL;
							ValaDataType* _tmp46_;
							ValaTypeSymbol* _tmp47_;
							ValaTypeSymbol* _tmp48_;
							gchar* _tmp49_;
							const gchar* _tmp50_;
							_tmp40_ = _prereq_index;
							_prereq_index = _tmp40_ + 1;
							_tmp41_ = _prereq_index;
							_tmp42_ = _prereq_size;
							if (!(_tmp41_ < _tmp42_)) {
								break;
							}
							_tmp43_ = _prereq_list;
							_tmp44_ = _prereq_index;
							_tmp45_ = vala_list_get (_tmp43_, _tmp44_);
							prereq = (ValaDataType*) _tmp45_;
							_tmp46_ = prereq;
							_tmp47_ = vala_data_type_get_data_type (_tmp46_);
							_tmp48_ = _tmp47_;
							_tmp49_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp48_);
							type_name = _tmp49_;
							_tmp50_ = type_name;
							if (g_strcmp0 (_tmp50_, "") != 0) {
								result = type_name;
								_vala_code_node_unref0 (prereq);
								_vala_iterable_unref0 (_prereq_list);
								return result;
							}
							_g_free0 (type_name);
							_vala_code_node_unref0 (prereq);
						}
						_vala_iterable_unref0 (_prereq_list);
					}
					_tmp51_ = g_strdup ("POINTER");
					result = _tmp51_;
					return result;
				} else {
					ValaSymbol* _tmp52_;
					_tmp52_ = self->priv->sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, VALA_TYPE_STRUCT)) {
						ValaStruct* st = NULL;
						ValaSymbol* _tmp53_;
						ValaStruct* _tmp54_;
						ValaStruct* base_st = NULL;
						ValaStruct* _tmp55_;
						ValaStruct* _tmp56_;
						ValaStruct* _tmp57_;
						ValaStruct* _tmp58_;
						ValaStruct* _tmp67_;
						_tmp53_ = self->priv->sym;
						_tmp54_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_STRUCT, ValaStruct));
						st = _tmp54_;
						_tmp55_ = st;
						_tmp56_ = vala_struct_get_base_struct (_tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = _vala_code_node_ref0 (_tmp57_);
						base_st = _tmp58_;
						while (TRUE) {
							ValaStruct* _tmp59_;
							ValaStruct* _tmp60_;
							_tmp59_ = base_st;
							if (!(_tmp59_ != NULL)) {
								break;
							}
							_tmp60_ = base_st;
							if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp60_)) {
								ValaStruct* _tmp61_;
								gchar* _tmp62_;
								_tmp61_ = base_st;
								_tmp62_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp61_);
								result = _tmp62_;
								_vala_code_node_unref0 (base_st);
								_vala_code_node_unref0 (st);
								return result;
							} else {
								ValaStruct* _tmp63_;
								ValaStruct* _tmp64_;
								ValaStruct* _tmp65_;
								ValaStruct* _tmp66_;
								_tmp63_ = base_st;
								_tmp64_ = vala_struct_get_base_struct (_tmp63_);
								_tmp65_ = _tmp64_;
								_tmp66_ = _vala_code_node_ref0 (_tmp65_);
								_vala_code_node_unref0 (base_st);
								base_st = _tmp66_;
							}
						}
						_tmp67_ = st;
						if (vala_struct_is_simple_type (_tmp67_)) {
							ValaStruct* _tmp68_;
							ValaSourceReference* _tmp69_;
							ValaSourceReference* _tmp70_;
							ValaStruct* _tmp71_;
							gchar* _tmp72_;
							gchar* _tmp73_;
							gchar* _tmp74_;
							gchar* _tmp75_;
							_tmp68_ = st;
							_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp68_);
							_tmp70_ = _tmp69_;
							_tmp71_ = st;
							_tmp72_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp71_);
							_tmp73_ = _tmp72_;
							_tmp74_ = g_strdup_printf ("The type `%s` doesn't declare a marshaller type name", _tmp73_);
							_tmp75_ = _tmp74_;
							vala_report_error (_tmp70_, _tmp75_);
							_g_free0 (_tmp75_);
							_g_free0 (_tmp73_);
						} else {
							ValaStruct* _tmp76_;
							_tmp76_ = st;
							if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp76_)) {
								gchar* _tmp77_;
								_tmp77_ = g_strdup ("BOXED");
								result = _tmp77_;
								_vala_code_node_unref0 (base_st);
								_vala_code_node_unref0 (st);
								return result;
							} else {
								gchar* _tmp78_;
								_tmp78_ = g_strdup ("POINTER");
								result = _tmp78_;
								_vala_code_node_unref0 (base_st);
								_vala_code_node_unref0 (st);
								return result;
							}
						}
						_vala_code_node_unref0 (base_st);
						_vala_code_node_unref0 (st);
					} else {
						ValaSymbol* _tmp79_;
						_tmp79_ = self->priv->sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp79_, VALA_TYPE_PARAMETER)) {
							ValaParameter* param = NULL;
							ValaSymbol* _tmp80_;
							ValaParameter* _tmp81_;
							ValaParameter* _tmp82_;
							ValaParameterDirection _tmp83_;
							ValaParameterDirection _tmp84_;
							_tmp80_ = self->priv->sym;
							_tmp81_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_PARAMETER, ValaParameter));
							param = _tmp81_;
							_tmp82_ = param;
							_tmp83_ = vala_parameter_get_direction (_tmp82_);
							_tmp84_ = _tmp83_;
							if (_tmp84_ != VALA_PARAMETER_DIRECTION_IN) {
								gchar* _tmp85_;
								_tmp85_ = g_strdup ("POINTER");
								result = _tmp85_;
								_vala_code_node_unref0 (param);
								return result;
							} else {
								ValaParameter* _tmp86_;
								ValaDataType* _tmp87_;
								ValaDataType* _tmp88_;
								gchar* _tmp89_;
								_tmp86_ = param;
								_tmp87_ = vala_variable_get_variable_type ((ValaVariable*) _tmp86_);
								_tmp88_ = _tmp87_;
								_tmp89_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp88_);
								result = _tmp89_;
								_vala_code_node_unref0 (param);
								return result;
							}
							_vala_code_node_unref0 (param);
						} else {
							gchar* _tmp90_;
							_tmp90_ = g_strdup ("POINTER");
							result = _tmp90_;
							return result;
						}
					}
				}
			}
		}
	} else {
		gboolean _tmp91_ = FALSE;
		ValaCodeNode* _tmp92_;
		_tmp92_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp92_, VALA_TYPE_VALUE_TYPE)) {
			ValaCodeNode* _tmp93_;
			gboolean _tmp94_;
			gboolean _tmp95_;
			_tmp93_ = self->priv->node;
			_tmp94_ = vala_data_type_get_nullable ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_VALUE_TYPE, ValaValueType));
			_tmp95_ = _tmp94_;
			_tmp91_ = _tmp95_;
		} else {
			_tmp91_ = FALSE;
		}
		if (_tmp91_) {
			gchar* _tmp96_;
			_tmp96_ = g_strdup ("POINTER");
			result = _tmp96_;
			return result;
		} else {
			gboolean _tmp97_ = FALSE;
			ValaCodeNode* _tmp98_;
			_tmp98_ = self->priv->node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_POINTER_TYPE)) {
				_tmp97_ = TRUE;
			} else {
				ValaCodeNode* _tmp99_;
				_tmp99_ = self->priv->node;
				_tmp97_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_GENERIC_TYPE);
			}
			if (_tmp97_) {
				gchar* _tmp100_;
				_tmp100_ = g_strdup ("POINTER");
				result = _tmp100_;
				return result;
			} else {
				ValaCodeNode* _tmp101_;
				_tmp101_ = self->priv->node;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_ERROR_TYPE)) {
					gchar* _tmp102_;
					_tmp102_ = g_strdup ("POINTER");
					result = _tmp102_;
					return result;
				} else {
					ValaCodeNode* _tmp103_;
					_tmp103_ = self->priv->node;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp103_, VALA_TYPE_ARRAY_TYPE)) {
						ValaCodeNode* _tmp104_;
						ValaDataType* _tmp105_;
						ValaDataType* _tmp106_;
						ValaTypeSymbol* _tmp107_;
						ValaTypeSymbol* _tmp108_;
						gchar* _tmp109_;
						gchar* _tmp110_;
						gboolean _tmp111_;
						_tmp104_ = self->priv->node;
						_tmp105_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp106_ = _tmp105_;
						_tmp107_ = vala_data_type_get_data_type (_tmp106_);
						_tmp108_ = _tmp107_;
						_tmp109_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp108_);
						_tmp110_ = _tmp109_;
						_tmp111_ = g_strcmp0 (_tmp110_, "string") == 0;
						_g_free0 (_tmp110_);
						if (_tmp111_) {
							gchar* _tmp112_;
							_tmp112_ = g_strdup ("BOXED,INT");
							result = _tmp112_;
							return result;
						} else {
							gchar* ret = NULL;
							gchar* _tmp113_;
							_tmp113_ = g_strdup ("POINTER");
							ret = _tmp113_;
							{
								gint i = 0;
								i = 0;
								{
									gboolean _tmp114_ = FALSE;
									_tmp114_ = TRUE;
									while (TRUE) {
										gint _tmp116_;
										ValaCodeNode* _tmp117_;
										gint _tmp118_;
										gint _tmp119_;
										const gchar* _tmp120_;
										gchar* _tmp121_;
										if (!_tmp114_) {
											gint _tmp115_;
											_tmp115_ = i;
											i = _tmp115_ + 1;
										}
										_tmp114_ = FALSE;
										_tmp116_ = i;
										_tmp117_ = self->priv->node;
										_tmp118_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp117_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
										_tmp119_ = _tmp118_;
										if (!(_tmp116_ < _tmp119_)) {
											break;
										}
										_tmp120_ = ret;
										_tmp121_ = g_strdup_printf ("%s,INT", _tmp120_);
										_g_free0 (ret);
										ret = _tmp121_;
									}
								}
							}
							result = ret;
							return result;
						}
					} else {
						ValaCodeNode* _tmp122_;
						_tmp122_ = self->priv->node;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp122_, VALA_TYPE_VOID_TYPE)) {
							gchar* _tmp123_;
							_tmp123_ = g_strdup ("VOID");
							result = _tmp123_;
							return result;
						} else {
							ValaCodeNode* _tmp124_;
							ValaTypeSymbol* _tmp125_;
							ValaTypeSymbol* _tmp126_;
							gchar* _tmp127_;
							_tmp124_ = self->priv->node;
							_tmp125_ = vala_data_type_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_DATA_TYPE, ValaDataType));
							_tmp126_ = _tmp125_;
							_tmp127_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp126_);
							result = _tmp127_;
							return result;
						}
					}
				}
			}
		}
	}
	_tmp128_ = g_strdup ("");
	result = _tmp128_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_get_value_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp77_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		ValaClass* _tmp3_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp2_;
		_tmp3_ = cl;
		if (vala_class_is_fundamental (_tmp3_)) {
			ValaClass* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = cl;
			_tmp5_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp4_, "value_get_");
			result = _tmp5_;
			_vala_code_node_unref0 (cl);
			return result;
		} else {
			ValaClass* _tmp6_;
			ValaClass* _tmp7_;
			ValaClass* _tmp8_;
			_tmp6_ = cl;
			_tmp7_ = vala_class_get_base_class (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ != NULL) {
				ValaClass* _tmp9_;
				ValaClass* _tmp10_;
				ValaClass* _tmp11_;
				gchar* _tmp12_;
				_tmp9_ = cl;
				_tmp10_ = vala_class_get_base_class (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp11_);
				result = _tmp12_;
				_vala_code_node_unref0 (cl);
				return result;
			} else {
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = vala_ccode_attribute_get_type_id (self);
				_tmp14_ = _tmp13_;
				if (g_strcmp0 (_tmp14_, "G_TYPE_POINTER") == 0) {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("g_value_get_pointer");
					result = _tmp15_;
					_vala_code_node_unref0 (cl);
					return result;
				} else {
					gchar* _tmp16_;
					_tmp16_ = g_strdup ("g_value_get_boxed");
					result = _tmp16_;
					_vala_code_node_unref0 (cl);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaSymbol* _tmp17_;
		_tmp17_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_ENUM)) {
			ValaEnum* en = NULL;
			ValaSymbol* _tmp18_;
			ValaEnum* _tmp19_;
			ValaEnum* _tmp20_;
			_tmp18_ = self->priv->sym;
			_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp19_;
			_tmp20_ = en;
			if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp20_)) {
				ValaEnum* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp21_ = en;
				_tmp22_ = vala_enum_get_is_flags (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_) {
					gchar* _tmp24_;
					_tmp24_ = g_strdup ("g_value_get_flags");
					result = _tmp24_;
					_vala_code_node_unref0 (en);
					return result;
				} else {
					gchar* _tmp25_;
					_tmp25_ = g_strdup ("g_value_get_enum");
					result = _tmp25_;
					_vala_code_node_unref0 (en);
					return result;
				}
			} else {
				ValaEnum* _tmp26_;
				gboolean _tmp27_;
				gboolean _tmp28_;
				_tmp26_ = en;
				_tmp27_ = vala_enum_get_is_flags (_tmp26_);
				_tmp28_ = _tmp27_;
				if (_tmp28_) {
					gchar* _tmp29_;
					_tmp29_ = g_strdup ("g_value_get_uint");
					result = _tmp29_;
					_vala_code_node_unref0 (en);
					return result;
				} else {
					gchar* _tmp30_;
					_tmp30_ = g_strdup ("g_value_get_int");
					result = _tmp30_;
					_vala_code_node_unref0 (en);
					return result;
				}
			}
			_vala_code_node_unref0 (en);
		} else {
			ValaSymbol* _tmp31_;
			_tmp31_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_INTERFACE)) {
				gchar* _tmp48_;
				{
					ValaList* _prereq_list = NULL;
					ValaSymbol* _tmp32_;
					ValaList* _tmp33_;
					gint _prereq_size = 0;
					ValaList* _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					gint _prereq_index = 0;
					_tmp32_ = self->priv->sym;
					_tmp33_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_INTERFACE, ValaInterface));
					_prereq_list = _tmp33_;
					_tmp34_ = _prereq_list;
					_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
					_tmp36_ = _tmp35_;
					_prereq_size = _tmp36_;
					_prereq_index = -1;
					while (TRUE) {
						gint _tmp37_;
						gint _tmp38_;
						gint _tmp39_;
						ValaDataType* prereq = NULL;
						ValaList* _tmp40_;
						gint _tmp41_;
						gpointer _tmp42_;
						gchar* type_name = NULL;
						ValaDataType* _tmp43_;
						ValaTypeSymbol* _tmp44_;
						ValaTypeSymbol* _tmp45_;
						gchar* _tmp46_;
						const gchar* _tmp47_;
						_tmp37_ = _prereq_index;
						_prereq_index = _tmp37_ + 1;
						_tmp38_ = _prereq_index;
						_tmp39_ = _prereq_size;
						if (!(_tmp38_ < _tmp39_)) {
							break;
						}
						_tmp40_ = _prereq_list;
						_tmp41_ = _prereq_index;
						_tmp42_ = vala_list_get (_tmp40_, _tmp41_);
						prereq = (ValaDataType*) _tmp42_;
						_tmp43_ = prereq;
						_tmp44_ = vala_data_type_get_data_type (_tmp43_);
						_tmp45_ = _tmp44_;
						_tmp46_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp45_);
						type_name = _tmp46_;
						_tmp47_ = type_name;
						if (g_strcmp0 (_tmp47_, "") != 0) {
							result = type_name;
							_vala_code_node_unref0 (prereq);
							_vala_iterable_unref0 (_prereq_list);
							return result;
						}
						_g_free0 (type_name);
						_vala_code_node_unref0 (prereq);
					}
					_vala_iterable_unref0 (_prereq_list);
				}
				_tmp48_ = g_strdup ("g_value_get_pointer");
				result = _tmp48_;
				return result;
			} else {
				ValaSymbol* _tmp49_;
				_tmp49_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, VALA_TYPE_STRUCT)) {
					ValaStruct* st = NULL;
					ValaSymbol* _tmp50_;
					ValaStruct* _tmp51_;
					ValaStruct* base_st = NULL;
					ValaStruct* _tmp52_;
					ValaStruct* _tmp53_;
					ValaStruct* _tmp54_;
					ValaStruct* _tmp55_;
					ValaStruct* _tmp64_;
					_tmp50_ = self->priv->sym;
					_tmp51_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp51_;
					_tmp52_ = st;
					_tmp53_ = vala_struct_get_base_struct (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = _vala_code_node_ref0 (_tmp54_);
					base_st = _tmp55_;
					while (TRUE) {
						ValaStruct* _tmp56_;
						ValaStruct* _tmp57_;
						_tmp56_ = base_st;
						if (!(_tmp56_ != NULL)) {
							break;
						}
						_tmp57_ = base_st;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp57_)) {
							ValaStruct* _tmp58_;
							gchar* _tmp59_;
							_tmp58_ = base_st;
							_tmp59_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp58_);
							result = _tmp59_;
							_vala_code_node_unref0 (base_st);
							_vala_code_node_unref0 (st);
							return result;
						} else {
							ValaStruct* _tmp60_;
							ValaStruct* _tmp61_;
							ValaStruct* _tmp62_;
							ValaStruct* _tmp63_;
							_tmp60_ = base_st;
							_tmp61_ = vala_struct_get_base_struct (_tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = _vala_code_node_ref0 (_tmp62_);
							_vala_code_node_unref0 (base_st);
							base_st = _tmp63_;
						}
					}
					_tmp64_ = st;
					if (vala_struct_is_simple_type (_tmp64_)) {
						ValaStruct* _tmp65_;
						ValaSourceReference* _tmp66_;
						ValaSourceReference* _tmp67_;
						ValaStruct* _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						gchar* _tmp71_;
						gchar* _tmp72_;
						_tmp65_ = st;
						_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = st;
						_tmp69_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = g_strdup_printf ("The type `%s` doesn't declare a GValue get function", _tmp70_);
						_tmp72_ = _tmp71_;
						vala_report_error (_tmp67_, _tmp72_);
						_g_free0 (_tmp72_);
						_g_free0 (_tmp70_);
					} else {
						ValaStruct* _tmp73_;
						_tmp73_ = st;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp73_)) {
							gchar* _tmp74_;
							_tmp74_ = g_strdup ("g_value_get_boxed");
							result = _tmp74_;
							_vala_code_node_unref0 (base_st);
							_vala_code_node_unref0 (st);
							return result;
						} else {
							gchar* _tmp75_;
							_tmp75_ = g_strdup ("g_value_get_pointer");
							result = _tmp75_;
							_vala_code_node_unref0 (base_st);
							_vala_code_node_unref0 (st);
							return result;
						}
					}
					_vala_code_node_unref0 (base_st);
					_vala_code_node_unref0 (st);
				} else {
					gchar* _tmp76_;
					_tmp76_ = g_strdup ("g_value_get_pointer");
					result = _tmp76_;
					return result;
				}
			}
		}
	}
	_tmp77_ = g_strdup ("");
	result = _tmp77_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_set_value_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp77_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		ValaClass* _tmp3_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp2_;
		_tmp3_ = cl;
		if (vala_class_is_fundamental (_tmp3_)) {
			ValaClass* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = cl;
			_tmp5_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp4_, "value_set_");
			result = _tmp5_;
			_vala_code_node_unref0 (cl);
			return result;
		} else {
			ValaClass* _tmp6_;
			ValaClass* _tmp7_;
			ValaClass* _tmp8_;
			_tmp6_ = cl;
			_tmp7_ = vala_class_get_base_class (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ != NULL) {
				ValaClass* _tmp9_;
				ValaClass* _tmp10_;
				ValaClass* _tmp11_;
				gchar* _tmp12_;
				_tmp9_ = cl;
				_tmp10_ = vala_class_get_base_class (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_get_ccode_set_value_function ((ValaCodeNode*) _tmp11_);
				result = _tmp12_;
				_vala_code_node_unref0 (cl);
				return result;
			} else {
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = vala_ccode_attribute_get_type_id (self);
				_tmp14_ = _tmp13_;
				if (g_strcmp0 (_tmp14_, "G_TYPE_POINTER") == 0) {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("g_value_set_pointer");
					result = _tmp15_;
					_vala_code_node_unref0 (cl);
					return result;
				} else {
					gchar* _tmp16_;
					_tmp16_ = g_strdup ("g_value_set_boxed");
					result = _tmp16_;
					_vala_code_node_unref0 (cl);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaSymbol* _tmp17_;
		_tmp17_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_ENUM)) {
			ValaEnum* en = NULL;
			ValaSymbol* _tmp18_;
			ValaEnum* _tmp19_;
			ValaEnum* _tmp20_;
			_tmp18_ = self->priv->sym;
			_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp19_;
			_tmp20_ = en;
			if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp20_)) {
				ValaEnum* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp21_ = en;
				_tmp22_ = vala_enum_get_is_flags (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_) {
					gchar* _tmp24_;
					_tmp24_ = g_strdup ("g_value_set_flags");
					result = _tmp24_;
					_vala_code_node_unref0 (en);
					return result;
				} else {
					gchar* _tmp25_;
					_tmp25_ = g_strdup ("g_value_set_enum");
					result = _tmp25_;
					_vala_code_node_unref0 (en);
					return result;
				}
			} else {
				ValaEnum* _tmp26_;
				gboolean _tmp27_;
				gboolean _tmp28_;
				_tmp26_ = en;
				_tmp27_ = vala_enum_get_is_flags (_tmp26_);
				_tmp28_ = _tmp27_;
				if (_tmp28_) {
					gchar* _tmp29_;
					_tmp29_ = g_strdup ("g_value_set_uint");
					result = _tmp29_;
					_vala_code_node_unref0 (en);
					return result;
				} else {
					gchar* _tmp30_;
					_tmp30_ = g_strdup ("g_value_set_int");
					result = _tmp30_;
					_vala_code_node_unref0 (en);
					return result;
				}
			}
			_vala_code_node_unref0 (en);
		} else {
			ValaSymbol* _tmp31_;
			_tmp31_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_INTERFACE)) {
				gchar* _tmp48_;
				{
					ValaList* _prereq_list = NULL;
					ValaSymbol* _tmp32_;
					ValaList* _tmp33_;
					gint _prereq_size = 0;
					ValaList* _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					gint _prereq_index = 0;
					_tmp32_ = self->priv->sym;
					_tmp33_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_INTERFACE, ValaInterface));
					_prereq_list = _tmp33_;
					_tmp34_ = _prereq_list;
					_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
					_tmp36_ = _tmp35_;
					_prereq_size = _tmp36_;
					_prereq_index = -1;
					while (TRUE) {
						gint _tmp37_;
						gint _tmp38_;
						gint _tmp39_;
						ValaDataType* prereq = NULL;
						ValaList* _tmp40_;
						gint _tmp41_;
						gpointer _tmp42_;
						gchar* type_name = NULL;
						ValaDataType* _tmp43_;
						ValaTypeSymbol* _tmp44_;
						ValaTypeSymbol* _tmp45_;
						gchar* _tmp46_;
						const gchar* _tmp47_;
						_tmp37_ = _prereq_index;
						_prereq_index = _tmp37_ + 1;
						_tmp38_ = _prereq_index;
						_tmp39_ = _prereq_size;
						if (!(_tmp38_ < _tmp39_)) {
							break;
						}
						_tmp40_ = _prereq_list;
						_tmp41_ = _prereq_index;
						_tmp42_ = vala_list_get (_tmp40_, _tmp41_);
						prereq = (ValaDataType*) _tmp42_;
						_tmp43_ = prereq;
						_tmp44_ = vala_data_type_get_data_type (_tmp43_);
						_tmp45_ = _tmp44_;
						_tmp46_ = vala_get_ccode_set_value_function ((ValaCodeNode*) _tmp45_);
						type_name = _tmp46_;
						_tmp47_ = type_name;
						if (g_strcmp0 (_tmp47_, "") != 0) {
							result = type_name;
							_vala_code_node_unref0 (prereq);
							_vala_iterable_unref0 (_prereq_list);
							return result;
						}
						_g_free0 (type_name);
						_vala_code_node_unref0 (prereq);
					}
					_vala_iterable_unref0 (_prereq_list);
				}
				_tmp48_ = g_strdup ("g_value_set_pointer");
				result = _tmp48_;
				return result;
			} else {
				ValaSymbol* _tmp49_;
				_tmp49_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, VALA_TYPE_STRUCT)) {
					ValaStruct* st = NULL;
					ValaSymbol* _tmp50_;
					ValaStruct* _tmp51_;
					ValaStruct* base_st = NULL;
					ValaStruct* _tmp52_;
					ValaStruct* _tmp53_;
					ValaStruct* _tmp54_;
					ValaStruct* _tmp55_;
					ValaStruct* _tmp64_;
					_tmp50_ = self->priv->sym;
					_tmp51_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp51_;
					_tmp52_ = st;
					_tmp53_ = vala_struct_get_base_struct (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = _vala_code_node_ref0 (_tmp54_);
					base_st = _tmp55_;
					while (TRUE) {
						ValaStruct* _tmp56_;
						ValaStruct* _tmp57_;
						_tmp56_ = base_st;
						if (!(_tmp56_ != NULL)) {
							break;
						}
						_tmp57_ = base_st;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp57_)) {
							ValaStruct* _tmp58_;
							gchar* _tmp59_;
							_tmp58_ = base_st;
							_tmp59_ = vala_get_ccode_set_value_function ((ValaCodeNode*) _tmp58_);
							result = _tmp59_;
							_vala_code_node_unref0 (base_st);
							_vala_code_node_unref0 (st);
							return result;
						} else {
							ValaStruct* _tmp60_;
							ValaStruct* _tmp61_;
							ValaStruct* _tmp62_;
							ValaStruct* _tmp63_;
							_tmp60_ = base_st;
							_tmp61_ = vala_struct_get_base_struct (_tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = _vala_code_node_ref0 (_tmp62_);
							_vala_code_node_unref0 (base_st);
							base_st = _tmp63_;
						}
					}
					_tmp64_ = st;
					if (vala_struct_is_simple_type (_tmp64_)) {
						ValaStruct* _tmp65_;
						ValaSourceReference* _tmp66_;
						ValaSourceReference* _tmp67_;
						ValaStruct* _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						gchar* _tmp71_;
						gchar* _tmp72_;
						_tmp65_ = st;
						_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = st;
						_tmp69_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = g_strdup_printf ("The type `%s` doesn't declare a GValue set function", _tmp70_);
						_tmp72_ = _tmp71_;
						vala_report_error (_tmp67_, _tmp72_);
						_g_free0 (_tmp72_);
						_g_free0 (_tmp70_);
					} else {
						ValaStruct* _tmp73_;
						_tmp73_ = st;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp73_)) {
							gchar* _tmp74_;
							_tmp74_ = g_strdup ("g_value_set_boxed");
							result = _tmp74_;
							_vala_code_node_unref0 (base_st);
							_vala_code_node_unref0 (st);
							return result;
						} else {
							gchar* _tmp75_;
							_tmp75_ = g_strdup ("g_value_set_pointer");
							result = _tmp75_;
							_vala_code_node_unref0 (base_st);
							_vala_code_node_unref0 (st);
							return result;
						}
					}
					_vala_code_node_unref0 (base_st);
					_vala_code_node_unref0 (st);
				} else {
					gchar* _tmp76_;
					_tmp76_ = g_strdup ("g_value_set_pointer");
					result = _tmp76_;
					return result;
				}
			}
		}
	}
	_tmp77_ = g_strdup ("");
	result = _tmp77_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_take_value_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp77_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		ValaClass* _tmp3_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp2_;
		_tmp3_ = cl;
		if (vala_class_is_fundamental (_tmp3_)) {
			ValaClass* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = cl;
			_tmp5_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp4_, "value_take_");
			result = _tmp5_;
			_vala_code_node_unref0 (cl);
			return result;
		} else {
			ValaClass* _tmp6_;
			ValaClass* _tmp7_;
			ValaClass* _tmp8_;
			_tmp6_ = cl;
			_tmp7_ = vala_class_get_base_class (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ != NULL) {
				ValaClass* _tmp9_;
				ValaClass* _tmp10_;
				ValaClass* _tmp11_;
				gchar* _tmp12_;
				_tmp9_ = cl;
				_tmp10_ = vala_class_get_base_class (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_get_ccode_take_value_function ((ValaCodeNode*) _tmp11_);
				result = _tmp12_;
				_vala_code_node_unref0 (cl);
				return result;
			} else {
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = vala_ccode_attribute_get_type_id (self);
				_tmp14_ = _tmp13_;
				if (g_strcmp0 (_tmp14_, "G_TYPE_POINTER") == 0) {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("g_value_set_pointer");
					result = _tmp15_;
					_vala_code_node_unref0 (cl);
					return result;
				} else {
					gchar* _tmp16_;
					_tmp16_ = g_strdup ("g_value_take_boxed");
					result = _tmp16_;
					_vala_code_node_unref0 (cl);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaSymbol* _tmp17_;
		_tmp17_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_ENUM)) {
			ValaEnum* en = NULL;
			ValaSymbol* _tmp18_;
			ValaEnum* _tmp19_;
			ValaEnum* _tmp20_;
			_tmp18_ = self->priv->sym;
			_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp19_;
			_tmp20_ = en;
			if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp20_)) {
				ValaEnum* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp21_ = en;
				_tmp22_ = vala_enum_get_is_flags (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_) {
					gchar* _tmp24_;
					_tmp24_ = g_strdup ("g_value_take_flags");
					result = _tmp24_;
					_vala_code_node_unref0 (en);
					return result;
				} else {
					gchar* _tmp25_;
					_tmp25_ = g_strdup ("g_value_take_enum");
					result = _tmp25_;
					_vala_code_node_unref0 (en);
					return result;
				}
			} else {
				ValaEnum* _tmp26_;
				gboolean _tmp27_;
				gboolean _tmp28_;
				_tmp26_ = en;
				_tmp27_ = vala_enum_get_is_flags (_tmp26_);
				_tmp28_ = _tmp27_;
				if (_tmp28_) {
					gchar* _tmp29_;
					_tmp29_ = g_strdup ("g_value_take_uint");
					result = _tmp29_;
					_vala_code_node_unref0 (en);
					return result;
				} else {
					gchar* _tmp30_;
					_tmp30_ = g_strdup ("g_value_take_int");
					result = _tmp30_;
					_vala_code_node_unref0 (en);
					return result;
				}
			}
			_vala_code_node_unref0 (en);
		} else {
			ValaSymbol* _tmp31_;
			_tmp31_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_INTERFACE)) {
				gchar* _tmp48_;
				{
					ValaList* _prereq_list = NULL;
					ValaSymbol* _tmp32_;
					ValaList* _tmp33_;
					gint _prereq_size = 0;
					ValaList* _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					gint _prereq_index = 0;
					_tmp32_ = self->priv->sym;
					_tmp33_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_INTERFACE, ValaInterface));
					_prereq_list = _tmp33_;
					_tmp34_ = _prereq_list;
					_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
					_tmp36_ = _tmp35_;
					_prereq_size = _tmp36_;
					_prereq_index = -1;
					while (TRUE) {
						gint _tmp37_;
						gint _tmp38_;
						gint _tmp39_;
						ValaDataType* prereq = NULL;
						ValaList* _tmp40_;
						gint _tmp41_;
						gpointer _tmp42_;
						gchar* func = NULL;
						ValaDataType* _tmp43_;
						ValaTypeSymbol* _tmp44_;
						ValaTypeSymbol* _tmp45_;
						gchar* _tmp46_;
						const gchar* _tmp47_;
						_tmp37_ = _prereq_index;
						_prereq_index = _tmp37_ + 1;
						_tmp38_ = _prereq_index;
						_tmp39_ = _prereq_size;
						if (!(_tmp38_ < _tmp39_)) {
							break;
						}
						_tmp40_ = _prereq_list;
						_tmp41_ = _prereq_index;
						_tmp42_ = vala_list_get (_tmp40_, _tmp41_);
						prereq = (ValaDataType*) _tmp42_;
						_tmp43_ = prereq;
						_tmp44_ = vala_data_type_get_data_type (_tmp43_);
						_tmp45_ = _tmp44_;
						_tmp46_ = vala_get_ccode_take_value_function ((ValaCodeNode*) _tmp45_);
						func = _tmp46_;
						_tmp47_ = func;
						if (g_strcmp0 (_tmp47_, "") != 0) {
							result = func;
							_vala_code_node_unref0 (prereq);
							_vala_iterable_unref0 (_prereq_list);
							return result;
						}
						_g_free0 (func);
						_vala_code_node_unref0 (prereq);
					}
					_vala_iterable_unref0 (_prereq_list);
				}
				_tmp48_ = g_strdup ("g_value_set_pointer");
				result = _tmp48_;
				return result;
			} else {
				ValaSymbol* _tmp49_;
				_tmp49_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, VALA_TYPE_STRUCT)) {
					ValaStruct* st = NULL;
					ValaSymbol* _tmp50_;
					ValaStruct* _tmp51_;
					ValaStruct* base_st = NULL;
					ValaStruct* _tmp52_;
					ValaStruct* _tmp53_;
					ValaStruct* _tmp54_;
					ValaStruct* _tmp55_;
					ValaStruct* _tmp64_;
					_tmp50_ = self->priv->sym;
					_tmp51_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp51_;
					_tmp52_ = st;
					_tmp53_ = vala_struct_get_base_struct (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = _vala_code_node_ref0 (_tmp54_);
					base_st = _tmp55_;
					while (TRUE) {
						ValaStruct* _tmp56_;
						ValaStruct* _tmp57_;
						_tmp56_ = base_st;
						if (!(_tmp56_ != NULL)) {
							break;
						}
						_tmp57_ = base_st;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp57_)) {
							ValaStruct* _tmp58_;
							gchar* _tmp59_;
							_tmp58_ = base_st;
							_tmp59_ = vala_get_ccode_take_value_function ((ValaCodeNode*) _tmp58_);
							result = _tmp59_;
							_vala_code_node_unref0 (base_st);
							_vala_code_node_unref0 (st);
							return result;
						} else {
							ValaStruct* _tmp60_;
							ValaStruct* _tmp61_;
							ValaStruct* _tmp62_;
							ValaStruct* _tmp63_;
							_tmp60_ = base_st;
							_tmp61_ = vala_struct_get_base_struct (_tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = _vala_code_node_ref0 (_tmp62_);
							_vala_code_node_unref0 (base_st);
							base_st = _tmp63_;
						}
					}
					_tmp64_ = st;
					if (vala_struct_is_simple_type (_tmp64_)) {
						ValaStruct* _tmp65_;
						ValaSourceReference* _tmp66_;
						ValaSourceReference* _tmp67_;
						ValaStruct* _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						gchar* _tmp71_;
						gchar* _tmp72_;
						_tmp65_ = st;
						_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = st;
						_tmp69_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = g_strdup_printf ("The type `%s` doesn't declare a GValue take function", _tmp70_);
						_tmp72_ = _tmp71_;
						vala_report_error (_tmp67_, _tmp72_);
						_g_free0 (_tmp72_);
						_g_free0 (_tmp70_);
					} else {
						ValaStruct* _tmp73_;
						_tmp73_ = st;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp73_)) {
							gchar* _tmp74_;
							_tmp74_ = g_strdup ("g_value_take_boxed");
							result = _tmp74_;
							_vala_code_node_unref0 (base_st);
							_vala_code_node_unref0 (st);
							return result;
						} else {
							gchar* _tmp75_;
							_tmp75_ = g_strdup ("g_value_set_pointer");
							result = _tmp75_;
							_vala_code_node_unref0 (base_st);
							_vala_code_node_unref0 (st);
							return result;
						}
					}
					_vala_code_node_unref0 (base_st);
					_vala_code_node_unref0 (st);
				} else {
					gchar* _tmp76_;
					_tmp76_ = g_strdup ("g_value_set_pointer");
					result = _tmp76_;
					return result;
				}
			}
		}
	}
	_tmp77_ = g_strdup ("");
	result = _tmp77_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_param_spec_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	gchar* _tmp102_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_SYMBOL)) {
		ValaSymbol* _tmp1_;
		_tmp1_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp2_;
			ValaClass* _tmp3_;
			ValaClass* _tmp4_;
			_tmp2_ = self->priv->sym;
			_tmp3_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp3_;
			_tmp4_ = cl;
			if (vala_class_is_fundamental (_tmp4_)) {
				ValaClass* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = cl;
				_tmp6_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp5_, "param_spec_");
				result = _tmp6_;
				_vala_code_node_unref0 (cl);
				return result;
			} else {
				ValaClass* _tmp7_;
				ValaClass* _tmp8_;
				ValaClass* _tmp9_;
				_tmp7_ = cl;
				_tmp8_ = vala_class_get_base_class (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_ != NULL) {
					ValaClass* _tmp10_;
					ValaClass* _tmp11_;
					ValaClass* _tmp12_;
					gchar* _tmp13_;
					_tmp10_ = cl;
					_tmp11_ = vala_class_get_base_class (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = vala_get_ccode_param_spec_function ((ValaCodeNode*) _tmp12_);
					result = _tmp13_;
					_vala_code_node_unref0 (cl);
					return result;
				} else {
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp14_ = vala_ccode_attribute_get_type_id (self);
					_tmp15_ = _tmp14_;
					if (g_strcmp0 (_tmp15_, "G_TYPE_POINTER") == 0) {
						gchar* _tmp16_;
						_tmp16_ = g_strdup ("g_param_spec_pointer");
						result = _tmp16_;
						_vala_code_node_unref0 (cl);
						return result;
					} else {
						gchar* _tmp17_;
						_tmp17_ = g_strdup ("g_param_spec_boxed");
						result = _tmp17_;
						_vala_code_node_unref0 (cl);
						return result;
					}
				}
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp18_;
			_tmp18_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_INTERFACE)) {
				gchar* _tmp35_;
				{
					ValaList* _prereq_list = NULL;
					ValaSymbol* _tmp19_;
					ValaList* _tmp20_;
					gint _prereq_size = 0;
					ValaList* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					gint _prereq_index = 0;
					_tmp19_ = self->priv->sym;
					_tmp20_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_INTERFACE, ValaInterface));
					_prereq_list = _tmp20_;
					_tmp21_ = _prereq_list;
					_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
					_tmp23_ = _tmp22_;
					_prereq_size = _tmp23_;
					_prereq_index = -1;
					while (TRUE) {
						gint _tmp24_;
						gint _tmp25_;
						gint _tmp26_;
						ValaDataType* prereq = NULL;
						ValaList* _tmp27_;
						gint _tmp28_;
						gpointer _tmp29_;
						gchar* func = NULL;
						ValaDataType* _tmp30_;
						ValaTypeSymbol* _tmp31_;
						ValaTypeSymbol* _tmp32_;
						gchar* _tmp33_;
						const gchar* _tmp34_;
						_tmp24_ = _prereq_index;
						_prereq_index = _tmp24_ + 1;
						_tmp25_ = _prereq_index;
						_tmp26_ = _prereq_size;
						if (!(_tmp25_ < _tmp26_)) {
							break;
						}
						_tmp27_ = _prereq_list;
						_tmp28_ = _prereq_index;
						_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
						prereq = (ValaDataType*) _tmp29_;
						_tmp30_ = prereq;
						_tmp31_ = vala_data_type_get_data_type (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = vala_get_ccode_param_spec_function ((ValaCodeNode*) _tmp32_);
						func = _tmp33_;
						_tmp34_ = func;
						if (g_strcmp0 (_tmp34_, "") != 0) {
							result = func;
							_vala_code_node_unref0 (prereq);
							_vala_iterable_unref0 (_prereq_list);
							return result;
						}
						_g_free0 (func);
						_vala_code_node_unref0 (prereq);
					}
					_vala_iterable_unref0 (_prereq_list);
				}
				_tmp35_ = g_strdup ("g_param_spec_pointer");
				result = _tmp35_;
				return result;
			} else {
				ValaSymbol* _tmp36_;
				_tmp36_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM)) {
					ValaEnum* e = NULL;
					ValaSymbol* _tmp37_;
					ValaEnum* _tmp38_;
					ValaEnum* _tmp39_;
					_tmp37_ = self->priv->sym;
					_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALA_TYPE_ENUM) ? ((ValaEnum*) _tmp37_) : NULL);
					e = _tmp38_;
					_tmp39_ = e;
					if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp39_)) {
						ValaEnum* _tmp40_;
						gboolean _tmp41_;
						gboolean _tmp42_;
						_tmp40_ = e;
						_tmp41_ = vala_enum_get_is_flags (_tmp40_);
						_tmp42_ = _tmp41_;
						if (_tmp42_) {
							gchar* _tmp43_;
							_tmp43_ = g_strdup ("g_param_spec_flags");
							result = _tmp43_;
							_vala_code_node_unref0 (e);
							return result;
						} else {
							gchar* _tmp44_;
							_tmp44_ = g_strdup ("g_param_spec_enum");
							result = _tmp44_;
							_vala_code_node_unref0 (e);
							return result;
						}
					} else {
						ValaEnum* _tmp45_;
						gboolean _tmp46_;
						gboolean _tmp47_;
						_tmp45_ = e;
						_tmp46_ = vala_enum_get_is_flags (_tmp45_);
						_tmp47_ = _tmp46_;
						if (_tmp47_) {
							gchar* _tmp48_;
							_tmp48_ = g_strdup ("g_param_spec_uint");
							result = _tmp48_;
							_vala_code_node_unref0 (e);
							return result;
						} else {
							gchar* _tmp49_;
							_tmp49_ = g_strdup ("g_param_spec_int");
							result = _tmp49_;
							_vala_code_node_unref0 (e);
							return result;
						}
					}
					_vala_code_node_unref0 (e);
				} else {
					ValaSymbol* _tmp50_;
					_tmp50_ = self->priv->sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, VALA_TYPE_STRUCT)) {
						gchar* type_id = NULL;
						ValaSymbol* _tmp51_;
						gchar* _tmp52_;
						const gchar* _tmp53_;
						_tmp51_ = self->priv->sym;
						_tmp52_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp51_);
						type_id = _tmp52_;
						_tmp53_ = type_id;
						if (g_strcmp0 (_tmp53_, "G_TYPE_INT") == 0) {
							gchar* _tmp54_;
							_tmp54_ = g_strdup ("g_param_spec_int");
							result = _tmp54_;
							_g_free0 (type_id);
							return result;
						} else {
							const gchar* _tmp55_;
							_tmp55_ = type_id;
							if (g_strcmp0 (_tmp55_, "G_TYPE_UINT") == 0) {
								gchar* _tmp56_;
								_tmp56_ = g_strdup ("g_param_spec_uint");
								result = _tmp56_;
								_g_free0 (type_id);
								return result;
							} else {
								const gchar* _tmp57_;
								_tmp57_ = type_id;
								if (g_strcmp0 (_tmp57_, "G_TYPE_INT64") == 0) {
									gchar* _tmp58_;
									_tmp58_ = g_strdup ("g_param_spec_int64");
									result = _tmp58_;
									_g_free0 (type_id);
									return result;
								} else {
									const gchar* _tmp59_;
									_tmp59_ = type_id;
									if (g_strcmp0 (_tmp59_, "G_TYPE_UINT64") == 0) {
										gchar* _tmp60_;
										_tmp60_ = g_strdup ("g_param_spec_uint64");
										result = _tmp60_;
										_g_free0 (type_id);
										return result;
									} else {
										const gchar* _tmp61_;
										_tmp61_ = type_id;
										if (g_strcmp0 (_tmp61_, "G_TYPE_LONG") == 0) {
											gchar* _tmp62_;
											_tmp62_ = g_strdup ("g_param_spec_long");
											result = _tmp62_;
											_g_free0 (type_id);
											return result;
										} else {
											const gchar* _tmp63_;
											_tmp63_ = type_id;
											if (g_strcmp0 (_tmp63_, "G_TYPE_ULONG") == 0) {
												gchar* _tmp64_;
												_tmp64_ = g_strdup ("g_param_spec_ulong");
												result = _tmp64_;
												_g_free0 (type_id);
												return result;
											} else {
												const gchar* _tmp65_;
												_tmp65_ = type_id;
												if (g_strcmp0 (_tmp65_, "G_TYPE_BOOLEAN") == 0) {
													gchar* _tmp66_;
													_tmp66_ = g_strdup ("g_param_spec_boolean");
													result = _tmp66_;
													_g_free0 (type_id);
													return result;
												} else {
													const gchar* _tmp67_;
													_tmp67_ = type_id;
													if (g_strcmp0 (_tmp67_, "G_TYPE_CHAR") == 0) {
														gchar* _tmp68_;
														_tmp68_ = g_strdup ("g_param_spec_char");
														result = _tmp68_;
														_g_free0 (type_id);
														return result;
													} else {
														const gchar* _tmp69_;
														_tmp69_ = type_id;
														if (g_strcmp0 (_tmp69_, "G_TYPE_UCHAR") == 0) {
															gchar* _tmp70_;
															_tmp70_ = g_strdup ("g_param_spec_uchar");
															result = _tmp70_;
															_g_free0 (type_id);
															return result;
														} else {
															const gchar* _tmp71_;
															_tmp71_ = type_id;
															if (g_strcmp0 (_tmp71_, "G_TYPE_FLOAT") == 0) {
																gchar* _tmp72_;
																_tmp72_ = g_strdup ("g_param_spec_float");
																result = _tmp72_;
																_g_free0 (type_id);
																return result;
															} else {
																const gchar* _tmp73_;
																_tmp73_ = type_id;
																if (g_strcmp0 (_tmp73_, "G_TYPE_DOUBLE") == 0) {
																	gchar* _tmp74_;
																	_tmp74_ = g_strdup ("g_param_spec_double");
																	result = _tmp74_;
																	_g_free0 (type_id);
																	return result;
																} else {
																	const gchar* _tmp75_;
																	_tmp75_ = type_id;
																	if (g_strcmp0 (_tmp75_, "G_TYPE_GTYPE") == 0) {
																		gchar* _tmp76_;
																		_tmp76_ = g_strdup ("g_param_spec_gtype");
																		result = _tmp76_;
																		_g_free0 (type_id);
																		return result;
																	} else {
																		gchar* _tmp77_;
																		_tmp77_ = g_strdup ("g_param_spec_boxed");
																		result = _tmp77_;
																		_g_free0 (type_id);
																		return result;
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
						_g_free0 (type_id);
					}
				}
			}
		}
	} else {
		gboolean _tmp78_ = FALSE;
		ValaCodeNode* _tmp79_;
		_tmp79_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp79_, VALA_TYPE_ARRAY_TYPE)) {
			ValaCodeNode* _tmp80_;
			ValaDataType* _tmp81_;
			ValaDataType* _tmp82_;
			ValaTypeSymbol* _tmp83_;
			ValaTypeSymbol* _tmp84_;
			ValaCodeContext* _tmp85_;
			ValaCodeContext* _tmp86_;
			ValaSemanticAnalyzer* _tmp87_;
			ValaSemanticAnalyzer* _tmp88_;
			ValaDataType* _tmp89_;
			ValaTypeSymbol* _tmp90_;
			ValaTypeSymbol* _tmp91_;
			_tmp80_ = self->priv->node;
			_tmp81_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_data_type_get_data_type (_tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_code_context_get ();
			_tmp86_ = _tmp85_;
			_tmp87_ = vala_code_context_get_analyzer (_tmp86_);
			_tmp88_ = _tmp87_;
			_tmp89_ = _tmp88_->string_type;
			_tmp90_ = vala_data_type_get_data_type (_tmp89_);
			_tmp91_ = _tmp90_;
			_tmp78_ = _tmp84_ == _tmp91_;
			_vala_code_context_unref0 (_tmp86_);
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			gchar* _tmp92_;
			_tmp92_ = g_strdup ("g_param_spec_boxed");
			result = _tmp92_;
			return result;
		} else {
			gboolean _tmp93_ = FALSE;
			ValaCodeNode* _tmp94_;
			_tmp94_ = self->priv->node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp94_, VALA_TYPE_DATA_TYPE)) {
				ValaCodeNode* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaTypeSymbol* _tmp97_;
				_tmp95_ = self->priv->node;
				_tmp96_ = vala_data_type_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_DATA_TYPE, ValaDataType));
				_tmp97_ = _tmp96_;
				_tmp93_ = _tmp97_ != NULL;
			} else {
				_tmp93_ = FALSE;
			}
			if (_tmp93_) {
				ValaCodeNode* _tmp98_;
				ValaTypeSymbol* _tmp99_;
				ValaTypeSymbol* _tmp100_;
				gchar* _tmp101_;
				_tmp98_ = self->priv->node;
				_tmp99_ = vala_data_type_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_DATA_TYPE, ValaDataType));
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_get_ccode_param_spec_function ((ValaCodeNode*) _tmp100_);
				result = _tmp101_;
				return result;
			}
		}
	}
	_tmp102_ = g_strdup ("g_param_spec_pointer");
	result = _tmp102_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_default_value (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_ENUM)) {
		ValaEnum* en = NULL;
		ValaSymbol* _tmp1_;
		ValaEnum* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = self->priv->sym;
		en = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_ENUM, ValaEnum);
		_tmp2_ = en;
		_tmp3_ = vala_enum_get_is_flags (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("0U");
			result = _tmp5_;
			return result;
		} else {
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("0");
			result = _tmp6_;
			return result;
		}
	} else {
		ValaSymbol* _tmp7_;
		_tmp7_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_STRUCT)) {
			ValaStruct* st = NULL;
			ValaSymbol* _tmp8_;
			ValaStruct* _tmp9_;
			ValaStruct* base_st = NULL;
			ValaStruct* _tmp10_;
			ValaStruct* _tmp11_;
			ValaStruct* _tmp12_;
			ValaStruct* _tmp13_;
			ValaStruct* _tmp14_;
			_tmp8_ = self->priv->sym;
			_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp9_;
			_tmp10_ = st;
			_tmp11_ = vala_struct_get_base_struct (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _vala_code_node_ref0 (_tmp12_);
			base_st = _tmp13_;
			_tmp14_ = base_st;
			if (_tmp14_ != NULL) {
				ValaStruct* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = base_st;
				_tmp16_ = vala_get_ccode_default_value ((ValaTypeSymbol*) _tmp15_);
				result = _tmp16_;
				_vala_code_node_unref0 (base_st);
				_vala_code_node_unref0 (st);
				return result;
			}
			_vala_code_node_unref0 (base_st);
			_vala_code_node_unref0 (st);
		}
	}
	_tmp17_ = g_strdup ("");
	result = _tmp17_;
	return result;
}


static gchar*
vala_ccode_attribute_get_finish_name_for_basename (ValaCCodeAttribute* self,
                                                   const gchar* basename)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (basename != NULL, NULL);
	_tmp0_ = g_strdup (basename);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (g_str_has_suffix (_tmp1_, "_async")) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = _result_;
		_tmp3_ = _result_;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = strlen ("_async");
		_tmp7_ = _tmp6_;
		_tmp8_ = string_substring (_tmp2_, (glong) 0, (glong) (_tmp5_ - _tmp7_));
		_g_free0 (_result_);
		_result_ = _tmp8_;
	}
	_tmp9_ = _result_;
	_tmp10_ = g_strdup_printf ("%s_finish", _tmp9_);
	result = _tmp10_;
	_g_free0 (_result_);
	return result;
}


static gchar*
vala_ccode_attribute_get_default_real_name (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CREATION_METHOD)) {
		ValaCreationMethod* m = NULL;
		ValaSymbol* _tmp1_;
		ValaCreationMethod* _tmp2_;
		ValaClass* parent = NULL;
		ValaCreationMethod* _tmp3_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaClass* _tmp6_;
		gboolean _tmp7_ = FALSE;
		ValaClass* _tmp8_;
		gchar* infix = NULL;
		gchar* _tmp15_;
		ValaCreationMethod* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		m = _tmp2_;
		_tmp3_ = m;
		_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp5_) : NULL);
		parent = _tmp6_;
		_tmp8_ = parent;
		if (_tmp8_ == NULL) {
			_tmp7_ = TRUE;
		} else {
			ValaClass* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp9_ = parent;
			_tmp10_ = vala_class_get_is_compact (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp7_ = _tmp11_;
		}
		if (_tmp7_) {
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = vala_ccode_attribute_get_name (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup (_tmp13_);
			result = _tmp14_;
			_vala_code_node_unref0 (parent);
			_vala_code_node_unref0 (m);
			return result;
		}
		_tmp15_ = g_strdup ("construct");
		infix = _tmp15_;
		_tmp16_ = m;
		_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
		_tmp18_ = _tmp17_;
		if (g_strcmp0 (_tmp18_, ".new") == 0) {
			ValaClass* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp19_ = parent;
			_tmp20_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = infix;
			_tmp23_ = g_strdup_printf ("%s%s", _tmp21_, _tmp22_);
			_tmp24_ = _tmp23_;
			_g_free0 (_tmp21_);
			result = _tmp24_;
			_g_free0 (infix);
			_vala_code_node_unref0 (parent);
			_vala_code_node_unref0 (m);
			return result;
		} else {
			ValaClass* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			const gchar* _tmp28_;
			ValaCreationMethod* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp25_ = parent;
			_tmp26_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = infix;
			_tmp29_ = m;
			_tmp30_ = vala_symbol_get_name ((ValaSymbol*) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strdup_printf ("%s%s_%s", _tmp27_, _tmp28_, _tmp31_);
			_tmp33_ = _tmp32_;
			_g_free0 (_tmp27_);
			result = _tmp33_;
			_g_free0 (infix);
			_vala_code_node_unref0 (parent);
			_vala_code_node_unref0 (m);
			return result;
		}
		_g_free0 (infix);
		_vala_code_node_unref0 (parent);
		_vala_code_node_unref0 (m);
	} else {
		ValaSymbol* _tmp34_;
		_tmp34_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALA_TYPE_METHOD)) {
			ValaMethod* m = NULL;
			ValaSymbol* _tmp35_;
			ValaMethod* _tmp36_;
			gboolean _tmp37_ = FALSE;
			ValaMethod* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			_tmp35_ = self->priv->sym;
			_tmp36_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_METHOD, ValaMethod));
			m = _tmp36_;
			_tmp38_ = m;
			_tmp39_ = vala_method_get_base_method (_tmp38_);
			_tmp40_ = _tmp39_;
			if (_tmp40_ != NULL) {
				_tmp37_ = TRUE;
			} else {
				ValaMethod* _tmp41_;
				ValaMethod* _tmp42_;
				ValaMethod* _tmp43_;
				_tmp41_ = m;
				_tmp42_ = vala_method_get_base_interface_method (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp37_ = _tmp43_ != NULL;
			}
			if (_tmp37_) {
				gchar* m_name = NULL;
				ValaMethod* _tmp44_;
				ValaSignal* _tmp45_;
				ValaSignal* _tmp46_;
				ValaMethod* _tmp55_;
				ValaDataType* _tmp56_;
				ValaDataType* _tmp57_;
				_tmp44_ = m;
				_tmp45_ = vala_method_get_signal_reference (_tmp44_);
				_tmp46_ = _tmp45_;
				if (_tmp46_ != NULL) {
					ValaMethod* _tmp47_;
					ValaSignal* _tmp48_;
					ValaSignal* _tmp49_;
					gchar* _tmp50_;
					_tmp47_ = m;
					_tmp48_ = vala_method_get_signal_reference (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp49_, NULL);
					_g_free0 (m_name);
					m_name = _tmp50_;
				} else {
					ValaMethod* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					gchar* _tmp54_;
					_tmp51_ = m;
					_tmp52_ = vala_symbol_get_name ((ValaSymbol*) _tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = g_strdup (_tmp53_);
					_g_free0 (m_name);
					m_name = _tmp54_;
				}
				_tmp55_ = m;
				_tmp56_ = vala_method_get_base_interface_type (_tmp55_);
				_tmp57_ = _tmp56_;
				if (_tmp57_ != NULL) {
					ValaMethod* _tmp58_;
					ValaSymbol* _tmp59_;
					ValaSymbol* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					ValaMethod* _tmp63_;
					ValaDataType* _tmp64_;
					ValaDataType* _tmp65_;
					ValaTypeSymbol* _tmp66_;
					ValaTypeSymbol* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					const gchar* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					_tmp58_ = m;
					_tmp59_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = vala_get_ccode_lower_case_prefix (_tmp60_);
					_tmp62_ = _tmp61_;
					_tmp63_ = m;
					_tmp64_ = vala_method_get_base_interface_type (_tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = vala_data_type_get_data_type (_tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = m_name;
					_tmp71_ = g_strdup_printf ("%sreal_%s%s", _tmp62_, _tmp69_, _tmp70_);
					_tmp72_ = _tmp71_;
					_g_free0 (_tmp69_);
					_g_free0 (_tmp62_);
					result = _tmp72_;
					_g_free0 (m_name);
					_vala_code_node_unref0 (m);
					return result;
				} else {
					ValaMethod* _tmp73_;
					ValaSymbol* _tmp74_;
					ValaSymbol* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					const gchar* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					_tmp73_ = m;
					_tmp74_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = vala_get_ccode_lower_case_prefix (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = m_name;
					_tmp79_ = g_strdup_printf ("%sreal_%s", _tmp77_, _tmp78_);
					_tmp80_ = _tmp79_;
					_g_free0 (_tmp77_);
					result = _tmp80_;
					_g_free0 (m_name);
					_vala_code_node_unref0 (m);
					return result;
				}
				_g_free0 (m_name);
			} else {
				const gchar* _tmp81_;
				const gchar* _tmp82_;
				gchar* _tmp83_;
				_tmp81_ = vala_ccode_attribute_get_name (self);
				_tmp82_ = _tmp81_;
				_tmp83_ = g_strdup (_tmp82_);
				result = _tmp83_;
				_vala_code_node_unref0 (m);
				return result;
			}
			_vala_code_node_unref0 (m);
		} else {
			ValaSymbol* _tmp84_;
			_tmp84_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, VALA_TYPE_PROPERTY_ACCESSOR)) {
				ValaPropertyAccessor* acc = NULL;
				ValaSymbol* _tmp85_;
				ValaPropertyAccessor* _tmp86_;
				ValaProperty* prop = NULL;
				ValaPropertyAccessor* _tmp87_;
				ValaProperty* _tmp88_;
				ValaProperty* _tmp89_;
				ValaProperty* _tmp90_;
				gboolean _tmp91_ = FALSE;
				ValaProperty* _tmp92_;
				ValaProperty* _tmp93_;
				ValaProperty* _tmp94_;
				_tmp85_ = self->priv->sym;
				_tmp86_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor));
				acc = _tmp86_;
				_tmp87_ = acc;
				_tmp88_ = vala_property_accessor_get_prop (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp90_;
				_tmp92_ = prop;
				_tmp93_ = vala_property_get_base_property (_tmp92_);
				_tmp94_ = _tmp93_;
				if (_tmp94_ != NULL) {
					_tmp91_ = TRUE;
				} else {
					ValaProperty* _tmp95_;
					ValaProperty* _tmp96_;
					ValaProperty* _tmp97_;
					_tmp95_ = prop;
					_tmp96_ = vala_property_get_base_interface_property (_tmp95_);
					_tmp97_ = _tmp96_;
					_tmp91_ = _tmp97_ != NULL;
				}
				if (_tmp91_) {
					ValaPropertyAccessor* _tmp98_;
					gboolean _tmp99_;
					gboolean _tmp100_;
					_tmp98_ = acc;
					_tmp99_ = vala_property_accessor_get_readable (_tmp98_);
					_tmp100_ = _tmp99_;
					if (_tmp100_) {
						ValaProperty* _tmp101_;
						ValaSymbol* _tmp102_;
						ValaSymbol* _tmp103_;
						gchar* _tmp104_;
						gchar* _tmp105_;
						ValaProperty* _tmp106_;
						const gchar* _tmp107_;
						const gchar* _tmp108_;
						gchar* _tmp109_;
						gchar* _tmp110_;
						_tmp101_ = prop;
						_tmp102_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp101_);
						_tmp103_ = _tmp102_;
						_tmp104_ = vala_get_ccode_lower_case_prefix (_tmp103_);
						_tmp105_ = _tmp104_;
						_tmp106_ = prop;
						_tmp107_ = vala_symbol_get_name ((ValaSymbol*) _tmp106_);
						_tmp108_ = _tmp107_;
						_tmp109_ = g_strdup_printf ("%sreal_get_%s", _tmp105_, _tmp108_);
						_tmp110_ = _tmp109_;
						_g_free0 (_tmp105_);
						result = _tmp110_;
						_vala_code_node_unref0 (prop);
						_vala_code_node_unref0 (acc);
						return result;
					} else {
						ValaProperty* _tmp111_;
						ValaSymbol* _tmp112_;
						ValaSymbol* _tmp113_;
						gchar* _tmp114_;
						gchar* _tmp115_;
						ValaProperty* _tmp116_;
						const gchar* _tmp117_;
						const gchar* _tmp118_;
						gchar* _tmp119_;
						gchar* _tmp120_;
						_tmp111_ = prop;
						_tmp112_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp111_);
						_tmp113_ = _tmp112_;
						_tmp114_ = vala_get_ccode_lower_case_prefix (_tmp113_);
						_tmp115_ = _tmp114_;
						_tmp116_ = prop;
						_tmp117_ = vala_symbol_get_name ((ValaSymbol*) _tmp116_);
						_tmp118_ = _tmp117_;
						_tmp119_ = g_strdup_printf ("%sreal_set_%s", _tmp115_, _tmp118_);
						_tmp120_ = _tmp119_;
						_g_free0 (_tmp115_);
						result = _tmp120_;
						_vala_code_node_unref0 (prop);
						_vala_code_node_unref0 (acc);
						return result;
					}
				} else {
					const gchar* _tmp121_;
					const gchar* _tmp122_;
					gchar* _tmp123_;
					_tmp121_ = vala_ccode_attribute_get_name (self);
					_tmp122_ = _tmp121_;
					_tmp123_ = g_strdup (_tmp122_);
					result = _tmp123_;
					_vala_code_node_unref0 (prop);
					_vala_code_node_unref0 (acc);
					return result;
				}
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (acc);
			}
		}
	}
	g_assert_not_reached ();
}


static gchar*
vala_ccode_attribute_get_default_const_name (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_DATA_TYPE)) {
		ValaDataType* type = NULL;
		ValaCodeNode* _tmp1_;
		ValaDataType* _tmp2_;
		gchar* ptr = NULL;
		ValaTypeSymbol* t = NULL;
		ValaDataType* _tmp3_;
		ValaTypeSymbol* _tmp14_;
		ValaTypeSymbol* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp1_ = self->priv->node;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_DATA_TYPE, ValaDataType));
		type = _tmp2_;
		_tmp3_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_ARRAY_TYPE)) {
			ValaDataType* _tmp4_;
			ValaDataType* _tmp5_;
			ValaDataType* _tmp6_;
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			_tmp4_ = type;
			_tmp5_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_data_type_get_data_type (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _vala_code_node_ref0 (_tmp8_);
			_vala_code_node_unref0 (t);
			t = _tmp9_;
		} else {
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			_tmp10_ = type;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _vala_code_node_ref0 (_tmp12_);
			_vala_code_node_unref0 (t);
			t = _tmp13_;
		}
		_tmp14_ = t;
		if (!vala_typesymbol_is_reference_type (_tmp14_)) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			_g_free0 (ptr);
			ptr = _tmp15_;
		} else {
			gchar* _tmp16_;
			_tmp16_ = g_strdup ("*");
			_g_free0 (ptr);
			ptr = _tmp16_;
		}
		_tmp17_ = t;
		_tmp18_ = vala_get_ccode_name ((ValaCodeNode*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = ptr;
		_tmp21_ = g_strdup_printf ("const %s%s", _tmp19_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp19_);
		result = _tmp22_;
		_vala_code_node_unref0 (t);
		_g_free0 (ptr);
		_vala_code_node_unref0 (type);
		return result;
	} else {
		gboolean _tmp23_ = FALSE;
		ValaCodeNode* _tmp24_;
		_tmp24_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_CLASS)) {
			ValaCodeNode* _tmp25_;
			gboolean _tmp26_;
			gboolean _tmp27_;
			_tmp25_ = self->priv->node;
			_tmp26_ = vala_class_get_is_immutable (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_CLASS, ValaClass));
			_tmp27_ = _tmp26_;
			_tmp23_ = _tmp27_;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp28_ = vala_ccode_attribute_get_name (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf ("const %s", _tmp29_);
			result = _tmp30_;
			return result;
		} else {
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp31_ = vala_ccode_attribute_get_name (self);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strdup (_tmp32_);
			result = _tmp33_;
			return result;
		}
	}
}


static gboolean
vala_ccode_attribute_get_default_array_length (ValaCCodeAttribute* self)
{
	gboolean result = FALSE;
	ValaCodeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_PARAMETER)) {
		ValaParameter* param = NULL;
		ValaCodeNode* _tmp1_;
		ValaParameter* _tmp2_;
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaParameter* _tmp5_;
		_tmp1_ = self->priv->node;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_PARAMETER, ValaParameter));
		param = _tmp2_;
		_tmp3_ = param;
		_tmp4_ = vala_parameter_get_base_parameter (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			ValaParameter* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			_tmp6_ = param;
			_tmp7_ = vala_parameter_get_base_parameter (_tmp6_);
			_tmp8_ = _tmp7_;
			result = vala_get_ccode_array_length ((ValaCodeNode*) _tmp8_);
			_vala_code_node_unref0 (param);
			return result;
		}
		_vala_code_node_unref0 (param);
	} else {
		ValaCodeNode* _tmp9_;
		_tmp9_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_METHOD)) {
			ValaMethod* method = NULL;
			ValaCodeNode* _tmp10_;
			ValaMethod* _tmp11_;
			gboolean _tmp12_ = FALSE;
			ValaMethod* _tmp13_;
			ValaMethod* _tmp14_;
			ValaMethod* _tmp15_;
			_tmp10_ = self->priv->node;
			_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp11_;
			_tmp13_ = method;
			_tmp14_ = vala_method_get_base_method (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ != NULL) {
				ValaMethod* _tmp16_;
				ValaMethod* _tmp17_;
				ValaMethod* _tmp18_;
				ValaMethod* _tmp19_;
				_tmp16_ = method;
				_tmp17_ = vala_method_get_base_method (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = method;
				_tmp12_ = _tmp18_ != _tmp19_;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				ValaMethod* _tmp20_;
				ValaMethod* _tmp21_;
				ValaMethod* _tmp22_;
				_tmp20_ = method;
				_tmp21_ = vala_method_get_base_method (_tmp20_);
				_tmp22_ = _tmp21_;
				result = vala_get_ccode_array_length ((ValaCodeNode*) _tmp22_);
				_vala_code_node_unref0 (method);
				return result;
			} else {
				gboolean _tmp23_ = FALSE;
				ValaMethod* _tmp24_;
				ValaMethod* _tmp25_;
				ValaMethod* _tmp26_;
				_tmp24_ = method;
				_tmp25_ = vala_method_get_base_interface_method (_tmp24_);
				_tmp26_ = _tmp25_;
				if (_tmp26_ != NULL) {
					ValaMethod* _tmp27_;
					ValaMethod* _tmp28_;
					ValaMethod* _tmp29_;
					ValaMethod* _tmp30_;
					_tmp27_ = method;
					_tmp28_ = vala_method_get_base_interface_method (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = method;
					_tmp23_ = _tmp29_ != _tmp30_;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					ValaMethod* _tmp31_;
					ValaMethod* _tmp32_;
					ValaMethod* _tmp33_;
					_tmp31_ = method;
					_tmp32_ = vala_method_get_base_interface_method (_tmp31_);
					_tmp33_ = _tmp32_;
					result = vala_get_ccode_array_length ((ValaCodeNode*) _tmp33_);
					_vala_code_node_unref0 (method);
					return result;
				}
			}
			_vala_code_node_unref0 (method);
		}
	}
	result = TRUE;
	return result;
}


static gboolean
vala_ccode_attribute_get_default_array_null_terminated (ValaCCodeAttribute* self)
{
	gboolean result = FALSE;
	ValaCodeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_PARAMETER)) {
		ValaParameter* param = NULL;
		ValaCodeNode* _tmp1_;
		ValaParameter* _tmp2_;
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaParameter* _tmp5_;
		_tmp1_ = self->priv->node;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_PARAMETER, ValaParameter));
		param = _tmp2_;
		_tmp3_ = param;
		_tmp4_ = vala_parameter_get_base_parameter (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			ValaParameter* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			_tmp6_ = param;
			_tmp7_ = vala_parameter_get_base_parameter (_tmp6_);
			_tmp8_ = _tmp7_;
			result = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp8_);
			_vala_code_node_unref0 (param);
			return result;
		}
		_vala_code_node_unref0 (param);
	} else {
		ValaCodeNode* _tmp9_;
		_tmp9_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_METHOD)) {
			ValaMethod* method = NULL;
			ValaCodeNode* _tmp10_;
			ValaMethod* _tmp11_;
			gboolean _tmp12_ = FALSE;
			ValaMethod* _tmp13_;
			ValaMethod* _tmp14_;
			ValaMethod* _tmp15_;
			_tmp10_ = self->priv->node;
			_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp11_;
			_tmp13_ = method;
			_tmp14_ = vala_method_get_base_method (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ != NULL) {
				ValaMethod* _tmp16_;
				ValaMethod* _tmp17_;
				ValaMethod* _tmp18_;
				ValaMethod* _tmp19_;
				_tmp16_ = method;
				_tmp17_ = vala_method_get_base_method (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = method;
				_tmp12_ = _tmp18_ != _tmp19_;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				ValaMethod* _tmp20_;
				ValaMethod* _tmp21_;
				ValaMethod* _tmp22_;
				_tmp20_ = method;
				_tmp21_ = vala_method_get_base_method (_tmp20_);
				_tmp22_ = _tmp21_;
				result = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp22_);
				_vala_code_node_unref0 (method);
				return result;
			} else {
				gboolean _tmp23_ = FALSE;
				ValaMethod* _tmp24_;
				ValaMethod* _tmp25_;
				ValaMethod* _tmp26_;
				_tmp24_ = method;
				_tmp25_ = vala_method_get_base_interface_method (_tmp24_);
				_tmp26_ = _tmp25_;
				if (_tmp26_ != NULL) {
					ValaMethod* _tmp27_;
					ValaMethod* _tmp28_;
					ValaMethod* _tmp29_;
					ValaMethod* _tmp30_;
					_tmp27_ = method;
					_tmp28_ = vala_method_get_base_interface_method (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = method;
					_tmp23_ = _tmp29_ != _tmp30_;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					ValaMethod* _tmp31_;
					ValaMethod* _tmp32_;
					ValaMethod* _tmp33_;
					_tmp31_ = method;
					_tmp32_ = vala_method_get_base_interface_method (_tmp31_);
					_tmp33_ = _tmp32_;
					result = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp33_);
					_vala_code_node_unref0 (method);
					return result;
				}
			}
			_vala_code_node_unref0 (method);
		}
	}
	result = FALSE;
	return result;
}


const gchar*
vala_ccode_attribute_get_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "cname", NULL);
			_g_free0 (self->priv->_name);
			self->priv->_name = _tmp3_;
		}
		_tmp4_ = self->priv->_name;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_name (self);
			_g_free0 (self->priv->_name);
			self->priv->_name = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_name;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_const_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_const_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "const_cname", NULL);
			_g_free0 (self->priv->_const_name);
			self->priv->_const_name = _tmp3_;
		}
		_tmp4_ = self->priv->_const_name;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_const_name (self);
			_g_free0 (self->priv->_const_name);
			self->priv->_const_name = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_const_name;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_type_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_type_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "type_cname", NULL);
			_g_free0 (self->priv->_type_name);
			self->priv->_type_name = _tmp3_;
		}
		_tmp4_ = self->priv->_type_name;
		if (_tmp4_ == NULL) {
			ValaSymbol* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp5_ = self->priv->sym;
			_tmp6_ = vala_get_ccode_name ((ValaCodeNode*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strdup_printf ("%sIface", _tmp7_);
			_g_free0 (self->priv->_type_name);
			self->priv->_type_name = _tmp8_;
			_g_free0 (_tmp7_);
		}
	}
	_tmp9_ = self->priv->_type_name;
	result = _tmp9_;
	return result;
}


const gchar*
vala_ccode_attribute_get_feature_test_macros (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_feature_test_macros;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "feature_test_macro", NULL);
			_g_free0 (self->priv->_feature_test_macros);
			self->priv->_feature_test_macros = _tmp3_;
		}
		_tmp4_ = self->priv->_feature_test_macros;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("");
			_g_free0 (self->priv->_feature_test_macros);
			self->priv->_feature_test_macros = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_feature_test_macros;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_header_filenames (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_header_filenames;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "cheader_filename", NULL);
			_g_free0 (self->priv->_header_filenames);
			self->priv->_header_filenames = _tmp3_;
		}
		_tmp4_ = self->priv->_header_filenames;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_header_filenames (self);
			_g_free0 (self->priv->_header_filenames);
			self->priv->_header_filenames = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_header_filenames;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_prefix (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_prefix;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "cprefix", NULL);
			_g_free0 (self->priv->_prefix);
			self->priv->_prefix = _tmp3_;
		}
		_tmp4_ = self->priv->_prefix;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_prefix (self);
			_g_free0 (self->priv->_prefix);
			self->priv->_prefix = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_prefix;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_lower_case_prefix (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lower_case_prefix;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp11_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			gboolean _tmp4_ = FALSE;
			const gchar* _tmp5_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "lower_case_cprefix", NULL);
			_g_free0 (self->priv->_lower_case_prefix);
			self->priv->_lower_case_prefix = _tmp3_;
			_tmp5_ = self->priv->_lower_case_prefix;
			if (_tmp5_ == NULL) {
				gboolean _tmp6_ = FALSE;
				ValaSymbol* _tmp7_;
				_tmp7_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
					_tmp6_ = TRUE;
				} else {
					ValaSymbol* _tmp8_;
					_tmp8_ = self->priv->sym;
					_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_STRUCT);
				}
				_tmp4_ = _tmp6_;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				ValaAttribute* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = self->priv->ccode;
				_tmp10_ = vala_attribute_get_string (_tmp9_, "cprefix", NULL);
				_g_free0 (self->priv->_lower_case_prefix);
				self->priv->_lower_case_prefix = _tmp10_;
			}
		}
		_tmp11_ = self->priv->_lower_case_prefix;
		if (_tmp11_ == NULL) {
			gchar* _tmp12_;
			_tmp12_ = vala_ccode_attribute_get_default_lower_case_prefix (self);
			_g_free0 (self->priv->_lower_case_prefix);
			self->priv->_lower_case_prefix = _tmp12_;
		}
	}
	_tmp13_ = self->priv->_lower_case_prefix;
	result = _tmp13_;
	return result;
}


const gchar*
vala_ccode_attribute_get_lower_case_suffix (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lower_case_suffix;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "lower_case_csuffix", NULL);
			_g_free0 (self->priv->_lower_case_suffix);
			self->priv->_lower_case_suffix = _tmp3_;
		}
		_tmp4_ = self->priv->_lower_case_suffix;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_lower_case_suffix (self);
			_g_free0 (self->priv->_lower_case_suffix);
			self->priv->_lower_case_suffix = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_lower_case_suffix;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_ref_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->ref_function_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "ref_function", NULL);
			_g_free0 (self->priv->_ref_function);
			self->priv->_ref_function = _tmp3_;
		}
		_tmp4_ = self->priv->_ref_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_ref_function (self);
			_g_free0 (self->priv->_ref_function);
			self->priv->_ref_function = _tmp5_;
		}
		self->priv->ref_function_set = TRUE;
	}
	_tmp6_ = self->priv->_ref_function;
	result = _tmp6_;
	return result;
}


static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}


gboolean
vala_ccode_attribute_get_ref_function_void (ValaCCodeAttribute* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_ref_function_void;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaAttribute* _tmp2_;
		_tmp2_ = self->priv->ccode;
		if (_tmp2_ != NULL) {
			ValaAttribute* _tmp3_;
			_tmp3_ = self->priv->ccode;
			_tmp1_ = vala_attribute_has_argument (_tmp3_, "ref_function_void");
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaAttribute* _tmp4_;
			gboolean _tmp5_;
			gboolean* _tmp6_;
			_tmp4_ = self->priv->ccode;
			_tmp5_ = vala_attribute_get_bool (_tmp4_, "ref_function_void", FALSE);
			_tmp6_ = __bool_dup0 (&_tmp5_);
			_g_free0 (self->priv->_ref_function_void);
			self->priv->_ref_function_void = _tmp6_;
		} else {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp7_;
			ValaClass* _tmp8_;
			ValaClass* _tmp9_;
			ValaClass* _tmp10_;
			ValaClass* _tmp11_;
			_tmp7_ = self->priv->sym;
			_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp8_;
			_tmp9_ = cl;
			_tmp10_ = vala_class_get_base_class (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaClass* _tmp12_;
				ValaClass* _tmp13_;
				ValaClass* _tmp14_;
				gboolean _tmp15_;
				gboolean* _tmp16_;
				_tmp12_ = cl;
				_tmp13_ = vala_class_get_base_class (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = vala_get_ccode_ref_function_void (_tmp14_);
				_tmp16_ = __bool_dup0 (&_tmp15_);
				_g_free0 (self->priv->_ref_function_void);
				self->priv->_ref_function_void = _tmp16_;
			} else {
				gboolean _tmp17_;
				gboolean* _tmp18_;
				_tmp17_ = FALSE;
				_tmp18_ = __bool_dup0 (&_tmp17_);
				_g_free0 (self->priv->_ref_function_void);
				self->priv->_ref_function_void = _tmp18_;
			}
			_vala_code_node_unref0 (cl);
		}
	}
	_tmp19_ = self->priv->_ref_function_void;
	result = *_tmp19_;
	return result;
}


const gchar*
vala_ccode_attribute_get_unref_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->unref_function_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "unref_function", NULL);
			_g_free0 (self->priv->_unref_function);
			self->priv->_unref_function = _tmp3_;
		}
		_tmp4_ = self->priv->_unref_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_unref_function (self);
			_g_free0 (self->priv->_unref_function);
			self->priv->_unref_function = _tmp5_;
		}
		self->priv->unref_function_set = TRUE;
	}
	_tmp6_ = self->priv->_unref_function;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_ref_sink_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ref_sink_function;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "ref_sink_function", NULL);
			_g_free0 (self->priv->_ref_sink_function);
			self->priv->_ref_sink_function = _tmp3_;
		}
		_tmp4_ = self->priv->_ref_sink_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_ref_sink_function (self);
			_g_free0 (self->priv->_ref_sink_function);
			self->priv->_ref_sink_function = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_ref_sink_function;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_copy_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->copy_function_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "copy_function", NULL);
			_g_free0 (self->priv->_copy_function);
			self->priv->_copy_function = _tmp3_;
		}
		_tmp5_ = self->priv->_copy_function;
		if (_tmp5_ == NULL) {
			ValaSymbol* _tmp6_;
			_tmp6_ = self->priv->sym;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_STRUCT);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = vala_ccode_attribute_get_lower_case_prefix (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup_printf ("%scopy", _tmp8_);
			_g_free0 (self->priv->_copy_function);
			self->priv->_copy_function = _tmp9_;
		}
		self->priv->copy_function_set = TRUE;
	}
	_tmp10_ = self->priv->_copy_function;
	result = _tmp10_;
	return result;
}


const gchar*
vala_ccode_attribute_get_destroy_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->destroy_function_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "destroy_function", NULL);
			_g_free0 (self->priv->_destroy_function);
			self->priv->_destroy_function = _tmp3_;
		}
		_tmp5_ = self->priv->_destroy_function;
		if (_tmp5_ == NULL) {
			ValaSymbol* _tmp6_;
			_tmp6_ = self->priv->sym;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_STRUCT);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = vala_ccode_attribute_get_lower_case_prefix (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup_printf ("%sdestroy", _tmp8_);
			_g_free0 (self->priv->_destroy_function);
			self->priv->_destroy_function = _tmp9_;
		}
		self->priv->destroy_function_set = TRUE;
	}
	_tmp10_ = self->priv->_destroy_function;
	result = _tmp10_;
	return result;
}


const gchar*
vala_ccode_attribute_get_dup_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dup_function_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "dup_function", NULL);
			_g_free0 (self->priv->_dup_function);
			self->priv->_dup_function = _tmp3_;
		}
		_tmp6_ = self->priv->_dup_function;
		if (_tmp6_ == NULL) {
			ValaSymbol* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp7_ = self->priv->sym;
			_tmp8_ = vala_symbol_get_external_package (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp5_ = !_tmp9_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaSymbol* _tmp10_;
			_tmp10_ = self->priv->sym;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_STRUCT);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp11_ = vala_ccode_attribute_get_lower_case_prefix (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup_printf ("%sdup", _tmp12_);
			_g_free0 (self->priv->_dup_function);
			self->priv->_dup_function = _tmp13_;
		}
		self->priv->dup_function_set = TRUE;
	}
	_tmp14_ = self->priv->_dup_function;
	result = _tmp14_;
	return result;
}


const gchar*
vala_ccode_attribute_get_free_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->free_function_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "free_function", NULL);
			_g_free0 (self->priv->_free_function);
			self->priv->_free_function = _tmp3_;
		}
		_tmp4_ = self->priv->_free_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_free_function (self);
			_g_free0 (self->priv->_free_function);
			self->priv->_free_function = _tmp5_;
		}
		self->priv->free_function_set = TRUE;
	}
	_tmp6_ = self->priv->_free_function;
	result = _tmp6_;
	return result;
}


gboolean
vala_ccode_attribute_get_free_function_address_of (ValaCCodeAttribute* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_free_function_address_of;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaAttribute* _tmp2_;
		_tmp2_ = self->priv->ccode;
		if (_tmp2_ != NULL) {
			ValaAttribute* _tmp3_;
			_tmp3_ = self->priv->ccode;
			_tmp1_ = vala_attribute_has_argument (_tmp3_, "free_function_address_of");
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaAttribute* _tmp4_;
			gboolean _tmp5_;
			gboolean* _tmp6_;
			_tmp4_ = self->priv->ccode;
			_tmp5_ = vala_attribute_get_bool (_tmp4_, "free_function_address_of", FALSE);
			_tmp6_ = __bool_dup0 (&_tmp5_);
			_g_free0 (self->priv->_free_function_address_of);
			self->priv->_free_function_address_of = _tmp6_;
		} else {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp7_;
			ValaClass* _tmp8_;
			ValaClass* _tmp9_;
			ValaClass* _tmp10_;
			ValaClass* _tmp11_;
			_tmp7_ = self->priv->sym;
			_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp8_;
			_tmp9_ = cl;
			_tmp10_ = vala_class_get_base_class (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaClass* _tmp12_;
				ValaClass* _tmp13_;
				ValaClass* _tmp14_;
				gboolean _tmp15_;
				gboolean* _tmp16_;
				_tmp12_ = cl;
				_tmp13_ = vala_class_get_base_class (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = vala_get_ccode_free_function_address_of (_tmp14_);
				_tmp16_ = __bool_dup0 (&_tmp15_);
				_g_free0 (self->priv->_free_function_address_of);
				self->priv->_free_function_address_of = _tmp16_;
			} else {
				gboolean _tmp17_;
				gboolean* _tmp18_;
				_tmp17_ = FALSE;
				_tmp18_ = __bool_dup0 (&_tmp17_);
				_g_free0 (self->priv->_free_function_address_of);
				self->priv->_free_function_address_of = _tmp18_;
			}
			_vala_code_node_unref0 (cl);
		}
	}
	_tmp19_ = self->priv->_free_function_address_of;
	result = *_tmp19_;
	return result;
}


const gchar*
vala_ccode_attribute_get_ctype (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->ctype_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "type", NULL);
			_g_free0 (self->priv->_ctype);
			self->priv->_ctype = _tmp3_;
			_tmp4_ = self->priv->_ctype;
			if (_tmp4_ == NULL) {
				ValaAttribute* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = self->priv->ccode;
				_tmp6_ = vala_attribute_get_string (_tmp5_, "ctype", NULL);
				_g_free0 (self->priv->_ctype);
				self->priv->_ctype = _tmp6_;
			}
		}
		self->priv->ctype_set = TRUE;
	}
	_tmp7_ = self->priv->_ctype;
	result = _tmp7_;
	return result;
}


const gchar*
vala_ccode_attribute_get_type_id (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_type_id;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "type_id", NULL);
			_g_free0 (self->priv->_type_id);
			self->priv->_type_id = _tmp3_;
		}
		_tmp4_ = self->priv->_type_id;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_type_id (self);
			_g_free0 (self->priv->_type_id);
			self->priv->_type_id = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_type_id;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_marshaller_type_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_marshaller_type_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "marshaller_type_name", NULL);
			_g_free0 (self->priv->_marshaller_type_name);
			self->priv->_marshaller_type_name = _tmp3_;
		}
		_tmp4_ = self->priv->_marshaller_type_name;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_marshaller_type_name (self);
			_g_free0 (self->priv->_marshaller_type_name);
			self->priv->_marshaller_type_name = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_marshaller_type_name;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_get_value_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_get_value_function;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "get_value_function", NULL);
			_g_free0 (self->priv->_get_value_function);
			self->priv->_get_value_function = _tmp3_;
		}
		_tmp4_ = self->priv->_get_value_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_get_value_function (self);
			_g_free0 (self->priv->_get_value_function);
			self->priv->_get_value_function = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_get_value_function;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_set_value_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_value_function;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "set_value_function", NULL);
			_g_free0 (self->priv->_set_value_function);
			self->priv->_set_value_function = _tmp3_;
		}
		_tmp4_ = self->priv->_set_value_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_set_value_function (self);
			_g_free0 (self->priv->_set_value_function);
			self->priv->_set_value_function = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_set_value_function;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_take_value_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_take_value_function;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "take_value_function", NULL);
			_g_free0 (self->priv->_take_value_function);
			self->priv->_take_value_function = _tmp3_;
		}
		_tmp4_ = self->priv->_take_value_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_take_value_function (self);
			_g_free0 (self->priv->_take_value_function);
			self->priv->_take_value_function = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_take_value_function;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_param_spec_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_param_spec_function;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "param_spec_function", NULL);
			_g_free0 (self->priv->_param_spec_function);
			self->priv->_param_spec_function = _tmp3_;
		}
		_tmp4_ = self->priv->_param_spec_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_param_spec_function (self);
			_g_free0 (self->priv->_param_spec_function);
			self->priv->_param_spec_function = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_param_spec_function;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_default_value (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_value;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "default_value", NULL);
			_g_free0 (self->priv->_default_value);
			self->priv->_default_value = _tmp3_;
		}
		_tmp4_ = self->priv->_default_value;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_default_value (self);
			_g_free0 (self->priv->_default_value);
			self->priv->_default_value = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_default_value;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_default_value_on_error (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_value_on_error;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "default_value_on_error", NULL);
			_g_free0 (self->priv->_default_value_on_error);
			self->priv->_default_value_on_error = _tmp3_;
		}
		_tmp4_ = self->priv->_default_value_on_error;
		if (_tmp4_ == NULL) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = vala_ccode_attribute_get_default_value (self);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (self->priv->_default_value_on_error);
			self->priv->_default_value_on_error = _tmp7_;
		}
	}
	_tmp8_ = self->priv->_default_value_on_error;
	result = _tmp8_;
	return result;
}


gdouble
vala_ccode_attribute_get_pos (ValaCCodeAttribute* self)
{
	gdouble result;
	gdouble* _tmp0_;
	gdouble* _tmp22_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_pos;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaAttribute* _tmp2_;
		_tmp2_ = self->priv->ccode;
		if (_tmp2_ != NULL) {
			ValaAttribute* _tmp3_;
			_tmp3_ = self->priv->ccode;
			_tmp1_ = vala_attribute_has_argument (_tmp3_, "pos");
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaAttribute* _tmp4_;
			gdouble _tmp5_;
			gdouble* _tmp6_;
			_tmp4_ = self->priv->ccode;
			_tmp5_ = vala_attribute_get_double (_tmp4_, "pos", (gdouble) 0);
			_tmp6_ = __double_dup0 (&_tmp5_);
			_g_free0 (self->priv->_pos);
			self->priv->_pos = _tmp6_;
		} else {
			ValaParameter* param = NULL;
			ValaCodeNode* _tmp7_;
			ValaParameter* _tmp8_;
			ValaSymbol* sym = NULL;
			ValaParameter* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSymbol* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp7_ = self->priv->node;
			_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp8_;
			_tmp9_ = param;
			_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (_tmp11_);
			sym = _tmp12_;
			_tmp13_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_CALLABLE)) {
				ValaSymbol* _tmp14_;
				ValaList* _tmp15_;
				ValaList* _tmp16_;
				ValaParameter* _tmp17_;
				gdouble _tmp18_;
				gdouble* _tmp19_;
				_tmp14_ = sym;
				_tmp15_ = vala_callable_get_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_CALLABLE, ValaCallable));
				_tmp16_ = _tmp15_;
				_tmp17_ = param;
				_tmp18_ = vala_list_index_of (_tmp16_, _tmp17_) + 1.0;
				_tmp19_ = __double_dup0 (&_tmp18_);
				_g_free0 (self->priv->_pos);
				self->priv->_pos = _tmp19_;
				_vala_iterable_unref0 (_tmp16_);
			} else {
				gdouble _tmp20_;
				gdouble* _tmp21_;
				_tmp20_ = 0.0;
				_tmp21_ = __double_dup0 (&_tmp20_);
				_g_free0 (self->priv->_pos);
				self->priv->_pos = _tmp21_;
			}
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (param);
		}
	}
	_tmp22_ = self->priv->_pos;
	result = *_tmp22_;
	return result;
}


const gchar*
vala_ccode_attribute_get_real_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_real_name;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaAttribute* _tmp2_;
		const gchar* _tmp6_;
		_tmp2_ = self->priv->ccode;
		if (_tmp2_ != NULL) {
			ValaSymbol* _tmp3_;
			_tmp3_ = self->priv->sym;
			_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaAttribute* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = self->priv->ccode;
			_tmp5_ = vala_attribute_get_string (_tmp4_, "construct_function", NULL);
			_g_free0 (self->priv->_real_name);
			self->priv->_real_name = _tmp5_;
		}
		_tmp6_ = self->priv->_real_name;
		if (_tmp6_ == NULL) {
			gchar* _tmp7_;
			_tmp7_ = vala_ccode_attribute_get_default_real_name (self);
			_g_free0 (self->priv->_real_name);
			self->priv->_real_name = _tmp7_;
		}
	}
	_tmp8_ = self->priv->_real_name;
	result = _tmp8_;
	return result;
}


const gchar*
vala_ccode_attribute_get_vfunc_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_vfunc_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "vfunc_name", NULL);
			_g_free0 (self->priv->_vfunc_name);
			self->priv->_vfunc_name = _tmp3_;
		}
		_tmp4_ = self->priv->_vfunc_name;
		if (_tmp4_ == NULL) {
			ValaMethod* m = NULL;
			ValaCodeNode* _tmp5_;
			ValaMethod* _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaMethod* _tmp8_;
			_tmp5_ = self->priv->node;
			_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp5_) : NULL);
			m = _tmp6_;
			_tmp8_ = m;
			if (_tmp8_ != NULL) {
				ValaMethod* _tmp9_;
				ValaSignal* _tmp10_;
				ValaSignal* _tmp11_;
				_tmp9_ = m;
				_tmp10_ = vala_method_get_signal_reference (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp7_ = _tmp11_ != NULL;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				ValaMethod* _tmp12_;
				ValaSignal* _tmp13_;
				ValaSignal* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = m;
				_tmp13_ = vala_method_get_signal_reference (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp14_, NULL);
				_g_free0 (self->priv->_vfunc_name);
				self->priv->_vfunc_name = _tmp15_;
			} else {
				ValaSymbol* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp16_ = self->priv->sym;
				_tmp17_ = vala_symbol_get_name (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strdup (_tmp18_);
				_g_free0 (self->priv->_vfunc_name);
				self->priv->_vfunc_name = _tmp19_;
			}
			_vala_code_node_unref0 (m);
		}
	}
	_tmp20_ = self->priv->_vfunc_name;
	result = _tmp20_;
	return result;
}


const gchar*
vala_ccode_attribute_get_finish_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_finish_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp7_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "finish_name", NULL);
			_g_free0 (self->priv->_finish_name);
			self->priv->_finish_name = _tmp3_;
			_tmp4_ = self->priv->_finish_name;
			if (_tmp4_ == NULL) {
				ValaAttribute* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = self->priv->ccode;
				_tmp6_ = vala_attribute_get_string (_tmp5_, "finish_function", NULL);
				_g_free0 (self->priv->_finish_name);
				self->priv->_finish_name = _tmp6_;
			}
		}
		_tmp7_ = self->priv->_finish_name;
		if (_tmp7_ == NULL) {
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = vala_ccode_attribute_get_name (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_ccode_attribute_get_finish_name_for_basename (self, _tmp9_);
			_g_free0 (self->priv->_finish_name);
			self->priv->_finish_name = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_finish_name;
	result = _tmp11_;
	return result;
}


const gchar*
vala_ccode_attribute_get_finish_vfunc_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_finish_vfunc_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "finish_vfunc_name", NULL);
			_g_free0 (self->priv->_finish_vfunc_name);
			self->priv->_finish_vfunc_name = _tmp3_;
		}
		_tmp4_ = self->priv->_finish_vfunc_name;
		if (_tmp4_ == NULL) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = vala_ccode_attribute_get_vfunc_name (self);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_ccode_attribute_get_finish_name_for_basename (self, _tmp6_);
			_g_free0 (self->priv->_finish_vfunc_name);
			self->priv->_finish_vfunc_name = _tmp7_;
		}
	}
	_tmp8_ = self->priv->_finish_vfunc_name;
	result = _tmp8_;
	return result;
}


const gchar*
vala_ccode_attribute_get_finish_real_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_finish_real_name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = vala_ccode_attribute_get_real_name (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_ccode_attribute_get_finish_name_for_basename (self, _tmp2_);
		_g_free0 (self->priv->_finish_real_name);
		self->priv->_finish_real_name = _tmp3_;
	}
	_tmp4_ = self->priv->_finish_real_name;
	result = _tmp4_;
	return result;
}


gboolean
vala_ccode_attribute_get_finish_instance (ValaCCodeAttribute* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp22_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_finish_instance;
	if (_tmp0_ == NULL) {
		ValaMethod* m = NULL;
		ValaCodeNode* _tmp1_;
		ValaMethod* _tmp2_;
		gboolean is_creation_method = FALSE;
		ValaMethod* _tmp3_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaAttribute* _tmp7_;
		_tmp1_ = self->priv->node;
		_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1_) : NULL);
		m = _tmp2_;
		_tmp3_ = m;
		is_creation_method = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_CREATION_METHOD);
		_tmp7_ = self->priv->ccode;
		if (_tmp7_ == NULL) {
			_tmp6_ = TRUE;
		} else {
			ValaMethod* _tmp8_;
			_tmp8_ = m;
			_tmp6_ = _tmp8_ == NULL;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			ValaMethod* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp9_ = m;
			_tmp10_ = vala_method_get_is_abstract (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp5_ = _tmp11_;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			ValaMethod* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp12_ = m;
			_tmp13_ = vala_method_get_is_virtual (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp4_ = _tmp14_;
		}
		if (_tmp4_) {
			gboolean _tmp15_;
			gboolean _tmp16_;
			gboolean* _tmp17_;
			_tmp15_ = is_creation_method;
			_tmp16_ = !_tmp15_;
			_tmp17_ = __bool_dup0 (&_tmp16_);
			_g_free0 (self->priv->_finish_instance);
			self->priv->_finish_instance = _tmp17_;
		} else {
			ValaAttribute* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			gboolean* _tmp21_;
			_tmp18_ = self->priv->ccode;
			_tmp19_ = is_creation_method;
			_tmp20_ = vala_attribute_get_bool (_tmp18_, "finish_instance", !_tmp19_);
			_tmp21_ = __bool_dup0 (&_tmp20_);
			_g_free0 (self->priv->_finish_instance);
			self->priv->_finish_instance = _tmp21_;
		}
		_vala_code_node_unref0 (m);
	}
	_tmp22_ = self->priv->_finish_instance;
	result = *_tmp22_;
	return result;
}


const gchar*
vala_ccode_attribute_get_delegate_target_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_delegate_target_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "delegate_target_cname", NULL);
			_g_free0 (self->priv->_delegate_target_name);
			self->priv->_delegate_target_name = _tmp3_;
		}
		_tmp4_ = self->priv->_delegate_target_name;
		if (_tmp4_ == NULL) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = vala_ccode_attribute_get_name (self);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strdup_printf ("%s_target", _tmp6_);
			_g_free0 (self->priv->_delegate_target_name);
			self->priv->_delegate_target_name = _tmp7_;
		}
	}
	_tmp8_ = self->priv->_delegate_target_name;
	result = _tmp8_;
	return result;
}


gboolean
vala_ccode_attribute_get_array_length (ValaCCodeAttribute* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp18_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_array_length;
	if (_tmp0_ == NULL) {
		ValaCodeNode* _tmp1_;
		ValaAttribute* _tmp2_;
		ValaAttribute* _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = self->priv->node;
		_tmp2_ = vala_code_node_get_attribute (_tmp1_, "NoArrayLength");
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_ != NULL;
		_vala_code_node_unref0 (_tmp3_);
		if (_tmp4_) {
			ValaCodeNode* _tmp5_;
			ValaSourceReference* _tmp6_;
			ValaSourceReference* _tmp7_;
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp5_ = self->priv->node;
			_tmp6_ = vala_code_node_get_source_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			vala_report_deprecated (_tmp7_, "[NoArrayLength] is deprecated, use [CCode (array_length = false)] inst" \
"ead.");
			_tmp8_ = FALSE;
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_array_length);
			self->priv->_array_length = _tmp9_;
		} else {
			gboolean _tmp10_ = FALSE;
			ValaAttribute* _tmp11_;
			_tmp11_ = self->priv->ccode;
			if (_tmp11_ != NULL) {
				ValaAttribute* _tmp12_;
				_tmp12_ = self->priv->ccode;
				_tmp10_ = vala_attribute_has_argument (_tmp12_, "array_length");
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValaAttribute* _tmp13_;
				gboolean _tmp14_;
				gboolean* _tmp15_;
				_tmp13_ = self->priv->ccode;
				_tmp14_ = vala_attribute_get_bool (_tmp13_, "array_length", FALSE);
				_tmp15_ = __bool_dup0 (&_tmp14_);
				_g_free0 (self->priv->_array_length);
				self->priv->_array_length = _tmp15_;
			} else {
				gboolean _tmp16_;
				gboolean* _tmp17_;
				_tmp16_ = vala_ccode_attribute_get_default_array_length (self);
				_tmp17_ = __bool_dup0 (&_tmp16_);
				_g_free0 (self->priv->_array_length);
				self->priv->_array_length = _tmp17_;
			}
		}
	}
	_tmp18_ = self->priv->_array_length;
	result = *_tmp18_;
	return result;
}


gboolean
vala_ccode_attribute_get_array_null_terminated (ValaCCodeAttribute* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_array_null_terminated;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		ValaAttribute* _tmp3_;
		_tmp3_ = self->priv->ccode;
		if (_tmp3_ != NULL) {
			ValaAttribute* _tmp4_;
			_tmp4_ = self->priv->ccode;
			_tmp2_ = vala_attribute_has_argument (_tmp4_, "array_length");
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			ValaAttribute* _tmp5_;
			_tmp5_ = self->priv->ccode;
			_tmp1_ = vala_attribute_get_bool (_tmp5_, "array_length", FALSE);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp6_ = FALSE;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_array_null_terminated);
			self->priv->_array_null_terminated = _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			ValaAttribute* _tmp9_;
			_tmp9_ = self->priv->ccode;
			if (_tmp9_ != NULL) {
				ValaAttribute* _tmp10_;
				_tmp10_ = self->priv->ccode;
				_tmp8_ = vala_attribute_has_argument (_tmp10_, "array_null_terminated");
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				ValaAttribute* _tmp11_;
				gboolean _tmp12_;
				gboolean* _tmp13_;
				_tmp11_ = self->priv->ccode;
				_tmp12_ = vala_attribute_get_bool (_tmp11_, "array_null_terminated", FALSE);
				_tmp13_ = __bool_dup0 (&_tmp12_);
				_g_free0 (self->priv->_array_null_terminated);
				self->priv->_array_null_terminated = _tmp13_;
			} else {
				gboolean _tmp14_;
				gboolean* _tmp15_;
				_tmp14_ = vala_ccode_attribute_get_default_array_null_terminated (self);
				_tmp15_ = __bool_dup0 (&_tmp14_);
				_g_free0 (self->priv->_array_null_terminated);
				self->priv->_array_null_terminated = _tmp15_;
			}
		}
	}
	_tmp16_ = self->priv->_array_null_terminated;
	result = *_tmp16_;
	return result;
}


const gchar*
vala_ccode_attribute_get_array_length_type (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_array_length_type;
	result = _tmp0_;
	return result;
}


static void
vala_ccode_attribute_set_array_length_type (ValaCCodeAttribute* self,
                                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_array_length_type);
	self->priv->_array_length_type = _tmp0_;
}


const gchar*
vala_ccode_attribute_get_array_length_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_array_length_name;
	result = _tmp0_;
	return result;
}


static void
vala_ccode_attribute_set_array_length_name (ValaCCodeAttribute* self,
                                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_array_length_name);
	self->priv->_array_length_name = _tmp0_;
}


const gchar*
vala_ccode_attribute_get_array_length_expr (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_array_length_expr;
	result = _tmp0_;
	return result;
}


static void
vala_ccode_attribute_set_array_length_expr (ValaCCodeAttribute* self,
                                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_array_length_expr);
	self->priv->_array_length_expr = _tmp0_;
}


gboolean
vala_ccode_attribute_get_delegate_target (ValaCCodeAttribute* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_delegate_target;
	result = _tmp0_;
	return result;
}


static void
vala_ccode_attribute_set_delegate_target (ValaCCodeAttribute* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_delegate_target = value;
}


const gchar*
vala_ccode_attribute_get_sentinel (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sentinel;
	result = _tmp0_;
	return result;
}


static void
vala_ccode_attribute_set_sentinel (ValaCCodeAttribute* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_sentinel);
	self->priv->_sentinel = _tmp0_;
}


static void
vala_ccode_attribute_class_init (ValaCCodeAttributeClass * klass)
{
	vala_ccode_attribute_parent_class = g_type_class_peek_parent (klass);
	((ValaAttributeCacheClass *) klass)->finalize = vala_ccode_attribute_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeAttributePrivate));
}


static void
vala_ccode_attribute_instance_init (ValaCCodeAttribute * self)
{
	self->priv = VALA_CCODE_ATTRIBUTE_GET_PRIVATE (self);
	self->priv->ctype_set = FALSE;
}


static void
vala_ccode_attribute_finalize (ValaAttributeCache * obj)
{
	ValaCCodeAttribute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_ATTRIBUTE, ValaCCodeAttribute);
	_vala_code_node_unref0 (self->priv->ccode);
	_g_free0 (self->priv->_array_length_type);
	_g_free0 (self->priv->_array_length_name);
	_g_free0 (self->priv->_array_length_expr);
	_g_free0 (self->priv->_sentinel);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_const_name);
	_g_free0 (self->priv->_type_name);
	_g_free0 (self->priv->_feature_test_macros);
	_g_free0 (self->priv->_header_filenames);
	_g_free0 (self->priv->_prefix);
	_g_free0 (self->priv->_lower_case_prefix);
	_g_free0 (self->priv->_lower_case_suffix);
	_g_free0 (self->priv->_ref_function);
	_g_free0 (self->priv->_ref_function_void);
	_g_free0 (self->priv->_unref_function);
	_g_free0 (self->priv->_ref_sink_function);
	_g_free0 (self->priv->_copy_function);
	_g_free0 (self->priv->_destroy_function);
	_g_free0 (self->priv->_dup_function);
	_g_free0 (self->priv->_free_function);
	_g_free0 (self->priv->_free_function_address_of);
	_g_free0 (self->priv->_type_id);
	_g_free0 (self->priv->_marshaller_type_name);
	_g_free0 (self->priv->_get_value_function);
	_g_free0 (self->priv->_set_value_function);
	_g_free0 (self->priv->_take_value_function);
	_g_free0 (self->priv->_param_spec_function);
	_g_free0 (self->priv->_default_value);
	_g_free0 (self->priv->_default_value_on_error);
	_g_free0 (self->priv->_pos);
	_g_free0 (self->priv->_vfunc_name);
	_g_free0 (self->priv->_finish_name);
	_g_free0 (self->priv->_finish_vfunc_name);
	_g_free0 (self->priv->_finish_real_name);
	_g_free0 (self->priv->_finish_instance);
	_g_free0 (self->priv->_real_name);
	_g_free0 (self->priv->_delegate_target_name);
	_g_free0 (self->priv->_ctype);
	_g_free0 (self->priv->_array_length);
	_g_free0 (self->priv->_array_null_terminated);
	VALA_ATTRIBUTE_CACHE_CLASS (vala_ccode_attribute_parent_class)->finalize (obj);
}


/**
 * Cache for the CCode attribute
 */
GType
vala_ccode_attribute_get_type (void)
{
	static volatile gsize vala_ccode_attribute_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_attribute_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeAttributeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_attribute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeAttribute), 0, (GInstanceInitFunc) vala_ccode_attribute_instance_init, NULL };
		GType vala_ccode_attribute_type_id;
		vala_ccode_attribute_type_id = g_type_register_static (VALA_TYPE_ATTRIBUTE_CACHE, "ValaCCodeAttribute", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_attribute_type_id__volatile, vala_ccode_attribute_type_id);
	}
	return vala_ccode_attribute_type_id__volatile;
}



