/* girdocumentationimporter.c generated by valac, the Vala compiler
 * generated from girdocumentationimporter.vala, do not modify */

/* girdocumentationimporter.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 * Copyright (C) 2011       Luca Bruno
 * Copyright (C) 2011-2014  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Luca Bruno <lucabru@src.gnome.org>
 *  Florian Brosch <flo.brosch@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_0_PROPERTY,
	VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_FILE_EXTENSION_PROPERTY,
	VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_NUM_PROPERTIES
};
static GParamSpec* valadoc_importer_gir_documentation_importer_properties[VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_NUM_PROPERTIES];
#define _vala_markup_reader_unref0(var) ((var == NULL) ? NULL : (var = (vala_markup_reader_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_TYPE_IMPLICIT_PARAMETER_POS (valadoc_importer_gir_documentation_importer_implicit_parameter_pos_get_type ())
typedef struct _ValadocImporterGirDocumentationImporterImplicitParameterPos ValadocImporterGirDocumentationImporterImplicitParameterPos;
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _valadoc_api_source_comment_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_source_comment_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValadocImporterGirDocumentationImporterPrivate {
	ValaMarkupTokenType current_token;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaMarkupReader* reader;
	ValadocDocumentationParser* parser;
	ValadocApiSourceFile* file;
	gchar* parent_c_identifier;
};

struct _ValadocImporterGirDocumentationImporterImplicitParameterPos {
	gint parameter;
	gint position;
};


static gpointer valadoc_importer_gir_documentation_importer_parent_class = NULL;

#define VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_IMPORTER_TYPE_GIR_DOCUMENTATION_IMPORTER, ValadocImporterGirDocumentationImporterPrivate))
#define VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_GIR_VERSION "1.2"
static void valadoc_importer_gir_documentation_importer_real_process (ValadocImporterDocumentationImporter* base,
                                                               const gchar* source_file);
static void valadoc_importer_gir_documentation_importer_next (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_repository (ValadocImporterGirDocumentationImporter* self);
static ValadocApiFormalParameter* valadoc_importer_gir_documentation_importer_find_parameter (ValadocImporterGirDocumentationImporter* self,
                                                                                       ValadocApiNode* node,
                                                                                       const gchar* name);
static inline gchar* valadoc_importer_gir_documentation_importer_get_cparameter_name (ValadocImporterGirDocumentationImporter* self,
                                                                        gchar** param_names,
                                                                        int param_names_length1,
                                                                        gint length_pos);
static GType valadoc_importer_gir_documentation_importer_implicit_parameter_pos_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValadocImporterGirDocumentationImporterImplicitParameterPos* valadoc_importer_gir_documentation_importer_implicit_parameter_pos_dup (const ValadocImporterGirDocumentationImporterImplicitParameterPos* self);
static void valadoc_importer_gir_documentation_importer_implicit_parameter_pos_free (ValadocImporterGirDocumentationImporterImplicitParameterPos* self);
static void valadoc_importer_gir_documentation_importer_attach_comment (ValadocImporterGirDocumentationImporter* self,
                                                                 const gchar* cname,
                                                                 ValadocApiGirSourceComment* comment,
                                                                 gchar** param_names,
                                                                 int param_names_length1,
                                                                 ValadocImporterGirDocumentationImporterImplicitParameterPos* destroy_notifies,
                                                                 int destroy_notifies_length1,
                                                                 ValadocImporterGirDocumentationImporterImplicitParameterPos* closures,
                                                                 int closures_length1,
                                                                 ValadocImporterGirDocumentationImporterImplicitParameterPos* array_lengths,
                                                                 int array_lengths_length1,
                                                                 gint array_length_ret);
G_GNUC_INTERNAL void valadoc_api_formal_parameter_set_implicit_destroy_cparameter_name (ValadocApiFormalParameter* self,
                                                                        const gchar* value);
G_GNUC_INTERNAL void valadoc_api_formal_parameter_set_implicit_closure_cparameter_name (ValadocApiFormalParameter* self,
                                                                        const gchar* value);
G_GNUC_INTERNAL void valadoc_api_formal_parameter_set_implicit_array_length_cparameter_name (ValadocApiFormalParameter* self,
                                                                             const gchar* value);
G_GNUC_INTERNAL void valadoc_api_callable_set_implicit_array_length_cparameter_name (ValadocApiCallable* self,
                                                                     const gchar* value);
G_GNUC_INTERNAL void valadoc_api_node_set_documentation (ValadocApiNode* self,
                                         ValadocContentComment* value);
static void valadoc_importer_gir_documentation_importer_warning (ValadocImporterGirDocumentationImporter* self,
                                                          const gchar* message);
static void valadoc_importer_gir_documentation_importer_error (ValadocImporterGirDocumentationImporter* self,
                                                        const gchar* message);
static void valadoc_importer_gir_documentation_importer_start_element (ValadocImporterGirDocumentationImporter* self,
                                                                const gchar* name);
static void valadoc_importer_gir_documentation_importer_end_element (ValadocImporterGirDocumentationImporter* self,
                                                              const gchar* name);
static void valadoc_importer_gir_documentation_importer_parse_namespace (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_include (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_package (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_c_include (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_skip_element (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_alias (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_enumeration (ValadocImporterGirDocumentationImporter* self,
                                                                    const gchar* element_name);
static void valadoc_importer_gir_documentation_importer_parse_bitfield (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_method (ValadocImporterGirDocumentationImporter* self,
                                                               const gchar* element_name);
static void valadoc_importer_gir_documentation_importer_parse_callback (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_record (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_class (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_interface (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_boxed (ValadocImporterGirDocumentationImporter* self,
                                                              const gchar* element_name);
static void valadoc_importer_gir_documentation_importer_parse_union (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_constant (ValadocImporterGirDocumentationImporter* self);
static ValadocApiGirSourceComment* valadoc_importer_gir_documentation_importer_parse_symbol_doc (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_type (ValadocImporterGirDocumentationImporter* self,
                                                             gint* array_length_pos);
static ValadocApiSourceComment* valadoc_importer_gir_documentation_importer_parse_doc (ValadocImporterGirDocumentationImporter* self,
                                                                                const gchar* element_name);
static void valadoc_importer_gir_documentation_importer_parse_enumeration_member (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_return_value (ValadocImporterGirDocumentationImporter* self,
                                                                     ValadocApiSourceComment* * comment,
                                                                     gint* array_length_ret);
static void valadoc_importer_gir_documentation_importer_parse_parameter (ValadocImporterGirDocumentationImporter* self,
                                                                  ValadocApiSourceComment* * comment,
                                                                  gchar* * param_name,
                                                                  gint* destroy_pos,
                                                                  gint* closure_pos,
                                                                  gint* array_length_pos);
static void valadoc_importer_gir_documentation_importer_parse_field (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_constructor (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_property (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_signal (ValadocImporterGirDocumentationImporter* self);
static void valadoc_importer_gir_documentation_importer_parse_function (ValadocImporterGirDocumentationImporter* self,
                                                                 const gchar* element_name);
static void _vala_array_add3 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void valadoc_importer_gir_documentation_importer_implicit_parameter_pos_init (ValadocImporterGirDocumentationImporterImplicitParameterPos *self,
                                                                              gint parameter,
                                                                              gint position);
static void _vala_array_add4 (ValadocImporterGirDocumentationImporterImplicitParameterPos* * array,
                       int* length,
                       int* size,
                       const ValadocImporterGirDocumentationImporterImplicitParameterPos* value);
static void _vala_array_add5 (ValadocImporterGirDocumentationImporterImplicitParameterPos* * array,
                       int* length,
                       int* size,
                       const ValadocImporterGirDocumentationImporterImplicitParameterPos* value);
static void _vala_array_add6 (ValadocImporterGirDocumentationImporterImplicitParameterPos* * array,
                       int* length,
                       int* size,
                       const ValadocImporterGirDocumentationImporterImplicitParameterPos* value);
static void valadoc_importer_gir_documentation_importer_finalize (GObject * obj);
static void _vala_valadoc_importer_gir_documentation_importer_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


ValadocImporterGirDocumentationImporter*
valadoc_importer_gir_documentation_importer_construct (GType object_type,
                                                       ValadocApiTree* tree,
                                                       ValadocDocumentationParser* parser,
                                                       ValadocModuleLoader* modules,
                                                       ValadocSettings* settings,
                                                       ValadocErrorReporter* reporter)
{
	ValadocImporterGirDocumentationImporter * self = NULL;
	ValadocDocumentationParser* _tmp0_;
	g_return_val_if_fail (tree != NULL, NULL);
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (modules != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	self = (ValadocImporterGirDocumentationImporter*) valadoc_importer_documentation_importer_construct (object_type, tree, modules, settings);
	_tmp0_ = _g_object_ref0 (parser);
	_g_object_unref0 (self->priv->parser);
	self->priv->parser = _tmp0_;
	return self;
}


ValadocImporterGirDocumentationImporter*
valadoc_importer_gir_documentation_importer_new (ValadocApiTree* tree,
                                                 ValadocDocumentationParser* parser,
                                                 ValadocModuleLoader* modules,
                                                 ValadocSettings* settings,
                                                 ValadocErrorReporter* reporter)
{
	return valadoc_importer_gir_documentation_importer_construct (VALADOC_IMPORTER_TYPE_GIR_DOCUMENTATION_IMPORTER, tree, parser, modules, settings, reporter);
}


static void
valadoc_importer_gir_documentation_importer_real_process (ValadocImporterDocumentationImporter* base,
                                                          const gchar* source_file)
{
	ValadocImporterGirDocumentationImporter * self;
	ValaSourceFile* data = NULL;
	ValadocApiTree* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ValaSourceFile* _tmp5_;
	ValaSourceFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValadocApiPackage* _tmp9_;
	ValadocApiPackage* _tmp10_;
	ValadocApiSourceFile* _tmp11_;
	ValaMarkupReader* _tmp12_;
	self = (ValadocImporterGirDocumentationImporter*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = ((ValadocImporterDocumentationImporter*) self)->tree;
	_tmp1_ = valadoc_api_tree_get_data (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_path_get_basename (source_file);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_source_file_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_CODE_CONTEXT, ValaCodeContext), VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp4_, NULL, FALSE);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	data = _tmp6_;
	_tmp7_ = g_path_get_basename (source_file);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_package_new (_tmp8_, TRUE, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = valadoc_api_source_file_new (_tmp10_, source_file, NULL, data);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp11_;
	_g_object_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp12_ = vala_markup_reader_new (source_file);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = _tmp12_;
	valadoc_importer_gir_documentation_importer_next (self);
	valadoc_importer_gir_documentation_importer_next (self);
	valadoc_importer_gir_documentation_importer_next (self);
	valadoc_importer_gir_documentation_importer_parse_repository (self);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = NULL;
	_g_object_unref0 (self->priv->file);
	self->priv->file = NULL;
	_vala_source_file_unref0 (data);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static ValadocApiFormalParameter*
valadoc_importer_gir_documentation_importer_find_parameter (ValadocImporterGirDocumentationImporter* self,
                                                            ValadocApiNode* node,
                                                            const gchar* name)
{
	ValadocApiFormalParameter* result = NULL;
	ValaList* parameters = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = valadoc_api_node_get_children_by_type (node, VALADOC_API_NODE_TYPE_FORMAL_PARAMETER, FALSE);
	parameters = _tmp0_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _param_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _param_index = 0;
		_tmp1_ = parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_param_list = _tmp2_;
		_tmp3_ = _param_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_param_size = _tmp5_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValadocApiNode* param = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValadocApiNode* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp6_ = _param_index;
			_param_index = _tmp6_ + 1;
			_tmp7_ = _param_index;
			_tmp8_ = _param_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _param_list;
			_tmp10_ = _param_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			param = (ValadocApiNode*) _tmp11_;
			_tmp12_ = param;
			_tmp13_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALADOC_API_TYPE_FORMAL_PARAMETER, ValadocApiFormalParameter));
			_tmp14_ = _tmp13_;
			if (g_strcmp0 (_tmp14_, name) == 0) {
				ValadocApiNode* _tmp15_;
				ValadocApiFormalParameter* _tmp16_;
				_tmp15_ = param;
				_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALADOC_API_TYPE_FORMAL_PARAMETER, ValadocApiFormalParameter));
				result = _tmp16_;
				_g_object_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_iterable_unref0 (parameters);
				return result;
			}
			_g_object_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = NULL;
	_vala_iterable_unref0 (parameters);
	return result;
}


static inline gchar*
valadoc_importer_gir_documentation_importer_get_cparameter_name (ValadocImporterGirDocumentationImporter* self,
                                                                 gchar** param_names,
                                                                 int param_names_length1,
                                                                 gint length_pos)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	if (length_pos < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = param_names_length1 < length_pos;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = param_names[length_pos];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


static void
valadoc_importer_gir_documentation_importer_attach_comment (ValadocImporterGirDocumentationImporter* self,
                                                            const gchar* cname,
                                                            ValadocApiGirSourceComment* comment,
                                                            gchar** param_names,
                                                            int param_names_length1,
                                                            ValadocImporterGirDocumentationImporterImplicitParameterPos* destroy_notifies,
                                                            int destroy_notifies_length1,
                                                            ValadocImporterGirDocumentationImporterImplicitParameterPos* closures,
                                                            int closures_length1,
                                                            ValadocImporterGirDocumentationImporterImplicitParameterPos* array_lengths,
                                                            int array_lengths_length1,
                                                            gint array_length_ret)
{
	ValadocApiNode* node = NULL;
	ValadocApiTree* _tmp0_;
	ValadocApiNode* _tmp1_;
	ValadocApiNode* _tmp2_;
	ValadocContentComment* content = NULL;
	ValadocDocumentationParser* _tmp40_;
	ValadocApiNode* _tmp41_;
	ValadocContentComment* _tmp42_;
	ValadocContentComment* _tmp43_;
	ValadocApiNode* _tmp44_;
	ValadocContentComment* _tmp45_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	if (comment == NULL) {
		return;
	}
	_tmp0_ = ((ValadocImporterDocumentationImporter*) self)->tree;
	_tmp1_ = valadoc_api_tree_search_symbol_cstr (_tmp0_, NULL, cname);
	node = _tmp1_;
	_tmp2_ = node;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (node);
		return;
	}
	if (param_names != NULL) {
		ValadocApiNode* _tmp36_;
		{
			ValadocImporterGirDocumentationImporterImplicitParameterPos* pos_collection = NULL;
			gint pos_collection_length1 = 0;
			gint _pos_collection_size_ = 0;
			gint pos_it = 0;
			pos_collection = destroy_notifies;
			pos_collection_length1 = destroy_notifies_length1;
			for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
				ValadocImporterGirDocumentationImporterImplicitParameterPos pos = {0};
				pos = pos_collection[pos_it];
				{
					ValadocApiFormalParameter* param = NULL;
					ValadocApiNode* _tmp3_;
					ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp4_;
					gint _tmp5_;
					const gchar* _tmp6_;
					ValadocApiFormalParameter* _tmp7_;
					ValadocApiFormalParameter* _tmp8_;
					ValadocApiFormalParameter* _tmp9_;
					ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp10_;
					gint _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp3_ = node;
					_tmp4_ = pos;
					_tmp5_ = _tmp4_.parameter;
					_tmp6_ = param_names[_tmp5_];
					_tmp7_ = valadoc_importer_gir_documentation_importer_find_parameter (self, _tmp3_, _tmp6_);
					param = _tmp7_;
					_tmp8_ = param;
					if (_tmp8_ == NULL) {
						_g_object_unref0 (param);
						continue;
					}
					_tmp9_ = param;
					_tmp10_ = pos;
					_tmp11_ = _tmp10_.position;
					_tmp12_ = valadoc_importer_gir_documentation_importer_get_cparameter_name (self, param_names, param_names_length1, _tmp11_);
					_tmp13_ = _tmp12_;
					valadoc_api_formal_parameter_set_implicit_destroy_cparameter_name (_tmp9_, _tmp13_);
					_g_free0 (_tmp13_);
					_g_object_unref0 (param);
				}
			}
		}
		{
			ValadocImporterGirDocumentationImporterImplicitParameterPos* pos_collection = NULL;
			gint pos_collection_length1 = 0;
			gint _pos_collection_size_ = 0;
			gint pos_it = 0;
			pos_collection = closures;
			pos_collection_length1 = closures_length1;
			for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
				ValadocImporterGirDocumentationImporterImplicitParameterPos pos = {0};
				pos = pos_collection[pos_it];
				{
					ValadocApiFormalParameter* param = NULL;
					ValadocApiNode* _tmp14_;
					ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp15_;
					gint _tmp16_;
					const gchar* _tmp17_;
					ValadocApiFormalParameter* _tmp18_;
					ValadocApiFormalParameter* _tmp19_;
					ValadocApiFormalParameter* _tmp20_;
					ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp21_;
					gint _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp14_ = node;
					_tmp15_ = pos;
					_tmp16_ = _tmp15_.parameter;
					_tmp17_ = param_names[_tmp16_];
					_tmp18_ = valadoc_importer_gir_documentation_importer_find_parameter (self, _tmp14_, _tmp17_);
					param = _tmp18_;
					_tmp19_ = param;
					if (_tmp19_ == NULL) {
						_g_object_unref0 (param);
						continue;
					}
					_tmp20_ = param;
					_tmp21_ = pos;
					_tmp22_ = _tmp21_.position;
					_tmp23_ = valadoc_importer_gir_documentation_importer_get_cparameter_name (self, param_names, param_names_length1, _tmp22_);
					_tmp24_ = _tmp23_;
					valadoc_api_formal_parameter_set_implicit_closure_cparameter_name (_tmp20_, _tmp24_);
					_g_free0 (_tmp24_);
					_g_object_unref0 (param);
				}
			}
		}
		{
			ValadocImporterGirDocumentationImporterImplicitParameterPos* pos_collection = NULL;
			gint pos_collection_length1 = 0;
			gint _pos_collection_size_ = 0;
			gint pos_it = 0;
			pos_collection = array_lengths;
			pos_collection_length1 = array_lengths_length1;
			for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
				ValadocImporterGirDocumentationImporterImplicitParameterPos pos = {0};
				pos = pos_collection[pos_it];
				{
					ValadocApiFormalParameter* param = NULL;
					ValadocApiNode* _tmp25_;
					ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp26_;
					gint _tmp27_;
					const gchar* _tmp28_;
					ValadocApiFormalParameter* _tmp29_;
					ValadocApiFormalParameter* _tmp30_;
					ValadocApiFormalParameter* _tmp31_;
					ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp32_;
					gint _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					_tmp25_ = node;
					_tmp26_ = pos;
					_tmp27_ = _tmp26_.parameter;
					_tmp28_ = param_names[_tmp27_];
					_tmp29_ = valadoc_importer_gir_documentation_importer_find_parameter (self, _tmp25_, _tmp28_);
					param = _tmp29_;
					_tmp30_ = param;
					if (_tmp30_ == NULL) {
						_g_object_unref0 (param);
						continue;
					}
					_tmp31_ = param;
					_tmp32_ = pos;
					_tmp33_ = _tmp32_.position;
					_tmp34_ = valadoc_importer_gir_documentation_importer_get_cparameter_name (self, param_names, param_names_length1, _tmp33_);
					_tmp35_ = _tmp34_;
					valadoc_api_formal_parameter_set_implicit_array_length_cparameter_name (_tmp31_, _tmp35_);
					_g_free0 (_tmp35_);
					_g_object_unref0 (param);
				}
			}
		}
		_tmp36_ = node;
		if (VALADOC_API_IS_CALLABLE (_tmp36_)) {
			ValadocApiNode* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp37_ = node;
			_tmp38_ = valadoc_importer_gir_documentation_importer_get_cparameter_name (self, param_names, param_names_length1, array_length_ret);
			_tmp39_ = _tmp38_;
			valadoc_api_callable_set_implicit_array_length_cparameter_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALADOC_API_TYPE_CALLABLE, ValadocApiCallable), _tmp39_);
			_g_free0 (_tmp39_);
		}
	}
	_tmp40_ = self->priv->parser;
	_tmp41_ = node;
	_tmp42_ = valadoc_documentation_parser_parse (_tmp40_, _tmp41_, (ValadocApiSourceComment*) comment);
	content = _tmp42_;
	_tmp43_ = content;
	if (_tmp43_ == NULL) {
		_g_object_unref0 (content);
		_g_object_unref0 (node);
		return;
	}
	_tmp44_ = node;
	_tmp45_ = content;
	valadoc_api_node_set_documentation (_tmp44_, _tmp45_);
	_g_object_unref0 (content);
	_g_object_unref0 (node);
}


static void
valadoc_importer_gir_documentation_importer_warning (ValadocImporterGirDocumentationImporter* self,
                                                     const gchar* message)
{
	ValadocApiSourceFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = valadoc_api_source_file_get_data (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->begin;
	_tmp4_ = self->priv->end;
	_tmp5_ = vala_source_reference_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_SOURCE_FILE, ValaSourceFile), &_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	vala_report_warning (_tmp6_, message);
	_vala_source_reference_unref0 (_tmp6_);
}


static void
valadoc_importer_gir_documentation_importer_error (ValadocImporterGirDocumentationImporter* self,
                                                   const gchar* message)
{
	ValadocApiSourceFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = valadoc_api_source_file_get_data (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->begin;
	_tmp4_ = self->priv->end;
	_tmp5_ = vala_source_reference_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_SOURCE_FILE, ValaSourceFile), &_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	vala_report_error (_tmp6_, message);
	_vala_source_reference_unref0 (_tmp6_);
}


static void
valadoc_importer_gir_documentation_importer_next (ValadocImporterGirDocumentationImporter* self)
{
	ValaMarkupReader* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	ValaSourceLocation _tmp2_ = {0};
	ValaMarkupTokenType _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMarkupTokenType _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_read_token (_tmp0_, &_tmp1_, &_tmp2_);
	self->priv->begin = _tmp1_;
	self->priv->end = _tmp2_;
	self->priv->current_token = _tmp3_;
	_tmp5_ = self->priv->current_token;
	if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = self->priv->reader;
		_tmp7_ = vala_markup_reader_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = g_strcmp0 (_tmp8_, "annotation") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		valadoc_importer_gir_documentation_importer_next (self);
		valadoc_importer_gir_documentation_importer_next (self);
	}
}


static void
valadoc_importer_gir_documentation_importer_start_element (ValadocImporterGirDocumentationImporter* self,
                                                           const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	ValaMarkupTokenType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->current_token;
	if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaMarkupReader* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup_printf ("expected start element of `%s'", name);
		_tmp6_ = _tmp5_;
		valadoc_importer_gir_documentation_importer_error (self, _tmp6_);
		_g_free0 (_tmp6_);
	}
}


static void
valadoc_importer_gir_documentation_importer_end_element (ValadocImporterGirDocumentationImporter* self,
                                                         const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	ValaMarkupTokenType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->current_token;
	if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaMarkupReader* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup_printf ("expected end element of `%s'", name);
		_tmp6_ = _tmp5_;
		valadoc_importer_gir_documentation_importer_error (self, _tmp6_);
		_g_free0 (_tmp6_);
	}
	valadoc_importer_gir_documentation_importer_next (self);
}


static void
valadoc_importer_gir_documentation_importer_parse_repository (ValadocImporterGirDocumentationImporter* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "repository");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "version");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_GIR_VERSION) != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		ValaMarkupReader* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = self->priv->reader;
		_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "version");
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("unsupported GIR version %s (supported: %s)", _tmp6_, VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_GIR_VERSION);
		_tmp8_ = _tmp7_;
		valadoc_importer_gir_documentation_importer_error (self, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		return;
	}
	valadoc_importer_gir_documentation_importer_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp9_;
		ValaMarkupReader* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = self->priv->current_token;
		if (!(_tmp9_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp10_ = self->priv->reader;
		_tmp11_ = vala_markup_reader_get_name (_tmp10_);
		_tmp12_ = _tmp11_;
		if (g_strcmp0 (_tmp12_, "namespace") == 0) {
			valadoc_importer_gir_documentation_importer_parse_namespace (self);
		} else {
			ValaMarkupReader* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = self->priv->reader;
			_tmp14_ = vala_markup_reader_get_name (_tmp13_);
			_tmp15_ = _tmp14_;
			if (g_strcmp0 (_tmp15_, "include") == 0) {
				valadoc_importer_gir_documentation_importer_parse_include (self);
			} else {
				ValaMarkupReader* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp16_ = self->priv->reader;
				_tmp17_ = vala_markup_reader_get_name (_tmp16_);
				_tmp18_ = _tmp17_;
				if (g_strcmp0 (_tmp18_, "package") == 0) {
					valadoc_importer_gir_documentation_importer_parse_package (self);
				} else {
					ValaMarkupReader* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					_tmp19_ = self->priv->reader;
					_tmp20_ = vala_markup_reader_get_name (_tmp19_);
					_tmp21_ = _tmp20_;
					if (g_strcmp0 (_tmp21_, "c:include") == 0) {
						valadoc_importer_gir_documentation_importer_parse_c_include (self);
					} else {
						ValaMarkupReader* _tmp22_;
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						_tmp22_ = self->priv->reader;
						_tmp23_ = vala_markup_reader_get_name (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_strdup_printf ("unknown child element `%s' in `repository'", _tmp24_);
						_tmp26_ = _tmp25_;
						valadoc_importer_gir_documentation_importer_error (self, _tmp26_);
						_g_free0 (_tmp26_);
						valadoc_importer_gir_documentation_importer_skip_element (self);
					}
				}
			}
		}
	}
	valadoc_importer_gir_documentation_importer_end_element (self, "repository");
}


static void
valadoc_importer_gir_documentation_importer_parse_include (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "include");
	valadoc_importer_gir_documentation_importer_next (self);
	valadoc_importer_gir_documentation_importer_end_element (self, "include");
}


static void
valadoc_importer_gir_documentation_importer_parse_package (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "package");
	valadoc_importer_gir_documentation_importer_next (self);
	valadoc_importer_gir_documentation_importer_end_element (self, "package");
}


static void
valadoc_importer_gir_documentation_importer_parse_c_include (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "c:include");
	valadoc_importer_gir_documentation_importer_next (self);
	valadoc_importer_gir_documentation_importer_end_element (self, "c:include");
}


static void
valadoc_importer_gir_documentation_importer_skip_element (ValadocImporterGirDocumentationImporter* self)
{
	gint level = 0;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_next (self);
	level = 1;
	while (TRUE) {
		gint _tmp0_;
		ValaMarkupTokenType _tmp1_;
		_tmp0_ = level;
		if (!(_tmp0_ > 0)) {
			break;
		}
		_tmp1_ = self->priv->current_token;
		if (_tmp1_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			gint _tmp2_;
			_tmp2_ = level;
			level = _tmp2_ + 1;
		} else {
			ValaMarkupTokenType _tmp3_;
			_tmp3_ = self->priv->current_token;
			if (_tmp3_ == VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
				gint _tmp4_;
				_tmp4_ = level;
				level = _tmp4_ - 1;
			} else {
				ValaMarkupTokenType _tmp5_;
				_tmp5_ = self->priv->current_token;
				if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_EOF) {
					valadoc_importer_gir_documentation_importer_error (self, "unexpected end of file");
					break;
				}
			}
		}
		valadoc_importer_gir_documentation_importer_next (self);
	}
}


static void
valadoc_importer_gir_documentation_importer_parse_namespace (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "namespace");
	valadoc_importer_gir_documentation_importer_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		if (g_strcmp0 (_tmp3_, "alias") == 0) {
			valadoc_importer_gir_documentation_importer_parse_alias (self);
		} else {
			ValaMarkupReader* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp4_ = self->priv->reader;
			_tmp5_ = vala_markup_reader_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			if (g_strcmp0 (_tmp6_, "enumeration") == 0) {
				valadoc_importer_gir_documentation_importer_parse_enumeration (self, "enumeration");
			} else {
				ValaMarkupReader* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp7_ = self->priv->reader;
				_tmp8_ = vala_markup_reader_get_name (_tmp7_);
				_tmp9_ = _tmp8_;
				if (g_strcmp0 (_tmp9_, "bitfield") == 0) {
					valadoc_importer_gir_documentation_importer_parse_bitfield (self);
				} else {
					ValaMarkupReader* _tmp10_;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					_tmp10_ = self->priv->reader;
					_tmp11_ = vala_markup_reader_get_name (_tmp10_);
					_tmp12_ = _tmp11_;
					if (g_strcmp0 (_tmp12_, "function") == 0) {
						valadoc_importer_gir_documentation_importer_parse_method (self, "function");
					} else {
						ValaMarkupReader* _tmp13_;
						const gchar* _tmp14_;
						const gchar* _tmp15_;
						_tmp13_ = self->priv->reader;
						_tmp14_ = vala_markup_reader_get_name (_tmp13_);
						_tmp15_ = _tmp14_;
						if (g_strcmp0 (_tmp15_, "callback") == 0) {
							valadoc_importer_gir_documentation_importer_parse_callback (self);
						} else {
							ValaMarkupReader* _tmp16_;
							const gchar* _tmp17_;
							const gchar* _tmp18_;
							_tmp16_ = self->priv->reader;
							_tmp17_ = vala_markup_reader_get_name (_tmp16_);
							_tmp18_ = _tmp17_;
							if (g_strcmp0 (_tmp18_, "record") == 0) {
								valadoc_importer_gir_documentation_importer_parse_record (self);
							} else {
								ValaMarkupReader* _tmp19_;
								const gchar* _tmp20_;
								const gchar* _tmp21_;
								_tmp19_ = self->priv->reader;
								_tmp20_ = vala_markup_reader_get_name (_tmp19_);
								_tmp21_ = _tmp20_;
								if (g_strcmp0 (_tmp21_, "class") == 0) {
									valadoc_importer_gir_documentation_importer_parse_class (self);
								} else {
									ValaMarkupReader* _tmp22_;
									const gchar* _tmp23_;
									const gchar* _tmp24_;
									_tmp22_ = self->priv->reader;
									_tmp23_ = vala_markup_reader_get_name (_tmp22_);
									_tmp24_ = _tmp23_;
									if (g_strcmp0 (_tmp24_, "interface") == 0) {
										valadoc_importer_gir_documentation_importer_parse_interface (self);
									} else {
										ValaMarkupReader* _tmp25_;
										const gchar* _tmp26_;
										const gchar* _tmp27_;
										_tmp25_ = self->priv->reader;
										_tmp26_ = vala_markup_reader_get_name (_tmp25_);
										_tmp27_ = _tmp26_;
										if (g_strcmp0 (_tmp27_, "glib:boxed") == 0) {
											valadoc_importer_gir_documentation_importer_parse_boxed (self, "glib:boxed");
										} else {
											ValaMarkupReader* _tmp28_;
											const gchar* _tmp29_;
											const gchar* _tmp30_;
											_tmp28_ = self->priv->reader;
											_tmp29_ = vala_markup_reader_get_name (_tmp28_);
											_tmp30_ = _tmp29_;
											if (g_strcmp0 (_tmp30_, "union") == 0) {
												valadoc_importer_gir_documentation_importer_parse_union (self);
											} else {
												ValaMarkupReader* _tmp31_;
												const gchar* _tmp32_;
												const gchar* _tmp33_;
												_tmp31_ = self->priv->reader;
												_tmp32_ = vala_markup_reader_get_name (_tmp31_);
												_tmp33_ = _tmp32_;
												if (g_strcmp0 (_tmp33_, "constant") == 0) {
													valadoc_importer_gir_documentation_importer_parse_constant (self);
												} else {
													ValaMarkupReader* _tmp34_;
													const gchar* _tmp35_;
													const gchar* _tmp36_;
													gchar* _tmp37_;
													gchar* _tmp38_;
													_tmp34_ = self->priv->reader;
													_tmp35_ = vala_markup_reader_get_name (_tmp34_);
													_tmp36_ = _tmp35_;
													_tmp37_ = g_strdup_printf ("unknown child element `%s' in `namespace'", _tmp36_);
													_tmp38_ = _tmp37_;
													valadoc_importer_gir_documentation_importer_error (self, _tmp38_);
													_g_free0 (_tmp38_);
													valadoc_importer_gir_documentation_importer_skip_element (self);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	valadoc_importer_gir_documentation_importer_end_element (self, "namespace");
}


static void
valadoc_importer_gir_documentation_importer_parse_alias (ValadocImporterGirDocumentationImporter* self)
{
	gchar* c_identifier = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp2_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "alias");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	c_identifier = _tmp1_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp2_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp2_;
	valadoc_importer_gir_documentation_importer_attach_comment (self, c_identifier, comment, NULL, 0, NULL, 0, NULL, 0, NULL, 0, -1);
	valadoc_importer_gir_documentation_importer_parse_type (self, NULL);
	valadoc_importer_gir_documentation_importer_end_element (self, "alias");
	_valadoc_api_source_comment_unref0 (comment);
	_g_free0 (c_identifier);
}


static ValadocApiGirSourceComment*
valadoc_importer_gir_documentation_importer_parse_symbol_doc (ValadocImporterGirDocumentationImporter* self)
{
	ValadocApiGirSourceComment* result = NULL;
	ValadocApiGirSourceComment* comment = NULL;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "doc") == 0) {
		ValaMarkupTokenType _tmp3_;
		valadoc_importer_gir_documentation_importer_start_element (self, "doc");
		valadoc_importer_gir_documentation_importer_next (self);
		_tmp3_ = self->priv->current_token;
		if (_tmp3_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
			ValaMarkupReader* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			ValadocApiSourceFile* _tmp7_;
			ValaSourceLocation _tmp8_;
			gint _tmp9_;
			ValaSourceLocation _tmp10_;
			gint _tmp11_;
			ValaSourceLocation _tmp12_;
			gint _tmp13_;
			ValaSourceLocation _tmp14_;
			gint _tmp15_;
			ValadocApiGirSourceComment* _tmp16_;
			_tmp4_ = self->priv->reader;
			_tmp5_ = vala_markup_reader_get_content (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = self->priv->file;
			_tmp8_ = self->priv->begin;
			_tmp9_ = _tmp8_.line;
			_tmp10_ = self->priv->begin;
			_tmp11_ = _tmp10_.column;
			_tmp12_ = self->priv->end;
			_tmp13_ = _tmp12_.line;
			_tmp14_ = self->priv->end;
			_tmp15_ = _tmp14_.column;
			_tmp16_ = valadoc_api_gir_source_comment_new (_tmp6_, _tmp7_, _tmp9_, _tmp11_, _tmp13_, _tmp15_);
			_valadoc_api_source_comment_unref0 (comment);
			comment = _tmp16_;
			valadoc_importer_gir_documentation_importer_next (self);
		}
		valadoc_importer_gir_documentation_importer_end_element (self, "doc");
	}
	while (TRUE) {
		ValaMarkupReader* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp17_ = self->priv->reader;
		_tmp18_ = vala_markup_reader_get_name (_tmp17_);
		_tmp19_ = _tmp18_;
		if (g_strcmp0 (_tmp19_, "doc-deprecated") == 0) {
			ValadocApiSourceComment* doc_deprecated = NULL;
			ValadocApiSourceComment* _tmp20_;
			ValadocApiSourceComment* _tmp21_;
			_tmp20_ = valadoc_importer_gir_documentation_importer_parse_doc (self, "doc-deprecated");
			doc_deprecated = _tmp20_;
			_tmp21_ = doc_deprecated;
			if (_tmp21_ != NULL) {
				ValadocApiGirSourceComment* _tmp22_;
				ValadocApiGirSourceComment* _tmp33_;
				ValadocApiSourceComment* _tmp34_;
				_tmp22_ = comment;
				if (_tmp22_ == NULL) {
					ValadocApiSourceFile* _tmp23_;
					ValaSourceLocation _tmp24_;
					gint _tmp25_;
					ValaSourceLocation _tmp26_;
					gint _tmp27_;
					ValaSourceLocation _tmp28_;
					gint _tmp29_;
					ValaSourceLocation _tmp30_;
					gint _tmp31_;
					ValadocApiGirSourceComment* _tmp32_;
					_tmp23_ = self->priv->file;
					_tmp24_ = self->priv->begin;
					_tmp25_ = _tmp24_.line;
					_tmp26_ = self->priv->end;
					_tmp27_ = _tmp26_.line;
					_tmp28_ = self->priv->begin;
					_tmp29_ = _tmp28_.line;
					_tmp30_ = self->priv->end;
					_tmp31_ = _tmp30_.line;
					_tmp32_ = valadoc_api_gir_source_comment_new ("", _tmp23_, _tmp25_, _tmp27_, _tmp29_, _tmp31_);
					_valadoc_api_source_comment_unref0 (comment);
					comment = _tmp32_;
				}
				_tmp33_ = comment;
				_tmp34_ = doc_deprecated;
				valadoc_api_gir_source_comment_set_deprecated_comment (_tmp33_, _tmp34_);
			}
			_valadoc_api_source_comment_unref0 (doc_deprecated);
		} else {
			ValaMarkupReader* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp35_ = self->priv->reader;
			_tmp36_ = vala_markup_reader_get_name (_tmp35_);
			_tmp37_ = _tmp36_;
			if (g_strcmp0 (_tmp37_, "doc-version") == 0) {
				ValadocApiSourceComment* doc_version = NULL;
				ValadocApiSourceComment* _tmp38_;
				ValadocApiSourceComment* _tmp39_;
				_tmp38_ = valadoc_importer_gir_documentation_importer_parse_doc (self, "doc-version");
				doc_version = _tmp38_;
				_tmp39_ = doc_version;
				if (_tmp39_ != NULL) {
					ValadocApiGirSourceComment* _tmp40_;
					ValadocApiGirSourceComment* _tmp51_;
					ValadocApiSourceComment* _tmp52_;
					_tmp40_ = comment;
					if (_tmp40_ == NULL) {
						ValadocApiSourceFile* _tmp41_;
						ValaSourceLocation _tmp42_;
						gint _tmp43_;
						ValaSourceLocation _tmp44_;
						gint _tmp45_;
						ValaSourceLocation _tmp46_;
						gint _tmp47_;
						ValaSourceLocation _tmp48_;
						gint _tmp49_;
						ValadocApiGirSourceComment* _tmp50_;
						_tmp41_ = self->priv->file;
						_tmp42_ = self->priv->begin;
						_tmp43_ = _tmp42_.line;
						_tmp44_ = self->priv->end;
						_tmp45_ = _tmp44_.line;
						_tmp46_ = self->priv->begin;
						_tmp47_ = _tmp46_.line;
						_tmp48_ = self->priv->end;
						_tmp49_ = _tmp48_.line;
						_tmp50_ = valadoc_api_gir_source_comment_new ("", _tmp41_, _tmp43_, _tmp45_, _tmp47_, _tmp49_);
						_valadoc_api_source_comment_unref0 (comment);
						comment = _tmp50_;
					}
					_tmp51_ = comment;
					_tmp52_ = doc_version;
					valadoc_api_gir_source_comment_set_version_comment (_tmp51_, _tmp52_);
				}
				_valadoc_api_source_comment_unref0 (doc_version);
			} else {
				ValaMarkupReader* _tmp53_;
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				_tmp53_ = self->priv->reader;
				_tmp54_ = vala_markup_reader_get_name (_tmp53_);
				_tmp55_ = _tmp54_;
				if (g_strcmp0 (_tmp55_, "doc-stability") == 0) {
					ValadocApiSourceComment* doc_stability = NULL;
					ValadocApiSourceComment* _tmp56_;
					ValadocApiSourceComment* _tmp57_;
					_tmp56_ = valadoc_importer_gir_documentation_importer_parse_doc (self, "doc-stability");
					doc_stability = _tmp56_;
					_tmp57_ = doc_stability;
					if (_tmp57_ != NULL) {
						ValadocApiGirSourceComment* _tmp58_;
						ValadocApiGirSourceComment* _tmp69_;
						ValadocApiSourceComment* _tmp70_;
						_tmp58_ = comment;
						if (_tmp58_ == NULL) {
							ValadocApiSourceFile* _tmp59_;
							ValaSourceLocation _tmp60_;
							gint _tmp61_;
							ValaSourceLocation _tmp62_;
							gint _tmp63_;
							ValaSourceLocation _tmp64_;
							gint _tmp65_;
							ValaSourceLocation _tmp66_;
							gint _tmp67_;
							ValadocApiGirSourceComment* _tmp68_;
							_tmp59_ = self->priv->file;
							_tmp60_ = self->priv->begin;
							_tmp61_ = _tmp60_.line;
							_tmp62_ = self->priv->end;
							_tmp63_ = _tmp62_.line;
							_tmp64_ = self->priv->begin;
							_tmp65_ = _tmp64_.line;
							_tmp66_ = self->priv->end;
							_tmp67_ = _tmp66_.line;
							_tmp68_ = valadoc_api_gir_source_comment_new ("", _tmp59_, _tmp61_, _tmp63_, _tmp65_, _tmp67_);
							_valadoc_api_source_comment_unref0 (comment);
							comment = _tmp68_;
						}
						_tmp69_ = comment;
						_tmp70_ = doc_stability;
						valadoc_api_gir_source_comment_set_stability_comment (_tmp69_, _tmp70_);
					}
					_valadoc_api_source_comment_unref0 (doc_stability);
				} else {
					ValaMarkupReader* _tmp71_;
					const gchar* _tmp72_;
					const gchar* _tmp73_;
					_tmp71_ = self->priv->reader;
					_tmp72_ = vala_markup_reader_get_name (_tmp71_);
					_tmp73_ = _tmp72_;
					if (g_strcmp0 (_tmp73_, "source-position") == 0) {
						valadoc_importer_gir_documentation_importer_skip_element (self);
					} else {
						break;
					}
				}
			}
		}
	}
	result = comment;
	return result;
}


static ValadocApiSourceComment*
valadoc_importer_gir_documentation_importer_parse_doc (ValadocImporterGirDocumentationImporter* self,
                                                       const gchar* element_name)
{
	ValadocApiSourceComment* result = NULL;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocApiSourceComment* comment = NULL;
	ValaMarkupTokenType _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element_name != NULL, NULL);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, element_name) != 0) {
		result = NULL;
		return result;
	}
	valadoc_importer_gir_documentation_importer_start_element (self, element_name);
	valadoc_importer_gir_documentation_importer_next (self);
	comment = NULL;
	_tmp3_ = self->priv->current_token;
	if (_tmp3_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
		ValaMarkupReader* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		ValadocApiSourceFile* _tmp7_;
		ValaSourceLocation _tmp8_;
		gint _tmp9_;
		ValaSourceLocation _tmp10_;
		gint _tmp11_;
		ValaSourceLocation _tmp12_;
		gint _tmp13_;
		ValaSourceLocation _tmp14_;
		gint _tmp15_;
		ValadocApiSourceComment* _tmp16_;
		_tmp4_ = self->priv->reader;
		_tmp5_ = vala_markup_reader_get_content (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->file;
		_tmp8_ = self->priv->begin;
		_tmp9_ = _tmp8_.line;
		_tmp10_ = self->priv->begin;
		_tmp11_ = _tmp10_.column;
		_tmp12_ = self->priv->end;
		_tmp13_ = _tmp12_.line;
		_tmp14_ = self->priv->end;
		_tmp15_ = _tmp14_.column;
		_tmp16_ = valadoc_api_source_comment_new (_tmp6_, _tmp7_, _tmp9_, _tmp11_, _tmp13_, _tmp15_);
		_valadoc_api_source_comment_unref0 (comment);
		comment = _tmp16_;
		valadoc_importer_gir_documentation_importer_next (self);
	}
	valadoc_importer_gir_documentation_importer_end_element (self, element_name);
	result = comment;
	return result;
}


static void
valadoc_importer_gir_documentation_importer_parse_enumeration (ValadocImporterGirDocumentationImporter* self,
                                                               const gchar* element_name)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp2_;
	const gchar* _tmp3_;
	ValadocApiGirSourceComment* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = _tmp1_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp2_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp2_;
	_tmp3_ = self->priv->parent_c_identifier;
	_tmp4_ = comment;
	valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp3_, _tmp4_, NULL, 0, NULL, 0, NULL, 0, NULL, 0, -1);
	while (TRUE) {
		ValaMarkupTokenType _tmp5_;
		ValaMarkupReader* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = self->priv->current_token;
		if (!(_tmp5_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp6_ = self->priv->reader;
		_tmp7_ = vala_markup_reader_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		if (g_strcmp0 (_tmp8_, "member") == 0) {
			valadoc_importer_gir_documentation_importer_parse_enumeration_member (self);
		} else {
			ValaMarkupReader* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp9_ = self->priv->reader;
			_tmp10_ = vala_markup_reader_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, "function") == 0) {
				valadoc_importer_gir_documentation_importer_skip_element (self);
			} else {
				ValaMarkupReader* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp12_ = self->priv->reader;
				_tmp13_ = vala_markup_reader_get_name (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strdup_printf ("unknown child element `%s' in `%s'", _tmp14_, element_name);
				_tmp16_ = _tmp15_;
				valadoc_importer_gir_documentation_importer_error (self, _tmp16_);
				_g_free0 (_tmp16_);
				valadoc_importer_gir_documentation_importer_skip_element (self);
			}
		}
	}
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = NULL;
	valadoc_importer_gir_documentation_importer_end_element (self, element_name);
	_valadoc_api_source_comment_unref0 (comment);
}


static void
valadoc_importer_gir_documentation_importer_parse_bitfield (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_parse_enumeration (self, "bitfield");
}


static void
valadoc_importer_gir_documentation_importer_parse_enumeration_member (ValadocImporterGirDocumentationImporter* self)
{
	gchar* c_identifier = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp2_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "member");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:identifier");
	c_identifier = _tmp1_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp2_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp2_;
	valadoc_importer_gir_documentation_importer_attach_comment (self, c_identifier, comment, NULL, 0, NULL, 0, NULL, 0, NULL, 0, -1);
	valadoc_importer_gir_documentation_importer_end_element (self, "member");
	_valadoc_api_source_comment_unref0 (comment);
	_g_free0 (c_identifier);
}


static void
valadoc_importer_gir_documentation_importer_parse_return_value (ValadocImporterGirDocumentationImporter* self,
                                                                ValadocApiSourceComment* * comment,
                                                                gint* array_length_ret)
{
	ValadocApiSourceComment* _vala_comment = NULL;
	gint _vala_array_length_ret = 0;
	ValadocApiSourceComment* _tmp0_;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "return-value");
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp0_ = valadoc_importer_gir_documentation_importer_parse_doc (self, "doc");
	_valadoc_api_source_comment_unref0 (_vala_comment);
	_vala_comment = _tmp0_;
	valadoc_importer_gir_documentation_importer_parse_type (self, &_tmp1_);
	_vala_array_length_ret = _tmp1_;
	valadoc_importer_gir_documentation_importer_end_element (self, "return-value");
	if (comment) {
		*comment = _vala_comment;
	} else {
		_valadoc_api_source_comment_unref0 (_vala_comment);
	}
	if (array_length_ret) {
		*array_length_ret = _vala_array_length_ret;
	}
}


static void
valadoc_importer_gir_documentation_importer_parse_parameter (ValadocImporterGirDocumentationImporter* self,
                                                             ValadocApiSourceComment* * comment,
                                                             gchar* * param_name,
                                                             gint* destroy_pos,
                                                             gint* closure_pos,
                                                             gint* array_length_pos)
{
	ValadocApiSourceComment* _vala_comment = NULL;
	gchar* _vala_param_name = NULL;
	gint _vala_destroy_pos = 0;
	gint _vala_closure_pos = 0;
	gint _vala_array_length_pos = 0;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* closure = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* destroy = NULL;
	ValaMarkupReader* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	ValadocApiSourceComment* _tmp12_;
	ValaMarkupReader* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "parameter");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	_g_free0 (_vala_param_name);
	_vala_param_name = _tmp1_;
	_vala_array_length_pos = -1;
	_vala_destroy_pos = -1;
	_vala_closure_pos = -1;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "closure");
	closure = _tmp3_;
	_tmp4_ = closure;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gint _tmp6_;
		_tmp5_ = closure;
		_vala_closure_pos = atoi (_tmp5_);
		_tmp6_ = _vala_closure_pos;
		if (_tmp6_ < 0) {
			valadoc_importer_gir_documentation_importer_warning (self, "invalid closure position");
		}
	}
	_tmp7_ = self->priv->reader;
	_tmp8_ = vala_markup_reader_get_attribute (_tmp7_, "destroy");
	destroy = _tmp8_;
	_tmp9_ = destroy;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		gint _tmp11_;
		_tmp10_ = destroy;
		_vala_destroy_pos = atoi (_tmp10_);
		_tmp11_ = _vala_destroy_pos;
		if (_tmp11_ < 0) {
			valadoc_importer_gir_documentation_importer_warning (self, "invalid destroy position");
		}
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp12_ = valadoc_importer_gir_documentation_importer_parse_doc (self, "doc");
	_valadoc_api_source_comment_unref0 (_vala_comment);
	_vala_comment = _tmp12_;
	_tmp13_ = self->priv->reader;
	_tmp14_ = vala_markup_reader_get_name (_tmp13_);
	_tmp15_ = _tmp14_;
	if (g_strcmp0 (_tmp15_, "varargs") == 0) {
		gchar* _tmp16_;
		valadoc_importer_gir_documentation_importer_start_element (self, "varargs");
		_tmp16_ = g_strdup ("...");
		_g_free0 (_vala_param_name);
		_vala_param_name = _tmp16_;
		valadoc_importer_gir_documentation_importer_next (self);
		valadoc_importer_gir_documentation_importer_end_element (self, "varargs");
	} else {
		gint _tmp17_ = 0;
		valadoc_importer_gir_documentation_importer_parse_type (self, &_tmp17_);
		_vala_array_length_pos = _tmp17_;
	}
	valadoc_importer_gir_documentation_importer_end_element (self, "parameter");
	_g_free0 (destroy);
	_g_free0 (closure);
	if (comment) {
		*comment = _vala_comment;
	} else {
		_valadoc_api_source_comment_unref0 (_vala_comment);
	}
	if (param_name) {
		*param_name = _vala_param_name;
	} else {
		_g_free0 (_vala_param_name);
	}
	if (destroy_pos) {
		*destroy_pos = _vala_destroy_pos;
	}
	if (closure_pos) {
		*closure_pos = _vala_closure_pos;
	}
	if (array_length_pos) {
		*array_length_pos = _vala_array_length_pos;
	}
}


static void
valadoc_importer_gir_documentation_importer_parse_type (ValadocImporterGirDocumentationImporter* self,
                                                        gint* array_length_pos)
{
	gint _vala_array_length_pos = 0;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_vala_array_length_pos = -1;
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "array") == 0) {
		gchar* length = NULL;
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "length");
		length = _tmp4_;
		_tmp5_ = length;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			gint _tmp7_;
			_tmp6_ = length;
			_vala_array_length_pos = atoi (_tmp6_);
			_tmp7_ = _vala_array_length_pos;
			if (_tmp7_ < 0) {
				valadoc_importer_gir_documentation_importer_warning (self, "invalid array lenght position");
			}
		}
		valadoc_importer_gir_documentation_importer_skip_element (self);
		_g_free0 (length);
	} else {
		valadoc_importer_gir_documentation_importer_skip_element (self);
	}
	if (array_length_pos) {
		*array_length_pos = _vala_array_length_pos;
	}
}


static void
valadoc_importer_gir_documentation_importer_parse_record (ValadocImporterGirDocumentationImporter* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean is_type_struct = FALSE;
	ValaMarkupReader* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "record");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = _tmp1_;
	_tmp2_ = self->priv->parent_c_identifier;
	if (g_str_has_suffix (_tmp2_, "Private")) {
		_g_free0 (self->priv->parent_c_identifier);
		self->priv->parent_c_identifier = NULL;
		valadoc_importer_gir_documentation_importer_skip_element (self);
		return;
	}
	_tmp3_ = self->priv->reader;
	_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:is-gtype-struct-for");
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != NULL;
	_g_free0 (_tmp5_);
	is_type_struct = _tmp6_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp7_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp7_;
	_tmp8_ = is_type_struct;
	if (_tmp8_ == FALSE) {
		const gchar* _tmp9_;
		ValadocApiGirSourceComment* _tmp10_;
		_tmp9_ = self->priv->parent_c_identifier;
		_tmp10_ = comment;
		valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp9_, _tmp10_, NULL, 0, NULL, 0, NULL, 0, NULL, 0, -1);
	}
	while (TRUE) {
		ValaMarkupTokenType _tmp11_;
		ValaMarkupReader* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = self->priv->current_token;
		if (!(_tmp11_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp12_ = self->priv->reader;
		_tmp13_ = vala_markup_reader_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		if (g_strcmp0 (_tmp14_, "field") == 0) {
			valadoc_importer_gir_documentation_importer_parse_field (self);
		} else {
			ValaMarkupReader* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp15_ = self->priv->reader;
			_tmp16_ = vala_markup_reader_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			if (g_strcmp0 (_tmp17_, "constructor") == 0) {
				valadoc_importer_gir_documentation_importer_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				if (g_strcmp0 (_tmp20_, "method") == 0) {
					valadoc_importer_gir_documentation_importer_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					_tmp21_ = self->priv->reader;
					_tmp22_ = vala_markup_reader_get_name (_tmp21_);
					_tmp23_ = _tmp22_;
					if (g_strcmp0 (_tmp23_, "function") == 0) {
						valadoc_importer_gir_documentation_importer_skip_element (self);
					} else {
						ValaMarkupReader* _tmp24_;
						const gchar* _tmp25_;
						const gchar* _tmp26_;
						_tmp24_ = self->priv->reader;
						_tmp25_ = vala_markup_reader_get_name (_tmp24_);
						_tmp26_ = _tmp25_;
						if (g_strcmp0 (_tmp26_, "union") == 0) {
							valadoc_importer_gir_documentation_importer_parse_union (self);
						} else {
							ValaMarkupReader* _tmp27_;
							const gchar* _tmp28_;
							const gchar* _tmp29_;
							gchar* _tmp30_;
							gchar* _tmp31_;
							_tmp27_ = self->priv->reader;
							_tmp28_ = vala_markup_reader_get_name (_tmp27_);
							_tmp29_ = _tmp28_;
							_tmp30_ = g_strdup_printf ("unknown child element `%s' in `record'", _tmp29_);
							_tmp31_ = _tmp30_;
							valadoc_importer_gir_documentation_importer_error (self, _tmp31_);
							_g_free0 (_tmp31_);
							valadoc_importer_gir_documentation_importer_skip_element (self);
						}
					}
				}
			}
		}
	}
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = NULL;
	valadoc_importer_gir_documentation_importer_end_element (self, "record");
	_valadoc_api_source_comment_unref0 (comment);
}


static void
valadoc_importer_gir_documentation_importer_parse_class (ValadocImporterGirDocumentationImporter* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp2_;
	const gchar* _tmp3_;
	ValadocApiGirSourceComment* _tmp4_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "class");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = _tmp1_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp2_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp2_;
	_tmp3_ = self->priv->parent_c_identifier;
	_tmp4_ = comment;
	valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp3_, _tmp4_, NULL, 0, NULL, 0, NULL, 0, NULL, 0, -1);
	while (TRUE) {
		ValaMarkupTokenType _tmp5_;
		ValaMarkupReader* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = self->priv->current_token;
		if (!(_tmp5_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp6_ = self->priv->reader;
		_tmp7_ = vala_markup_reader_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		if (g_strcmp0 (_tmp8_, "implements") == 0) {
			valadoc_importer_gir_documentation_importer_skip_element (self);
		} else {
			ValaMarkupReader* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp9_ = self->priv->reader;
			_tmp10_ = vala_markup_reader_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, "constant") == 0) {
				valadoc_importer_gir_documentation_importer_parse_constant (self);
			} else {
				ValaMarkupReader* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp12_ = self->priv->reader;
				_tmp13_ = vala_markup_reader_get_name (_tmp12_);
				_tmp14_ = _tmp13_;
				if (g_strcmp0 (_tmp14_, "field") == 0) {
					valadoc_importer_gir_documentation_importer_parse_field (self);
				} else {
					ValaMarkupReader* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					_tmp15_ = self->priv->reader;
					_tmp16_ = vala_markup_reader_get_name (_tmp15_);
					_tmp17_ = _tmp16_;
					if (g_strcmp0 (_tmp17_, "property") == 0) {
						valadoc_importer_gir_documentation_importer_parse_property (self);
					} else {
						ValaMarkupReader* _tmp18_;
						const gchar* _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = self->priv->reader;
						_tmp19_ = vala_markup_reader_get_name (_tmp18_);
						_tmp20_ = _tmp19_;
						if (g_strcmp0 (_tmp20_, "constructor") == 0) {
							valadoc_importer_gir_documentation_importer_parse_constructor (self);
						} else {
							ValaMarkupReader* _tmp21_;
							const gchar* _tmp22_;
							const gchar* _tmp23_;
							_tmp21_ = self->priv->reader;
							_tmp22_ = vala_markup_reader_get_name (_tmp21_);
							_tmp23_ = _tmp22_;
							if (g_strcmp0 (_tmp23_, "function") == 0) {
								valadoc_importer_gir_documentation_importer_parse_method (self, "function");
							} else {
								ValaMarkupReader* _tmp24_;
								const gchar* _tmp25_;
								const gchar* _tmp26_;
								_tmp24_ = self->priv->reader;
								_tmp25_ = vala_markup_reader_get_name (_tmp24_);
								_tmp26_ = _tmp25_;
								if (g_strcmp0 (_tmp26_, "method") == 0) {
									valadoc_importer_gir_documentation_importer_parse_method (self, "method");
								} else {
									ValaMarkupReader* _tmp27_;
									const gchar* _tmp28_;
									const gchar* _tmp29_;
									_tmp27_ = self->priv->reader;
									_tmp28_ = vala_markup_reader_get_name (_tmp27_);
									_tmp29_ = _tmp28_;
									if (g_strcmp0 (_tmp29_, "virtual-method") == 0) {
										valadoc_importer_gir_documentation_importer_parse_method (self, "virtual-method");
									} else {
										ValaMarkupReader* _tmp30_;
										const gchar* _tmp31_;
										const gchar* _tmp32_;
										_tmp30_ = self->priv->reader;
										_tmp31_ = vala_markup_reader_get_name (_tmp30_);
										_tmp32_ = _tmp31_;
										if (g_strcmp0 (_tmp32_, "union") == 0) {
											valadoc_importer_gir_documentation_importer_parse_union (self);
										} else {
											ValaMarkupReader* _tmp33_;
											const gchar* _tmp34_;
											const gchar* _tmp35_;
											_tmp33_ = self->priv->reader;
											_tmp34_ = vala_markup_reader_get_name (_tmp33_);
											_tmp35_ = _tmp34_;
											if (g_strcmp0 (_tmp35_, "glib:signal") == 0) {
												valadoc_importer_gir_documentation_importer_parse_signal (self);
											} else {
												ValaMarkupReader* _tmp36_;
												const gchar* _tmp37_;
												const gchar* _tmp38_;
												gchar* _tmp39_;
												gchar* _tmp40_;
												_tmp36_ = self->priv->reader;
												_tmp37_ = vala_markup_reader_get_name (_tmp36_);
												_tmp38_ = _tmp37_;
												_tmp39_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp38_);
												_tmp40_ = _tmp39_;
												valadoc_importer_gir_documentation_importer_error (self, _tmp40_);
												_g_free0 (_tmp40_);
												valadoc_importer_gir_documentation_importer_skip_element (self);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = NULL;
	valadoc_importer_gir_documentation_importer_end_element (self, "class");
	_valadoc_api_source_comment_unref0 (comment);
}


static void
valadoc_importer_gir_documentation_importer_parse_interface (ValadocImporterGirDocumentationImporter* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp2_;
	const gchar* _tmp3_;
	ValadocApiGirSourceComment* _tmp4_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "interface");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = _tmp1_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp2_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp2_;
	_tmp3_ = self->priv->parent_c_identifier;
	_tmp4_ = comment;
	valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp3_, _tmp4_, NULL, 0, NULL, 0, NULL, 0, NULL, 0, -1);
	while (TRUE) {
		ValaMarkupTokenType _tmp5_;
		ValaMarkupReader* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = self->priv->current_token;
		if (!(_tmp5_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp6_ = self->priv->reader;
		_tmp7_ = vala_markup_reader_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		if (g_strcmp0 (_tmp8_, "prerequisite") == 0) {
			valadoc_importer_gir_documentation_importer_skip_element (self);
		} else {
			ValaMarkupReader* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp9_ = self->priv->reader;
			_tmp10_ = vala_markup_reader_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, "field") == 0) {
				valadoc_importer_gir_documentation_importer_parse_field (self);
			} else {
				ValaMarkupReader* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp12_ = self->priv->reader;
				_tmp13_ = vala_markup_reader_get_name (_tmp12_);
				_tmp14_ = _tmp13_;
				if (g_strcmp0 (_tmp14_, "property") == 0) {
					valadoc_importer_gir_documentation_importer_parse_property (self);
				} else {
					ValaMarkupReader* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					_tmp15_ = self->priv->reader;
					_tmp16_ = vala_markup_reader_get_name (_tmp15_);
					_tmp17_ = _tmp16_;
					if (g_strcmp0 (_tmp17_, "virtual-method") == 0) {
						valadoc_importer_gir_documentation_importer_parse_method (self, "virtual-method");
					} else {
						ValaMarkupReader* _tmp18_;
						const gchar* _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = self->priv->reader;
						_tmp19_ = vala_markup_reader_get_name (_tmp18_);
						_tmp20_ = _tmp19_;
						if (g_strcmp0 (_tmp20_, "function") == 0) {
							valadoc_importer_gir_documentation_importer_parse_method (self, "function");
						} else {
							ValaMarkupReader* _tmp21_;
							const gchar* _tmp22_;
							const gchar* _tmp23_;
							_tmp21_ = self->priv->reader;
							_tmp22_ = vala_markup_reader_get_name (_tmp21_);
							_tmp23_ = _tmp22_;
							if (g_strcmp0 (_tmp23_, "method") == 0) {
								valadoc_importer_gir_documentation_importer_parse_method (self, "method");
							} else {
								ValaMarkupReader* _tmp24_;
								const gchar* _tmp25_;
								const gchar* _tmp26_;
								_tmp24_ = self->priv->reader;
								_tmp25_ = vala_markup_reader_get_name (_tmp24_);
								_tmp26_ = _tmp25_;
								if (g_strcmp0 (_tmp26_, "glib:signal") == 0) {
									valadoc_importer_gir_documentation_importer_parse_signal (self);
								} else {
									ValaMarkupReader* _tmp27_;
									const gchar* _tmp28_;
									const gchar* _tmp29_;
									gchar* _tmp30_;
									gchar* _tmp31_;
									_tmp27_ = self->priv->reader;
									_tmp28_ = vala_markup_reader_get_name (_tmp27_);
									_tmp29_ = _tmp28_;
									_tmp30_ = g_strdup_printf ("unknown child element `%s' in `interface'", _tmp29_);
									_tmp31_ = _tmp30_;
									valadoc_importer_gir_documentation_importer_error (self, _tmp31_);
									_g_free0 (_tmp31_);
									valadoc_importer_gir_documentation_importer_skip_element (self);
								}
							}
						}
					}
				}
			}
		}
	}
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = NULL;
	valadoc_importer_gir_documentation_importer_end_element (self, "interface");
	_valadoc_api_source_comment_unref0 (comment);
}


static void
valadoc_importer_gir_documentation_importer_parse_field (ValadocImporterGirDocumentationImporter* self)
{
	gchar* c_identifier = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocApiGirSourceComment* _tmp8_;
	ValadocApiGirSourceComment* _tmp9_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "field");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	c_identifier = _tmp1_;
	_tmp2_ = self->priv->parent_c_identifier;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = self->priv->parent_c_identifier;
		_tmp4_ = g_strconcat (_tmp3_, ".", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = c_identifier;
		_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
		_g_free0 (c_identifier);
		c_identifier = _tmp7_;
		_g_free0 (_tmp5_);
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp8_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	_tmp9_ = _tmp8_;
	_valadoc_api_source_comment_unref0 (_tmp9_);
	valadoc_importer_gir_documentation_importer_parse_type (self, NULL);
	valadoc_importer_gir_documentation_importer_end_element (self, "field");
	_g_free0 (c_identifier);
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally18;
	__catch18_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally18:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


static void
valadoc_importer_gir_documentation_importer_parse_property (ValadocImporterGirDocumentationImporter* self)
{
	gchar* c_identifier = NULL;
	const gchar* _tmp0_;
	ValaMarkupReader* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp8_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "property");
	_tmp0_ = self->priv->parent_c_identifier;
	_tmp1_ = self->priv->reader;
	_tmp2_ = vala_markup_reader_get_attribute (_tmp1_, "name");
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s:%s", _tmp0_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	c_identifier = _tmp7_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp8_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp8_;
	valadoc_importer_gir_documentation_importer_attach_comment (self, c_identifier, comment, NULL, 0, NULL, 0, NULL, 0, NULL, 0, -1);
	valadoc_importer_gir_documentation_importer_parse_type (self, NULL);
	valadoc_importer_gir_documentation_importer_end_element (self, "property");
	_valadoc_api_source_comment_unref0 (comment);
	_g_free0 (c_identifier);
}


static void
valadoc_importer_gir_documentation_importer_parse_callback (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_parse_function (self, "callback");
}


static void
valadoc_importer_gir_documentation_importer_parse_constructor (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_parse_function (self, "constructor");
}


static void
_vala_array_add3 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add4 (ValadocImporterGirDocumentationImporterImplicitParameterPos* * array,
                  int* length,
                  int* size,
                  const ValadocImporterGirDocumentationImporterImplicitParameterPos* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValadocImporterGirDocumentationImporterImplicitParameterPos, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void
_vala_array_add5 (ValadocImporterGirDocumentationImporterImplicitParameterPos* * array,
                  int* length,
                  int* size,
                  const ValadocImporterGirDocumentationImporterImplicitParameterPos* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValadocImporterGirDocumentationImporterImplicitParameterPos, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void
_vala_array_add6 (ValadocImporterGirDocumentationImporterImplicitParameterPos* * array,
                  int* length,
                  int* size,
                  const ValadocImporterGirDocumentationImporterImplicitParameterPos* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValadocImporterGirDocumentationImporterImplicitParameterPos, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void
valadoc_importer_gir_documentation_importer_parse_function (ValadocImporterGirDocumentationImporter* self,
                                                            const gchar* element_name)
{
	gchar* c_identifier = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp21_;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* destroy_notifies = NULL;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp22_;
	gint destroy_notifies_length1;
	gint _destroy_notifies_size_;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* array_lengths = NULL;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp23_;
	gint array_lengths_length1;
	gint _array_lengths_size_;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* closures = NULL;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp24_;
	gint closures_length1;
	gint _closures_size_;
	gchar** param_names = NULL;
	gchar** _tmp25_;
	gint param_names_length1;
	gint _param_names_size_;
	gint array_length_ret = 0;
	gboolean _tmp26_ = FALSE;
	ValaMarkupTokenType _tmp27_;
	gboolean _tmp47_ = FALSE;
	ValaMarkupTokenType _tmp48_;
	const gchar* _tmp127_;
	ValadocApiGirSourceComment* _tmp128_;
	gchar** _tmp129_;
	gint _tmp129__length1;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp130_;
	gint _tmp130__length1;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp131_;
	gint _tmp131__length1;
	ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp132_;
	gint _tmp132__length1;
	gint _tmp133_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, element_name);
	c_identifier = NULL;
	_tmp0_ = element_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("constructor")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("function"))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("method"))))) {
		switch (0) {
			default:
			{
				ValaMarkupReader* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = self->priv->reader;
				_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "c:identifier");
				_g_free0 (c_identifier);
				c_identifier = _tmp4_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("callback")))) {
		switch (0) {
			default:
			{
				ValaMarkupReader* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = self->priv->reader;
				_tmp6_ = vala_markup_reader_get_attribute (_tmp5_, "c:type");
				_g_free0 (c_identifier);
				c_identifier = _tmp6_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("virtual-method")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				ValaMarkupReader* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp7_ = self->priv->parent_c_identifier;
				_tmp8_ = self->priv->reader;
				_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "name");
				_tmp10_ = _tmp9_;
				_tmp11_ = string_replace (_tmp10_, "-", "_");
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strdup_printf ("%s->%s", _tmp7_, _tmp12_);
				_g_free0 (c_identifier);
				c_identifier = _tmp13_;
				_g_free0 (_tmp12_);
				_g_free0 (_tmp10_);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("glib:signal")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp14_;
				ValaMarkupReader* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp14_ = self->priv->parent_c_identifier;
				_tmp15_ = self->priv->reader;
				_tmp16_ = vala_markup_reader_get_attribute (_tmp15_, "name");
				_tmp17_ = _tmp16_;
				_tmp18_ = string_replace (_tmp17_, "-", "_");
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strdup_printf ("%s::%s", _tmp14_, _tmp19_);
				_g_free0 (c_identifier);
				c_identifier = _tmp20_;
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				valadoc_importer_gir_documentation_importer_skip_element (self);
				_g_free0 (c_identifier);
				return;
			}
		}
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp21_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp21_;
	_tmp22_ = g_new0 (ValadocImporterGirDocumentationImporterImplicitParameterPos, 0);
	destroy_notifies = _tmp22_;
	destroy_notifies_length1 = 0;
	_destroy_notifies_size_ = destroy_notifies_length1;
	_tmp23_ = g_new0 (ValadocImporterGirDocumentationImporterImplicitParameterPos, 0);
	array_lengths = _tmp23_;
	array_lengths_length1 = 0;
	_array_lengths_size_ = array_lengths_length1;
	_tmp24_ = g_new0 (ValadocImporterGirDocumentationImporterImplicitParameterPos, 0);
	closures = _tmp24_;
	closures_length1 = 0;
	_closures_size_ = closures_length1;
	_tmp25_ = g_new0 (gchar*, 0 + 1);
	param_names = _tmp25_;
	param_names_length1 = 0;
	_param_names_size_ = param_names_length1;
	array_length_ret = -1;
	_tmp27_ = self->priv->current_token;
	if (_tmp27_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		_tmp28_ = self->priv->reader;
		_tmp29_ = vala_markup_reader_get_name (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp26_ = g_strcmp0 (_tmp30_, "return-value") == 0;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		ValadocApiSourceComment* return_comment = NULL;
		ValadocApiSourceComment* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		ValadocApiSourceComment* _tmp33_;
		valadoc_importer_gir_documentation_importer_parse_return_value (self, &_tmp31_, &_tmp32_);
		_valadoc_api_source_comment_unref0 (return_comment);
		return_comment = _tmp31_;
		array_length_ret = _tmp32_;
		_tmp33_ = return_comment;
		if (_tmp33_ != NULL) {
			ValadocApiGirSourceComment* _tmp34_;
			ValadocApiGirSourceComment* _tmp45_;
			ValadocApiSourceComment* _tmp46_;
			_tmp34_ = comment;
			if (_tmp34_ == NULL) {
				ValadocApiSourceFile* _tmp35_;
				ValaSourceLocation _tmp36_;
				gint _tmp37_;
				ValaSourceLocation _tmp38_;
				gint _tmp39_;
				ValaSourceLocation _tmp40_;
				gint _tmp41_;
				ValaSourceLocation _tmp42_;
				gint _tmp43_;
				ValadocApiGirSourceComment* _tmp44_;
				_tmp35_ = self->priv->file;
				_tmp36_ = self->priv->begin;
				_tmp37_ = _tmp36_.line;
				_tmp38_ = self->priv->begin;
				_tmp39_ = _tmp38_.column;
				_tmp40_ = self->priv->end;
				_tmp41_ = _tmp40_.line;
				_tmp42_ = self->priv->end;
				_tmp43_ = _tmp42_.column;
				_tmp44_ = valadoc_api_gir_source_comment_new ("", _tmp35_, _tmp37_, _tmp39_, _tmp41_, _tmp43_);
				_valadoc_api_source_comment_unref0 (comment);
				comment = _tmp44_;
			}
			_tmp45_ = comment;
			_tmp46_ = return_comment;
			valadoc_api_gir_source_comment_set_return_comment (_tmp45_, _tmp46_);
		}
		_valadoc_api_source_comment_unref0 (return_comment);
	}
	_tmp48_ = self->priv->current_token;
	if (_tmp48_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		_tmp49_ = self->priv->reader;
		_tmp50_ = vala_markup_reader_get_name (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp47_ = g_strcmp0 (_tmp51_, "parameters") == 0;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		gboolean _tmp52_ = FALSE;
		ValaMarkupTokenType _tmp53_;
		valadoc_importer_gir_documentation_importer_start_element (self, "parameters");
		valadoc_importer_gir_documentation_importer_next (self);
		_tmp53_ = self->priv->current_token;
		if (_tmp53_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			ValaMarkupReader* _tmp54_;
			const gchar* _tmp55_;
			const gchar* _tmp56_;
			_tmp54_ = self->priv->reader;
			_tmp55_ = vala_markup_reader_get_name (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp52_ = g_strcmp0 (_tmp56_, "instance-parameter") == 0;
		} else {
			_tmp52_ = FALSE;
		}
		if (_tmp52_) {
			gchar* instance_param_name = NULL;
			ValaMarkupReader* _tmp57_;
			gchar* _tmp58_;
			ValadocApiSourceComment* param_comment = NULL;
			ValadocApiSourceComment* _tmp59_;
			ValadocApiSourceComment* _tmp60_;
			_tmp57_ = self->priv->reader;
			_tmp58_ = vala_markup_reader_get_attribute (_tmp57_, "name");
			instance_param_name = _tmp58_;
			valadoc_importer_gir_documentation_importer_next (self);
			_tmp59_ = valadoc_importer_gir_documentation_importer_parse_doc (self, "doc");
			param_comment = _tmp59_;
			valadoc_importer_gir_documentation_importer_parse_type (self, NULL);
			valadoc_importer_gir_documentation_importer_end_element (self, "instance-parameter");
			_tmp60_ = param_comment;
			if (_tmp60_ != NULL) {
				ValadocApiGirSourceComment* _tmp61_;
				ValadocApiGirSourceComment* _tmp72_;
				const gchar* _tmp73_;
				ValadocApiSourceComment* _tmp74_;
				ValadocApiGirSourceComment* _tmp75_;
				const gchar* _tmp76_;
				_tmp61_ = comment;
				if (_tmp61_ == NULL) {
					ValadocApiSourceFile* _tmp62_;
					ValaSourceLocation _tmp63_;
					gint _tmp64_;
					ValaSourceLocation _tmp65_;
					gint _tmp66_;
					ValaSourceLocation _tmp67_;
					gint _tmp68_;
					ValaSourceLocation _tmp69_;
					gint _tmp70_;
					ValadocApiGirSourceComment* _tmp71_;
					_tmp62_ = self->priv->file;
					_tmp63_ = self->priv->begin;
					_tmp64_ = _tmp63_.line;
					_tmp65_ = self->priv->begin;
					_tmp66_ = _tmp65_.column;
					_tmp67_ = self->priv->end;
					_tmp68_ = _tmp67_.line;
					_tmp69_ = self->priv->end;
					_tmp70_ = _tmp69_.column;
					_tmp71_ = valadoc_api_gir_source_comment_new ("", _tmp62_, _tmp64_, _tmp66_, _tmp68_, _tmp70_);
					_valadoc_api_source_comment_unref0 (comment);
					comment = _tmp71_;
				}
				_tmp72_ = comment;
				_tmp73_ = instance_param_name;
				_tmp74_ = param_comment;
				valadoc_api_gir_source_comment_add_parameter_content (_tmp72_, _tmp73_, _tmp74_);
				_tmp75_ = comment;
				_tmp76_ = instance_param_name;
				valadoc_api_gir_source_comment_set_instance_param_name (_tmp75_, _tmp76_);
			}
			_valadoc_api_source_comment_unref0 (param_comment);
			_g_free0 (instance_param_name);
		}
		{
			gint pcount = 0;
			pcount = 0;
			{
				gboolean _tmp77_ = FALSE;
				_tmp77_ = TRUE;
				while (TRUE) {
					ValaMarkupTokenType _tmp79_;
					ValadocApiSourceComment* param_comment = NULL;
					gint array_length_pos = 0;
					gint destroy_pos = 0;
					gint closure_pos = 0;
					gchar* param_name = NULL;
					ValadocApiSourceComment* _tmp80_ = NULL;
					gchar* _tmp81_ = NULL;
					gint _tmp82_ = 0;
					gint _tmp83_ = 0;
					gint _tmp84_ = 0;
					gchar** _tmp85_;
					gint _tmp85__length1;
					const gchar* _tmp86_;
					gchar* _tmp87_;
					gboolean _tmp88_ = FALSE;
					gint _tmp89_;
					gboolean _tmp96_ = FALSE;
					gint _tmp97_;
					gboolean _tmp104_ = FALSE;
					gint _tmp105_;
					ValadocApiSourceComment* _tmp112_;
					if (!_tmp77_) {
						gint _tmp78_;
						_tmp78_ = pcount;
						pcount = _tmp78_ + 1;
					}
					_tmp77_ = FALSE;
					_tmp79_ = self->priv->current_token;
					if (!(_tmp79_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
						break;
					}
					valadoc_importer_gir_documentation_importer_parse_parameter (self, &_tmp80_, &_tmp81_, &_tmp82_, &_tmp83_, &_tmp84_);
					_valadoc_api_source_comment_unref0 (param_comment);
					param_comment = _tmp80_;
					_g_free0 (param_name);
					param_name = _tmp81_;
					destroy_pos = _tmp82_;
					closure_pos = _tmp83_;
					array_length_pos = _tmp84_;
					_tmp85_ = param_names;
					_tmp85__length1 = param_names_length1;
					_tmp86_ = param_name;
					_tmp87_ = g_strdup (_tmp86_);
					_vala_array_add3 (&param_names, &param_names_length1, &_param_names_size_, _tmp87_);
					_tmp89_ = destroy_pos;
					if (_tmp89_ >= 0) {
						gint _tmp90_;
						gint _tmp91_;
						_tmp90_ = pcount;
						_tmp91_ = destroy_pos;
						_tmp88_ = _tmp90_ != _tmp91_;
					} else {
						_tmp88_ = FALSE;
					}
					if (_tmp88_) {
						ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp92_;
						gint _tmp92__length1;
						gint _tmp93_;
						gint _tmp94_;
						ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp95_ = {0};
						_tmp92_ = destroy_notifies;
						_tmp92__length1 = destroy_notifies_length1;
						_tmp93_ = pcount;
						_tmp94_ = destroy_pos;
						valadoc_importer_gir_documentation_importer_implicit_parameter_pos_init (&_tmp95_, _tmp93_, _tmp94_);
						_vala_array_add4 (&destroy_notifies, &destroy_notifies_length1, &_destroy_notifies_size_, &_tmp95_);
					}
					_tmp97_ = closure_pos;
					if (_tmp97_ >= 0) {
						gint _tmp98_;
						gint _tmp99_;
						_tmp98_ = pcount;
						_tmp99_ = closure_pos;
						_tmp96_ = _tmp98_ != _tmp99_;
					} else {
						_tmp96_ = FALSE;
					}
					if (_tmp96_) {
						ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp100_;
						gint _tmp100__length1;
						gint _tmp101_;
						gint _tmp102_;
						ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp103_ = {0};
						_tmp100_ = closures;
						_tmp100__length1 = closures_length1;
						_tmp101_ = pcount;
						_tmp102_ = closure_pos;
						valadoc_importer_gir_documentation_importer_implicit_parameter_pos_init (&_tmp103_, _tmp101_, _tmp102_);
						_vala_array_add5 (&closures, &closures_length1, &_closures_size_, &_tmp103_);
					}
					_tmp105_ = array_length_pos;
					if (_tmp105_ >= 0) {
						gint _tmp106_;
						gint _tmp107_;
						_tmp106_ = pcount;
						_tmp107_ = destroy_pos;
						_tmp104_ = _tmp106_ != _tmp107_;
					} else {
						_tmp104_ = FALSE;
					}
					if (_tmp104_) {
						ValadocImporterGirDocumentationImporterImplicitParameterPos* _tmp108_;
						gint _tmp108__length1;
						gint _tmp109_;
						gint _tmp110_;
						ValadocImporterGirDocumentationImporterImplicitParameterPos _tmp111_ = {0};
						_tmp108_ = array_lengths;
						_tmp108__length1 = array_lengths_length1;
						_tmp109_ = pcount;
						_tmp110_ = array_length_pos;
						valadoc_importer_gir_documentation_importer_implicit_parameter_pos_init (&_tmp111_, _tmp109_, _tmp110_);
						_vala_array_add6 (&array_lengths, &array_lengths_length1, &_array_lengths_size_, &_tmp111_);
					}
					_tmp112_ = param_comment;
					if (_tmp112_ != NULL) {
						ValadocApiGirSourceComment* _tmp113_;
						ValadocApiGirSourceComment* _tmp124_;
						const gchar* _tmp125_;
						ValadocApiSourceComment* _tmp126_;
						_tmp113_ = comment;
						if (_tmp113_ == NULL) {
							ValadocApiSourceFile* _tmp114_;
							ValaSourceLocation _tmp115_;
							gint _tmp116_;
							ValaSourceLocation _tmp117_;
							gint _tmp118_;
							ValaSourceLocation _tmp119_;
							gint _tmp120_;
							ValaSourceLocation _tmp121_;
							gint _tmp122_;
							ValadocApiGirSourceComment* _tmp123_;
							_tmp114_ = self->priv->file;
							_tmp115_ = self->priv->begin;
							_tmp116_ = _tmp115_.line;
							_tmp117_ = self->priv->begin;
							_tmp118_ = _tmp117_.column;
							_tmp119_ = self->priv->end;
							_tmp120_ = _tmp119_.line;
							_tmp121_ = self->priv->end;
							_tmp122_ = _tmp121_.column;
							_tmp123_ = valadoc_api_gir_source_comment_new ("", _tmp114_, _tmp116_, _tmp118_, _tmp120_, _tmp122_);
							_valadoc_api_source_comment_unref0 (comment);
							comment = _tmp123_;
						}
						_tmp124_ = comment;
						_tmp125_ = param_name;
						_tmp126_ = param_comment;
						valadoc_api_gir_source_comment_add_parameter_content (_tmp124_, _tmp125_, _tmp126_);
					}
					_g_free0 (param_name);
					_valadoc_api_source_comment_unref0 (param_comment);
				}
			}
		}
		valadoc_importer_gir_documentation_importer_end_element (self, "parameters");
	}
	_tmp127_ = c_identifier;
	_tmp128_ = comment;
	_tmp129_ = param_names;
	_tmp129__length1 = param_names_length1;
	_tmp130_ = destroy_notifies;
	_tmp130__length1 = destroy_notifies_length1;
	_tmp131_ = closures;
	_tmp131__length1 = closures_length1;
	_tmp132_ = array_lengths;
	_tmp132__length1 = array_lengths_length1;
	_tmp133_ = array_length_ret;
	valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp127_, _tmp128_, _tmp129_, _tmp129__length1, _tmp130_, _tmp130__length1, _tmp131_, _tmp131__length1, _tmp132_, _tmp132__length1, _tmp133_);
	valadoc_importer_gir_documentation_importer_end_element (self, element_name);
	param_names = (_vala_array_free (param_names, param_names_length1, (GDestroyNotify) g_free), NULL);
	closures = (g_free (closures), NULL);
	array_lengths = (g_free (array_lengths), NULL);
	destroy_notifies = (g_free (destroy_notifies), NULL);
	_valadoc_api_source_comment_unref0 (comment);
	_g_free0 (c_identifier);
}


static void
valadoc_importer_gir_documentation_importer_parse_method (ValadocImporterGirDocumentationImporter* self,
                                                          const gchar* element_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	valadoc_importer_gir_documentation_importer_parse_function (self, element_name);
}


static void
valadoc_importer_gir_documentation_importer_parse_signal (ValadocImporterGirDocumentationImporter* self)
{
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_parse_function (self, "glib:signal");
}


static void
valadoc_importer_gir_documentation_importer_parse_boxed (ValadocImporterGirDocumentationImporter* self,
                                                         const gchar* element_name)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocApiGirSourceComment* _tmp5_;
	ValadocApiGirSourceComment* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = _tmp1_;
	_tmp2_ = self->priv->parent_c_identifier;
	if (_tmp2_ == NULL) {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:name");
		_g_free0 (self->priv->parent_c_identifier);
		self->priv->parent_c_identifier = _tmp4_;
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp5_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	_tmp6_ = _tmp5_;
	_valadoc_api_source_comment_unref0 (_tmp6_);
	while (TRUE) {
		ValaMarkupTokenType _tmp7_;
		ValaMarkupReader* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = self->priv->current_token;
		if (!(_tmp7_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp8_ = self->priv->reader;
		_tmp9_ = vala_markup_reader_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		if (g_strcmp0 (_tmp10_, "field") == 0) {
			valadoc_importer_gir_documentation_importer_parse_field (self);
		} else {
			ValaMarkupReader* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp11_ = self->priv->reader;
			_tmp12_ = vala_markup_reader_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			if (g_strcmp0 (_tmp13_, "constructor") == 0) {
				valadoc_importer_gir_documentation_importer_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp14_ = self->priv->reader;
				_tmp15_ = vala_markup_reader_get_name (_tmp14_);
				_tmp16_ = _tmp15_;
				if (g_strcmp0 (_tmp16_, "method") == 0) {
					valadoc_importer_gir_documentation_importer_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					_tmp17_ = self->priv->reader;
					_tmp18_ = vala_markup_reader_get_name (_tmp17_);
					_tmp19_ = _tmp18_;
					if (g_strcmp0 (_tmp19_, "function") == 0) {
						valadoc_importer_gir_documentation_importer_skip_element (self);
					} else {
						ValaMarkupReader* _tmp20_;
						const gchar* _tmp21_;
						const gchar* _tmp22_;
						_tmp20_ = self->priv->reader;
						_tmp21_ = vala_markup_reader_get_name (_tmp20_);
						_tmp22_ = _tmp21_;
						if (g_strcmp0 (_tmp22_, "union") == 0) {
							valadoc_importer_gir_documentation_importer_parse_union (self);
						} else {
							ValaMarkupReader* _tmp23_;
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							_tmp23_ = self->priv->reader;
							_tmp24_ = vala_markup_reader_get_name (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp25_);
							_tmp27_ = _tmp26_;
							valadoc_importer_gir_documentation_importer_error (self, _tmp27_);
							_g_free0 (_tmp27_);
							valadoc_importer_gir_documentation_importer_skip_element (self);
						}
					}
				}
			}
		}
	}
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = NULL;
	valadoc_importer_gir_documentation_importer_end_element (self, element_name);
}


static void
valadoc_importer_gir_documentation_importer_parse_union (ValadocImporterGirDocumentationImporter* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp3_;
	const gchar* _tmp4_;
	ValadocApiGirSourceComment* _tmp5_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "union");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = _tmp1_;
	_tmp2_ = self->priv->parent_c_identifier;
	if (_tmp2_ == NULL) {
		valadoc_importer_gir_documentation_importer_skip_element (self);
		return;
	}
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp3_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp3_;
	_tmp4_ = self->priv->parent_c_identifier;
	_tmp5_ = comment;
	valadoc_importer_gir_documentation_importer_attach_comment (self, _tmp4_, _tmp5_, NULL, 0, NULL, 0, NULL, 0, NULL, 0, -1);
	while (TRUE) {
		ValaMarkupTokenType _tmp6_;
		ValaMarkupReader* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = self->priv->current_token;
		if (!(_tmp6_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp7_ = self->priv->reader;
		_tmp8_ = vala_markup_reader_get_name (_tmp7_);
		_tmp9_ = _tmp8_;
		if (g_strcmp0 (_tmp9_, "field") == 0) {
			valadoc_importer_gir_documentation_importer_parse_field (self);
		} else {
			ValaMarkupReader* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = self->priv->reader;
			_tmp11_ = vala_markup_reader_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			if (g_strcmp0 (_tmp12_, "constructor") == 0) {
				valadoc_importer_gir_documentation_importer_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp13_ = self->priv->reader;
				_tmp14_ = vala_markup_reader_get_name (_tmp13_);
				_tmp15_ = _tmp14_;
				if (g_strcmp0 (_tmp15_, "method") == 0) {
					valadoc_importer_gir_documentation_importer_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					_tmp16_ = self->priv->reader;
					_tmp17_ = vala_markup_reader_get_name (_tmp16_);
					_tmp18_ = _tmp17_;
					if (g_strcmp0 (_tmp18_, "function") == 0) {
						valadoc_importer_gir_documentation_importer_skip_element (self);
					} else {
						ValaMarkupReader* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						_tmp19_ = self->priv->reader;
						_tmp20_ = vala_markup_reader_get_name (_tmp19_);
						_tmp21_ = _tmp20_;
						if (g_strcmp0 (_tmp21_, "record") == 0) {
							valadoc_importer_gir_documentation_importer_parse_record (self);
						} else {
							ValaMarkupReader* _tmp22_;
							const gchar* _tmp23_;
							const gchar* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
							_tmp22_ = self->priv->reader;
							_tmp23_ = vala_markup_reader_get_name (_tmp22_);
							_tmp24_ = _tmp23_;
							_tmp25_ = g_strdup_printf ("unknown child element `%s' in `union'", _tmp24_);
							_tmp26_ = _tmp25_;
							valadoc_importer_gir_documentation_importer_error (self, _tmp26_);
							_g_free0 (_tmp26_);
							valadoc_importer_gir_documentation_importer_skip_element (self);
						}
					}
				}
			}
		}
	}
	_g_free0 (self->priv->parent_c_identifier);
	self->priv->parent_c_identifier = NULL;
	valadoc_importer_gir_documentation_importer_end_element (self, "union");
	_valadoc_api_source_comment_unref0 (comment);
}


static void
valadoc_importer_gir_documentation_importer_parse_constant (ValadocImporterGirDocumentationImporter* self)
{
	gchar* c_identifier = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	ValadocApiGirSourceComment* comment = NULL;
	ValadocApiGirSourceComment* _tmp2_;
	g_return_if_fail (self != NULL);
	valadoc_importer_gir_documentation_importer_start_element (self, "constant");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:type");
	c_identifier = _tmp1_;
	valadoc_importer_gir_documentation_importer_next (self);
	_tmp2_ = valadoc_importer_gir_documentation_importer_parse_symbol_doc (self);
	comment = _tmp2_;
	valadoc_importer_gir_documentation_importer_attach_comment (self, c_identifier, comment, NULL, 0, NULL, 0, NULL, 0, NULL, 0, -1);
	valadoc_importer_gir_documentation_importer_parse_type (self, NULL);
	valadoc_importer_gir_documentation_importer_end_element (self, "constant");
	_valadoc_api_source_comment_unref0 (comment);
	_g_free0 (c_identifier);
}


static const gchar*
valadoc_importer_gir_documentation_importer_real_get_file_extension (ValadocImporterDocumentationImporter* base)
{
	const gchar* result;
	ValadocImporterGirDocumentationImporter* self;
	self = (ValadocImporterGirDocumentationImporter*) base;
	result = "gir";
	return result;
}


static void
valadoc_importer_gir_documentation_importer_implicit_parameter_pos_init (ValadocImporterGirDocumentationImporterImplicitParameterPos *self,
                                                                         gint parameter,
                                                                         gint position)
{
	memset (self, 0, sizeof (ValadocImporterGirDocumentationImporterImplicitParameterPos));
	(*self).parameter = parameter;
	(*self).position = position;
}


static ValadocImporterGirDocumentationImporterImplicitParameterPos*
valadoc_importer_gir_documentation_importer_implicit_parameter_pos_dup (const ValadocImporterGirDocumentationImporterImplicitParameterPos* self)
{
	ValadocImporterGirDocumentationImporterImplicitParameterPos* dup;
	dup = g_new0 (ValadocImporterGirDocumentationImporterImplicitParameterPos, 1);
	memcpy (dup, self, sizeof (ValadocImporterGirDocumentationImporterImplicitParameterPos));
	return dup;
}


static void
valadoc_importer_gir_documentation_importer_implicit_parameter_pos_free (ValadocImporterGirDocumentationImporterImplicitParameterPos* self)
{
	g_free (self);
}


static GType
valadoc_importer_gir_documentation_importer_implicit_parameter_pos_get_type (void)
{
	static volatile gsize valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id__volatile)) {
		GType valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id;
		valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id = g_boxed_type_register_static ("ValadocImporterGirDocumentationImporterImplicitParameterPos", (GBoxedCopyFunc) valadoc_importer_gir_documentation_importer_implicit_parameter_pos_dup, (GBoxedFreeFunc) valadoc_importer_gir_documentation_importer_implicit_parameter_pos_free);
		g_once_init_leave (&valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id__volatile, valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id);
	}
	return valadoc_importer_gir_documentation_importer_implicit_parameter_pos_type_id__volatile;
}


static void
valadoc_importer_gir_documentation_importer_class_init (ValadocImporterGirDocumentationImporterClass * klass)
{
	valadoc_importer_gir_documentation_importer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocImporterGirDocumentationImporterPrivate));
	((ValadocImporterDocumentationImporterClass *) klass)->process = (void (*) (ValadocImporterDocumentationImporter*, const gchar*)) valadoc_importer_gir_documentation_importer_real_process;
	VALADOC_IMPORTER_DOCUMENTATION_IMPORTER_CLASS (klass)->get_file_extension = valadoc_importer_gir_documentation_importer_real_get_file_extension;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_importer_gir_documentation_importer_get_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_importer_gir_documentation_importer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_FILE_EXTENSION_PROPERTY, valadoc_importer_gir_documentation_importer_properties[VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_FILE_EXTENSION_PROPERTY] = g_param_spec_string ("file-extension", "file-extension", "file-extension", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
valadoc_importer_gir_documentation_importer_instance_init (ValadocImporterGirDocumentationImporter * self)
{
	self->priv = VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_GET_PRIVATE (self);
}


static void
valadoc_importer_gir_documentation_importer_finalize (GObject * obj)
{
	ValadocImporterGirDocumentationImporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_IMPORTER_TYPE_GIR_DOCUMENTATION_IMPORTER, ValadocImporterGirDocumentationImporter);
	_vala_markup_reader_unref0 (self->priv->reader);
	_g_object_unref0 (self->priv->parser);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->parent_c_identifier);
	G_OBJECT_CLASS (valadoc_importer_gir_documentation_importer_parent_class)->finalize (obj);
}


GType
valadoc_importer_gir_documentation_importer_get_type (void)
{
	static volatile gsize valadoc_importer_gir_documentation_importer_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_importer_gir_documentation_importer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocImporterGirDocumentationImporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_importer_gir_documentation_importer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocImporterGirDocumentationImporter), 0, (GInstanceInitFunc) valadoc_importer_gir_documentation_importer_instance_init, NULL };
		GType valadoc_importer_gir_documentation_importer_type_id;
		valadoc_importer_gir_documentation_importer_type_id = g_type_register_static (VALADOC_IMPORTER_TYPE_DOCUMENTATION_IMPORTER, "ValadocImporterGirDocumentationImporter", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_importer_gir_documentation_importer_type_id__volatile, valadoc_importer_gir_documentation_importer_type_id);
	}
	return valadoc_importer_gir_documentation_importer_type_id__volatile;
}


static void
_vala_valadoc_importer_gir_documentation_importer_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec)
{
	ValadocImporterGirDocumentationImporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_IMPORTER_TYPE_GIR_DOCUMENTATION_IMPORTER, ValadocImporterGirDocumentationImporter);
	switch (property_id) {
		case VALADOC_IMPORTER_GIR_DOCUMENTATION_IMPORTER_FILE_EXTENSION_PROPERTY:
		g_value_set_string (value, valadoc_importer_documentation_importer_get_file_extension ((ValadocImporterDocumentationImporter*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



