/* valadatatype.c generated by valac, the Vala compiler
 * generated from valadatatype.vala, do not modify */

/* valadatatype.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_scope_unref0(var) ((var == NULL) ? NULL : (var = (vala_scope_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaDataTypePrivate {
	gboolean _value_owned;
	gboolean _nullable;
	ValaTypeSymbol* _data_type;
	gboolean _floating_reference;
	gboolean _is_dynamic;
	ValaList* type_argument_list;
};


static gpointer vala_data_type_parent_class = NULL;
static ValaList* vala_data_type__empty_type_list;
static ValaList* vala_data_type__empty_type_list = NULL;

#define VALA_DATA_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DATA_TYPE, ValaDataTypePrivate))
static void vala_data_type_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_data_type_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gchar* vala_data_type_real_to_string (ValaCodeNode* base);
static gchar* vala_data_type_real_to_qualified_string (ValaDataType* self,
                                                ValaScope* scope);
static ValaDataType* vala_data_type_real_copy (ValaDataType* self);
static gboolean vala_data_type_real_equals (ValaDataType* self,
                                     ValaDataType* type2);
static gboolean vala_data_type_real_stricter (ValaDataType* self,
                                       ValaDataType* type2);
static void vala_data_type_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_data_type_real_compatible (ValaDataType* self,
                                         ValaDataType* target_type);
G_GNUC_INTERNAL ValaDataType* vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type,
                                                                        ValaTypeSymbol* type_symbol,
                                                                        ValaCodeNode* node_reference);
static gboolean vala_data_type_real_is_invokable (ValaDataType* self);
static ValaDataType* vala_data_type_real_get_return_type (ValaDataType* self);
static ValaList* vala_data_type_real_get_parameters (ValaDataType* self);
static gboolean vala_data_type_real_is_reference_type_or_type_parameter (ValaDataType* self);
static gboolean vala_data_type_real_is_array (ValaDataType* self);
static gboolean vala_data_type_real_is_accessible (ValaDataType* self,
                                            ValaSymbol* sym);
static ValaSymbol* vala_data_type_real_get_member (ValaDataType* self,
                                            const gchar* member_name);
static ValaSymbol* vala_data_type_real_get_pointer_member (ValaDataType* self,
                                                    const gchar* member_name);
static gboolean vala_data_type_real_is_real_struct_type (ValaDataType* self);
static gboolean vala_data_type_real_is_disposable (ValaDataType* self);
static ValaDataType* vala_data_type_real_get_actual_type (ValaDataType* self,
                                                   ValaDataType* derived_instance_type,
                                                   ValaList* method_type_arguments,
                                                   ValaCodeNode* node_reference);
static ValaDataType* vala_data_type_real_infer_type_argument (ValaDataType* self,
                                                       ValaTypeParameter* type_param,
                                                       ValaDataType* value_type);
static gchar* vala_data_type_real_to_prototype_string (ValaDataType* self,
                                                const gchar* override_name);
static void vala_data_type_finalize (ValaCodeNode * obj);


/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_data_type_add_type_argument (ValaDataType* self,
                                  ValaDataType* arg)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_argument_list);
		self->priv->type_argument_list = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp3_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_data_type_get_type_arguments (ValaDataType* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->type_argument_list;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_data_type__empty_type_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_data_type__empty_type_list);
		vala_data_type__empty_type_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_data_type__empty_type_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


gboolean
vala_data_type_has_type_arguments (ValaDataType* self)
{
	gboolean result = FALSE;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->type_argument_list;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_ > 0;
	return result;
}


/**
 * Removes all generic type arguments.
 */
void
vala_data_type_remove_all_type_arguments (ValaDataType* self)
{
	g_return_if_fail (self != NULL);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	self->priv->type_argument_list = NULL;
}


static void
vala_data_type_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaDataType * self;
	self = (ValaDataType*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_data_type (visitor, self);
}


static void
vala_data_type_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaDataType * self;
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	self = (ValaDataType*) base;
	g_return_if_fail (visitor != NULL);
	_tmp1_ = self->priv->type_argument_list;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_argument_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp5_;
			ValaList* _tmp6_;
			gint _type_arg_size = 0;
			ValaList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _type_arg_index = 0;
			_tmp5_ = self->priv->type_argument_list;
			_tmp6_ = _vala_iterable_ref0 (_tmp5_);
			_type_arg_list = _tmp6_;
			_tmp7_ = _type_arg_list;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_type_arg_size = _tmp9_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp13_;
				gint _tmp14_;
				gpointer _tmp15_;
				ValaDataType* _tmp16_;
				_tmp10_ = _type_arg_index;
				_type_arg_index = _tmp10_ + 1;
				_tmp11_ = _type_arg_index;
				_tmp12_ = _type_arg_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _type_arg_list;
				_tmp14_ = _type_arg_index;
				_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
				type_arg = (ValaDataType*) _tmp15_;
				_tmp16_ = type_arg;
				vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
	}
}


static gchar*
vala_data_type_real_to_string (ValaCodeNode* base)
{
	ValaDataType * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaDataType*) base;
	_tmp0_ = vala_data_type_to_qualified_string (self, NULL);
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_scope_ref0 (gpointer self)
{
	return self ? vala_scope_ref (self) : NULL;
}


static gchar*
vala_data_type_real_to_qualified_string (ValaDataType* self,
                                         ValaScope* scope)
{
	gchar* result = NULL;
	gchar* s = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaList* type_args = NULL;
	ValaList* _tmp36_;
	ValaList* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gboolean _tmp67_;
	_tmp0_ = self->priv->_data_type;
	if (_tmp0_ != NULL) {
		ValaSymbol* global_symbol = NULL;
		ValaTypeSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* sym = NULL;
		ValaScope* parent_scope = NULL;
		ValaScope* _tmp12_;
		gboolean _tmp25_ = FALSE;
		ValaSymbol* _tmp26_;
		_tmp1_ = self->priv->_data_type;
		_tmp2_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp1_);
		global_symbol = _tmp2_;
		while (TRUE) {
			ValaSymbol* _tmp3_;
			ValaSymbol* _tmp4_;
			ValaSymbol* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			ValaSymbol* _tmp8_;
			ValaSymbol* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSymbol* _tmp11_;
			_tmp3_ = global_symbol;
			_tmp4_ = vala_symbol_get_parent_symbol (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_symbol_get_name (_tmp5_);
			_tmp7_ = _tmp6_;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = global_symbol;
			_tmp9_ = vala_symbol_get_parent_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			_vala_code_node_unref0 (global_symbol);
			global_symbol = _tmp11_;
		}
		sym = NULL;
		_tmp12_ = _vala_scope_ref0 (scope);
		parent_scope = _tmp12_;
		while (TRUE) {
			gboolean _tmp13_ = FALSE;
			ValaSymbol* _tmp14_;
			ValaScope* _tmp16_;
			ValaSymbol* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaScope* _tmp21_;
			ValaScope* _tmp22_;
			ValaScope* _tmp23_;
			ValaScope* _tmp24_;
			_tmp14_ = sym;
			if (_tmp14_ == NULL) {
				ValaScope* _tmp15_;
				_tmp15_ = parent_scope;
				_tmp13_ = _tmp15_ != NULL;
			} else {
				_tmp13_ = FALSE;
			}
			if (!_tmp13_) {
				break;
			}
			_tmp16_ = parent_scope;
			_tmp17_ = global_symbol;
			_tmp18_ = vala_symbol_get_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_scope_lookup (_tmp16_, _tmp19_);
			_vala_code_node_unref0 (sym);
			sym = _tmp20_;
			_tmp21_ = parent_scope;
			_tmp22_ = vala_scope_get_parent_scope (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = _vala_scope_ref0 (_tmp23_);
			_vala_scope_unref0 (parent_scope);
			parent_scope = _tmp24_;
		}
		_tmp26_ = sym;
		if (_tmp26_ != NULL) {
			ValaSymbol* _tmp27_;
			ValaSymbol* _tmp28_;
			_tmp27_ = global_symbol;
			_tmp28_ = sym;
			_tmp25_ = _tmp27_ != _tmp28_;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaTypeSymbol* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp29_ = self->priv->_data_type;
			_tmp30_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strconcat ("global::", _tmp31_, NULL);
			_g_free0 (s);
			s = _tmp32_;
			_g_free0 (_tmp31_);
		} else {
			ValaTypeSymbol* _tmp33_;
			gchar* _tmp34_;
			_tmp33_ = self->priv->_data_type;
			_tmp34_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp33_);
			_g_free0 (s);
			s = _tmp34_;
		}
		_vala_scope_unref0 (parent_scope);
		_vala_code_node_unref0 (sym);
		_vala_code_node_unref0 (global_symbol);
	} else {
		gchar* _tmp35_;
		_tmp35_ = g_strdup ("null");
		_g_free0 (s);
		s = _tmp35_;
	}
	_tmp36_ = vala_data_type_get_type_arguments (self);
	type_args = _tmp36_;
	_tmp37_ = type_args;
	_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_ > 0) {
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gboolean first = FALSE;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp40_ = s;
		_tmp41_ = g_strconcat (_tmp40_, "<", NULL);
		_g_free0 (s);
		s = _tmp41_;
		first = TRUE;
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp42_;
			ValaList* _tmp43_;
			gint _type_arg_size = 0;
			ValaList* _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			gint _type_arg_index = 0;
			_tmp42_ = type_args;
			_tmp43_ = _vala_iterable_ref0 (_tmp42_);
			_type_arg_list = _tmp43_;
			_tmp44_ = _type_arg_list;
			_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
			_tmp46_ = _tmp45_;
			_type_arg_size = _tmp46_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp50_;
				gint _tmp51_;
				gpointer _tmp52_;
				gboolean _tmp53_;
				ValaDataType* _tmp56_;
				gboolean _tmp57_;
				const gchar* _tmp60_;
				ValaDataType* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				_tmp47_ = _type_arg_index;
				_type_arg_index = _tmp47_ + 1;
				_tmp48_ = _type_arg_index;
				_tmp49_ = _type_arg_size;
				if (!(_tmp48_ < _tmp49_)) {
					break;
				}
				_tmp50_ = _type_arg_list;
				_tmp51_ = _type_arg_index;
				_tmp52_ = vala_list_get (_tmp50_, _tmp51_);
				type_arg = (ValaDataType*) _tmp52_;
				_tmp53_ = first;
				if (!_tmp53_) {
					const gchar* _tmp54_;
					gchar* _tmp55_;
					_tmp54_ = s;
					_tmp55_ = g_strconcat (_tmp54_, ",", NULL);
					_g_free0 (s);
					s = _tmp55_;
				} else {
					first = FALSE;
				}
				_tmp56_ = type_arg;
				_tmp57_ = _tmp56_->priv->_value_owned;
				if (!_tmp57_) {
					const gchar* _tmp58_;
					gchar* _tmp59_;
					_tmp58_ = s;
					_tmp59_ = g_strconcat (_tmp58_, "weak ", NULL);
					_g_free0 (s);
					s = _tmp59_;
				}
				_tmp60_ = s;
				_tmp61_ = type_arg;
				_tmp62_ = vala_data_type_to_qualified_string (_tmp61_, scope);
				_tmp63_ = _tmp62_;
				_tmp64_ = g_strconcat (_tmp60_, _tmp63_, NULL);
				_g_free0 (s);
				s = _tmp64_;
				_g_free0 (_tmp63_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_tmp65_ = s;
		_tmp66_ = g_strconcat (_tmp65_, ">", NULL);
		_g_free0 (s);
		s = _tmp66_;
	}
	_tmp67_ = self->priv->_nullable;
	if (_tmp67_) {
		const gchar* _tmp68_;
		gchar* _tmp69_;
		_tmp68_ = s;
		_tmp69_ = g_strconcat (_tmp68_, "?", NULL);
		_g_free0 (s);
		s = _tmp69_;
	}
	result = s;
	_vala_iterable_unref0 (type_args);
	return result;
}


gchar*
vala_data_type_to_qualified_string (ValaDataType* self,
                                    ValaScope* scope)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->to_qualified_string (self, scope);
}


/**
 * Creates a shallow copy of this type reference.
 *
 * @return copy of this type reference
 */
static ValaDataType*
vala_data_type_real_copy (ValaDataType* self)
{
	g_critical ("Type `%s' does not implement abstract method `vala_data_type_copy'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


ValaDataType*
vala_data_type_copy (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->copy (self);
}


/**
 * Checks two type references for equality. May only be used with
 * resolved type references.
 *
 * @param type2 a type reference
 * @return      true if this type reference is equal to type2, false
 *              otherwise
 */
static gboolean
vala_data_type_real_equals (ValaDataType* self,
                            ValaDataType* type2)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp10_;
	gboolean _tmp11_;
	ValaList* type_args = NULL;
	ValaList* _tmp12_;
	ValaList* type2_args = NULL;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	ValaList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	g_return_val_if_fail (type2 != NULL, FALSE);
	if (vala_data_type_is_disposable (type2) != vala_data_type_is_disposable (self)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = type2->priv->_nullable;
	_tmp1_ = self->priv->_nullable;
	if (_tmp0_ != _tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = type2->priv->_data_type;
	_tmp3_ = self->priv->_data_type;
	if (_tmp2_ != _tmp3_) {
		result = FALSE;
		return result;
	}
	if (VALA_IS_GENERIC_TYPE (type2)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = VALA_IS_GENERIC_TYPE (self);
	}
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		ValaTypeParameter* _tmp6_;
		ValaTypeParameter* _tmp7_;
		ValaTypeParameter* _tmp8_;
		ValaTypeParameter* _tmp9_;
		if (!VALA_IS_GENERIC_TYPE (type2)) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = !VALA_IS_GENERIC_TYPE (self);
		}
		if (_tmp5_) {
			result = FALSE;
			return result;
		}
		_tmp6_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (type2, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
		_tmp9_ = _tmp8_;
		if (!vala_typeparameter_equals (_tmp7_, _tmp9_)) {
			result = FALSE;
			return result;
		}
	}
	_tmp10_ = type2->priv->_floating_reference;
	_tmp11_ = self->priv->_floating_reference;
	if (_tmp10_ != _tmp11_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = vala_data_type_get_type_arguments (self);
	type_args = _tmp12_;
	_tmp13_ = vala_data_type_get_type_arguments (type2);
	type2_args = _tmp13_;
	_tmp14_ = type2_args;
	_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = type_args;
	_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp16_ != _tmp19_) {
		result = FALSE;
		_vala_iterable_unref0 (type2_args);
		_vala_iterable_unref0 (type_args);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gint _tmp22_;
				ValaList* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				ValaList* _tmp26_;
				gint _tmp27_;
				gpointer _tmp28_;
				ValaDataType* _tmp29_;
				ValaList* _tmp30_;
				gint _tmp31_;
				gpointer _tmp32_;
				ValaDataType* _tmp33_;
				gboolean _tmp34_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = i;
				_tmp23_ = type_args;
				_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
				_tmp25_ = _tmp24_;
				if (!(_tmp22_ < _tmp25_)) {
					break;
				}
				_tmp26_ = type2_args;
				_tmp27_ = i;
				_tmp28_ = vala_list_get (_tmp26_, _tmp27_);
				_tmp29_ = (ValaDataType*) _tmp28_;
				_tmp30_ = type_args;
				_tmp31_ = i;
				_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
				_tmp33_ = (ValaDataType*) _tmp32_;
				_tmp34_ = !vala_data_type_equals (_tmp29_, _tmp33_);
				_vala_code_node_unref0 (_tmp33_);
				_vala_code_node_unref0 (_tmp29_);
				if (_tmp34_) {
					result = FALSE;
					_vala_iterable_unref0 (type2_args);
					_vala_iterable_unref0 (type_args);
					return result;
				}
			}
		}
	}
	result = TRUE;
	_vala_iterable_unref0 (type2_args);
	_vala_iterable_unref0 (type_args);
	return result;
}


gboolean
vala_data_type_equals (ValaDataType* self,
                       ValaDataType* type2)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->equals (self, type2);
}


/**
 * Checks whether this type reference is at least as strict as the
 * specified type reference type2.
 *
 * @param type2 a type reference
 * @return      true if this type reference is stricter or equal
 */
static gboolean
vala_data_type_real_stricter (ValaDataType* self,
                              ValaDataType* type2)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_ = FALSE;
	ValaTypeSymbol* _tmp4_;
	ValaTypeSymbol* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (type2 != NULL, FALSE);
	if (vala_data_type_is_disposable (type2) != vala_data_type_is_disposable (self)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = type2->priv->_nullable;
	if (!_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_nullable;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (VALA_IS_GENERIC_TYPE (self)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = VALA_IS_GENERIC_TYPE (type2);
	}
	if (_tmp3_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = type2->priv->_data_type;
	_tmp5_ = self->priv->_data_type;
	if (_tmp4_ != _tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = type2->priv->_floating_reference;
	_tmp7_ = self->priv->_floating_reference;
	if (_tmp6_ != _tmp7_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean
vala_data_type_stricter (ValaDataType* self,
                         ValaDataType* type2)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->stricter (self, type2);
}


static void
vala_data_type_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaDataType * self;
	ValaList* _tmp0_;
	self = (ValaDataType*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = self->priv->type_argument_list;
	if (_tmp0_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gint _tmp3_;
					ValaList* _tmp4_;
					gint _tmp5_;
					gint _tmp6_;
					ValaList* _tmp7_;
					gint _tmp8_;
					gpointer _tmp9_;
					ValaDataType* _tmp10_;
					gboolean _tmp11_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = i;
					_tmp4_ = self->priv->type_argument_list;
					_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
					_tmp6_ = _tmp5_;
					if (!(_tmp3_ < _tmp6_)) {
						break;
					}
					_tmp7_ = self->priv->type_argument_list;
					_tmp8_ = i;
					_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
					_tmp10_ = (ValaDataType*) _tmp9_;
					_tmp11_ = _tmp10_ == old_type;
					_vala_code_node_unref0 (_tmp10_);
					if (_tmp11_) {
						ValaList* _tmp12_;
						gint _tmp13_;
						_tmp12_ = self->priv->type_argument_list;
						_tmp13_ = i;
						vala_list_set (_tmp12_, _tmp13_, new_type);
						return;
					}
				}
			}
		}
	}
}


static gboolean
vala_data_type_real_compatible (ValaDataType* self,
                                ValaDataType* target_type)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaCodeContext* _tmp2_;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	ValaTypeSymbol* _tmp9_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	ValaTypeSymbol* _tmp33_;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	ValaTypeSymbol* _tmp38_;
	gboolean _tmp68_ = FALSE;
	ValaTypeSymbol* _tmp69_;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp2_ = vala_code_context_get ();
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_code_context_get_experimental_non_null (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_vala_code_context_unref0 (_tmp3_);
	if (_tmp6_) {
		gboolean _tmp7_;
		_tmp7_ = self->priv->_nullable;
		_tmp1_ = _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp8_;
		_tmp8_ = target_type->priv->_nullable;
		_tmp0_ = !_tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = target_type->priv->_data_type;
	if (_tmp9_ != NULL) {
		ValaTypeSymbol* _tmp10_;
		ValaCodeContext* _tmp11_;
		ValaCodeContext* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaStructValueType* _tmp15_;
		ValaTypeSymbol* _tmp16_;
		gboolean _tmp17_;
		ValaTypeSymbol* _tmp18_;
		ValaCodeContext* _tmp19_;
		ValaCodeContext* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaObjectType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		gboolean _tmp25_;
		_tmp10_ = target_type->priv->_data_type;
		_tmp11_ = vala_code_context_get ();
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->gvalue_type;
		_tmp16_ = ((ValaDataType*) _tmp15_)->priv->_data_type;
		_tmp17_ = vala_typesymbol_is_subtype_of (_tmp10_, _tmp16_);
		_vala_code_context_unref0 (_tmp12_);
		if (_tmp17_) {
			result = TRUE;
			return result;
		}
		_tmp18_ = target_type->priv->_data_type;
		_tmp19_ = vala_code_context_get ();
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->gvariant_type;
		_tmp24_ = ((ValaDataType*) _tmp23_)->priv->_data_type;
		_tmp25_ = vala_typesymbol_is_subtype_of (_tmp18_, _tmp24_);
		_vala_code_context_unref0 (_tmp20_);
		if (_tmp25_) {
			result = TRUE;
			return result;
		}
	}
	if (VALA_IS_POINTER_TYPE (target_type)) {
		gboolean _tmp26_ = FALSE;
		if (VALA_IS_GENERIC_TYPE (self)) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp27_ = FALSE;
			ValaTypeSymbol* _tmp28_;
			_tmp28_ = self->priv->_data_type;
			if (_tmp28_ != NULL) {
				gboolean _tmp29_ = FALSE;
				ValaTypeSymbol* _tmp30_;
				_tmp30_ = self->priv->_data_type;
				if (vala_typesymbol_is_reference_type (_tmp30_)) {
					_tmp29_ = TRUE;
				} else {
					_tmp29_ = VALA_IS_DELEGATE_TYPE (self);
				}
				_tmp27_ = _tmp29_;
			} else {
				_tmp27_ = FALSE;
			}
			_tmp26_ = _tmp27_;
		}
		if (_tmp26_) {
			result = TRUE;
			return result;
		}
		result = FALSE;
		return result;
	}
	if (VALA_IS_GENERIC_TYPE (target_type)) {
		result = TRUE;
		return result;
	}
	if (VALA_IS_ARRAY_TYPE (self) != VALA_IS_ARRAY_TYPE (target_type)) {
		result = FALSE;
		return result;
	}
	_tmp33_ = self->priv->_data_type;
	if (VALA_IS_ENUM (_tmp33_)) {
		ValaTypeSymbol* _tmp34_;
		_tmp34_ = target_type->priv->_data_type;
		_tmp32_ = VALA_IS_STRUCT (_tmp34_);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		ValaTypeSymbol* _tmp35_;
		_tmp35_ = target_type->priv->_data_type;
		_tmp31_ = vala_struct_is_integer_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_STRUCT, ValaStruct));
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		result = TRUE;
		return result;
	}
	_tmp38_ = self->priv->_data_type;
	if (_tmp38_ != NULL) {
		ValaTypeSymbol* _tmp39_;
		_tmp39_ = target_type->priv->_data_type;
		_tmp37_ = _tmp39_ != NULL;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		ValaTypeSymbol* _tmp40_;
		ValaTypeSymbol* _tmp41_;
		_tmp40_ = self->priv->_data_type;
		_tmp41_ = target_type->priv->_data_type;
		_tmp36_ = vala_typesymbol_is_subtype_of (_tmp40_, _tmp41_);
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		ValaDataType* base_type = NULL;
		ValaTypeSymbol* _tmp42_;
		ValaDataType* _tmp43_;
		ValaList* base_type_args = NULL;
		ValaDataType* _tmp44_;
		ValaList* _tmp45_;
		ValaList* target_type_args = NULL;
		ValaList* _tmp46_;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		ValaList* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		_tmp42_ = target_type->priv->_data_type;
		_tmp43_ = vala_semantic_analyzer_get_instance_base_type_for_member (self, _tmp42_, (ValaCodeNode*) self);
		base_type = _tmp43_;
		_tmp44_ = base_type;
		_tmp45_ = vala_data_type_get_type_arguments (_tmp44_);
		base_type_args = _tmp45_;
		_tmp46_ = vala_data_type_get_type_arguments (target_type);
		target_type_args = _tmp46_;
		_tmp47_ = base_type_args;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = target_type_args;
		_tmp51_ = vala_collection_get_size ((ValaCollection*) _tmp50_);
		_tmp52_ = _tmp51_;
		if (_tmp49_ == _tmp52_) {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp53_ = FALSE;
					_tmp53_ = TRUE;
					while (TRUE) {
						gint _tmp55_;
						ValaList* _tmp56_;
						gint _tmp57_;
						gint _tmp58_;
						ValaList* _tmp59_;
						gint _tmp60_;
						gpointer _tmp61_;
						ValaDataType* _tmp62_;
						ValaList* _tmp63_;
						gint _tmp64_;
						gpointer _tmp65_;
						ValaDataType* _tmp66_;
						gboolean _tmp67_;
						if (!_tmp53_) {
							gint _tmp54_;
							_tmp54_ = i;
							i = _tmp54_ + 1;
						}
						_tmp53_ = FALSE;
						_tmp55_ = i;
						_tmp56_ = base_type_args;
						_tmp57_ = vala_collection_get_size ((ValaCollection*) _tmp56_);
						_tmp58_ = _tmp57_;
						if (!(_tmp55_ < _tmp58_)) {
							break;
						}
						_tmp59_ = base_type_args;
						_tmp60_ = i;
						_tmp61_ = vala_list_get (_tmp59_, _tmp60_);
						_tmp62_ = (ValaDataType*) _tmp61_;
						_tmp63_ = target_type_args;
						_tmp64_ = i;
						_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
						_tmp66_ = (ValaDataType*) _tmp65_;
						_tmp67_ = !vala_data_type_compatible (_tmp62_, _tmp66_);
						_vala_code_node_unref0 (_tmp66_);
						_vala_code_node_unref0 (_tmp62_);
						if (_tmp67_) {
							result = FALSE;
							_vala_iterable_unref0 (target_type_args);
							_vala_iterable_unref0 (base_type_args);
							_vala_code_node_unref0 (base_type);
							return result;
						}
					}
				}
			}
		}
		result = TRUE;
		_vala_iterable_unref0 (target_type_args);
		_vala_iterable_unref0 (base_type_args);
		_vala_code_node_unref0 (base_type);
		return result;
	}
	_tmp69_ = self->priv->_data_type;
	if (VALA_IS_STRUCT (_tmp69_)) {
		ValaTypeSymbol* _tmp70_;
		_tmp70_ = target_type->priv->_data_type;
		_tmp68_ = VALA_IS_STRUCT (_tmp70_);
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		ValaStruct* expr_struct = NULL;
		ValaTypeSymbol* _tmp71_;
		ValaStruct* _tmp72_;
		ValaStruct* expect_struct = NULL;
		ValaTypeSymbol* _tmp73_;
		ValaStruct* _tmp74_;
		gboolean _tmp75_ = FALSE;
		ValaStruct* _tmp76_;
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		ValaStruct* _tmp80_;
		ValaStruct* _tmp87_;
		ValaStruct* _tmp88_;
		_tmp71_ = self->priv->_data_type;
		_tmp72_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_STRUCT, ValaStruct));
		expr_struct = _tmp72_;
		_tmp73_ = target_type->priv->_data_type;
		_tmp74_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_STRUCT, ValaStruct));
		expect_struct = _tmp74_;
		_tmp76_ = expr_struct;
		if (vala_struct_is_integer_type (_tmp76_)) {
			ValaStruct* _tmp77_;
			_tmp77_ = expect_struct;
			_tmp75_ = vala_struct_is_floating_type (_tmp77_);
		} else {
			_tmp75_ = FALSE;
		}
		if (_tmp75_) {
			result = TRUE;
			_vala_code_node_unref0 (expect_struct);
			_vala_code_node_unref0 (expr_struct);
			return result;
		}
		_tmp80_ = expr_struct;
		if (vala_struct_is_integer_type (_tmp80_)) {
			ValaStruct* _tmp81_;
			_tmp81_ = expect_struct;
			_tmp79_ = vala_struct_is_integer_type (_tmp81_);
		} else {
			_tmp79_ = FALSE;
		}
		if (_tmp79_) {
			_tmp78_ = TRUE;
		} else {
			gboolean _tmp82_ = FALSE;
			ValaStruct* _tmp83_;
			_tmp83_ = expr_struct;
			if (vala_struct_is_floating_type (_tmp83_)) {
				ValaStruct* _tmp84_;
				_tmp84_ = expect_struct;
				_tmp82_ = vala_struct_is_floating_type (_tmp84_);
			} else {
				_tmp82_ = FALSE;
			}
			_tmp78_ = _tmp82_;
		}
		if (_tmp78_) {
			ValaStruct* _tmp85_;
			ValaStruct* _tmp86_;
			_tmp85_ = expr_struct;
			_tmp86_ = expect_struct;
			if (vala_struct_get_rank (_tmp85_) <= vala_struct_get_rank (_tmp86_)) {
				result = TRUE;
				_vala_code_node_unref0 (expect_struct);
				_vala_code_node_unref0 (expr_struct);
				return result;
			}
		}
		_tmp87_ = expect_struct;
		_tmp88_ = expr_struct;
		if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp87_, (ValaTypeSymbol*) _tmp88_)) {
			result = TRUE;
			_vala_code_node_unref0 (expect_struct);
			_vala_code_node_unref0 (expr_struct);
			return result;
		}
		_vala_code_node_unref0 (expect_struct);
		_vala_code_node_unref0 (expr_struct);
	}
	result = FALSE;
	return result;
}


gboolean
vala_data_type_compatible (ValaDataType* self,
                           ValaDataType* target_type)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->compatible (self, target_type);
}


/**
 * Returns whether instances of this type are invokable.
 *
 * @return true if invokable, false otherwise
 */
static gboolean
vala_data_type_real_is_invokable (ValaDataType* self)
{
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean
vala_data_type_is_invokable (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_invokable (self);
}


/**
 * Returns the return type of this invokable.
 *
 * @return return type
 */
static ValaDataType*
vala_data_type_real_get_return_type (ValaDataType* self)
{
	ValaDataType* result = NULL;
	result = NULL;
	return result;
}


ValaDataType*
vala_data_type_get_return_type (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_return_type (self);
}


/**
 * Returns copy of the list of invocation parameters.
 *
 * @return parameter list
 */
static ValaList*
vala_data_type_real_get_parameters (ValaDataType* self)
{
	ValaList* result = NULL;
	result = NULL;
	return result;
}


ValaList*
vala_data_type_get_parameters (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_parameters (self);
}


static gboolean
vala_data_type_real_is_reference_type_or_type_parameter (ValaDataType* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaTypeSymbol* _tmp2_;
	_tmp2_ = self->priv->_data_type;
	if (_tmp2_ != NULL) {
		ValaTypeSymbol* _tmp3_;
		_tmp3_ = self->priv->_data_type;
		_tmp1_ = vala_typesymbol_is_reference_type (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_GENERIC_TYPE (self);
	}
	result = _tmp0_;
	return result;
}


gboolean
vala_data_type_is_reference_type_or_type_parameter (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_reference_type_or_type_parameter (self);
}


static gboolean
vala_data_type_real_is_array (ValaDataType* self)
{
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean
vala_data_type_is_array (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_array (self);
}


static gboolean
vala_data_type_real_is_accessible (ValaDataType* self,
                                   ValaSymbol* sym)
{
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp11_;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp0_;
		gint _type_arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_arg_index = 0;
		_tmp0_ = vala_data_type_get_type_arguments (self);
		_type_arg_list = _tmp0_;
		_tmp1_ = _type_arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_arg_size = _tmp3_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			_tmp4_ = _type_arg_index;
			_type_arg_index = _tmp4_ + 1;
			_tmp5_ = _type_arg_index;
			_tmp6_ = _type_arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_arg_list;
			_tmp8_ = _type_arg_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			type_arg = (ValaDataType*) _tmp9_;
			_tmp10_ = type_arg;
			if (!vala_data_type_is_accessible (_tmp10_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (type_arg);
				_vala_iterable_unref0 (_type_arg_list);
				return result;
			}
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	_tmp11_ = self->priv->_data_type;
	if (_tmp11_ != NULL) {
		ValaTypeSymbol* _tmp12_;
		_tmp12_ = self->priv->_data_type;
		result = vala_symbol_is_accessible ((ValaSymbol*) _tmp12_, sym);
		return result;
	}
	result = TRUE;
	return result;
}


gboolean
vala_data_type_is_accessible (ValaDataType* self,
                              ValaSymbol* sym)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_accessible (self, sym);
}


static ValaSymbol*
vala_data_type_real_get_member (ValaDataType* self,
                                const gchar* member_name)
{
	ValaSymbol* result = NULL;
	ValaTypeSymbol* _tmp0_;
	g_return_val_if_fail (member_name != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	if (_tmp0_ != NULL) {
		ValaTypeSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		_tmp1_ = self->priv->_data_type;
		_tmp2_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp1_, member_name);
		result = _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}


ValaSymbol*
vala_data_type_get_member (ValaDataType* self,
                           const gchar* member_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_member (self, member_name);
}


static ValaSymbol*
vala_data_type_real_get_pointer_member (ValaDataType* self,
                                        const gchar* member_name)
{
	ValaSymbol* result = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	result = NULL;
	return result;
}


ValaSymbol*
vala_data_type_get_pointer_member (ValaDataType* self,
                                   const gchar* member_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_pointer_member (self, member_name);
}


/**
 * Checks whether this data type references a real struct. A real struct
 * is a struct which is not a simple (fundamental) type.
 */
static gboolean
vala_data_type_real_is_real_struct_type (ValaDataType* self)
{
	gboolean result = FALSE;
	ValaStruct* s = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaStruct* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	_tmp0_ = self->priv->_data_type;
	_tmp1_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL);
	s = _tmp1_;
	_tmp3_ = s;
	if (_tmp3_ != NULL) {
		ValaStruct* _tmp4_;
		_tmp4_ = s;
		_tmp2_ = !vala_struct_is_simple_type (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		_vala_code_node_unref0 (s);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (s);
	return result;
}


gboolean
vala_data_type_is_real_struct_type (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_real_struct_type (self);
}


gboolean
vala_data_type_is_real_non_null_struct_type (ValaDataType* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_data_type_is_real_struct_type (self)) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_nullable;
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


/**
 * Returns whether the value needs to be disposed, i.e. whether
 * allocated memory or other resources need to be released when
 * the value is no longer needed.
 */
static gboolean
vala_data_type_real_is_disposable (ValaDataType* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	_tmp0_ = self->priv->_value_owned;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	if (vala_data_type_is_reference_type_or_type_parameter (self)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


gboolean
vala_data_type_is_disposable (ValaDataType* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_DATA_TYPE_GET_CLASS (self)->is_disposable (self);
}


static ValaDataType*
vala_data_type_real_get_actual_type (ValaDataType* self,
                                     ValaDataType* derived_instance_type,
                                     ValaList* method_type_arguments,
                                     ValaCodeNode* node_reference)
{
	ValaDataType* result = NULL;
	ValaDataType* _result_ = NULL;
	ValaDataType* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp2_;
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_data_type_copy (self);
	_result_ = _tmp0_;
	if (derived_instance_type == NULL) {
		_tmp1_ = method_type_arguments == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = _result_;
		return result;
	}
	_tmp2_ = _result_;
	if (VALA_IS_GENERIC_TYPE (_tmp2_)) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp3_ = _result_;
		_tmp4_ = vala_semantic_analyzer_get_actual_type (derived_instance_type, method_type_arguments, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_GENERIC_TYPE, ValaGenericType), node_reference);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp4_;
	} else {
		ValaDataType* _tmp5_;
		ValaList* _tmp6_;
		_tmp5_ = _result_;
		_tmp6_ = _tmp5_->priv->type_argument_list;
		if (_tmp6_ != NULL) {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp7_ = FALSE;
					_tmp7_ = TRUE;
					while (TRUE) {
						gint _tmp9_;
						ValaDataType* _tmp10_;
						ValaList* _tmp11_;
						gint _tmp12_;
						gint _tmp13_;
						ValaDataType* _tmp14_;
						ValaList* _tmp15_;
						gint _tmp16_;
						ValaDataType* _tmp17_;
						ValaList* _tmp18_;
						gint _tmp19_;
						gpointer _tmp20_;
						ValaDataType* _tmp21_;
						ValaDataType* _tmp22_;
						ValaDataType* _tmp23_;
						if (!_tmp7_) {
							gint _tmp8_;
							_tmp8_ = i;
							i = _tmp8_ + 1;
						}
						_tmp7_ = FALSE;
						_tmp9_ = i;
						_tmp10_ = _result_;
						_tmp11_ = _tmp10_->priv->type_argument_list;
						_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
						_tmp13_ = _tmp12_;
						if (!(_tmp9_ < _tmp13_)) {
							break;
						}
						_tmp14_ = _result_;
						_tmp15_ = _tmp14_->priv->type_argument_list;
						_tmp16_ = i;
						_tmp17_ = _result_;
						_tmp18_ = _tmp17_->priv->type_argument_list;
						_tmp19_ = i;
						_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
						_tmp21_ = (ValaDataType*) _tmp20_;
						_tmp22_ = vala_data_type_get_actual_type (_tmp21_, derived_instance_type, method_type_arguments, node_reference);
						_tmp23_ = _tmp22_;
						vala_list_set (_tmp15_, _tmp16_, _tmp23_);
						_vala_code_node_unref0 (_tmp23_);
						_vala_code_node_unref0 (_tmp21_);
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}


ValaDataType*
vala_data_type_get_actual_type (ValaDataType* self,
                                ValaDataType* derived_instance_type,
                                ValaList* method_type_arguments,
                                ValaCodeNode* node_reference)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->get_actual_type (self, derived_instance_type, method_type_arguments, node_reference);
}


/**
 * Search for the type parameter in this formal type and match it in
 * value_type.
 */
static ValaDataType*
vala_data_type_real_infer_type_argument (ValaDataType* self,
                                         ValaTypeParameter* type_param,
                                         ValaDataType* value_type)
{
	ValaDataType* result = NULL;
	ValaIterator* value_type_arg_it = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaIterator* _tmp2_;
	ValaIterator* _tmp3_;
	g_return_val_if_fail (type_param != NULL, NULL);
	g_return_val_if_fail (value_type != NULL, NULL);
	_tmp0_ = vala_data_type_get_type_arguments (value_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_iterable_iterator ((ValaIterable*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_iterable_unref0 (_tmp1_);
	value_type_arg_it = _tmp3_;
	{
		ValaList* _formal_type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _formal_type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _formal_type_arg_index = 0;
		_tmp4_ = vala_data_type_get_type_arguments (self);
		_formal_type_arg_list = _tmp4_;
		_tmp5_ = _formal_type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_formal_type_arg_size = _tmp7_;
		_formal_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* formal_type_arg = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaIterator* _tmp14_;
			_tmp8_ = _formal_type_arg_index;
			_formal_type_arg_index = _tmp8_ + 1;
			_tmp9_ = _formal_type_arg_index;
			_tmp10_ = _formal_type_arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _formal_type_arg_list;
			_tmp12_ = _formal_type_arg_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			formal_type_arg = (ValaDataType*) _tmp13_;
			_tmp14_ = value_type_arg_it;
			if (vala_iterator_next (_tmp14_)) {
				ValaDataType* inferred_type = NULL;
				ValaDataType* _tmp15_;
				ValaIterator* _tmp16_;
				gpointer _tmp17_;
				ValaDataType* _tmp18_;
				ValaDataType* _tmp19_;
				ValaDataType* _tmp20_;
				ValaDataType* _tmp21_;
				_tmp15_ = formal_type_arg;
				_tmp16_ = value_type_arg_it;
				_tmp17_ = vala_iterator_get (_tmp16_);
				_tmp18_ = (ValaDataType*) _tmp17_;
				_tmp19_ = vala_data_type_infer_type_argument (_tmp15_, type_param, _tmp18_);
				_tmp20_ = _tmp19_;
				_vala_code_node_unref0 (_tmp18_);
				inferred_type = _tmp20_;
				_tmp21_ = inferred_type;
				if (_tmp21_ != NULL) {
					result = inferred_type;
					_vala_code_node_unref0 (formal_type_arg);
					_vala_iterable_unref0 (_formal_type_arg_list);
					_vala_iterator_unref0 (value_type_arg_it);
					return result;
				}
				_vala_code_node_unref0 (inferred_type);
			}
			_vala_code_node_unref0 (formal_type_arg);
		}
		_vala_iterable_unref0 (_formal_type_arg_list);
	}
	result = NULL;
	_vala_iterator_unref0 (value_type_arg_it);
	return result;
}


ValaDataType*
vala_data_type_infer_type_argument (ValaDataType* self,
                                    ValaTypeParameter* type_param,
                                    ValaDataType* value_type)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->infer_type_argument (self, type_param, value_type);
}


/**
 * Returns a stringified representation used for detailed error output
 *
 * @param override_name used as name if given
 * @return stringified representation
 */
static gchar*
vala_data_type_real_to_prototype_string (ValaDataType* self,
                                         const gchar* override_name)
{
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	if (vala_data_type_is_weak (self)) {
		_tmp0_ = "unowned ";
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = vala_data_type_to_qualified_string (self, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s%s", _tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


gchar*
vala_data_type_to_prototype_string (ValaDataType* self,
                                    const gchar* override_name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_DATA_TYPE_GET_CLASS (self)->to_prototype_string (self, override_name);
}


gboolean
vala_data_type_is_weak (ValaDataType* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_value_owned;
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (VALA_IS_VOID_TYPE (self)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = VALA_IS_POINTER_TYPE (self);
		}
		if (_tmp1_) {
			result = FALSE;
			return result;
		} else {
			if (VALA_IS_VALUE_TYPE (self)) {
				gboolean _tmp2_;
				_tmp2_ = self->priv->_nullable;
				if (_tmp2_) {
					result = TRUE;
					return result;
				}
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}


ValaDataType*
vala_data_type_construct (GType object_type)
{
	ValaDataType* self = NULL;
	self = (ValaDataType*) vala_code_node_construct (object_type);
	return self;
}


gboolean
vala_data_type_get_value_owned (ValaDataType* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_value_owned;
	result = _tmp0_;
	return result;
}


void
vala_data_type_set_value_owned (ValaDataType* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_value_owned = value;
}


gboolean
vala_data_type_get_nullable (ValaDataType* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_nullable;
	result = _tmp0_;
	return result;
}


void
vala_data_type_set_nullable (ValaDataType* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_nullable = value;
}


ValaTypeSymbol*
vala_data_type_get_data_type (ValaDataType* self)
{
	ValaTypeSymbol* result;
	ValaTypeSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void
vala_data_type_set_data_type (ValaDataType* self,
                              ValaTypeSymbol* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_data_type = value;
}


gboolean
vala_data_type_get_floating_reference (ValaDataType* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_floating_reference;
	result = _tmp0_;
	return result;
}


void
vala_data_type_set_floating_reference (ValaDataType* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_floating_reference = value;
}


gboolean
vala_data_type_get_is_dynamic (ValaDataType* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_dynamic;
	result = _tmp0_;
	return result;
}


void
vala_data_type_set_is_dynamic (ValaDataType* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_dynamic = value;
}


static void
vala_data_type_class_init (ValaDataTypeClass * klass)
{
	vala_data_type_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_data_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaDataTypePrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_data_type_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_data_type_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_data_type_real_to_string;
	((ValaDataTypeClass *) klass)->to_qualified_string = (gchar* (*) (ValaDataType*, ValaScope*)) vala_data_type_real_to_qualified_string;
	((ValaDataTypeClass *) klass)->copy = (ValaDataType* (*) (ValaDataType*)) vala_data_type_real_copy;
	((ValaDataTypeClass *) klass)->equals = (gboolean (*) (ValaDataType*, ValaDataType*)) vala_data_type_real_equals;
	((ValaDataTypeClass *) klass)->stricter = (gboolean (*) (ValaDataType*, ValaDataType*)) vala_data_type_real_stricter;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_data_type_real_replace_type;
	((ValaDataTypeClass *) klass)->compatible = (gboolean (*) (ValaDataType*, ValaDataType*)) vala_data_type_real_compatible;
	((ValaDataTypeClass *) klass)->is_invokable = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_invokable;
	((ValaDataTypeClass *) klass)->get_return_type = (ValaDataType* (*) (ValaDataType*)) vala_data_type_real_get_return_type;
	((ValaDataTypeClass *) klass)->get_parameters = (ValaList* (*) (ValaDataType*)) vala_data_type_real_get_parameters;
	((ValaDataTypeClass *) klass)->is_reference_type_or_type_parameter = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_reference_type_or_type_parameter;
	((ValaDataTypeClass *) klass)->is_array = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_array;
	((ValaDataTypeClass *) klass)->is_accessible = (gboolean (*) (ValaDataType*, ValaSymbol*)) vala_data_type_real_is_accessible;
	((ValaDataTypeClass *) klass)->get_member = (ValaSymbol* (*) (ValaDataType*, const gchar*)) vala_data_type_real_get_member;
	((ValaDataTypeClass *) klass)->get_pointer_member = (ValaSymbol* (*) (ValaDataType*, const gchar*)) vala_data_type_real_get_pointer_member;
	((ValaDataTypeClass *) klass)->is_real_struct_type = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_real_struct_type;
	((ValaDataTypeClass *) klass)->is_disposable = (gboolean (*) (ValaDataType*)) vala_data_type_real_is_disposable;
	((ValaDataTypeClass *) klass)->get_actual_type = (ValaDataType* (*) (ValaDataType*, ValaDataType*, ValaList*, ValaCodeNode*)) vala_data_type_real_get_actual_type;
	((ValaDataTypeClass *) klass)->infer_type_argument = (ValaDataType* (*) (ValaDataType*, ValaTypeParameter*, ValaDataType*)) vala_data_type_real_infer_type_argument;
	((ValaDataTypeClass *) klass)->to_prototype_string = (gchar* (*) (ValaDataType*, const gchar*)) vala_data_type_real_to_prototype_string;
}


static void
vala_data_type_instance_init (ValaDataType * self)
{
	self->priv = VALA_DATA_TYPE_GET_PRIVATE (self);
}


static void
vala_data_type_finalize (ValaCodeNode * obj)
{
	ValaDataType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_DATA_TYPE, ValaDataType);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_data_type_parent_class)->finalize (obj);
}


/**
 * A reference to a data type. This is used to specify static types of
 * expressions.
 */
GType
vala_data_type_get_type (void)
{
	static volatile gsize vala_data_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_data_type_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDataTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_data_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDataType), 0, (GInstanceInitFunc) vala_data_type_instance_init, NULL };
		GType vala_data_type_type_id;
		vala_data_type_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDataType", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&vala_data_type_type_id__volatile, vala_data_type_type_id);
	}
	return vala_data_type_type_id__volatile;
}



