/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};


static gpointer vala_object_creation_expression_parent_class = NULL;

#define VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionPrivate))
static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}


ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self,
                                              ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}


/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_arg_list = _tmp9_;
		_tmp10_ = _arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_arg_size = _tmp12_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* arg = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaExpression* _tmp19_;
			_tmp13_ = _arg_index;
			_arg_index = _tmp13_ + 1;
			_tmp14_ = _arg_index;
			_tmp15_ = _arg_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _arg_list;
			_tmp17_ = _arg_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			arg = (ValaExpression*) _tmp18_;
			_tmp19_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _init_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _init_index = 0;
		_tmp20_ = self->priv->object_initializer;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_init_list = _tmp21_;
		_tmp22_ = _init_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_init_size = _tmp24_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			ValaMemberInitializer* _tmp31_;
			_tmp25_ = _init_index;
			_init_index = _tmp25_ + 1;
			_tmp26_ = _init_index;
			_tmp27_ = _init_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _init_list;
			_tmp29_ = _init_index;
			_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
			init = (ValaMemberInitializer*) _tmp30_;
			_tmp31_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp31_, visitor);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	gint _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	_tmp1_ = index;
	if (_tmp1_ >= 0) {
		ValaList* _tmp2_;
		gint _tmp3_;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = index;
		vala_list_set (_tmp2_, _tmp3_, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _arg_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_arg_list = _tmp6_;
		_tmp7_ = _arg_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_arg_size = _tmp9_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaExpression* arg = NULL;
			ValaList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_;
			ValaExpression* _tmp16_;
			_tmp10_ = _arg_index;
			_arg_index = _tmp10_ + 1;
			_tmp11_ = _arg_index;
			_tmp12_ = _arg_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _arg_list;
			_tmp14_ = _arg_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			arg = (ValaExpression*) _tmp15_;
			_tmp16_ = arg;
			if (!vala_expression_is_accessible (_tmp16_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _init_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _init_index = 0;
		_tmp17_ = self->priv->object_initializer;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_init_list = _tmp18_;
		_tmp19_ = _init_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_init_size = _tmp21_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			ValaMemberInitializer* _tmp28_;
			ValaExpression* _tmp29_;
			ValaExpression* _tmp30_;
			_tmp22_ = _init_index;
			_init_index = _tmp22_ + 1;
			_tmp23_ = _init_index;
			_tmp24_ = _init_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _init_list;
			_tmp26_ = _init_index;
			_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
			init = (ValaMemberInitializer*) _tmp27_;
			_tmp28_ = init;
			_tmp29_ = vala_member_initializer_get_initializer (_tmp28_);
			_tmp30_ = _tmp29_;
			if (!vala_expression_is_accessible (_tmp30_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				_vala_iterable_unref0 (_init_list);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	result = TRUE;
	return result;
}


static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	gboolean may_throw = FALSE;
	gint given_num_type_args = 0;
	ValaDataType* _tmp116_;
	ValaDataType* _tmp117_;
	ValaList* _tmp118_;
	ValaList* _tmp119_;
	gint _tmp120_;
	gint _tmp121_;
	gint _tmp122_;
	gint expected_num_type_args = 0;
	ValaTypeSymbol* _tmp123_;
	gint _tmp245_;
	gint _tmp246_;
	gboolean _tmp253_ = FALSE;
	ValaSymbol* _tmp254_;
	ValaSymbol* _tmp255_;
	ValaSymbol* _tmp267_;
	ValaSymbol* _tmp268_;
	gboolean _tmp547_;
	gboolean _tmp600_;
	gboolean _tmp601_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	type = NULL;
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaSymbol* _tmp31_;
		ValaSymbol* _tmp55_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		type_args = _tmp30_;
		_tmp31_ = constructor_sym;
		if (VALA_IS_METHOD (_tmp31_)) {
			ValaSymbol* _tmp32_;
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp36_;
			ValaMethod* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaMethod* _tmp46_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp47_;
			ValaMemberAccess* _tmp48_;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaMemberAccess* _tmp51_;
			ValaMemberAccess* _tmp52_;
			_tmp32_ = constructor_sym;
			_tmp33_ = vala_symbol_get_parent_symbol (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _vala_code_node_ref0 (_tmp34_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp35_;
			_tmp36_ = constructor_sym;
			_tmp37_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp37_;
			_tmp38_ = constructor_sym;
			if (!VALA_IS_CREATION_METHOD (_tmp38_)) {
				ValaSourceReference* _tmp39_;
				ValaSourceReference* _tmp40_;
				ValaMethod* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp40_ = _tmp39_;
				_tmp41_ = constructor;
				_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strdup_printf ("`%s' is not a creation method", _tmp43_);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp40_, _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp46_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp46_);
			_tmp47_ = vala_object_creation_expression_get_member_name (self);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_member_access_get_inner (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp50_) ? ((ValaMemberAccess*) _tmp50_) : NULL);
			ma = _tmp51_;
			_tmp52_ = ma;
			if (_tmp52_ != NULL) {
				ValaMemberAccess* _tmp53_;
				ValaList* _tmp54_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_type_arguments (_tmp53_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp54_;
			}
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (constructor);
		}
		_tmp55_ = type_sym;
		if (VALA_IS_CLASS (_tmp55_)) {
			ValaSymbol* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			gboolean _tmp59_;
			gboolean _tmp60_;
			_tmp56_ = type_sym;
			_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp57_;
			_tmp58_ = type;
			_tmp59_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_CLASS, ValaClass));
			_tmp60_ = _tmp59_;
			if (_tmp60_) {
				ValaSourceReference* _tmp61_;
				ValaSourceReference* _tmp62_;
				ValaErrorType* _tmp63_;
				ValaErrorType* _tmp64_;
				_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp62_ = _tmp61_;
				_tmp63_ = vala_error_type_new (NULL, NULL, _tmp62_);
				_tmp64_ = _tmp63_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp64_);
				_vala_code_node_unref0 (_tmp64_);
			} else {
				ValaTypeSymbol* _tmp65_;
				ValaObjectType* _tmp66_;
				ValaObjectType* _tmp67_;
				_tmp65_ = type;
				_tmp66_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_CLASS, ValaClass));
				_tmp67_ = _tmp66_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp67_);
				_vala_code_node_unref0 (_tmp67_);
			}
		} else {
			ValaSymbol* _tmp68_;
			_tmp68_ = type_sym;
			if (VALA_IS_STRUCT (_tmp68_)) {
				ValaSymbol* _tmp69_;
				ValaTypeSymbol* _tmp70_;
				ValaTypeSymbol* _tmp71_;
				ValaStructValueType* _tmp72_;
				ValaStructValueType* _tmp73_;
				_tmp69_ = type_sym;
				_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp70_;
				_tmp71_ = type;
				_tmp72_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp73_ = _tmp72_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp73_);
				_vala_code_node_unref0 (_tmp73_);
			} else {
				ValaSymbol* _tmp74_;
				_tmp74_ = type_sym;
				if (VALA_IS_ERROR_CODE (_tmp74_)) {
					ValaSymbol* _tmp75_;
					ValaSymbol* _tmp76_;
					ValaSymbol* _tmp77_;
					ValaSymbol* _tmp78_;
					ValaSourceReference* _tmp79_;
					ValaSourceReference* _tmp80_;
					ValaErrorType* _tmp81_;
					ValaErrorType* _tmp82_;
					ValaSymbol* _tmp83_;
					_tmp75_ = type_sym;
					_tmp76_ = vala_symbol_get_parent_symbol (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = type_sym;
					_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp80_ = _tmp79_;
					_tmp81_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp80_);
					_tmp82_ = _tmp81_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp82_);
					_vala_code_node_unref0 (_tmp82_);
					_tmp83_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp83_);
				} else {
					ValaSourceReference* _tmp84_;
					ValaSourceReference* _tmp85_;
					ValaSymbol* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp85_ = _tmp84_;
					_tmp86_ = type_sym;
					_tmp87_ = vala_symbol_get_full_name (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp88_);
					_tmp90_ = _tmp89_;
					vala_report_error (_tmp85_, _tmp90_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp88_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp91_;
			ValaList* _tmp92_;
			gint _type_arg_size = 0;
			ValaList* _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			gint _type_arg_index = 0;
			_tmp91_ = type_args;
			_tmp92_ = _vala_iterable_ref0 (_tmp91_);
			_type_arg_list = _tmp92_;
			_tmp93_ = _type_arg_list;
			_tmp94_ = vala_collection_get_size ((ValaCollection*) _tmp93_);
			_tmp95_ = _tmp94_;
			_type_arg_size = _tmp95_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp96_;
				gint _tmp97_;
				gint _tmp98_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp99_;
				gint _tmp100_;
				gpointer _tmp101_;
				ValaDataType* _tmp102_;
				ValaDataType* _tmp103_;
				ValaDataType* _tmp104_;
				_tmp96_ = _type_arg_index;
				_type_arg_index = _tmp96_ + 1;
				_tmp97_ = _type_arg_index;
				_tmp98_ = _type_arg_size;
				if (!(_tmp97_ < _tmp98_)) {
					break;
				}
				_tmp99_ = _type_arg_list;
				_tmp100_ = _type_arg_index;
				_tmp101_ = vala_list_get (_tmp99_, _tmp100_);
				type_arg = (ValaDataType*) _tmp101_;
				_tmp102_ = vala_object_creation_expression_get_type_reference (self);
				_tmp103_ = _tmp102_;
				_tmp104_ = type_arg;
				vala_data_type_add_type_argument (_tmp103_, _tmp104_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp105_;
		ValaDataType* _tmp106_;
		ValaTypeSymbol* _tmp107_;
		ValaTypeSymbol* _tmp108_;
		ValaTypeSymbol* _tmp109_;
		_tmp105_ = vala_object_creation_expression_get_type_reference (self);
		_tmp106_ = _tmp105_;
		_tmp107_ = vala_data_type_get_data_type (_tmp106_);
		_tmp108_ = _tmp107_;
		_tmp109_ = _vala_code_node_ref0 (_tmp108_);
		_vala_code_node_unref0 (type);
		type = _tmp109_;
	}
	_tmp110_ = vala_object_creation_expression_get_type_reference (self);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_data_type_copy (_tmp111_);
	_tmp113_ = _tmp112_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp113_);
	_vala_code_node_unref0 (_tmp113_);
	_tmp114_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp115_ = _tmp114_;
	vala_data_type_set_value_owned (_tmp115_, TRUE);
	may_throw = FALSE;
	_tmp116_ = vala_object_creation_expression_get_type_reference (self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vala_data_type_get_type_arguments (_tmp117_);
	_tmp119_ = _tmp118_;
	_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
	_tmp121_ = _tmp120_;
	_tmp122_ = _tmp121_;
	_vala_iterable_unref0 (_tmp119_);
	given_num_type_args = _tmp122_;
	expected_num_type_args = 0;
	_tmp123_ = type;
	if (VALA_IS_CLASS (_tmp123_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp124_;
		ValaClass* _tmp125_;
		ValaClass* _tmp126_;
		ValaList* _tmp127_;
		ValaList* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		gboolean _tmp131_;
		ValaClass* _tmp134_;
		gboolean _tmp135_;
		gboolean _tmp136_;
		ValaSymbol* _tmp144_;
		ValaSymbol* _tmp145_;
		gboolean _tmp166_ = FALSE;
		ValaSymbol* _tmp167_;
		ValaSymbol* _tmp168_;
		_tmp124_ = type;
		_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp125_;
		_tmp126_ = cl;
		_tmp127_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp126_);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
		_tmp130_ = _tmp129_;
		expected_num_type_args = _tmp130_;
		_vala_iterable_unref0 (_tmp128_);
		_tmp131_ = self->priv->_struct_creation;
		if (_tmp131_) {
			ValaSourceReference* _tmp132_;
			ValaSourceReference* _tmp133_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp133_ = _tmp132_;
			vala_report_error (_tmp133_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp134_ = cl;
		_tmp135_ = vala_class_get_is_abstract (_tmp134_);
		_tmp136_ = _tmp135_;
		if (_tmp136_) {
			ValaSourceReference* _tmp137_;
			ValaSourceReference* _tmp138_;
			ValaClass* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = cl;
			_tmp140_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp141_);
			_tmp143_ = _tmp142_;
			vala_report_error (_tmp138_, _tmp143_);
			_g_free0 (_tmp143_);
			_g_free0 (_tmp141_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp145_ = _tmp144_;
		if (_tmp145_ == NULL) {
			ValaClass* _tmp146_;
			ValaCreationMethod* _tmp147_;
			ValaCreationMethod* _tmp148_;
			ValaSymbol* _tmp149_;
			ValaSymbol* _tmp150_;
			ValaSymbol* _tmp158_;
			ValaSymbol* _tmp159_;
			ValaSymbol* _tmp160_;
			ValaSymbol* _tmp161_;
			ValaVersionAttribute* _tmp162_;
			ValaVersionAttribute* _tmp163_;
			ValaSourceReference* _tmp164_;
			ValaSourceReference* _tmp165_;
			_tmp146_ = cl;
			_tmp147_ = vala_class_get_default_construction_method (_tmp146_);
			_tmp148_ = _tmp147_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp148_);
			_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp150_ = _tmp149_;
			if (_tmp150_ == NULL) {
				ValaSourceReference* _tmp151_;
				ValaSourceReference* _tmp152_;
				ValaClass* _tmp153_;
				gchar* _tmp154_;
				gchar* _tmp155_;
				gchar* _tmp156_;
				gchar* _tmp157_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp152_ = _tmp151_;
				_tmp153_ = cl;
				_tmp154_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp155_);
				_tmp157_ = _tmp156_;
				vala_report_error (_tmp152_, _tmp157_);
				_g_free0 (_tmp157_);
				_g_free0 (_tmp155_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp158_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp159_ = _tmp158_;
			vala_symbol_set_used (_tmp159_, TRUE);
			_tmp160_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp161_ = _tmp160_;
			_tmp162_ = vala_symbol_get_version (_tmp161_);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp165_ = _tmp164_;
			vala_version_attribute_check (_tmp163_, _tmp165_);
		}
		_tmp167_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp168_ = _tmp167_;
		if (_tmp168_ != NULL) {
			gboolean _tmp169_ = FALSE;
			ValaSymbol* _tmp170_;
			ValaSymbol* _tmp171_;
			ValaSymbolAccessibility _tmp172_;
			ValaSymbolAccessibility _tmp173_;
			_tmp170_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_symbol_get_access (_tmp171_);
			_tmp173_ = _tmp172_;
			if (_tmp173_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp169_ = TRUE;
			} else {
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp175_;
				ValaSymbolAccessibility _tmp176_;
				ValaSymbolAccessibility _tmp177_;
				_tmp174_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_symbol_get_access (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp169_ = _tmp177_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp166_ = _tmp169_;
		} else {
			_tmp166_ = FALSE;
		}
		if (_tmp166_) {
			gboolean in_target_type = FALSE;
			gboolean _tmp191_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp178_;
				ValaSemanticAnalyzer* _tmp179_;
				ValaSymbol* _tmp180_;
				ValaSymbol* _tmp181_;
				ValaSymbol* _tmp182_;
				_tmp178_ = vala_code_context_get_analyzer (context);
				_tmp179_ = _tmp178_;
				_tmp180_ = vala_semantic_analyzer_get_current_symbol (_tmp179_);
				_tmp181_ = _tmp180_;
				_tmp182_ = _vala_code_node_ref0 (_tmp181_);
				this_symbol = _tmp182_;
				{
					gboolean _tmp183_ = FALSE;
					_tmp183_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp188_;
						ValaSymbol* _tmp189_;
						ValaClass* _tmp190_;
						if (!_tmp183_) {
							ValaSymbol* _tmp184_;
							ValaSymbol* _tmp185_;
							ValaSymbol* _tmp186_;
							ValaSymbol* _tmp187_;
							_tmp184_ = this_symbol;
							_tmp185_ = vala_symbol_get_parent_symbol (_tmp184_);
							_tmp186_ = _tmp185_;
							_tmp187_ = _vala_code_node_ref0 (_tmp186_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp187_;
						}
						_tmp183_ = FALSE;
						_tmp188_ = this_symbol;
						if (!(_tmp188_ != NULL)) {
							break;
						}
						_tmp189_ = this_symbol;
						_tmp190_ = cl;
						if (_tmp189_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp190_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp191_ = in_target_type;
			if (!_tmp191_) {
				ValaSourceReference* _tmp192_;
				ValaSourceReference* _tmp193_;
				ValaSymbol* _tmp194_;
				ValaSymbol* _tmp195_;
				gchar* _tmp196_;
				gchar* _tmp197_;
				gchar* _tmp198_;
				gchar* _tmp199_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp193_ = _tmp192_;
				_tmp194_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_symbol_get_full_name (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = g_strdup_printf ("Access to non-public constructor `%s' denied", _tmp197_);
				_tmp199_ = _tmp198_;
				vala_report_error (_tmp193_, _tmp199_);
				_g_free0 (_tmp199_);
				_g_free0 (_tmp197_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp200_;
			ValaClass* _tmp201_;
			gchar* _tmp202_;
			gchar* _tmp203_;
			gboolean _tmp204_;
			ValaClass* _tmp207_;
			ValaClass* _tmp208_;
			ValaClass* _tmp209_;
			ValaClass* _tmp210_;
			_tmp200_ = cl;
			if (!(_tmp200_ != NULL)) {
				break;
			}
			_tmp201_ = cl;
			_tmp202_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp201_, "CCode", "ref_sink_function", NULL);
			_tmp203_ = _tmp202_;
			_tmp204_ = _tmp203_ != NULL;
			_g_free0 (_tmp203_);
			if (_tmp204_) {
				ValaDataType* _tmp205_;
				ValaDataType* _tmp206_;
				_tmp205_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp206_ = _tmp205_;
				vala_data_type_set_floating_reference (_tmp206_, TRUE);
				break;
			}
			_tmp207_ = cl;
			_tmp208_ = vala_class_get_base_class (_tmp207_);
			_tmp209_ = _tmp208_;
			_tmp210_ = _vala_code_node_ref0 (_tmp209_);
			_vala_code_node_unref0 (cl);
			cl = _tmp210_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp211_;
		_tmp211_ = type;
		if (VALA_IS_STRUCT (_tmp211_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp212_;
			ValaStruct* _tmp213_;
			ValaStruct* _tmp214_;
			ValaList* _tmp215_;
			ValaList* _tmp216_;
			gint _tmp217_;
			gint _tmp218_;
			gboolean _tmp219_ = FALSE;
			gboolean _tmp220_;
			ValaSymbol* _tmp225_;
			ValaSymbol* _tmp226_;
			gboolean _tmp230_ = FALSE;
			gboolean _tmp231_ = FALSE;
			ValaStruct* _tmp232_;
			_tmp212_ = type;
			_tmp213_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp212_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp213_;
			_tmp214_ = st;
			_tmp215_ = vala_struct_get_type_parameters (_tmp214_);
			_tmp216_ = _tmp215_;
			_tmp217_ = vala_collection_get_size ((ValaCollection*) _tmp216_);
			_tmp218_ = _tmp217_;
			expected_num_type_args = _tmp218_;
			_vala_iterable_unref0 (_tmp216_);
			_tmp220_ = self->priv->_struct_creation;
			if (!_tmp220_) {
				gboolean _tmp221_;
				gboolean _tmp222_;
				_tmp221_ = vala_code_context_get_deprecated (context);
				_tmp222_ = _tmp221_;
				_tmp219_ = !_tmp222_;
			} else {
				_tmp219_ = FALSE;
			}
			if (_tmp219_) {
				ValaSourceReference* _tmp223_;
				ValaSourceReference* _tmp224_;
				_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp224_ = _tmp223_;
				vala_report_warning (_tmp224_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp225_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp226_ = _tmp225_;
			if (_tmp226_ == NULL) {
				ValaStruct* _tmp227_;
				ValaMethod* _tmp228_;
				ValaMethod* _tmp229_;
				_tmp227_ = st;
				_tmp228_ = vala_struct_get_default_construction_method (_tmp227_);
				_tmp229_ = _tmp228_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp229_);
			}
			_tmp232_ = st;
			if (vala_struct_is_simple_type (_tmp232_)) {
				ValaSymbol* _tmp233_;
				ValaSymbol* _tmp234_;
				_tmp233_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp234_ = _tmp233_;
				_tmp231_ = _tmp234_ == NULL;
			} else {
				_tmp231_ = FALSE;
			}
			if (_tmp231_) {
				ValaList* _tmp235_;
				gint _tmp236_;
				gint _tmp237_;
				_tmp235_ = self->priv->object_initializer;
				_tmp236_ = vala_collection_get_size ((ValaCollection*) _tmp235_);
				_tmp237_ = _tmp236_;
				_tmp230_ = _tmp237_ == 0;
			} else {
				_tmp230_ = FALSE;
			}
			if (_tmp230_) {
				ValaSourceReference* _tmp238_;
				ValaSourceReference* _tmp239_;
				ValaStruct* _tmp240_;
				gchar* _tmp241_;
				gchar* _tmp242_;
				gchar* _tmp243_;
				gchar* _tmp244_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp239_ = _tmp238_;
				_tmp240_ = st;
				_tmp241_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp240_);
				_tmp242_ = _tmp241_;
				_tmp243_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp242_);
				_tmp244_ = _tmp243_;
				vala_report_error (_tmp239_, _tmp244_);
				_g_free0 (_tmp244_);
				_g_free0 (_tmp242_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp245_ = expected_num_type_args;
	_tmp246_ = given_num_type_args;
	if (_tmp245_ > _tmp246_) {
		ValaSourceReference* _tmp247_;
		ValaSourceReference* _tmp248_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp247_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp248_ = _tmp247_;
		vala_report_error (_tmp248_, "too few type arguments");
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	} else {
		gint _tmp249_;
		gint _tmp250_;
		_tmp249_ = expected_num_type_args;
		_tmp250_ = given_num_type_args;
		if (_tmp249_ < _tmp250_) {
			ValaSourceReference* _tmp251_;
			ValaSourceReference* _tmp252_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp251_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp252_ = _tmp251_;
			vala_report_error (_tmp252_, "too many type arguments");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp254_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp255_ = _tmp254_;
	if (_tmp255_ == NULL) {
		ValaList* _tmp256_;
		ValaList* _tmp257_;
		gint _tmp258_;
		gint _tmp259_;
		_tmp256_ = vala_object_creation_expression_get_argument_list (self);
		_tmp257_ = _tmp256_;
		_tmp258_ = vala_collection_get_size ((ValaCollection*) _tmp257_);
		_tmp259_ = _tmp258_;
		_tmp253_ = _tmp259_ != 0;
		_vala_iterable_unref0 (_tmp257_);
	} else {
		_tmp253_ = FALSE;
	}
	if (_tmp253_) {
		ValaSourceReference* _tmp260_;
		ValaSourceReference* _tmp261_;
		ValaTypeSymbol* _tmp262_;
		gchar* _tmp263_;
		gchar* _tmp264_;
		gchar* _tmp265_;
		gchar* _tmp266_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp260_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp261_ = _tmp260_;
		_tmp262_ = type;
		_tmp263_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp262_);
		_tmp264_ = _tmp263_;
		_tmp265_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp264_);
		_tmp266_ = _tmp265_;
		vala_report_error (_tmp261_, _tmp266_);
		_g_free0 (_tmp266_);
		_g_free0 (_tmp264_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp267_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp268_ = _tmp267_;
	if (VALA_IS_METHOD (_tmp268_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp269_;
		ValaSymbol* _tmp270_;
		ValaMethod* _tmp271_;
		gboolean _tmp272_;
		ValaExpression* last_arg = NULL;
		ValaList* args = NULL;
		ValaList* _tmp291_;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp292_;
		ValaIterator* _tmp293_;
		ValaMethod* _tmp326_;
		gboolean _tmp327_;
		gboolean _tmp328_;
		ValaSemanticAnalyzer* _tmp393_;
		ValaSemanticAnalyzer* _tmp394_;
		ValaMethod* _tmp395_;
		ValaMethodType* _tmp396_;
		ValaMethodType* _tmp397_;
		ValaMethod* _tmp398_;
		ValaList* _tmp399_;
		ValaList* _tmp400_;
		ValaList* _tmp401_;
		_tmp269_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp270_ = _tmp269_;
		_tmp271_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp270_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp271_;
		_tmp272_ = self->priv->_is_yield_expression;
		if (_tmp272_) {
			ValaMethod* _tmp273_;
			gboolean _tmp274_;
			gboolean _tmp275_;
			gboolean _tmp278_ = FALSE;
			ValaSemanticAnalyzer* _tmp279_;
			ValaSemanticAnalyzer* _tmp280_;
			ValaMethod* _tmp281_;
			ValaMethod* _tmp282_;
			_tmp273_ = m;
			_tmp274_ = vala_method_get_coroutine (_tmp273_);
			_tmp275_ = _tmp274_;
			if (!_tmp275_) {
				ValaSourceReference* _tmp276_;
				ValaSourceReference* _tmp277_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp277_ = _tmp276_;
				vala_report_error (_tmp277_, "yield expression requires async method");
			}
			_tmp279_ = vala_code_context_get_analyzer (context);
			_tmp280_ = _tmp279_;
			_tmp281_ = vala_semantic_analyzer_get_current_method (_tmp280_);
			_tmp282_ = _tmp281_;
			if (_tmp282_ == NULL) {
				_tmp278_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp283_;
				ValaSemanticAnalyzer* _tmp284_;
				ValaMethod* _tmp285_;
				ValaMethod* _tmp286_;
				gboolean _tmp287_;
				gboolean _tmp288_;
				_tmp283_ = vala_code_context_get_analyzer (context);
				_tmp284_ = _tmp283_;
				_tmp285_ = vala_semantic_analyzer_get_current_method (_tmp284_);
				_tmp286_ = _tmp285_;
				_tmp287_ = vala_method_get_coroutine (_tmp286_);
				_tmp288_ = _tmp287_;
				_tmp278_ = !_tmp288_;
			}
			if (_tmp278_) {
				ValaSourceReference* _tmp289_;
				ValaSourceReference* _tmp290_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp289_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp290_ = _tmp289_;
				vala_report_error (_tmp290_, "yield expression not available outside async method");
			}
		}
		last_arg = NULL;
		_tmp291_ = vala_object_creation_expression_get_argument_list (self);
		args = _tmp291_;
		_tmp292_ = args;
		_tmp293_ = vala_iterable_iterator ((ValaIterable*) _tmp292_);
		arg_it = _tmp293_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp294_;
			ValaList* _tmp295_;
			gint _param_size = 0;
			ValaList* _tmp296_;
			gint _tmp297_;
			gint _tmp298_;
			gint _param_index = 0;
			_tmp294_ = m;
			_tmp295_ = vala_callable_get_parameters ((ValaCallable*) _tmp294_);
			_param_list = _tmp295_;
			_tmp296_ = _param_list;
			_tmp297_ = vala_collection_get_size ((ValaCollection*) _tmp296_);
			_tmp298_ = _tmp297_;
			_param_size = _tmp298_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp299_;
				gint _tmp300_;
				gint _tmp301_;
				ValaParameter* param = NULL;
				ValaList* _tmp302_;
				gint _tmp303_;
				gpointer _tmp304_;
				ValaParameter* _tmp305_;
				ValaParameter* _tmp306_;
				gboolean _tmp307_;
				gboolean _tmp308_;
				ValaIterator* _tmp309_;
				_tmp299_ = _param_index;
				_param_index = _tmp299_ + 1;
				_tmp300_ = _param_index;
				_tmp301_ = _param_size;
				if (!(_tmp300_ < _tmp301_)) {
					break;
				}
				_tmp302_ = _param_list;
				_tmp303_ = _param_index;
				_tmp304_ = vala_list_get (_tmp302_, _tmp303_);
				param = (ValaParameter*) _tmp304_;
				_tmp305_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp305_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp306_ = param;
				_tmp307_ = vala_parameter_get_ellipsis (_tmp306_);
				_tmp308_ = _tmp307_;
				if (_tmp308_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp309_ = arg_it;
				if (vala_iterator_next (_tmp309_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp310_;
					gpointer _tmp311_;
					ValaExpression* _tmp312_;
					ValaParameter* _tmp313_;
					ValaDataType* _tmp314_;
					ValaDataType* _tmp315_;
					ValaExpression* _tmp316_;
					ValaExpression* _tmp317_;
					ValaDataType* _tmp318_;
					ValaDataType* _tmp319_;
					ValaDataType* _tmp320_;
					ValaDataType* _tmp321_;
					ValaDataType* _tmp322_;
					ValaDataType* _tmp323_;
					ValaExpression* _tmp324_;
					ValaExpression* _tmp325_;
					_tmp310_ = arg_it;
					_tmp311_ = vala_iterator_get (_tmp310_);
					arg = (ValaExpression*) _tmp311_;
					_tmp312_ = arg;
					_tmp313_ = param;
					_tmp314_ = vala_variable_get_variable_type ((ValaVariable*) _tmp313_);
					_tmp315_ = _tmp314_;
					vala_expression_set_formal_target_type (_tmp312_, _tmp315_);
					_tmp316_ = arg;
					_tmp317_ = arg;
					_tmp318_ = vala_expression_get_formal_target_type (_tmp317_);
					_tmp319_ = _tmp318_;
					_tmp320_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp321_ = _tmp320_;
					_tmp322_ = vala_data_type_get_actual_type (_tmp319_, _tmp321_, NULL, (ValaCodeNode*) self);
					_tmp323_ = _tmp322_;
					vala_expression_set_target_type (_tmp316_, _tmp323_);
					_vala_code_node_unref0 (_tmp323_);
					_tmp324_ = arg;
					_tmp325_ = _vala_code_node_ref0 (_tmp324_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp325_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp326_ = m;
		_tmp327_ = vala_method_get_printf_format (_tmp326_);
		_tmp328_ = _tmp327_;
		if (_tmp328_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp329_;
			ValaStringLiteral* _tmp372_;
			format_literal = NULL;
			_tmp329_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp329_)) {
			} else {
				ValaExpression* _tmp330_;
				_tmp330_ = last_arg;
				if (_tmp330_ != NULL) {
					ValaExpression* _tmp331_;
					ValaStringLiteral* _tmp332_;
					gboolean _tmp333_ = FALSE;
					ValaStringLiteral* _tmp334_;
					_tmp331_ = last_arg;
					_tmp332_ = vala_string_literal_get_format_literal (_tmp331_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp332_;
					_tmp334_ = format_literal;
					if (_tmp334_ == NULL) {
						ValaList* _tmp335_;
						gint _tmp336_;
						gint _tmp337_;
						ValaMethod* _tmp338_;
						ValaList* _tmp339_;
						ValaList* _tmp340_;
						gint _tmp341_;
						gint _tmp342_;
						_tmp335_ = args;
						_tmp336_ = vala_collection_get_size ((ValaCollection*) _tmp335_);
						_tmp337_ = _tmp336_;
						_tmp338_ = m;
						_tmp339_ = vala_callable_get_parameters ((ValaCallable*) _tmp338_);
						_tmp340_ = _tmp339_;
						_tmp341_ = vala_collection_get_size ((ValaCollection*) _tmp340_);
						_tmp342_ = _tmp341_;
						_tmp333_ = _tmp337_ == (_tmp342_ - 1);
						_vala_iterable_unref0 (_tmp340_);
					} else {
						_tmp333_ = FALSE;
					}
					if (_tmp333_) {
						ValaStringLiteral* _tmp343_;
						ValaStringLiteral* _tmp344_;
						ValaSemanticAnalyzer* _tmp345_;
						ValaSemanticAnalyzer* _tmp346_;
						ValaDataType* _tmp347_;
						ValaDataType* _tmp348_;
						ValaDataType* _tmp349_;
						ValaList* _tmp350_;
						ValaList* _tmp351_;
						gint _tmp352_;
						gint _tmp353_;
						ValaStringLiteral* _tmp354_;
						ValaList* _tmp355_;
						ValaIterator* _tmp356_;
						_tmp343_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp343_;
						_tmp344_ = format_literal;
						_tmp345_ = vala_code_context_get_analyzer (context);
						_tmp346_ = _tmp345_;
						_tmp347_ = _tmp346_->string_type;
						_tmp348_ = vala_data_type_copy (_tmp347_);
						_tmp349_ = _tmp348_;
						vala_expression_set_target_type ((ValaExpression*) _tmp344_, _tmp349_);
						_vala_code_node_unref0 (_tmp349_);
						_tmp350_ = self->priv->argument_list;
						_tmp351_ = args;
						_tmp352_ = vala_collection_get_size ((ValaCollection*) _tmp351_);
						_tmp353_ = _tmp352_;
						_tmp354_ = format_literal;
						vala_list_insert (_tmp350_, _tmp353_ - 1, (ValaExpression*) _tmp354_);
						_tmp355_ = self->priv->argument_list;
						_tmp356_ = vala_iterable_iterator ((ValaIterable*) _tmp355_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp356_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp357_;
							ValaList* _tmp358_;
							gint _param_size = 0;
							ValaList* _tmp359_;
							gint _tmp360_;
							gint _tmp361_;
							gint _param_index = 0;
							_tmp357_ = m;
							_tmp358_ = vala_callable_get_parameters ((ValaCallable*) _tmp357_);
							_param_list = _tmp358_;
							_tmp359_ = _param_list;
							_tmp360_ = vala_collection_get_size ((ValaCollection*) _tmp359_);
							_tmp361_ = _tmp360_;
							_param_size = _tmp361_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp362_;
								gint _tmp363_;
								gint _tmp364_;
								ValaParameter* param = NULL;
								ValaList* _tmp365_;
								gint _tmp366_;
								gpointer _tmp367_;
								ValaParameter* _tmp368_;
								gboolean _tmp369_;
								gboolean _tmp370_;
								ValaIterator* _tmp371_;
								_tmp362_ = _param_index;
								_param_index = _tmp362_ + 1;
								_tmp363_ = _param_index;
								_tmp364_ = _param_size;
								if (!(_tmp363_ < _tmp364_)) {
									break;
								}
								_tmp365_ = _param_list;
								_tmp366_ = _param_index;
								_tmp367_ = vala_list_get (_tmp365_, _tmp366_);
								param = (ValaParameter*) _tmp367_;
								_tmp368_ = param;
								_tmp369_ = vala_parameter_get_ellipsis (_tmp368_);
								_tmp370_ = _tmp369_;
								if (_tmp370_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp371_ = arg_it;
								vala_iterator_next (_tmp371_);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
					}
				}
			}
			_tmp372_ = format_literal;
			if (_tmp372_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp373_;
				gchar* _tmp374_;
				ValaSemanticAnalyzer* _tmp375_;
				ValaSemanticAnalyzer* _tmp376_;
				const gchar* _tmp377_;
				ValaIterator* _tmp378_;
				ValaSourceReference* _tmp379_;
				ValaSourceReference* _tmp380_;
				_tmp373_ = format_literal;
				_tmp374_ = vala_string_literal_eval (_tmp373_);
				format = _tmp374_;
				_tmp375_ = vala_code_context_get_analyzer (context);
				_tmp376_ = _tmp375_;
				_tmp377_ = format;
				_tmp378_ = arg_it;
				_tmp379_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp380_ = _tmp379_;
				if (!vala_semantic_analyzer_check_print_format (_tmp376_, _tmp377_, _tmp378_, _tmp380_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_iterable_unref0 (args);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp381_;
			ValaList* _tmp382_;
			gint _arg_size = 0;
			ValaList* _tmp383_;
			gint _tmp384_;
			gint _tmp385_;
			gint _arg_index = 0;
			_tmp381_ = args;
			_tmp382_ = _vala_iterable_ref0 (_tmp381_);
			_arg_list = _tmp382_;
			_tmp383_ = _arg_list;
			_tmp384_ = vala_collection_get_size ((ValaCollection*) _tmp383_);
			_tmp385_ = _tmp384_;
			_arg_size = _tmp385_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp386_;
				gint _tmp387_;
				gint _tmp388_;
				ValaExpression* arg = NULL;
				ValaList* _tmp389_;
				gint _tmp390_;
				gpointer _tmp391_;
				ValaExpression* _tmp392_;
				_tmp386_ = _arg_index;
				_arg_index = _tmp386_ + 1;
				_tmp387_ = _arg_index;
				_tmp388_ = _arg_size;
				if (!(_tmp387_ < _tmp388_)) {
					break;
				}
				_tmp389_ = _arg_list;
				_tmp390_ = _arg_index;
				_tmp391_ = vala_list_get (_tmp389_, _tmp390_);
				arg = (ValaExpression*) _tmp391_;
				_tmp392_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp392_, context);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp393_ = vala_code_context_get_analyzer (context);
		_tmp394_ = _tmp393_;
		_tmp395_ = m;
		_tmp396_ = vala_method_type_new (_tmp395_);
		_tmp397_ = _tmp396_;
		_tmp398_ = m;
		_tmp399_ = vala_callable_get_parameters ((ValaCallable*) _tmp398_);
		_tmp400_ = _tmp399_;
		_tmp401_ = args;
		vala_semantic_analyzer_check_arguments (_tmp394_, (ValaExpression*) self, (ValaDataType*) _tmp397_, _tmp400_, _tmp401_);
		_vala_iterable_unref0 (_tmp400_);
		_vala_code_node_unref0 (_tmp397_);
		{
			ValaList* _error_type_list = NULL;
			ValaMethod* _tmp402_;
			ValaList* _tmp403_;
			gint _error_type_size = 0;
			ValaList* _tmp404_;
			gint _tmp405_;
			gint _tmp406_;
			gint _error_type_index = 0;
			_tmp402_ = m;
			_tmp403_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp402_);
			_error_type_list = _tmp403_;
			_tmp404_ = _error_type_list;
			_tmp405_ = vala_collection_get_size ((ValaCollection*) _tmp404_);
			_tmp406_ = _tmp405_;
			_error_type_size = _tmp406_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp407_;
				gint _tmp408_;
				gint _tmp409_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp410_;
				gint _tmp411_;
				gpointer _tmp412_;
				ValaDataType* call_error_type = NULL;
				ValaDataType* _tmp413_;
				ValaDataType* _tmp414_;
				ValaDataType* _tmp415_;
				ValaSourceReference* _tmp416_;
				ValaSourceReference* _tmp417_;
				ValaDataType* _tmp418_;
				_tmp407_ = _error_type_index;
				_error_type_index = _tmp407_ + 1;
				_tmp408_ = _error_type_index;
				_tmp409_ = _error_type_size;
				if (!(_tmp408_ < _tmp409_)) {
					break;
				}
				_tmp410_ = _error_type_list;
				_tmp411_ = _error_type_index;
				_tmp412_ = vala_list_get (_tmp410_, _tmp411_);
				error_type = (ValaDataType*) _tmp412_;
				may_throw = TRUE;
				_tmp413_ = error_type;
				_tmp414_ = vala_data_type_copy (_tmp413_);
				call_error_type = _tmp414_;
				_tmp415_ = call_error_type;
				_tmp416_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp417_ = _tmp416_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp415_, _tmp417_);
				_tmp418_ = call_error_type;
				vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp418_);
				_vala_code_node_unref0 (call_error_type);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp419_;
		ValaDataType* _tmp420_;
		_tmp419_ = vala_object_creation_expression_get_type_reference (self);
		_tmp420_ = _tmp419_;
		if (VALA_IS_ERROR_TYPE (_tmp420_)) {
			ValaDataType* _tmp421_;
			ValaDataType* _tmp422_;
			ValaMemberAccess* _tmp425_;
			ValaMemberAccess* _tmp426_;
			ValaList* _tmp453_;
			ValaList* _tmp454_;
			gint _tmp455_;
			gint _tmp456_;
			gboolean _tmp457_;
			_tmp421_ = vala_object_creation_expression_get_type_reference (self);
			_tmp422_ = _tmp421_;
			if (_tmp422_ != NULL) {
				ValaDataType* _tmp423_;
				ValaDataType* _tmp424_;
				_tmp423_ = vala_object_creation_expression_get_type_reference (self);
				_tmp424_ = _tmp423_;
				vala_code_node_check ((ValaCodeNode*) _tmp424_, context);
			}
			_tmp425_ = vala_object_creation_expression_get_member_name (self);
			_tmp426_ = _tmp425_;
			if (_tmp426_ != NULL) {
				ValaMemberAccess* _tmp427_;
				ValaMemberAccess* _tmp428_;
				_tmp427_ = vala_object_creation_expression_get_member_name (self);
				_tmp428_ = _tmp427_;
				vala_code_node_check ((ValaCodeNode*) _tmp428_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp429_;
				ValaList* _tmp430_;
				gint _arg_size = 0;
				ValaList* _tmp431_;
				gint _tmp432_;
				gint _tmp433_;
				gint _arg_index = 0;
				_tmp429_ = self->priv->argument_list;
				_tmp430_ = _vala_iterable_ref0 (_tmp429_);
				_arg_list = _tmp430_;
				_tmp431_ = _arg_list;
				_tmp432_ = vala_collection_get_size ((ValaCollection*) _tmp431_);
				_tmp433_ = _tmp432_;
				_arg_size = _tmp433_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp434_;
					gint _tmp435_;
					gint _tmp436_;
					ValaExpression* arg = NULL;
					ValaList* _tmp437_;
					gint _tmp438_;
					gpointer _tmp439_;
					ValaExpression* _tmp440_;
					_tmp434_ = _arg_index;
					_arg_index = _tmp434_ + 1;
					_tmp435_ = _arg_index;
					_tmp436_ = _arg_size;
					if (!(_tmp435_ < _tmp436_)) {
						break;
					}
					_tmp437_ = _arg_list;
					_tmp438_ = _arg_index;
					_tmp439_ = vala_list_get (_tmp437_, _tmp438_);
					arg = (ValaExpression*) _tmp439_;
					_tmp440_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp440_, context);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp441_;
				ValaList* _tmp442_;
				gint _init_size = 0;
				ValaList* _tmp443_;
				gint _tmp444_;
				gint _tmp445_;
				gint _init_index = 0;
				_tmp441_ = self->priv->object_initializer;
				_tmp442_ = _vala_iterable_ref0 (_tmp441_);
				_init_list = _tmp442_;
				_tmp443_ = _init_list;
				_tmp444_ = vala_collection_get_size ((ValaCollection*) _tmp443_);
				_tmp445_ = _tmp444_;
				_init_size = _tmp445_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp446_;
					gint _tmp447_;
					gint _tmp448_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp449_;
					gint _tmp450_;
					gpointer _tmp451_;
					ValaMemberInitializer* _tmp452_;
					_tmp446_ = _init_index;
					_init_index = _tmp446_ + 1;
					_tmp447_ = _init_index;
					_tmp448_ = _init_size;
					if (!(_tmp447_ < _tmp448_)) {
						break;
					}
					_tmp449_ = _init_list;
					_tmp450_ = _init_index;
					_tmp451_ = vala_list_get (_tmp449_, _tmp450_);
					init = (ValaMemberInitializer*) _tmp451_;
					_tmp452_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp452_, context);
					_vala_code_node_unref0 (init);
				}
				_vala_iterable_unref0 (_init_list);
			}
			_tmp453_ = vala_object_creation_expression_get_argument_list (self);
			_tmp454_ = _tmp453_;
			_tmp455_ = vala_collection_get_size ((ValaCollection*) _tmp454_);
			_tmp456_ = _tmp455_;
			_tmp457_ = _tmp456_ == 0;
			_vala_iterable_unref0 (_tmp454_);
			if (_tmp457_) {
				ValaSourceReference* _tmp458_;
				ValaSourceReference* _tmp459_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp458_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp459_ = _tmp458_;
				vala_report_error (_tmp459_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp460_;
				ValaList* _tmp461_;
				ValaIterator* _tmp462_;
				ValaIterator* _tmp463_;
				ValaIterator* _tmp464_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp465_;
				gpointer _tmp466_;
				gboolean _tmp467_ = FALSE;
				ValaExpression* _tmp468_;
				ValaDataType* _tmp469_;
				ValaDataType* _tmp470_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp479_;
				ValaStringLiteral* _tmp480_;
				ValaStringLiteral* _tmp481_;
				ValaList* _tmp490_;
				ValaList* _tmp491_;
				ValaIterator* _tmp492_;
				ValaIterator* _tmp493_;
				ValaSemanticAnalyzer* _tmp494_;
				ValaSemanticAnalyzer* _tmp495_;
				ValaIterator* _tmp496_;
				ValaSourceReference* _tmp497_;
				ValaSourceReference* _tmp498_;
				_tmp460_ = vala_object_creation_expression_get_argument_list (self);
				_tmp461_ = _tmp460_;
				_tmp462_ = vala_iterable_iterator ((ValaIterable*) _tmp461_);
				_tmp463_ = _tmp462_;
				_vala_iterable_unref0 (_tmp461_);
				arg_it = _tmp463_;
				_tmp464_ = arg_it;
				vala_iterator_next (_tmp464_);
				_tmp465_ = arg_it;
				_tmp466_ = vala_iterator_get (_tmp465_);
				ex = (ValaExpression*) _tmp466_;
				_tmp468_ = ex;
				_tmp469_ = vala_expression_get_value_type (_tmp468_);
				_tmp470_ = _tmp469_;
				if (_tmp470_ == NULL) {
					_tmp467_ = TRUE;
				} else {
					ValaExpression* _tmp471_;
					ValaDataType* _tmp472_;
					ValaDataType* _tmp473_;
					ValaSemanticAnalyzer* _tmp474_;
					ValaSemanticAnalyzer* _tmp475_;
					ValaDataType* _tmp476_;
					_tmp471_ = ex;
					_tmp472_ = vala_expression_get_value_type (_tmp471_);
					_tmp473_ = _tmp472_;
					_tmp474_ = vala_code_context_get_analyzer (context);
					_tmp475_ = _tmp474_;
					_tmp476_ = _tmp475_->string_type;
					_tmp467_ = !vala_data_type_compatible (_tmp473_, _tmp476_);
				}
				if (_tmp467_) {
					ValaSourceReference* _tmp477_;
					ValaSourceReference* _tmp478_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp477_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp478_ = _tmp477_;
					vala_report_error (_tmp478_, "Invalid type for argument 1");
				}
				_tmp479_ = ex;
				_tmp480_ = vala_string_literal_get_format_literal (_tmp479_);
				format_literal = _tmp480_;
				_tmp481_ = format_literal;
				if (_tmp481_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp482_;
					gchar* _tmp483_;
					ValaSemanticAnalyzer* _tmp484_;
					ValaSemanticAnalyzer* _tmp485_;
					const gchar* _tmp486_;
					ValaIterator* _tmp487_;
					ValaSourceReference* _tmp488_;
					ValaSourceReference* _tmp489_;
					_tmp482_ = format_literal;
					_tmp483_ = vala_string_literal_eval (_tmp482_);
					format = _tmp483_;
					_tmp484_ = vala_code_context_get_analyzer (context);
					_tmp485_ = _tmp484_;
					_tmp486_ = format;
					_tmp487_ = arg_it;
					_tmp488_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp489_ = _tmp488_;
					if (!vala_semantic_analyzer_check_print_format (_tmp485_, _tmp486_, _tmp487_, _tmp489_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp490_ = vala_object_creation_expression_get_argument_list (self);
				_tmp491_ = _tmp490_;
				_tmp492_ = vala_iterable_iterator ((ValaIterable*) _tmp491_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp492_;
				_vala_iterable_unref0 (_tmp491_);
				_tmp493_ = arg_it;
				vala_iterator_next (_tmp493_);
				_tmp494_ = vala_code_context_get_analyzer (context);
				_tmp495_ = _tmp494_;
				_tmp496_ = arg_it;
				_tmp497_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp498_ = _tmp497_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp495_, _tmp496_, 1, _tmp498_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp499_;
		gint _arg_size = 0;
		ValaList* _tmp500_;
		gint _tmp501_;
		gint _tmp502_;
		gint _arg_index = 0;
		_tmp499_ = vala_object_creation_expression_get_argument_list (self);
		_arg_list = _tmp499_;
		_tmp500_ = _arg_list;
		_tmp501_ = vala_collection_get_size ((ValaCollection*) _tmp500_);
		_tmp502_ = _tmp501_;
		_arg_size = _tmp502_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp503_;
			gint _tmp504_;
			gint _tmp505_;
			ValaExpression* arg = NULL;
			ValaList* _tmp506_;
			gint _tmp507_;
			gpointer _tmp508_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp509_;
			gboolean _tmp510_ = FALSE;
			ValaSizeofExpression* _tmp511_;
			_tmp503_ = _arg_index;
			_arg_index = _tmp503_ + 1;
			_tmp504_ = _arg_index;
			_tmp505_ = _arg_size;
			if (!(_tmp504_ < _tmp505_)) {
				break;
			}
			_tmp506_ = _arg_list;
			_tmp507_ = _arg_index;
			_tmp508_ = vala_list_get (_tmp506_, _tmp507_);
			arg = (ValaExpression*) _tmp508_;
			_tmp509_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp509_) ? ((ValaSizeofExpression*) _tmp509_) : NULL;
			_tmp511_ = sizeof_expr;
			if (_tmp511_ != NULL) {
				ValaSizeofExpression* _tmp512_;
				ValaDataType* _tmp513_;
				ValaDataType* _tmp514_;
				_tmp512_ = sizeof_expr;
				_tmp513_ = vala_sizeof_expression_get_type_reference (_tmp512_);
				_tmp514_ = _tmp513_;
				_tmp510_ = VALA_IS_GENERIC_TYPE (_tmp514_);
			} else {
				_tmp510_ = FALSE;
			}
			if (_tmp510_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp515_;
				ValaDataType* _tmp516_;
				ValaDataType* _tmp517_;
				ValaDataType* _tmp518_;
				ValaDataType* _tmp519_;
				ValaDataType* _tmp520_;
				ValaDataType* _tmp521_;
				ValaList* _tmp522_;
				ValaList* _tmp523_;
				ValaDataType* _tmp524_;
				ValaDataType* _tmp525_;
				ValaExpression* _tmp526_;
				ValaDataType* _tmp527_;
				ValaSourceReference* _tmp528_;
				ValaSourceReference* _tmp529_;
				ValaSizeofExpression* _tmp530_;
				ValaSizeofExpression* _tmp531_;
				_tmp515_ = sizeof_expr;
				_tmp516_ = vala_sizeof_expression_get_type_reference (_tmp515_);
				_tmp517_ = _tmp516_;
				_tmp518_ = vala_object_creation_expression_get_type_reference (self);
				_tmp519_ = _tmp518_;
				_tmp520_ = vala_object_creation_expression_get_type_reference (self);
				_tmp521_ = _tmp520_;
				_tmp522_ = vala_data_type_get_type_arguments (_tmp521_);
				_tmp523_ = _tmp522_;
				_tmp524_ = vala_data_type_get_actual_type (_tmp517_, _tmp519_, _tmp523_, (ValaCodeNode*) self);
				_tmp525_ = _tmp524_;
				_vala_iterable_unref0 (_tmp523_);
				sizeof_type = _tmp525_;
				_tmp526_ = arg;
				_tmp527_ = sizeof_type;
				_tmp528_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp529_ = _tmp528_;
				_tmp530_ = vala_sizeof_expression_new (_tmp527_, _tmp529_);
				_tmp531_ = _tmp530_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp526_, (ValaExpression*) _tmp531_);
				_vala_code_node_unref0 (_tmp531_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp532_;
		gint _init_size = 0;
		ValaList* _tmp533_;
		gint _tmp534_;
		gint _tmp535_;
		gint _init_index = 0;
		_tmp532_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp532_;
		_tmp533_ = _init_list;
		_tmp534_ = vala_collection_get_size ((ValaCollection*) _tmp533_);
		_tmp535_ = _tmp534_;
		_init_size = _tmp535_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp536_;
			gint _tmp537_;
			gint _tmp538_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp539_;
			gint _tmp540_;
			gpointer _tmp541_;
			ValaSemanticAnalyzer* _tmp542_;
			ValaSemanticAnalyzer* _tmp543_;
			ValaMemberInitializer* _tmp544_;
			ValaDataType* _tmp545_;
			ValaDataType* _tmp546_;
			_tmp536_ = _init_index;
			_init_index = _tmp536_ + 1;
			_tmp537_ = _init_index;
			_tmp538_ = _init_size;
			if (!(_tmp537_ < _tmp538_)) {
				break;
			}
			_tmp539_ = _init_list;
			_tmp540_ = _init_index;
			_tmp541_ = vala_list_get (_tmp539_, _tmp540_);
			init = (ValaMemberInitializer*) _tmp541_;
			_tmp542_ = vala_code_context_get_analyzer (context);
			_tmp543_ = _tmp542_;
			_tmp544_ = init;
			_tmp545_ = vala_object_creation_expression_get_type_reference (self);
			_tmp546_ = _tmp545_;
			vala_semantic_analyzer_visit_member_initializer (_tmp543_, _tmp544_, _tmp546_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp547_ = may_throw;
	if (_tmp547_) {
		gboolean _tmp548_ = FALSE;
		ValaCodeNode* _tmp549_;
		ValaCodeNode* _tmp550_;
		_tmp549_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp550_ = _tmp549_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp550_)) {
			_tmp548_ = TRUE;
		} else {
			ValaCodeNode* _tmp551_;
			ValaCodeNode* _tmp552_;
			_tmp551_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp552_ = _tmp551_;
			_tmp548_ = VALA_IS_EXPRESSION_STATEMENT (_tmp552_);
		}
		if (_tmp548_) {
		} else {
			ValaSemanticAnalyzer* _tmp553_;
			ValaSemanticAnalyzer* _tmp554_;
			ValaSymbol* _tmp555_;
			ValaSymbol* _tmp556_;
			_tmp553_ = vala_code_context_get_analyzer (context);
			_tmp554_ = _tmp553_;
			_tmp555_ = vala_semantic_analyzer_get_current_symbol (_tmp554_);
			_tmp556_ = _tmp555_;
			if (!VALA_IS_BLOCK (_tmp556_)) {
				ValaSourceReference* _tmp557_;
				ValaSourceReference* _tmp558_;
				_tmp557_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp558_ = _tmp557_;
				vala_report_error (_tmp558_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp559_;
				ValaCodeNode* _tmp560_;
				ValaCodeNode* _tmp561_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp562_;
				ValaDataType* _tmp563_;
				ValaDataType* _tmp564_;
				ValaDataType* _tmp565_;
				gchar* _tmp566_;
				gchar* _tmp567_;
				ValaSourceReference* _tmp568_;
				ValaSourceReference* _tmp569_;
				ValaLocalVariable* _tmp570_;
				ValaLocalVariable* _tmp571_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp572_;
				ValaSourceReference* _tmp573_;
				ValaSourceReference* _tmp574_;
				ValaDeclarationStatement* _tmp575_;
				ValaSemanticAnalyzer* _tmp576_;
				ValaSemanticAnalyzer* _tmp577_;
				ValaBlock* _tmp578_;
				ValaDeclarationStatement* _tmp579_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp580_;
				ValaDataType* _tmp581_;
				ValaDataType* _tmp582_;
				ValaExpression* _tmp583_;
				ValaLocalVariable* _tmp584_;
				ValaDeclarationStatement* _tmp585_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp586_;
				ValaSemanticAnalyzer* _tmp587_;
				ValaSymbol* _tmp588_;
				ValaSymbol* _tmp589_;
				ValaBlock* _tmp590_;
				ValaBlock* _tmp591_;
				ValaLocalVariable* _tmp592_;
				ValaSemanticAnalyzer* _tmp593_;
				ValaSemanticAnalyzer* _tmp594_;
				ValaBlock* _tmp595_;
				ValaLocalVariable* _tmp596_;
				ValaCodeNode* _tmp597_;
				ValaExpression* _tmp598_;
				ValaExpression* _tmp599_;
				_tmp559_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp560_ = _tmp559_;
				_tmp561_ = _vala_code_node_ref0 (_tmp560_);
				old_parent_node = _tmp561_;
				_tmp562_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp563_ = _tmp562_;
				_tmp564_ = vala_data_type_copy (_tmp563_);
				_tmp565_ = _tmp564_;
				_tmp566_ = vala_code_node_get_temp_name ();
				_tmp567_ = _tmp566_;
				_tmp568_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp569_ = _tmp568_;
				_tmp570_ = vala_local_variable_new (_tmp565_, _tmp567_, NULL, _tmp569_);
				_tmp571_ = _tmp570_;
				_g_free0 (_tmp567_);
				_vala_code_node_unref0 (_tmp565_);
				local = _tmp571_;
				_tmp572_ = local;
				_tmp573_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp574_ = _tmp573_;
				_tmp575_ = vala_declaration_statement_new ((ValaSymbol*) _tmp572_, _tmp574_);
				decl = _tmp575_;
				_tmp576_ = vala_code_context_get_analyzer (context);
				_tmp577_ = _tmp576_;
				_tmp578_ = _tmp577_->insert_block;
				_tmp579_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp578_, (ValaStatement*) _tmp579_);
				_tmp580_ = local;
				_tmp581_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp582_ = _tmp581_;
				_tmp583_ = vala_semantic_analyzer_create_temp_access (_tmp580_, _tmp582_);
				temp_access = _tmp583_;
				_tmp584_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp584_, (ValaExpression*) self);
				_tmp585_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp585_, context);
				_tmp586_ = vala_code_context_get_analyzer (context);
				_tmp587_ = _tmp586_;
				_tmp588_ = vala_semantic_analyzer_get_current_symbol (_tmp587_);
				_tmp589_ = _tmp588_;
				_tmp590_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp589_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp590_;
				_tmp591_ = block;
				_tmp592_ = local;
				vala_block_remove_local_variable (_tmp591_, _tmp592_);
				_tmp593_ = vala_code_context_get_analyzer (context);
				_tmp594_ = _tmp593_;
				_tmp595_ = _tmp594_->insert_block;
				_tmp596_ = local;
				vala_block_add_local_variable (_tmp595_, _tmp596_);
				_tmp597_ = old_parent_node;
				_tmp598_ = temp_access;
				vala_code_node_replace_expression (_tmp597_, (ValaExpression*) self, _tmp598_);
				_tmp599_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp599_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp600_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp601_ = _tmp600_;
	result = !_tmp601_;
	_vala_code_node_unref0 (type);
	return result;
}


static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, codegen);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _init_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _init_index = 0;
		_tmp12_ = self->priv->object_initializer;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_init_list = _tmp13_;
		_tmp14_ = _init_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_init_size = _tmp16_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaMemberInitializer* _tmp23_;
			_tmp17_ = _init_index;
			_init_index = _tmp17_ + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = _init_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			init = (ValaMemberInitializer*) _tmp22_;
			_tmp23_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp23_, codegen);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _init_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _init_index = 0;
		_tmp12_ = self->priv->object_initializer;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_init_list = _tmp13_;
		_tmp14_ = _init_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_init_size = _tmp16_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaMemberInitializer* _tmp23_;
			_tmp17_ = _init_index;
			_init_index = _tmp17_ + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = _init_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			init = (ValaMemberInitializer*) _tmp22_;
			_tmp23_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp23_, collection);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


gboolean
vala_object_creation_expression_get_is_yield_expression (ValaObjectCreationExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_is_yield_expression (ValaObjectCreationExpression* self,
                                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}


gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_struct_creation;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}


static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaObjectCreationExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
}


static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}


static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}


/**
 * Represents an object creation expression in the source code.
 */
GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}



