/* valapropertyaccessor.c generated by valac, the Vala compiler
 * generated from valapropertyaccessor.vala, do not modify */

/* valapropertyaccessor.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaPropertyAccessorPrivate {
	gboolean _readable;
	gboolean _writable;
	gboolean _construction;
	gboolean _automatic_body;
	ValaParameter* _value_parameter;
	ValaDataType* _value_type;
};


static gpointer vala_property_accessor_parent_class = NULL;

#define VALA_PROPERTY_ACCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorPrivate))
static void vala_property_accessor_set_readable (ValaPropertyAccessor* self,
                                          gboolean value);
static void vala_property_accessor_set_writable (ValaPropertyAccessor* self,
                                          gboolean value);
static void vala_property_accessor_set_construction (ValaPropertyAccessor* self,
                                              gboolean value);
static void vala_property_accessor_set_value_type (ValaPropertyAccessor* self,
                                            ValaDataType* value);
static void vala_property_accessor_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_property_accessor_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static gboolean vala_property_accessor_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self,
                                                 ValaParameter* value);
static void vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self,
                                                gboolean value);
static void vala_property_accessor_real_replace_type (ValaCodeNode* base,
                                               ValaDataType* old_type,
                                               ValaDataType* new_type);
static void vala_property_accessor_finalize (ValaCodeNode * obj);


/**
 * Creates a new property accessor.
 *
 * @param readable           true if get accessor, false otherwise
 * @param writable           true if set accessor, false otherwise
 * @param construction       true if construct accessor, false otherwise
 * @param body               accessor body
 * @param source_reference   reference to source code
 * @return                   newly created property accessor
 */
ValaPropertyAccessor*
vala_property_accessor_construct (GType object_type,
                                  gboolean readable,
                                  gboolean writable,
                                  gboolean construction,
                                  ValaDataType* value_type,
                                  ValaBlock* body,
                                  ValaSourceReference* source_reference,
                                  ValaComment* comment)
{
	ValaPropertyAccessor* self = NULL;
	self = (ValaPropertyAccessor*) vala_subroutine_construct (object_type, NULL, source_reference, comment);
	vala_property_accessor_set_readable (self, readable);
	vala_property_accessor_set_writable (self, writable);
	vala_property_accessor_set_construction (self, construction);
	vala_property_accessor_set_value_type (self, value_type);
	vala_subroutine_set_body ((ValaSubroutine*) self, body);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaPropertyAccessor*
vala_property_accessor_new (gboolean readable,
                            gboolean writable,
                            gboolean construction,
                            ValaDataType* value_type,
                            ValaBlock* body,
                            ValaSourceReference* source_reference,
                            ValaComment* comment)
{
	return vala_property_accessor_construct (VALA_TYPE_PROPERTY_ACCESSOR, readable, writable, construction, value_type, body, source_reference, comment);
}


static void
vala_property_accessor_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_property_accessor (visitor, self);
}


static void
vala_property_accessor_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaLocalVariable* _tmp2_;
	ValaLocalVariable* _tmp3_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp7_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaLocalVariable* _tmp4_;
		ValaLocalVariable* _tmp5_;
		_tmp4_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
	_tmp6_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaBlock* _tmp8_;
		ValaBlock* _tmp9_;
		_tmp8_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}


/**
 * Get the method representing this property accessor
 * @return   null if the accessor is neither readable nor writable
 */
ValaMethod*
vala_property_accessor_get_method (ValaPropertyAccessor* self)
{
	ValaMethod* result = NULL;
	ValaMethod* m = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	m = NULL;
	_tmp0_ = self->priv->_readable;
	if (_tmp0_) {
		ValaProperty* _tmp1_;
		ValaProperty* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaComment* _tmp11_;
		ValaComment* _tmp12_;
		ValaMethod* _tmp13_;
		_tmp1_ = vala_property_accessor_get_prop (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("get_%s", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_property_accessor_get_value_type (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_comment ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_method_new (_tmp6_, _tmp8_, _tmp10_, _tmp12_);
		_vala_code_node_unref0 (m);
		m = _tmp13_;
		_g_free0 (_tmp6_);
	} else {
		gboolean _tmp14_;
		_tmp14_ = self->priv->_writable;
		if (_tmp14_) {
			ValaProperty* _tmp15_;
			ValaProperty* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			ValaVoidType* _tmp21_;
			ValaVoidType* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaComment* _tmp25_;
			ValaComment* _tmp26_;
			ValaMethod* _tmp27_;
			ValaMethod* _tmp28_;
			ValaParameter* _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameter* _tmp31_;
			_tmp15_ = vala_property_accessor_get_prop (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf ("set_%s", _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_void_type_new (NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_symbol_get_comment ((ValaSymbol*) self);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_method_new (_tmp20_, (ValaDataType*) _tmp22_, _tmp24_, _tmp26_);
			_vala_code_node_unref0 (m);
			m = _tmp27_;
			_vala_code_node_unref0 (_tmp22_);
			_g_free0 (_tmp20_);
			_tmp28_ = m;
			_tmp29_ = self->priv->_value_parameter;
			_tmp30_ = vala_parameter_copy (_tmp29_);
			_tmp31_ = _tmp30_;
			vala_callable_add_parameter ((ValaCallable*) _tmp28_, _tmp31_);
			_vala_code_node_unref0 (_tmp31_);
		}
	}
	_tmp32_ = m;
	if (_tmp32_ != NULL) {
		ValaMethod* _tmp33_;
		ValaProperty* _tmp34_;
		ValaProperty* _tmp35_;
		ValaScope* _tmp36_;
		ValaScope* _tmp37_;
		ValaMethod* _tmp38_;
		ValaSymbolAccessibility _tmp39_;
		ValaSymbolAccessibility _tmp40_;
		ValaMethod* _tmp41_;
		ValaProperty* _tmp42_;
		ValaProperty* _tmp43_;
		ValaMemberBinding _tmp44_;
		ValaMemberBinding _tmp45_;
		ValaMethod* _tmp46_;
		ValaProperty* _tmp47_;
		ValaProperty* _tmp48_;
		gboolean _tmp49_;
		gboolean _tmp50_;
		ValaMethod* _tmp51_;
		ValaProperty* _tmp52_;
		ValaProperty* _tmp53_;
		gboolean _tmp54_;
		gboolean _tmp55_;
		_tmp33_ = m;
		_tmp34_ = vala_property_accessor_get_prop (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_symbol_get_owner ((ValaSymbol*) _tmp35_);
		_tmp37_ = _tmp36_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp33_, _tmp37_);
		_tmp38_ = m;
		_tmp39_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp40_ = _tmp39_;
		vala_symbol_set_access ((ValaSymbol*) _tmp38_, _tmp40_);
		_tmp41_ = m;
		_tmp42_ = vala_property_accessor_get_prop (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_property_get_binding (_tmp43_);
		_tmp45_ = _tmp44_;
		vala_method_set_binding (_tmp41_, _tmp45_);
		_tmp46_ = m;
		_tmp47_ = vala_property_accessor_get_prop (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_property_get_is_abstract (_tmp48_);
		_tmp50_ = _tmp49_;
		vala_method_set_is_abstract (_tmp46_, _tmp50_);
		_tmp51_ = m;
		_tmp52_ = vala_property_accessor_get_prop (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_property_get_is_virtual (_tmp53_);
		_tmp55_ = _tmp54_;
		vala_method_set_is_virtual (_tmp51_, _tmp55_);
	}
	result = m;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_property_accessor_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaPropertyAccessor * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSemanticAnalyzer* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_;
	ValaProperty* _tmp93_;
	ValaProperty* _tmp94_;
	ValaSourceFileType _tmp95_;
	ValaSourceFileType _tmp96_;
	gboolean _tmp152_ = FALSE;
	gboolean _tmp153_ = FALSE;
	gboolean _tmp154_ = FALSE;
	ValaProperty* _tmp155_;
	ValaProperty* _tmp156_;
	gboolean _tmp157_;
	gboolean _tmp158_;
	ValaBlock* _tmp177_;
	ValaBlock* _tmp178_;
	ValaSemanticAnalyzer* _tmp215_;
	ValaSemanticAnalyzer* _tmp216_;
	ValaSymbol* _tmp217_;
	gboolean _tmp218_;
	gboolean _tmp219_;
	self = (ValaPropertyAccessor*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_property_accessor_get_value_type (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_code_context_get_analyzer (context);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_semantic_analyzer_get_current_symbol (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _vala_code_node_ref0 (_tmp9_);
	old_symbol = _tmp10_;
	_tmp11_ = vala_code_context_get_analyzer (context);
	_tmp12_ = _tmp11_;
	vala_semantic_analyzer_set_current_symbol (_tmp12_, (ValaSymbol*) self);
	_tmp14_ = self->priv->_writable;
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp15_;
		_tmp15_ = self->priv->_construction;
		_tmp13_ = _tmp15_;
	}
	if (_tmp13_) {
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaParameter* _tmp20_;
		ValaParameter* _tmp21_;
		_tmp16_ = vala_property_accessor_get_value_type (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_parameter_new ("value", _tmp17_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_property_accessor_set_value_parameter (self, _tmp21_);
		_vala_code_node_unref0 (_tmp21_);
	}
	_tmp23_ = self->priv->_readable;
	if (_tmp23_) {
		ValaProperty* _tmp24_;
		ValaProperty* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaClass* _tmp30_;
		_tmp24_ = vala_property_accessor_get_prop (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_code_context_get_analyzer (context);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_->object_type;
		_tmp22_ = vala_typesymbol_is_subtype_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), (ValaTypeSymbol*) _tmp30_);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		ValaProperty* _tmp31_;
		ValaProperty* _tmp32_;
		ValaAttribute* _tmp33_;
		ValaAttribute* _tmp34_;
		gboolean _tmp35_;
		_tmp31_ = vala_property_accessor_get_prop (self);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp32_, "NoAccessorMethod");
		_tmp34_ = _tmp33_;
		_tmp35_ = _tmp34_ != NULL;
		_vala_code_node_unref0 (_tmp34_);
		if (_tmp35_) {
			ValaDataType* _tmp36_;
			ValaDataType* _tmp37_;
			_tmp36_ = vala_property_accessor_get_value_type (self);
			_tmp37_ = _tmp36_;
			if (vala_data_type_is_real_struct_type (_tmp37_)) {
				gboolean _tmp38_ = FALSE;
				ValaSourceReference* _tmp39_;
				ValaSourceReference* _tmp40_;
				_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp40_ = _tmp39_;
				if (_tmp40_ == NULL) {
					_tmp38_ = TRUE;
				} else {
					ValaSourceReference* _tmp41_;
					ValaSourceReference* _tmp42_;
					ValaSourceFile* _tmp43_;
					ValaSourceFile* _tmp44_;
					_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp42_ = _tmp41_;
					_tmp43_ = vala_source_reference_get_file (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp38_ = _tmp44_ == NULL;
				}
				if (_tmp38_) {
				} else {
					gboolean _tmp45_ = FALSE;
					ValaDataType* _tmp46_;
					ValaDataType* _tmp47_;
					gboolean _tmp48_;
					gboolean _tmp49_;
					_tmp46_ = vala_property_accessor_get_value_type (self);
					_tmp47_ = _tmp46_;
					_tmp48_ = vala_data_type_get_value_owned (_tmp47_);
					_tmp49_ = _tmp48_;
					if (!_tmp49_) {
						ValaSourceReference* _tmp50_;
						ValaSourceReference* _tmp51_;
						ValaSourceFile* _tmp52_;
						ValaSourceFile* _tmp53_;
						ValaSourceFileType _tmp54_;
						ValaSourceFileType _tmp55_;
						_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp51_ = _tmp50_;
						_tmp52_ = vala_source_reference_get_file (_tmp51_);
						_tmp53_ = _tmp52_;
						_tmp54_ = vala_source_file_get_file_type (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp45_ = _tmp55_ == VALA_SOURCE_FILE_TYPE_SOURCE;
					} else {
						_tmp45_ = FALSE;
					}
					if (_tmp45_) {
						ValaSourceReference* _tmp56_;
						ValaSourceReference* _tmp57_;
						ValaProperty* _tmp58_;
						ValaProperty* _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
						ValaDataType* _tmp64_;
						ValaDataType* _tmp65_;
						_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp57_ = _tmp56_;
						_tmp58_ = vala_property_accessor_get_prop (self);
						_tmp59_ = _tmp58_;
						_tmp60_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp59_);
						_tmp61_ = _tmp60_;
						_tmp62_ = g_strdup_printf ("unowned return value for getter of property `%s' not supported without" \
" accessor", _tmp61_);
						_tmp63_ = _tmp62_;
						vala_report_warning (_tmp57_, _tmp63_);
						_g_free0 (_tmp63_);
						_g_free0 (_tmp61_);
						_tmp64_ = vala_property_accessor_get_value_type (self);
						_tmp65_ = _tmp64_;
						vala_data_type_set_value_owned (_tmp65_, TRUE);
					}
				}
			} else {
				gboolean _tmp66_ = FALSE;
				ValaDataType* _tmp67_;
				ValaDataType* _tmp68_;
				gboolean _tmp69_;
				gboolean _tmp70_;
				_tmp67_ = vala_property_accessor_get_value_type (self);
				_tmp68_ = _tmp67_;
				_tmp69_ = vala_data_type_get_value_owned (_tmp68_);
				_tmp70_ = _tmp69_;
				if (_tmp70_) {
					gboolean _tmp71_ = FALSE;
					ValaSourceReference* _tmp72_;
					ValaSourceReference* _tmp73_;
					_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp73_ = _tmp72_;
					if (_tmp73_ == NULL) {
						_tmp71_ = TRUE;
					} else {
						ValaSourceReference* _tmp74_;
						ValaSourceReference* _tmp75_;
						ValaSourceFile* _tmp76_;
						ValaSourceFile* _tmp77_;
						_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp75_ = _tmp74_;
						_tmp76_ = vala_source_reference_get_file (_tmp75_);
						_tmp77_ = _tmp76_;
						_tmp71_ = _tmp77_ == NULL;
					}
					_tmp66_ = _tmp71_;
				} else {
					_tmp66_ = FALSE;
				}
				if (_tmp66_) {
					gboolean _tmp78_ = FALSE;
					gboolean _tmp79_ = FALSE;
					ValaDataType* _tmp80_;
					ValaDataType* _tmp81_;
					_tmp80_ = vala_property_accessor_get_value_type (self);
					_tmp81_ = _tmp80_;
					if (VALA_IS_DELEGATE_TYPE (_tmp81_)) {
						_tmp79_ = TRUE;
					} else {
						ValaDataType* _tmp82_;
						ValaDataType* _tmp83_;
						_tmp82_ = vala_property_accessor_get_value_type (self);
						_tmp83_ = _tmp82_;
						_tmp79_ = VALA_IS_POINTER_TYPE (_tmp83_);
					}
					if (_tmp79_) {
						_tmp78_ = TRUE;
					} else {
						gboolean _tmp84_ = FALSE;
						ValaDataType* _tmp85_;
						ValaDataType* _tmp86_;
						_tmp85_ = vala_property_accessor_get_value_type (self);
						_tmp86_ = _tmp85_;
						if (VALA_IS_VALUE_TYPE (_tmp86_)) {
							ValaDataType* _tmp87_;
							ValaDataType* _tmp88_;
							gboolean _tmp89_;
							gboolean _tmp90_;
							_tmp87_ = vala_property_accessor_get_value_type (self);
							_tmp88_ = _tmp87_;
							_tmp89_ = vala_data_type_get_nullable (_tmp88_);
							_tmp90_ = _tmp89_;
							_tmp84_ = !_tmp90_;
						} else {
							_tmp84_ = FALSE;
						}
						_tmp78_ = _tmp84_;
					}
					if (_tmp78_) {
						ValaDataType* _tmp91_;
						ValaDataType* _tmp92_;
						_tmp91_ = vala_property_accessor_get_value_type (self);
						_tmp92_ = _tmp91_;
						vala_data_type_set_value_owned (_tmp92_, FALSE);
					}
				}
			}
		}
	}
	_tmp93_ = vala_property_accessor_get_prop (self);
	_tmp94_ = _tmp93_;
	_tmp95_ = vala_symbol_get_source_type ((ValaSymbol*) _tmp94_);
	_tmp96_ = _tmp95_;
	if (_tmp96_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp97_ = FALSE;
		gboolean _tmp98_ = FALSE;
		ValaBlock* _tmp99_;
		ValaBlock* _tmp100_;
		_tmp99_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp100_ = _tmp99_;
		if (_tmp100_ == NULL) {
			ValaProperty* _tmp101_;
			ValaProperty* _tmp102_;
			gboolean _tmp103_;
			gboolean _tmp104_;
			_tmp101_ = vala_property_accessor_get_prop (self);
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_property_get_interface_only (_tmp102_);
			_tmp104_ = _tmp103_;
			_tmp98_ = !_tmp104_;
		} else {
			_tmp98_ = FALSE;
		}
		if (_tmp98_) {
			ValaProperty* _tmp105_;
			ValaProperty* _tmp106_;
			gboolean _tmp107_;
			gboolean _tmp108_;
			_tmp105_ = vala_property_accessor_get_prop (self);
			_tmp106_ = _tmp105_;
			_tmp107_ = vala_property_get_is_abstract (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp97_ = !_tmp108_;
		} else {
			_tmp97_ = FALSE;
		}
		if (_tmp97_) {
			ValaSourceReference* _tmp109_;
			ValaSourceReference* _tmp110_;
			ValaBlock* _tmp111_;
			ValaBlock* _tmp112_;
			ValaMemberAccess* ma = NULL;
			ValaProperty* _tmp113_;
			ValaProperty* _tmp114_;
			const gchar* _tmp115_;
			const gchar* _tmp116_;
			gchar* _tmp117_;
			gchar* _tmp118_;
			ValaSourceReference* _tmp119_;
			ValaSourceReference* _tmp120_;
			ValaMemberAccess* _tmp121_;
			ValaMemberAccess* _tmp122_;
			gboolean _tmp123_;
			vala_property_accessor_set_automatic_body (self, TRUE);
			_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp110_ = _tmp109_;
			_tmp111_ = vala_block_new (_tmp110_);
			_tmp112_ = _tmp111_;
			vala_subroutine_set_body ((ValaSubroutine*) self, _tmp112_);
			_vala_code_node_unref0 (_tmp112_);
			_tmp113_ = vala_property_accessor_get_prop (self);
			_tmp114_ = _tmp113_;
			_tmp115_ = vala_symbol_get_name ((ValaSymbol*) _tmp114_);
			_tmp116_ = _tmp115_;
			_tmp117_ = g_strdup_printf ("_%s", _tmp116_);
			_tmp118_ = _tmp117_;
			_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp120_ = _tmp119_;
			_tmp121_ = vala_member_access_new_simple (_tmp118_, _tmp120_);
			_tmp122_ = _tmp121_;
			_g_free0 (_tmp118_);
			ma = _tmp122_;
			_tmp123_ = self->priv->_readable;
			if (_tmp123_) {
				ValaBlock* _tmp124_;
				ValaBlock* _tmp125_;
				ValaMemberAccess* _tmp126_;
				ValaSourceReference* _tmp127_;
				ValaSourceReference* _tmp128_;
				ValaReturnStatement* _tmp129_;
				ValaReturnStatement* _tmp130_;
				_tmp124_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp125_ = _tmp124_;
				_tmp126_ = ma;
				_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp128_ = _tmp127_;
				_tmp129_ = vala_return_statement_new ((ValaExpression*) _tmp126_, _tmp128_);
				_tmp130_ = _tmp129_;
				vala_block_add_statement (_tmp125_, (ValaStatement*) _tmp130_);
				_vala_code_node_unref0 (_tmp130_);
			} else {
				ValaExpression* value = NULL;
				ValaSourceReference* _tmp131_;
				ValaSourceReference* _tmp132_;
				ValaMemberAccess* _tmp133_;
				ValaDataType* _tmp134_;
				ValaDataType* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				ValaAssignment* assignment = NULL;
				ValaMemberAccess* _tmp142_;
				ValaExpression* _tmp143_;
				ValaSourceReference* _tmp144_;
				ValaSourceReference* _tmp145_;
				ValaAssignment* _tmp146_;
				ValaBlock* _tmp147_;
				ValaBlock* _tmp148_;
				ValaAssignment* _tmp149_;
				ValaExpressionStatement* _tmp150_;
				ValaExpressionStatement* _tmp151_;
				_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp132_ = _tmp131_;
				_tmp133_ = vala_member_access_new_simple ("value", _tmp132_);
				value = (ValaExpression*) _tmp133_;
				_tmp134_ = vala_property_accessor_get_value_type (self);
				_tmp135_ = _tmp134_;
				_tmp136_ = vala_data_type_get_value_owned (_tmp135_);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaExpression* _tmp138_;
					ValaSourceReference* _tmp139_;
					ValaSourceReference* _tmp140_;
					ValaReferenceTransferExpression* _tmp141_;
					_tmp138_ = value;
					_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp140_ = _tmp139_;
					_tmp141_ = vala_reference_transfer_expression_new (_tmp138_, _tmp140_);
					_vala_code_node_unref0 (value);
					value = (ValaExpression*) _tmp141_;
				}
				_tmp142_ = ma;
				_tmp143_ = value;
				_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp145_ = _tmp144_;
				_tmp146_ = vala_assignment_new ((ValaExpression*) _tmp142_, _tmp143_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp145_);
				assignment = _tmp146_;
				_tmp147_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp148_ = _tmp147_;
				_tmp149_ = assignment;
				_tmp150_ = vala_expression_statement_new ((ValaExpression*) _tmp149_, NULL);
				_tmp151_ = _tmp150_;
				vala_block_add_statement (_tmp148_, (ValaStatement*) _tmp151_);
				_vala_code_node_unref0 (_tmp151_);
				_vala_code_node_unref0 (assignment);
				_vala_code_node_unref0 (value);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp155_ = vala_property_accessor_get_prop (self);
	_tmp156_ = _tmp155_;
	_tmp157_ = vala_property_get_is_abstract (_tmp156_);
	_tmp158_ = _tmp157_;
	if (_tmp158_) {
		_tmp154_ = TRUE;
	} else {
		ValaProperty* _tmp159_;
		ValaProperty* _tmp160_;
		gboolean _tmp161_;
		gboolean _tmp162_;
		_tmp159_ = vala_property_accessor_get_prop (self);
		_tmp160_ = _tmp159_;
		_tmp161_ = vala_property_get_is_virtual (_tmp160_);
		_tmp162_ = _tmp161_;
		_tmp154_ = _tmp162_;
	}
	if (_tmp154_) {
		_tmp153_ = TRUE;
	} else {
		ValaProperty* _tmp163_;
		ValaProperty* _tmp164_;
		gboolean _tmp165_;
		gboolean _tmp166_;
		_tmp163_ = vala_property_accessor_get_prop (self);
		_tmp164_ = _tmp163_;
		_tmp165_ = vala_property_get_overrides (_tmp164_);
		_tmp166_ = _tmp165_;
		_tmp153_ = _tmp166_;
	}
	if (_tmp153_) {
		ValaSymbolAccessibility _tmp167_;
		ValaSymbolAccessibility _tmp168_;
		_tmp167_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp168_ = _tmp167_;
		_tmp152_ = _tmp168_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
	} else {
		_tmp152_ = FALSE;
	}
	if (_tmp152_) {
		ValaSourceReference* _tmp169_;
		ValaSourceReference* _tmp170_;
		ValaProperty* _tmp171_;
		ValaProperty* _tmp172_;
		gchar* _tmp173_;
		gchar* _tmp174_;
		gchar* _tmp175_;
		gchar* _tmp176_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp169_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp170_ = _tmp169_;
		_tmp171_ = vala_property_accessor_get_prop (self);
		_tmp172_ = _tmp171_;
		_tmp173_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp172_);
		_tmp174_ = _tmp173_;
		_tmp175_ = g_strdup_printf ("Property `%s' with private accessor cannot be marked as abstract, virt" \
"ual or override", _tmp174_);
		_tmp176_ = _tmp175_;
		vala_report_error (_tmp170_, _tmp176_);
		_g_free0 (_tmp176_);
		_g_free0 (_tmp174_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	}
	_tmp177_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp178_ = _tmp177_;
	if (_tmp178_ != NULL) {
		gboolean _tmp179_ = FALSE;
		gboolean _tmp180_;
		ValaBlock* _tmp190_;
		ValaBlock* _tmp191_;
		_tmp180_ = self->priv->_writable;
		if (_tmp180_) {
			_tmp179_ = TRUE;
		} else {
			gboolean _tmp181_;
			_tmp181_ = self->priv->_construction;
			_tmp179_ = _tmp181_;
		}
		if (_tmp179_) {
			ValaBlock* _tmp182_;
			ValaBlock* _tmp183_;
			ValaScope* _tmp184_;
			ValaScope* _tmp185_;
			ValaParameter* _tmp186_;
			const gchar* _tmp187_;
			const gchar* _tmp188_;
			ValaParameter* _tmp189_;
			_tmp182_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp183_ = _tmp182_;
			_tmp184_ = vala_symbol_get_scope ((ValaSymbol*) _tmp183_);
			_tmp185_ = _tmp184_;
			_tmp186_ = self->priv->_value_parameter;
			_tmp187_ = vala_symbol_get_name ((ValaSymbol*) _tmp186_);
			_tmp188_ = _tmp187_;
			_tmp189_ = self->priv->_value_parameter;
			vala_scope_add (_tmp185_, _tmp188_, (ValaSymbol*) _tmp189_);
		}
		_tmp190_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp191_ = _tmp190_;
		vala_code_node_check ((ValaCodeNode*) _tmp191_, context);
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp192_;
			ValaBlock* _tmp193_;
			ValaList* _tmp194_;
			gint _body_error_type_size = 0;
			ValaList* _tmp195_;
			gint _tmp196_;
			gint _tmp197_;
			gint _body_error_type_index = 0;
			_tmp192_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp193_ = _tmp192_;
			_tmp194_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp193_);
			_body_error_type_list = _tmp194_;
			_tmp195_ = _body_error_type_list;
			_tmp196_ = vala_collection_get_size ((ValaCollection*) _tmp195_);
			_tmp197_ = _tmp196_;
			_body_error_type_size = _tmp197_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp198_;
				gint _tmp199_;
				gint _tmp200_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp201_;
				gint _tmp202_;
				gpointer _tmp203_;
				ValaDataType* _tmp204_;
				gboolean _tmp205_;
				gboolean _tmp206_;
				_tmp198_ = _body_error_type_index;
				_body_error_type_index = _tmp198_ + 1;
				_tmp199_ = _body_error_type_index;
				_tmp200_ = _body_error_type_size;
				if (!(_tmp199_ < _tmp200_)) {
					break;
				}
				_tmp201_ = _body_error_type_list;
				_tmp202_ = _body_error_type_index;
				_tmp203_ = vala_list_get (_tmp201_, _tmp202_);
				body_error_type = (ValaDataType*) _tmp203_;
				_tmp204_ = body_error_type;
				_tmp205_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
				_tmp206_ = _tmp205_;
				if (!_tmp206_) {
					ValaDataType* _tmp207_;
					ValaSourceReference* _tmp208_;
					ValaSourceReference* _tmp209_;
					ValaDataType* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					gchar* _tmp214_;
					_tmp207_ = body_error_type;
					_tmp208_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp207_);
					_tmp209_ = _tmp208_;
					_tmp210_ = body_error_type;
					_tmp211_ = vala_code_node_to_string ((ValaCodeNode*) _tmp210_);
					_tmp212_ = _tmp211_;
					_tmp213_ = g_strdup_printf ("unhandled error `%s'", _tmp212_);
					_tmp214_ = _tmp213_;
					vala_report_warning (_tmp209_, _tmp214_);
					_g_free0 (_tmp214_);
					_g_free0 (_tmp212_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	_tmp215_ = vala_code_context_get_analyzer (context);
	_tmp216_ = _tmp215_;
	_tmp217_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp216_, _tmp217_);
	_tmp218_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp219_ = _tmp218_;
	result = !_tmp219_;
	_vala_code_node_unref0 (old_symbol);
	return result;
}


static void
vala_property_accessor_real_replace_type (ValaCodeNode* base,
                                          ValaDataType* old_type,
                                          ValaDataType* new_type)
{
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_property_accessor_set_value_type (self, new_type);
	}
}


ValaProperty*
vala_property_accessor_get_prop (ValaPropertyAccessor* self)
{
	ValaProperty* result;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	result = VALA_IS_PROPERTY (_tmp1_) ? ((ValaProperty*) _tmp1_) : NULL;
	return result;
}


ValaDataType*
vala_property_accessor_get_value_type (ValaPropertyAccessor* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_type;
	result = _tmp0_;
	return result;
}


static void
vala_property_accessor_set_value_type (ValaPropertyAccessor* self,
                                       ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_type);
	self->priv->_value_type = _tmp0_;
	if (value != NULL) {
		ValaDataType* _tmp1_;
		_tmp1_ = self->priv->_value_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	}
}


gboolean
vala_property_accessor_get_readable (ValaPropertyAccessor* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_readable;
	result = _tmp0_;
	return result;
}


static void
vala_property_accessor_set_readable (ValaPropertyAccessor* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_readable = value;
}


gboolean
vala_property_accessor_get_writable (ValaPropertyAccessor* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_writable;
	result = _tmp0_;
	return result;
}


static void
vala_property_accessor_set_writable (ValaPropertyAccessor* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_writable = value;
}


gboolean
vala_property_accessor_get_construction (ValaPropertyAccessor* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_construction;
	result = _tmp0_;
	return result;
}


static void
vala_property_accessor_set_construction (ValaPropertyAccessor* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_construction = value;
}


gboolean
vala_property_accessor_get_automatic_body (ValaPropertyAccessor* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_automatic_body;
	result = _tmp0_;
	return result;
}


static void
vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_automatic_body = value;
}


static gboolean
vala_property_accessor_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaPropertyAccessor* self;
	gboolean _tmp0_;
	self = (ValaPropertyAccessor*) base;
	_tmp0_ = self->priv->_readable;
	result = _tmp0_;
	return result;
}


ValaParameter*
vala_property_accessor_get_value_parameter (ValaPropertyAccessor* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_parameter;
	result = _tmp0_;
	return result;
}


static void
vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self,
                                            ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	self->priv->_value_parameter = _tmp0_;
}


static void
vala_property_accessor_class_init (ValaPropertyAccessorClass * klass)
{
	vala_property_accessor_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_property_accessor_finalize;
	g_type_class_add_private (klass, sizeof (ValaPropertyAccessorPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_accessor_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_accessor_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_property_accessor_real_check;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_property_accessor_real_replace_type;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_property_accessor_real_get_has_result;
}


static void
vala_property_accessor_instance_init (ValaPropertyAccessor * self)
{
	self->priv = VALA_PROPERTY_ACCESSOR_GET_PRIVATE (self);
}


static void
vala_property_accessor_finalize (ValaCodeNode * obj)
{
	ValaPropertyAccessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	_vala_code_node_unref0 (self->priv->_value_type);
	VALA_CODE_NODE_CLASS (vala_property_accessor_parent_class)->finalize (obj);
}


/**
 * Represents a get or set accessor of a property in the source code.
 */
GType
vala_property_accessor_get_type (void)
{
	static volatile gsize vala_property_accessor_type_id__volatile = 0;
	if (g_once_init_enter (&vala_property_accessor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyAccessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_accessor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPropertyAccessor), 0, (GInstanceInitFunc) vala_property_accessor_instance_init, NULL };
		GType vala_property_accessor_type_id;
		vala_property_accessor_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaPropertyAccessor", &g_define_type_info, 0);
		g_once_init_leave (&vala_property_accessor_type_id__volatile, vala_property_accessor_type_id);
	}
	return vala_property_accessor_type_id__volatile;
}



