/* valasemanticanalyzer.c generated by valac, the Vala compiler
 * generated from valasemanticanalyzer.vala, do not modify */

/* valasemanticanalyzer.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaSemanticAnalyzerPrivate {
	ValaCodeContext* context;
	ValaSymbol* _current_symbol;
	ValaSourceFile* _current_source_file;
};


static gpointer vala_semantic_analyzer_parent_class = NULL;

#define VALA_SEMANTIC_ANALYZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerPrivate))
static void vala_semantic_analyzer_real_visit_source_file (ValaCodeVisitor* base,
                                                    ValaSourceFile* file);
static gboolean vala_semantic_analyzer_check_argument (ValaSemanticAnalyzer* self,
                                                ValaExpression* arg,
                                                gint i,
                                                ValaParameterDirection direction);
static ValaDataType* vala_semantic_analyzer_get_instance_base_type (ValaDataType* instance_type,
                                                             ValaDataType* base_type,
                                                             ValaCodeNode* node_reference);
G_GNUC_INTERNAL ValaDataType* vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type,
                                                                        ValaTypeSymbol* type_symbol,
                                                                        ValaCodeNode* node_reference);
static ValaStruct* vala_semantic_analyzer_get_arithmetic_struct (ValaSemanticAnalyzer* self,
                                                          ValaDataType* type);
static void vala_semantic_analyzer_finalize (ValaCodeVisitor * obj);


ValaSemanticAnalyzer*
vala_semantic_analyzer_construct (GType object_type)
{
	ValaSemanticAnalyzer* self = NULL;
	self = (ValaSemanticAnalyzer*) vala_code_visitor_construct (object_type);
	return self;
}


ValaSemanticAnalyzer*
vala_semantic_analyzer_new (void)
{
	return vala_semantic_analyzer_construct (VALA_TYPE_SEMANTIC_ANALYZER);
}


/**
 * Analyze and check code in the specified context.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


void
vala_semantic_analyzer_analyze (ValaSemanticAnalyzer* self,
                                ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	ValaNamespace* root_symbol = NULL;
	ValaNamespace* _tmp1_;
	ValaNamespace* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaStruct* _tmp8_;
	ValaBooleanType* _tmp9_;
	ValaNamespace* _tmp10_;
	ValaScope* _tmp11_;
	ValaScope* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaClass* _tmp14_;
	ValaObjectType* _tmp15_;
	ValaNamespace* _tmp16_;
	ValaScope* _tmp17_;
	ValaScope* _tmp18_;
	ValaSymbol* _tmp19_;
	ValaStruct* _tmp20_;
	ValaIntegerType* _tmp21_;
	ValaNamespace* _tmp22_;
	ValaScope* _tmp23_;
	ValaScope* _tmp24_;
	ValaSymbol* _tmp25_;
	ValaStruct* _tmp26_;
	ValaIntegerType* _tmp27_;
	ValaNamespace* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaStruct* _tmp32_;
	ValaIntegerType* _tmp33_;
	ValaNamespace* _tmp34_;
	ValaScope* _tmp35_;
	ValaScope* _tmp36_;
	ValaSymbol* _tmp37_;
	ValaStruct* _tmp38_;
	ValaIntegerType* _tmp39_;
	ValaNamespace* _tmp40_;
	ValaScope* _tmp41_;
	ValaScope* _tmp42_;
	ValaSymbol* _tmp43_;
	ValaStruct* _tmp44_;
	ValaIntegerType* _tmp45_;
	ValaNamespace* _tmp46_;
	ValaScope* _tmp47_;
	ValaScope* _tmp48_;
	ValaSymbol* _tmp49_;
	ValaStruct* _tmp50_;
	ValaIntegerType* _tmp51_;
	ValaNamespace* _tmp52_;
	ValaScope* _tmp53_;
	ValaScope* _tmp54_;
	ValaSymbol* _tmp55_;
	ValaStruct* _tmp56_;
	ValaIntegerType* _tmp57_;
	ValaNamespace* _tmp58_;
	ValaScope* _tmp59_;
	ValaScope* _tmp60_;
	ValaSymbol* _tmp61_;
	ValaStruct* _tmp62_;
	ValaIntegerType* _tmp63_;
	ValaNamespace* _tmp64_;
	ValaScope* _tmp65_;
	ValaScope* _tmp66_;
	ValaSymbol* _tmp67_;
	ValaStruct* _tmp68_;
	ValaIntegerType* _tmp69_;
	ValaNamespace* _tmp70_;
	ValaScope* _tmp71_;
	ValaScope* _tmp72_;
	ValaSymbol* _tmp73_;
	ValaStruct* _tmp74_;
	ValaIntegerType* _tmp75_;
	ValaNamespace* _tmp76_;
	ValaScope* _tmp77_;
	ValaScope* _tmp78_;
	ValaSymbol* _tmp79_;
	ValaStruct* _tmp80_;
	ValaFloatingType* _tmp81_;
	ValaNamespace* _tmp82_;
	ValaScope* _tmp83_;
	ValaScope* _tmp84_;
	ValaSymbol* _tmp85_;
	ValaStruct* _tmp86_;
	ValaStructValueType* _tmp87_;
	ValaStruct* unichar_struct = NULL;
	ValaNamespace* _tmp88_;
	ValaScope* _tmp89_;
	ValaScope* _tmp90_;
	ValaSymbol* _tmp91_;
	ValaStruct* _tmp92_;
	ValaSymbol* glib_ns = NULL;
	ValaNamespace* _tmp95_;
	ValaScope* _tmp96_;
	ValaScope* _tmp97_;
	ValaSymbol* _tmp98_;
	ValaScope* _tmp99_;
	ValaScope* _tmp100_;
	ValaSymbol* _tmp101_;
	ValaScope* _tmp102_;
	ValaScope* _tmp103_;
	ValaSymbol* _tmp104_;
	ValaStruct* _tmp105_;
	ValaIntegerType* _tmp106_;
	ValaScope* _tmp107_;
	ValaScope* _tmp108_;
	ValaSymbol* _tmp109_;
	ValaStruct* _tmp110_;
	ValaStructValueType* _tmp111_;
	ValaScope* _tmp112_;
	ValaScope* _tmp113_;
	ValaSymbol* _tmp114_;
	ValaClass* _tmp115_;
	ValaObjectType* _tmp116_;
	ValaScope* _tmp117_;
	ValaScope* _tmp118_;
	ValaSymbol* _tmp119_;
	ValaClass* _tmp120_;
	ValaObjectType* _tmp121_;
	ValaScope* _tmp122_;
	ValaScope* _tmp123_;
	ValaSymbol* _tmp124_;
	ValaClass* _tmp125_;
	ValaObjectType* _tmp126_;
	ValaScope* _tmp127_;
	ValaScope* _tmp128_;
	ValaSymbol* _tmp129_;
	ValaClass* _tmp130_;
	ValaObjectType* _tmp131_;
	ValaScope* _tmp132_;
	ValaScope* _tmp133_;
	ValaSymbol* _tmp134_;
	ValaClass* _tmp135_;
	ValaObjectType* _tmp136_;
	ValaScope* _tmp137_;
	ValaScope* _tmp138_;
	ValaSymbol* _tmp139_;
	ValaNamespace* _tmp140_;
	ValaScope* _tmp141_;
	ValaScope* _tmp142_;
	ValaSymbol* _tmp143_;
	ValaSymbol* _tmp144_;
	ValaScope* _tmp145_;
	ValaScope* _tmp146_;
	ValaSymbol* _tmp147_;
	ValaClass* _tmp148_;
	ValaObjectType* _tmp149_;
	ValaScope* _tmp150_;
	ValaScope* _tmp151_;
	ValaSymbol* _tmp152_;
	ValaNamespace* _tmp153_;
	ValaNamespace* _tmp154_;
	ValaNamespace* _tmp155_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = vala_code_context_get_root (context);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	root_symbol = _tmp3_;
	_tmp4_ = root_symbol;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "bool");
	_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp9_ = vala_boolean_type_new (_tmp8_);
	_vala_code_node_unref0 (self->bool_type);
	self->bool_type = (ValaDataType*) _tmp9_;
	_vala_code_node_unref0 (_tmp8_);
	_tmp10_ = root_symbol;
	_tmp11_ = vala_symbol_get_scope ((ValaSymbol*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_scope_lookup (_tmp12_, "string");
	_tmp14_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_CLASS, ValaClass);
	_tmp15_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp14_);
	_vala_code_node_unref0 (self->string_type);
	self->string_type = (ValaDataType*) _tmp15_;
	_vala_code_node_unref0 (_tmp14_);
	_tmp16_ = root_symbol;
	_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_scope_lookup (_tmp18_, "int");
	_tmp20_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp21_ = vala_integer_type_new (_tmp20_, NULL, NULL);
	_vala_code_node_unref0 (self->int_type);
	self->int_type = (ValaDataType*) _tmp21_;
	_vala_code_node_unref0 (_tmp20_);
	_tmp22_ = root_symbol;
	_tmp23_ = vala_symbol_get_scope ((ValaSymbol*) _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_scope_lookup (_tmp24_, "uint");
	_tmp26_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp27_ = vala_integer_type_new (_tmp26_, NULL, NULL);
	_vala_code_node_unref0 (self->uint_type);
	self->uint_type = (ValaDataType*) _tmp27_;
	_vala_code_node_unref0 (_tmp26_);
	_tmp28_ = root_symbol;
	_tmp29_ = vala_symbol_get_scope ((ValaSymbol*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_scope_lookup (_tmp30_, "uchar");
	_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp33_ = vala_integer_type_new (_tmp32_, NULL, NULL);
	_vala_code_node_unref0 (self->uchar_type);
	self->uchar_type = (ValaDataType*) _tmp33_;
	_vala_code_node_unref0 (_tmp32_);
	_tmp34_ = root_symbol;
	_tmp35_ = vala_symbol_get_scope ((ValaSymbol*) _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = vala_scope_lookup (_tmp36_, "int8");
	_tmp38_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp39_ = vala_integer_type_new (_tmp38_, NULL, NULL);
	_vala_code_node_unref0 (self->int8_type);
	self->int8_type = (ValaDataType*) _tmp39_;
	_vala_code_node_unref0 (_tmp38_);
	_tmp40_ = root_symbol;
	_tmp41_ = vala_symbol_get_scope ((ValaSymbol*) _tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_scope_lookup (_tmp42_, "short");
	_tmp44_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp45_ = vala_integer_type_new (_tmp44_, NULL, NULL);
	_vala_code_node_unref0 (self->short_type);
	self->short_type = (ValaDataType*) _tmp45_;
	_vala_code_node_unref0 (_tmp44_);
	_tmp46_ = root_symbol;
	_tmp47_ = vala_symbol_get_scope ((ValaSymbol*) _tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_scope_lookup (_tmp48_, "ushort");
	_tmp50_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp51_ = vala_integer_type_new (_tmp50_, NULL, NULL);
	_vala_code_node_unref0 (self->ushort_type);
	self->ushort_type = (ValaDataType*) _tmp51_;
	_vala_code_node_unref0 (_tmp50_);
	_tmp52_ = root_symbol;
	_tmp53_ = vala_symbol_get_scope ((ValaSymbol*) _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_scope_lookup (_tmp54_, "long");
	_tmp56_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp57_ = vala_integer_type_new (_tmp56_, NULL, NULL);
	_vala_code_node_unref0 (self->long_type);
	self->long_type = (ValaDataType*) _tmp57_;
	_vala_code_node_unref0 (_tmp56_);
	_tmp58_ = root_symbol;
	_tmp59_ = vala_symbol_get_scope ((ValaSymbol*) _tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = vala_scope_lookup (_tmp60_, "ulong");
	_tmp62_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp63_ = vala_integer_type_new (_tmp62_, NULL, NULL);
	_vala_code_node_unref0 (self->ulong_type);
	self->ulong_type = (ValaDataType*) _tmp63_;
	_vala_code_node_unref0 (_tmp62_);
	_tmp64_ = root_symbol;
	_tmp65_ = vala_symbol_get_scope ((ValaSymbol*) _tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = vala_scope_lookup (_tmp66_, "size_t");
	_tmp68_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp69_ = vala_integer_type_new (_tmp68_, NULL, NULL);
	_vala_code_node_unref0 (self->size_t_type);
	self->size_t_type = (ValaDataType*) _tmp69_;
	_vala_code_node_unref0 (_tmp68_);
	_tmp70_ = root_symbol;
	_tmp71_ = vala_symbol_get_scope ((ValaSymbol*) _tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = vala_scope_lookup (_tmp72_, "ssize_t");
	_tmp74_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp75_ = vala_integer_type_new (_tmp74_, NULL, NULL);
	_vala_code_node_unref0 (self->ssize_t_type);
	self->ssize_t_type = (ValaDataType*) _tmp75_;
	_vala_code_node_unref0 (_tmp74_);
	_tmp76_ = root_symbol;
	_tmp77_ = vala_symbol_get_scope ((ValaSymbol*) _tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_scope_lookup (_tmp78_, "double");
	_tmp80_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp81_ = vala_floating_type_new (_tmp80_);
	_vala_code_node_unref0 (self->double_type);
	self->double_type = (ValaDataType*) _tmp81_;
	_vala_code_node_unref0 (_tmp80_);
	_tmp82_ = root_symbol;
	_tmp83_ = vala_symbol_get_scope ((ValaSymbol*) _tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = vala_scope_lookup (_tmp84_, "va_list");
	_tmp86_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp87_ = vala_struct_value_type_new (_tmp86_);
	_vala_code_node_unref0 (self->va_list_type);
	self->va_list_type = (ValaDataType*) _tmp87_;
	_vala_code_node_unref0 (_tmp86_);
	_tmp88_ = root_symbol;
	_tmp89_ = vala_symbol_get_scope ((ValaSymbol*) _tmp88_);
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_scope_lookup (_tmp90_, "unichar");
	unichar_struct = G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp92_ = unichar_struct;
	if (_tmp92_ != NULL) {
		ValaStruct* _tmp93_;
		ValaIntegerType* _tmp94_;
		_tmp93_ = unichar_struct;
		_tmp94_ = vala_integer_type_new (_tmp93_, NULL, NULL);
		_vala_code_node_unref0 (self->unichar_type);
		self->unichar_type = (ValaDataType*) _tmp94_;
	}
	_tmp95_ = root_symbol;
	_tmp96_ = vala_symbol_get_scope ((ValaSymbol*) _tmp95_);
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_scope_lookup (_tmp97_, "GLib");
	glib_ns = _tmp98_;
	_tmp99_ = vala_symbol_get_scope (glib_ns);
	_tmp100_ = _tmp99_;
	_tmp101_ = vala_scope_lookup (_tmp100_, "Object");
	_vala_code_node_unref0 (self->object_type);
	self->object_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, VALA_TYPE_CLASS, ValaClass);
	_tmp102_ = vala_symbol_get_scope (glib_ns);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_scope_lookup (_tmp103_, "Type");
	_tmp105_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp106_ = vala_integer_type_new (_tmp105_, NULL, NULL);
	_vala_code_node_unref0 (self->type_type);
	self->type_type = (ValaDataType*) _tmp106_;
	_vala_code_node_unref0 (_tmp105_);
	_tmp107_ = vala_symbol_get_scope (glib_ns);
	_tmp108_ = _tmp107_;
	_tmp109_ = vala_scope_lookup (_tmp108_, "Value");
	_tmp110_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_STRUCT, ValaStruct);
	_tmp111_ = vala_struct_value_type_new (_tmp110_);
	_vala_code_node_unref0 (self->gvalue_type);
	self->gvalue_type = _tmp111_;
	_vala_code_node_unref0 (_tmp110_);
	_tmp112_ = vala_symbol_get_scope (glib_ns);
	_tmp113_ = _tmp112_;
	_tmp114_ = vala_scope_lookup (_tmp113_, "Variant");
	_tmp115_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, VALA_TYPE_CLASS, ValaClass);
	_tmp116_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp115_);
	_vala_code_node_unref0 (self->gvariant_type);
	self->gvariant_type = _tmp116_;
	_vala_code_node_unref0 (_tmp115_);
	_tmp117_ = vala_symbol_get_scope (glib_ns);
	_tmp118_ = _tmp117_;
	_tmp119_ = vala_scope_lookup (_tmp118_, "List");
	_tmp120_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp119_, VALA_TYPE_CLASS, ValaClass);
	_tmp121_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp120_);
	_vala_code_node_unref0 (self->glist_type);
	self->glist_type = (ValaDataType*) _tmp121_;
	_vala_code_node_unref0 (_tmp120_);
	_tmp122_ = vala_symbol_get_scope (glib_ns);
	_tmp123_ = _tmp122_;
	_tmp124_ = vala_scope_lookup (_tmp123_, "SList");
	_tmp125_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass);
	_tmp126_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp125_);
	_vala_code_node_unref0 (self->gslist_type);
	self->gslist_type = (ValaDataType*) _tmp126_;
	_vala_code_node_unref0 (_tmp125_);
	_tmp127_ = vala_symbol_get_scope (glib_ns);
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_scope_lookup (_tmp128_, "Array");
	_tmp130_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, VALA_TYPE_CLASS, ValaClass);
	_tmp131_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp130_);
	_vala_code_node_unref0 (self->garray_type);
	self->garray_type = (ValaDataType*) _tmp131_;
	_vala_code_node_unref0 (_tmp130_);
	_tmp132_ = vala_symbol_get_scope (glib_ns);
	_tmp133_ = _tmp132_;
	_tmp134_ = vala_scope_lookup (_tmp133_, "ValueArray");
	_tmp135_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, VALA_TYPE_CLASS, ValaClass);
	_tmp136_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp135_);
	_vala_code_node_unref0 (self->gvaluearray_type);
	self->gvaluearray_type = (ValaDataType*) _tmp136_;
	_vala_code_node_unref0 (_tmp135_);
	_tmp137_ = vala_symbol_get_scope (glib_ns);
	_tmp138_ = _tmp137_;
	_tmp139_ = vala_scope_lookup (_tmp138_, "Error");
	_vala_code_node_unref0 (self->gerror_type);
	self->gerror_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp139_, VALA_TYPE_CLASS, ValaClass);
	_tmp140_ = root_symbol;
	_tmp141_ = vala_symbol_get_scope ((ValaSymbol*) _tmp140_);
	_tmp142_ = _tmp141_;
	_tmp143_ = vala_scope_lookup (_tmp142_, "GLib");
	_tmp144_ = _tmp143_;
	_tmp145_ = vala_symbol_get_scope (_tmp144_);
	_tmp146_ = _tmp145_;
	_tmp147_ = vala_scope_lookup (_tmp146_, "Regex");
	_tmp148_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_CLASS, ValaClass);
	_tmp149_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp148_);
	_vala_code_node_unref0 (self->regex_type);
	self->regex_type = (ValaDataType*) _tmp149_;
	_vala_code_node_unref0 (_tmp148_);
	_vala_code_node_unref0 (_tmp144_);
	_tmp150_ = vala_symbol_get_scope (glib_ns);
	_tmp151_ = _tmp150_;
	_tmp152_ = vala_scope_lookup (_tmp151_, "Source");
	_vala_code_node_unref0 (self->gsource_type);
	self->gsource_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp152_, VALA_TYPE_CLASS, ValaClass);
	_tmp153_ = root_symbol;
	vala_semantic_analyzer_set_current_symbol (self, (ValaSymbol*) _tmp153_);
	_tmp154_ = vala_code_context_get_root (context);
	_tmp155_ = _tmp154_;
	vala_code_node_check ((ValaCodeNode*) _tmp155_, context);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
	_vala_code_node_unref0 (glib_ns);
	_vala_code_node_unref0 (unichar_struct);
	_vala_code_node_unref0 (root_symbol);
}


static void
vala_semantic_analyzer_real_visit_source_file (ValaCodeVisitor* base,
                                               ValaSourceFile* file)
{
	ValaSemanticAnalyzer * self;
	ValaCodeContext* _tmp0_;
	self = (ValaSemanticAnalyzer*) base;
	g_return_if_fail (file != NULL);
	vala_semantic_analyzer_set_current_source_file (self, file);
	_tmp0_ = self->priv->context;
	vala_source_file_check (file, _tmp0_);
}


gboolean
vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self,
                                           ValaSymbol* sym,
                                           ValaDataType* type)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	result = vala_data_type_is_accessible (type, sym);
	return result;
}


ValaDataType*
vala_semantic_analyzer_get_value_type_for_symbol (ValaSemanticAnalyzer* self,
                                                  ValaSymbol* sym,
                                                  gboolean lvalue)
{
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	if (VALA_IS_FIELD (sym)) {
		ValaField* f = NULL;
		ValaField* _tmp0_;
		ValaDataType* type = NULL;
		ValaField* _tmp1_;
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
		f = _tmp0_;
		_tmp1_ = f;
		_tmp2_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_data_type_copy (_tmp3_);
		type = _tmp4_;
		if (!lvalue) {
			ValaDataType* _tmp5_;
			_tmp5_ = type;
			vala_data_type_set_value_owned (_tmp5_, FALSE);
		}
		result = type;
		_vala_code_node_unref0 (f);
		return result;
	} else {
		if (VALA_IS_ENUM_VALUE (sym)) {
			ValaSymbol* _tmp6_;
			ValaSymbol* _tmp7_;
			ValaEnumValueType* _tmp8_;
			_tmp6_ = vala_symbol_get_parent_symbol (sym);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_enum_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_ENUM, ValaEnum));
			result = (ValaDataType*) _tmp8_;
			return result;
		} else {
			if (VALA_IS_CONSTANT (sym)) {
				ValaConstant* c = NULL;
				ValaConstant* _tmp9_;
				ValaConstant* _tmp10_;
				ValaDataType* _tmp11_;
				ValaDataType* _tmp12_;
				ValaDataType* _tmp13_;
				_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
				c = _tmp9_;
				_tmp10_ = c;
				_tmp11_ = vala_constant_get_type_reference (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _vala_code_node_ref0 (_tmp12_);
				result = _tmp13_;
				_vala_code_node_unref0 (c);
				return result;
			} else {
				if (VALA_IS_PROPERTY (sym)) {
					ValaProperty* prop = NULL;
					ValaProperty* _tmp14_;
					_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
					prop = _tmp14_;
					if (lvalue) {
						gboolean _tmp15_ = FALSE;
						ValaProperty* _tmp16_;
						ValaPropertyAccessor* _tmp17_;
						ValaPropertyAccessor* _tmp18_;
						_tmp16_ = prop;
						_tmp17_ = vala_property_get_set_accessor (_tmp16_);
						_tmp18_ = _tmp17_;
						if (_tmp18_ != NULL) {
							ValaProperty* _tmp19_;
							ValaPropertyAccessor* _tmp20_;
							ValaPropertyAccessor* _tmp21_;
							ValaDataType* _tmp22_;
							ValaDataType* _tmp23_;
							_tmp19_ = prop;
							_tmp20_ = vala_property_get_set_accessor (_tmp19_);
							_tmp21_ = _tmp20_;
							_tmp22_ = vala_property_accessor_get_value_type (_tmp21_);
							_tmp23_ = _tmp22_;
							_tmp15_ = _tmp23_ != NULL;
						} else {
							_tmp15_ = FALSE;
						}
						if (_tmp15_) {
							ValaProperty* _tmp24_;
							ValaPropertyAccessor* _tmp25_;
							ValaPropertyAccessor* _tmp26_;
							ValaDataType* _tmp27_;
							ValaDataType* _tmp28_;
							ValaDataType* _tmp29_;
							_tmp24_ = prop;
							_tmp25_ = vala_property_get_set_accessor (_tmp24_);
							_tmp26_ = _tmp25_;
							_tmp27_ = vala_property_accessor_get_value_type (_tmp26_);
							_tmp28_ = _tmp27_;
							_tmp29_ = vala_data_type_copy (_tmp28_);
							result = _tmp29_;
							_vala_code_node_unref0 (prop);
							return result;
						}
					} else {
						gboolean _tmp30_ = FALSE;
						ValaProperty* _tmp31_;
						ValaPropertyAccessor* _tmp32_;
						ValaPropertyAccessor* _tmp33_;
						_tmp31_ = prop;
						_tmp32_ = vala_property_get_get_accessor (_tmp31_);
						_tmp33_ = _tmp32_;
						if (_tmp33_ != NULL) {
							ValaProperty* _tmp34_;
							ValaPropertyAccessor* _tmp35_;
							ValaPropertyAccessor* _tmp36_;
							ValaDataType* _tmp37_;
							ValaDataType* _tmp38_;
							_tmp34_ = prop;
							_tmp35_ = vala_property_get_get_accessor (_tmp34_);
							_tmp36_ = _tmp35_;
							_tmp37_ = vala_property_accessor_get_value_type (_tmp36_);
							_tmp38_ = _tmp37_;
							_tmp30_ = _tmp38_ != NULL;
						} else {
							_tmp30_ = FALSE;
						}
						if (_tmp30_) {
							ValaProperty* _tmp39_;
							ValaPropertyAccessor* _tmp40_;
							ValaPropertyAccessor* _tmp41_;
							ValaDataType* _tmp42_;
							ValaDataType* _tmp43_;
							ValaDataType* _tmp44_;
							_tmp39_ = prop;
							_tmp40_ = vala_property_get_get_accessor (_tmp39_);
							_tmp41_ = _tmp40_;
							_tmp42_ = vala_property_accessor_get_value_type (_tmp41_);
							_tmp43_ = _tmp42_;
							_tmp44_ = vala_data_type_copy (_tmp43_);
							result = _tmp44_;
							_vala_code_node_unref0 (prop);
							return result;
						}
					}
					_vala_code_node_unref0 (prop);
				} else {
					if (VALA_IS_PARAMETER (sym)) {
						ValaParameter* p = NULL;
						ValaParameter* _tmp45_;
						ValaDataType* type = NULL;
						ValaParameter* _tmp46_;
						ValaDataType* _tmp47_;
						ValaDataType* _tmp48_;
						ValaDataType* _tmp49_;
						_tmp45_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PARAMETER, ValaParameter));
						p = _tmp45_;
						_tmp46_ = p;
						_tmp47_ = vala_variable_get_variable_type ((ValaVariable*) _tmp46_);
						_tmp48_ = _tmp47_;
						_tmp49_ = vala_data_type_copy (_tmp48_);
						type = _tmp49_;
						if (!lvalue) {
							ValaDataType* _tmp50_;
							_tmp50_ = type;
							vala_data_type_set_value_owned (_tmp50_, FALSE);
						}
						result = type;
						_vala_code_node_unref0 (p);
						return result;
					} else {
						if (VALA_IS_LOCAL_VARIABLE (sym)) {
							ValaLocalVariable* local = NULL;
							ValaLocalVariable* _tmp51_;
							ValaDataType* type = NULL;
							ValaLocalVariable* _tmp52_;
							ValaDataType* _tmp53_;
							ValaDataType* _tmp54_;
							ValaDataType* _tmp55_;
							_tmp51_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
							local = _tmp51_;
							_tmp52_ = local;
							_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) _tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = vala_data_type_copy (_tmp54_);
							type = _tmp55_;
							if (!lvalue) {
								ValaDataType* _tmp56_;
								_tmp56_ = type;
								vala_data_type_set_value_owned (_tmp56_, FALSE);
							}
							result = type;
							_vala_code_node_unref0 (local);
							return result;
						} else {
							if (VALA_IS_METHOD (sym)) {
								ValaMethodType* _tmp57_;
								_tmp57_ = vala_method_type_new (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								result = (ValaDataType*) _tmp57_;
								return result;
							} else {
								if (VALA_IS_SIGNAL (sym)) {
									ValaSignalType* _tmp58_;
									_tmp58_ = vala_signal_type_new (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
									result = (ValaDataType*) _tmp58_;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


ValaSymbol*
vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym,
                                                const gchar* name)
{
	ValaSymbol* result = NULL;
	ValaSymbol* _result_ = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	g_return_val_if_fail (sym != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = vala_symbol_get_scope (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_scope_lookup (_tmp1_, name);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		result = _result_;
		return result;
	}
	if (VALA_IS_CLASS (sym)) {
		ValaClass* cl = NULL;
		ValaClass* _tmp4_;
		ValaClass* _tmp26_;
		ValaClass* _tmp27_;
		ValaClass* _tmp28_;
		_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp4_;
		{
			ValaList* _base_type_list = NULL;
			ValaClass* _tmp5_;
			ValaList* _tmp6_;
			gint _base_type_size = 0;
			ValaList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _base_type_index = 0;
			_tmp5_ = cl;
			_tmp6_ = vala_class_get_base_types (_tmp5_);
			_base_type_list = _tmp6_;
			_tmp7_ = _base_type_list;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_base_type_size = _tmp9_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp13_;
				gint _tmp14_;
				gpointer _tmp15_;
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp10_ = _base_type_index;
				_base_type_index = _tmp10_ + 1;
				_tmp11_ = _base_type_index;
				_tmp12_ = _base_type_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _base_type_list;
				_tmp14_ = _base_type_index;
				_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
				base_type = (ValaDataType*) _tmp15_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				if (VALA_IS_INTERFACE (_tmp18_)) {
					ValaDataType* _tmp19_;
					ValaTypeSymbol* _tmp20_;
					ValaTypeSymbol* _tmp21_;
					ValaScope* _tmp22_;
					ValaScope* _tmp23_;
					ValaSymbol* _tmp24_;
					ValaSymbol* _tmp25_;
					_tmp19_ = base_type;
					_tmp20_ = vala_data_type_get_data_type (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = vala_scope_lookup (_tmp23_, name);
					_vala_code_node_unref0 (_result_);
					_result_ = _tmp24_;
					_tmp25_ = _result_;
					if (_tmp25_ != NULL) {
						result = _result_;
						_vala_code_node_unref0 (base_type);
						_vala_iterable_unref0 (_base_type_list);
						_vala_code_node_unref0 (cl);
						return result;
					}
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp26_ = cl;
		_tmp27_ = vala_class_get_base_class (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaClass* _tmp29_;
			ValaClass* _tmp30_;
			ValaClass* _tmp31_;
			ValaSymbol* _tmp32_;
			_tmp29_ = cl;
			_tmp30_ = vala_class_get_base_class (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp31_, name);
			result = _tmp32_;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (_result_);
			return result;
		}
		_vala_code_node_unref0 (cl);
	} else {
		if (VALA_IS_STRUCT (sym)) {
			ValaStruct* st = NULL;
			ValaStruct* _tmp33_;
			ValaStruct* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp33_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp33_;
			_tmp34_ = st;
			_tmp35_ = vala_struct_get_base_type (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_ != NULL) {
				ValaStruct* _tmp37_;
				ValaDataType* _tmp38_;
				ValaDataType* _tmp39_;
				ValaTypeSymbol* _tmp40_;
				ValaTypeSymbol* _tmp41_;
				ValaSymbol* _tmp42_;
				ValaSymbol* _tmp43_;
				_tmp37_ = st;
				_tmp38_ = vala_struct_get_base_type (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = vala_data_type_get_data_type (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp41_, name);
				_vala_code_node_unref0 (_result_);
				_result_ = _tmp42_;
				_tmp43_ = _result_;
				if (_tmp43_ != NULL) {
					result = _result_;
					_vala_code_node_unref0 (st);
					return result;
				}
			}
			_vala_code_node_unref0 (st);
		} else {
			if (VALA_IS_INTERFACE (sym)) {
				ValaInterface* iface = NULL;
				ValaInterface* _tmp44_;
				_tmp44_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_INTERFACE, ValaInterface));
				iface = _tmp44_;
				{
					ValaList* _prerequisite_list = NULL;
					ValaInterface* _tmp45_;
					ValaList* _tmp46_;
					gint _prerequisite_size = 0;
					ValaList* _tmp47_;
					gint _tmp48_;
					gint _tmp49_;
					gint _prerequisite_index = 0;
					_tmp45_ = iface;
					_tmp46_ = vala_interface_get_prerequisites (_tmp45_);
					_prerequisite_list = _tmp46_;
					_tmp47_ = _prerequisite_list;
					_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
					_tmp49_ = _tmp48_;
					_prerequisite_size = _tmp49_;
					_prerequisite_index = -1;
					while (TRUE) {
						gint _tmp50_;
						gint _tmp51_;
						gint _tmp52_;
						ValaDataType* prerequisite = NULL;
						ValaList* _tmp53_;
						gint _tmp54_;
						gpointer _tmp55_;
						ValaDataType* _tmp56_;
						ValaTypeSymbol* _tmp57_;
						ValaTypeSymbol* _tmp58_;
						_tmp50_ = _prerequisite_index;
						_prerequisite_index = _tmp50_ + 1;
						_tmp51_ = _prerequisite_index;
						_tmp52_ = _prerequisite_size;
						if (!(_tmp51_ < _tmp52_)) {
							break;
						}
						_tmp53_ = _prerequisite_list;
						_tmp54_ = _prerequisite_index;
						_tmp55_ = vala_list_get (_tmp53_, _tmp54_);
						prerequisite = (ValaDataType*) _tmp55_;
						_tmp56_ = prerequisite;
						_tmp57_ = vala_data_type_get_data_type (_tmp56_);
						_tmp58_ = _tmp57_;
						if (VALA_IS_INTERFACE (_tmp58_)) {
							ValaDataType* _tmp59_;
							ValaTypeSymbol* _tmp60_;
							ValaTypeSymbol* _tmp61_;
							ValaSymbol* _tmp62_;
							ValaSymbol* _tmp63_;
							_tmp59_ = prerequisite;
							_tmp60_ = vala_data_type_get_data_type (_tmp59_);
							_tmp61_ = _tmp60_;
							_tmp62_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp61_, name);
							_vala_code_node_unref0 (_result_);
							_result_ = _tmp62_;
							_tmp63_ = _result_;
							if (_tmp63_ != NULL) {
								result = _result_;
								_vala_code_node_unref0 (prerequisite);
								_vala_iterable_unref0 (_prerequisite_list);
								_vala_code_node_unref0 (iface);
								return result;
							}
						}
						_vala_code_node_unref0 (prerequisite);
					}
					_vala_iterable_unref0 (_prerequisite_list);
				}
				{
					ValaList* _prerequisite_list = NULL;
					ValaInterface* _tmp64_;
					ValaList* _tmp65_;
					gint _prerequisite_size = 0;
					ValaList* _tmp66_;
					gint _tmp67_;
					gint _tmp68_;
					gint _prerequisite_index = 0;
					_tmp64_ = iface;
					_tmp65_ = vala_interface_get_prerequisites (_tmp64_);
					_prerequisite_list = _tmp65_;
					_tmp66_ = _prerequisite_list;
					_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
					_tmp68_ = _tmp67_;
					_prerequisite_size = _tmp68_;
					_prerequisite_index = -1;
					while (TRUE) {
						gint _tmp69_;
						gint _tmp70_;
						gint _tmp71_;
						ValaDataType* prerequisite = NULL;
						ValaList* _tmp72_;
						gint _tmp73_;
						gpointer _tmp74_;
						ValaDataType* _tmp75_;
						ValaTypeSymbol* _tmp76_;
						ValaTypeSymbol* _tmp77_;
						_tmp69_ = _prerequisite_index;
						_prerequisite_index = _tmp69_ + 1;
						_tmp70_ = _prerequisite_index;
						_tmp71_ = _prerequisite_size;
						if (!(_tmp70_ < _tmp71_)) {
							break;
						}
						_tmp72_ = _prerequisite_list;
						_tmp73_ = _prerequisite_index;
						_tmp74_ = vala_list_get (_tmp72_, _tmp73_);
						prerequisite = (ValaDataType*) _tmp74_;
						_tmp75_ = prerequisite;
						_tmp76_ = vala_data_type_get_data_type (_tmp75_);
						_tmp77_ = _tmp76_;
						if (VALA_IS_CLASS (_tmp77_)) {
							ValaDataType* _tmp78_;
							ValaTypeSymbol* _tmp79_;
							ValaTypeSymbol* _tmp80_;
							ValaSymbol* _tmp81_;
							ValaSymbol* _tmp82_;
							_tmp78_ = prerequisite;
							_tmp79_ = vala_data_type_get_data_type (_tmp78_);
							_tmp80_ = _tmp79_;
							_tmp81_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp80_, name);
							_vala_code_node_unref0 (_result_);
							_result_ = _tmp81_;
							_tmp82_ = _result_;
							if (_tmp82_ != NULL) {
								result = _result_;
								_vala_code_node_unref0 (prerequisite);
								_vala_iterable_unref0 (_prerequisite_list);
								_vala_code_node_unref0 (iface);
								return result;
							}
						}
						_vala_code_node_unref0 (prerequisite);
					}
					_vala_iterable_unref0 (_prerequisite_list);
				}
				_vala_code_node_unref0 (iface);
			}
		}
	}
	result = NULL;
	_vala_code_node_unref0 (_result_);
	return result;
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaDataType*
vala_semantic_analyzer_get_data_type_for_symbol (ValaSymbol* sym)
{
	ValaDataType* result = NULL;
	ValaDataType* type = NULL;
	ValaList* type_parameters = NULL;
	ValaList* _tmp33_;
	g_return_val_if_fail (sym != NULL, NULL);
	type = NULL;
	type_parameters = NULL;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (sym)) {
		ValaClass* cl = NULL;
		ValaClass* _tmp0_;
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp0_ = _vala_code_node_ref0 (VALA_IS_CLASS (sym) ? ((ValaClass*) sym) : NULL);
		cl = _tmp0_;
		_tmp2_ = cl;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			gboolean _tmp4_;
			gboolean _tmp5_;
			_tmp3_ = cl;
			_tmp4_ = vala_class_get_is_error_base (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp1_ = _tmp5_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaErrorType* _tmp6_;
			_tmp6_ = vala_error_type_new (NULL, NULL, NULL);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp6_;
		} else {
			ValaObjectType* _tmp7_;
			ValaList* _tmp8_;
			_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_vala_iterable_unref0 (type_parameters);
			type_parameters = _tmp8_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		if (VALA_IS_STRUCT (sym)) {
			ValaStruct* st = NULL;
			ValaStruct* _tmp9_;
			ValaStruct* _tmp10_;
			ValaStruct* _tmp21_;
			ValaList* _tmp22_;
			_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp9_;
			_tmp10_ = st;
			if (vala_struct_is_boolean_type (_tmp10_)) {
				ValaStruct* _tmp11_;
				ValaBooleanType* _tmp12_;
				_tmp11_ = st;
				_tmp12_ = vala_boolean_type_new (_tmp11_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp12_;
			} else {
				ValaStruct* _tmp13_;
				_tmp13_ = st;
				if (vala_struct_is_integer_type (_tmp13_)) {
					ValaStruct* _tmp14_;
					ValaIntegerType* _tmp15_;
					_tmp14_ = st;
					_tmp15_ = vala_integer_type_new (_tmp14_, NULL, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp15_;
				} else {
					ValaStruct* _tmp16_;
					_tmp16_ = st;
					if (vala_struct_is_floating_type (_tmp16_)) {
						ValaStruct* _tmp17_;
						ValaFloatingType* _tmp18_;
						_tmp17_ = st;
						_tmp18_ = vala_floating_type_new (_tmp17_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp18_;
					} else {
						ValaStruct* _tmp19_;
						ValaStructValueType* _tmp20_;
						_tmp19_ = st;
						_tmp20_ = vala_struct_value_type_new (_tmp19_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp20_;
					}
				}
			}
			_tmp21_ = st;
			_tmp22_ = vala_struct_get_type_parameters (_tmp21_);
			_vala_iterable_unref0 (type_parameters);
			type_parameters = _tmp22_;
			_vala_code_node_unref0 (st);
		} else {
			if (VALA_IS_ENUM (sym)) {
				ValaEnumValueType* _tmp23_;
				_tmp23_ = vala_enum_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp23_;
			} else {
				if (VALA_IS_ERROR_DOMAIN (sym)) {
					ValaErrorType* _tmp24_;
					_tmp24_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), NULL, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp24_;
				} else {
					if (VALA_IS_ERROR_CODE (sym)) {
						ValaSymbol* _tmp25_;
						ValaSymbol* _tmp26_;
						ValaErrorType* _tmp27_;
						_tmp25_ = vala_symbol_get_parent_symbol (sym);
						_tmp26_ = _tmp25_;
						_tmp27_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_CODE, ValaErrorCode), NULL);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp27_;
					} else {
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						ValaInvalidType* _tmp32_;
						_tmp28_ = vala_symbol_get_full_name (sym);
						_tmp29_ = _tmp28_;
						_tmp30_ = g_strdup_printf ("internal error: `%s' is not a supported type", _tmp29_);
						_tmp31_ = _tmp30_;
						vala_report_error (NULL, _tmp31_);
						_g_free0 (_tmp31_);
						_g_free0 (_tmp29_);
						_tmp32_ = vala_invalid_type_new ();
						result = (ValaDataType*) _tmp32_;
						_vala_iterable_unref0 (type_parameters);
						_vala_code_node_unref0 (type);
						return result;
					}
				}
			}
		}
	}
	_tmp33_ = type_parameters;
	if (_tmp33_ != NULL) {
		{
			ValaList* _type_param_list = NULL;
			ValaList* _tmp34_;
			ValaList* _tmp35_;
			gint _type_param_size = 0;
			ValaList* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _type_param_index = 0;
			_tmp34_ = type_parameters;
			_tmp35_ = _vala_iterable_ref0 (_tmp34_);
			_type_param_list = _tmp35_;
			_tmp36_ = _type_param_list;
			_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_type_param_size = _tmp38_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp42_;
				gint _tmp43_;
				gpointer _tmp44_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp45_;
				ValaGenericType* _tmp46_;
				ValaGenericType* _tmp47_;
				ValaDataType* _tmp48_;
				ValaGenericType* _tmp49_;
				_tmp39_ = _type_param_index;
				_type_param_index = _tmp39_ + 1;
				_tmp40_ = _type_param_index;
				_tmp41_ = _type_param_size;
				if (!(_tmp40_ < _tmp41_)) {
					break;
				}
				_tmp42_ = _type_param_list;
				_tmp43_ = _type_param_index;
				_tmp44_ = vala_list_get (_tmp42_, _tmp43_);
				type_param = (ValaTypeParameter*) _tmp44_;
				_tmp45_ = type_param;
				_tmp46_ = vala_generic_type_new (_tmp45_);
				type_arg = _tmp46_;
				_tmp47_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp47_, TRUE);
				_tmp48_ = type;
				_tmp49_ = type_arg;
				vala_data_type_add_type_argument (_tmp48_, (ValaDataType*) _tmp49_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
	}
	result = type;
	_vala_iterable_unref0 (type_parameters);
	return result;
}


ValaSymbol*
vala_semantic_analyzer_get_symbol_for_data_type (ValaDataType* type)
{
	ValaSymbol* result = NULL;
	ValaSymbol* sym = NULL;
	g_return_val_if_fail (type != NULL, NULL);
	sym = NULL;
	if (VALA_IS_OBJECT_TYPE (type)) {
		ValaObjectTypeSymbol* _tmp0_;
		ValaObjectTypeSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		_tmp0_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
		_tmp1_ = _tmp0_;
		_tmp2_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp1_);
		_vala_code_node_unref0 (sym);
		sym = _tmp2_;
	} else {
		if (VALA_IS_CLASS_TYPE (type)) {
			ValaClass* _tmp3_;
			ValaClass* _tmp4_;
			ValaSymbol* _tmp5_;
			_tmp3_ = vala_class_type_get_class_symbol (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_CLASS_TYPE, ValaClassType));
			_tmp4_ = _tmp3_;
			_tmp5_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp4_);
			_vala_code_node_unref0 (sym);
			sym = _tmp5_;
		} else {
			if (VALA_IS_INTERFACE_TYPE (type)) {
				ValaInterface* _tmp6_;
				ValaInterface* _tmp7_;
				ValaSymbol* _tmp8_;
				_tmp6_ = vala_interface_type_get_interface_symbol (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_INTERFACE_TYPE, ValaInterfaceType));
				_tmp7_ = _tmp6_;
				_tmp8_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp7_);
				_vala_code_node_unref0 (sym);
				sym = _tmp8_;
			} else {
				if (VALA_IS_METHOD_TYPE (type)) {
					ValaMethod* _tmp9_;
					ValaMethod* _tmp10_;
					ValaSymbol* _tmp11_;
					_tmp9_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_METHOD_TYPE, ValaMethodType));
					_tmp10_ = _tmp9_;
					_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
					_vala_code_node_unref0 (sym);
					sym = _tmp11_;
				} else {
					if (VALA_IS_SIGNAL_TYPE (type)) {
						ValaSignal* _tmp12_;
						ValaSignal* _tmp13_;
						ValaSymbol* _tmp14_;
						_tmp12_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
						_tmp13_ = _tmp12_;
						_tmp14_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp13_);
						_vala_code_node_unref0 (sym);
						sym = _tmp14_;
					} else {
						if (VALA_IS_DELEGATE_TYPE (type)) {
							ValaDelegate* _tmp15_;
							ValaDelegate* _tmp16_;
							ValaSymbol* _tmp17_;
							_tmp15_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							_tmp16_ = _tmp15_;
							_tmp17_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp16_);
							_vala_code_node_unref0 (sym);
							sym = _tmp17_;
						} else {
							if (VALA_IS_VALUE_TYPE (type)) {
								ValaTypeSymbol* _tmp18_;
								ValaTypeSymbol* _tmp19_;
								ValaSymbol* _tmp20_;
								_tmp18_ = vala_value_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_VALUE_TYPE, ValaValueType));
								_tmp19_ = _tmp18_;
								_tmp20_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp19_);
								_vala_code_node_unref0 (sym);
								sym = _tmp20_;
							}
						}
					}
				}
			}
		}
	}
	result = sym;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


gboolean
vala_semantic_analyzer_check_arguments (ValaSemanticAnalyzer* self,
                                        ValaExpression* expr,
                                        ValaDataType* mtype,
                                        ValaList* params,
                                        ValaList* args)
{
	gboolean result = FALSE;
	gboolean _error_ = FALSE;
	ValaExpression* prev_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaIterator* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean diag = FALSE;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gboolean _tmp83_ = FALSE;
	gboolean _tmp84_;
	gboolean _tmp118_ = FALSE;
	gboolean _tmp119_;
	gboolean _tmp145_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (expr != NULL, FALSE);
	g_return_val_if_fail (mtype != NULL, FALSE);
	g_return_val_if_fail (params != NULL, FALSE);
	g_return_val_if_fail (args != NULL, FALSE);
	_error_ = FALSE;
	prev_arg = NULL;
	_tmp0_ = vala_iterable_iterator ((ValaIterable*) args);
	arg_it = _tmp0_;
	if (VALA_IS_METHOD_TYPE (mtype)) {
		ValaMethod* _tmp2_;
		ValaMethod* _tmp3_;
		ValaAttribute* _tmp4_;
		ValaAttribute* _tmp5_;
		_tmp2_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (mtype, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp3_, "Diagnostics");
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ != NULL;
		_vala_code_node_unref0 (_tmp5_);
	} else {
		_tmp1_ = FALSE;
	}
	diag = _tmp1_;
	ellipsis = FALSE;
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp6_;
		gint _param_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _param_index = 0;
		_tmp6_ = _vala_iterable_ref0 (params);
		_param_list = _tmp6_;
		_tmp7_ = _param_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_param_size = _tmp9_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaParameter* param = NULL;
			ValaList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_;
			ValaParameter* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			ValaParameter* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp31_ = FALSE;
			ValaIterator* _tmp32_;
			_tmp10_ = _param_index;
			_param_index = _tmp10_ + 1;
			_tmp11_ = _param_index;
			_tmp12_ = _param_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _param_list;
			_tmp14_ = _param_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			param = (ValaParameter*) _tmp15_;
			_tmp16_ = param;
			_tmp17_ = vala_parameter_get_ellipsis (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_) {
				ellipsis = TRUE;
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp19_ = param;
			_tmp20_ = vala_parameter_get_params_array (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				while (TRUE) {
					ValaIterator* _tmp22_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp23_;
					gpointer _tmp24_;
					ValaExpression* _tmp25_;
					gint _tmp26_;
					ValaParameter* _tmp27_;
					ValaParameterDirection _tmp28_;
					ValaParameterDirection _tmp29_;
					gint _tmp30_;
					_tmp22_ = arg_it;
					if (!vala_iterator_next (_tmp22_)) {
						break;
					}
					_tmp23_ = arg_it;
					_tmp24_ = vala_iterator_get (_tmp23_);
					arg = (ValaExpression*) _tmp24_;
					_tmp25_ = arg;
					_tmp26_ = i;
					_tmp27_ = param;
					_tmp28_ = vala_parameter_get_direction (_tmp27_);
					_tmp29_ = _tmp28_;
					if (!vala_semantic_analyzer_check_argument (self, _tmp25_, _tmp26_, _tmp29_)) {
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						_error_ = TRUE;
					}
					_tmp30_ = i;
					i = _tmp30_ + 1;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp32_ = arg_it;
			if (_tmp32_ == NULL) {
				_tmp31_ = TRUE;
			} else {
				ValaIterator* _tmp33_;
				_tmp33_ = arg_it;
				_tmp31_ = !vala_iterator_next (_tmp33_);
			}
			if (_tmp31_) {
				ValaParameter* _tmp34_;
				ValaExpression* _tmp35_;
				ValaExpression* _tmp36_;
				_tmp34_ = param;
				_tmp35_ = vala_variable_get_initializer ((ValaVariable*) _tmp34_);
				_tmp36_ = _tmp35_;
				if (_tmp36_ == NULL) {
					ValaMethodType* m = NULL;
					ValaMethodType* _tmp37_;
					ValaMethodType* _tmp38_;
					vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
					_tmp37_ = _vala_code_node_ref0 (VALA_IS_METHOD_TYPE (mtype) ? ((ValaMethodType*) mtype) : NULL);
					m = _tmp37_;
					_tmp38_ = m;
					if (_tmp38_ != NULL) {
						ValaSourceReference* _tmp39_;
						ValaSourceReference* _tmp40_;
						ValaMethodType* _tmp41_;
						ValaList* _tmp42_;
						ValaList* _tmp43_;
						gint _tmp44_;
						gint _tmp45_;
						gint _tmp46_;
						gint _tmp47_;
						ValaMethodType* _tmp48_;
						gchar* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
						_tmp40_ = _tmp39_;
						_tmp41_ = m;
						_tmp42_ = vala_data_type_get_parameters ((ValaDataType*) _tmp41_);
						_tmp43_ = _tmp42_;
						_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
						_tmp45_ = _tmp44_;
						_tmp46_ = vala_collection_get_size ((ValaCollection*) args);
						_tmp47_ = _tmp46_;
						_tmp48_ = m;
						_tmp49_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp48_, NULL);
						_tmp50_ = _tmp49_;
						_tmp51_ = g_strdup_printf ("%d missing arguments for `%s'", _tmp45_ - _tmp47_, _tmp50_);
						_tmp52_ = _tmp51_;
						vala_report_error (_tmp40_, _tmp52_);
						_g_free0 (_tmp52_);
						_g_free0 (_tmp50_);
						_vala_iterable_unref0 (_tmp43_);
					} else {
						ValaSourceReference* _tmp53_;
						ValaSourceReference* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						gint _tmp57_;
						gint _tmp58_;
						gchar* _tmp59_;
						gchar* _tmp60_;
						_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
						_tmp54_ = _tmp53_;
						_tmp55_ = vala_code_node_to_string ((ValaCodeNode*) mtype);
						_tmp56_ = _tmp55_;
						_tmp57_ = vala_collection_get_size ((ValaCollection*) args);
						_tmp58_ = _tmp57_;
						_tmp59_ = g_strdup_printf ("Too few arguments, method `%s' does not take %d arguments", _tmp56_, _tmp58_);
						_tmp60_ = _tmp59_;
						vala_report_error (_tmp54_, _tmp60_);
						_g_free0 (_tmp60_);
						_g_free0 (_tmp56_);
					}
					_error_ = TRUE;
					_vala_code_node_unref0 (m);
				} else {
					ValaMethodCall* invocation_expr = NULL;
					ValaMethodCall* _tmp61_;
					ValaObjectCreationExpression* object_creation_expr = NULL;
					ValaObjectCreationExpression* _tmp62_;
					ValaMethodCall* _tmp63_;
					_tmp61_ = _vala_code_node_ref0 (VALA_IS_METHOD_CALL (expr) ? ((ValaMethodCall*) expr) : NULL);
					invocation_expr = _tmp61_;
					_tmp62_ = _vala_code_node_ref0 (VALA_IS_OBJECT_CREATION_EXPRESSION (expr) ? ((ValaObjectCreationExpression*) expr) : NULL);
					object_creation_expr = _tmp62_;
					_tmp63_ = invocation_expr;
					if (_tmp63_ != NULL) {
						ValaMethodCall* _tmp64_;
						ValaParameter* _tmp65_;
						ValaExpression* _tmp66_;
						ValaExpression* _tmp67_;
						_tmp64_ = invocation_expr;
						_tmp65_ = param;
						_tmp66_ = vala_variable_get_initializer ((ValaVariable*) _tmp65_);
						_tmp67_ = _tmp66_;
						vala_method_call_add_argument (_tmp64_, _tmp67_);
					} else {
						ValaObjectCreationExpression* _tmp68_;
						_tmp68_ = object_creation_expr;
						if (_tmp68_ != NULL) {
							ValaObjectCreationExpression* _tmp69_;
							ValaParameter* _tmp70_;
							ValaExpression* _tmp71_;
							ValaExpression* _tmp72_;
							_tmp69_ = object_creation_expr;
							_tmp70_ = param;
							_tmp71_ = vala_variable_get_initializer ((ValaVariable*) _tmp70_);
							_tmp72_ = _tmp71_;
							vala_object_creation_expression_add_argument (_tmp69_, _tmp72_);
						} else {
							g_assert_not_reached ();
						}
					}
					_vala_iterator_unref0 (arg_it);
					arg_it = NULL;
					_vala_code_node_unref0 (object_creation_expr);
					_vala_code_node_unref0 (invocation_expr);
				}
			} else {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp73_;
				gpointer _tmp74_;
				ValaExpression* _tmp75_;
				gint _tmp76_;
				ValaParameter* _tmp77_;
				ValaParameterDirection _tmp78_;
				ValaParameterDirection _tmp79_;
				ValaExpression* _tmp80_;
				ValaExpression* _tmp81_;
				gint _tmp82_;
				_tmp73_ = arg_it;
				_tmp74_ = vala_iterator_get (_tmp73_);
				arg = (ValaExpression*) _tmp74_;
				_tmp75_ = arg;
				_tmp76_ = i;
				_tmp77_ = param;
				_tmp78_ = vala_parameter_get_direction (_tmp77_);
				_tmp79_ = _tmp78_;
				if (!vala_semantic_analyzer_check_argument (self, _tmp75_, _tmp76_, _tmp79_)) {
					vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
					_error_ = TRUE;
				}
				_tmp80_ = arg;
				_tmp81_ = _vala_code_node_ref0 (_tmp80_);
				_vala_code_node_unref0 (prev_arg);
				prev_arg = _tmp81_;
				_tmp82_ = i;
				i = _tmp82_ + 1;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp84_ = ellipsis;
	if (_tmp84_) {
		ValaIterator* _tmp85_;
		gint _tmp86_;
		ValaSourceReference* _tmp87_;
		ValaSourceReference* _tmp88_;
		_tmp85_ = arg_it;
		_tmp86_ = i;
		_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp88_ = _tmp87_;
		_tmp83_ = !vala_semantic_analyzer_check_variadic_arguments (self, _tmp85_, _tmp86_, _tmp88_);
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
		_error_ = TRUE;
	} else {
		gboolean _tmp89_ = FALSE;
		gboolean _tmp90_ = FALSE;
		gboolean _tmp91_;
		_tmp91_ = ellipsis;
		if (!_tmp91_) {
			ValaIterator* _tmp92_;
			_tmp92_ = arg_it;
			_tmp90_ = _tmp92_ != NULL;
		} else {
			_tmp90_ = FALSE;
		}
		if (_tmp90_) {
			ValaIterator* _tmp93_;
			_tmp93_ = arg_it;
			_tmp89_ = vala_iterator_next (_tmp93_);
		} else {
			_tmp89_ = FALSE;
		}
		if (_tmp89_) {
			ValaMethodType* m = NULL;
			ValaMethodType* _tmp94_;
			ValaMethodType* _tmp95_;
			vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
			_tmp94_ = _vala_code_node_ref0 (VALA_IS_METHOD_TYPE (mtype) ? ((ValaMethodType*) mtype) : NULL);
			m = _tmp94_;
			_tmp95_ = m;
			if (_tmp95_ != NULL) {
				ValaSourceReference* _tmp96_;
				ValaSourceReference* _tmp97_;
				gint _tmp98_;
				gint _tmp99_;
				ValaMethodType* _tmp100_;
				ValaList* _tmp101_;
				ValaList* _tmp102_;
				gint _tmp103_;
				gint _tmp104_;
				ValaMethodType* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
				gchar* _tmp108_;
				gchar* _tmp109_;
				_tmp96_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
				_tmp97_ = _tmp96_;
				_tmp98_ = vala_collection_get_size ((ValaCollection*) args);
				_tmp99_ = _tmp98_;
				_tmp100_ = m;
				_tmp101_ = vala_data_type_get_parameters ((ValaDataType*) _tmp100_);
				_tmp102_ = _tmp101_;
				_tmp103_ = vala_collection_get_size ((ValaCollection*) _tmp102_);
				_tmp104_ = _tmp103_;
				_tmp105_ = m;
				_tmp106_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp105_, NULL);
				_tmp107_ = _tmp106_;
				_tmp108_ = g_strdup_printf ("%d extra arguments for `%s'", _tmp99_ - _tmp104_, _tmp107_);
				_tmp109_ = _tmp108_;
				vala_report_error (_tmp97_, _tmp109_);
				_g_free0 (_tmp109_);
				_g_free0 (_tmp107_);
				_vala_iterable_unref0 (_tmp102_);
			} else {
				ValaSourceReference* _tmp110_;
				ValaSourceReference* _tmp111_;
				gchar* _tmp112_;
				gchar* _tmp113_;
				gint _tmp114_;
				gint _tmp115_;
				gchar* _tmp116_;
				gchar* _tmp117_;
				_tmp110_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
				_tmp111_ = _tmp110_;
				_tmp112_ = vala_code_node_to_string ((ValaCodeNode*) mtype);
				_tmp113_ = _tmp112_;
				_tmp114_ = vala_collection_get_size ((ValaCollection*) args);
				_tmp115_ = _tmp114_;
				_tmp116_ = g_strdup_printf ("Too many arguments, method `%s' does not take %d arguments", _tmp113_, _tmp115_);
				_tmp117_ = _tmp116_;
				vala_report_error (_tmp111_, _tmp117_);
				_g_free0 (_tmp117_);
				_g_free0 (_tmp113_);
			}
			_error_ = TRUE;
			_vala_code_node_unref0 (m);
		}
	}
	_tmp119_ = diag;
	if (_tmp119_) {
		ValaExpression* _tmp120_;
		_tmp120_ = prev_arg;
		_tmp118_ = _tmp120_ != NULL;
	} else {
		_tmp118_ = FALSE;
	}
	if (_tmp118_) {
		ValaStringLiteral* format_arg = NULL;
		ValaExpression* _tmp121_;
		ValaStringLiteral* _tmp122_;
		ValaStringLiteral* _tmp123_;
		_tmp121_ = prev_arg;
		_tmp122_ = _vala_code_node_ref0 (VALA_IS_STRING_LITERAL (_tmp121_) ? ((ValaStringLiteral*) _tmp121_) : NULL);
		format_arg = _tmp122_;
		_tmp123_ = format_arg;
		if (_tmp123_ != NULL) {
			ValaStringLiteral* _tmp124_;
			ValaSourceReference* _tmp125_;
			ValaSourceReference* _tmp126_;
			ValaSourceFile* _tmp127_;
			ValaSourceFile* _tmp128_;
			const gchar* _tmp129_;
			const gchar* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			ValaSourceReference* _tmp133_;
			ValaSourceReference* _tmp134_;
			ValaSourceLocation _tmp135_ = {0};
			ValaSourceLocation _tmp136_;
			gint _tmp137_;
			ValaStringLiteral* _tmp138_;
			const gchar* _tmp139_;
			const gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			_tmp124_ = format_arg;
			_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp126_ = _tmp125_;
			_tmp127_ = vala_source_reference_get_file (_tmp126_);
			_tmp128_ = _tmp127_;
			_tmp129_ = vala_source_file_get_filename (_tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = g_path_get_basename (_tmp130_);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp134_ = _tmp133_;
			vala_source_reference_get_begin (_tmp134_, &_tmp135_);
			_tmp136_ = _tmp135_;
			_tmp137_ = _tmp136_.line;
			_tmp138_ = format_arg;
			_tmp139_ = vala_string_literal_get_value (_tmp138_);
			_tmp140_ = _tmp139_;
			_tmp141_ = string_substring (_tmp140_, (glong) 1, (glong) -1);
			_tmp142_ = _tmp141_;
			_tmp143_ = g_strdup_printf ("\"%s:%d: %s", _tmp132_, _tmp137_, _tmp142_);
			_tmp144_ = _tmp143_;
			vala_string_literal_set_value (_tmp124_, _tmp144_);
			_g_free0 (_tmp144_);
			_g_free0 (_tmp142_);
			_g_free0 (_tmp132_);
		}
		_vala_code_node_unref0 (format_arg);
	}
	_tmp145_ = _error_;
	result = !_tmp145_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (prev_arg);
	return result;
}


static gboolean
vala_semantic_analyzer_check_argument (ValaSemanticAnalyzer* self,
                                       ValaExpression* arg,
                                       gint i,
                                       ValaParameterDirection direction)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp87_;
	ValaDataType* _tmp88_;
	ValaMemberAccess* ma = NULL;
	ValaMemberAccess* _tmp126_;
	gboolean _tmp127_ = FALSE;
	ValaMemberAccess* _tmp128_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	_tmp0_ = vala_code_node_get_error ((ValaCodeNode*) arg);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	} else {
		if (VALA_IS_NAMED_ARGUMENT (arg)) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
			_tmp3_ = _tmp2_;
			vala_report_error (_tmp3_, "Named arguments are not supported yet");
			result = FALSE;
			return result;
		} else {
			ValaDataType* _tmp4_;
			ValaDataType* _tmp5_;
			_tmp4_ = vala_expression_get_value_type (arg);
			_tmp5_ = _tmp4_;
			if (_tmp5_ == NULL) {
				gboolean _tmp6_ = FALSE;
				ValaDataType* _tmp7_;
				ValaDataType* _tmp8_;
				_tmp7_ = vala_expression_get_target_type (arg);
				_tmp8_ = _tmp7_;
				if (!VALA_IS_DELEGATE_TYPE (_tmp8_)) {
					_tmp6_ = TRUE;
				} else {
					ValaSymbol* _tmp9_;
					ValaSymbol* _tmp10_;
					_tmp9_ = vala_expression_get_symbol_reference (arg);
					_tmp10_ = _tmp9_;
					_tmp6_ = !VALA_IS_METHOD (_tmp10_);
				}
				if (_tmp6_) {
					ValaSourceReference* _tmp11_;
					ValaSourceReference* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strdup_printf ("Invalid type for argument %d", i + 1);
					_tmp14_ = _tmp13_;
					vala_report_error (_tmp12_, _tmp14_);
					_g_free0 (_tmp14_);
					result = FALSE;
					return result;
				}
			} else {
				gint arg_type = 0;
				ValaDataType* _tmp15_;
				ValaDataType* _tmp16_;
				gint _tmp24_;
				arg_type = 1;
				_tmp15_ = vala_expression_get_value_type (arg);
				_tmp16_ = _tmp15_;
				if (VALA_IS_NULL_TYPE (_tmp16_)) {
					arg_type = 0;
				} else {
					if (VALA_IS_UNARY_EXPRESSION (arg)) {
						ValaUnaryExpression* unary = NULL;
						ValaUnaryExpression* _tmp17_;
						ValaUnaryExpression* _tmp18_;
						ValaUnaryOperator _tmp19_;
						ValaUnaryOperator _tmp20_;
						_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (arg, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
						unary = _tmp17_;
						_tmp18_ = unary;
						_tmp19_ = vala_unary_expression_get_operator (_tmp18_);
						_tmp20_ = _tmp19_;
						if (_tmp20_ == VALA_UNARY_OPERATOR_REF) {
							arg_type = 2;
						} else {
							ValaUnaryExpression* _tmp21_;
							ValaUnaryOperator _tmp22_;
							ValaUnaryOperator _tmp23_;
							_tmp21_ = unary;
							_tmp22_ = vala_unary_expression_get_operator (_tmp21_);
							_tmp23_ = _tmp22_;
							if (_tmp23_ == VALA_UNARY_OPERATOR_OUT) {
								arg_type = 3;
							}
						}
						_vala_code_node_unref0 (unary);
					}
				}
				_tmp24_ = arg_type;
				if (_tmp24_ == 0) {
					if (direction == VALA_PARAMETER_DIRECTION_REF) {
						ValaSourceReference* _tmp25_;
						ValaSourceReference* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
						_tmp26_ = _tmp25_;
						_tmp27_ = g_strdup_printf ("Argument %d: Cannot pass null to reference parameter", i + 1);
						_tmp28_ = _tmp27_;
						vala_report_error (_tmp26_, _tmp28_);
						_g_free0 (_tmp28_);
						result = FALSE;
						return result;
					} else {
						gboolean _tmp29_ = FALSE;
						if (direction != VALA_PARAMETER_DIRECTION_OUT) {
							ValaDataType* _tmp30_;
							ValaDataType* _tmp31_;
							gboolean _tmp32_;
							gboolean _tmp33_;
							_tmp30_ = vala_expression_get_target_type (arg);
							_tmp31_ = _tmp30_;
							_tmp32_ = vala_data_type_get_nullable (_tmp31_);
							_tmp33_ = _tmp32_;
							_tmp29_ = !_tmp33_;
						} else {
							_tmp29_ = FALSE;
						}
						if (_tmp29_) {
							ValaSourceReference* _tmp34_;
							ValaSourceReference* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
							_tmp35_ = _tmp34_;
							_tmp36_ = g_strdup_printf ("Argument %d: Cannot pass null to non-null parameter type", i + 1);
							_tmp37_ = _tmp36_;
							vala_report_warning (_tmp35_, _tmp37_);
							_g_free0 (_tmp37_);
						}
					}
				} else {
					gint _tmp38_;
					_tmp38_ = arg_type;
					if (_tmp38_ == 1) {
						if (direction != VALA_PARAMETER_DIRECTION_IN) {
							ValaSourceReference* _tmp39_;
							ValaSourceReference* _tmp40_;
							gchar* _tmp41_;
							gchar* _tmp42_;
							_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
							_tmp40_ = _tmp39_;
							_tmp41_ = g_strdup_printf ("Argument %d: Cannot pass value to reference or output parameter", i + 1);
							_tmp42_ = _tmp41_;
							vala_report_error (_tmp40_, _tmp42_);
							_g_free0 (_tmp42_);
							result = FALSE;
							return result;
						}
					} else {
						gint _tmp43_;
						_tmp43_ = arg_type;
						if (_tmp43_ == 2) {
							ValaDataType* _tmp48_;
							ValaDataType* _tmp49_;
							ValaDataType* _tmp61_;
							ValaDataType* _tmp62_;
							if (direction != VALA_PARAMETER_DIRECTION_REF) {
								ValaSourceReference* _tmp44_;
								ValaSourceReference* _tmp45_;
								gchar* _tmp46_;
								gchar* _tmp47_;
								_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
								_tmp45_ = _tmp44_;
								_tmp46_ = g_strdup_printf ("Argument %d: Cannot pass ref argument to non-reference parameter", i + 1);
								_tmp47_ = _tmp46_;
								vala_report_error (_tmp45_, _tmp47_);
								_g_free0 (_tmp47_);
								result = FALSE;
								return result;
							}
							_tmp48_ = vala_expression_get_target_type (arg);
							_tmp49_ = _tmp48_;
							if (vala_data_type_is_disposable (_tmp49_)) {
								gboolean _tmp50_ = FALSE;
								ValaDataType* _tmp51_;
								ValaDataType* _tmp52_;
								_tmp51_ = vala_expression_get_value_type (arg);
								_tmp52_ = _tmp51_;
								if (!VALA_IS_POINTER_TYPE (_tmp52_)) {
									ValaDataType* _tmp53_;
									ValaDataType* _tmp54_;
									gboolean _tmp55_;
									gboolean _tmp56_;
									_tmp53_ = vala_expression_get_value_type (arg);
									_tmp54_ = _tmp53_;
									_tmp55_ = vala_data_type_get_value_owned (_tmp54_);
									_tmp56_ = _tmp55_;
									_tmp50_ = !_tmp56_;
								} else {
									_tmp50_ = FALSE;
								}
								if (_tmp50_) {
									ValaSourceReference* _tmp57_;
									ValaSourceReference* _tmp58_;
									gchar* _tmp59_;
									gchar* _tmp60_;
									_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
									_tmp58_ = _tmp57_;
									_tmp59_ = g_strdup_printf ("Argument %d: Cannot pass unowned ref argument to owned reference param" \
"eter", i + 1);
									_tmp60_ = _tmp59_;
									vala_report_error (_tmp58_, _tmp60_);
									_g_free0 (_tmp60_);
									result = FALSE;
									return result;
								}
							}
							_tmp61_ = vala_expression_get_value_type (arg);
							_tmp62_ = _tmp61_;
							if (vala_data_type_is_disposable (_tmp62_)) {
								ValaDataType* _tmp63_;
								ValaDataType* _tmp64_;
								gboolean _tmp65_;
								gboolean _tmp66_;
								_tmp63_ = vala_expression_get_target_type (arg);
								_tmp64_ = _tmp63_;
								_tmp65_ = vala_data_type_get_value_owned (_tmp64_);
								_tmp66_ = _tmp65_;
								if (!_tmp66_) {
									ValaSourceReference* _tmp67_;
									ValaSourceReference* _tmp68_;
									gchar* _tmp69_;
									gchar* _tmp70_;
									_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
									_tmp68_ = _tmp67_;
									_tmp69_ = g_strdup_printf ("Argument %d: Cannot pass owned ref argument to unowned reference param" \
"eter", i + 1);
									_tmp70_ = _tmp69_;
									vala_report_error (_tmp68_, _tmp70_);
									_g_free0 (_tmp70_);
									result = FALSE;
									return result;
								}
							}
						} else {
							gint _tmp71_;
							_tmp71_ = arg_type;
							if (_tmp71_ == 3) {
								ValaDataType* _tmp76_;
								ValaDataType* _tmp77_;
								if (direction != VALA_PARAMETER_DIRECTION_OUT) {
									ValaSourceReference* _tmp72_;
									ValaSourceReference* _tmp73_;
									gchar* _tmp74_;
									gchar* _tmp75_;
									_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
									_tmp73_ = _tmp72_;
									_tmp74_ = g_strdup_printf ("Argument %d: Cannot pass out argument to non-output parameter", i + 1);
									_tmp75_ = _tmp74_;
									vala_report_error (_tmp73_, _tmp75_);
									_g_free0 (_tmp75_);
									result = FALSE;
									return result;
								}
								_tmp76_ = vala_expression_get_target_type (arg);
								_tmp77_ = _tmp76_;
								if (vala_data_type_is_disposable (_tmp77_)) {
									gboolean _tmp78_ = FALSE;
									ValaDataType* _tmp79_;
									ValaDataType* _tmp80_;
									_tmp79_ = vala_expression_get_value_type (arg);
									_tmp80_ = _tmp79_;
									if (!VALA_IS_POINTER_TYPE (_tmp80_)) {
										ValaDataType* _tmp81_;
										ValaDataType* _tmp82_;
										gboolean _tmp83_;
										gboolean _tmp84_;
										_tmp81_ = vala_expression_get_value_type (arg);
										_tmp82_ = _tmp81_;
										_tmp83_ = vala_data_type_get_value_owned (_tmp82_);
										_tmp84_ = _tmp83_;
										_tmp78_ = !_tmp84_;
									} else {
										_tmp78_ = FALSE;
									}
									if (_tmp78_) {
										ValaSourceReference* _tmp85_;
										ValaSourceReference* _tmp86_;
										_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
										_tmp86_ = _tmp85_;
										vala_report_error (_tmp86_, "Invalid assignment from owned expression to unowned variable");
										result = FALSE;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp87_ = vala_expression_get_target_type (arg);
	_tmp88_ = _tmp87_;
	if (_tmp88_ != NULL) {
		gboolean _tmp89_ = FALSE;
		gboolean _tmp90_ = FALSE;
		if (direction == VALA_PARAMETER_DIRECTION_IN) {
			_tmp90_ = TRUE;
		} else {
			_tmp90_ = direction == VALA_PARAMETER_DIRECTION_REF;
		}
		if (_tmp90_) {
			ValaDataType* _tmp91_;
			ValaDataType* _tmp92_;
			ValaDataType* _tmp93_;
			ValaDataType* _tmp94_;
			_tmp91_ = vala_expression_get_value_type (arg);
			_tmp92_ = _tmp91_;
			_tmp93_ = vala_expression_get_target_type (arg);
			_tmp94_ = _tmp93_;
			_tmp89_ = !vala_data_type_compatible (_tmp92_, _tmp94_);
		} else {
			_tmp89_ = FALSE;
		}
		if (_tmp89_) {
			ValaSourceReference* _tmp95_;
			ValaSourceReference* _tmp96_;
			ValaDataType* _tmp97_;
			ValaDataType* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			ValaDataType* _tmp101_;
			ValaDataType* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			_tmp95_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
			_tmp96_ = _tmp95_;
			_tmp97_ = vala_expression_get_value_type (arg);
			_tmp98_ = _tmp97_;
			_tmp99_ = vala_data_type_to_prototype_string (_tmp98_, NULL);
			_tmp100_ = _tmp99_;
			_tmp101_ = vala_expression_get_target_type (arg);
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_data_type_to_prototype_string (_tmp102_, NULL);
			_tmp104_ = _tmp103_;
			_tmp105_ = g_strdup_printf ("Argument %d: Cannot convert from `%s' to `%s'", i + 1, _tmp100_, _tmp104_);
			_tmp106_ = _tmp105_;
			vala_report_error (_tmp96_, _tmp106_);
			_g_free0 (_tmp106_);
			_g_free0 (_tmp104_);
			_g_free0 (_tmp100_);
			result = FALSE;
			return result;
		} else {
			gboolean _tmp107_ = FALSE;
			gboolean _tmp108_ = FALSE;
			gboolean _tmp109_ = FALSE;
			if (direction == VALA_PARAMETER_DIRECTION_REF) {
				_tmp109_ = TRUE;
			} else {
				_tmp109_ = direction == VALA_PARAMETER_DIRECTION_OUT;
			}
			if (_tmp109_) {
				ValaDataType* _tmp110_;
				ValaDataType* _tmp111_;
				ValaDataType* _tmp112_;
				ValaDataType* _tmp113_;
				_tmp110_ = vala_expression_get_target_type (arg);
				_tmp111_ = _tmp110_;
				_tmp112_ = vala_expression_get_value_type (arg);
				_tmp113_ = _tmp112_;
				_tmp108_ = !vala_data_type_compatible (_tmp111_, _tmp113_);
			} else {
				_tmp108_ = FALSE;
			}
			if (_tmp108_) {
				_tmp107_ = !VALA_IS_NULL_LITERAL (arg);
			} else {
				_tmp107_ = FALSE;
			}
			if (_tmp107_) {
				ValaSourceReference* _tmp114_;
				ValaSourceReference* _tmp115_;
				ValaDataType* _tmp116_;
				ValaDataType* _tmp117_;
				gchar* _tmp118_;
				gchar* _tmp119_;
				ValaDataType* _tmp120_;
				ValaDataType* _tmp121_;
				gchar* _tmp122_;
				gchar* _tmp123_;
				gchar* _tmp124_;
				gchar* _tmp125_;
				_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_expression_get_target_type (arg);
				_tmp117_ = _tmp116_;
				_tmp118_ = vala_data_type_to_prototype_string (_tmp117_, NULL);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_expression_get_value_type (arg);
				_tmp121_ = _tmp120_;
				_tmp122_ = vala_data_type_to_prototype_string (_tmp121_, NULL);
				_tmp123_ = _tmp122_;
				_tmp124_ = g_strdup_printf ("Argument %d: Cannot convert from `%s' to `%s'", i + 1, _tmp119_, _tmp123_);
				_tmp125_ = _tmp124_;
				vala_report_error (_tmp115_, _tmp125_);
				_g_free0 (_tmp125_);
				_g_free0 (_tmp123_);
				_g_free0 (_tmp119_);
				result = FALSE;
				return result;
			}
		}
	}
	_tmp126_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (arg) ? ((ValaMemberAccess*) arg) : NULL);
	ma = _tmp126_;
	_tmp128_ = ma;
	if (_tmp128_ != NULL) {
		ValaMemberAccess* _tmp129_;
		gboolean _tmp130_;
		gboolean _tmp131_;
		_tmp129_ = ma;
		_tmp130_ = vala_member_access_get_prototype_access (_tmp129_);
		_tmp131_ = _tmp130_;
		_tmp127_ = _tmp131_;
	} else {
		_tmp127_ = FALSE;
	}
	if (_tmp127_) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp132_;
		ValaDataType* _tmp133_;
		ValaDelegateType* _tmp134_;
		gboolean _tmp135_ = FALSE;
		ValaDelegateType* _tmp136_;
		_tmp132_ = vala_expression_get_target_type (arg);
		_tmp133_ = _tmp132_;
		_tmp134_ = _vala_code_node_ref0 (VALA_IS_DELEGATE_TYPE (_tmp133_) ? ((ValaDelegateType*) _tmp133_) : NULL);
		deleg_type = _tmp134_;
		_tmp136_ = deleg_type;
		if (_tmp136_ == NULL) {
			_tmp135_ = TRUE;
		} else {
			ValaDelegateType* _tmp137_;
			ValaDelegate* _tmp138_;
			ValaDelegate* _tmp139_;
			gboolean _tmp140_;
			gboolean _tmp141_;
			_tmp137_ = deleg_type;
			_tmp138_ = vala_delegate_type_get_delegate_symbol (_tmp137_);
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_delegate_get_has_target (_tmp139_);
			_tmp141_ = _tmp140_;
			_tmp135_ = _tmp141_;
		}
		if (_tmp135_) {
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			ValaSymbol* _tmp144_;
			ValaSymbol* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			gchar* _tmp149_;
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) arg);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_expression_get_symbol_reference (arg);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_symbol_get_full_name (_tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp147_);
			_tmp149_ = _tmp148_;
			vala_report_error (_tmp143_, _tmp149_);
			_g_free0 (_tmp149_);
			_g_free0 (_tmp147_);
			result = FALSE;
			_vala_code_node_unref0 (deleg_type);
			_vala_code_node_unref0 (ma);
			return result;
		}
		_vala_code_node_unref0 (deleg_type);
	}
	result = TRUE;
	_vala_code_node_unref0 (ma);
	return result;
}


gboolean
vala_semantic_analyzer_check_variadic_arguments (ValaSemanticAnalyzer* self,
                                                 ValaIterator* arg_it,
                                                 gint i,
                                                 ValaSourceReference* source_reference)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source_reference != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		ValaExpression* arg = NULL;
		gpointer _tmp1_;
		ValaExpression* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gint _tmp45_;
		if (arg_it != NULL) {
			_tmp0_ = vala_iterator_next (arg_it);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp1_ = vala_iterator_get (arg_it);
		arg = (ValaExpression*) _tmp1_;
		_tmp2_ = arg;
		_tmp3_ = vala_code_node_get_error ((ValaCodeNode*) _tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			result = FALSE;
			_vala_code_node_unref0 (arg);
			return result;
		} else {
			ValaExpression* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			_tmp5_ = arg;
			_tmp6_ = vala_expression_get_value_type (_tmp5_);
			_tmp7_ = _tmp6_;
			if (VALA_IS_SIGNAL_TYPE (_tmp7_)) {
				ValaExpression* _tmp8_;
				ValaExpression* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaSourceReference* _tmp11_;
				_tmp8_ = arg;
				vala_code_node_set_error ((ValaCodeNode*) _tmp8_, TRUE);
				_tmp9_ = arg;
				_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp9_);
				_tmp11_ = _tmp10_;
				vala_report_error (_tmp11_, "Cannot pass signals as arguments");
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			} else {
				ValaExpression* _tmp12_;
				ValaDataType* _tmp13_;
				ValaDataType* _tmp14_;
				_tmp12_ = arg;
				_tmp13_ = vala_expression_get_value_type (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == NULL) {
					ValaExpression* _tmp15_;
					ValaSymbol* _tmp16_;
					ValaSymbol* _tmp17_;
					_tmp15_ = arg;
					_tmp16_ = vala_expression_get_symbol_reference (_tmp15_);
					_tmp17_ = _tmp16_;
					if (!VALA_IS_METHOD (_tmp17_)) {
						gchar* _tmp18_;
						gchar* _tmp19_;
						_tmp18_ = g_strdup_printf ("Invalid type for argument %d", i + 1);
						_tmp19_ = _tmp18_;
						vala_report_error (source_reference, _tmp19_);
						_g_free0 (_tmp19_);
						result = FALSE;
						_vala_code_node_unref0 (arg);
						return result;
					}
				} else {
					gboolean _tmp20_ = FALSE;
					ValaExpression* _tmp21_;
					ValaDataType* _tmp22_;
					ValaDataType* _tmp23_;
					_tmp21_ = arg;
					_tmp22_ = vala_expression_get_target_type (_tmp21_);
					_tmp23_ = _tmp22_;
					if (_tmp23_ != NULL) {
						ValaExpression* _tmp24_;
						ValaDataType* _tmp25_;
						ValaDataType* _tmp26_;
						ValaExpression* _tmp27_;
						ValaDataType* _tmp28_;
						ValaDataType* _tmp29_;
						_tmp24_ = arg;
						_tmp25_ = vala_expression_get_value_type (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = arg;
						_tmp28_ = vala_expression_get_target_type (_tmp27_);
						_tmp29_ = _tmp28_;
						_tmp20_ = !vala_data_type_compatible (_tmp26_, _tmp29_);
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						ValaExpression* _tmp30_;
						ValaSourceReference* _tmp31_;
						ValaSourceReference* _tmp32_;
						ValaExpression* _tmp33_;
						ValaDataType* _tmp34_;
						ValaDataType* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						ValaExpression* _tmp38_;
						ValaDataType* _tmp39_;
						ValaDataType* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						_tmp30_ = arg;
						_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = arg;
						_tmp34_ = vala_expression_get_value_type (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = vala_code_node_to_string ((ValaCodeNode*) _tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = arg;
						_tmp39_ = vala_expression_get_target_type (_tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = vala_code_node_to_string ((ValaCodeNode*) _tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = g_strdup_printf ("Argument %d: Cannot convert from `%s' to `%s'", i + 1, _tmp37_, _tmp42_);
						_tmp44_ = _tmp43_;
						vala_report_error (_tmp32_, _tmp44_);
						_g_free0 (_tmp44_);
						_g_free0 (_tmp42_);
						_g_free0 (_tmp37_);
						result = FALSE;
						_vala_code_node_unref0 (arg);
						return result;
					}
				}
			}
		}
		_tmp45_ = i;
		i = _tmp45_ + 1;
		_vala_code_node_unref0 (arg);
	}
	result = TRUE;
	return result;
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


gboolean
vala_semantic_analyzer_check_print_format (ValaSemanticAnalyzer* self,
                                           const gchar* format,
                                           ValaIterator* arg_it,
                                           ValaSourceReference* source_reference)
{
	gboolean result = FALSE;
	gboolean unsupported_format = FALSE;
	const gchar* format_it = NULL;
	gunichar c = 0U;
	const gchar* _tmp0_;
	gboolean _tmp128_ = FALSE;
	gboolean _tmp129_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (format != NULL, FALSE);
	g_return_val_if_fail (arg_it != NULL, FALSE);
	g_return_val_if_fail (source_reference != NULL, FALSE);
	unsupported_format = FALSE;
	format_it = format;
	_tmp0_ = format_it;
	c = string_get_char (_tmp0_, (glong) 0);
	while (TRUE) {
		gunichar _tmp1_;
		gunichar _tmp2_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gunichar _tmp27_;
		gint length = 0;
		gunichar _tmp37_;
		ValaDataType* param_type = NULL;
		gboolean _tmp53_ = FALSE;
		gboolean _tmp54_ = FALSE;
		gunichar _tmp55_;
		gunichar _tmp120_;
		ValaDataType* _tmp124_;
		_tmp1_ = c;
		if (!(_tmp1_ != ((gunichar) '\0'))) {
			break;
		}
		_tmp2_ = c;
		if (_tmp2_ != ((gunichar) '%')) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp3_ = format_it;
			_tmp4_ = g_utf8_next_char (_tmp3_);
			format_it = _tmp4_;
			_tmp5_ = format_it;
			c = string_get_char (_tmp5_, (glong) 0);
			continue;
		}
		_tmp6_ = format_it;
		_tmp7_ = g_utf8_next_char (_tmp6_);
		format_it = _tmp7_;
		_tmp8_ = format_it;
		c = string_get_char (_tmp8_, (glong) 0);
		while (TRUE) {
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gunichar _tmp13_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp13_ = c;
			if (_tmp13_ == ((gunichar) '#')) {
				_tmp12_ = TRUE;
			} else {
				gunichar _tmp14_;
				_tmp14_ = c;
				_tmp12_ = _tmp14_ == ((gunichar) '0');
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				gunichar _tmp15_;
				_tmp15_ = c;
				_tmp11_ = _tmp15_ == ((gunichar) '-');
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				gunichar _tmp16_;
				_tmp16_ = c;
				_tmp10_ = _tmp16_ == ((gunichar) ' ');
			}
			if (_tmp10_) {
				_tmp9_ = TRUE;
			} else {
				gunichar _tmp17_;
				_tmp17_ = c;
				_tmp9_ = _tmp17_ == ((gunichar) '+');
			}
			if (!_tmp9_) {
				break;
			}
			_tmp18_ = format_it;
			_tmp19_ = g_utf8_next_char (_tmp18_);
			format_it = _tmp19_;
			_tmp20_ = format_it;
			c = string_get_char (_tmp20_, (glong) 0);
		}
		while (TRUE) {
			gboolean _tmp21_ = FALSE;
			gunichar _tmp22_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			_tmp22_ = c;
			if (_tmp22_ >= ((gunichar) '0')) {
				gunichar _tmp23_;
				_tmp23_ = c;
				_tmp21_ = _tmp23_ <= ((gunichar) '9');
			} else {
				_tmp21_ = FALSE;
			}
			if (!_tmp21_) {
				break;
			}
			_tmp24_ = format_it;
			_tmp25_ = g_utf8_next_char (_tmp24_);
			format_it = _tmp25_;
			_tmp26_ = format_it;
			c = string_get_char (_tmp26_, (glong) 0);
		}
		_tmp27_ = c;
		if (_tmp27_ == ((gunichar) '.')) {
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			_tmp28_ = format_it;
			_tmp29_ = g_utf8_next_char (_tmp28_);
			format_it = _tmp29_;
			_tmp30_ = format_it;
			c = string_get_char (_tmp30_, (glong) 0);
			while (TRUE) {
				gboolean _tmp31_ = FALSE;
				gunichar _tmp32_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp32_ = c;
				if (_tmp32_ >= ((gunichar) '0')) {
					gunichar _tmp33_;
					_tmp33_ = c;
					_tmp31_ = _tmp33_ <= ((gunichar) '9');
				} else {
					_tmp31_ = FALSE;
				}
				if (!_tmp31_) {
					break;
				}
				_tmp34_ = format_it;
				_tmp35_ = g_utf8_next_char (_tmp34_);
				format_it = _tmp35_;
				_tmp36_ = format_it;
				c = string_get_char (_tmp36_, (glong) 0);
			}
		}
		length = 0;
		_tmp37_ = c;
		if (_tmp37_ == ((gunichar) 'h')) {
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gunichar _tmp41_;
			length = -1;
			_tmp38_ = format_it;
			_tmp39_ = g_utf8_next_char (_tmp38_);
			format_it = _tmp39_;
			_tmp40_ = format_it;
			c = string_get_char (_tmp40_, (glong) 0);
			_tmp41_ = c;
			if (_tmp41_ == ((gunichar) 'h')) {
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				length = -2;
				_tmp42_ = format_it;
				_tmp43_ = g_utf8_next_char (_tmp42_);
				format_it = _tmp43_;
				_tmp44_ = format_it;
				c = string_get_char (_tmp44_, (glong) 0);
			}
		} else {
			gunichar _tmp45_;
			_tmp45_ = c;
			if (_tmp45_ == ((gunichar) 'l')) {
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				length = 1;
				_tmp46_ = format_it;
				_tmp47_ = g_utf8_next_char (_tmp46_);
				format_it = _tmp47_;
				_tmp48_ = format_it;
				c = string_get_char (_tmp48_, (glong) 0);
			} else {
				gunichar _tmp49_;
				_tmp49_ = c;
				if (_tmp49_ == ((gunichar) 'z')) {
					const gchar* _tmp50_;
					const gchar* _tmp51_;
					const gchar* _tmp52_;
					length = 2;
					_tmp50_ = format_it;
					_tmp51_ = g_utf8_next_char (_tmp50_);
					format_it = _tmp51_;
					_tmp52_ = format_it;
					c = string_get_char (_tmp52_, (glong) 0);
				}
			}
		}
		param_type = NULL;
		_tmp55_ = c;
		if (_tmp55_ == ((gunichar) 'd')) {
			_tmp54_ = TRUE;
		} else {
			gunichar _tmp56_;
			_tmp56_ = c;
			_tmp54_ = _tmp56_ == ((gunichar) 'i');
		}
		if (_tmp54_) {
			_tmp53_ = TRUE;
		} else {
			gunichar _tmp57_;
			_tmp57_ = c;
			_tmp53_ = _tmp57_ == ((gunichar) 'c');
		}
		if (_tmp53_) {
			gint _tmp58_;
			_tmp58_ = length;
			if (_tmp58_ == -2) {
				ValaDataType* _tmp59_;
				ValaDataType* _tmp60_;
				_tmp59_ = self->int8_type;
				_tmp60_ = _vala_code_node_ref0 (_tmp59_);
				_vala_code_node_unref0 (param_type);
				param_type = _tmp60_;
			} else {
				gint _tmp61_;
				_tmp61_ = length;
				if (_tmp61_ == -1) {
					ValaDataType* _tmp62_;
					ValaDataType* _tmp63_;
					_tmp62_ = self->short_type;
					_tmp63_ = _vala_code_node_ref0 (_tmp62_);
					_vala_code_node_unref0 (param_type);
					param_type = _tmp63_;
				} else {
					gint _tmp64_;
					_tmp64_ = length;
					if (_tmp64_ == 0) {
						ValaDataType* _tmp65_;
						ValaDataType* _tmp66_;
						_tmp65_ = self->int_type;
						_tmp66_ = _vala_code_node_ref0 (_tmp65_);
						_vala_code_node_unref0 (param_type);
						param_type = _tmp66_;
					} else {
						gint _tmp67_;
						_tmp67_ = length;
						if (_tmp67_ == 1) {
							ValaDataType* _tmp68_;
							ValaDataType* _tmp69_;
							_tmp68_ = self->long_type;
							_tmp69_ = _vala_code_node_ref0 (_tmp68_);
							_vala_code_node_unref0 (param_type);
							param_type = _tmp69_;
						} else {
							gint _tmp70_;
							_tmp70_ = length;
							if (_tmp70_ == 2) {
								ValaDataType* _tmp71_;
								ValaDataType* _tmp72_;
								_tmp71_ = self->ssize_t_type;
								_tmp72_ = _vala_code_node_ref0 (_tmp71_);
								_vala_code_node_unref0 (param_type);
								param_type = _tmp72_;
							}
						}
					}
				}
			}
		} else {
			gboolean _tmp73_ = FALSE;
			gboolean _tmp74_ = FALSE;
			gboolean _tmp75_ = FALSE;
			gunichar _tmp76_;
			_tmp76_ = c;
			if (_tmp76_ == ((gunichar) 'o')) {
				_tmp75_ = TRUE;
			} else {
				gunichar _tmp77_;
				_tmp77_ = c;
				_tmp75_ = _tmp77_ == ((gunichar) 'u');
			}
			if (_tmp75_) {
				_tmp74_ = TRUE;
			} else {
				gunichar _tmp78_;
				_tmp78_ = c;
				_tmp74_ = _tmp78_ == ((gunichar) 'x');
			}
			if (_tmp74_) {
				_tmp73_ = TRUE;
			} else {
				gunichar _tmp79_;
				_tmp79_ = c;
				_tmp73_ = _tmp79_ == ((gunichar) 'X');
			}
			if (_tmp73_) {
				gint _tmp80_;
				_tmp80_ = length;
				if (_tmp80_ == -2) {
					ValaDataType* _tmp81_;
					ValaDataType* _tmp82_;
					_tmp81_ = self->uchar_type;
					_tmp82_ = _vala_code_node_ref0 (_tmp81_);
					_vala_code_node_unref0 (param_type);
					param_type = _tmp82_;
				} else {
					gint _tmp83_;
					_tmp83_ = length;
					if (_tmp83_ == -1) {
						ValaDataType* _tmp84_;
						ValaDataType* _tmp85_;
						_tmp84_ = self->ushort_type;
						_tmp85_ = _vala_code_node_ref0 (_tmp84_);
						_vala_code_node_unref0 (param_type);
						param_type = _tmp85_;
					} else {
						gint _tmp86_;
						_tmp86_ = length;
						if (_tmp86_ == 0) {
							ValaDataType* _tmp87_;
							ValaDataType* _tmp88_;
							_tmp87_ = self->uint_type;
							_tmp88_ = _vala_code_node_ref0 (_tmp87_);
							_vala_code_node_unref0 (param_type);
							param_type = _tmp88_;
						} else {
							gint _tmp89_;
							_tmp89_ = length;
							if (_tmp89_ == 1) {
								ValaDataType* _tmp90_;
								ValaDataType* _tmp91_;
								_tmp90_ = self->ulong_type;
								_tmp91_ = _vala_code_node_ref0 (_tmp90_);
								_vala_code_node_unref0 (param_type);
								param_type = _tmp91_;
							} else {
								gint _tmp92_;
								_tmp92_ = length;
								if (_tmp92_ == 2) {
									ValaDataType* _tmp93_;
									ValaDataType* _tmp94_;
									_tmp93_ = self->size_t_type;
									_tmp94_ = _vala_code_node_ref0 (_tmp93_);
									_vala_code_node_unref0 (param_type);
									param_type = _tmp94_;
								}
							}
						}
					}
				}
			} else {
				gboolean _tmp95_ = FALSE;
				gboolean _tmp96_ = FALSE;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				gboolean _tmp99_ = FALSE;
				gboolean _tmp100_ = FALSE;
				gboolean _tmp101_ = FALSE;
				gunichar _tmp102_;
				_tmp102_ = c;
				if (_tmp102_ == ((gunichar) 'e')) {
					_tmp101_ = TRUE;
				} else {
					gunichar _tmp103_;
					_tmp103_ = c;
					_tmp101_ = _tmp103_ == ((gunichar) 'E');
				}
				if (_tmp101_) {
					_tmp100_ = TRUE;
				} else {
					gunichar _tmp104_;
					_tmp104_ = c;
					_tmp100_ = _tmp104_ == ((gunichar) 'f');
				}
				if (_tmp100_) {
					_tmp99_ = TRUE;
				} else {
					gunichar _tmp105_;
					_tmp105_ = c;
					_tmp99_ = _tmp105_ == ((gunichar) 'F');
				}
				if (_tmp99_) {
					_tmp98_ = TRUE;
				} else {
					gunichar _tmp106_;
					_tmp106_ = c;
					_tmp98_ = _tmp106_ == ((gunichar) 'g');
				}
				if (_tmp98_) {
					_tmp97_ = TRUE;
				} else {
					gunichar _tmp107_;
					_tmp107_ = c;
					_tmp97_ = _tmp107_ == ((gunichar) 'G');
				}
				if (_tmp97_) {
					_tmp96_ = TRUE;
				} else {
					gunichar _tmp108_;
					_tmp108_ = c;
					_tmp96_ = _tmp108_ == ((gunichar) 'a');
				}
				if (_tmp96_) {
					_tmp95_ = TRUE;
				} else {
					gunichar _tmp109_;
					_tmp109_ = c;
					_tmp95_ = _tmp109_ == ((gunichar) 'A');
				}
				if (_tmp95_) {
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					_tmp110_ = self->double_type;
					_tmp111_ = _vala_code_node_ref0 (_tmp110_);
					_vala_code_node_unref0 (param_type);
					param_type = _tmp111_;
				} else {
					gunichar _tmp112_;
					_tmp112_ = c;
					if (_tmp112_ == ((gunichar) 's')) {
						ValaDataType* _tmp113_;
						ValaDataType* _tmp114_;
						_tmp113_ = self->string_type;
						_tmp114_ = _vala_code_node_ref0 (_tmp113_);
						_vala_code_node_unref0 (param_type);
						param_type = _tmp114_;
					} else {
						gunichar _tmp115_;
						_tmp115_ = c;
						if (_tmp115_ == ((gunichar) 'p')) {
							ValaVoidType* _tmp116_;
							ValaVoidType* _tmp117_;
							ValaPointerType* _tmp118_;
							_tmp116_ = vala_void_type_new (NULL);
							_tmp117_ = _tmp116_;
							_tmp118_ = vala_pointer_type_new ((ValaDataType*) _tmp117_, NULL);
							_vala_code_node_unref0 (param_type);
							param_type = (ValaDataType*) _tmp118_;
							_vala_code_node_unref0 (_tmp117_);
						} else {
							gunichar _tmp119_;
							_tmp119_ = c;
							if (_tmp119_ == ((gunichar) '%')) {
							} else {
								unsupported_format = TRUE;
								_vala_code_node_unref0 (param_type);
								break;
							}
						}
					}
				}
			}
		}
		_tmp120_ = c;
		if (_tmp120_ != ((gunichar) '\0')) {
			const gchar* _tmp121_;
			const gchar* _tmp122_;
			const gchar* _tmp123_;
			_tmp121_ = format_it;
			_tmp122_ = g_utf8_next_char (_tmp121_);
			format_it = _tmp122_;
			_tmp123_ = format_it;
			c = string_get_char (_tmp123_, (glong) 0);
		}
		_tmp124_ = param_type;
		if (_tmp124_ != NULL) {
			if (vala_iterator_next (arg_it)) {
				ValaExpression* arg = NULL;
				gpointer _tmp125_;
				ValaExpression* _tmp126_;
				ValaDataType* _tmp127_;
				_tmp125_ = vala_iterator_get (arg_it);
				arg = (ValaExpression*) _tmp125_;
				_tmp126_ = arg;
				_tmp127_ = param_type;
				vala_expression_set_target_type (_tmp126_, _tmp127_);
				_vala_code_node_unref0 (arg);
			} else {
				vala_report_error (source_reference, "Too few arguments for specified format");
				result = FALSE;
				_vala_code_node_unref0 (param_type);
				return result;
			}
		}
		_vala_code_node_unref0 (param_type);
	}
	_tmp129_ = unsupported_format;
	if (!_tmp129_) {
		_tmp128_ = vala_iterator_next (arg_it);
	} else {
		_tmp128_ = FALSE;
	}
	if (_tmp128_) {
		vala_report_error (source_reference, "Too many arguments for specified format");
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static ValaDataType*
vala_semantic_analyzer_get_instance_base_type (ValaDataType* instance_type,
                                               ValaDataType* base_type,
                                               ValaCodeNode* node_reference)
{
	ValaDataType* result = NULL;
	ValaDataType* instance_base_type = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	g_return_val_if_fail (instance_type != NULL, NULL);
	g_return_val_if_fail (base_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_data_type_get_data_type (base_type);
	_tmp1_ = _tmp0_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1_)) {
		ValaTypeSymbol* _tmp2_;
		ValaTypeSymbol* _tmp3_;
		ValaObjectType* _tmp4_;
		_tmp2_ = vala_data_type_get_data_type (base_type);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (instance_base_type);
		instance_base_type = (ValaDataType*) _tmp4_;
	} else {
		ValaTypeSymbol* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		_tmp5_ = vala_data_type_get_data_type (base_type);
		_tmp6_ = _tmp5_;
		if (VALA_IS_STRUCT (_tmp6_)) {
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaStructValueType* _tmp9_;
			_tmp7_ = vala_data_type_get_data_type (base_type);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct));
			_vala_code_node_unref0 (instance_base_type);
			instance_base_type = (ValaDataType*) _tmp9_;
		} else {
			g_assert_not_reached ();
		}
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp10_;
		gint _type_arg_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _type_arg_index = 0;
		_tmp10_ = vala_data_type_get_type_arguments (base_type);
		_type_arg_list = _tmp10_;
		_tmp11_ = _type_arg_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_type_arg_size = _tmp13_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp21_;
			ValaDataType* _tmp22_;
			ValaDataType* _tmp23_;
			_tmp14_ = _type_arg_index;
			_type_arg_index = _tmp14_ + 1;
			_tmp15_ = _type_arg_index;
			_tmp16_ = _type_arg_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _type_arg_list;
			_tmp18_ = _type_arg_index;
			_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
			type_arg = (ValaDataType*) _tmp19_;
			_tmp20_ = type_arg;
			_tmp21_ = vala_data_type_get_actual_type (_tmp20_, instance_type, NULL, node_reference);
			_vala_code_node_unref0 (type_arg);
			type_arg = _tmp21_;
			_tmp22_ = instance_base_type;
			_tmp23_ = type_arg;
			vala_data_type_add_type_argument (_tmp22_, _tmp23_);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	result = instance_base_type;
	return result;
}


G_GNUC_INTERNAL ValaDataType*
vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type,
                                                          ValaTypeSymbol* type_symbol,
                                                          ValaCodeNode* node_reference)
{
	ValaDataType* result = NULL;
	ValaDataType* instance_type = NULL;
	ValaDataType* _tmp0_;
	gboolean _tmp8_ = FALSE;
	ValaDataType* _tmp9_;
	ValaDataType* instance_base_type = NULL;
	ValaDataType* _tmp16_;
	ValaTypeSymbol* _tmp17_;
	ValaTypeSymbol* _tmp18_;
	g_return_val_if_fail (derived_instance_type != NULL, NULL);
	g_return_val_if_fail (type_symbol != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = _vala_code_node_ref0 (derived_instance_type);
	instance_type = _tmp0_;
	while (TRUE) {
		ValaDataType* _tmp1_;
		ValaPointerType* instance_pointer_type = NULL;
		ValaDataType* _tmp2_;
		ValaPointerType* _tmp3_;
		ValaPointerType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp1_ = instance_type;
		if (!VALA_IS_POINTER_TYPE (_tmp1_)) {
			break;
		}
		_tmp2_ = instance_type;
		_tmp3_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
		instance_pointer_type = _tmp3_;
		_tmp4_ = instance_pointer_type;
		_tmp5_ = vala_pointer_type_get_base_type (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _vala_code_node_ref0 (_tmp6_);
		_vala_code_node_unref0 (instance_type);
		instance_type = _tmp7_;
		_vala_code_node_unref0 (instance_pointer_type);
	}
	_tmp9_ = instance_type;
	if (VALA_IS_DELEGATE_TYPE (_tmp9_)) {
		ValaDataType* _tmp10_;
		ValaDelegate* _tmp11_;
		ValaDelegate* _tmp12_;
		_tmp10_ = instance_type;
		_tmp11_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		_tmp12_ = _tmp11_;
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == type_symbol;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		result = instance_type;
		return result;
	} else {
		ValaDataType* _tmp13_;
		ValaTypeSymbol* _tmp14_;
		ValaTypeSymbol* _tmp15_;
		_tmp13_ = instance_type;
		_tmp14_ = vala_data_type_get_data_type (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == type_symbol) {
			result = instance_type;
			return result;
		}
	}
	instance_base_type = NULL;
	_tmp16_ = instance_type;
	_tmp17_ = vala_data_type_get_data_type (_tmp16_);
	_tmp18_ = _tmp17_;
	if (VALA_IS_CLASS (_tmp18_)) {
		ValaClass* cl = NULL;
		ValaDataType* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaTypeSymbol* _tmp21_;
		ValaClass* _tmp22_;
		ValaDataType* _tmp43_;
		_tmp19_ = instance_type;
		_tmp20_ = vala_data_type_get_data_type (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp22_;
		{
			ValaList* _base_type_list = NULL;
			ValaClass* _tmp23_;
			ValaList* _tmp24_;
			gint _base_type_size = 0;
			ValaList* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _base_type_index = 0;
			_tmp23_ = cl;
			_tmp24_ = vala_class_get_base_types (_tmp23_);
			_base_type_list = _tmp24_;
			_tmp25_ = _base_type_list;
			_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
			_tmp27_ = _tmp26_;
			_base_type_size = _tmp27_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp31_;
				gint _tmp32_;
				gpointer _tmp33_;
				ValaDataType* _tmp34_;
				ValaTypeSymbol* _tmp35_;
				ValaTypeSymbol* _tmp36_;
				_tmp28_ = _base_type_index;
				_base_type_index = _tmp28_ + 1;
				_tmp29_ = _base_type_index;
				_tmp30_ = _base_type_size;
				if (!(_tmp29_ < _tmp30_)) {
					break;
				}
				_tmp31_ = _base_type_list;
				_tmp32_ = _base_type_index;
				_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
				base_type = (ValaDataType*) _tmp33_;
				_tmp34_ = base_type;
				_tmp35_ = vala_data_type_get_data_type (_tmp34_);
				_tmp36_ = _tmp35_;
				if (VALA_IS_INTERFACE (_tmp36_)) {
					ValaDataType* _tmp37_;
					ValaDataType* _tmp38_;
					ValaDataType* _tmp39_;
					ValaDataType* _tmp40_;
					ValaDataType* _tmp41_;
					ValaDataType* _tmp42_;
					_tmp37_ = instance_type;
					_tmp38_ = base_type;
					_tmp39_ = vala_semantic_analyzer_get_instance_base_type (_tmp37_, _tmp38_, node_reference);
					_tmp40_ = _tmp39_;
					_tmp41_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp40_, type_symbol, node_reference);
					_vala_code_node_unref0 (instance_base_type);
					instance_base_type = _tmp41_;
					_vala_code_node_unref0 (_tmp40_);
					_tmp42_ = instance_base_type;
					if (_tmp42_ != NULL) {
						result = instance_base_type;
						_vala_code_node_unref0 (base_type);
						_vala_iterable_unref0 (_base_type_list);
						_vala_code_node_unref0 (cl);
						_vala_code_node_unref0 (instance_type);
						return result;
					}
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp43_ = instance_base_type;
		if (_tmp43_ == NULL) {
			{
				ValaList* _base_type_list = NULL;
				ValaClass* _tmp44_;
				ValaList* _tmp45_;
				gint _base_type_size = 0;
				ValaList* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gint _base_type_index = 0;
				_tmp44_ = cl;
				_tmp45_ = vala_class_get_base_types (_tmp44_);
				_base_type_list = _tmp45_;
				_tmp46_ = _base_type_list;
				_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
				_tmp48_ = _tmp47_;
				_base_type_size = _tmp48_;
				_base_type_index = -1;
				while (TRUE) {
					gint _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
					ValaDataType* base_type = NULL;
					ValaList* _tmp52_;
					gint _tmp53_;
					gpointer _tmp54_;
					ValaDataType* _tmp55_;
					ValaTypeSymbol* _tmp56_;
					ValaTypeSymbol* _tmp57_;
					_tmp49_ = _base_type_index;
					_base_type_index = _tmp49_ + 1;
					_tmp50_ = _base_type_index;
					_tmp51_ = _base_type_size;
					if (!(_tmp50_ < _tmp51_)) {
						break;
					}
					_tmp52_ = _base_type_list;
					_tmp53_ = _base_type_index;
					_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
					base_type = (ValaDataType*) _tmp54_;
					_tmp55_ = base_type;
					_tmp56_ = vala_data_type_get_data_type (_tmp55_);
					_tmp57_ = _tmp56_;
					if (VALA_IS_CLASS (_tmp57_)) {
						ValaDataType* _tmp58_;
						ValaDataType* _tmp59_;
						ValaDataType* _tmp60_;
						ValaDataType* _tmp61_;
						ValaDataType* _tmp62_;
						ValaDataType* _tmp63_;
						_tmp58_ = instance_type;
						_tmp59_ = base_type;
						_tmp60_ = vala_semantic_analyzer_get_instance_base_type (_tmp58_, _tmp59_, node_reference);
						_tmp61_ = _tmp60_;
						_tmp62_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp61_, type_symbol, node_reference);
						_vala_code_node_unref0 (instance_base_type);
						instance_base_type = _tmp62_;
						_vala_code_node_unref0 (_tmp61_);
						_tmp63_ = instance_base_type;
						if (_tmp63_ != NULL) {
							result = instance_base_type;
							_vala_code_node_unref0 (base_type);
							_vala_iterable_unref0 (_base_type_list);
							_vala_code_node_unref0 (cl);
							_vala_code_node_unref0 (instance_type);
							return result;
						}
					}
					_vala_code_node_unref0 (base_type);
				}
				_vala_iterable_unref0 (_base_type_list);
			}
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaDataType* _tmp64_;
		ValaTypeSymbol* _tmp65_;
		ValaTypeSymbol* _tmp66_;
		_tmp64_ = instance_type;
		_tmp65_ = vala_data_type_get_data_type (_tmp64_);
		_tmp66_ = _tmp65_;
		if (VALA_IS_STRUCT (_tmp66_)) {
			ValaStruct* st = NULL;
			ValaDataType* _tmp67_;
			ValaTypeSymbol* _tmp68_;
			ValaTypeSymbol* _tmp69_;
			ValaStruct* _tmp70_;
			ValaStruct* _tmp71_;
			ValaDataType* _tmp72_;
			ValaDataType* _tmp73_;
			_tmp67_ = instance_type;
			_tmp68_ = vala_data_type_get_data_type (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp70_;
			_tmp71_ = st;
			_tmp72_ = vala_struct_get_base_type (_tmp71_);
			_tmp73_ = _tmp72_;
			if (_tmp73_ != NULL) {
				ValaDataType* _tmp74_;
				ValaStruct* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				ValaDataType* _tmp79_;
				ValaDataType* _tmp80_;
				ValaDataType* _tmp81_;
				_tmp74_ = instance_type;
				_tmp75_ = st;
				_tmp76_ = vala_struct_get_base_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_semantic_analyzer_get_instance_base_type (_tmp74_, _tmp77_, node_reference);
				_tmp79_ = _tmp78_;
				_tmp80_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp79_, type_symbol, node_reference);
				_vala_code_node_unref0 (instance_base_type);
				instance_base_type = _tmp80_;
				_vala_code_node_unref0 (_tmp79_);
				_tmp81_ = instance_base_type;
				if (_tmp81_ != NULL) {
					result = instance_base_type;
					_vala_code_node_unref0 (st);
					_vala_code_node_unref0 (instance_type);
					return result;
				}
			}
			_vala_code_node_unref0 (st);
		} else {
			ValaDataType* _tmp82_;
			ValaTypeSymbol* _tmp83_;
			ValaTypeSymbol* _tmp84_;
			_tmp82_ = instance_type;
			_tmp83_ = vala_data_type_get_data_type (_tmp82_);
			_tmp84_ = _tmp83_;
			if (VALA_IS_INTERFACE (_tmp84_)) {
				ValaInterface* iface = NULL;
				ValaDataType* _tmp85_;
				ValaTypeSymbol* _tmp86_;
				ValaTypeSymbol* _tmp87_;
				ValaInterface* _tmp88_;
				ValaDataType* _tmp109_;
				_tmp85_ = instance_type;
				_tmp86_ = vala_data_type_get_data_type (_tmp85_);
				_tmp87_ = _tmp86_;
				_tmp88_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_INTERFACE, ValaInterface));
				iface = _tmp88_;
				{
					ValaList* _prerequisite_list = NULL;
					ValaInterface* _tmp89_;
					ValaList* _tmp90_;
					gint _prerequisite_size = 0;
					ValaList* _tmp91_;
					gint _tmp92_;
					gint _tmp93_;
					gint _prerequisite_index = 0;
					_tmp89_ = iface;
					_tmp90_ = vala_interface_get_prerequisites (_tmp89_);
					_prerequisite_list = _tmp90_;
					_tmp91_ = _prerequisite_list;
					_tmp92_ = vala_collection_get_size ((ValaCollection*) _tmp91_);
					_tmp93_ = _tmp92_;
					_prerequisite_size = _tmp93_;
					_prerequisite_index = -1;
					while (TRUE) {
						gint _tmp94_;
						gint _tmp95_;
						gint _tmp96_;
						ValaDataType* prerequisite = NULL;
						ValaList* _tmp97_;
						gint _tmp98_;
						gpointer _tmp99_;
						ValaDataType* _tmp100_;
						ValaTypeSymbol* _tmp101_;
						ValaTypeSymbol* _tmp102_;
						_tmp94_ = _prerequisite_index;
						_prerequisite_index = _tmp94_ + 1;
						_tmp95_ = _prerequisite_index;
						_tmp96_ = _prerequisite_size;
						if (!(_tmp95_ < _tmp96_)) {
							break;
						}
						_tmp97_ = _prerequisite_list;
						_tmp98_ = _prerequisite_index;
						_tmp99_ = vala_list_get (_tmp97_, _tmp98_);
						prerequisite = (ValaDataType*) _tmp99_;
						_tmp100_ = prerequisite;
						_tmp101_ = vala_data_type_get_data_type (_tmp100_);
						_tmp102_ = _tmp101_;
						if (VALA_IS_INTERFACE (_tmp102_)) {
							ValaDataType* _tmp103_;
							ValaDataType* _tmp104_;
							ValaDataType* _tmp105_;
							ValaDataType* _tmp106_;
							ValaDataType* _tmp107_;
							ValaDataType* _tmp108_;
							_tmp103_ = instance_type;
							_tmp104_ = prerequisite;
							_tmp105_ = vala_semantic_analyzer_get_instance_base_type (_tmp103_, _tmp104_, node_reference);
							_tmp106_ = _tmp105_;
							_tmp107_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp106_, type_symbol, node_reference);
							_vala_code_node_unref0 (instance_base_type);
							instance_base_type = _tmp107_;
							_vala_code_node_unref0 (_tmp106_);
							_tmp108_ = instance_base_type;
							if (_tmp108_ != NULL) {
								result = instance_base_type;
								_vala_code_node_unref0 (prerequisite);
								_vala_iterable_unref0 (_prerequisite_list);
								_vala_code_node_unref0 (iface);
								_vala_code_node_unref0 (instance_type);
								return result;
							}
						}
						_vala_code_node_unref0 (prerequisite);
					}
					_vala_iterable_unref0 (_prerequisite_list);
				}
				_tmp109_ = instance_base_type;
				if (_tmp109_ == NULL) {
					{
						ValaList* _prerequisite_list = NULL;
						ValaInterface* _tmp110_;
						ValaList* _tmp111_;
						gint _prerequisite_size = 0;
						ValaList* _tmp112_;
						gint _tmp113_;
						gint _tmp114_;
						gint _prerequisite_index = 0;
						_tmp110_ = iface;
						_tmp111_ = vala_interface_get_prerequisites (_tmp110_);
						_prerequisite_list = _tmp111_;
						_tmp112_ = _prerequisite_list;
						_tmp113_ = vala_collection_get_size ((ValaCollection*) _tmp112_);
						_tmp114_ = _tmp113_;
						_prerequisite_size = _tmp114_;
						_prerequisite_index = -1;
						while (TRUE) {
							gint _tmp115_;
							gint _tmp116_;
							gint _tmp117_;
							ValaDataType* prerequisite = NULL;
							ValaList* _tmp118_;
							gint _tmp119_;
							gpointer _tmp120_;
							ValaDataType* _tmp121_;
							ValaTypeSymbol* _tmp122_;
							ValaTypeSymbol* _tmp123_;
							_tmp115_ = _prerequisite_index;
							_prerequisite_index = _tmp115_ + 1;
							_tmp116_ = _prerequisite_index;
							_tmp117_ = _prerequisite_size;
							if (!(_tmp116_ < _tmp117_)) {
								break;
							}
							_tmp118_ = _prerequisite_list;
							_tmp119_ = _prerequisite_index;
							_tmp120_ = vala_list_get (_tmp118_, _tmp119_);
							prerequisite = (ValaDataType*) _tmp120_;
							_tmp121_ = prerequisite;
							_tmp122_ = vala_data_type_get_data_type (_tmp121_);
							_tmp123_ = _tmp122_;
							if (VALA_IS_CLASS (_tmp123_)) {
								ValaDataType* _tmp124_;
								ValaDataType* _tmp125_;
								ValaDataType* _tmp126_;
								ValaDataType* _tmp127_;
								ValaDataType* _tmp128_;
								ValaDataType* _tmp129_;
								_tmp124_ = instance_type;
								_tmp125_ = prerequisite;
								_tmp126_ = vala_semantic_analyzer_get_instance_base_type (_tmp124_, _tmp125_, node_reference);
								_tmp127_ = _tmp126_;
								_tmp128_ = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp127_, type_symbol, node_reference);
								_vala_code_node_unref0 (instance_base_type);
								instance_base_type = _tmp128_;
								_vala_code_node_unref0 (_tmp127_);
								_tmp129_ = instance_base_type;
								if (_tmp129_ != NULL) {
									result = instance_base_type;
									_vala_code_node_unref0 (prerequisite);
									_vala_iterable_unref0 (_prerequisite_list);
									_vala_code_node_unref0 (iface);
									_vala_code_node_unref0 (instance_type);
									return result;
								}
							}
							_vala_code_node_unref0 (prerequisite);
						}
						_vala_iterable_unref0 (_prerequisite_list);
					}
				}
				_vala_code_node_unref0 (iface);
			}
		}
	}
	result = NULL;
	_vala_code_node_unref0 (instance_base_type);
	_vala_code_node_unref0 (instance_type);
	return result;
}


ValaDataType*
vala_semantic_analyzer_get_actual_type (ValaDataType* derived_instance_type,
                                        ValaList* method_type_arguments,
                                        ValaGenericType* generic_type,
                                        ValaCodeNode* node_reference)
{
	ValaDataType* result = NULL;
	ValaDataType* actual_type = NULL;
	ValaTypeParameter* _tmp0_;
	ValaTypeParameter* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaDataType* _tmp82_;
	ValaDataType* _tmp84_;
	ValaDataType* _tmp85_;
	gboolean _tmp86_ = FALSE;
	ValaDataType* _tmp87_;
	gboolean _tmp88_;
	gboolean _tmp89_;
	ValaDataType* _tmp92_;
	g_return_val_if_fail (generic_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	actual_type = NULL;
	_tmp0_ = vala_generic_type_get_type_parameter (generic_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (VALA_IS_TYPESYMBOL (_tmp3_)) {
		if (derived_instance_type != NULL) {
			ValaDataType* instance_type = NULL;
			ValaTypeParameter* _tmp4_;
			ValaTypeParameter* _tmp5_;
			ValaSymbol* _tmp6_;
			ValaSymbol* _tmp7_;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			gint param_index = 0;
			ValaDataType* _tmp20_;
			gint _tmp35_;
			gint _tmp45_;
			ValaDataType* _tmp46_;
			ValaList* _tmp47_;
			ValaList* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			gboolean _tmp51_;
			_tmp4_ = vala_generic_type_get_type_parameter (generic_type);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_semantic_analyzer_get_instance_base_type_for_member (derived_instance_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), node_reference);
			instance_type = _tmp8_;
			_tmp9_ = instance_type;
			if (_tmp9_ == NULL) {
				ValaCodeNode* reference = NULL;
				ValaSymbol* _tmp10_;
				ValaCodeNode* _tmp11_ = NULL;
				ValaCodeNode* _tmp12_;
				ValaSourceReference* _tmp13_;
				ValaSourceReference* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				ValaInvalidType* _tmp19_;
				_tmp10_ = vala_semantic_analyzer_get_symbol_for_data_type (derived_instance_type);
				reference = (ValaCodeNode*) _tmp10_;
				_tmp12_ = reference;
				_tmp11_ = _tmp12_;
				if (_tmp11_ == NULL) {
					_tmp11_ = node_reference;
				}
				_tmp13_ = vala_code_node_get_source_reference (_tmp11_);
				_tmp14_ = _tmp13_;
				_tmp15_ = vala_code_node_to_string ((ValaCodeNode*) generic_type);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strdup_printf ("The type-parameter `%s' is missing", _tmp16_);
				_tmp18_ = _tmp17_;
				vala_report_error (_tmp14_, _tmp18_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
				vala_code_node_set_error (node_reference, TRUE);
				_tmp19_ = vala_invalid_type_new ();
				result = (ValaDataType*) _tmp19_;
				_vala_code_node_unref0 (reference);
				_vala_code_node_unref0 (instance_type);
				_vala_code_node_unref0 (actual_type);
				return result;
			}
			_tmp20_ = instance_type;
			if (VALA_IS_DELEGATE_TYPE (_tmp20_)) {
				ValaDataType* _tmp21_;
				ValaDelegate* _tmp22_;
				ValaDelegate* _tmp23_;
				ValaTypeParameter* _tmp24_;
				ValaTypeParameter* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp21_ = instance_type;
				_tmp22_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_generic_type_get_type_parameter (generic_type);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_symbol_get_name ((ValaSymbol*) _tmp25_);
				_tmp27_ = _tmp26_;
				param_index = vala_typesymbol_get_type_parameter_index ((ValaTypeSymbol*) _tmp23_, _tmp27_);
			} else {
				ValaDataType* _tmp28_;
				ValaTypeSymbol* _tmp29_;
				ValaTypeSymbol* _tmp30_;
				ValaTypeParameter* _tmp31_;
				ValaTypeParameter* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				_tmp28_ = instance_type;
				_tmp29_ = vala_data_type_get_data_type (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = vala_generic_type_get_type_parameter (generic_type);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_symbol_get_name ((ValaSymbol*) _tmp32_);
				_tmp34_ = _tmp33_;
				param_index = vala_typesymbol_get_type_parameter_index (_tmp30_, _tmp34_);
			}
			_tmp35_ = param_index;
			if (_tmp35_ == -1) {
				ValaSourceReference* _tmp36_;
				ValaSourceReference* _tmp37_;
				ValaTypeParameter* _tmp38_;
				ValaTypeParameter* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				ValaInvalidType* _tmp44_;
				_tmp36_ = vala_code_node_get_source_reference (node_reference);
				_tmp37_ = _tmp36_;
				_tmp38_ = vala_generic_type_get_type_parameter (generic_type);
				_tmp39_ = _tmp38_;
				_tmp40_ = vala_symbol_get_name ((ValaSymbol*) _tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strdup_printf ("internal error: unknown type parameter %s", _tmp41_);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp37_, _tmp43_);
				_g_free0 (_tmp43_);
				vala_code_node_set_error (node_reference, TRUE);
				_tmp44_ = vala_invalid_type_new ();
				result = (ValaDataType*) _tmp44_;
				_vala_code_node_unref0 (instance_type);
				_vala_code_node_unref0 (actual_type);
				return result;
			}
			_tmp45_ = param_index;
			_tmp46_ = instance_type;
			_tmp47_ = vala_data_type_get_type_arguments (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = _tmp45_ < _tmp50_;
			_vala_iterable_unref0 (_tmp48_);
			if (_tmp51_) {
				ValaDataType* _tmp52_;
				ValaList* _tmp53_;
				ValaList* _tmp54_;
				gint _tmp55_;
				gpointer _tmp56_;
				_tmp52_ = instance_type;
				_tmp53_ = vala_data_type_get_type_arguments (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = param_index;
				_tmp56_ = vala_list_get (_tmp54_, _tmp55_);
				_vala_code_node_unref0 (actual_type);
				actual_type = G_TYPE_CHECK_INSTANCE_CAST ((ValaDataType*) _tmp56_, VALA_TYPE_DATA_TYPE, ValaDataType);
				_vala_iterable_unref0 (_tmp54_);
			}
			_vala_code_node_unref0 (instance_type);
		}
	} else {
		ValaMethod* m = NULL;
		ValaTypeParameter* _tmp57_;
		ValaTypeParameter* _tmp58_;
		ValaSymbol* _tmp59_;
		ValaSymbol* _tmp60_;
		ValaMethod* _tmp61_;
		gint param_index = 0;
		ValaMethod* _tmp62_;
		ValaTypeParameter* _tmp63_;
		ValaTypeParameter* _tmp64_;
		const gchar* _tmp65_;
		const gchar* _tmp66_;
		gint _tmp67_;
		_tmp57_ = vala_generic_type_get_type_parameter (generic_type);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp61_;
		_tmp62_ = m;
		_tmp63_ = vala_generic_type_get_type_parameter (generic_type);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_symbol_get_name ((ValaSymbol*) _tmp64_);
		_tmp66_ = _tmp65_;
		param_index = vala_method_get_type_parameter_index (_tmp62_, _tmp66_);
		_tmp67_ = param_index;
		if (_tmp67_ == -1) {
			ValaSourceReference* _tmp68_;
			ValaSourceReference* _tmp69_;
			ValaTypeParameter* _tmp70_;
			ValaTypeParameter* _tmp71_;
			const gchar* _tmp72_;
			const gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			ValaInvalidType* _tmp76_;
			_tmp68_ = vala_code_node_get_source_reference (node_reference);
			_tmp69_ = _tmp68_;
			_tmp70_ = vala_generic_type_get_type_parameter (generic_type);
			_tmp71_ = _tmp70_;
			_tmp72_ = vala_symbol_get_name ((ValaSymbol*) _tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = g_strdup_printf ("internal error: unknown type parameter %s", _tmp73_);
			_tmp75_ = _tmp74_;
			vala_report_error (_tmp69_, _tmp75_);
			_g_free0 (_tmp75_);
			vala_code_node_set_error (node_reference, TRUE);
			_tmp76_ = vala_invalid_type_new ();
			result = (ValaDataType*) _tmp76_;
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (actual_type);
			return result;
		}
		if (method_type_arguments != NULL) {
			gint _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			_tmp77_ = param_index;
			_tmp78_ = vala_collection_get_size ((ValaCollection*) method_type_arguments);
			_tmp79_ = _tmp78_;
			if (_tmp77_ < _tmp79_) {
				gint _tmp80_;
				gpointer _tmp81_;
				_tmp80_ = param_index;
				_tmp81_ = vala_list_get (method_type_arguments, _tmp80_);
				_vala_code_node_unref0 (actual_type);
				actual_type = G_TYPE_CHECK_INSTANCE_CAST ((ValaDataType*) _tmp81_, VALA_TYPE_DATA_TYPE, ValaDataType);
			}
		}
		_vala_code_node_unref0 (m);
	}
	_tmp82_ = actual_type;
	if (_tmp82_ == NULL) {
		ValaDataType* _tmp83_;
		_tmp83_ = _vala_code_node_ref0 ((ValaDataType*) generic_type);
		result = _tmp83_;
		_vala_code_node_unref0 (actual_type);
		return result;
	}
	_tmp84_ = actual_type;
	_tmp85_ = vala_data_type_copy (_tmp84_);
	_vala_code_node_unref0 (actual_type);
	actual_type = _tmp85_;
	_tmp87_ = actual_type;
	_tmp88_ = vala_data_type_get_value_owned (_tmp87_);
	_tmp89_ = _tmp88_;
	if (_tmp89_) {
		gboolean _tmp90_;
		gboolean _tmp91_;
		_tmp90_ = vala_data_type_get_value_owned ((ValaDataType*) generic_type);
		_tmp91_ = _tmp90_;
		_tmp86_ = _tmp91_;
	} else {
		_tmp86_ = FALSE;
	}
	_tmp92_ = actual_type;
	vala_data_type_set_value_owned (_tmp92_, _tmp86_);
	result = actual_type;
	return result;
}


gboolean
vala_semantic_analyzer_is_in_instance_method (ValaSemanticAnalyzer* self)
{
	gboolean result = FALSE;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_current_symbol;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	sym = _tmp1_;
	while (TRUE) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp28_;
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		_tmp2_ = sym;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = sym;
		if (VALA_IS_CREATION_METHOD (_tmp3_)) {
			result = TRUE;
			_vala_code_node_unref0 (sym);
			return result;
		} else {
			ValaSymbol* _tmp4_;
			_tmp4_ = sym;
			if (VALA_IS_METHOD (_tmp4_)) {
				ValaMethod* m = NULL;
				ValaSymbol* _tmp5_;
				ValaMethod* _tmp6_;
				ValaMethod* _tmp7_;
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp5_ = sym;
				_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp6_;
				_tmp7_ = m;
				_tmp8_ = vala_method_get_binding (_tmp7_);
				_tmp9_ = _tmp8_;
				result = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
				_vala_code_node_unref0 (m);
				_vala_code_node_unref0 (sym);
				return result;
			} else {
				ValaSymbol* _tmp10_;
				_tmp10_ = sym;
				if (VALA_IS_CONSTRUCTOR (_tmp10_)) {
					ValaConstructor* c = NULL;
					ValaSymbol* _tmp11_;
					ValaConstructor* _tmp12_;
					ValaConstructor* _tmp13_;
					ValaMemberBinding _tmp14_;
					ValaMemberBinding _tmp15_;
					_tmp11_ = sym;
					_tmp12_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
					c = _tmp12_;
					_tmp13_ = c;
					_tmp14_ = vala_constructor_get_binding (_tmp13_);
					_tmp15_ = _tmp14_;
					result = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
					_vala_code_node_unref0 (c);
					_vala_code_node_unref0 (sym);
					return result;
				} else {
					ValaSymbol* _tmp16_;
					_tmp16_ = sym;
					if (VALA_IS_DESTRUCTOR (_tmp16_)) {
						ValaDestructor* d = NULL;
						ValaSymbol* _tmp17_;
						ValaDestructor* _tmp18_;
						ValaDestructor* _tmp19_;
						ValaMemberBinding _tmp20_;
						ValaMemberBinding _tmp21_;
						_tmp17_ = sym;
						_tmp18_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
						d = _tmp18_;
						_tmp19_ = d;
						_tmp20_ = vala_destructor_get_binding (_tmp19_);
						_tmp21_ = _tmp20_;
						result = _tmp21_ == VALA_MEMBER_BINDING_INSTANCE;
						_vala_code_node_unref0 (d);
						_vala_code_node_unref0 (sym);
						return result;
					} else {
						ValaSymbol* _tmp22_;
						_tmp22_ = sym;
						if (VALA_IS_PROPERTY (_tmp22_)) {
							ValaProperty* p = NULL;
							ValaSymbol* _tmp23_;
							ValaProperty* _tmp24_;
							ValaProperty* _tmp25_;
							ValaMemberBinding _tmp26_;
							ValaMemberBinding _tmp27_;
							_tmp23_ = sym;
							_tmp24_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_PROPERTY, ValaProperty));
							p = _tmp24_;
							_tmp25_ = p;
							_tmp26_ = vala_property_get_binding (_tmp25_);
							_tmp27_ = _tmp26_;
							result = _tmp27_ == VALA_MEMBER_BINDING_INSTANCE;
							_vala_code_node_unref0 (p);
							_vala_code_node_unref0 (sym);
							return result;
						}
					}
				}
			}
		}
		_tmp28_ = sym;
		_tmp29_ = vala_symbol_get_parent_symbol (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _vala_code_node_ref0 (_tmp30_);
		_vala_code_node_unref0 (sym);
		sym = _tmp31_;
	}
	result = FALSE;
	_vala_code_node_unref0 (sym);
	return result;
}


ValaExpression*
vala_semantic_analyzer_create_temp_access (ValaLocalVariable* local,
                                           ValaDataType* target_type)
{
	ValaExpression* result = NULL;
	ValaExpression* temp_access = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaMemberAccess* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean target_owned = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
	g_return_val_if_fail (local != NULL, NULL);
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) local);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) local);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_member_access_new_simple (_tmp1_, _tmp3_);
	temp_access = (ValaExpression*) _tmp4_;
	if (target_type != NULL) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = vala_data_type_get_value_owned (target_type);
		_tmp7_ = _tmp6_;
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	target_owned = _tmp5_;
	_tmp9_ = target_owned;
	if (_tmp9_) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) local);
		_tmp11_ = _tmp10_;
		_tmp8_ = vala_data_type_is_disposable (_tmp11_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaExpression* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaReferenceTransferExpression* _tmp15_;
		ValaDataType* _tmp16_ = NULL;
		ValaExpression* _tmp21_;
		ValaExpression* _tmp22_;
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		_tmp12_ = temp_access;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) local);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_reference_transfer_expression_new (_tmp12_, _tmp14_);
		_vala_code_node_unref0 (temp_access);
		temp_access = (ValaExpression*) _tmp15_;
		if (target_type != NULL) {
			ValaDataType* _tmp17_;
			_tmp17_ = vala_data_type_copy (target_type);
			_vala_code_node_unref0 (_tmp16_);
			_tmp16_ = _tmp17_;
		} else {
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			ValaDataType* _tmp20_;
			_tmp18_ = vala_variable_get_variable_type ((ValaVariable*) local);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_data_type_copy (_tmp19_);
			_vala_code_node_unref0 (_tmp16_);
			_tmp16_ = _tmp20_;
		}
		_tmp21_ = temp_access;
		vala_expression_set_target_type (_tmp21_, _tmp16_);
		_tmp22_ = temp_access;
		_tmp23_ = vala_expression_get_target_type (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_data_type_set_value_owned (_tmp24_, TRUE);
		_vala_code_node_unref0 (_tmp16_);
	} else {
		ValaDataType* _tmp25_ = NULL;
		ValaExpression* _tmp27_;
		if (target_type != NULL) {
			ValaDataType* _tmp26_;
			_tmp26_ = vala_data_type_copy (target_type);
			_vala_code_node_unref0 (_tmp25_);
			_tmp25_ = _tmp26_;
		} else {
			_vala_code_node_unref0 (_tmp25_);
			_tmp25_ = NULL;
		}
		_tmp27_ = temp_access;
		vala_expression_set_target_type (_tmp27_, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
	}
	result = temp_access;
	return result;
}


void
vala_semantic_analyzer_visit_member_initializer (ValaSemanticAnalyzer* self,
                                                 ValaMemberInitializer* init,
                                                 ValaDataType* type)
{
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp21_;
	ValaSymbol* _tmp22_;
	ValaSymbolAccessibility _tmp23_;
	ValaSymbolAccessibility _tmp24_;
	ValaDataType* member_type = NULL;
	ValaSymbol* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaExpression* _tmp67_;
	ValaExpression* _tmp68_;
	ValaDataType* _tmp69_;
	ValaExpression* _tmp70_;
	ValaExpression* _tmp71_;
	ValaExpression* _tmp72_;
	ValaExpression* _tmp73_;
	ValaDataType* _tmp74_;
	ValaDataType* _tmp75_;
	ValaDataType* _tmp76_;
	ValaDataType* _tmp77_;
	ValaCodeContext* _tmp78_;
	gboolean _tmp79_ = FALSE;
	ValaExpression* _tmp80_;
	ValaExpression* _tmp81_;
	ValaDataType* _tmp82_;
	ValaDataType* _tmp83_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = vala_data_type_get_data_type (type);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_member_initializer_get_name (init);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	vala_member_initializer_set_symbol_reference (init, _tmp5_);
	_vala_code_node_unref0 (_tmp5_);
	_tmp7_ = vala_member_initializer_get_symbol_reference (init);
	_tmp8_ = _tmp7_;
	if (VALA_IS_FIELD (_tmp8_)) {
		_tmp6_ = TRUE;
	} else {
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp9_ = vala_member_initializer_get_symbol_reference (init);
		_tmp10_ = _tmp9_;
		_tmp6_ = VALA_IS_PROPERTY (_tmp10_);
	}
	if (!_tmp6_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		ValaTypeSymbol* _tmp15_;
		ValaTypeSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		vala_code_node_set_error ((ValaCodeNode*) init, TRUE);
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) init);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_initializer_get_name (init);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_data_type_get_data_type (type);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("Invalid member `%s' in `%s'", _tmp14_, _tmp18_);
		_tmp20_ = _tmp19_;
		vala_report_error (_tmp12_, _tmp20_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		return;
	}
	_tmp21_ = vala_member_initializer_get_symbol_reference (init);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_symbol_get_access (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSymbol* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		vala_code_node_set_error ((ValaCodeNode*) init, TRUE);
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) init);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_member_initializer_get_symbol_reference (init);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_symbol_get_full_name (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strdup_printf ("Access to private member `%s' denied", _tmp30_);
		_tmp32_ = _tmp31_;
		vala_report_error (_tmp26_, _tmp32_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp30_);
		return;
	}
	member_type = NULL;
	_tmp33_ = vala_member_initializer_get_symbol_reference (init);
	_tmp34_ = _tmp33_;
	if (VALA_IS_FIELD (_tmp34_)) {
		ValaField* f = NULL;
		ValaSymbol* _tmp35_;
		ValaSymbol* _tmp36_;
		ValaField* _tmp37_;
		ValaField* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		_tmp35_ = vala_member_initializer_get_symbol_reference (init);
		_tmp36_ = _tmp35_;
		_tmp37_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_FIELD, ValaField));
		f = _tmp37_;
		_tmp38_ = f;
		_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = _vala_code_node_ref0 (_tmp40_);
		_vala_code_node_unref0 (member_type);
		member_type = _tmp41_;
		_vala_code_node_unref0 (f);
	} else {
		ValaSymbol* _tmp42_;
		ValaSymbol* _tmp43_;
		_tmp42_ = vala_member_initializer_get_symbol_reference (init);
		_tmp43_ = _tmp42_;
		if (VALA_IS_PROPERTY (_tmp43_)) {
			ValaProperty* prop = NULL;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			ValaProperty* _tmp46_;
			ValaProperty* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			ValaDataType* _tmp50_;
			gboolean _tmp51_ = FALSE;
			ValaProperty* _tmp52_;
			ValaPropertyAccessor* _tmp53_;
			ValaPropertyAccessor* _tmp54_;
			_tmp44_ = vala_member_initializer_get_symbol_reference (init);
			_tmp45_ = _tmp44_;
			_tmp46_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp46_;
			_tmp47_ = prop;
			_tmp48_ = vala_property_get_property_type (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = _vala_code_node_ref0 (_tmp49_);
			_vala_code_node_unref0 (member_type);
			member_type = _tmp50_;
			_tmp52_ = prop;
			_tmp53_ = vala_property_get_set_accessor (_tmp52_);
			_tmp54_ = _tmp53_;
			if (_tmp54_ == NULL) {
				_tmp51_ = TRUE;
			} else {
				ValaProperty* _tmp55_;
				ValaPropertyAccessor* _tmp56_;
				ValaPropertyAccessor* _tmp57_;
				gboolean _tmp58_;
				gboolean _tmp59_;
				_tmp55_ = prop;
				_tmp56_ = vala_property_get_set_accessor (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_property_accessor_get_writable (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp51_ = !_tmp59_;
			}
			if (_tmp51_) {
				ValaSourceReference* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaProperty* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				vala_code_node_set_error ((ValaCodeNode*) init, TRUE);
				_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) init);
				_tmp61_ = _tmp60_;
				_tmp62_ = prop;
				_tmp63_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = g_strdup_printf ("Property `%s' is read-only", _tmp64_);
				_tmp66_ = _tmp65_;
				vala_report_error (_tmp61_, _tmp66_);
				_g_free0 (_tmp66_);
				_g_free0 (_tmp64_);
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (member_type);
				return;
			}
			_vala_code_node_unref0 (prop);
		}
	}
	_tmp67_ = vala_member_initializer_get_initializer (init);
	_tmp68_ = _tmp67_;
	_tmp69_ = member_type;
	vala_expression_set_formal_target_type (_tmp68_, _tmp69_);
	_tmp70_ = vala_member_initializer_get_initializer (init);
	_tmp71_ = _tmp70_;
	_tmp72_ = vala_member_initializer_get_initializer (init);
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_expression_get_formal_target_type (_tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = vala_data_type_get_actual_type (_tmp75_, type, NULL, (ValaCodeNode*) init);
	_tmp77_ = _tmp76_;
	vala_expression_set_target_type (_tmp71_, _tmp77_);
	_vala_code_node_unref0 (_tmp77_);
	_tmp78_ = self->priv->context;
	vala_code_node_check ((ValaCodeNode*) init, _tmp78_);
	_tmp80_ = vala_member_initializer_get_initializer (init);
	_tmp81_ = _tmp80_;
	_tmp82_ = vala_expression_get_value_type (_tmp81_);
	_tmp83_ = _tmp82_;
	if (_tmp83_ == NULL) {
		_tmp79_ = TRUE;
	} else {
		ValaExpression* _tmp84_;
		ValaExpression* _tmp85_;
		ValaDataType* _tmp86_;
		ValaDataType* _tmp87_;
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaDataType* _tmp90_;
		ValaDataType* _tmp91_;
		_tmp84_ = vala_member_initializer_get_initializer (init);
		_tmp85_ = _tmp84_;
		_tmp86_ = vala_expression_get_value_type (_tmp85_);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_member_initializer_get_initializer (init);
		_tmp89_ = _tmp88_;
		_tmp90_ = vala_expression_get_target_type (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp79_ = !vala_data_type_compatible (_tmp87_, _tmp91_);
	}
	if (_tmp79_) {
		ValaSourceReference* _tmp92_;
		ValaSourceReference* _tmp93_;
		const gchar* _tmp94_;
		const gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		vala_code_node_set_error ((ValaCodeNode*) init, TRUE);
		_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) init);
		_tmp93_ = _tmp92_;
		_tmp94_ = vala_member_initializer_get_name (init);
		_tmp95_ = _tmp94_;
		_tmp96_ = g_strdup_printf ("Invalid type for member `%s'", _tmp95_);
		_tmp97_ = _tmp96_;
		vala_report_error (_tmp93_, _tmp97_);
		_g_free0 (_tmp97_);
		_vala_code_node_unref0 (member_type);
		return;
	}
	_vala_code_node_unref0 (member_type);
}


static ValaStruct*
vala_semantic_analyzer_get_arithmetic_struct (ValaSemanticAnalyzer* self,
                                              ValaDataType* type)
{
	ValaStruct* result = NULL;
	ValaStruct* _result_ = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = vala_data_type_get_data_type (type);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL);
	_result_ = _tmp2_;
	_tmp4_ = _result_;
	if (_tmp4_ == NULL) {
		_tmp3_ = VALA_IS_ENUM_VALUE_TYPE (type);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaDataType* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaStruct* _tmp8_;
		_tmp5_ = self->int_type;
		_tmp6_ = vala_data_type_get_data_type (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_STRUCT, ValaStruct));
		result = _tmp8_;
		_vala_code_node_unref0 (_result_);
		return result;
	}
	result = _result_;
	return result;
}


ValaDataType*
vala_semantic_analyzer_get_arithmetic_result_type (ValaSemanticAnalyzer* self,
                                                   ValaDataType* left_type,
                                                   ValaDataType* right_type)
{
	ValaDataType* result = NULL;
	ValaStruct* left = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* right = NULL;
	ValaStruct* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	ValaStruct* _tmp7_;
	ValaStruct* _tmp12_;
	ValaStruct* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (left_type != NULL, NULL);
	g_return_val_if_fail (right_type != NULL, NULL);
	_tmp0_ = vala_semantic_analyzer_get_arithmetic_struct (self, left_type);
	left = _tmp0_;
	_tmp1_ = vala_semantic_analyzer_get_arithmetic_struct (self, right_type);
	right = _tmp1_;
	_tmp3_ = left;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		ValaStruct* _tmp4_;
		_tmp4_ = right;
		_tmp2_ = _tmp4_ == NULL;
	}
	if (_tmp2_) {
		result = NULL;
		_vala_code_node_unref0 (right);
		_vala_code_node_unref0 (left);
		return result;
	}
	_tmp7_ = left;
	if (!vala_struct_is_floating_type (_tmp7_)) {
		ValaStruct* _tmp8_;
		_tmp8_ = left;
		_tmp6_ = !vala_struct_is_integer_type (_tmp8_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		ValaStruct* _tmp10_;
		_tmp10_ = right;
		if (!vala_struct_is_floating_type (_tmp10_)) {
			ValaStruct* _tmp11_;
			_tmp11_ = right;
			_tmp9_ = !vala_struct_is_integer_type (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		_tmp5_ = _tmp9_;
	}
	if (_tmp5_) {
		result = NULL;
		_vala_code_node_unref0 (right);
		_vala_code_node_unref0 (left);
		return result;
	}
	_tmp12_ = left;
	_tmp13_ = right;
	if (vala_struct_is_floating_type (_tmp12_) == vala_struct_is_floating_type (_tmp13_)) {
		ValaStruct* _tmp14_;
		ValaStruct* _tmp15_;
		_tmp14_ = left;
		_tmp15_ = right;
		if (vala_struct_get_rank (_tmp14_) >= vala_struct_get_rank (_tmp15_)) {
			ValaDataType* _tmp16_;
			_tmp16_ = _vala_code_node_ref0 (left_type);
			result = _tmp16_;
			_vala_code_node_unref0 (right);
			_vala_code_node_unref0 (left);
			return result;
		} else {
			ValaDataType* _tmp17_;
			_tmp17_ = _vala_code_node_ref0 (right_type);
			result = _tmp17_;
			_vala_code_node_unref0 (right);
			_vala_code_node_unref0 (left);
			return result;
		}
	} else {
		ValaStruct* _tmp18_;
		_tmp18_ = left;
		if (vala_struct_is_floating_type (_tmp18_)) {
			ValaDataType* _tmp19_;
			_tmp19_ = _vala_code_node_ref0 (left_type);
			result = _tmp19_;
			_vala_code_node_unref0 (right);
			_vala_code_node_unref0 (left);
			return result;
		} else {
			ValaDataType* _tmp20_;
			_tmp20_ = _vala_code_node_ref0 (right_type);
			result = _tmp20_;
			_vala_code_node_unref0 (right);
			_vala_code_node_unref0 (left);
			return result;
		}
	}
	_vala_code_node_unref0 (right);
	_vala_code_node_unref0 (left);
}


ValaMethod*
vala_semantic_analyzer_find_current_method (ValaSemanticAnalyzer* self)
{
	ValaMethod* result = NULL;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	sym = _tmp1_;
	while (TRUE) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		_tmp2_ = sym;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = sym;
		if (VALA_IS_METHOD (_tmp3_)) {
			ValaSymbol* _tmp4_;
			ValaMethod* _tmp5_;
			_tmp4_ = sym;
			_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_METHOD, ValaMethod));
			result = _tmp5_;
			_vala_code_node_unref0 (sym);
			return result;
		}
		_tmp6_ = sym;
		_tmp7_ = vala_symbol_get_parent_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (_tmp8_);
		_vala_code_node_unref0 (sym);
		sym = _tmp9_;
	}
	result = NULL;
	_vala_code_node_unref0 (sym);
	return result;
}


ValaMethod*
vala_semantic_analyzer_find_parent_method (ValaSemanticAnalyzer* self,
                                           ValaSymbol* sym)
{
	ValaMethod* result = NULL;
	ValaMethod* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		if (!VALA_IS_BLOCK (sym)) {
			break;
		}
		_tmp0_ = vala_symbol_get_parent_symbol (sym);
		_tmp1_ = _tmp0_;
		sym = _tmp1_;
	}
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_METHOD (sym) ? ((ValaMethod*) sym) : NULL);
	result = _tmp2_;
	return result;
}


ValaSymbol*
vala_semantic_analyzer_find_parent_method_or_property_accessor (ValaSemanticAnalyzer* self,
                                                                ValaSymbol* sym)
{
	ValaSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		if (!VALA_IS_BLOCK (sym)) {
			break;
		}
		_tmp0_ = vala_symbol_get_parent_symbol (sym);
		_tmp1_ = _tmp0_;
		sym = _tmp1_;
	}
	if (VALA_IS_METHOD (sym)) {
		ValaSymbol* _tmp2_;
		_tmp2_ = _vala_code_node_ref0 (sym);
		result = _tmp2_;
		return result;
	} else {
		if (VALA_IS_PROPERTY_ACCESSOR (sym)) {
			ValaSymbol* _tmp3_;
			_tmp3_ = _vala_code_node_ref0 (sym);
			result = _tmp3_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}


gboolean
vala_semantic_analyzer_is_in_constructor (ValaSemanticAnalyzer* self)
{
	gboolean result = FALSE;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_current_symbol;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	sym = _tmp1_;
	while (TRUE) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp2_ = sym;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = sym;
		if (VALA_IS_CONSTRUCTOR (_tmp3_)) {
			result = TRUE;
			_vala_code_node_unref0 (sym);
			return result;
		}
		_tmp4_ = sym;
		_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _vala_code_node_ref0 (_tmp6_);
		_vala_code_node_unref0 (sym);
		sym = _tmp7_;
	}
	result = FALSE;
	_vala_code_node_unref0 (sym);
	return result;
}


gboolean
vala_semantic_analyzer_is_in_destructor (ValaSemanticAnalyzer* self)
{
	gboolean result = FALSE;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_current_symbol;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	sym = _tmp1_;
	while (TRUE) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp2_ = sym;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = sym;
		if (VALA_IS_DESTRUCTOR (_tmp3_)) {
			result = TRUE;
			_vala_code_node_unref0 (sym);
			return result;
		}
		_tmp4_ = sym;
		_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _vala_code_node_ref0 (_tmp6_);
		_vala_code_node_unref0 (sym);
		sym = _tmp7_;
	}
	result = FALSE;
	_vala_code_node_unref0 (sym);
	return result;
}


ValaSymbol*
vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self)
{
	ValaSymbol* result;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	result = _tmp0_;
	return result;
}


void
vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self,
                                           ValaSymbol* value)
{
	ValaSymbol* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_current_symbol);
	self->priv->_current_symbol = _tmp0_;
}


ValaSourceFile*
vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self)
{
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_source_file;
	result = _tmp0_;
	return result;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


void
vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self,
                                                ValaSourceFile* value)
{
	ValaSourceFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_file_ref0 (value);
	_vala_source_file_unref0 (self->priv->_current_source_file);
	self->priv->_current_source_file = _tmp0_;
}


ValaTypeSymbol*
vala_semantic_analyzer_get_current_type_symbol (ValaSemanticAnalyzer* self)
{
	ValaTypeSymbol* result;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	sym = _tmp1_;
	while (TRUE) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp2_ = sym;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = sym;
		if (VALA_IS_TYPESYMBOL (_tmp3_)) {
			ValaSymbol* _tmp4_;
			_tmp4_ = sym;
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			_vala_code_node_unref0 (sym);
			return result;
		}
		_tmp5_ = sym;
		_tmp6_ = vala_symbol_get_parent_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _vala_code_node_ref0 (_tmp7_);
		_vala_code_node_unref0 (sym);
		sym = _tmp8_;
	}
	result = NULL;
	_vala_code_node_unref0 (sym);
	return result;
}


ValaClass*
vala_semantic_analyzer_get_current_class (ValaSemanticAnalyzer* self)
{
	ValaClass* result;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_semantic_analyzer_get_current_type_symbol (self);
	_tmp1_ = _tmp0_;
	result = VALA_IS_CLASS (_tmp1_) ? ((ValaClass*) _tmp1_) : NULL;
	return result;
}


ValaStruct*
vala_semantic_analyzer_get_current_struct (ValaSemanticAnalyzer* self)
{
	ValaStruct* result;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_semantic_analyzer_get_current_type_symbol (self);
	_tmp1_ = _tmp0_;
	result = VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL;
	return result;
}


ValaMethod*
vala_semantic_analyzer_get_current_method (ValaSemanticAnalyzer* self)
{
	ValaMethod* result;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp1_ = sym;
		if (!VALA_IS_BLOCK (_tmp1_)) {
			break;
		}
		_tmp2_ = sym;
		_tmp3_ = vala_symbol_get_parent_symbol (_tmp2_);
		_tmp4_ = _tmp3_;
		sym = _tmp4_;
	}
	_tmp5_ = sym;
	result = VALA_IS_METHOD (_tmp5_) ? ((ValaMethod*) _tmp5_) : NULL;
	return result;
}


ValaMethod*
vala_semantic_analyzer_get_current_async_method (ValaSemanticAnalyzer* self)
{
	ValaMethod* result;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		ValaSymbol* _tmp2_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaMethod* _tmp5_;
		gboolean _tmp6_ = FALSE;
		ValaMethod* _tmp7_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		_tmp2_ = sym;
		if (VALA_IS_BLOCK (_tmp2_)) {
			_tmp1_ = TRUE;
		} else {
			ValaSymbol* _tmp3_;
			_tmp3_ = sym;
			_tmp1_ = VALA_IS_METHOD (_tmp3_);
		}
		if (!_tmp1_) {
			break;
		}
		_tmp4_ = sym;
		_tmp5_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp4_) ? ((ValaMethod*) _tmp4_) : NULL);
		m = _tmp5_;
		_tmp7_ = m;
		if (_tmp7_ != NULL) {
			ValaMethod* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = m;
			_tmp9_ = vala_method_get_coroutine (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			_vala_code_node_unref0 (m);
			break;
		}
		_tmp11_ = sym;
		_tmp12_ = vala_symbol_get_parent_symbol (_tmp11_);
		_tmp13_ = _tmp12_;
		sym = _tmp13_;
		_vala_code_node_unref0 (m);
	}
	_tmp14_ = sym;
	result = VALA_IS_METHOD (_tmp14_) ? ((ValaMethod*) _tmp14_) : NULL;
	return result;
}


ValaPropertyAccessor*
vala_semantic_analyzer_get_current_property_accessor (ValaSemanticAnalyzer* self)
{
	ValaPropertyAccessor* result;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp1_ = sym;
		if (!VALA_IS_BLOCK (_tmp1_)) {
			break;
		}
		_tmp2_ = sym;
		_tmp3_ = vala_symbol_get_parent_symbol (_tmp2_);
		_tmp4_ = _tmp3_;
		sym = _tmp4_;
	}
	_tmp5_ = sym;
	result = VALA_IS_PROPERTY_ACCESSOR (_tmp5_) ? ((ValaPropertyAccessor*) _tmp5_) : NULL;
	return result;
}


ValaSymbol*
vala_semantic_analyzer_get_current_method_or_property_accessor (ValaSemanticAnalyzer* self)
{
	ValaSymbol* result;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_symbol;
	sym = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp1_ = sym;
		if (!VALA_IS_BLOCK (_tmp1_)) {
			break;
		}
		_tmp2_ = sym;
		_tmp3_ = vala_symbol_get_parent_symbol (_tmp2_);
		_tmp4_ = _tmp3_;
		sym = _tmp4_;
	}
	_tmp5_ = sym;
	if (VALA_IS_METHOD (_tmp5_)) {
		ValaSymbol* _tmp6_;
		_tmp6_ = sym;
		result = _tmp6_;
		return result;
	} else {
		ValaSymbol* _tmp7_;
		_tmp7_ = sym;
		if (VALA_IS_PROPERTY_ACCESSOR (_tmp7_)) {
			ValaSymbol* _tmp8_;
			_tmp8_ = sym;
			result = _tmp8_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}


ValaDataType*
vala_semantic_analyzer_get_current_return_type (ValaSemanticAnalyzer* self)
{
	ValaDataType* result;
	ValaMethod* m = NULL;
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp2_;
	ValaMethod* _tmp3_;
	ValaPropertyAccessor* acc = NULL;
	ValaPropertyAccessor* _tmp7_;
	ValaPropertyAccessor* _tmp8_;
	ValaPropertyAccessor* _tmp9_;
	ValaPropertyAccessor* _tmp10_;
	gboolean _tmp18_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_semantic_analyzer_get_current_method (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	m = _tmp2_;
	_tmp3_ = m;
	if (_tmp3_ != NULL) {
		ValaMethod* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		_tmp4_ = m;
		_tmp5_ = vala_callable_get_return_type ((ValaCallable*) _tmp4_);
		_tmp6_ = _tmp5_;
		result = _tmp6_;
		_vala_code_node_unref0 (m);
		return result;
	}
	_tmp7_ = vala_semantic_analyzer_get_current_property_accessor (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (_tmp8_);
	acc = _tmp9_;
	_tmp10_ = acc;
	if (_tmp10_ != NULL) {
		ValaPropertyAccessor* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = acc;
		_tmp12_ = vala_property_accessor_get_readable (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			ValaPropertyAccessor* _tmp14_;
			ValaDataType* _tmp15_;
			ValaDataType* _tmp16_;
			_tmp14_ = acc;
			_tmp15_ = vala_property_accessor_get_value_type (_tmp14_);
			_tmp16_ = _tmp15_;
			result = _tmp16_;
			_vala_code_node_unref0 (acc);
			_vala_code_node_unref0 (m);
			return result;
		} else {
			ValaDataType* _tmp17_;
			_tmp17_ = self->void_type;
			result = _tmp17_;
			_vala_code_node_unref0 (acc);
			_vala_code_node_unref0 (m);
			return result;
		}
	}
	if (vala_semantic_analyzer_is_in_constructor (self)) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = vala_semantic_analyzer_is_in_destructor (self);
	}
	if (_tmp18_) {
		ValaDataType* _tmp19_;
		_tmp19_ = self->void_type;
		result = _tmp19_;
		_vala_code_node_unref0 (acc);
		_vala_code_node_unref0 (m);
		return result;
	}
	result = NULL;
	_vala_code_node_unref0 (acc);
	_vala_code_node_unref0 (m);
	return result;
}


static void
vala_semantic_analyzer_class_init (ValaSemanticAnalyzerClass * klass)
{
	vala_semantic_analyzer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_semantic_analyzer_finalize;
	g_type_class_add_private (klass, sizeof (ValaSemanticAnalyzerPrivate));
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_semantic_analyzer_real_visit_source_file;
}


static void
vala_semantic_analyzer_instance_init (ValaSemanticAnalyzer * self)
{
	ValaVoidType* _tmp0_;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	self->priv = VALA_SEMANTIC_ANALYZER_GET_PRIVATE (self);
	_tmp0_ = vala_void_type_new (NULL);
	self->void_type = (ValaDataType*) _tmp0_;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	self->replaced_nodes = (ValaList*) _tmp2_;
}


static void
vala_semantic_analyzer_finalize (ValaCodeVisitor * obj)
{
	ValaSemanticAnalyzer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer);
	_vala_code_context_unref0 (self->priv->context);
	_vala_code_node_unref0 (self->priv->_current_symbol);
	_vala_source_file_unref0 (self->priv->_current_source_file);
	_vala_code_node_unref0 (self->insert_block);
	_vala_code_node_unref0 (self->void_type);
	_vala_code_node_unref0 (self->bool_type);
	_vala_code_node_unref0 (self->string_type);
	_vala_code_node_unref0 (self->regex_type);
	_vala_code_node_unref0 (self->uchar_type);
	_vala_code_node_unref0 (self->short_type);
	_vala_code_node_unref0 (self->ushort_type);
	_vala_code_node_unref0 (self->int_type);
	_vala_code_node_unref0 (self->uint_type);
	_vala_code_node_unref0 (self->long_type);
	_vala_code_node_unref0 (self->ulong_type);
	_vala_code_node_unref0 (self->size_t_type);
	_vala_code_node_unref0 (self->ssize_t_type);
	_vala_code_node_unref0 (self->int8_type);
	_vala_code_node_unref0 (self->unichar_type);
	_vala_code_node_unref0 (self->double_type);
	_vala_code_node_unref0 (self->type_type);
	_vala_code_node_unref0 (self->va_list_type);
	_vala_code_node_unref0 (self->object_type);
	_vala_code_node_unref0 (self->gvalue_type);
	_vala_code_node_unref0 (self->gvariant_type);
	_vala_code_node_unref0 (self->glist_type);
	_vala_code_node_unref0 (self->gslist_type);
	_vala_code_node_unref0 (self->garray_type);
	_vala_code_node_unref0 (self->gvaluearray_type);
	_vala_code_node_unref0 (self->gerror_type);
	_vala_code_node_unref0 (self->list_type);
	_vala_code_node_unref0 (self->tuple_type);
	_vala_code_node_unref0 (self->gsource_type);
	_vala_iterable_unref0 (self->replaced_nodes);
	VALA_CODE_VISITOR_CLASS (vala_semantic_analyzer_parent_class)->finalize (obj);
}


/**
 * Code visitor analyzing and checking code.
 */
GType
vala_semantic_analyzer_get_type (void)
{
	static volatile gsize vala_semantic_analyzer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_semantic_analyzer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSemanticAnalyzerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_semantic_analyzer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSemanticAnalyzer), 0, (GInstanceInitFunc) vala_semantic_analyzer_instance_init, NULL };
		GType vala_semantic_analyzer_type_id;
		vala_semantic_analyzer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaSemanticAnalyzer", &g_define_type_info, 0);
		g_once_init_leave (&vala_semantic_analyzer_type_id__volatile, vala_semantic_analyzer_type_id);
	}
	return vala_semantic_analyzer_type_id__volatile;
}



