import numpy
import viper


coords2d = numpy.array([[0.0,0.0,0.0],
                        [1.0,0.0,0.0],
                        [0.0,1.0,0.0],
                        [1.0,1.0,0.0],
                        [2.0,0.0,0.0],
                        [0.0,2.0,0.0],
                        [2.0,1.0,0.0],
                        [1.0,2.0,0.0],
                        [2.0,2.0,0.0]])

triangles = numpy.array([[0,1,2],[1,2,3],[1,4,3],[4,3,6],[2,3,5],
                        [3,5,7],[3,6,7],[6,7,8]], dtype='i')

coords3d = numpy.array([[0,0,0],[1,0,0],
                        [0,1,0],[0,0,1]], dtype='d')

tets = numpy.array([[0,1,2,3]], dtype='i')
lines = numpy.array([[0,1],[2,4]], dtype='i')

def _meshplot():
    v = viper.Viper(coordinates=coords2d, cells=triangles)
    v.interactive()

def _lineplot():
    N = 30000
    cells = []
    coords = numpy.random.random((2*N, 3))
    for i in range(N):
        cells.append([2*i, 2*i+1])

    cells = numpy.array(cells, dtype='i')
    x = numpy.linspace(0,1, 2*N)
    v = viper.Viper(coordinates=coords, cells=cells)
    v.interactive()

def _scalarplot():
    x = numpy.linspace(0,1,len(coords2d))
    v = viper.Viper(x=x, coordinates=coords2d, cells=triangles, add_cell_labels=True, rescale=True)
    v.interactive()

def _scalarplot3d():
    x = numpy.linspace(0,1,len(coords3d))
    v = viper.Viper(x=x, coordinates=coords3d, cells=tets)
    v.interactive()
    v = viper.Viper(x=x, coordinates=coords3d, cells=tets, cutplane_origin=(.0,.0,.1), cutplane_normal=(1,0,1))
    stop = 400
    for i in xrange(stop):
        x += 1.0/stop
        v.update(x)
    for i in xrange(stop):
        x -= 1.0/stop
        v.update(x)
    v.interactive()

def _vectorplot():
    x = coords2d.copy()
    v = viper.Viper(x=x, coordinates=coords2d, cells=triangles)
    v.interactive()
    for i in xrange(100):
        x += 0.01
        v.update()
    for i in xrange(100):
        x -= 0.01
        v.update()
    v.interactive()

def _displacementplot():
    x = numpy.linspace(0,1,len(coords2d))
    displacement2d = 0.2*coords2d.copy()
    displacement2d[0,:-1] = -1
    v = viper.Viper(x=x,coordinates=coords2d, cells=triangles, displacement=displacement2d)
    v.interactive()
    inc = 0.005
    stop = 400
    for i in xrange(stop):
        displacement2d[0,:-1] -= inc
        v.update(displacement2d)
    for i in xrange(stop):
        displacement2d[0,:-1] += inc
        v.update(displacement2d)
    v.interactive()


if __name__ == "__main__":
    _lineplot()
    _meshplot()
    _scalarplot()
    _scalarplot3d()
    _vectorplot()
    _displacementplot()
