/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
/*!
 *\file Settings_window.hpp
 */

#ifndef SETTINGS_WINDOW_HPP
#define SETTINGS_WINDOW_HPP

/* For moc compilation */
#include <QWidget>
#include "ui_settings.h"

class Core;
class Color;

/*!
 * \class Settings_window
 * \brief Class used to display statistics of containers.
 *
 */

class Settings_window : public QWidget, protected Ui::settings {
    
    Q_OBJECT
    
private:

    Core *_c;
    /*!
     * \brief Load in the QListWidget the directory name from the Session
     */
    void plugin_load_dirs_name();

    /*!
     * \brief Fill the state table with the states and theirs colors depending on the palette set.
     */
    void fill_table(const std::string &palette_name);

    /*!
     * \brief Fill a new row to the state table.
     * row is incremented at the end of the function.
     */
    void add_state_line(int &row, std::string st_name, Color *c, bool checked = true);

    /*!
     * \brief Reload the general tab.
     */
    void reload_general_tab();

    /*!
     * \brief Reload the minimap tab.
     */
    void reload_minimap_tab();
public:
    /*!
     * Default constructor
     * \param parent The parent widget of the window.
     */
    Settings_window(Core *c, QWidget *parent = 0);

    ~Settings_window();

    /*!
     * \brief Overloaded to store at beginning the values
     * (to get them back if we cancel for example)
     */
    void show();
    
public slots:
    /*!
     * \fn on_tabWidget_currentChanged(int index)
     * \brief Called when the user changes the tab.
     * \param index : the index of the new tab.
     * Initialize the new tab if needed.
     */
    void on_tabWidget_currentChanged(int index);

private slots:

    /*!
     * \fn on_add_state_btn_clicked()
     * \brief (state tab) Called when the user click on the add state button.
     * Pop up a window asking for the name and the color of the new state.
     */
    void on_add_state_btn_clicked();
    
    /*!
     * \fn on_rm_state_btn_clicked()
     * \brief (state tab) Called when the user click on the remove state button.
     * Erase the current state.
     */
    void on_rm_state_btn_clicked();
    
    /*!
     * \fn on_palette_list_currentIndexChanged(const QString &text)
     * \brief (state tab) Called when the user changes the current palette.
     * \param text : the name of the palette.
     * Fill the states table with the state of the new palette.
     */
    void on_palette_list_currentIndexChanged(const QString &text);

    /*!
     * \fn on_add_palette_btn_clicked()
     * \brief (state tab) Called when the user click on the add palette button.
     * Pop up a window asking for the name of the new palette.
     */
    void on_add_palette_btn_clicked();

    /*!
     * \fn on_copy_palette_btn_clicked()
     * \brief (state tab) Called when the user click on the copy palette button.
     * Copy the palette and its colors/states to the new palette.
     */
    void on_copy_palette_btn_clicked();

    /*!
     * \fn on_rm_palette_btn_clicked()
     * \brief (state tab) Called when the user click on the remove palette button.
     * Erase the current palette.
     */
    void on_rm_palette_btn_clicked();

    /*!
     * \fn state_color_changed(const QColor &c)
     * \brief (state tab) Called when the user changes an object in the table.
     * \param c : the new color
     */
    void state_color_changed(const QColor &c);

    /*!
     * \fn on_rm_dir_btn_clicked()
     * \brief (plugin tab) Called when the user click on the remove directory button.
     * Remove the directory from the list where we look for the plugins.
     */
    void on_rm_dir_btn_clicked();

    /*!
     * \fn on_add_dir_btn_clicked()
     * \brief (plugin tab) Called when the user click on the add directory button.
     * Add the directory from the list where we look for the plugins.
     */
    void on_add_dir_btn_clicked();

    /*!
     * \fn on_apply_clicked()
     * \brief (Global) Called when the user click on the apply button.
     * Save the informations and emit the changes.
     */
    void on_apply_clicked();

    /*!
     * \fn on_cancel_clicked()
     * \brief (Global) Called when the user click on the cancel button.
     * Quit the window without saving changes.
     */
    void on_cancel_clicked();

signals:
    void settings_changed();
};

#endif // SETTINGS_WINDOW_HPP
